
-----------------------------------------------------------------------------
-- valid
-----------------------------------------------------------------------------
drop sequence valid_id_seq;
drop table valid;

CREATE TABLE valid
(
    id serial,
    name varchar (25) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket_priority
-----------------------------------------------------------------------------
drop sequence ticket_priority_id_seq;
drop table ticket_priority;

CREATE TABLE ticket_priority
(
    id serial,
    name varchar (25) NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket_lock_type
-----------------------------------------------------------------------------
drop sequence ticket_lock_type_id_seq;
drop table ticket_lock_type;

CREATE TABLE ticket_lock_type
(
    id serial,
    name varchar (25) NOT NULL,
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- system_user
-----------------------------------------------------------------------------
drop sequence system_user_id_seq;
drop table system_user;

CREATE TABLE system_user
(
    id serial,
    login varchar (80) NOT NULL,
    pw varchar (20) NOT NULL,
    salutation varchar (20),
    first_name varchar (40) NOT NULL,
    last_name varchar (40) NOT NULL,
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (login)
);

-----------------------------------------------------------------------------
-- user_preferences
-----------------------------------------------------------------------------
drop table user_preferences;

CREATE TABLE user_preferences
(
    user_id integer NOT NULL,
    preferences_key varchar (100) NOT NULL,
    preferences_value varchar (250)
);
create  INDEX index_user_id ON user_preferences (user_id);

-----------------------------------------------------------------------------
-- groups
-----------------------------------------------------------------------------
drop sequence groups_id_seq;
drop table groups;

CREATE TABLE groups
(
    id serial,
    name varchar (25) NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- group_user
-----------------------------------------------------------------------------
drop sequence group_user_id_seq;
drop table group_user;

CREATE TABLE group_user
(
    id serial,
    user_id integer NOT NULL,
    group_id integer NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- personal_queues
-----------------------------------------------------------------------------
drop sequence personal_queues_id_seq;
drop table personal_queues;

CREATE TABLE personal_queues
(
    id serial,
    user_id integer NOT NULL,
    queue_id integer NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- language
-----------------------------------------------------------------------------
drop sequence language_id_seq;
drop table language;

CREATE TABLE language
(
    id serial,
    language varchar (30) NOT NULL,
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (language)
);

-----------------------------------------------------------------------------
-- theme
-----------------------------------------------------------------------------
drop sequence theme_id_seq;
drop table theme;

CREATE TABLE theme
(
    id serial,
    theme varchar (30) NOT NULL,
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (theme)
);

-----------------------------------------------------------------------------
-- charset
-----------------------------------------------------------------------------
drop sequence charset_id_seq;
drop table charset;

CREATE TABLE charset
(
    id serial,
    name varchar (30) NOT NULL,
    charset varchar (30) NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket_state
-----------------------------------------------------------------------------
drop sequence ticket_state_id_seq;
drop table ticket_state;

CREATE TABLE ticket_state
(
    id serial,
    name varchar (30) NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- salutation
-----------------------------------------------------------------------------
drop sequence salutation_id_seq;
drop table salutation;

CREATE TABLE salutation
(
    id serial,
    name varchar (50) NOT NULL,
    text varchar NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- signature
-----------------------------------------------------------------------------
drop sequence signature_id_seq;
drop table signature;

CREATE TABLE signature
(
    id serial,
    name varchar (50) NOT NULL,
    text varchar NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- system_address
-----------------------------------------------------------------------------
drop sequence system_address_id_seq;
drop table system_address;

CREATE TABLE system_address
(
    id serial,
    value0 varchar (200) NOT NULL,
    value1 varchar (200) NOT NULL,
    value2 varchar (200), 
    value3 varchar (200),
    queue_id smallint NOT NULL,
    comment varchar (200),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- follow_up_possible
-----------------------------------------------------------------------------
drop sequence follow_up_possible_id_seq;
drop table follow_up_possible;

CREATE TABLE follow_up_possible
(
    id serial,
    name varchar (200) NOT NULL,
    comment varchar (200),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- queue
-----------------------------------------------------------------------------
drop sequence queue_id_seq;
drop table queue;

CREATE TABLE queue
(
    id serial,
    name varchar (200) NOT NULL,
    group_id smallint NOT NULL,
    unlock_timeout integer,
    escalation_time integer,
    system_address_id smallint NOT NULL,
    salutation_id smallint NOT NULL,
    signature_id smallint NOT NULL,
    follow_up_id smallint NOT NULL,
    follow_up_lock smallint NOT NULL,
    comment varchar (200),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- ticket
-----------------------------------------------------------------------------
drop sequence ticket_id_seq;
drop table ticket;

CREATE TABLE ticket
(
    id serial,
    tn varchar (50) NOT NULL,
    queue_id smallint NOT NULL,
    ticket_lock_id smallint NOT NULL,
    ticket_answered smallint NOT NULL,
    user_id smallint NOT NULL,
    group_id smallint NOT NULL,
    ticket_priority_id smallint NOT NULL,
    ticket_state_id smallint NOT NULL,
    group_read smallint,
    group_write smallint,
    other_read smallint,
    other_write smallint,
    customer_id varchar (150),
    timeout integer,
    until_time integer,
    freekey1 varchar (150),
    freetext1 varchar (150),
    freekey2 varchar (150),
    freetext2 varchar (150),
    valid_id smallint NOT NULL,
    create_time_unix integer NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (tn)
);
create  INDEX index_ticket_queue_view ON ticket (ticket_state_id, group_id, ticket_lock_id);
create  INDEX index_ticket_user ON ticket (user_id);
create  INDEX index_ticket_answered ON ticket (ticket_answered);

-----------------------------------------------------------------------------
-- ticket_history
-----------------------------------------------------------------------------
drop sequence ticket_history_id_seq;
drop table ticket_history;

CREATE TABLE ticket_history
(
    id serial,
    name varchar (200) NOT NULL,
    history_type_id smallint NOT NULL,
    ticket_id bigint NOT NULL,
    article_id bigint,
    system_queue_id smallint,
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);
create  INDEX ticket_history_ticket_id ON ticket_history (ticket_id);

-----------------------------------------------------------------------------
-- ticket_history_type
-----------------------------------------------------------------------------
drop sequence ticket_history_type_id_seq;
drop table ticket_history_type;

CREATE TABLE ticket_history_type
(
    id serial,
    name varchar (50) NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- article_type
-----------------------------------------------------------------------------
drop sequence article_type_id_seq;
drop table article_type;

CREATE TABLE article_type
(
    id serial,
    name varchar (50) NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- article_sender_type
-----------------------------------------------------------------------------
drop sequence article_sender_type_id_seq;
drop table article_sender_type;

CREATE TABLE article_sender_type
(
    id serial,
    name varchar (50) NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- article
-----------------------------------------------------------------------------
drop sequence article_id_seq;
drop table article;

CREATE TABLE article
(
    id serial8,
    ticket_id bigint NOT NULL,
    article_type_id smallint NOT NULL,
    article_sender_type_id smallint NOT NULL,
    a_from varchar,
    a_reply_to varchar (255),
    a_to varchar,
    a_cc varchar,
    a_subject varchar,
    a_message_id varchar (250),
    a_content_type varchar (100),
    a_body varchar NOT NULL,
    incoming_time integer NOT NULL,
    content_path varchar (250),
    a_freekey1 varchar (250),
    a_freetext1 varchar (250),
    a_freekey2 varchar (250),
    a_freetext2 varchar (250),
    a_freekey3 varchar (250),
    a_freetext3 varchar (250),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);
create INDEX article_ticket_id ON article (ticket_id);

-----------------------------------------------------------------------------
-- standard_response
-----------------------------------------------------------------------------
drop sequence standard_response_id_seq;
drop table standard_response;

CREATE TABLE standard_response
(
    id serial,
    name varchar (80) NOT NULL,
    text varchar NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- queue_standard_response
-----------------------------------------------------------------------------
drop sequence queue_standard_response_id_seq;
drop table queue_standard_response;

CREATE TABLE queue_standard_response
(
    id serial,
    queue_id integer NOT NULL,
    standard_response_id integer NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- auto_response_type
-----------------------------------------------------------------------------
drop sequence auto_response_type_id_seq;
drop table auto_response_type;

CREATE TABLE auto_response_type
(
    id serial,
    name varchar (50) NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- auto_response
-----------------------------------------------------------------------------
drop sequence auto_response_id_seq;
drop table auto_response;

CREATE TABLE auto_response
(
    id serial,
    name varchar (80) NOT NULL,
    text0 varchar,
    text1 varchar,
    text2 varchar,
    type_id smallint NOT NULL,
    system_address_id smallint NOT NULL,
    charset_id smallint NOT NULL,
    comment varchar (100),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- queue_auto_response
-----------------------------------------------------------------------------
drop sequence queue_auto_response_id_seq;
drop table queue_auto_response;

CREATE TABLE queue_auto_response
(
    id serial,
    queue_id integer NOT NULL,
    auto_response_id integer NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);

-----------------------------------------------------------------------------
-- time_accounting
-----------------------------------------------------------------------------
drop sequence time_accounting_id_seq;
drop table time_accounting;

CREATE TABLE time_accounting
(
    id serial8,
    ticket_id bigint NOT NULL,
    article_id bigint,
    time_unit smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id)
);
create  INDEX time_accounting_ticket_id ON time_accounting (ticket_id);

-----------------------------------------------------------------------------
-- faq
-----------------------------------------------------------------------------
drop sequence faq_id_seq;
drop table faq;

CREATE TABLE faq
(
    id serial,
    name varchar (200) NOT NULL,
    text varchar (255) NOT NULL,
    language_id smallint NOT NULL,
    comment varchar (80),
    valid_id smallint NOT NULL,
    create_time timestamp(0) NOT NULL,
    create_by integer NOT NULL,
    change_time timestamp(0) NOT NULL,
    change_by integer NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (name)
);

-----------------------------------------------------------------------------
-- session
-----------------------------------------------------------------------------
drop sequence session_id_seq;
drop table session;

CREATE TABLE session
(
    id serial,
    session_id varchar (120) NOT NULL,
    value varchar NOT NULL,
    PRIMARY KEY(id),
    UNIQUE (session_id)
);
create  INDEX index_session_id ON session (session_id);

-----------------------------------------------------------------------------
-- ticket_index
-----------------------------------------------------------------------------
drop table ticket_index;

CREATE TABLE ticket_index
(
    ticket_id bigint NOT NULL,
    queue_id integer NOT NULL,
    queue varchar (70) NOT NULL,
    group_id integer NOT NULL,
    s_lock varchar (70) NOT NULL,
    s_state varchar (70) NOT NULL,
    create_time_unix bigint NOT NULL
);

----------------------------------------------------------------------------
-- session
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- valid
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- ticket_priority
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- ticket_lock_type
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- system_user
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- user_preferences
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- groups
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- group_user
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- personal_queues
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- language
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- theme
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- charset
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- ticket_state
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- salutation
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- signature
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- system_address
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- follow_up_possible
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- queue
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- ticket
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- ticket_history
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- ticket_history_type
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- article_type
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- article_sender_type
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- article
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- standard_response
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- queue_standard_response
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- auto_response_type
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- auto_response
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- queue_auto_response
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- faq
----------------------------------------------------------------------------

