# -- 
# Kernel/Language/nb_SW.pm - Swedish language translation
# Copyright (C) 2004 Mats Eric Olausson <mats@synergy.se>
# --
# $Id: nb_SW.pm,v 1.2 2004/06/15 09:16:34 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::nb_SW.pm;

use strict;

use vars qw($VERSION);
$VERSION = q$Revision: 1.2 $;
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Fri May 21 19:28:37 2004 by Mats Eric Olausson

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D/%M %Y %T';
    $Self->{DateFormatShort} = '%D/%M %Y';
    $Self->{DateFormatLong} = '%A %D. %B %Y %T';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 minuter',
      ' 5 minutes' => ' 5 minuter',
      ' 7 minutes' => ' 7 minuter',
      '(Click here to add)' => '(Klicka hr fr att lgga till)',
      '10 minutes' => '10 minuter',
      '15 minutes' => '15 minuter',
      'AddLink' => 'Lgg till lnk',
      'Admin-Area' => 'Admin-omrde',
      'agent' => 'agent',
      'Agent-Area' => 'Agent-omrde',
      'all' => 'alla',
      'All' => 'Alla',
      'Attention' => 'OBS',
      'before' => 'fre',
      'Bug Report' => 'Rapportera fel',
      'Cancel' => 'Avbryt',
      'change' => 'ndra',
      'Change' => 'ndra',
      'change!' => 'ndra!',
      'click here' => 'klicka hr',
      'Comment' => 'Kommentar',
      'Customer' => 'Kund',
      'customer' => 'kund',
      'Customer Info' => 'Kundinfo',
      'day' => 'dag',
      'day(s)' => 'dag(ar)',
      'days' => 'dagar',
      'description' => 'beskrivning',
      'Description' => 'Beskrivning',
      'Dispatching by email To: field.' => 'Skickar ivg enligt epostmeddelandets Till:-flt.',
      'Don\'t show closed Tickets' => 'Visa inte lsta tickets',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Det r inte rekommenderat att arbeta som userid 1 (systemkonto)! Skapa nya anvndare!',
      'Done' => 'Klar',
      'end' => 'slut',
      'Error' => 'Fel',
      'Example' => 'Exempel',
      'Examples' => 'Exempel',
      'Facility' => 'Innrttning',
      'FAQ-Area' => 'FAQ-omrde',
      'Feature not active!' => 'Funktion inte aktiverad!',
      'go' => 'Starta',
      'go!' => 'Starta!',
      'Group' => 'Grupp',
      'Hit' => 'Trff',
      'Hits' => 'Trffar',
      'hour' => 'timme',
      'hours' => 'timmar',
      'Ignore' => 'Ignorera',
      'invalid' => 'ogiltig',
      'Invalid SessionID!' => 'Ogiltigt SessionID!',
      'Language' => 'Sprk',
      'Languages' => 'Sprk',
      'last' => 'sista',
      'Line' => 'Rad',
      'Lite' => 'Enkel',
      'Login failed! Your username or password was entered incorrectly.' => 'Inloggningen misslyckades! Angivet anvndarnamn och/eller lsenord r inte korrekt.',
      'Logout successful. Thank you for using OTRS!' => 'Utloggningen lyckades.  Tack fr att du anvnde OTRS!',
      'Message' => 'Meddelande',
      'minute' => 'minut',
      'minutes' => 'minuter',
      'Module' => 'Modul',
      'Modulefile' => 'Modulfil',
      'month(s)' => 'mnad(er)',
      'Name' => 'Namn',
      'New Article' => 'Ny artikel',
      'New message' => 'Nytt meddelande',
      'New message!' => 'Nytt meddelande!',
      'No' => 'Nej',
      'no' => 'inga',
      'No entry found!' => 'Ingen inmatning funnen!',
      'No suggestions' => 'Inga frslag',
      'none' => 'inga',
      'none - answered' => 'inga - besvarat',
      'none!' => 'inga!',
      'Normal' => 'Normal',
      'Off' => 'Av',
      'off' => 'av',
      'On' => 'P',
      'on' => 'p',
      'Password' => 'Lsenord',
      'Pending till' => 'Vntande tills',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Vnligen besvara denna/dessa tickets fr att komma tillbaka till den normala k-visningsbilden!',
      'Please contact your admin' => 'Vnligen kontakta administratren',
      'please do not edit!' => 'Var vnlig och ndra inte detta!',
      'Please go away!' => 'Systemet anser att du inte r auktoriserad att utfra tgrden du forsker gra.  Ta kontakt med administratren om du anser att detta inte stmmer.',
      'possible' => 'mjlig',
      'Preview' => 'Forhandsvisning',
      'QueueView' => 'Ker',
      'reject' => 'Avvisas',
      'replace with' => 'Erstt med',
      'Reset' => 'Nollstll',
      'Salutation' => 'Hlsning',
      'Session has timed out. Please log in again.' => 'Sessionstiden har lpt ut.  Vnligen logga p igen.',
      'Show closed Tickets' => 'Visa lsta tickets',
      'Signature' => 'Signatur',
      'Sorry' => 'Beklagar',
      'Stats' => 'Statistik',
      'Subfunction' => 'Underfunktion',
      'submit' => 'Skicka',
      'submit!' => 'Skicka!',
      'system' => 'System',
      'Take this User' => 'Vlj denna anvndare',
      'Text' => 'Text',
      'The recommended charset for your language is %s!' => 'Den rekommenderade teckenuppsttningen fr ditt sprk r %s!',
      'Theme' => 'Tema',
      'There is no account with that login name.' => 'Det finns inget konto med detta namn.',
      'Timeover' => 'Tidsvertrdelse',
      'To: (%s) replaced with database email!' => 'Till: (%s) ersatt med epost frn databas!',
      'top' => 'topp',
      'update' => 'uppdatera',
      'Update' => 'Uppdatera',
      'update!' => 'Uppdatera!',
      'User' => 'Anvndare',
      'Username' => 'Anvndarnamn',
      'Valid' => 'Giltigt',
      'Warning' => 'Varning',
      'week(s)' => 'vecka(or)',
      'Welcome to OTRS' => 'Vlkommen till OTRS',
      'Word' => 'Ord',
      'wrote' => 'skrev',
      'year(s)' => 'r',
      'yes' => 'ja',
      'Yes' => 'Ja',
      'You got new message!' => 'Du har ftt ett nytt meddelande!',
      'You have %s new message(s)!' => 'Du har %s nya meddelanden!',
      'You have %s reminder ticket(s)!' => 'Du har %s pminnelse-tickets!',

    # Template: AAAMonth
      'Apr' => 'apr',
      'Aug' => 'aug',
      'Dec' => 'dec',
      'Feb' => 'feb',
      'Jan' => 'jan',
      'Jul' => 'jul',
      'Jun' => 'jun',
      'Mar' => 'mar',
      'May' => 'maj',
      'Nov' => 'nov',
      'Oct' => 'okt',
      'Sep' => 'sep',

    # Template: AAAPreferences
      'Closed Tickets' => 'Lsta tickets',
      'CreateTicket' => 'Skapa Ticket',
      'Custom Queue' => 'Utvald k',
      'Follow up notification' => 'Meddelande om uppfljning',
      'Frontend' => 'Grnssnitt',
      'Mail Management' => 'Eposthantering',
      'Max. shown Tickets a page in Overview.' => 'Max. visade tickets per sida i versikt.',
      'Max. shown Tickets a page in QueueView.' => 'Max. visade tickets per side i K-bild.',
      'Move notification' => 'Meddelande om ndring av k',
      'New ticket notification' => 'Meddelande om nyskapad ticket',
      'Other Options' => 'Andra tillval',
      'PhoneView' => 'Tel.samtal',
      'Preferences updated successfully!' => 'Instllningar lagrade!',
      'QueueView refresh time' => 'Automatisk uppdateringsintervall f K-bild',
      'Screen after new ticket' => 'Skrm efter inmatning av ny ticket',
      'Select your default spelling dictionary.' => 'Vlj standard ordbok for stavningskontroll.',
      'Select your frontend Charset.' => 'Vlj teckenuppsttning.',
      'Select your frontend language.' => 'Vlj sprk.',
      'Select your frontend QueueView.' => 'Vlj K-bild.',
      'Select your frontend Theme.' => 'Vlj stil-tema.',
      'Select your QueueView refresh time.' => 'Vlj automatisk uppdateringsintervall fr K-bild.',
      'Select your screen after creating a new ticket.' => 'Vlj skrmbild som visas efter registrering av ny hnvisning/ticket.',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Skicka mig ett meddelande om kundkorrespondens fr tickets som jag str som gare till.',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Skicka mig ett meddelande ifall en ticket flyttas ver till en av mina utvalda ker.',
      'Send me a notification if a ticket is unlocked by the system.' => 'Skicka mig ett meddelande ifall systemet tar bort lset p en ticket.',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Skicka mig ett meddelande ifall det kommer ett nytt meddelande till mina utvalda ker.',
      'Show closed tickets.' => 'Visa lsta tickets.',
      'Spelling Dictionary' => 'Stavningslexikon',
      'Ticket lock timeout notification' => 'Meddelan mig d tiden gtt ut fr ett ticket-ls',
      'TicketZoom' => 'Ticket Zoom',

    # Template: AAATicket
      '1 very low' => '1 Planeras',
      '2 low' => '2 lg',
      '3 normal' => '3 medium',
      '4 high' => '4 hg',
      '5 very high' => '5 kritisk',
      'Action' => 'tgrd',
      'Age' => 'lder',
      'Article' => 'Artikel',
      'Attachment' => 'Bifogat dokument',
      'Attachments' => 'Bifogade dokument',
      'Bcc' => 'Bcc',
      'Bounce' => 'Studsa',
      'Cc' => 'Cc',
      'Close' => 'Stng',
      'closed successful' => 'Lst och stngt',
      'closed unsuccessful' => 'Olst men stngt',
      'Compose' => 'Frfatta',
      'Created' => 'Skapat',
      'Createtime' => 'Tidpunkt fr skapande',
      'email' => 'email',
      'eMail' => 'eMail',
      'email-external' => 'email externt',
      'email-internal' => 'email internt',
      'Forward' => 'Vidarebefordra',
      'From' => 'Frn',
      'high' => 'hg',
      'History' => 'Historik',
      'If it is not displayed correctly,' => 'Ifall det inte visas korrekt,',
      'lock' => 'lst',
      'Lock' => 'Ls',
      'low' => 'lg',
      'Move' => 'Flytta',
      'new' => 'ny',
      'normal' => 'normal',
      'note-external' => 'notis externt',
      'note-internal' => 'notis internt',
      'note-report' => 'notis till rapport',
      'open' => 'ppen',
      'Owner' => 'gare',
      'Pending' => 'Vntande',
      'pending auto close+' => 'vntar p att stngas (lst)',
      'pending auto close-' => 'vntar p att stngas (olst)',
      'pending reminder' => 'vntar p pminnelse',
      'phone' => 'telefon',
      'plain' => 'r',
      'Priority' => 'Prioritet',
      'Queue' => 'K',
      'removed' => 'borttagen',
      'Sender' => 'Avsndare',
      'sms' => 'sms',
      'State' => 'Status',
      'Subject' => 'mne',
      'This is a' => 'Detta r en',
      'This is a HTML email. Click here to show it.' => 'Detta r ett HTML-email. Klicka hr fr att visa.',
      'This message was written in a character set other than your own.' => 'Detta meddelande r skrivet med en annan teckenuppsttning n den du anvnder.',
      'Ticket' => 'Ticket',
      'Ticket "%s" created!' => 'Ticket "%s" skapad!',
      'To' => 'Till',
      'to open it in a new window.' => 'fr att ppna i ett nytt fnster',
      'unlock' => 'ls upp',
      'Unlock' => 'Ls upp',
      'very high' => 'kritisk',
      'very low' => 'planeras',
      'View' => 'Bild',
      'webrequest' => 'web-anmodan',
      'Zoom' => 'Zoom',

    # Template: AAAWeekDay
      'Fri' => 'fre',
      'Mon' => 'mn',
      'Sat' => 'lr',
      'Sun' => 'sn',
      'Thu' => 'tor',
      'Tue' => 'tis',
      'Wed' => 'ons',

    # Template: AdminAttachmentForm
      'Add' => 'Lgg till',
      'Attachment Management' => 'Hantering av bifogade dokument',

    # Template: AdminAutoResponseForm
      'Add auto response' => 'Lgg till autosvar',
      'Auto Response From' => 'autosvar-avsndare',
      'Auto Response Management' => 'Autosvar-hantering',
      'Change auto response settings' => 'ndra autosvar-instllningar',
      'Note' => 'Notis',
      'Response' => 'Svar',
      'to get the first 20 character of the subject' => 'fr att f fram de frste 20 tecknen i mnesbeskrivningen',
      'to get the first 5 lines of the email' => 'fr att f fram de frsta 5 raderna av emailen',
      'to get the from line of the email' => 'fr att f fram avsndarraden i emailen',
      'to get the realname of the sender (if given)' => 'fr att f fram avsndarens fulla namn (om mjligt)',
      'to get the ticket id of the ticket' => 'fr att f fram intern ticket-id',
      'to get the ticket number of the ticket' => 'fr att f fram ticket-nummer',
      'Type' => 'Typ',
      'Useable options' => 'Anvndbara tillgg',

    # Template: AdminCustomerUserForm
      'Customer User Management' => 'Kundanvndare',
      'Customer user will be needed to to login via customer panels.' => 'Kundanvndare mste logga in via kundsidorna.',
      'Select source:' => 'Vlj klla',
      'Source' => 'Klla',

    # Template: AdminCustomerUserGeneric

    # Template: AdminCustomerUserGroupChangeForm
      'Change %s settings' => 'ndra %s-instllningar',
      'Customer User <-> Group Management' => 'Kundanvndare <-> gruppr',
      'Full read and write access to the tickets in this group/queue.' => 'Fulla ls- och skrivrttigheter till tickets i denna grupp/k.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Om ingenting r valt finns inga rttigheter i denna grupp (tickets i denna grupp kommer inte att finnas tillgngliga fr anvndaren).',
      'Permission' => 'Rttighet',
      'Read only access to the ticket in this group/queue.' => 'Endast lsrttighet till tickets i denna grupp/k.',
      'ro' => 'ro',
      'rw' => 'rw',
      'Select the user:group permissions.' => 'Vlj anvndar:grupp-rettigheter.',

    # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'ndra anvndar- <-> grupp-instllningar',

    # Template: AdminCustomerUserPreferencesGeneric

    # Template: AdminEmail
      'Admin-Email' => 'Admin-email',
      'Body' => 'Meddelandetext',
      'OTRS-Admin Info!' => 'OTRS-Admin Info!',
      'Recipents' => 'Mottagare',
      'send' => 'Skicka',

    # Template: AdminEmailSent
      'Message sent to' => 'Meddelande skicakt till',

    # Template: AdminGroupForm
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Skapa nya gruppr fr att kunna handtera olika rttigheter fr skilda gruppr av agenter (t.ex. inkpsavdelning, supportavdelning, frsljningsavdelning, ...).',
      'Group Management' => 'gruppr',
      'It\'s useful for ASP solutions.' => 'Nyttigt fr ASP-lsningar.',
      'The admin group is to get in the admin area and the stats group to get stats area.' => '\'admin\'-gruppen ger tillgng till Admin-arean, \'stats\'-gruppen till Statistik-arean.',

    # Template: AdminLog
      'System Log' => 'Systemlogg',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Admin-email',
      'Attachment <-> Response' => 'Bifogat dokument <-> Svar',
      'Auto Response <-> Queue' => 'Autosvar <-> K',
      'Auto Responses' => 'Autosvar',
      'Customer User' => 'Kundanvndare',
      'Customer User <-> Groups' => 'Kundanvndare <-> gruppr',
      'Email Addresses' => 'Emailadresser',
      'Groups' => 'gruppr',
      'Logout' => 'Logga ut',
      'Misc' => 'Div',
      'Notifications' => 'Meddelanden',
      'PostMaster Filter' => '',
      'PostMaster POP3 Account' => 'Postmaster POP3-konto',
      'Responses' => 'Svar',
      'Responses <-> Queue' => 'Svar <-> K',
      'Select Box' => 'SQL-access',
      'Session Management' => 'Sessionshantering',
      'Status' => '',
      'System' => '',
      'User <-> Groups' => 'Anvndare <-> gruppr',

    # Template: AdminNotificationForm
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Konfigurationsval (t.ex. &lt;OTRS_CONFIG_HttpType&gt;)',
      'Notification Management' => 'Meddelandehantering',
      'Notifications are sent to an agent or a customer.' => 'Meddelanden skickats till agenter eller kunder.',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'ger tillgng till data fr gllande kund (t.ex. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'ger tillgng till data fr agenten som utfr handlingen (t.ex. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'ger tillgang till data fr agenten som str som gare till ticketen (t.ex. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',

    # Template: AdminPOP3Form
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Inkommande email frn POP3-konton sorteras till vald k!',
      'Dispatching' => 'Frdelning',
      'Host' => 'Host',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Ifall detta r ett betrott konto anvnds X-OTRS Header!',
      'Login' => '',
      'POP3 Account Management' => 'Administration av POP3-Konto',
      'Trusted' => 'Betrodd',

    # Template: AdminPostMasterFilterForm
      'Match' => 'Trff',
      'PostMasterFilter Management' => '',
      'Set' => 'Set',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Hantering av K <-> Autosvar',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = ingen upptrappning',
      '0 = no unlock' => '0 = ingen upplsning',
      'Customer Move Notify' => 'Meddelande om flytt av kund',
      'Customer Owner Notify' => 'Meddelande om byte av gare av Kund',
      'Customer State Notify' => 'Meddelande om statusndring fr Kund',
      'Escalation time' => 'Upptrappningstid',
      'Follow up Option' => 'Korrespondens p lst ticket',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ifall en kund skickar uppfljningsmail p en lst ticket, blir ticketen lst till frra garen.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Ifall en ticket inte blir besvarad inom denna tid, visas enbart denna ticket.',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ifall en ticket som r lst av en agent men nd inte blir besvarad inom denna tid, kommer lset automatiskt att tas bort.',
      'Key' => 'Nyckel',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS skickar ett meddelande till kunden ifall ticketen flyttas.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS skickar ett meddelande till kunden vid garbyte.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS skickar ett meddelande till kunden vid statusuppdatering.',
      'Queue Management' => 'Khantering',
      'Sub-Queue of' => 'Underk till',
      'Systemaddress' => 'Systemadress',
      'The salutation for email answers.' => 'Hlsningsfras fr email-svar.',
      'The signature for email answers.' => 'Signatur fr email-svar.',
      'Ticket lock after a follow up' => 'Ticket lses efter uppfljningsmail',
      'Unlock timeout' => 'Tidsintervall fr borttagning av ls',
      'Will be the sender address of this queue for email answers.' => 'Avsndaradress fr email i denna K.',

    # Template: AdminQueueResponsesChangeForm
      'Std. Responses <-> Queue Management' => 'Hantering av standardsvar <-> Khantering',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Svar',
      'Change answer <-> queue settings' => 'ndra var <-> Kinstllningar',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Hantering av standardsvar <-> Bifogade dokument',

    # Template: AdminResponseAttachmentForm
      'Change Response <-> Attachment settings' => 'ndra Svar <-> Instllningar fr bifogade dokument',

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Ett svar er en standardtext fr att underltta besvarandet av vanliga kundfrgor.',
      'Don\'t forget to add a new response a queue!' => 'Kom ihg att lgga till ett nytt svar till en k!',
      'Next state' => 'Nsta tillstnd',
      'Response Management' => 'Hantera svar',
      'The current ticket state is' => 'Nuvarande ticket-status',

    # Template: AdminSalutationForm
      'customer realname' => 'Fullt kundnamn',
      'for agent firstname' => 'fr agents frnamn',
      'for agent lastname' => 'fr agents efternamn',
      'for agent login' => 'fr agents login',
      'for agent user id' => 'fr agents anvndar-id',
      'Salutation Management' => 'Hantering av Hlsningsfraser',

    # Template: AdminSelectBoxForm
      'Max Rows' => 'Max rader',

    # Template: AdminSelectBoxResult
      'Limit' => '',
      'Select Box Result' => 'Select Box Resultat',
      'SQL' => '',

    # Template: AdminSession
      'Agent' => '',
      'kill all sessions' => 'Terminera alla sessioner',
      'Overview' => 'versikt',
      'Sessions' => 'Sessioner',
      'Uniq' => '',

    # Template: AdminSessionTable
      'kill session' => 'Terminera session',
      'SessionID' => '',

    # Template: AdminSignatureForm
      'Signature Management' => 'Signaturhantering',

    # Template: AdminStateForm
      'See also' => 'Se ocks',
      'State Type' => 'Statustyp',
      'System State Management' => 'Hantering av systemstatus',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Se till att du ocks uppdaterade standardutgngslgena i Kernel/Config.pm!',

    # Template: AdminSystemAddressForm
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Alla inkommande mail till denna adressat (To:) delas ut till vald k.',
      'Email' => 'Email',
      'Realname' => 'Fullstndigt namn',
      'System Email Addresses Management' => 'Hantera System-emailadresser',

    # Template: AdminUserForm
      'Don\'t forget to add a new user to groups!' => 'Glm inte att lgga in en ny anvndare i en grupp!',
      'Firstname' => 'Frnamn',
      'Lastname' => 'Efternamn',
      'User Management' => 'Anvndarhantering',
      'User will be needed to handle tickets.' => 'Anvndare krvs fr att hantera tickets.',

    # Template: AdminUserGroupChangeForm
      'create' => 'Skapa',
      'move_into' => 'Flytta till',
      'owner' => 'gare',
      'Permissions to change the ticket owner in this group/queue.' => 'Rtt att ndra ticket-gare i denna grupp/K.',
      'Permissions to change the ticket priority in this group/queue.' => 'Rtt att ndra prioritet i denna grupp/K.',
      'Permissions to create tickets in this group/queue.' => 'Rtt att skapa tickets i denna grupp/K.',
      'Permissions to move tickets into this group/queue.' => 'Rtt att flytta tickets i denna grupp/K.',
      'priority' => 'prioritet',
      'User <-> Group Management' => 'Hantera anvndare <-> grupp',

    # Template: AdminUserGroupForm

    # Template: AdminUserPreferencesGeneric

    # Template: AgentBook
      'Address Book' => 'Adressbok',
      'Discard all changes and return to the compose screen' => 'Bortse frn ndringarna och stng fnstret',
      'Return to the compose screen' => 'Stng fnstret',
      'Search' => 'Sk',
      'The message being composed has been closed.  Exiting.' => 'Det tilhrande redigeringsfnstret har stngts. Avslutar.',
      'This window must be called from compose window' => 'Denne funktion mste startas frn redigeringsfnstret',

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Ett meddelande mste ha en mottagare i Till:-fltet!',
      'Bounce ticket' => 'Skicka ver ticket',
      'Bounce to' => 'Skicka ver till',
      'Inform sender' => 'Informera avsndare',
      'Next ticket state' => 'Nsta ticketstatus',
      'Send mail!' => 'Skicka mail!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'I Till-fltet mste anges en giltig emailadress (t.ex. kund@exempeldomain.se)!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Emailen med ticketnummer "<OTRS_TICKET>" har skickats ver till "<OTRS_BOUNCE_TO>". Vnligen kontakta denna adress fr vidare hnvisningar.',

    # Template: AgentClose
      ' (work units)' => ' (arbetsenheter)',
      'A message should have a body!' => 'Ett meddelande mste innehlla en meddelandetext!',
      'A message should have a subject!' => 'Ett meddelande mste ha en mnesrad!',
      'Close ticket' => 'Stng ticket',
      'Close type' => 'Stngningstillstnd',
      'Close!' => 'Stng!',
      'Note Text' => 'Anteckingstext',
      'Note type' => 'Anteckningstyp',
      'Options' => 'Tillval',
      'Spell Check' => 'Stavningskontroll',
      'Time units' => 'Tidsenheter',
      'You need to account time!' => 'Du mste redovisa tiden!',

    # Template: AgentCompose
      'A message must be spell checked!' => 'Stavningskontroll mste utfras p alla meddelanden!',
      'Attach' => 'Bifoga',
      'Compose answer for ticket' => 'Frfatta svar till ticket',
      'for pending* states' => 'fr vntetillstnd',
      'Is the ticket answered' => 'r ticketen besvarad',
      'Pending Date' => 'Vntar till',

    # Template: AgentCustomer
      'Back' => 'Tilbaka',
      'Change customer of ticket' => 'ndra kund fr ticket',
      'CustomerID' => 'Organisations-ID',
      'Search Customer' => 'Sk kund',
      'Set customer user and customer id of a ticket' => 'Markera kundanvndare och organisations-id fr ticket',

    # Template: AgentCustomerHistory
      'All customer tickets.' => 'Alla tickets fr kund.',
      'Customer history' => 'Kundehistorik',

    # Template: AgentCustomerMessage
      'Follow up' => 'Uppfljning',

    # Template: AgentCustomerView
      'Customer Data' => 'Kunddata',

    # Template: AgentEmailNew
      'All Agents' => 'Alla agenter',
      'Clear From' => 'Nolstll Frn:',
      'Compose Email' => 'Skriv email',
      'Lock Ticket' => 'Ls ticket',
      'new ticket' => 'Ny ticket',

    # Template: AgentForward
      'Article type' => 'Artikeltyp',
      'Date' => 'Dato',
      'End forwarded message' => 'Avsluta vidarebefordrat meddelande',
      'Forward article of ticket' => 'Vidarebefordrad artikel frn ticket',
      'Forwarded message from' => 'Vidarebefordrat meddelande frn',
      'Reply-To' => '',

    # Template: AgentFreeText
      'Change free text of ticket' => 'ndra friatextflt i ticket',
      'Value' => 'Innehll',

    # Template: AgentHistoryForm
      'History of' => 'Historik fr',

    # Template: AgentMailboxNavBar
      'All messages' => 'Alla meddelanden',
      'down' => 'sjunkande',
      'Mailbox' => 'Mailbox',
      'New' => 'Nytt',
      'New messages' => 'Nya meddelanden',
      'Open' => 'ppna',
      'Open messages' => 'ppna meddelanden',
      'Order' => 'Sortering',
      'Pending messages' => 'Vntande meddelanden',
      'Reminder' => 'Pminnelse',
      'Reminder messages' => 'Pminnelsemeddelanden',
      'Sort by' => 'Sortera efter',
      'Tickets' => 'Tickets',
      'up' => 'stigande',

    # Template: AgentMailboxTicket
      '"}' => '',
      '"}","14' => '',

    # Template: AgentMove
      'Move Ticket' => 'Flytta ticket',
      'New Owner' => 'Ny gare',
      'New Queue' => 'Ny K',
      'Previous Owner' => 'Tidigare gare',
      'Queue ID' => 'K-id',

    # Template: AgentNavigationBar
      'Locked tickets' => 'Lsta tickets',
      'new message' => 'Nytt meddelande',
      'Preferences' => 'Instllningar',
      'Utilities' => 'Verktyg',

    # Template: AgentNote
      'Add note to ticket' => 'Lgg till anteckning till ticket',
      'Note!' => 'Observera!',

    # Template: AgentOwner
      'Change owner of ticket' => 'ndra gare av ticket',
      'Message for new Owner' => 'Meddelande till ny gare',

    # Template: AgentPending
      'Pending date' => 'Vntande datum',
      'Pending type' => 'Vntande typ',
      'Pending!' => 'Vntar!',
      'Set Pending' => 'Markera som vntande',

    # Template: AgentPhone
      'Customer called' => 'Kundeuppringning',
      'Phone call' => 'Telefonsamtal',
      'Phone call at %s' => 'Telefonsamtal %s',

    # Template: AgentPhoneNew

    # Template: AgentPlain
      'ArticleID' => '',
      'Plain' => 'Enkel',
      'TicketID' => '',

    # Template: AgentPreferencesCustomQueue
      'Select your custom queues' => 'Vlj dina egna Ker ("PersonalQueue")',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'ndra lsenord',
      'New password' => 'Nytt lsenord',
      'New password again' => 'Nytt lsenord igen',

    # Template: AgentPriority
      'Change priority of ticket' => 'ndra prioritet fr ticket',

    # Template: AgentSpelling
      'Apply these changes' => 'Verkstll ndringar',
      'Spell Checker' => 'Stavningskontroll',
      'spelling error(s)' => 'Stavfel',

    # Template: AgentStatusView
      'D' => 'N',
      'of' => 'av',
      'Site' => 'plats',
      'sort downward' => 'Sortera sjunkande',
      'sort upward' => 'Sortera stigande',
      'Ticket Status' => 'Ticketstatus',
      'U' => 'U',

    # Template: AgentStatusViewTable

    # Template: AgentStatusViewTableNotAnswerd

    # Template: AgentTicketLink
      'Link' => 'Lnk',
      'Link to' => 'Lnk till',

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Ticket lst',
      'Ticket unlock!' => 'Ticket upplst',

    # Template: AgentTicketPrint
      'by' => 'av',

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'Redovisad tid',
      'Escalation in' => 'Upptrappning om',

    # Template: AgentUtilSearch
      '(e. g. 10*5155 or 105658*)' => 't.ex. 10*5144 eller 105658*',
      '(e. g. 234321)' => 't.ex. 234321',
      '(e. g. U5150)' => 't.ex. U5150',
      'and' => 'og',
      'Customer User Login' => 'kundanvndare loginnamn',
      'Delete' => 'Radera',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fritextsk i artiklar (t.ex. "Mar*in" eller "Baue*")',
      'No time settings.' => 'Inga tidsinstllningar.',
      'Profile' => 'Profil',
      'Result Form' => 'Resultatbild',
      'Save Search-Profile as Template?' => 'Spara skkriterier som mall?',
      'Search-Template' => 'Skmall',
      'Select' => 'Vlj',
      'Ticket created' => 'Ticket skapad',
      'Ticket created between' => 'Ticket skapat mellan',
      'Ticket Search' => 'Ticket-sk',
      'TicketFreeText' => '',
      'Times' => 'Tider',
      'Yes, save it with name' => 'Ja, spara med namn',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'Kundhistorik',
      'Customer history search (e. g. "ID342425").' => 'Sk efter kundhistorik (t.ex. "ID342425").',
      'No * possible!' => 'Wildcards * inte tilltna!',

    # Template: AgentUtilSearchNavBar
      'Change search options' => 'ndra skinstllningar',
      'Results' => 'Resultat',
      'Search Result' => 'Skeresultat',
      'Total hits' => 'Totalt hittade',

    # Template: AgentUtilSearchResult
      '"}","15' => '',

    # Template: AgentUtilSearchResultPrint

    # Template: AgentUtilSearchResultPrintTable
      '"}","30' => '',

    # Template: AgentUtilSearchResultShort

    # Template: AgentUtilSearchResultShortTable

    # Template: AgentUtilSearchResultShortTableNotAnswered

    # Template: AgentUtilTicketStatus
      'All closed tickets' => 'Alla lsta tickets',
      'All open tickets' => 'Alla ppna tickets',
      'closed tickets' => 'lsta tickets',
      'open tickets' => 'ppna tickets',
      'or' => 'eller',
      'Provides an overview of all' => 'Gir en oversikt over alle',
      'So you see what is going on in your system.' => 'S att du kan se vad som sker i ditt system.',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => 'Skriv uppfljningssvar',
      'Your own Ticket' => 'Din egen ticket',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Skriv svar',
      'Contact customer' => 'Kontakta kund',
      'phone call' => 'Telefonsamtal',

    # Template: AgentZoomArticle
      'Split' => 'Dela',

    # Template: AgentZoomBody
      'Change queue' => 'ndra k',

    # Template: AgentZoomHead
      'Free Fields' => 'Lediga flt',
      'Print' => 'Skriv ut',

    # Template: AgentZoomStatus
      '"}","18' => '',

    # Template: CustomerCreateAccount
      'Create Account' => 'Skapa konto',

    # Template: CustomerError
      'Traceback' => '',

    # Template: CustomerFAQArticleHistory
      'Edit' => 'Redigera',
      'FAQ History' => '',

    # Template: CustomerFAQArticlePrint
      'Category' => 'Kategori',
      'Keywords' => 'Nyckelord',
      'Last update' => 'Senast ndrat',
      'Problem' => 'Problem',
      'Solution' => 'Lsning',
      'Symptom' => 'Symptom',

    # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => '',

    # Template: CustomerFAQArticleView
      'FAQ Article' => '',
      'Modified' => 'ndrat',

    # Template: CustomerFAQOverview
      'FAQ Overview' => 'FAQ versikt',

    # Template: CustomerFAQSearch
      'FAQ Search' => 'FAQ Sk',
      'Fulltext' => 'Fritext',
      'Keyword' => 'Nyckelord',

    # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'FAQ Skresultat',

    # Template: CustomerFooter
      'Powered by' => '',

    # Template: CustomerHeader
      'Contact' => 'Kontakt',
      'Home' => 'Hem',
      'Online-Support' => 'Online-support',
      'Products' => 'Produkter',
      'Support' => 'Support',

    # Template: CustomerLogin

    # Template: CustomerLostPassword
      'Lost your password?' => 'Glmt lsenordet?',
      'Request new password' => 'Be om nytt lsenord',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'Create new Ticket' => 'Skapat ny ticket',
      'FAQ' => 'FAQ',
      'New Ticket' => 'Ny ticket',
      'Ticket-Overview' => 'Ticket-versikt',
      'Welcome %s' => 'Vlkommen %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView
      'My Tickets' => 'Mina tickets',

    # Template: CustomerStatusViewTable

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Klicka hr fr att rapportera ett fel!',

    # Template: FAQArticleDelete
      'FAQ Delete' => 'Radera FAQ',
      'You really want to delete this article?' => 'Vill du verkligen radera denna artikel?',

    # Template: FAQArticleForm
      'Comment (internal)' => 'Kommentar (intern)',
      'Filename' => 'Filnamn',
      'Short Description' => 'Kort beskrivning',

    # Template: FAQArticleHistory

    # Template: FAQArticlePrint

    # Template: FAQArticleSystemHistory

    # Template: FAQArticleView

    # Template: FAQCategoryForm
      'FAQ Category' => 'FAQ Kategori',

    # Template: FAQLanguageForm
      'FAQ Language' => 'FAQ Sprk',

    # Template: FAQNavigationBar

    # Template: FAQOverview

    # Template: FAQSearch

    # Template: FAQSearchResult

    # Template: FAQStateForm
      'FAQ State' => 'FAQ Status',

    # Template: Footer
      'Top of Page' => 'Brjan av sidan',

    # Template: Header

    # Template: InstallerBody
      'Create Database' => 'Skapa databas',
      'Drop Database' => 'Radera databas',
      'Finished' => 'Klar',
      'System Settings' => 'Systeminstllningar',
      'Web-Installer' => 'Web-installation',

    # Template: InstallerFinish
      'Admin-User' => 'Admin-anvndare',
      'After doing so your OTRS is up and running.' => 'Efter detta r OTRS igng.',
      'Have a lot of fun!' => 'Ha det s roligt!',
      'Restart your webserver' => 'Starta om din webserver',
      'Start page' => 'Startsida',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Fr att kunna anvnda OTRS, mste fljende rad skrivas p kommandoraden som root.',
      'Your OTRS Team' => 'Ditt OTRS-Team',

    # Template: InstallerLicense
      'accept license' => 'godknn licens',
      'don\'t accept license' => 'godknn inte licens',
      'License' => 'Licens',

    # Template: InstallerStart
      'Create new database' => 'Skapa ny databas',
      'DB Admin Password' => 'DB Adminlsenord',
      'DB Admin User' => 'DB Adminanvndare',
      'DB Host' => 'DB host',
      'DB Type' => 'DB typ',
      'default \'hot\'' => 'default \'hot\'',
      'Delete old database' => 'Radera gammal databas',
      'next step' => 'nsta steg',
      'OTRS DB connect host' => 'OTRS DB connect host',
      'OTRS DB Name' => 'OTRS DB namn',
      'OTRS DB Password' => 'OTRS DB lsenord',
      'OTRS DB User' => 'OTRS DB anvndare',
      'your MySQL DB should have a root password! Default is empty!' => 'Din MySQL-databas br ha ett root-lsenord satt!  Default r inget lsenord!',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontrollerar mx-uppslag fr uppgivna emailadresser i meddelanden som skrivs.  Anvnd inte CheckMXRecord om din OTRS-maskin r bakom en uppringd lina!)',
      '(Email of the system admin)' => '(Email till systemadmin)',
      '(Full qualified domain name of your system)' => '(Fullt kvalificerat dns-namn fr ditt system)',
      '(Logfile just needed for File-LogModule!)' => '(Logfile behvs enbart fr File-LogModule!)',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Unik id fr detta system.  Alla ticketnummer och http-sesssionsid brjar med denna id)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Ticket-identifierare, t.ex. \'Ticket#\', \'Call#\' eller \'MyTicket#\')',
      '(Used default language)' => '(Valt standardsprk)',
      '(Used log backend)' => '(Valt logg-backend)',
      '(Used ticket number format)' => '(Valt format fr ticketnummer)',
      'CheckMXRecord' => '',
      'Default Charset' => 'Standard teckenuppsttning',
      'Default Language' => 'Standardsprk',
      'Logfile' => 'Logfil',
      'LogModule' => '',
      'Organization' => 'Organisation',
      'System FQDN' => '',
      'SystemID' => '',
      'Ticket Hook' => '',
      'Ticket Number Generator' => 'Ticket-nummergenerator',
      'Use utf-8 it your database supports it!' => 'Anvnd utf-8 ifall din databas stdjer det!',
      'Webfrontend' => 'Web-grnssnitt',

    # Template: Login

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Ingen tkomst',

    # Template: Notify
      'Info' => '',

    # Template: PrintFooter
      'URL' => '',

    # Template: PrintHeader
      'printed by' => 'utskrivet av',

    # Template: QueueView
      'All tickets' => 'Alla tickets',
      'Page' => 'Sida',
      'Queues' => 'Ker',
      'Tickets available' => 'Tillgngliga tickets',
      'Tickets shown' => 'Tickets som visas',

    # Template: SystemStats
      'Graphs' => 'Grafer',

    # Template: Test
      'OTRS Test Page' => 'OTRS Test-sida',

    # Template: TicketEscalation
      'Ticket escalation!' => 'Ticket-upptrappning!',

    # Template: TicketView

    # Template: TicketViewLite
      'Add Note' => 'Lgg till anteckning',

    # Template: Warning

    # Misc
      'Addressbook' => 'Adressbok',
      'AgentFrontend' => 'Agent-grnssnitt',
      'Article free text' => 'Artikel-fritext',
      'BackendMessage' => 'Backend-meddelande',
      'Bottom of Page' => 'Slutet av sidan',
      'Charset' => 'Teckenuppsttning',
      'Charsets' => 'Teckenuppsttningar',
      'Closed' => 'Lst',
      'Create' => 'Skapa',
      'CustomerUser' => 'Kundanvndare',
      'New ticket via call.' => 'Ny ticket via samtal.',
      'New user' => 'Ny anvndare',
      'Search in' => 'Sk i',
      'Show all' => 'Visa alla',
      'Shown Tickets' => 'Tickets som visas',
      'System Charset Management' => 'Hantering av systemets teckenuppsttning',
      'Time till escalation' => 'Tid till upptrappning',
      'With Priority' => 'Med prioritet',
      'With State' => 'Med status',
      'invalid-temporarily' => 'temporrt ogiltig',
      'search' => 'sk',
      'store' => 'lagra',
      'tickets' => 'tickets',
      'valid' => 'giltig',
    );

    # $$STOP$$
    $Self->{Translation} = \%Hash;
}
# --
1;

