# --
# Kernel/Language/sk_SK.pm - provides sk_SK language translation
# Copyright (C) 2001-2006 Martin Edenhofer <martin+code@otrs.org>
# --
# $Id: sk_SK.pm,v 1.3 2006/04/01 23:38:29 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::sk_SK;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.3 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Thu Jul 28 22:12:45 2005

    # possible charsets
    $Self->{Charset} = ['iso-8859-2',];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'no',
      'No' => 'Nie',
      'yes' => 'no',
      'no' => 'iadny',
      'Off' => 'vypn',
      'off' => 'vypn',
      'On' => 'zapn',
      'on' => 'zapn',
      'top' => 'hore',
      'end' => 'koniec',
      'Done' => 'hotovo',
      'Cancel' => 'zrui',
      'Reset' => 'Reset',
      'last' => 'posledn',
      'before' => 'pred',
      'day' => 'de',
      'days' => 'dni',
      'day(s)' => 'de/dni',
      'hour' => 'hodina',
      'hours' => 'hodiny',
      'hour(s)' => 'hodina/hodiny',
      'minute' => 'minuta',
      'minutes' => 'minuty',
      'minute(s)' => 'minuta/minuty',
      'month' => 'mesiac',
      'months' => 'mesiace',
      'month(s)' => 'mesiac/mesiace',
      'week' => 'tde',
      'week(s)' => 'tdne',
      'year' => 'rok',
      'years' => 'roky',
      'year(s)' => 'rok/roky',
      'wrote' => 'psa',
      'Message' => 'sprva',
      'Error' => 'Chyba',
      'Bug Report' => 'chybov hlsenie',
      'Attention' => 'Pozor',
      'Warning' => 'Varovanie',
      'Module' => 'Modul',
      'Modulefile' => 'modulov prieinok',
      'Subfunction' => 'Podfunkcia',
      'Line' => 'riadok',
      'Example' => 'Prklad',
      'Examples' => 'Prklady',
      'valid' => 'platn',
      'invalid' => 'neplatn',
      'invalid-temporarily' => 'doasne neplatn',
      ' 2 minutes' => ' 2 minuty',
      ' 5 minutes' => ' 5 mint',
      ' 7 minutes' => ' 7 mint',
      '10 minutes' => ' 10 mint',
      '15 minutes' => ' 15 mint',
      'Mr.' => 'Pn',
      'Mrs.' => 'Pani',
      'Next' => 'alej',
      'Back' => 'sp',
      'Next...' => 'alej...',
      '...Back' => '...sp',
      '-none-' => '-iadny-',
      'none' => 'iadny',
      'none!' => 'iaden',
      'none - answered' => 'iadna odpove',
      'please do not edit!' => 'Prosm neupravova!',
      'AddLink' => 'Prida odkaz.',
      'Link' => 'Prepojenie',
      'Linked' => 'spojen',
      'Link (Normal)' => 'Prepojenie (obyajn)',
      'Link (Parent)' => 'Prepojenie (zdroj)',
      'Link (Child)' => 'Prepojenie (nslednk)',
      'Normal' => 'obyajn',
      'Parent' => 'zdroj',
      'Child' => 'diea',
      'Hit' => 'der',
      'Hits' => 'dery',
      'Text' => 'Text',
      'Lite' => 'Odahen',
      'User' => 'Uvate',
      'Username' => 'Uvatesk meno',
      'Language' => 'Jazyk',
      'Languages' => 'Jazyky',
      'Password' => 'Heslo',
      'Salutation' => 'Oslovenie',
      'Signature' => 'Podpis',
      'Customer' => 'Zkaznk',
      'CustomerID' => 'Zkazncke ',
      'CustomerIDs' => 'Zkazncke sla',
      'customer' => 'Zkaznk',
      'agent' => 'Agent',
      'system' => 'Systm',
      'Customer Info' => 'Zkaznke info',
      'go!' => 'tart!',
      'go' => 'tart',
      'All' => 'Vetko',
      'all' => 'vetko',
      'Sorry' => 'Pardon',
      'update!' => 'Aktualizuj!',
      'update' => 'Aktualizova',
      'Update' => 'Aktualizcia',
      'submit!' => 'predlo!',
      'submit' => 'predloi',
      'Submit' => 'Predloenie',
      'change!' => 'Zme!',
      'Change' => 'Zmena',
      'change' => 'Zmeni',
      'click here' => 'klikni tu',
      'Comment' => 'poznmka',
      'Valid' => 'Platn',
      'Invalid Option!' => 'Neplatn monos!',
      'Invalid time!' => 'Neplatn as!',
      'Invalid date!' => 'Neplatn dtum!',
      'Name' => 'Meno',
      'Group' => 'Skupina',
      'Description' => 'Popis ',
      'description' => 'Popis ',
      'Theme' => 'Schema',
      'Created' => 'Vytvoren',
      'Created by' => 'Vytvoren (km)',
      'Changed' => 'Zmenen',
      'Changed by' => 'Zmenen (km)',
      'Search' => 'Hada',
      'and' => 'a',
      'between' => 'medzi',
      'Fulltext Search' => 'Fulltextov vyhadvanie ',
      'Data' => 'daje',
      'Options' => 'Monosti',
      'Title' => 'Nzov',
      'Item' => 'Poloka',
      'Delete' => 'Zmaza',
      'Edit' => 'Upravi',
      'View' => 'Zobrazi',
      'Number' => 'slo',
      'System' => 'Systm',
      'Contact' => 'Kontakt',
      'Contacts' => 'Kontakty',
      'Export' => 'Export',
      'Up' => 'Hore',
      'Down' => 'Dolu',
      'Add' => 'Prida ',
      'Category' => 'Kategria',
      'Viewer' => 'Zobraz',
      'New message' => 'Nov sprva',
      'New message!' => 'Nov sprva!',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosim odpovedajte na tento tiket',
      'You got new message!' => 'Mte nov sprvu!',
      'You have %s new message(s)!' => 'Mte % novch sprv!',
      'You have %s reminder ticket(s)!' => 'Mte % pripomienok!',
      'The recommended charset for your language is %s!' => 'Odporan znakov sada pre v jazyk je %',
      'Passwords doesn\'t match! Please try it again!' => 'Hesl sa nezhoduju! Prosm skste znova!',
      'Password is already in use! Please use an other password!' => 'Heslo je u pouvan. Prosm pouite in heslo!',
      'Password is already used! Please use an other password!' => 'Heslo je u pouvan. Prosm pouite in heslo!',
      'You need to activate %s first to use it!' => 'Na pouvanie muste najprv aktivova %',
      'No suggestions' => 'iadne nvrhy.',
      'Word' => 'Slovo',
      'Ignore' => 'Ignorova',
      'replace with' => 'nahradi s',
      'Welcome to %s' => 'Vitajte v %',
      'There is no account with that login name.' => 'Neexistuje iadny et s tmto vateskm menom',
      'Login failed! Your username or password was entered incorrectly.' => 'Prihlsenie zlyhalo! Vae pouvatesk meno alebo heslo bolo vloen nesprvne.',
      'Please contact your admin' => 'Prosm kontaktujte vho administrtora.',
      'Logout successful. Thank you for using OTRS!' => 'Odhlsenie spen. akujeme za pouvanie ORTS!',
      'Invalid SessionID!' => 'Neplatn SessionID',
      'Feature not active!' => 'Funkcia neaktvna!',
      'Take this Customer' => 'Poui tohto klienta.',
      'Take this User' => 'Pui tohto uvatea.',
      'possible' => 'mon',
      'reject' => 'odmietnu',
      'Facility' => 'Prsluenstvo',
      'Timeover' => 'Timeover',
      'Pending till' => 'Odloen do.',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Nepracujte s pouvateskm slom 1 (systmov et)! Vytvorte novho pouvatea.',
      'Dispatching by email To: field.' => 'Posielam emailom =>  prijemca: pole',
      'Dispatching by selected Queue.' => 'Posielam vybranm radom.',
      'No entry found!' => 'Nenjden iaden vstup.',
      'Session has timed out. Please log in again.' => 'Relcia timeout. Prosm =>  prihlste sa znova.',
      'No Permission!' => 'Nepovolen!',
      'To: (%s) replaced with database email!' => 'Prjemca: % je nahraden databzovm emailom!',
      'Cc: (%s) added database email!' => 'Kpia: % pridan databzov email.',
      '(Click here to add)' => '(Ak chcete prida poloku =>  kliknete sem.)',
      'Preview' => 'Nhad',
      'Added User %s""' => 'Pridan pouvate %',
      'Contract' => 'Zmluva',
      'Online Customer: %s' => 'Online uvate: %',
      'Online Agent: %s' => 'Online Agent %',
      'Calendar' => 'Kalendr',
      'File' => 'File',
      'Filename' => 'Filename',
      'Type' => 'Typ',
      'Size' => 'Vekos',
      'Upload' => 'Upload',
      'Directory' => 'Directory',
      'Signed' => 'Podpsan',
      'Sign' => 'Podpsa',
      'Crypted' => 'Zaifrovan',
      'Crypt' => 'ifrova',

      # Template: AAAMonth
	'Jan' => 'jan',
	'Feb' => 'feb',
	'Mar' => 'mar',
	'Apr' => 'aprl',
	'May' => 'mj',
	'Jun' => 'jn',
	'Jul' => 'jl',
	'Aug' => 'aug',
	'Sep' => 'sept',
	'Oct' => 'okt',
	'Nov' => 'nov',
	'Dec' => 'dec',

      # Template: AAANavBar
      'Admin-Area' => 'Admin-oblas',
      'Agent-Area' => 'Agent-Area',
      'Ticket-Area' => 'Ticket-Area',
      'Logout' => 'Odhlsenie ',
      'Agent Preferences' => 'Nastavenia vatea',
      'Preferences' => 'Nastavenia',
      'Agent Mailbox' => 'Agent Mailbox',
      'Stats' => 'tatistika',
      'Stats-Area' => 'tatistick oblas',
      'FAQ-Area' => 'FAQ oblas',
      'FAQ' => 'FAQ',
      'FAQ-Search' => 'FAQ-hladanie',
      'FAQ-Article' => 'FAQ-lnok',
      'New Article' => 'Nov lnok',
      'FAQ-State' => 'FAQ-stav',
      'Admin' => 'Admin',
      'A web calendar' => 'webov kalendr',
      'WebMail' => 'WebMail',
      'A web mail client' => 'Web mail client',
      'FileManager' => 'Sprvca sborov',
      'A web file manager' => 'Sprvca weborch sborov',
      'Artefact' => 'Artefakt',
      'Incident' => 'Udalos',
      'Advisory' => 'Advisory',
      'WebWatcher' => 'WebWatcher',
      'Customer Users' => 'Klientsk uvatelia.',
      'Customer Users <-> Groups' => 'Klientsk uvatelia <-> skupiny ',
      'Users <-> Groups' => 'Uvatelia <-> Skupiny',
      'Roles' => 'Funkcie',
      'Roles <-> Users' => 'Funkcie <-> Uvatelia',
      'Roles <-> Groups' => 'Funkcie <-> Skupiny',
      'Salutations' => 'Oslovenia',
      'Signatures' => 'Podpisy',
      'Email Addresses' => 'Emailov adresy',
      'Notifications' => 'Oznamovanie',
      'Category Tree' => 'Strom kategri',
      'Admin Notification' => 'Administrtorsk oznamovanie',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Predvoby spene aktualizovan!',
      'Mail Management' => 'Sprva poty.',
      'Frontend' => 'Frontend',
      'Other Options' => 'Ostatn Monosti',
      'Change Password' => 'Zmena hesla',
      'New password' => 'Nov heslo',
      'New password again' => 'Znova nov heslo',
      'Select your QueueView refresh time.' => 'Vyberte si refresh time fronty',
      'Select your frontend language.' => 'Vyberte si jazyk.',
      'Select your frontend Charset.' => 'Vyberte si znakov sadu.',
      'Select your frontend Theme.' => 'Vyberte si vzhad.',
      'Select your frontend QueueView.' => 'Vyberte si QueueView',
      'Spelling Dictionary' => 'Slovnk pravopisu.',
      'Select your default spelling dictionary.' => 'Vyberte si slovnk na kontrolu pravopisu.',
      'Max. shown Tickets a page in Overview.' => 'Maximlny poet poiadaviek zobrazovanch v prehade.',
      'Can\'t update password =>  passwords doesn\'t match! Please try it again!' => 'Nemono aktualizova heslo =>  hesl nezhoduj.',
      'Can\'t update password =>  invalid characters!' => 'Nemono aktualizova heslo =>  neplatn znaky.',
      'Can\'t update password =>  need min. 8 characters!' => 'Nemono aktualizova heslo =>  potrebujete minimlne 8 psmen.',
      'Can\'t update password =>  need 2 lower and 2 upper characters!' => 'Nemono aktualizova heslo =>  potrebujete 2 mal a 2 vek psmen',
      'Can\'t update password =>  need min. 1 digit!' => 'Nemono aktualizova heslo =>  potrebujete minimlne 1 slicu.',
      'Can\'t update password =>  need min. 2 characters!' => 'Nemono aktualizova heslo =>  potrebujete minimlne 2 psmen!',
      'Password is needed!' => 'Je potrebn heslo.',

      # Template: AAATicket
      'Lock' => 'Zamkn',
      'Unlock' => 'Odomkn',
      'History' => 'Histria',
      'Zoom' => 'Zvi',
      'Age' => 'Vek',
      'Bounce' => 'Skoi na',
      'Forward' => 'Nasledujci',
      'From' => 'Od ',
      'To' => 'Prjemca',
      'Cc' => 'Cc',
      'Bcc' => 'Bcc',
      'Subject' => 'Predmet',
      'Move' => 'Presun',
      'Queue' => 'Fronta',
      'Priority' => 'Priorita',
      'State' => 'Stav',
      'Compose' => 'Vytvori',
      'Pending' => 'akanie',
      'Owner' => 'Vlastnk',
      'Owner Update' => 'aktualizcia vlastnka',
      'Sender' => 'Odosielate',
      'Article' => 'lnok',
      'Ticket' => 'Poiadavka',
      'Createtime' => 'Doba spracovania',
      'plain' => 'jednoduch',
      'Email' => 'e-mail',
      'email' => 'e-mail',
      'Close' => 'Zatvorit',
      'Action' => 'Akcia',
      'Attachment' => 'Prloha',
      'Attachments' => 'Prlohy',
      'This message was written in a character set other than your own.' => 'Tto sprva bola napsan v inej znakovej sade =>  ako je vaa.',
      'If it is not displayed correctly => ' => 'Ak nie je zobrazen sprvne =>  ',
      'This is a' => 'To je',
      'to open it in a new window.' => 'Otvori v novom okne',
      'This is a HTML email. Click here to show it.' => 'Toto je HMTL  e-mail. Na otvorenie =>  kliknite tu',
      'Free Fields' => 'Von polia',
      'Merge' => 'Zli',
      'closed successful' => 'zatvoren spene',
      'closed unsuccessful' => 'zatvoren nespene',
      'new' => 'nov',
      'open' => 'otvori',
      'closed' => 'zatvoren',
      'removed' => 'odstrnen',
      'pending reminder' => 'nevybaven pripomienka',
      'pending auto close+' => 'poas automatickho zatvrania +',
      'pending auto close-' => 'poas automatickho zatvrania -',
      'email-external' => 'extern e-mail',
      'email-internal' => 'intern e-mail',
      'note-external' => 'extern poznmka',
      'note-internal' => 'intern poznmka',
      'note-report' => 'hlsnie poznmky',
      'phone' => 'telefn',
      'sms' => 'sms',
      'webrequest' => 'webov poiadavka',
      'lock' => 'zamkn',
      'unlock' => 'odomkn',
      'very low' => 'vemi nzka',
      'low' => 'nzka',
      'normal' => 'normlna',
      'high' => 'vysok',
      'very high' => 'vemi vysok',
      '1 very low' => '1 vemi nzka',
      '2 low' => '2 nzka',
      '3 normal' => '3 normlna',
      '4 high' => '4 vysok',
      '5 very high' => '5 vemi vysok',
      'Ticket %s" created!"' => 'poiadavka % vytvoren',
      'Ticket Number' => 'slo poiadavky',
      'Ticket Object' => 'predmet poiadavky',
      'No such Ticket Number %s"! Can\'t link it!"' => 'iadna poiadavka slo %. ',
      'Don\'t show closed Tickets' => 'Nezobrazuj uzavret poiadavky.',
      'Show closed Tickets' => 'Zobraz uzavret poiadavky.',
      'Email-Ticket' => 'e-mailov poiadavka',
      'Create new Email Ticket' => 'Vytvor nov e-mailov poiadavku',
      'Phone-Ticket' => 'Telefonick poiadavka',
      'Create new Phone Ticket' => 'Vytvor nov telefonick poiadavku',
      'Search Tickets' => 'Hadaj poiadavky',
      'Edit Customer Users' => 'Uprav zkaznckeho uvatea.',
      'Bulk-Action' => 'Hromadn akcia',
      'Bulk Actions on Tickets' => 'hromadn akcie na poiadavkch.',
      'Send Email and create a new Ticket' => 'Poli e-mail a vytvor nov poiadavku',
      'Overview of all open Tickets' => 'Prehad vetkch otvorench poiadaviek.',
      'Locked Tickets' => 'Lockovan poiadavky',
      'Lock it to work on it!' => 'Kvli prci na nich =>  lock.',
      'Unlock to give it back to the queue!' => 'Unlock a daj sp do radu.',
      'Shows the ticket history!' => 'Zobraz histriu poiadaviek.',
      'Print this ticket!' => 'Vytla tto poiadavku.',
      'Change the ticket priority!' => 'Zme prioritu poiadavky.',
      'Change the ticket free fields!' => 'Zme von polia poiadavky.',
      'Link this ticket to an other objects!' => 'Prepoj poiadavku s inmi objektami!',
      'Change the ticket owner!' => 'Zme majitea poiadavky.',
      'Change the ticket customer!' => 'Zme klienta poiadavky.',
      'Add a note to this ticket!' => 'Pridaj poznmku k tejto poiadavke.',
      'Merge this ticket!' => 'Pripoj tto poiadavku.',
      'Set this ticket to pending!' => 'Nastav poiadavku na vyrieenie.',
      'Close this ticket!' => 'Zatvor tto poiadavku.',
      'Look into a ticket!' => 'Vyhadaj poiadavku.',
      'Delete this ticket!' => 'Vyma tto poiadavku.',
      'Mark as Spam!' => 'Ozna ako Spam!',
      'My Queues' => 'Moje rady.',
      'Shown Tickets' => 'Zobraz poiadavky.',
      'New ticket notification' => 'Hlsenie novej poiadavky.',
      'Send me a notification if there is a new ticket in My Queues"."' => 'Poli mi notifikciu =>  ak je nov poiadavka v MyQueue ?',
      'Follow up notification' => 'Nasleduj hlsenie.',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Poli mi oznmenie =>  ak klient pole overenie a ja som vlastnk tejto poiadavky.',
      'Ticket lock timeout notification' => 'Poiadavka blokuje asov limit oznmenia.',
      'Send me a notification if a ticket is unlocked by the system.' => 'Poli mi oznmenie =>  ak je poiadavka odblokovan systmom.',
      'Move notification' => 'Premiestni hlsenie',
      'Send me a notification if a ticket is moved into one of My Queues"."' => 'Poli mi oznmenie =>  ak je poiadavka premiestnen do jednho z mojich radov.',
      'Your queue selection of your favorite queues. You also get notified about this queues via email if enabled.' => 'V vber z obbench radov. Tie mete by oboznmen s poiadavkou cez e-mail =>  ak je to mon.',
      'Custom Queue' => 'Klientsk rady.',
      'QueueView refresh time' => '?',
      'Screen after new ticket' => 'Okno po novej poiadavke.',
      'Select your screen after creating a new ticket.' => 'Vyberte si okno zobrazujce sa po vytvoren novej poiadavky.',
      'Closed Tickets' => 'Zatvoren poiadavky.',
      'Show closed tickets.' => 'Uk zatvoren poiadavky.',
      'Max. shown Tickets a page in QueueView.' => 'Maximlny poet poiadaviek zobrazovanch v prehade.',
      'Responses' => 'Odpovede',
      'Responses <-> Queue' => 'Odpovede <-> rad',
      'Auto Responses' => 'Automatick odpovede',
      'Auto Responses <-> Queue' => 'Automatick odpovede <-> rad',
      'Attachments <-> Responses' => 'Prlohy <-> Odpovede',
      'History::Move' => 'Histria: pohyb',
      'History::NewTicket' => 'Histria: Nov pripomienka',
      'History::FollowUp' => 'Histria: sleduj',
      'History::SendAutoReject' => 'Histria: poli automatick odpove',
      'History::SendAutoReply' => 'Histria: poli automatick zamietnutie',
      'History::SendAutoFollowUp' => 'Histria: SendAutoFollowUp',
      'History::Forward' => 'Histria: Forward',
      'History::Bounce' => 'Histria: ',
      'History::SendAnswer' => 'Histria:: Poli odpove',
      'History::SendAgentNotification' => 'Histria:: poli notifikciu zstupcovi',
      'History::SendCustomerNotification' => 'Histria:: Poli zkazncku notifikciu',
      'History::EmailAgent' => 'Histria: email zstupcu',
      'History::EmailCustomer' => 'Histria: Email klienta',
      'History::PhoneCallAgent' => 'Histria: Hovor agenta',
      'History::PhoneCallCustomer' => 'Histria: Hovor klienta',
      'History::AddNote' => 'Histria: Pridaj poznmku',
      'History::Lock' => 'Histria: zamkni',
      'History::Unlock' => 'Histria: odomkni',
      'History::TimeAccounting' => 'Histria: asov et',
      'History::Remove' => 'Histria: odstrnen',
      'History::CustomerUpdate' => 'Histria: klientsk aktualizcia',
      'History::PriorityUpdate' => 'Histria: aktualizcia priort',
      'History::OwnerUpdate' => 'Histria: aktualizcia majitea',
      'History::LoopProtection' => 'Histria: LoopProtection',
      'History::Misc' => 'Histria: ',
      'History::SetPendingTime' => 'Histria: Nastav as rieenia',
      'History::StateUpdate' => 'Histria: Aktualizcia stavu',
      'History::TicketFreeTextUpdate' => 'Histria: ',
      'History::WebRequestCustomer' => 'Histria: ',
      'History::TicketLinkAdd' => 'Histria: ',
      'History::TicketLinkDelete' => 'Histria: ',
      'Workflow Groups' => '?',

      # Template: AAAWeekDay
      'Sun' => 'Ned',
      'Mon' => 'Pon',
      'Tue' => 'Ut',
      'Wed' => 'Str',
      'Thu' => 'Stv',
      'Fri' => 'Pia',
      'Sat' => 'Sob',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'riadenie prloh',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'riadenie automatickch odpoved',
      'Response' => 'Odpove',
      'Auto Response From' => 'Automatick odpove od',
      'Note' => 'Poznmka',
      'Useable options' => 'pouiten monos',
      'to get the first 20 character of the subject' => 'zobrazi prvch 20 vlastnost subjektu',
      'to get the first 5 lines of the email' => 'zobrazi prvch 5 riadkov emailu',
      'to get the from line of the email' => 'zobrazi ',
      'to get the realname of the sender (if given)' => 'zobrazi skuton meno odosielatea (ak je dan)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt; =>  &lt;OTRS_TICKET_ID&gt; =>  &lt;OTRS_TICKET_Queue&gt; =>  &lt;OTRS_TICKET_State&gt;)' => 'Monosti dajov poiadavky (napr. &lt;OTRS_TICKET_Number&gt; =>  &lt;OTRS_TICKET_ID&gt; =>  &lt;OTRS_TICKET_Queue&gt; =>  &lt;OTRS_TICKET_State&gt;)',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'Vytvoren sprva bola zatvoren. ',
      'This window must be called from compose window' => 'Toto okno mus by vyvolan z okna na vytvranie.',
      'Customer User Management' => 'Riadenie klientskch uvateov.',
      'Search for' => 'Hada',
      'Result' => 'vsledok',
      'Select Source (for add)' => 'vyber zdroj (pre pridanie)',
      'Source' => 'zdroj',
      'This values are read only.' => 'Tto hodnota je iba na tanie',
      'This values are required.' => 'Tto hodnota je poadovan.',
      'Customer user will be needed to have a customer history and to login via customer panel.' => 'Customer user will be needed to have a customer history and to login via customer panel.',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => 'Klientsk uvatelia <-> Skupiny riadenia',
      'Change %s settings' => 'Zmeni % nastavenia',
      'Select the user:group permissions.' => 'Vyber pouvatea: skupina povolen',
      'If nothing is selected =>  then there are no permissions in this group (tickets will not be available for the user).' => 'Ak nie je ni vybran =>  nie je dovolen pracova v tejto skupine (poiadavky nie s dostupn pre uvatea)',
      'Permission' => 'Povolenie',
      'ro' => 'ro',
      'Read only access to the ticket in this group/queue.' => 'taj iba prstup k poiadavkm v tejto skupine/rade.',
      'rw' => 'rw',
      'Full read and write access to the tickets in this group/queue.' => ,

      # Template: AdminCustomerUserGroupForm

      # Template: AdminEmail
      'Message sent to' => 'Sprva poslan',
      'Recipents' => 'Adresti',
      'Body' => 'Telo sprvy',
      'send' => 'Posla',

      # Template: AdminGenericAgent
      'GenericAgent' => 'generovan zstupca',
      'Job-List' => 'zoznam loh',
      'Last run' => 'posledn spustenie',
      'Run Now!' => 'Spusti!',
      'x' => 'x',
      'Save Job as?' => 'Uloi prcu ako?',
      'Is Job Valid?' => 'Je prca platn?',
      'Is Job Valid' => 'Je prca platn',
      'Schedule' => 'Rozvrh',
      'Fulltext-Search in Article (e. g. Mar*in" or "Baue*")"' => 'Fulltextov vyhadvanie v lnku (napr. Mar*in" alebo "Baue*")"',
      '(e. g. 10*5155 or 105658*)' => '(napr. 10*5155 alebo 105658*)',
      '(e. g. 234321)' => '(napr. 234321)',
      'Customer User Login' => 'login klientskho uvatea',
      '(e. g. U5150)' => '(napr. U5150)',
      'Agent' => 'Zstupca',
      'TicketFreeText' => 'Text bez poiadavky',
      'Ticket Lock' => ,
      'Times' => 'as',
      'No time settings.' => 'iadne asov nastavenia',
      'Ticket created' => 'Pripomienka vytvoren',
      'Ticket created between' => 'Pripomienka vytvoren medzi',
      'New Priority' => 'Nov priorita',
      'New Queue' => 'Nov rad',
      'New State' => 'Nov stav',
      'New Agent' => 'Nov zstupca',
      'New Owner' => 'Nov ',
      'New Customer' => 'Nov zkaznk',
      'New Ticket Lock' => ,
      'CustomerUser' => 'klientsk uvate',
      'Add Note' => 'priada poznmku',
      'CMD' => 'CMD',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.',
      'Delete tickets' => 'Zmazan poiadavky',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Pozor! Tto poiadavka bude vymazan z databzy. Tieto poiadavky s straten!',
      'Modules' => 'Moduly',
      'Param 1' => 'parameter 1',
      'Param 2' => 'parameter 2',
      'Param 3' => 'parameter 3',
      'Param 4' => 'parameter 4',
      'Param 5' => 'parameter 5',
      'Param 6' => 'parameter 6',
      'Save' => 'Uloi',

      # Template: AdminGroupForm
      'Group Management' => 'Sprva skupn',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'The admin group is to get in the admin area and the stats group to get stats area.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department =>  support department =>  sales department =>  ...).' => 'vytvorit nove skupiny pre osetrenie pristupovych prav roznych skupin agentov (napr. Oddelenie nkupu =>  oddelenie predaja => ..)',
      'It\'s useful for ASP solutions.' => 'It\'s useful for ASP solutions.',

      # Template: AdminLog
      'System Log' => 'systmov zznam',
      'Time' => 'as',

      # Template: AdminNavigationBar
      'Users' => 'Uvatelia',
      'Groups' => 'Skupiny',
      'Misc' => 'Ine',

      # Template: AdminNotificationForm
      'Notification Management' => 'Sprva hlsen',
      'Notification' => 'Hlsenie',
      'Notifications are sent to an agent or a customer.' => 'Hlsenia s poslan zstupcovi alebo zkaznkovi.',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'monosti konfigurcie (napr. &lt;OTRS_CONFIG_HttpType&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Monosti majitea poiadavky (napr. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Monosti aktulneho pouvatea =>  ktor poaduje tieto akcie (napr. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Monosti dajov aktulnohe klientskho uvatea (napr. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',

      # Template: AdminPackageManager
      'Package Manager' => 'riadenie balka',
      'Uninstall' => 'odintalova',
      'Verion' => 'Verion',
      'Do you really want to uninstall this package?' => 'Skutone chcete odintalova tento balk?',
      'Install' => 'intalova',
      'Package' => 'Balk',
      'Online Repository' => 'Online Repository',
      'Version' => 'Verzia',
      'Vendor' => 'Vendor',
      'Upgrade' => 'Upgrade',
      'Local Repository' => 'miestna schrnka',
      'Status' => 'stav',
      'Overview' => 'Nhad',
      'Download' => 'Stiahnu',
      'Rebuild' => 'Prestava',
      'Reinstall' => 'Reintalova',

      # Template: AdminPGPForm
      'PGP Management' => 'PGP manament',
      'Identifier' => 'identifiktor',
      'Bit' => 'bit',
      'Key' => 'k',
      'Fingerprint' => 'Fingerprint',
      'Expires' => 'Platnos',
      'In this way you can directly edit the keyring configured in SysConfig.' => 'Tmto spsobom mete priamo upravova konfigurcie',

      # Template: AdminPOP3Form
      'POP3 Account Management' => 'POP3 Account Management',
      'Host' => 'Host',
      'Trusted' => 'Dveryhodn',
      'Dispatching' => 'Vykonanie',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Vetky prichdzajce e-maily s jednm tom bud vybaven vo vybranom rade.',
      'If your account is trusted =>  the already existing x-otrs header at arrival time (for priority =>  ...) will be used! PostMaster filter will be used anyway.' => 'Ak je v et ',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => 'PostMaster Filter Management',
      'Filtername' => 'Filtername',
      'Match' => 'Spoji',
      'Header' => 'Hlavika',
      'Value' => 'Hodnota',
      'Set' => 'Nastavi',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Vybavi =>  alebo filtrova prichdzujce e-maly =>  na bze e-mailu X-header! Reg-Exp je tie mon!',
      'If you use RegExp =>  you also can use the matched value in () as [***] in \'Set\'.' => 'Ak pouvate RegExp =>  mete tie pouva prepojen hodnoty v () ako [***] v \'Set\'.',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => 'Rady <-> Riadenie automatickch odpoved',

      # Template: AdminQueueAutoResponseTable

      # Template: AdminQueueForm
      'Queue Management' => 'Riadenie radov',
      'Sub-Queue of' => 'Podrad (oho)',
      'Unlock timeout' => 'Unlock timeout',
      '0 = no unlock' => '0 = iadne odomknanie',
      'Escalation time' => 'as eskalcie',
      '0 = no escalation' => '0 = iadne zvyovanie',
      'Follow up Option' => 'nasledujce monosti',
      'Ticket lock after a follow up' => 'uzamkn poiadavku po nasledovnom',
      'Systemaddress' => 'systmov adresa',
      'Customer Move Notify' => 'hlsenie klientovho pohybu',
      'Customer State Notify' => 'hlsenie stavu klienta',
      'Customer Owner Notify' => 'hlsenie majitea klienta',
      'If an agent locks a ticket and he/she will not send an answer within this time =>  the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ak zstupca uzamkne poiadavku a on/ona nepole odpove do uritho asu =>  bude poiadavka automaticky odomknut a tak zobraziten pre vetkch zstupcov.',
      'If a ticket will not be answered in this time =>  just only this ticket will be shown.' => 'Ak nebude na poiadavku odpovedan do uritho asu =>  bude tto poiadavka zobrazen!',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ak je poiadavka zatvoren a klient pole nasledujcu poiadavku =>  poiadavka bude zamknut pre starho majitea.',
      'Will be the sender address of this queue for email answers.' => 'Adresa odosielatea tohto radu pre e-mailov odpove.',
      'The salutation for email answers.' => 'Pozdrav pre e-mailov odpove.',
      'The signature for email answers.' => 'Podpis pre e-mailov odpove.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS posiela klientom oznmenie e-mailom =>  ak bola poiadavka premiestnen.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS posiela klientom oznmenie e-mailom =>  ak sa zmenil stav poiadavky.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS posiela klientom oznmenie e-mailom =>  ak sa zmenil majite poiadavky.',
      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => 'Reakcie <-> Rady manamentu',

      # Template: AdminQueueResponsesForm
      'Answer' => 'odpove',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => 'Reakcie <-> Prlohy manamentu',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'odpove riadenia',
      'A response is default text to write faster answer (with default text) to customers.' => 'Reakcia je prednastaven text pre rchlejie psanie odpoved klientom.',
      'Don\'t forget to add a new response a queue!' => 'Nezabudnite prida nov odpove radu!',
      'Next state' => 'al ',
      'All Customer variables like defined in config option CustomerUser.' => 'vsetky zakaznikove premenne ako tie definovane v konfiguracnej moznosti (volbe) CustomerUser',
      'The current ticket state is' => 'Aktulny stav poiadavky je',
      'Your email address is new' => 'Vaa e-mailov adresa je nov.',

      # Template: AdminRoleForm
      'Role Management' => 'riadenie funkci',
      'Create a role and put groups in it. Then add the role to the users.' => 'Vytvori funkciu a da ju do skupiny. Potom prida funkciu uvateom.',
      'It\'s useful for a lot of users and groups.' => 'Je to pouiten pre mnostvo uvateov a skupn.',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => 'lohy  <-> riadenie skupn',
      'move_into' => 'premiestni_do',
      'Permissions to move tickets into this group/queue.' => 'Povolenie presun poiadavky do tejto skupiny/radu.',
      'create' => 'vytvori',
      'Permissions to create tickets in this group/queue.' => 'Povolenie vytvori poiadavku v tejto skupine/rade.',
      'owner' => 'majite',
      'Permissions to change the ticket owner in this group/queue.' => 'Povolenie zmeni majitea poiadavky v tejto skupine/rade.',
      'priority' => 'priorita',
      'Permissions to change the ticket priority in this group/queue.' => 'Povolenie zmeni prioritu poiadavky v tejto skupine/rade.',

      # Template: AdminRoleGroupForm
      'Role' => 'loha',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => 'funkcia <-> riadenie uvateov',
      'Active' => 'aktvny',
      'Select the role:user relations.' => 'vyber funkciu: prepojenia uvateov',

      # Template: AdminRoleUserForm

      # Template: AdminSalutationForm
      'Salutation Management' => 'Salutation Management',
      'customer realname' => 'skuton meno klienta',
      'for agent firstname' => 'pre meno agenta',
      'for agent lastname' => 'pre priezvisko agenta',
      'for agent user id' => 'pre agentovo pouvatesk id',
      'for agent login' => 'pre login agenta',

      # Template: AdminSelectBoxForm
      'Select Box' => 'vyber prieinok',
      'SQL' => 'SQL',
      'Limit' => 'limit',
      'Select Box Result' => 'Select Box vsledok',

      # Template: AdminSession
      'Session Management' => 'riadenie relcie',
      'Sessions' => 'relcie',
      'Uniq' => 'Uniq',
      'kill all sessions' => 'zru vetky relcie',
      'Session' => 'relcia',
      'kill session' => 'zrui relcie',

      # Template: AdminSignatureForm
      'Signature Management' => 'podpis vedenia',

      # Template: AdminSMIMEForm
      'SMIME Management' => 'SMIME riadenie',
      'Add Certificate' => 'pridaj osobn k',
      'Add Private Key' => 'pridaj osobn k',
      'Secret' => 'Sajn',
      'Hash' => 'Hash',
      'In this way you can directly edit the certification and private keys in file system.' => 'Tmto spsobom moene priamo meni osvedenie a osobn k v systme sborov.',

      # Template: AdminStateForm
      'System State Management' => 'Riadenie stavu systmu.',
      'State Type' => 'typ postavenia',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Dvajte pozor =>  i je aktualizovan tie ',
      'See also' => 'pozri aj',

      # Template: AdminSysConfig
      'SysConfig' => 'SysConfig',
      'Group selection' => 'vber skupiny',
      'Show' => 'ukza',
      'Download Settings' => 'Stiahnu nastavenia.',
      'Download all system config changes.' => 'Stiahnu vetky zmeny systmovej konfigurcie.',
      'Load Settings' => 'nata nastavenia',
      'Subgroup' => 'podskupina',
      'Elements' => 'asti',

      # Template: AdminSysConfigEdit
      'Config Options' => 'monosti configurcie',
      'Default'        => 'prednastaven',
      'Content'        => 'obsah',
      'New'            => 'nov',
      'New Group'      => 'nov skupina',
      'Group Ro'       => 'nov skupina RO',
      'New Group Ro'   => 'Neue Gruppe Ro',
      'NavBarName'     => 'obraz',
      'Image'          => 'prednastaven',
      'Prio'           => 'predchdzajci',
      'Block'          => 'blokova',
      'NavBar'         => 'NavBar',
      'AccessKey'      => 'Prstupov k',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'sprva systmovej e-mailovej adresy',
      'Email' => 'Email',
      'Realname' => 'Skuton meno',
      'All incoming emails with this Email" (To:) will be dispatched in the selected queue!"' => 'Vetky prichdzajce e-maily s prjemcom =>  bud vybaven v radoch.',

      # Template: AdminUserForm
      'User Management' => 'Sprva uvateov',
      'Firstname' => 'Meno',
      'Lastname' => 'Priezvisko',
      'User will be needed to handle tickets.' => ,
      'Don\'t forget to add a new user to groups and/or roles!' => 'Nezabudnite prida novho pouvatea do skupn a/alebo loh!',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => 'Uvatelia <-> skupiny ',
      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'adresr',
      'Return to the compose screen' => 'Sp na obrazovku vytvorenia.',
      'Discard all changes and return to the compose screen' => ,

      # Template: AgentCalendarSmall

      # Template: AgentCalendarSmallIcon

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => 'info',

      # Template: AgentLinkObject
      'Link Object' => 'prepojen objekt',
      'Select' => 'vber',
      'Results' => 'vsledky',
      'Total hits' => 'poet derov',
      'Site' => 'strana',
      'Detail' => 'detail',

      # Template: AgentLookup
      'Lookup' => 'vyhada',

      # Template: AgentNavigationBar
      'Ticket selected for bulk action!' => 'Poiadavky vybran pre hromadn akciu!',
      'You need min. one selected Ticket!' => 'Potrebujete minimlne 1 vybran poiadavku!',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Kontrola pravopisu',
      'spelling error(s)' => 'Chyba pravopisu',
      'or' => 'alebo',
      'Apply these changes' => 'Poui tieto zmeny.',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'Sprva mus ma prjemcu!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Muste napsa emailov adresu (napr. klient@prklad.com) do Prjemca:!',
      'Bounce ticket' => 'preskoi poiadavku',
      'Bounce to' => 'preskoi na',
      'Next ticket state' => 'Stav dalej poiadavky',
      'Inform sender' => 'informova odosielatea.',
      'Your email with ticket number <OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations."' => 'V e-mail s slom poiadavky <OTRS_POIADAVKA> je pripojen k <OTRS_PRIPOJI_K_POIADAVKE>',
      'Send mail!' => 'Poli mail!',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'Sprva by mala ma predmet!',
      'Ticket Bulk Action' => 'hromadn akcia poiadaviek',
      'Spell Check' => 'kontrola pravopisu',
      'Note type' => 'typ poznmky',
      'Unlock Tickets' => 'Unlock poiadavky.',

      # Template: AgentTicketClose
      'A message should have a body!' => 'Sprva mus ma telo.',
      'You need to account time!' => 'Potrebujete asov konto!',
      'Close ticket' => 'Zatvori poiadavku',
      'Note Text' => 'Text poznmky',
      'Close type' => 'Typ zatvorenia',
      'Time units' => 'asov jednotka',
      ' (work units)' => '(pracovn jednotka)',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'V sprve mus by skontrolovan pravopis.',
      'Compose answer for ticket' => 'Vytvori odpove na poiadavku.',
      'Attach' => 'priloi',
      'Pending Date' => 'as vybavenia',
      'for pending* states' => ,

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'Zme klienta poiadavky.',
      'Set customer user and customer id of a ticket' => 'Nastavi klientskho uvatea a klientsk id poiadavky',
      'Customer User' => 'Klient-uvate',
      'Search Customer' => 'Hada klienta',
      'Customer Data' => 'Klientsk daje',
      'Customer history' => 'Histria klienta',
      'All customer tickets.' => 'poiadavky vetkch klientov',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'nasledujci',

      # Template: AgentTicketEmail
      'Compose Email' => 'vytvori e-mail',
      'new ticket' => 'nov poiadavka',
      'Clear To' => 'vyma: Komu',
      'All Agents' => 'vetci agenti',
      'Termin1' => 'Termn1',

      # Template: AgentTicketForward
      'Article type' => 'typ lnku',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'zmeni von text poiadavky',

      # Template: AgentTicketHistory
      'History of' => 'histria',

      # Template: AgentTicketLocked
      'Ticket locked!' => 'zamknut poiadavka',
      'Ticket unlock!' => 'neuzamknut poiadavka!',

      # Template: AgentTicketMailbox
      'Mailbox' => ,
      'Tickets' => 'poiadavky',
      'All messages' => 'vetky sprvy',
      'New messages' => 'nov sprvy',
      'Pending messages' => 'nevybaven sprvy',
      'Reminder messages' => 'pripomienkov sprva',
      'Reminder' => 'pripomienkova',
      'Sort by' => 'triedi poda',
      'Order' => 'poradie',
      'up' => 'hore',
      'down' => 'dolu',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => 'Muste pouva slo poiadavky!',
      'Ticket Merge' => 'pripojen poiadavka',
      'Merge to' => 'pripoji k',
      'Your email with ticket number <OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>"."' => 'V e-mail s slom poiadavky <OTRS_POIADAVKA> je pripojen k <OTRS_PRIPOJI_K_POIADAVKE>',

      # Template: AgentTicketMove
      'Queue ID' => 'ID radu',
      'Move Ticket' => 'presu poiadavku',
      'Previous Owner' => 'predchdzajci majite',

      # Template: AgentTicketNote
      'Add note to ticket' => 'prida poznmku k poiadavke',
      'Inform Agent' => 'neformlny zstupca',
      'Optional' => 'monosti',
      'Inform involved Agents' => ,

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'Zme poiadavku majitea.',
      'Message for new Owner' => 'sprva od novho majitea.',

      # Template: AgentTicketPending
      'Set Pending' => 'nastavi vybavenie',
      'Pending type' => 'typ vybavenia',
      'Pending date' => 'termn vybavenia',

      # Template: AgentTicketPhone
      'Phone call' => 'hovor',

      # Template: AgentTicketPhoneNew
      'Clear From' => 'zmaza Od',

      # Template: AgentTicketPlain
      'Plain' => 'ist',
      'TicketID' => 'ID poiadavky',
      'ArticleID' => 'ID lnku',

      # Template: AgentTicketPrint
      'Ticket-Info' => 'info o poiadavkch',
      'Accounted time' => ,
      'Escalation in' => 'zvyova v',
      'Linked-Object' => 'prepojen objekt',
      'Parent-Object' => 'matersk objekt',
      'Child-Object' => 'dcrsky objekt',
      'by' => 'km',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'Zme prioritu poiadavky.',

      # Template: AgentTicketQueue
      'Tickets shown' => 'zobrazen poiadavky',
      'Page' => 'strana',
      'Tickets available' => 'dostupn poiadavky',
      'All tickets' => 'Vetky poiadavky',
      'Queues' => 'Rady',
      'Ticket escalation!' => 'stupovanie poiadaviek',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'Vaa vlastn poiadavka',
      'Compose Follow up' => 'vytvori nasledujcu',
      'Compose Answer' => 'vytvori odpove',
      'Contact customer' => 'kontaktova klienta',
      'Change queue' => 'zmeni rady',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketSearch
      'Ticket Search' => 'vyhadvanie poiadavky',
      'Profile' => 'profil',
      'Search-Template' => 'Vyhadvacia ablna',
      'Created in Queue' => 'Vytvori v rade.',
      'Result Form' => 'Vsledok z',
      'Save Search-Profile as Template?' => 'Uloi vyhadvac profil ako ablnu?',
      'Yes =>  save it with name' => 'no =>  ulo s menom.',
      'Customer history search' => 'histria klientskho hadania',
      'Customer history search (e. g. ID342425")."' => 'histria klientskho hadania (napr. ID342425")',
      'No * possible!' => 'iadna * nie je mon',

      # Template: AgentTicketSearchResult
      'Search Result' => 'vsledok hadania ',
      'Change search options' => 'zme monosti hadania',

      # Template: AgentTicketSearchResultPrint
      '"}' => '',

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'triedi hore',
      'U' => 'U',
      'sort downward' => 'triedi dolu',
      'D' => 'D',

      # Template: AgentTicketStatusView
      'Ticket Status View' => 'zobrazenie stavu poiadavky',
      'Open Tickets' => 'Otvoren poiadavky',

      # Template: AgentTicketZoom
      'Split' => 'Rozdeli',

      # Template: AgentTicketZoomStatus
      'Locked' => 'Zamkn',

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerCalendarSmallIcon

      # Template: CustomerError
      'Traceback' => 'Traceback',

      # Template: CustomerFAQ
      'Print' => 'Tlai',
      'Keywords' => 'Kov slov',
      'Symptom' => 'Symptm',
      'Problem' => 'Problem',
      'Solution' => 'Rieenie',
      'Modified' => 'Zmenen',
      'Last update' => 'Posledn aktualizcia',
      'FAQ System History' => 'FAQ histria systmu',
      'modified' => 'zmenen',
      'FAQ Search' => 'FAQ hadanie',
      'Fulltext' => 'Fulltext',
      'Keyword' => 'Kov slovo',
      'FAQ Search Result' => 'vsledok hadania FAQ',
      'FAQ Overview' => 'FAQ prehad',

      # Template: CustomerFooter
      'Powered by' => 'Powered by',

      # Template: CustomerFooterSmall

      # Template: CustomerHeader

      # Template: CustomerHeaderSmall

      # Template: CustomerLogin

      'Login' => 'Login',
      'Lost your password?' => 'Zabudli ste heslo?',
      'Request new password' => 'Poadova nov heslo',
      'Create Account' => 'Vytvori et',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'Vitajte v %',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView
      'of' => 'z',

      # Template: CustomerTicketMessage

      # Template: CustomerTicketMessageNew

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Pre hlsenie chyby =>  kliknite tu!',

      # Template: FAQ
      'Comment (internal)' => 'komentr (vntorn)',
      'A article should have a title!' => 'lnok mus ma nzov!',
      'New FAQ Article' => 'Nov FAQ lnok.',
      'Do you really want to delete this Object?' => 'Naozaj chcete zmaza tento objekt?',
      'System History' => 'Histria systmu',

      # Template: FAQCategoryForm
      'Name is required!' => 'Poadovan meno!',
      'FAQ Category' => 'Kategria FAQ',

      # Template: FAQLanguageForm
      'FAQ Language' => 'jazyk FAQ',

      # Template: Footer
      'QueueView' => 'Prehad radu.',
      'PhoneView' => 'Prehad hovorov',
      'Top of Page' => 'Zaiatok strany',

      # Template: FooterSmall

      # Template: Header
      'Home' => 'Home',

      # Template: HeaderSmall

      # Template: Installer
      'Web-Installer' => 'Web-Installer',
      'accept license' => 'akceptova licenciu',
      'don\'t accept license' => 'neakceptova licenciu',
      'Admin-User' => 'Admin-pouvate',
      'Admin-Password' => 'Admin-heslo',
      'your MySQL DB should have a root password! Default is empty!' => 'Vae MySQL DB',
      'Database-User' => 'pouvate databzy',
      'default \'hot\'' => 'predvolen (?)',
      'DB connect host' => 'DB pripojenie host',
      'Database' => 'Databza',
      'Create' => 'Vytvori',
      0 => ,
      'SystemID' => 'SystemID',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => 'Identifikcia systmu. Kad slo poiadavky a kad http zana tmto slo.',
      'System FQDN' => 'System FQDN',
      '(Full qualified domain name of your system)' => 'Cel nzov domny vho systmu',
      'AdminEmail' => 'AdminEmail',
      '(Email of the system admin)' => 'E-mail systmovho administrtora',
      'Organization' => 'Organizcia',
      'Log' => 'Log',
      'LogModule' => 'LogModule',
      '(Used log backend)' => '(Used log backend)',
      'Logfile' => 'Logfile',
      '(Logfile just needed for File-LogModule!)' => 'Sbor zznamov je potrebn pre Sbor Log Module!',
      'Webfrontend' => 'webov rozhranie',
      'Default Charset' => 'Predvolen znakov sada',
      'Use utf-8 it your database supports it!' => 'Poui utf-8 na podporu Vaej databzy.',
      'Default Language' => 'Predvolen jazyk',
      '(Used default language)' => 'Pouvan predvolen jazyk',
      'CheckMXRecord' => 'CheckMXRecord',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'Pri skladani (kompozicii) odpovede skontroluje MX zaznamy pouzitych emailovych adries. ',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Aby ste mohli pouzivat OTRS =>  musite zadat nasledovne: do Vasho prikazoveho riadku (terminal/shell) =>  pricom musite byt prihlaseny ako root:',
      'Restart your webserver' => 'dat "nasledovne") do Vasho prikazoveho riadku (terminal/shell) =>  pricom musite byt prihlaseny ako root:',
      'After doing so your OTRS is up and running.' => 'Ak to urobte =>  V OTRS je spusten.',
      'Start page' => 'Prv strana',
      'Have a lot of fun!' => 'Vea zbavy',
      'Your OTRS Team' => 'V OTRS tm',

      # Template: Login

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'Nepovolen',

      # Template: Notify
      'Important' => 'Dleit',

      # Template: PrintFooter
      'URL' => 'URL',

      # Template: PrintHeader
      'printed by' => 'vytlaen',

      # Template: Redirect

      # Template: SystemStats
      'Format' => 'Formt',

      # Template: Test
      'OTRS Test Page' => 'OTRS test strany',
      'Counter' => 'Potadlo',

      # Template: Warning
      # Misc
      'OTRS DB connect host' => 'OTRS DB pripojenie',
      'Create Database' => 'Vytvor databzu',
      'DB Host' => 'DB ',
      'Ticket Number Generator' => 'Generova sel poiadaviek',
      '(Ticket identifier. Some people want to set this to e. g. \'Ticket#\',\'Call#\' or \'MyTicket#\')' => '(Identifiktor poiadavky. Niektor udia to chc nastavi naprklad: \'Ticket#\', \'Call#\' alebo \'MyTicket#\')',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Tmto spsobom mete priamo upravova kov nastavenie v Kenel/Config.',
      'Close!' => 'Zatvori!',
      'TicketZoom' => 'Zvi poiadavku',
      'Don\'t forget to add a new user to groups!' => 'Nezabudnite prida novho pouvatea do skupn!',
      'License' => 'Licencia',
      'CreateTicket' => 'Vytvor poiadavku',
      'OTRS DB Name' => 'OTRS DB meno',
      'System Settings' => 'Systmov nastavenia',
      'Finished' => 'Ukonen',
      'Days' => 'Dni',
      'with' => 's',
      'DB Admin User' => 'DB admin pouvate',
      'Change user <-> group settings' => 'Zme pouvatea <-> nastavenie skupiny',
      'DB Type' => 'DB typ',
      'next step' => 'da krok',
      'My Queue' => 'Mj rad',
      'Create new database' => 'Vytvor nov databzu',
      'Delete old database' => 'Vyma star databzu',
      'Load' => 'Nata',
      'OTRS DB User' => 'OTRS DB pouvate',
      'OTRS DB Password' => 'OTRS DB heslo',
      'DB Admin Password' => 'DB heslo administrtora',
      'Drop Database' => 'vymaza databzu',
      '(Used ticket number format)' => '(Pouite seln formt poiadavky)',
      'FAQ History' => 'Histria FAQ',
      'Customer called' => 'Zkazncky hovor',
      'Phone' => 'Telefn',
      'Office' => 'Kancelria',
      'CompanyTickets' => 'Firemn poiadavky',
      'MyTickets' => 'Moje poiadavky',
      'New Ticket' => 'Nov poiadavka',
      'Create new Ticket' => 'Vytvor nov poiadavku',
      'Package not correctly deployed =>  you need to deploy it again!' => 'Balk nie je sprvne rozmiestnen =>  muste ho rozmiestni ete raz.',
      'installed' => 'naintalovan',
      'uninstalled' => 'odintalovan',
    };
    # $$STOP$$
}
#--
1;
