# --
# Kernel/Language/fr.pm - provides fr language translation
# Copyright (C) 2002 Bernard Choppy <choppy at imaginet.fr>
# Copyright (C) 2002 Nicolas Goralski <ngoralski at oceanet-technology.com>
# Copyright (C) 2004-2005 Yann Richard <ze at nbox.org>
# Copyright (C) 2004 Igor Genibel <igor.genibel at eds-opensource.com>
# --
# $Id: fr.pm,v 1.73 2007/06/16 13:01:21 mh Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --

package Kernel::Language::fr;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.73 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Tue May 29 15:15:04 2007

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateFormatShort} = '%D.%M.%Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Oui',
        'No' => 'Non',
        'yes' => 'oui',
        'no' => 'non',
        'Off' => 'teint',
        'off' => 'teint',
        'On' => 'Allum',
        'on' => 'allum',
        'top' => 'haut',
        'end' => 'fin',
        'Done' => 'Fait',
        'Cancel' => 'Annuler',
        'Reset' => 'Remise  zro',
        'last' => 'dernier',
        'before' => 'avant',
        'day' => 'jour',
        'days' => 'jours',
        'day(s)' => 'jour(s)',
        'hour' => 'heure',
        'hours' => 'heures',
        'hour(s)' => 'heure(s)',
        'minute' => '',
        'minutes' => '',
        'minute(s)' => '',
        'month' => 'mois',
        'months' => 'mois',
        'month(s)' => 'mois',
        'week' => 'semaine',
        'week(s)' => 'semaine(s)',
        'year' => 'anne',
        'years' => 'annes',
        'year(s)' => 'anne(s)',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        'wrote' => 'crit',
        'Message' => '',
        'Error' => 'Erreur',
        'Bug Report' => 'Rapport d\'anomalie',
        'Attention' => '',
        'Warning' => 'Attention',
        'Module' => '',
        'Modulefile' => 'Fichier de module',
        'Subfunction' => 'sous-fonction',
        'Line' => 'Ligne',
        'Example' => 'Exemple',
        'Examples' => 'Exemples',
        'valid' => 'valide',
        'invalid' => 'invalide',
        '* invalid' => '',
        'invalid-temporarily' => 'temporairement invalide',
        ' 2 minutes' => '',
        ' 5 minutes' => '',
        ' 7 minutes' => '',
        '10 minutes' => '',
        '15 minutes' => '',
        'Mr.' => 'M.',
        'Mrs.' => 'Mme',
        'Next' => 'Suivant',
        'Back' => 'Retour',
        'Next...' => 'Suivant...',
        '...Back' => '...Retour',
        '-none-' => '-aucun-',
        'none' => 'aucun',
        'none!' => 'aucun !',
        'none - answered' => 'aucun - rpondu',
        'please do not edit!' => 'Ne pas modifier !',
        'AddLink' => 'Ajouter un lien',
        'Link' => 'Lien',
        'Linked' => 'Lie',
        'Link (Normal)' => 'Lien (Normal)',
        'Link (Parent)' => 'Lien (Parent)',
        'Link (Child)' => 'Lien (Enfant)',
        'Normal' => '',
        'Parent' => '',
        'Child' => 'Enfant',
        'Hit' => '',
        'Hits' => '',
        'Text' => 'Texte',
        'Lite' => 'allge',
        'User' => 'Utilisateur',
        'Username' => 'Nom d\'utilisateur',
        'Language' => 'Langue',
        'Languages' => 'Langues',
        'Password' => 'Mot de Passe',
        'Salutation' => '',
        'Signature' => '',
        'Customer' => 'Client',
        'CustomerID' => 'Numro de client',
        'CustomerIDs' => 'Numro de client (Groupe)',
        'customer' => 'client',
        'agent' => 'technicien',
        'system' => 'systme',
        'Customer Info' => 'Information client',
        'Customer Company' => '',
        'Company' => '',
        'go!' => 'c\'est parti !',
        'go' => 'aller',
        'All' => 'Tout',
        'all' => 'tout',
        'Sorry' => 'Dsol',
        'update!' => 'mettre  jour !',
        'update' => 'mettre  jour',
        'Update' => 'Mettre  jour',
        'submit!' => 'soumettre !',
        'submit' => 'soumettre',
        'Submit' => 'Soumettre',
        'change!' => 'modifier !',
        'Change' => 'Modifier',
        'change' => 'modifier',
        'click here' => 'Cliquer ici',
        'Comment' => 'Commentaire',
        'Valid' => 'Valide',
        'Invalid Option!' => 'Option invalide !',
        'Invalid time!' => 'Temps invalide !',
        'Invalid date!' => 'Date invalide !',
        'Name' => 'Nom',
        'Group' => 'Groupe',
        'Description' => '',
        'description' => '',
        'Theme' => 'Thme',
        'Created' => 'Cr',
        'Created by' => 'Cre par',
        'Changed' => 'Chang',
        'Changed by' => 'Chang par',
        'Search' => 'Chercher',
        'and' => 'et le',
        'between' => 'entre',
        'Fulltext Search' => 'Recherche sur tout le texte',
        'Data' => 'Donnes',
        'Options' => '',
        'Title' => 'Titre',
        'Item' => 'lment',
        'Delete' => 'Effacer',
        'Edit' => 'diter',
        'View' => 'Vue',
        'Number' => 'Nombre',
        'System' => 'Systme',
        'Contact' => '',
        'Contacts' => '',
        'Export' => 'Exporter',
        'Up' => 'Haut',
        'Down' => 'Bas',
        'Add' => 'Ajouter',
        'Category' => 'Catgorie',
        'Viewer' => 'Visionneuse',
        'New message' => 'Nouveau message',
        'New message!' => 'Nouveau message !',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Il faut rpondre  ce(s) ticket(s) pour revenir  une vue normale de la file !',
        'You got new message!' => 'Vous avez un nouveau message !',
        'You have %s new message(s)!' => 'Vous avez %s nouveau(x) message(s) !',
        'You have %s reminder ticket(s)!' => 'Vous avez %s rappel(s) de ticket(s) !',
        'The recommended charset for your language is %s!' => 'Le jeu de caractre correspondant  votre langue est %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Les mots de passes diffrent! Essayez de nouveau svp!',
        'Password is already in use! Please use an other password!' => 'Mot de passe dj utilis! Essayez en un autre svp!',
        'Password is already used! Please use an other password!' => 'Ce mot de passe a dj t utilis! Essayez en un autre svp!',
        'You need to activate %s first to use it!' => 'Vous devez dabord activer %s pour l\'utiliser !',
        'No suggestions' => 'Pas de suggestions',
        'Word' => 'Mot',
        'Ignore' => 'Ignorer',
        'replace with' => 'remplacer par',
        'There is no account with that login name.' => 'Il n\'y a aucun compte avec ce nom de connexion',
        'Login failed! Your username or password was entered incorrectly.' => 'La connection a chou ! Votre nom d\'utilisateur ou votre mot de passe sont errons.',
        'Please contact your admin' => 'Veuillez contacter votre admnistrateur',
        'Logout successful. Thank you for using OTRS!' => 'Dconnexion russie. Merci d\'avoir utilis OTRS!',
        'Invalid SessionID!' => 'ID de Session Invalide !',
        'Feature not active!' => 'Cette fonctionnalit n\'est pas active !',
        'Login is needed!' => '',
        'Password is needed!' => 'Le mot de passe est requis !',
        'License' => 'Licence',
        'Take this Customer' => 'Choisir ce client',
        'Take this User' => 'Choisir cet utilisateur',
        'possible' => '',
        'reject' => 'rejet',
        'reverse' => '',
        'Facility' => 'Service',
        'Timeover' => 'Temp coul',
        'Pending till' => 'En attendant jusqu\'',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Cela ne fonctionne pas avec l\'identfifiant utilisateur 1 (Compte Systme)! Veuillez crer un nouvel utilisateur!',
        'Dispatching by email To: field.' => 'Rpartition par le champs \':\' du courriel',
        'Dispatching by selected Queue.' => 'Rpartition selon la file slectionne',
        'No entry found!' => 'Aucun rsultat n\'a t trouv !',
        'Session has timed out. Please log in again.' => 'Le dlai de votre session est dpass, veuillez vous r-authentifier.',
        'No Permission!' => 'Pas de permission!',
        'To: (%s) replaced with database email!' => 'Le champ \':\' (%s) a t remplac avec la valeur de la base de donnes des des adresses de courriel !',
        'Cc: (%s) added database email!' => 'Cc: (%s) a t ajout  la base de donne d\'e-mail',
        '(Click here to add)' => '(Cliquez ii pour ajouter)',
        'Preview' => 'Aperu',
        'Package not correctly deployed! You should reinstall the Package again!' => '',
        'Added User "%s"' => 'Ajout de l\'utilisateur "%s"',
        'Contract' => 'Contrat',
        'Online Customer: %s' => 'Clients en ligne: %s',
        'Online Agent: %s' => 'Agents en ligne: %s',
        'Calendar' => 'Calendrier',
        'File' => 'Fichier',
        'Filename' => 'Nom de fichier',
        'Type' => '',
        'Size' => 'Taille',
        'Upload' => 'Uploader',
        'Directory' => 'Rpertoire',
        'Signed' => 'Sign',
        'Sign' => 'Signer',
        'Crypted' => 'Crypt',
        'Crypt' => 'Crypter',
        'Office' => 'Bureau',
        'Phone' => 'Tlphone',
        'Fax' => '',
        'Mobile' => '',
        'Zip' => '',
        'City' => '',
        'Country' => '',
        'installed' => 'install',
        'uninstalled' => 'dsinstall',
        'Security Note: You should activate %s because application is already running!' => '',
        'Unable to parse Online Repository index document!' => '',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => '',
        'No Packages or no new Packages in selected Online Repository!' => '',
        'printed at' => '',

        # Template: AAAMonth
        'Jan' => '',
        'Feb' => 'Fv',
        'Mar' => '',
        'Apr' => 'Avr',
        'May' => 'Mai',
        'Jun' => 'Juin',
        'Jul' => 'Juil',
        'Aug' => 'Au',
        'Sep' => '',
        'Oct' => '',
        'Nov' => '',
        'Dec' => 'Dc',
        'January' => '',
        'February' => '',
        'March' => '',
        'April' => '',
        'June' => '',
        'July' => '',
        'August' => '',
        'September' => '',
        'October' => '',
        'November' => '',
        'December' => '',

        # Template: AAANavBar
        'Admin-Area' => 'Zone d\'administration',
        'Agent-Area' => 'Interface du technicien',
        'Ticket-Area' => 'Tickets',
        'Logout' => 'Dconnexion',
        'Agent Preferences' => 'Prfrences de l\'Agent',
        'Preferences' => 'Prfrences',
        'Agent Mailbox' => 'Boite e-mail de l\'Agent',
        'Stats' => 'Statistiques',
        'Stats-Area' => 'Statistiques',
        'Admin' => 'Administrateur',
        'Customer Users' => 'Clients',
        'Customer Users <-> Groups' => 'Clients <-> Groupes',
        'Users <-> Groups' => 'Agent <-> Groupes',
        'Roles' => 'Rles',
        'Roles <-> Users' => 'Rles <-> Agents',
        'Roles <-> Groups' => 'Rles <-> Groupes',
        'Salutations' => '',
        'Signatures' => '',
        'Email Addresses' => 'Adresses lectroniques',
        'Notifications' => '',
        'Category Tree' => 'Liste des catgories',
        'Admin Notification' => 'Notification des administrateurs',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Les prfrences ont bien t mises  jours !',
        'Mail Management' => 'Gestion des e-mails',
        'Frontend' => 'Interface',
        'Other Options' => 'Autres options',
        'Change Password' => 'Changer de mot de passe',
        'New password' => 'Nouveau mot de passe',
        'New password again' => 'Nouveau mot de passe (encore)',
        'Select your QueueView refresh time.' => 'Choix du dlai de rafrachissement de la vue des files',
        'Select your frontend language.' => 'Choix de la langue de l\'interface',
        'Select your frontend Charset.' => 'Choix du jeu de caractres de l\'interface',
        'Select your frontend Theme.' => 'Choix du thme de l\'interface',
        'Select your frontend QueueView.' => 'Choisissez votre interface de vue des files',
        'Spelling Dictionary' => 'Correcteur orthographique',
        'Select your default spelling dictionary.' => 'Slectionnez votre correcteur orthographique par dfaut',
        'Max. shown Tickets a page in Overview.' => 'Nombre de tickets maximum sur la page d\'aperu des tickets',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => 'Mise  jour du mot de passe impossible, les mots de passe diffrent! Essayez  nouveau svp!',
        'Can\'t update password, invalid characters!' => 'Mise  jour du mot de passe impossible, caractres invalides!',
        'Can\'t update password, need min. 8 characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit avoir au moins 8 caractres!',
        'Can\'t update password, need 2 lower and 2 upper characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 majuscules et 2 minuscules!',
        'Can\'t update password, need min. 1 digit!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter un chiffre minimum!',
        'Can\'t update password, need min. 2 characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 caractres minimum!',

        # Template: AAAStats
        'Stat' => '',
        'Please fill out the required fields!' => '',
        'Please select a file!' => '',
        'Please select an object!' => '',
        'Please select a graph size!' => '',
        'Please select one element for the X-axis!' => '',
        'You have to select two or more attributes from the select field!' => '',
        'Please select only one element or turn of the button \'Fixed\' where the select field is marked!' => '',
        'If you use a checkbox you have to select some attributes of the select field!' => '',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '',
        'The selected end time is before the start time!' => '',
        'You have to select one or more attributes from the select field!' => '',
        'The selected Date isn\'t valid!' => '',
        'Please select only one or two elements via the checkbox!' => '',
        'If you use a time scale element you can only select one element!' => '',
        'You have an error in your time selection!' => '',
        'Your reporting time interval is to small, please use a larger time scale!' => '',
        'The selected start time is before the allowed start time!' => '',
        'The selected end time is after the allowed end time!' => '',
        'The selected time period is larger than the allowed time period!' => '',
        'Common Specification' => '',
        'Xaxis' => '',
        'Value Series' => '',
        'Restrictions' => '',
        'graph-lines' => '',
        'graph-bars' => '',
        'graph-hbars' => '',
        'graph-points' => '',
        'graph-lines-points' => '',
        'graph-area' => '',
        'graph-pie' => '',
        'extended' => '',
        'Agent/Owner' => '',
        'Created by Agent/Owner' => '',
        'Created Priority' => '',
        'Created State' => '',
        'Create Time' => '',
        'CustomerUserLogin' => '',
        'Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Vrrouiller',
        'Unlock' => 'Dverrouiller',
        'History' => 'Historique',
        'Zoom' => 'Dtails',
        'Age' => 'ge',
        'Bounce' => 'Renvoyer',
        'Forward' => 'Transmettre',
        'From' => 'De ',
        'To' => '',
        'Cc' => 'Copie ',
        'Bcc' => 'Copie Invisible',
        'Subject' => 'Sujet',
        'Move' => 'Dplacer',
        'Queue' => 'File',
        'Priority' => 'Priorit',
        'State' => 'tat',
        'Compose' => 'Composer',
        'Pending' => 'En attente',
        'Owner' => 'Propritaire',
        'Owner Update' => '',
        'Responsible' => '',
        'Responsible Update' => '',
        'Sender' => 'metteur',
        'Article' => '',
        'Ticket' => '',
        'Createtime' => 'Cration du ',
        'plain' => 'tel quel',
        'Email' => 'Courrier lectronique',
        'email' => 'courriel',
        'Close' => 'Fermer',
        'Action' => '',
        'Attachment' => 'Pice jointe',
        'Attachments' => 'Pices jointes',
        'This message was written in a character set other than your own.' => 'Ce message a t crit dans un jeu de caractres diffrent du vtre.',
        'If it is not displayed correctly,' => 'S\'il n\'est pas affich correctement',
        'This is a' => 'Ceci est un',
        'to open it in a new window.' => 'L\'ouvrir dans une nouvelle fentre',
        'This is a HTML email. Click here to show it.' => 'Ceci est un message au format HTML ; cliquer ici pour l\'afficher.',
        'Free Fields' => 'Champs libres',
        'Merge' => 'Fusionner',
        'merged' => '',
        'closed successful' => 'clture russie',
        'closed unsuccessful' => 'clture manque',
        'new' => 'nouveau',
        'open' => 'ouvrir',
        'closed' => 'fermer',
        'removed' => 'supprim',
        'pending reminder' => 'Attente du rappel',
        'pending auto' => '',
        'pending auto close+' => 'Attente de la fermeture automatique(+)',
        'pending auto close-' => 'Attente de la fermeture automatique(-)',
        'email-external' => 'message externe',
        'email-internal' => 'message interne',
        'note-external' => 'Note externe',
        'note-internal' => 'Note interne',
        'note-report' => 'Note rapport',
        'phone' => 'tlphone',
        'sms' => '',
        'webrequest' => 'Requte par le web',
        'lock' => 'vrrouiller',
        'unlock' => 'dverrouiller',
        'very low' => 'trs basse',
        'low' => 'confort de fonctionnement',
        'normal' => '',
        'high' => 'important',
        'very high' => 'trs haut',
        '1 very low' => '1 trs bas',
        '2 low' => '2 bas',
        '3 normal' => '',
        '4 high' => '4 important',
        '5 very high' => '5 trs important',
        'Ticket "%s" created!' => 'Le ticket %s a t cr !',
        'Ticket Number' => 'Numro de ticket',
        'Ticket Object' => 'Objet ticket',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Pas de numro de ticket "%s"! Je ne peut pas le lier',
        'Don\'t show closed Tickets' => 'Ne pas montrer les tickets ferms',
        'Show closed Tickets' => 'Voir les tickets ferms',
        'New Article' => 'Nouvel Article',
        'Email-Ticket' => 'crire un e-mail',
        'Create new Email Ticket' => 'Crer un nouveau ticket en envoyant un e-mail',
        'Phone-Ticket' => 'Vue tlphone',
        'Search Tickets' => 'Recherche de tickets',
        'Edit Customer Users' => 'Editer clients',
        'Bulk-Action' => 'Action group',
        'Bulk Actions on Tickets' => 'Action groups sur les tickets',
        'Send Email and create a new Ticket' => 'Envoyer un courriel et crer un nouveau Ticket',
        'Create new Email Ticket and send this out (Outbound)' => '',
        'Create new Phone Ticket (Inbound)' => '',
        'Overview of all open Tickets' => 'Vue de tout les Tickets',
        'Locked Tickets' => 'Tickets vrrouills',
        'Watched Tickets' => '',
        'Watched' => '',
        'Subscribe' => '',
        'Unsubscribe' => '',
        'Lock it to work on it!' => 'Vrouillez le pour travailler dessus!',
        'Unlock to give it back to the queue!' => 'Dvrrouiller pour qu\'il retourne dans sa file!',
        'Shows the ticket history!' => 'Voir l\'historique du ticket!',
        'Print this ticket!' => 'Imprimer ce ticket!',
        'Change the ticket priority!' => 'Changer la priorit du ticket',
        'Change the ticket free fields!' => 'Changer les champs libres du ticket',
        'Link this ticket to an other objects!' => 'Lier ce ticket  un autre objet!',
        'Change the ticket owner!' => 'Changer le propritaire du ticket!',
        'Change the ticket customer!' => 'Changer le client du ticket!',
        'Add a note to this ticket!' => 'Ajouter une note au ticket!',
        'Merge this ticket!' => 'Fusionner ce ticket!',
        'Set this ticket to pending!' => 'Mettre le ticket en attente!',
        'Close this ticket!' => 'Fermer ce ticket!',
        'Look into a ticket!' => 'Voir le dtail du ticket!',
        'Delete this ticket!' => 'Effacer ce ticket!',
        'Mark as Spam!' => 'Signaler comme Spam!',
        'My Queues' => 'Mes files',
        'Shown Tickets' => 'Tickets affichs',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Votre ticket numro "<OTRS_TICKET>" a t fusionn avec le ticket numro "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => '',
        'Ticket %s: first response time will be over in %s!' => '',
        'Ticket %s: update time is over (%s)!' => '',
        'Ticket %s: update time will be over in %s!' => '',
        'Ticket %s: solution time is over (%s)!' => '',
        'Ticket %s: solution time will be over in %s!' => '',
        'There are more escalated tickets!' => '',
        'New ticket notification' => 'Notification de nouveau ticket',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Me prvenir si il y a un nouveau ticket dans une de "Mes files".',
        'Follow up notification' => 'Notification de suivi',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Me prvenir si un client envoie un suivi (follow-up) et que je suis le propritaire du ticket.',
        'Ticket lock timeout notification' => 'Prvenir du dpassement du dlai d\'un verrou',
        'Send me a notification if a ticket is unlocked by the system.' => 'Me prvenir si un ticket est dvrouill par le systme',
        'Move notification' => 'Notification de mouvement',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Me prvenir si un ticket est dplac dans une de "Mes files".',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => '',
        'Custom Queue' => 'File d\'attente personnalis',
        'QueueView refresh time' => 'Temps de rafrachissement de la vue des files',
        'Screen after new ticket' => 'cran aprs un nouveau ticket',
        'Select your screen after creating a new ticket.' => 'Slectionnez l\'cran qui sera affich aprs avoir cr un nouveau ticket.',
        'Closed Tickets' => 'Tickets ferms',
        'Show closed tickets.' => 'Voir les tickets ferms',
        'Max. shown Tickets a page in QueueView.' => 'Nombre de tickets maximum sur la page de la vue d\'une file',
        'CompanyTickets' => '',
        'MyTickets' => 'Mes tickets',
        'New Ticket' => 'Nouveau ticket',
        'Create new Ticket' => 'Cration d\'un nouveau ticket',
        'Customer called' => 'Client appell',
        'phone call' => '',
        'Responses' => 'Rponses',
        'Responses <-> Queue' => 'Rponses <-> Files',
        'Auto Responses' => 'Rponses automatiques',
        'Auto Responses <-> Queue' => 'Rponses automatiques <-> Files',
        'Attachments <-> Responses' => 'Pices jointes <-> Rponses',
        'History::Move' => 'Le ticket a t dplac dans la file "%s" (%s) - Ancienne file: "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Un nouveau ticket a t cre: [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Un suivie du ticket [%s]. %s',
        'History::SendAutoReject' => 'Rejet automatique envoy  "%s".',
        'History::SendAutoReply' => 'Rponse automatique envoy  "%s".',
        'History::SendAutoFollowUp' => 'Suivie automatique envoy  "%s".',
        'History::Forward' => 'Transfr vers "%s".',
        'History::Bounce' => 'Redirig vers "%s".',
        'History::SendAnswer' => 'Email envoy  "%s".',
        'History::SendAgentNotification' => '"%s"-notification envoy  "%s".',
        'History::SendCustomerNotification' => 'Notification envoy  "%s".',
        'History::EmailAgent' => 'Email envoy au client.',
        'History::EmailCustomer' => 'Ajout d\'une adresse email. %s',
        'History::PhoneCallAgent' => 'Agent a appell le client.',
        'History::PhoneCallCustomer' => 'Le client nous a appell.',
        'History::AddNote' => 'Ajout d\'une note (%s)',
        'History::Lock' => 'Ticket vrouill.',
        'History::Unlock' => 'Ticket dvrouill.',
        'History::TimeAccounting' => 'Temps pass sur l\'action: %s . Total du temps pass pour ce ticket: %s unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Mise  jour: %s',
        'History::PriorityUpdate' => 'Changement de priorit de "%s" (%s) pour "%s" (%s).',
        'History::OwnerUpdate' => 'Le nouveau propritaire est "%s" (ID=%s).',
        'History::LoopProtection' => 'Protection anti-boucle! Pas d\'auto rponse envoy  "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Mise  jour: %s',
        'History::StateUpdate' => 'Avant: "%s" Aprs: "%s"',
        'History::TicketFreeTextUpdate' => 'Mise  jour: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Requte du client via le web.',
        'History::TicketLinkAdd' => 'Added link to ticket "%s".',
        'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Dim',
        'Mon' => 'Lun',
        'Tue' => 'Mar',
        'Wed' => 'Mer',
        'Thu' => 'Jeu',
        'Fri' => 'Ven',
        'Sat' => 'Sam',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Gestion des attachements',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Gestion des rponses automatiques',
        'Response' => 'Rponse',
        'Auto Response From' => 'Rponse automatique de ',
        'Note' => '',
        'Useable options' => 'Options accessibles',
        'To get the first 20 character of the subject.' => '',
        'To get the first 5 lines of the email.' => '',
        'To get the realname of the sender (if given).' => '',
        'To get the article attribut (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => '',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => '',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => '',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => '',
        'Add Customer Company' => '',
        'Add a new Customer Company.' => '',
        'List' => '',
        'This values are required.' => 'Ces valeurs sont obligatoires.',
        'This values are read only.' => 'Ces valeurs sont en lecture seule.',

        # Template: AdminCustomerUserForm
        'Customer User Management' => 'Gestion des clients utilisateurs',
        'Search for' => 'Chercher ',
        'Add Customer User' => '',
        'Source' => '',
        'Create' => 'Cration',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Les clients utilisateurs seront invits  se connecter par la page client.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Clients <-> Gestion des groupes',
        'Change %s settings' => 'Changer les param&ecirc;tres de %s',
        'Select the user:group permissions.' => 'Slectionnez les permissions pour l\'utilisateur:groupe.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Si rien n\'est slectionn, il n\'y aura pas de droits dans ce groupe (Les tickets ne seront plus disponible pour l\'utilisateur).',
        'Permission' => 'Droits',
        'ro' => 'lecture seule',
        'Read only access to the ticket in this group/queue.' => 'Accs en lecture seulement aux tickets de cette file/groupe.',
        'rw' => 'lecture/criture',
        'Full read and write access to the tickets in this group/queue.' => 'Accs complet en lecture et criture aux tickets dans cette file/groupe.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminEmail
        'Message sent to' => 'Message envoy ',
        'Recipents' => 'Rcipients',
        'Body' => 'Corps',
        'Send' => '',

        # Template: AdminGenericAgent
        'GenericAgent' => '',
        'Job-List' => 'Liste de tches',
        'Last run' => 'Dernier lancement',
        'Run Now!' => 'Lancer maintenant!',
        'x' => '',
        'Save Job as?' => 'Sauver la tche en tant que?',
        'Is Job Valid?' => 'Cette tche est-elle valide?',
        'Is Job Valid' => 'Cette tche est-elle valide',
        'Schedule' => 'Planifier',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Recherche sur le texte d\'un article (ex: "Mar*in" or "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '(ex: 10*5155 or 105658*)',
        '(e. g. 234321)' => '(ex: 234321)',
        'Customer User Login' => 'Nom de connexion du client',
        '(e. g. U5150)' => '(ex: U5150)',
        'Agent' => 'Technicien',
        'Ticket Lock' => 'Ticket vrouill',
        'TicketFreeFields' => '',
        'Create Times' => '',
        'No create time settings.' => '',
        'Ticket created' => 'Ticket cr',
        'Ticket created between' => 'Ticket cr entre le',
        'Pending Times' => '',
        'No pending time settings.' => '',
        'Ticket pending time reached' => '',
        'Ticket pending time reached between' => '',
        'New Priority' => 'Nouvelle Priorit',
        'New Queue' => 'Nouvelle File',
        'New State' => 'Nouvel tat',
        'New Agent' => 'Nouvel Agent',
        'New Owner' => 'Nouveau Propritaire',
        'New Customer' => 'Nouveau Client',
        'New Ticket Lock' => 'Nouveau Verrou',
        'CustomerUser' => 'Client utilisateur',
        'New TicketFreeFields' => '',
        'Add Note' => 'Ajouter une note',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Cette commande sera excut. ARG[0] sera le numro du ticket et ARG[1] son identifiant.',
        'Delete tickets' => 'Effacer les tickets',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Attention, ces tickets seront ffacs de la base de donne ! Ils seront dfinitivement perdu !',
        'Send Notification' => '',
        'Param 1' => 'Paramtre 1',
        'Param 2' => 'Paramtre 2',
        'Param 3' => 'Paramtre 3',
        'Param 4' => 'Paramtre 4',
        'Param 5' => 'Paramtre 5',
        'Param 6' => 'Paramtre 6',
        'Send no notifications' => '',
        'Yes means, send no agent and customer notifications on changes.' => '',
        'No means, send agent and customer notifications on changes.' => '',
        'Save' => 'Sauver',
        '%s Tickets affected! Do you really want to use this job?' => '',
        '"}' => '',

        # Template: AdminGroupForm
        'Group Management' => 'Administration des groupes',
        'Add Group' => '',
        'Add a new Group.' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Le groupe admin permet d\'accder  la zone d\'administration et le groupe stats  la zone de statistiques.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crer de nouveaux groupes permettra de grer les droits d\'accs pour les diffrents groupes du technicien (exemple: achats, comptabilit, support, ventes...).',
        'It\'s useful for ASP solutions.' => 'C\'est utile pour les fournisseurs d\'applications.',

        # Template: AdminLog
        'System Log' => 'Journaux du Systme',
        'Time' => 'Date et heure',

        # Template: AdminNavigationBar
        'Users' => 'Utilisateurs',
        'Groups' => 'Groupes',
        'Misc' => 'Divers',

        # Template: AdminNotificationForm
        'Notification Management' => 'Gestion des notifications',
        'Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'Des notifications sont envoyes  un technicien ou  un client.',

        # Template: AdminPackageManager
        'Package Manager' => 'Gestionnaire de paquet',
        'Uninstall' => 'Dinstallation',
        'Version' => '',
        'Do you really want to uninstall this package?' => 'Voulez-vous vraiment dinstaller ce paquet ?',
        'Reinstall' => 'R-installation',
        'Do you really want to reinstall this package (all manual changes get lost)?' => '',
        'Cancle' => '',
        'Continue' => '',
        'Install' => 'Installation',
        'Package' => 'Paquet',
        'Online Repository' => 'Dpot en ligne',
        'Vendor' => 'Vendeur',
        'Upgrade' => 'Mise  jour',
        'Local Repository' => '',
        'Status' => 'tat',
        'Overview' => 'Aperu',
        'Download' => 'Tlchargement',
        'Rebuild' => 'Re-construction',
        'ChangeLog' => '',
        'Date' => '',
        'Filelist' => '',
        'Download file from package!' => '',
        'Required' => '',
        'PrimaryKey' => '',
        'AutoIncrement' => '',
        'SQL' => '',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => '',
        'This feature is enabled!' => '',
        'Just use this feature if you want to log each request.' => '',
        'Of couse this feature will take some system performance it self!' => '',
        'Disable it here!' => '',
        'This feature is disabled!' => '',
        'Enable it here!' => '',
        'Logfile too large!' => '',
        'Logfile too large, you need to reset it!' => '',
        'Range' => '',
        'Interface' => '',
        'Requests' => '',
        'Min Response' => '',
        'Max Response' => '',
        'Average Response' => '',

        # Template: AdminPGPForm
        'PGP Management' => 'Gestion de PGP',
        'Result' => 'Rsultat',
        'Identifier' => 'Identifiant',
        'Bit' => '',
        'Key' => 'Cl',
        'Fingerprint' => 'Empreinte',
        'Expires' => 'Expiration',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Dans ce cas vous pouvez directement diter le trousseau configur dans SysConfig.',

        # Template: AdminPOP3
        'POP3 Account Management' => 'Gestion du compte POP3',
        'Host' => 'Hte',
        'Trusted' => 'Vrifi',
        'Dispatching' => 'Rpartition',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Tous les courriels entrants avec un compte seront rpartis dans la file slectionne !',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Si votre compte est vrifi, les ent&ecirc;tes X-OTRS (pour les priorits,...) seront utiliss !',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Gestion des filtres PostMaster',
        'Filtername' => 'Nom du filtre',
        'Match' => 'Correspond',
        'Header' => 'En-tte',
        'Value' => 'Valeur',
        'Set' => 'Assigner',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'dispatcher ou filtrer les courriels entrant bas sur les en-ttes (X-*)! L\'utilisationd\'expression rgulire est aussi possible.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => '',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Files <-> Gestion des rponses automatiques',

        # Template: AdminQueueForm
        'Queue Management' => 'Gestion des files',
        'Sub-Queue of' => 'Sous-file',
        'Unlock timeout' => 'Dlai du dverrouillage',
        '0 = no unlock' => '0 = pas de vrouillage',
        'Escalation - First Response Time' => '',
        '0 = no escalation' => '0 = pas de remont du ticket',
        'Escalation - Update Time' => '',
        'Escalation - Solution Time' => '',
        'Follow up Option' => 'Option des suivis',
        'Ticket lock after a follow up' => 'Ticket verrouill aprs un suivi',
        'Systemaddress' => 'Adresse du Systme',
        'Customer Move Notify' => 'Notification lors d\'un changement de file',
        'Customer State Notify' => 'Notification lors d\'un changement d\'tat',
        'Customer Owner Notify' => 'Notification lors d\'un changement de propritaire',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un technicien verrouille un ticket et qu\'il/elle n\'envoie pas une rponse dans le temps imparti, le ticket sera dverrouill automatiquement. Le ticket sera alors visible de tous les autres techniciens',
        'Escalation time' => 'Dlai de remont du ticket',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Si un ticket n\'est pas rpondu dans le temps imparti, ce ticket sera seulement affich',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si un ticket est clotur et que le client envoie une note, le ticket sera verrouill pour l\'ancien propritaire',
        'Will be the sender address of this queue for email answers.' => 'Sera l\'adresse d\'expdition pour les rponses par courriel.',
        'The salutation for email answers.' => 'La formule de politesse pour les rponses par mail',
        'The signature for email answers.' => 'La signature pour les rponses par courriel',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS envoit un courriel au client ilorsque le ticket change de file.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS envoit un courriel au client lorsque le ticket change d\'tat.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS envoit un courriel au client lorsque le ticket change de propritaire.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Rponses <-> Gestion des files',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Rponse',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Rponses <-> Gestion des pices jointes',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Gestion des rponses',
        'A response is default text to write faster answer (with default text) to customers.' => 'Une rponse est un texte par dfaut destin  rdiger plus rapidement des rponses standard aux clients.',
        'Don\'t forget to add a new response a queue!' => 'Ne pas oublier d\'ajouter une file  une nouvelle rponse !',
        'The current ticket state is' => 'L\'tat actuel du ticket est',
        'Your email address is new' => 'Votre adresse lectronique est nouvelle',

        # Template: AdminRoleForm
        'Role Management' => 'Gestion des Rles',
        'Add Role' => '',
        'Add a new Role.' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'Crer un rle et ',
        'It\'s useful for a lot of users and groups.' => 'Pratique lorsqu\'on a beaucoup d\'utilisateurs et de groupes',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Rles <-> Gestion des groupes',
        'move_into' => 'dplacer dans',
        'Permissions to move tickets into this group/queue.' => 'Permission de dplacer un ticket dans cette file/groupe.',
        'create' => 'crer',
        'Permissions to create tickets in this group/queue.' => 'Permission de crer un ticket dans cette file/groupe.',
        'owner' => 'propritaire',
        'Permissions to change the ticket owner in this group/queue.' => 'Permission de changer le propritaire d\'un ticket dans cette file/groupe.',
        'priority' => 'priorit',
        'Permissions to change the ticket priority in this group/queue.' => 'Permission de changer la priorit d\'un ticket dans cette file/groupe.',

        # Template: AdminRoleGroupForm
        'Role' => 'Rles',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Rles <-> Gestion des utilisateurs',
        'Active' => 'Actif',
        'Select the role:user relations.' => 'Slection des relations role/utilisateur',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Prfixes des messages',
        'Add Salutation' => '',
        'Add a new Salutation.' => '',

        # Template: AdminSelectBoxForm
        'Select Box' => 'Requte SQL libre.',
        'Limit' => 'Limite',
        'Go' => '',
        'Select Box Result' => 'Choisissez le rsultat',

        # Template: AdminService
        'Service Management' => '',
        'Add Service' => '',
        'Add a new Service.' => '',
        'Service' => '',
        'Sub-Service of' => '',

        # Template: AdminSession
        'Session Management' => 'Gestion des sessions',
        'Sessions' => '',
        'Uniq' => 'Unique',
        'Kill all sessions' => '',
        'Session' => '',
        'Content' => 'Contenu',
        'kill session' => 'Terminer une session',

        # Template: AdminSignatureForm
        'Signature Management' => 'Gestion des signatures',
        'Add Signature' => '',
        'Add a new Signature.' => '',

        # Template: AdminSLA
        'SLA Management' => '',
        'Add SLA' => '',
        'Add a new SLA.' => '',
        'SLA' => '',
        'First Response Time' => '',
        'Update Time' => '',
        'Solution Time' => '',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'Gestion S/MIME',
        'Add Certificate' => 'Ajouter un certificat',
        'Add Private Key' => 'Ajouter une cl prive',
        'Secret' => 'Secrt',
        'Hash' => 'Hashage',
        'In this way you can directly edit the certification and private keys in file system.' => 'Dans ce cas vous pouvez directement diter le certificat et la cl prive dans le systme de fichier',

        # Template: AdminStateForm
        'State Management' => '',
        'Add State' => '',
        'Add a new State.' => '',
        'State Type' => 'Type d\'tat',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Prennez garde de bien mettre  jour les tats par dfaut dans votre Kernel/Config.pm !',
        'See also' => 'Voir aussi',

        # Template: AdminSysConfig
        'SysConfig' => 'Configuration Systme',
        'Group selection' => 'Slection du groupe',
        'Show' => 'Voir',
        'Download Settings' => 'Paramettres de tlchargement',
        'Download all system config changes.' => 'Tlcharger tout les changements de la configuration systme.',
        'Load Settings' => 'Charger les parramettres',
        'Subgroup' => 'Sous-groupe',
        'Elements' => 'lements',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Options de configuration',
        'Default' => 'Dfaut',
        'New' => 'Nouveau',
        'New Group' => 'Nouveau groupe',
        'Group Ro' => 'Groupe lecture seule',
        'New Group Ro' => 'Nouveau groupe (lecture seule)',
        'NavBarName' => 'Nom de la barre de navigation',
        'NavBar' => 'Barre de navigation',
        'Image' => '',
        'Prio' => 'Priorit',
        'Block' => 'Bloc',
        'AccessKey' => 'Accs clavier',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Gestion des adresses courriel du systme',
        'Add System Address' => '',
        'Add a new System Address.' => '',
        'Realname' => 'Vritable Nom',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tous les courriels avec cette adresse en destinataire (:) seront rpartis dans la file slectionne !',

        # Template: AdminTypeForm
        'Type Management' => '',
        'Add Type' => '',
        'Add a new Type.' => '',

        # Template: AdminUserForm
        'User Management' => 'Administration des utilisateurs',
        'Add User' => '',
        'Add a new Agent.' => '',
        'Login as' => '',
        'Firstname' => 'Prnom',
        'Lastname' => 'Nom',
        'User will be needed to handle tickets.' => 'Un utilisateur sera ncessaire pour grer les tickets.',
        'Don\'t forget to add a new user to groups and/or roles!' => '',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Utilisateurs <-> Gestion des groupes',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Carnet d\'adresses',
        'Return to the compose screen' => 'Retourner  l\'cran de saisie',
        'Discard all changes and return to the compose screen' => 'Annuler tous les changements et retourner  l\'cran de saisie',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerTableView

        # Template: AgentInfo
        'Info' => 'Information',

        # Template: AgentLinkObject
        'Link Object' => '',
        'Select' => 'Slectionner',
        'Results' => 'Rsultat',
        'Total hits' => 'Total des hits',
        'Page' => '',
        'Detail' => 'Dtail',

        # Template: AgentLookup
        'Lookup' => 'Consulter',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Vrificateur orthographique',
        'spelling error(s)' => 'erreurs d\'orthographe',
        'or' => 'ou',
        'Apply these changes' => 'Appliquer ces changements',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Voulez vous vraiment effacer cet objet ?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => '',
        'Fixed' => '',
        'Please select only one Element or turn of the button \'Fixed\'.' => '',
        'Absolut Period' => '',
        'Between' => '',
        'Relative Period' => '',
        'The last' => '',
        'Finish' => '',
        'Here you can make restrictions to your stat.' => '',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributs of the corresponding element.' => '',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => '',
        'Permissions' => '',
        'Format' => '',
        'Graphsize' => '',
        'Sum rows' => '',
        'Sum columns' => '',
        'Cache' => '',
        'Required Field' => '',
        'Selection needed' => '',
        'Explanation' => '',
        'In this form you can select the basic specifications.' => '',
        'Attribute' => '',
        'Title of the stat.' => '',
        'Here you can insert a description of the stat.' => '',
        'Dynamic-Object' => '',
        'Here you can select the dynamic object you want to use.' => '',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '',
        'Static-File' => '',
        'For very complex stats it is possible to include a hardcoded file.' => '',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => '',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => '',
        'Multiple selection of the output format.' => '',
        'If you use a graph as output format you have to select at least one graph size.' => '',
        'If you need the sum of every row select yes' => '',
        'If you need the sum of every column select yes.' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => '',
        '(Note: Useful for big databases and low performance server)' => '',
        'With an invalid stat it isn\'t feasible to generate a stat.' => '',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => '',
        'Scale' => '',
        'minimal' => '',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '',
        'Here you can the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => '',
        'maximal period' => '',
        'minimal scale' => '',
        'Here you can define the x-axis. You can select one element via the radio button. Than you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => '',
        'File is not a Stats config' => '',
        'No File selected' => '',

        # Template: AgentStatsOverview
        'Object' => '',

        # Template: AgentStatsPrint
        'Print' => 'Imprimer',
        'No Element selected.' => '',

        # Template: AgentStatsView
        'Export Config' => '',
        'Informations about the Stat' => '',
        'Exchange Axis' => '',
        'Configurable params of static stat' => '',
        'No element selected.' => '',
        'maximal period from' => '',
        'to' => '',
        'Start' => '',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketBounce
        'Bounce ticket' => 'Renvoyer le ticket',
        'Ticket locked!' => 'Ticket verrouill !',
        'Ticket unlock!' => 'Rendre le ticket !',
        'Bounce to' => 'Renvoyer ',
        'Next ticket state' => 'Prochain tat du ticket',
        'Inform sender' => 'Informer l\'emetteur',
        'Send mail!' => 'Envoyer le courriel !',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Ticket en action group',
        'Spell Check' => 'Vrification orthographique',
        'Note type' => 'Type de note',
        'Unlock Tickets' => 'Dvrouiller Tickets',

        # Template: AgentTicketClose
        'Close ticket' => 'Ticket clos',
        'Previous Owner' => 'Propritaire Prcdent',
        'Inform Agent' => 'Informer l\'agent',
        'Optional' => 'Optionnel',
        'Inform involved Agents' => 'Informer les agents impliqus',
        'Attach' => 'Attach',
        'Next state' => 'tat suivant',
        'Pending date' => 'Dlais d\'attente',
        'Time units' => 'Unit de temps',

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Rdiger une rponse pour le ticket',
        'Pending Date' => 'En attendant la date',
        'for pending* states' => 'pour tous les tats d\'attente',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Changer le client du ticket',
        'Set customer user and customer id of a ticket' => 'Assigner un utilisateur client et un identifiant client pour le ticket.',
        'Customer User' => 'Client Utilisateur',
        'Search Customer' => 'Recherche de client',
        'Customer Data' => 'Donnes client',
        'Customer history' => 'Historique du client',
        'All customer tickets.' => 'Tout les tickets du client',

        # Template: AgentTicketCustomerMessage
        'Follow up' => 'Note',

        # Template: AgentTicketEmail
        'Compose Email' => 'crire un courriel',
        'new ticket' => 'nouveau ticket',
        'Refresh' => '',
        'Clear To' => 'Effacer la zone de saisie "De:"',

        # Template: AgentTicketForward
        'Article type' => 'Type d\'article',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Changer le texte libre du ticket',

        # Template: AgentTicketHistory
        'History of' => 'Historique de',

        # Template: AgentTicketLocked

        # Template: AgentTicketMailbox
        'Mailbox' => 'Bo&icirc;te aux lettres',
        'Tickets' => '',
        'of' => 'de',
        'Filter' => '',
        'New messages' => 'Nouveaux messages',
        'Reminder' => 'Rappel',
        'Sort by' => 'Trier par',
        'Order' => 'Ordre',
        'up' => 'vers le haut',
        'down' => 'vers le bas',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Fusion de Ticket',
        'Merge to' => 'Fusionner avec',

        # Template: AgentTicketMove
        'Move Ticket' => 'Changer la file du ticket',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Ajouter une note au ticket',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Changer le propritaire du ticket',

        # Template: AgentTicketPending
        'Set Pending' => 'Dfinir l\'attente',

        # Template: AgentTicketPhone
        'Phone call' => 'Appel tlphonique',
        'Clear From' => 'Vider le formulaire',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Tel quel',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Information du Ticket',
        'Accounted time' => 'Temp pass',
        'Escalation in' => 'Remonte dans',
        'Linked-Object' => 'Objet li',
        'Parent-Object' => 'Objet Parent',
        'Child-Object' => 'Objet Enfant',
        'by' => 'par',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Modification de la priorit du ticket',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Tickets affichs',
        'Tickets available' => 'Tickets disponibles',
        'All tickets' => 'tous les tickets',
        'Queues' => 'Files',
        'Ticket escalation!' => 'Remonte du ticket !',

        # Template: AgentTicketQueueTicketView
        'Service Time' => '',
        'Your own Ticket' => 'Votre propre ticket',
        'Compose Follow up' => 'Fermer le suivi',
        'Compose Answer' => 'Rdiger une rponse',
        'Contact customer' => 'Contacter le client',
        'Change queue' => 'Changer de file',

        # Template: AgentTicketQueueTicketViewLite

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => '',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Recherche de ticket',
        'Profile' => 'Profil',
        'Search-Template' => 'Profil de recherche',
        'TicketFreeText' => 'Texte Libre du Ticket',
        'Created in Queue' => 'Cr dans la file',
        'Result Form' => 'Format du rsultat',
        'Save Search-Profile as Template?' => 'Sauver le profil de recherche ?',
        'Yes, save it with name' => 'Oui, le sauver avec le nom',

        # Template: AgentTicketSearchResult
        'Search Result' => 'Rsultat de la recherche',
        'Change search options' => 'Changer les options de recherche',

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketSearchResultShort
        'U' => 'A-Z',
        'D' => 'Z-A',

        # Template: AgentTicketStatusView
        'Ticket Status View' => 'Vue de l\'tat du ticket',
        'Open Tickets' => 'Tickets ouverts',
        'Locked' => 'Vrrouill',

        # Template: AgentTicketZoom

        # Template: AgentWindowTab

        # Template: Copyright

        # Template: css

        # Template: customer-css

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Trace du retour d\'erreur',

        # Template: CustomerFooter
        'Powered by' => 'Fonction assure par',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'S\'authentifier',
        'Lost your password?' => 'Mot de passe perdu ?',
        'Request new password' => 'Demande de nouveau mot de passe',
        'Create Account' => 'Crer un compte',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Bienvenue %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Fois',
        'No time settings.' => 'Pas de paramtre de temps',

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Cliquer ici pour signaler une anomalie !',

        # Template: Footer
        'Top of Page' => 'Haut de page',

        # Template: FooterSmall

        # Template: Header

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Installeur Web',
        'Accept license' => '',
        'Don\'t accept license' => '',
        'Admin-User' => 'Administrateur',
        'Admin-Password' => 'Mot de passe de l\'administrateur',
        'your MySQL DB should have a root password! Default is empty!' => 'Votre base MySQL doit avoir un mot de passe root ! Par dfaut cela est vide !',
        'Database-User' => 'Nom de l\'utilisateur de la base de donne',
        'default \'hot\'' => 'hte par dfaut',
        'DB connect host' => 'Nom d\'hte de la base de donne',
        'Database' => 'Base de donne',
        'false' => 'faux',
        'SystemID' => 'ID Systme',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(L\'identit du systme. Chaque numro de ticket et chaque id de session http commence avec ce nombre)',
        'System FQDN' => 'Nom de Domaine complet du systme',
        '(Full qualified domain name of your system)' => '(Nom de domaine complet de votre machine)',
        'AdminEmail' => 'Courriel de l\'administrateur.',
        '(Email of the system admin)' => '(Adresse de l\'administrateur systme)',
        'Organization' => 'Socit',
        'Log' => '',
        'LogModule' => 'Module de log',
        '(Used log backend)' => '(Backend de log utilis)',
        'Logfile' => 'fichier de log',
        '(Logfile just needed for File-LogModule!)' => '(fichier de log ncessaire pour le Module File-Log !)',
        'Webfrontend' => 'Frontal web',
        'Default Charset' => 'Charset par dfaut',
        'Use utf-8 it your database supports it!' => 'Utilisez UTF-8 si votre base de donne le supporte !',
        'Default Language' => 'Langage par dfaut ',
        '(Used default language)' => '(Langage par dfaut utilis)',
        'CheckMXRecord' => 'Vrifier les enregistrements MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Verifie les enregistrements MX des adresses lectroniques utilises lors de la rdaction d\'une rponse. N\'utilisez pas la "Vrification des enregistrements MX" si votre serveur OTRS est derrire une ligne modem $!',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Pour pouvoir utiliser OTRS, vous devez entrer les commandes suivantes dans votre terminal en tant que root.',
        'Restart your webserver' => 'Redmarrer votre serveur web',
        'After doing so your OTRS is up and running.' => 'Aprs avoir fait ceci votre OTRS est en service',
        'Start page' => 'Page de dmarrage',
        'Have a lot of fun!' => 'Amusez vous bien !',
        'Your OTRS Team' => 'Votre quipe OTRS',

        # Template: Login
        'Welcome to %s' => 'Bienvenue dans %s',

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Pas d\'autorisation',

        # Template: Notify
        'Important' => '',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'Imprim par :',

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'Page de test d\'OTRS',
        'Counter' => 'Compteur',

        # Template: Warning
        # Misc
        'Edit Article' => '',
        'Create Database' => 'Crer la base de donnes',
        'DB Host' => 'Nom d\'hte de la base',
        'Change roles <-> groups settings' => 'Changer les rles <-> paramttres des groupes',
        'Ticket Number Generator' => 'Gnrateur de numro pour les tickets',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiiant des tickets. Certaines personnes veulent le configurer avec par ex: \'Ticket#\', \'Appel#\' ou \'MonTicket#\')',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Dans ce cas vous pouvez directement diter le trousseau de cl dans Kernel/Config.pm',
        'Create new Phone Ticket' => 'Saisie d\'une demande tlphonique',
        'Symptom' => 'Symptme',
        'A message should have a To: recipient!' => 'Un message doit avoir un destinataire (:)!',
        'Site' => 'Site',
        'Customer history search (e. g. "ID342425").' => 'Recherche dans l\'historique client (ex: "ID342425")',
        'Close!' => 'Clture!',
        'for agent firstname' => 'pour le prnom du technicien',
        'The message being composed has been closed.  Exiting.' => 'Le message en cours de rdaction a t cltur. Sortie.',
        'A web calendar' => 'Un calendrier Web',
        'to get the realname of the sender (if given)' => 'pour avoir le nom rel de l\'utilisateur (s\il est donn)',
        'FAQ Search Result' => 'Rsultat de la recherche dans la FAQ',
        'OTRS DB Name' => 'Nom de la base OTRS',
        'Notification (Customer)' => '',
        'FAQ Category' => 'Catgorie dans la FAQ',
        'Select Source (for add)' => 'Slectionnez une source (pour ajout)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
        'New FAQ Article' => '(FAQ) Nouvel article',
        'Days' => 'Jours',
        'Queue ID' => 'Identifiant de la File',
        'Home' => 'Accueil',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Options de configuration (ex: <OTRS_CONFIG_HttpType>)',
        'System History' => 'Historique du systme',
        'FAQ System History' => 'Historique systme de la FAQ',
        'customer realname' => 'nom rel du client',
        'Pending messages' => 'Message en attente',
        'Modules' => 'Modules',
        'for agent login' => 'pour le nom de connexion (login) du technicien',
        'Keyword' => 'Mot cl',
        'Close type' => 'Type de clture',
        'FAQ-Article' => '(FAQ) Article',
        'DB Admin User' => 'nom de connexion de l\'administrateur base de donne',
        'for agent user id' => 'pour l\'identifiant du technicien',
        'sort upward' => 'Tri croissant',
        'Change user <-> group settings' => 'Modifier les paramtres utilisateurs <-> groupes',
        'FAQ-Area' => 'Foire Aux Questions',
        'Problem' => 'Problme',
        'next step' => 'tape suivante',
        'Customer history search' => 'Recherche dans l\'historique client',
        'Admin-Email' => 'Email de l\'administrateur',
        'Create new database' => 'Crer une nouvelle base de donnes',
        'A message must be spell checked!' => 'Lorthographe dun message doit tre vrifi!',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Votre message concernant le ticket numro "<OTRS_TICKET> est rmis  "<OTRS_BOUNCE_TO>". Contactez cette adresse pour de plus amples renseignements',
        'FAQ Language' => 'Langue dans la FAQ',
        'ArticleID' => 'Identifiant de l\'Article',
        'A message should have a body!' => 'Un message doit avoir un corp !',
        'All Agents' => 'Tous les techniciens',
        'Keywords' => 'Mots cls',
        'No * possible!' => 'Pas de * possible !',
        'Options ' => 'Options',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
        'Message for new Owner' => 'Message pour le nouveau propritaire',
        'to get the first 5 lines of the email' => 'pour avoir les 5 premires ligne du mail',
        'OTRS DB Password' => 'Mot de passe de la base OTRS',
        'Last update' => 'Dernire mise  jour',
        'to get the first 20 character of the subject' => 'pour avoir les 20 premiers caractres du sujet ',
        'DB Admin Password' => 'Mot de passe administrateur base de donnes',
        'Drop Database' => 'Effacer la base de donnes',
        'Advisory' => 'Avertissement',
        'FileManager' => 'Gestionnaire de fichiers',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Options concernant les donnes du client actuel (ex: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'Type d\'attente',
        'Comment (internal)' => 'Commentaire interne',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',
        'This window must be called from compose window' => 'Cette fentre doit tre appele de la fentre depuis la fentre de rdaction',
        'FAQ-Search' => '(FAQ) Rechercher',
        'You need min. one selected Ticket!' => 'Vous devez nommer au moins un Ticket!',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        '(Used ticket number format)' => '(Format numrique utilis pour les tickets)',
        'Fulltext' => 'Texte Complet',
        'OTRS DB connect host' => 'Hte de la base OTRS',
        ' (work units)' => ' Unit de travail',
        'All Customer variables like defined in config option CustomerUser.' => 'Toutes les variables client tels que dfinies dans les options "Client utilisateur"',
        'accept license' => 'Accepter la licence',
        'for agent lastname' => 'pour le nom du technicien',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Options concernant l\'utilisateur actuel ayant effectu cet action (ex: <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Message de rappel',
        'Change users <-> roles settings' => 'Changement d\'utilisateur <-> parramttres des rles',
        'A message should have a subject!' => 'Un message doit avoir un sujet !',
        'TicketZoom' => 'Vue en dtails',
        'Don\'t forget to add a new user to groups!' => 'Ne pas oublier d\'ajouter un nouvel utilisateur aux groupes !',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Il faut une adresse courriel (ex&nbsp;: client@exemple.fr)&nbsp;!',
        'CreateTicket' => 'Crer Ticket',
        'You need to account time!' => 'Vous devez avoir un compte de temps&nbsp;!',
        'System Settings' => 'Paramtres Systme',
        'WebWatcher' => '',
        'Hours' => 'Heures',
        'Finished' => 'Fini',
        'Account Type' => '',
        'Split' => 'Scinder',
        'All messages' => 'Tous les messages',
        'System Status' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'A article should have a title!' => 'Un article doit avoir un titre',
        'FAQ Overview' => 'Vue d\'ensemble de la FAQ',
        'Event' => '',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
        'don\'t accept license' => 'Ne pas accepter la licence',
        'A web mail client' => 'Un logiciel de messagerie via le web',
        'FAQ-State' => '(FAQ) tat',
        'WebMail' => 'Webmail',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Options du propritaire d\'un ticket (ex: <OTRS_OWNER_UserFirstname>)',
        'FAQ Search' => 'Chercher dans la FAQ',
        'Name is required!' => 'Un nom est requis!',
        'DB Type' => 'Type de SGBD',
        'Termin1' => 'Termin1',
        'kill all sessions' => 'Terminer toutes les sessions',
        'to get the from line of the email' => 'pour avoir les lignes \'De\' du courriel',
        'Solution' => 'Solution',
        'QueueView' => 'Vue file',
        'Welcome to OTRS' => '',
        'modified' => 'modifi',
        'Delete old database' => 'Effacer l\'ancienne base de donnes',
        'sort downward' => 'Tri dcroissant',
        'You need to use a ticket number!' => 'Vous devez utiliser un numro de ticket!',
        'A web file manager' => 'Un gestionnaire de fichier via le web',
        'send' => 'envoyer',
        'Note Text' => 'Note',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
        'System State Management' => 'Gestion des tats du systme',
        'OTRS DB User' => 'Utilisateur de la base OTRS',
        'PhoneView' => 'Vue tlphone',
        'maximal period form' => '',
        'Verion' => 'Version',
        'TicketID' => 'Identifiant du Ticket',
        'FAQ History' => 'Historique de la FAQ',
        'Modified' => 'Modifi',
        'Ticket selected for bulk action!' => 'Ticket slectionn pour une action group!',
    };
    # $$STOP$$
}

1;
