# --
# Kernel/Language/pt.pm - provides pt language translation
# Copyright (C) 2004-2007 CAT - Filipe Henriques <filipehenriques at ip.pt>
# --
# $Id: pt.pm,v 1.74 2009/04/20 08:35:54 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::pt;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.74 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Mon Apr 20 10:29:13 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%Y-%M-%D %T';
    $Self->{DateFormatLong}      = '%A, %D de %B de %Y, %T';
    $Self->{DateFormatShort}     = '%Y-%M-%D';
    $Self->{DateInputFormat}     = '%Y-%M-%D';
    $Self->{DateInputFormatLong} = '%Y-%M-%D - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Sim',
        'No' => 'No',
        'yes' => 'sim',
        'no' => 'no',
        'Off' => 'Desligado',
        'off' => 'desligado',
        'On' => 'Ligado',
        'on' => 'ligado',
        'top' => 'incio',
        'end' => 'fim',
        'Done' => 'Feito',
        'Cancel' => 'Cancelar',
        'Reset' => 'Limpar',
        'last' => 'nos ltimos',
        'before' => 'h mais de',
        'day' => 'dia',
        'days' => 'dias',
        'day(s)' => 'dia(s)',
        'hour' => 'hora',
        'hours' => 'horas',
        'hour(s)' => 'hora(s)',
        'minute' => 'minuto',
        'minutes' => 'minutos',
        'minute(s)' => 'minuto(s)',
        'month' => 'ms',
        'months' => 'meses',
        'month(s)' => 'mes(ses)',
        'week' => 'semana',
        'week(s)' => 'semana(s)',
        'year' => 'ano',
        'years' => 'anos',
        'year(s)' => 'ano(s)',
        'second(s)' => 'segundo(s)',
        'seconds' => 'segundos',
        'second' => 'segundo',
        'wrote' => 'escreveu',
        'Message' => 'Mensagem',
        'Error' => 'Erro',
        'Bug Report' => 'Relatrio de Erros',
        'Attention' => 'Ateno',
        'Warning' => 'Aviso',
        'Module' => 'Mdulo',
        'Modulefile' => 'Ficheiro de Mdulo',
        'Subfunction' => 'Subfuno',
        'Line' => 'Linha',
        'Example' => 'Exemplo',
        'Examples' => 'Exemplos',
        'valid' => 'vlido',
        'invalid' => 'invlido',
        '* invalid' => '* invlido',
        'invalid-temporarily' => 'invlido-temporariamente',
        ' 2 minutes' => ' 2 minutos',
        ' 5 minutes' => ' 5 minutos',
        ' 7 minutes' => ' 7 minutos',
        '10 minutes' => '10 minutos',
        '15 minutes' => '15 minutos',
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Next' => 'Prximo',
        'Back' => 'Voltar',
        'Next...' => 'Prximo...',
        '...Back' => '...Voltar',
        '-none-' => '-nenhum(a)-',
        'none' => 'nenhum(a)',
        'none!' => 'nenhum(a)!',
        'none - answered' => 'nenhum - respondido',
        'please do not edit!' => 'por favor no editar!',
        'AddLink' => 'Adicionar Ligao',
        'Link' => 'Ligar',
        'Unlink' => '',
        'Linked' => 'Ligado',
        'Link (Normal)' => 'Ligar (Normal)',
        'Link (Parent)' => 'Ligar (Ascendente)',
        'Link (Child)' => 'Ligar (Descendente)',
        'Normal' => 'Normal',
        'Parent' => 'Ascendente',
        'Child' => 'Descendente',
        'Hit' => 'Acerto',
        'Hits' => 'Acertos',
        'Text' => 'Texto',
        'Lite' => 'Leve',
        'User' => 'Utilizador',
        'Username' => 'Nome de utilizador',
        'Language' => 'Idioma',
        'Languages' => 'Idiomas',
        'Password' => 'Palavra-passe',
        'Salutation' => 'Saudao',
        'Signature' => 'Assinatura',
        'Customer' => 'Cliente',
        'CustomerID' => 'ID de Cliente',
        'CustomerIDs' => 'ID de Cliente',
        'customer' => 'cliente',
        'agent' => 'agente',
        'system' => 'sistema',
        'Customer Info' => 'Informao de Cliente',
        'Customer Company' => 'Companhia do Cliente',
        'Company' => 'Companhia',
        'go!' => 'ir!',
        'go' => 'ir',
        'All' => 'Todos',
        'all' => 'todos',
        'Sorry' => 'Desculpe',
        'update!' => 'actualizar!',
        'update' => 'actualizar',
        'Update' => 'Actualizar',
        'Updated!' => '',
        'submit!' => 'submeter!',
        'submit' => 'Submeter',
        'Submit' => 'Submeter',
        'change!' => 'alterar!',
        'Change' => 'Alterar',
        'change' => 'alterar',
        'click here' => 'clique aqui',
        'Comment' => 'Comentrio',
        'Valid' => 'Vlido',
        'Invalid Option!' => 'Opo Invlida!',
        'Invalid time!' => 'Hora invlida!',
        'Invalid date!' => 'Data invlida!',
        'Name' => 'Nome',
        'Group' => 'Grupo',
        'Description' => 'Descrio',
        'description' => 'descrio',
        'Theme' => 'Tema',
        'Created' => 'Criado',
        'Created by' => 'Criado por',
        'Changed' => 'Modificado',
        'Changed by' => 'Modificado por',
        'Search' => 'Procurar',
        'and' => 'e',
        'between' => 'entre',
        'Fulltext Search' => 'Procura Exaustiva no Texto',
        'Data' => 'Data',
        'Options' => 'Opes',
        'Title' => 'Ttulo',
        'Item' => 'Item',
        'Delete' => 'Eliminar',
        'Edit' => 'Editar',
        'View' => 'Ver',
        'Number' => 'Nmero',
        'System' => 'Sistema',
        'Contact' => 'Contacto',
        'Contacts' => 'Contactos',
        'Export' => 'Exportar',
        'Up' => 'Subir',
        'Down' => 'Descer',
        'Add' => 'Adicionar',
        'Added!' => '',
        'Category' => 'Categoria',
        'Viewer' => 'Visualizador',
        'Expand' => '',
        'New message' => 'Nova mensagem',
        'New message!' => 'Nova mensagem!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor, responda a este(s) ticket(s) para regressar  visualizao de filas!',
        'You got new message!' => 'Tem uma mensagem nova!',
        'You have %s new message(s)!' => 'Tem %s mensagem(s) nova(s)!',
        'You have %s reminder ticket(s)!' => 'Tem %s lembrete(s)!',
        'The recommended charset for your language is %s!' => 'O cdigo recomendado para o seu idioma  %s!',
        'Passwords doesn\'t match! Please try it again!' => 'As palavras-passe no correspondem! Tente de novo!',
        'Password is already in use! Please use an other password!' => 'A palavra-passe est j em uso! Por favor use outra!',
        'Password is already used! Please use an other password!' => 'A palavra-passe j foi usada! Por favor use outra!',
        'You need to activate %s first to use it!' => 'Tem de activar %s antes de o usar!',
        'No suggestions' => 'Sem sugestes',
        'Word' => 'Palavra',
        'Ignore' => 'Ignorar',
        'replace with' => 'substituir por',
        'There is no account with that login name.' => 'No existe nenhuma conta com esse nome de utilizador',
        'Login failed! Your username or password was entered incorrectly.' => 'Entrada falhou! Ou o nome de utilizador ou a palavra-passe foram introduzidos incorrectamente.',
        'Please contact your admin' => 'Por favor contactar o seu administrador de sistemas',
        'Logout successful. Thank you for using OTRS!' => 'Saiu com sucesso. Obrigado por utilizar o OTRS!',
        'Invalid SessionID!' => 'ID de Sesso Invlido',
        'Feature not active!' => 'Caracterstica no activa!',
        'Login is needed!' => 'Entrada necessria',
        'Password is needed!' => 'Palavra-passe indispensvel!',
        'License' => 'Licena',
        'Take this Customer' => 'Fique com este Cliente',
        'Take this User' => 'Fique com este Utilizador',
        'possible' => 'possvel',
        'reject' => 'rejeitar',
        'reverse' => 'reverter',
        'Facility' => 'Instalao',
        'Timeover' => 'Tempo a mais',
        'Pending till' => 'Pendente at',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabalhe com o UserID 1 (Conta de sistema)! Crie novos utilizadores!',
        'Dispatching by email To: field.' => 'Despachado atravs do campo Para:',
        'Dispatching by selected Queue.' => 'Despachado pela Fila escolhida',
        'No entry found!' => 'No se encontrou nada!',
        'Session has timed out. Please log in again.' => 'A sesso expirou. Por favor autentique-se novamente',
        'No Permission!' => 'Sem Permisso!',
        'To: (%s) replaced with database email!' => 'Para: (%s) substitudo pelo endereo na base de dados!',
        'Cc: (%s) added database email!' => 'Cc: (%s) acrescentado endereo na base de dados!',
        '(Click here to add)' => '(Clique aqui para adicionar)',
        'Preview' => 'Prever',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Pacote no correctamente entregue! Dever reinstalar o pacote.',
        'Added User "%s"' => 'Acrescentado Utilizador "%s"',
        'Contract' => 'Contrato',
        'Online Customer: %s' => 'Cliente em linha: %s',
        'Online Agent: %s' => 'Agente em linha: %s',
        'Calendar' => 'Calendrio',
        'File' => 'Ficheiro',
        'Filename' => 'Nome de ficheiro',
        'Type' => 'Tipo',
        'Size' => 'Tamanho',
        'Upload' => 'Carregar',
        'Directory' => 'Pasta',
        'Signed' => 'Assinado',
        'Sign' => 'Assinar',
        'Crypted' => 'Cifrado',
        'Crypt' => 'Cifrar',
        'Office' => 'Gabinete',
        'Phone' => 'Telefone',
        'Fax' => '',
        'Mobile' => 'Movel',
        'Zip' => 'Codigo Postal',
        'City' => 'Cidade',
        'Street' => 'Rua',
        'Country' => 'Pais',
        'Location' => 'Localizao',
        'installed' => 'instalado',
        'uninstalled' => 'desinstalado',
        'Security Note: You should activate %s because application is already running!' => 'Nota de Segurana:  necessrio activar %s porque a aplicao j est a ser executada',
        'Unable to parse Online Repository index document!' => 'No  possivel verificar o ficheiro index do Repositrio',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'No existe pacotes no Framework pedido neste Repositrio, mas pacotes de outro Frameworks',
        'No Packages or no new Packages in selected Online Repository!' => 'No existe pacotes no Repositrio selecionado',
        'printed at' => 'imprimido em',
        'Dear Mr. %s,' => '',
        'Dear Mrs. %s,' => '',
        'Dear %s,' => '',
        'Hello %s,' => '',
        'This account exists.' => '',
        'New account created. Sent Login-Account to %s.' => '',
        'Please press Back and try again.' => '',
        'Sent password token to: %s' => '',
        'Sent new password to: %s' => '',
        'Invalid Token!' => '',
        'For more info see:' => '',
        'Package verification failed!' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Header' => 'Cabealho',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'Jan',
        'Feb' => 'Fev',
        'Mar' => 'Mar',
        'Apr' => 'Abr',
        'May' => 'Maio',
        'Jun' => 'Jun',
        'Jul' => 'Jul',
        'Aug' => 'Ago',
        'Sep' => 'Set',
        'Oct' => 'Out',
        'Nov' => 'Nov',
        'Dec' => 'Dez',
        'January' => 'Janeiro',
        'February' => 'Fevereiro',
        'March' => 'Maro',
        'April' => 'Abril',
        'June' => 'Junho',
        'July' => 'Julho',
        'August' => 'Agosto',
        'September' => 'Setembro',
        'October' => 'Outubro',
        'November' => 'Novembro',
        'December' => 'Dezembro',

        # Template: AAANavBar
        'Admin-Area' => 'rea de Administrao',
        'Agent-Area' => 'rea de Agente',
        'Ticket-Area' => 'rea de Tickets',
        'Logout' => 'Sair',
        'Agent Preferences' => 'Preferncias de Agente',
        'Preferences' => 'Preferncias',
        'Agent Mailbox' => 'Caixa do Correio do Agente',
        'Stats' => 'Estatsticas',
        'Stats-Area' => 'rea de Estatsticas',
        'Admin' => 'Administrao',
        'Customer Users' => 'Utilizadores Clientes',
        'Customer Users <-> Groups' => 'Utilizadores Clientes <-> Grupos',
        'Users <-> Groups' => 'Utilizadores <-> Grupos',
        'Roles' => 'Papeis',
        'Roles <-> Users' => 'Papeis <-> Utilizadores',
        'Roles <-> Groups' => 'Papeis <-> Grupos',
        'Salutations' => 'Saudaes',
        'Signatures' => 'Assinaturas',
        'Email Addresses' => 'Endereos de Correio Electrnico',
        'Notifications' => 'Notificaes',
        'Category Tree' => 'rvore de Categorias',
        'Admin Notification' => 'Notificaes de Administrao',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Preferncias actualizadas com sucesso!',
        'Mail Management' => 'Gesto de Correio Electrnico',
        'Frontend' => 'Interface',
        'Other Options' => 'Outras Opes',
        'Change Password' => 'Mudar a Palavra-passe',
        'New password' => 'Nova palavra-passe',
        'New password again' => 'De novo',
        'Select your QueueView refresh time.' => 'Selecione o tempo de refrescamento da Visualizao de Filas.',
        'Select your frontend language.' => 'Selecione o idioma da interface.',
        'Select your frontend Charset.' => 'Selecione a codificao da interface.',
        'Select your frontend Theme.' => 'Selecione o tema da sua interface.',
        'Select your frontend QueueView.' => 'Selecione a Visualizao de Filas da Interface.',
        'Spelling Dictionary' => 'Dicionrio Ortogrfico',
        'Select your default spelling dictionary.' => 'Seleccione o dicionrio ortogrfico por omisso.',
        'Max. shown Tickets a page in Overview.' => 'Nmero mximo de tickets por pgina em Viso Geral.',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => 'Impossvel actualizar a palavra-passe: as palavras-passe no correspondem! Tente de novo!',
        'Can\'t update password, invalid characters!' => 'Impossvel actualizar palavra-passe: caracteres invlidos!',
        'Can\'t update password, need min. 8 characters!' => 'Impossvel actualizar palavra-passe: necessrios pelo menos oito caracteres!',
        'Can\'t update password, need 2 lower and 2 upper characters!' => 'Impossvel actualizar palavra-passe: pelo menos duas minsculas e duas maisculas!',
        'Can\'t update password, need min. 1 digit!' => 'Impossvel actualizar palavra-passe: pelo menos um dgito!',
        'Can\'t update password, need min. 2 characters!' => 'Impossvel actualizar palavra-passe: pelo menos um caractere!',

        # Template: AAAStats
        'Stat' => 'Relatorios',
        'Please fill out the required fields!' => ' necessrio preencher os campos necessrios',
        'Please select a file!' => ' necessrio escolher um ficheiro',
        'Please select an object!' => ' necessrio escolher um objecto',
        'Please select a graph size!' => ' necessrio escolher um tamanho de grfico',
        'Please select one element for the X-axis!' => ' necessrio escolher um elemento',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Slecione apenas um elemento ou desligue a opo Fixed onde o campo selecionado  marcado',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Se utilizar o campo selecionavel ter de selecionar alguns atributos do campo slecionado',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Insira um valor no campo a selecionar ou retire o visto da caixa.',
        'The selected end time is before the start time!' => '',
        'You have to select one or more attributes from the select field!' => 'Ter de seleccionar um ou mais atributos do campo seleccionado',
        'The selected Date isn\'t valid!' => 'A data selecionada nao  valida',
        'Please select only one or two elements via the checkbox!' => 'Seleccione um ou dois elementos da caixa',
        'If you use a time scale element you can only select one element!' => 'Se usar um elemento de escala de tempo s pode selecionar um elemento',
        'You have an error in your time selection!' => 'Existe um erro na seleco de tempo',
        'Your reporting time interval is too small, please use a larger time scale!' => 'O intervalo tempo de report  muito pequeno',
        'The selected start time is before the allowed start time!' => 'O tempo selecionado  antes do inicio do tempo permitido',
        'The selected end time is after the allowed end time!' => 'O tempo selecionado  depois do fim do tempo permitido',
        'The selected time period is larger than the allowed time period!' => 'O intervalo de tempo  suporior ao permitido',
        'Common Specification' => 'Especificaes Comuns',
        'Xaxis' => 'Eixo X',
        'Value Series' => 'Valores das Series',
        'Restrictions' => 'Restrices',
        'graph-lines' => '',
        'graph-bars' => '',
        'graph-hbars' => '',
        'graph-points' => '',
        'graph-lines-points' => '',
        'graph-area' => '',
        'graph-pie' => '',
        'extended' => '',
        'Agent/Owner' => 'Agente',
        'Created by Agent/Owner' => 'Criado por Agente',
        'Created Priority' => 'Prioridade Criada',
        'Created State' => 'Estado de Prioridade',
        'Create Time' => 'Tempo de prioridade',
        'CustomerUserLogin' => 'AcessoCliente',
        'Close Time' => 'Tempo de Fecho',
        'TicketAccumulation' => '',
        'Attributes to be printed' => '',
        'Sort sequence' => '',
        'Order by' => '',
        'Limit' => 'Limite',
        'Ticketlist' => '',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '',
        'Total Time' => '',
        'Ticket Average' => '',
        'Ticket Min Time' => '',
        'Ticket Max Time' => '',
        'Number of Tickets' => '',
        'Article Average' => '',
        'Article Min Time' => '',
        'Article Max Time' => '',
        'Number of Articles' => '',
        'Accounted time by Agent' => '',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => '',
        'Ticket Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Bloquear',
        'Unlock' => 'Desbloquear',
        'History' => 'Histrico',
        'Zoom' => 'Pormenores',
        'Age' => 'Idade',
        'Bounce' => 'Devolver',
        'Forward' => 'Encaminhar',
        'From' => 'De',
        'To' => 'Para',
        'Cc' => '',
        'Bcc' => '',
        'Subject' => 'Assunto',
        'Move' => 'Mover',
        'Queue' => 'Fila',
        'Priority' => 'Prioridade',
        'Priority Update' => '',
        'State' => 'Estado',
        'Compose' => 'Compr',
        'Pending' => 'Pendncias',
        'Owner' => 'Proprietrio',
        'Owner Update' => 'Actualizar Proprietrio',
        'Responsible' => 'Responsabilidade',
        'Responsible Update' => 'Actualizao da Responsabilidade',
        'Sender' => 'Remetente',
        'Article' => 'Artigo',
        'Ticket' => 'Ticket',
        'Createtime' => 'Hora de criao',
        'plain' => 'verbatim',
        'Email' => 'Correio Electrnico',
        'email' => 'correio electrnico',
        'Close' => 'Fechar',
        'Action' => 'Aco',
        'Attachment' => 'Anexo',
        'Attachments' => 'Anexos',
        'This message was written in a character set other than your own.' => 'Esta mensagem foi escrita usando uma codificao diferente da sua.',
        'If it is not displayed correctly,' => 'Se no for exibida correctamente,',
        'This is a' => 'Este  um',
        'to open it in a new window.' => 'para a abrir em nova janela.',
        'This is a HTML email. Click here to show it.' => 'Esta  uma mensagem HTML. Clicar aqui para a mostrar.',
        'Free Fields' => 'Campos Livres',
        'Merge' => 'Juntar',
        'merged' => 'junto',
        'closed successful' => 'fechado com sucesso',
        'closed unsuccessful' => 'fechado sem sucesso',
        'new' => 'novo',
        'open' => 'aberto',
        'Open' => '',
        'closed' => 'fechado',
        'Closed' => '',
        'removed' => 'removido',
        'pending reminder' => 'pendente com lembrete',
        'pending auto' => 'pendente com fecho automtico',
        'pending auto close+' => 'pendente com fecho automtico+',
        'pending auto close-' => 'pendente com fecho automtico-',
        'email-external' => 'mensagem de correio electrnico externa',
        'email-internal' => 'mensagem de correio electrnico interna',
        'note-external' => 'nota externa',
        'note-internal' => 'nota interna',
        'note-report' => 'relatrio de nota',
        'phone' => 'telefone',
        'sms' => '',
        'webrequest' => 'pedido via Web',
        'lock' => 'bloquear',
        'unlock' => 'desbloquear',
        'very low' => 'muito baixa',
        'low' => 'baixa',
        'normal' => '',
        'high' => 'alta',
        'very high' => 'muito alta',
        '1 very low' => '1 muito baixa',
        '2 low' => '2 baixa',
        '3 normal' => '',
        '4 high' => '4 alta',
        '5 very high' => '5 muito alta',
        'Ticket "%s" created!' => 'Ticket "%s" criado!',
        'Ticket Number' => 'Nmero do Ticket',
        'Ticket Object' => 'Objecto Ticket',
        'No such Ticket Number "%s"! Can\'t link it!' => 'No existe Nmero de Ticket "%s"! No posso ligar a ele!',
        'Don\'t show closed Tickets' => 'No mostrar tickets fechados',
        'Show closed Tickets' => 'Mostrar tickets fechados',
        'New Article' => 'Novo Artigo',
        'Email-Ticket' => 'Mensagem',
        'Create new Email Ticket' => 'Criar novo Ticket via Correio Electrnico',
        'Phone-Ticket' => 'Telefonema',
        'Search Tickets' => 'Procurar Tickets',
        'Edit Customer Users' => 'Editar Utilizadores Clientes',
        'Edit Customer Company' => '',
        'Bulk Action' => 'Em Lote',
        'Bulk Actions on Tickets' => 'Aces em Lote sobre Tickets',
        'Send Email and create a new Ticket' => 'Enviar mensagem e criar novo Ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'Criar novo Email Ticket e enviar para fora',
        'Create new Phone Ticket (Inbound)' => 'Criar novo Ticket telefnico',
        'Overview of all open Tickets' => 'Viso geral de todos os Tickets abertos',
        'Locked Tickets' => 'Tickets Bloqueados',
        'Watched Tickets' => 'Ticket Vigiado',
        'Watched' => 'Vigiado',
        'Subscribe' => 'Subscrever',
        'Unsubscribe' => 'Unsubscrever',
        'Lock it to work on it!' => 'Bloqueie-o para trabalhar nele!',
        'Unlock to give it back to the queue!' => 'Desbloqueie-o para o devolver  fila!',
        'Shows the ticket history!' => 'Mostra o histrico do ticket!',
        'Print this ticket!' => 'Imprime o ticket!',
        'Change the ticket priority!' => 'Muda a prioridade do ticket!',
        'Change the ticket free fields!' => 'Alterar os campos livres do ticket!',
        'Link this ticket to an other objects!' => 'Liga este ticket a outros objectos!',
        'Change the ticket owner!' => 'Muda o proprietrio do ticket!',
        'Change the ticket customer!' => 'Muda o cliente do ticket!',
        'Add a note to this ticket!' => 'Acrescentar uma nota ao ticket!',
        'Merge this ticket!' => 'Juntar este ticket a outro!',
        'Set this ticket to pending!' => 'Tornar o ticket pendente!',
        'Close this ticket!' => 'Fechar este ticket!',
        'Look into a ticket!' => 'Ver um ticket!',
        'Delete this ticket!' => 'Remover este ticket!',
        'Mark as Spam!' => 'Marcar como Spam!',
        'My Queues' => 'As Minhas Filas',
        'Shown Tickets' => 'Mostrar Tickets',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'A sua mensagem com o nmero de ticket "<OTRS_TICKET>" foi junta a "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: primeira resposta acabou em (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: primeira resposta acaba em (%s)!',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: tempo de actualizao acabou em (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: tempo de actualizao acaba em (%s)!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: tempo de resoluo acabou em (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Ticket %s: tempo de resoluo acaba em (%s)!',
        'There are more escalated tickets!' => 'Existem mais tickets escalados',
        'New ticket notification' => 'Notificao de novo ticket',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Envie-me uma notificao se houver um novo ticket nas "Minhas Filas".',
        'Follow up notification' => 'Notificao de seguimento',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Notifique-me se um cliente enviar um seguimento e eu for proprietrio deste ticket.',
        'Ticket lock timeout notification' => 'Notificao por expirao do tempo de bloqueio',
        'Send me a notification if a ticket is unlocked by the system.' => 'Notifique-me se um ticket for desbloqueado pelo sistema.',
        'Move notification' => 'Notificao de movimentos',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Notifique-me se um ticket for movido para uma das "Minhas Filas".',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Seleco das suas filas favoritas. Ser notificado acerca destas filas via correio electrnico se o servio estiver activo.',
        'Custom Queue' => 'Fila Personalizada',
        'QueueView refresh time' => 'Tempo de refrescamento da Visualizao  de Filas',
        'Screen after new ticket' => 'Ecr aps novo ticket',
        'Select your screen after creating a new ticket.' => 'Seleccionar ecr aps criao de novo ticket.',
        'Closed Tickets' => 'Tickets Fechados',
        'Show closed tickets.' => 'Mostrar tickets fechados',
        'Max. shown Tickets a page in QueueView.' => 'Nmero mximo de tickets por pgina em Visualio de Filas',
        'Watch notification' => '',
        'Send me a notification of an watched ticket like an owner of an ticket.' => '',
        'Out Of Office' => '',
        'Select your out of office time.' => '',
        'CompanyTickets' => 'Tickets da Instituio',
        'MyTickets' => 'Meus Tickets',
        'New Ticket' => 'Novo Ticket',
        'Create new Ticket' => 'Criar novo Ticket',
        'Customer called' => 'O cliente telefonou',
        'phone call' => 'chamada telefnica',
        'Reminder Reached' => '',
        'Responses' => 'Respostas',
        'Responses <-> Queue' => 'Respostas <-> Filas',
        'Auto Responses' => 'Respostas Automticas',
        'Auto Responses <-> Queue' => 'Respostas Automticas <-> Filas',
        'Attachments <-> Responses' => 'Anexos <-> Respostas',
        'History::Move' => 'Ticket movido para Fila "%s" (%s) da Fila "%s" (%s).',
        'History::TypeUpdate' => 'Actualizado tipo para %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Novo Ticket [%s] criado (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Acompanhamento para [%s]. %s',
        'History::SendAutoReject' => 'AutoRejeio enviada para "%s".',
        'History::SendAutoReply' => 'AutoResposta enviada para "%s".',
        'History::SendAutoFollowUp' => 'AutoAcompanhamento enviado para "%s".',
        'History::Forward' => 'Encaminhado para "%s".',
        'History::Bounce' => 'Bounced para "%s".',
        'History::SendAnswer' => 'Email enviado para "%s".',
        'History::SendAgentNotification' => '"%s"-notificao enviada para "%s".',
        'History::SendCustomerNotification' => 'Notificao enviada para "%s".',
        'History::EmailAgent' => 'Email enviado para cliente.',
        'History::EmailCustomer' => 'Adicionado Email. %s',
        'History::PhoneCallAgent' => 'Cliente contactado.',
        'History::PhoneCallCustomer' => 'Cliente contactou-nos.',
        'History::AddNote' => 'Adicionada nota (%s)',
        'History::Lock' => 'Ticket bloqueado.',
        'History::Unlock' => 'Ticket Desbloqueado.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Actualizado: %s',
        'History::PriorityUpdate' => 'Alterada prioridade de"%s" (%s) para "%s" (%s).',
        'History::OwnerUpdate' => 'Novo owner  "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! Nao foi enviada auto-resposta para "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Actualizado: %s',
        'History::StateUpdate' => 'Antigo: "%s" Novo: "%s"',
        'History::TicketFreeTextUpdate' => 'Actualizado: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Customer request via web.',
        'History::TicketLinkAdd' => 'Adicionado novo link ao ticket "%s".',
        'History::TicketLinkDelete' => 'Apagado link de ticket "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Domingo',
        'Mon' => 'Segunda',
        'Tue' => 'Tera',
        'Wed' => 'Quarta',
        'Thu' => 'Quinta',
        'Fri' => 'Sexta',
        'Sat' => 'Sbado',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Gesto de Anexos',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Gesto de Respostas Automticas',
        'Response' => 'Resposta',
        'Auto Response From' => 'Resposta Automtica De',
        'Note' => 'Nota',
        'Useable options' => 'Opes acessveis',
        'To get the first 20 character of the subject.' => 'Para obter os primeiros 20 Caracteres do subject',
        'To get the first 5 lines of the email.' => 'Para obter as primeiras 5 linhas do email',
        'To get the realname of the sender (if given).' => 'Para obter o realname do remetente (se dado)',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Para obter o atributo do artigo',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Opes dos actuais dados do cliente',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Opes do Owner do Ticket',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Opes do Responsavel do Ticket ',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Opes do actual cliente que pediu esta aco',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Opes dos dados do ticket',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Opes de Configurao',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Gesto de Utilizadores de Companhias',
        'Search for' => 'Procurar por',
        'Add Customer Company' => 'Adicione Utilizador de Companhia',
        'Add a new Customer Company.' => 'Adicione um novo Utilizador de Companhia',
        'List' => 'Listar',
        'This values are required.' => 'Estes valores so obrigatrios.',
        'This values are read only.' => 'Estes valores so apenas de leitura.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'A mensagem sendo composta foi fechada. Saindo.',
        'This window must be called from compose window' => 'Esta janela deve ser chamada da janela de composio',
        'Customer User Management' => 'Gesto de Utilizadores de Cliente',
        'Add Customer User' => 'Adicione Utilizador de Cliente',
        'Source' => 'Fonte',
        'Create' => 'Criar',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Utilizador cliente ter de ter um historial como cliente e de se autenticar via os paineis de cliente.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => '',
        'Change %s settings' => 'Modificar %s configuraes',
        'Select the user:group permissions.' => 'Seleccionar o utilizador:permisses de grupo.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Se nada for seleccionado, ento no h permisses neste grupo (tickets no estaram disponveis para o utilizador).',
        'Permission' => 'Permisso',
        'ro' => 'leitura',
        'Read only access to the ticket in this group/queue.' => 'Acesso apenas de leitura para o ticket neste grupo/fila.',
        'rw' => 'escrita',
        'Full read and write access to the tickets in this group/queue.' => 'Acesso total de leitura e escrita para os tickets neste grupo/queue.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => '',
        'CustomerUser' => 'Utilizador Cliente',
        'Service' => 'Servio',
        'Edit default services.' => '',
        'Search Result' => 'Resultado de Procura',
        'Allocate services to CustomerUser' => '',
        'Active' => 'Activo',
        'Allocate CustomerUser to service' => '',

        # Template: AdminEmail
        'Message sent to' => 'Mensagem enviada para',
        'Recipents' => 'Destinatrios',
        'Body' => 'Corpo',
        'Send' => 'Enviar',

        # Template: AdminGenericAgent
        'GenericAgent' => 'Agente Genrico',
        'Job-List' => 'Lista de Tarefas',
        'Last run' => 'ltima execuo',
        'Run Now!' => 'Excutar Agora!',
        'x' => '',
        'Save Job as?' => 'Guardar Tarefa como?',
        'Is Job Valid?' => 'A Tarefa  Vlida?',
        'Is Job Valid' => 'A Tarefa  Vlida',
        'Schedule' => 'Agendamento',
        'Currently this generic agent job will not run automatically.' => '',
        'To enable automatic execusion select at least one value form minutes, hours and days!' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Procura exaustiva no texto no artigo (ex: "Mar*in" or "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '(ex., 10*5155 ou 105658*)',
        '(e. g. 234321)' => '(ex., 234321)',
        'Customer User Login' => 'Nome de Utilizador de Cliente',
        '(e. g. U5150)' => '(ex., U5150)',
        'SLA' => '',
        'Agent' => 'Agente',
        'Ticket Lock' => 'Bloqueio de Ticket',
        'TicketFreeFields' => 'TicketCamposLivres',
        'Create Times' => 'Criar Tempos',
        'No create time settings.' => 'No existe definies de Tempo Criados',
        'Ticket created' => 'Ticket criado',
        'Ticket created between' => 'Ticket criado entre',
        'Close Times' => '',
        'No close time settings.' => '',
        'Ticket closed' => '',
        'Ticket closed between' => '',
        'Pending Times' => 'Tempo Pendente',
        'No pending time settings.' => 'No existe definies de Tempo Pendente',
        'Ticket pending time reached' => 'Tempo de pendencia do ticket atingido',
        'Ticket pending time reached between' => 'Tempo de pendencia do ticket entre',
        'New Service' => '',
        'New SLA' => '',
        'New Priority' => 'Nova Prioridade',
        'New Queue' => 'Nova Fila',
        'New State' => 'Novo Estado',
        'New Agent' => 'Novo Agente',
        'New Owner' => 'Novo Proprietrio',
        'New Customer' => 'Novo Cliente',
        'New Ticket Lock' => 'Novo Bloqueio do Ticket',
        'New Type' => '',
        'New Title' => '',
        'New TicketFreeFields' => 'Novo Campo livre',
        'Add Note' => 'Adicionar Nota',
        'Time units' => 'Unidades de tempo',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Este comando ser executado. ARG[0] ser o nmero do ticket e ARG[1] o seu ID.',
        'Delete tickets' => 'Remover tickets',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Aviso! Estes tickets sero removidos da base de dados! Sero perdidos!',
        'Send Notification' => 'Enviar notificao',
        'Param 1' => 'Parmetro 1',
        'Param 2' => 'Parmetro 2',
        'Param 3' => 'Parmetro 3',
        'Param 4' => 'Parmetro 4',
        'Param 5' => 'Parmetro 5',
        'Param 6' => 'Parmetro 6',
        'Send agent/customer notifications on changes' => '',
        'Save' => 'Guardar',
        '%s Tickets affected! Do you really want to use this job?' => '%s Tickets afectados! Tem a certeza que pretende efectuar este trabalho?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Gesto de Grupos',
        'Add Group' => 'Adicionar Grupo',
        'Add a new Group.' => 'Adicionar um novo Grupo.',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'O grupo admin  para uso na rea de administrao e o grupo stats  para uso na rea de estatsticas.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crie novos grupos para manipular as permisses de acesso para diferentes grupos de agentes (e.g., departamento de compras, departamento de suporte, departamento de vendas, etc.).',
        'It\'s useful for ASP solutions.' => 'Isto  til para solues ASP.',

        # Template: AdminLog
        'System Log' => 'Registo do Sistema',
        'Time' => 'Tempo',

        # Template: AdminMailAccount
        'Mail Account Management' => '',
        'Host' => 'Anfitrio',
        'Trusted' => 'Confivel',
        'Dispatching' => 'Despachando',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Todas as mensagens recebidas correspondentes a uma com uma conta sero despachados para a fila selecionada!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

        # Template: AdminNavigationBar
        'Users' => 'Utilizadores',
        'Groups' => 'Grupos',
        'Misc' => 'Vrios',

        # Template: AdminNotificationForm
        'Notification Management' => 'Gesto de Notificao',
        'Notification' => 'Notificaes',
        'Notifications are sent to an agent or a customer.' => 'As notificaes so enviadas para um agente ou um cliente.',

        # Template: AdminPackageManager
        'Package Manager' => 'Gestor de Pacotes',
        'Uninstall' => 'Desinstalar',
        'Version' => 'Verso',
        'Do you really want to uninstall this package?' => 'Deseja mesmo desinstalar este pacote?',
        'Reinstall' => 'Reinstalar',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Tem a certeza que pretende reinstalar este pacote ?(todas as alteraes manuais vao ser perdidas)',
        'Continue' => 'Continuar',
        'Install' => 'Instalar',
        'Package' => 'Pacote',
        'Online Repository' => 'Repositrio Em-linha',
        'Vendor' => 'Vendedor',
        'Module documentation' => '',
        'Upgrade' => 'Melhoria de Verso',
        'Local Repository' => 'Repositrio Local',
        'Status' => 'Estado',
        'Overview' => 'Viso Geral',
        'Download' => 'Descarregar',
        'Rebuild' => 'Reconstruir',
        'ChangeLog' => 'Mudana de Log',
        'Date' => 'Data',
        'Filelist' => 'Lista de ficheiros',
        'Download file from package!' => 'Download de ficheiro do pacote',
        'Required' => 'Obrigatrio',
        'PrimaryKey' => 'ChavePrincipal',
        'AutoIncrement' => 'AutoIncrementar',
        'SQL' => '',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => '',
        'This feature is enabled!' => 'Esta opo est activa',
        'Just use this feature if you want to log each request.' => 'Apenas use esta opo se pretender registar cada pedido',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => 'Desactivar aqui',
        'This feature is disabled!' => 'Esta opo est desactivada',
        'Enable it here!' => 'Activar aqui',
        'Logfile too large!' => 'Ficheiro de log demasiado grande',
        'Logfile too large, you need to reset it!' => 'Ficheiro de log demasiado grande, precisa de fazer reset',
        'Range' => 'Intervalo',
        'Interface' => '',
        'Requests' => 'Pedidos',
        'Min Response' => 'Resposta minima',
        'Max Response' => 'Resposta maxima',
        'Average Response' => 'Media de Resposta',
        'Period' => '',
        'Min' => '',
        'Max' => '',
        'Average' => '',

        # Template: AdminPGPForm
        'PGP Management' => 'Gesto de PGP',
        'Result' => 'Resultado',
        'Identifier' => 'Identificador',
        'Bit' => '',
        'Key' => 'Chave',
        'Fingerprint' => 'Impresso Digital',
        'Expires' => 'Expira',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Desta forma pode editar directamente o anel de chaves configurado no SysConfig',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Gesto de Filtros do Chefe do Correio',
        'Filtername' => 'Nome do Filtro',
        'Stop after match' => '',
        'Match' => 'Corresponde',
        'Value' => 'Valor',
        'Set' => 'Coloca',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Despachar ou filtrar mensagens recebidas de acordo com os seus Cabealhos-X! Pode-se usar expresses regulares.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Se pretender apenas relacionar o email adress, use EMAILADDRESS:info@example.com no From, To ou Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Se usar expresses regulares, pode aceder ao valor emparelhado em () como [***] em \'Coloca\'.',

        # Template: AdminPriority
        'Priority Management' => '',
        'Add Priority' => '',
        'Add a new Priority.' => '',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Fila <-> Gesto de Respostas Automticas',
        'settings' => '',

        # Template: AdminQueueForm
        'Queue Management' => 'Gesto de Filas',
        'Sub-Queue of' => 'Subfila de',
        'Unlock timeout' => 'Tempo de desbloqueio',
        '0 = no unlock' => '0 = sem desbloqueio',
        'Only business hours are counted.' => '',
        'Escalation - First Response Time' => 'Primeiro tempo de resposta',
        '0 = no escalation' => '0 = sem escalamento',
        'Notify by' => '',
        'Escalation - Update Time' => 'Tempo de actualizao',
        'Escalation - Solution Time' => 'Tempo de soluo',
        'Follow up Option' => 'Opo de Seguimento',
        'Ticket lock after a follow up' => 'Bloqueio do ticket aps seguimento',
        'Systemaddress' => 'Endereo do Sistema',
        'Customer Move Notify' => 'Movimento de Cliente Notificado',
        'Customer State Notify' => 'Estado de Cliente Notificado',
        'Customer Owner Notify' => 'Proprietrio de Cliente Notificado',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Se um agente bloqueia um ticket e no enviar uma resposta dentro deste tempo, o ticket ser desbloqueado automaticamente, ficando visvel para todos os outros agentes.',
        'Escalation time' => 'Tempo de escalamento',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Se um ticket no for respondido dentro deste tempo, apenas os tickets com este tempo vencido sero exibidos.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Se um ticket estiver fechado e um cliente enviar um seguimento, ser bloqueado em nome do seu proprietrio.',
        'Will be the sender address of this queue for email answers.' => 'Ser o endereo de correio electrnico usado para respostas nesta fila.',
        'The salutation for email answers.' => 'A saudao das respostas de correio electrnico.',
        'The signature for email answers.' => 'A assinatura das respostas de correio electrnico.',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'O OTRS envia uma mensagem de notificao ao cliente se o ticket for movido.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'O OTRS envia uma mensagem de notificao ao cliente se o estado do ticket for alterado.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'O OTRS envia uma mensagem de notificao ao cliente se o proprietrio do ticket for alterado.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Respostas <-> Gesto de Filas',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Resposta',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Respostas <-> Gesto de Anexos',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Gesto de Respostas',
        'A response is default text to write faster answer (with default text) to customers.' => 'Uma resposta  um texto padro para compr respostas rpidas (com texto padro) para clientes.',
        'Don\'t forget to add a new response a queue!' => 'No se esquea de adicionar a nova resposta a uma fila!',
        'The current ticket state is' => 'O estado corrente do ticket ',
        'Your email address is new' => 'O seu endereo de correio electrnico  novo',

        # Template: AdminRoleForm
        'Role Management' => 'Gesto de Papeis',
        'Add Role' => 'Adicionar Papel',
        'Add a new Role.' => 'Adicionar novo papel',
        'Create a role and put groups in it. Then add the role to the users.' => 'Criar um papel e atribuir-lhe grupos. Depois acrescentar o papel aos utilizadores.',
        'It\'s useful for a lot of users and groups.' => 'til para muitos utilizadores e grupos.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Papeis <-> Gesto de Grupos',
        'move_into' => 'mover para',
        'Permissions to move tickets into this group/queue.' => 'Permisses para mover tickets neste grupo/queue',
        'create' => 'criar',
        'Permissions to create tickets in this group/queue.' => 'Permisses para criar tickets neste grupo/queue',
        'owner' => 'dono',
        'Permissions to change the ticket owner in this group/queue.' => 'Permisses para modificar o dono do ticket neste grupo/queue',
        'priority' => 'prioridade',
        'Permissions to change the ticket priority in this group/queue.' => 'Permisses para modificar a prioridade do ticket neste grupo/queue',

        # Template: AdminRoleGroupForm
        'Role' => 'Papel',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Papeis <-> Gesto de Utilizadores',
        'Select the role:user relations.' => 'Seleccione as relaes papel:utilizador',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Gesto de Saudaes',
        'Add Salutation' => 'Adicionar Apresentao',
        'Add a new Salutation.' => 'Adicionar nova Apresentao',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBoxForm
        'SQL Box' => '',
        'Go' => '',
        'Select Box Result' => 'Selecione a Caixa de Resultado',

        # Template: AdminService
        'Service Management' => 'Gesto de servio',
        'Add Service' => 'Adicionar Servio',
        'Add a new Service.' => 'Adicionar novo servio',
        'Sub-Service of' => 'Sub-servio de',

        # Template: AdminSession
        'Session Management' => 'Gesto de Sesses',
        'Sessions' => 'Sesses',
        'Uniq' => 'nico',
        'Kill all sessions' => 'Fechar todas as sesses',
        'Session' => 'Sesso',
        'Content' => 'Contedo',
        'kill session' => 'finalizar sesso',

        # Template: AdminSignatureForm
        'Signature Management' => 'Gesto de Assinaturas',
        'Add Signature' => 'Adicionar assinatura',
        'Add a new Signature.' => 'Adicionar nova assinatura',

        # Template: AdminSLA
        'SLA Management' => 'Gesto de SLA',
        'Add SLA' => 'Adicionar SLA',
        'Add a new SLA.' => 'Adicionar novo SLA',

        # Template: AdminSMIMEForm
        'S/MIME Management' => '',
        'Add Certificate' => 'Adicionar Certificado',
        'Add Private Key' => 'Adicionar Chave Privada',
        'Secret' => 'Segredo',
        'Hash' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Aqui pode editar directamente os certificados e chaves privadas presentes no sistema de ficheiros.',

        # Template: AdminStateForm
        'State Management' => 'Gestao de estado',
        'Add State' => 'Adicionar estado',
        'Add a new State.' => 'Adicionar novo estado',
        'State Type' => 'Estado Tipo',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Garanta que tambm actualisou os estados por omisso no seu Kernel/Config.pm!',
        'See also' => 'Ver tambm',

        # Template: AdminSysConfig
        'SysConfig' => 'Configurao do Sistema',
        'Group selection' => 'Seleco do grupo',
        'Show' => 'Mostrar',
        'Download Settings' => 'Descarregar Configurao',
        'Download all system config changes.' => 'Descarregar todas as alteraes da configurao do sistema.',
        'Load Settings' => 'Carregar Configurao',
        'Subgroup' => 'Subgrupo',
        'Elements' => 'Elementos',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Opes de Configurao',
        'Default' => 'Por Omisso',
        'New' => 'Novo',
        'New Group' => 'Novo Grupo',
        'Group Ro' => '',
        'New Group Ro' => '',
        'NavBarName' => '',
        'NavBar' => '',
        'Image' => 'Imagem',
        'Prio' => '',
        'Block' => '',
        'AccessKey' => '',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Gesto dos Endereos de Correio Electrnico do Sistema',
        'Add System Address' => 'Adicionar endereo de sistema',
        'Add a new System Address.' => 'Adicionar novo endereo de sistema',
        'Realname' => 'Nome',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todas mensagens recebidas com este destinatrio (Para:) sero despachados para a fila selecionada!',

        # Template: AdminTypeForm
        'Type Management' => '',
        'Add Type' => '',
        'Add a new Type.' => '',

        # Template: AdminUserForm
        'User Management' => 'Gesto de Utilizadores',
        'Add User' => '',
        'Add a new Agent.' => '',
        'Login as' => 'Entrar como',
        'Firstname' => 'Nome',
        'Lastname' => 'Apelido',
        'Start' => 'Incio',
        'End' => 'Fim',
        'User will be needed to handle tickets.' => ' necessrio um utilizador para manipular os tickets.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'No se esquea de adicionar um novo utilizador a grupos e/ou papeis!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Utilizadores <-> Gesto de Grupos',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Lista de Endereos',
        'Return to the compose screen' => 'Retornar para o ecr de composio',
        'Discard all changes and return to the compose screen' => 'Descartar todas as modificaes e retornar para o ecr de composio',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentInfo
        'Info' => 'Informao',

        # Template: AgentLinkObject
        'Link Object: %s' => '',
        'Object' => 'Objecto',
        'Link Object' => 'Ligar Objecto',
        'with' => 'com',
        'Select' => 'Seleccionar',
        'Unlink Object: %s' => '',

        # Template: AgentLookup
        'Lookup' => 'Procura',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Verificador Ortogrfico',
        'spelling error(s)' => 'erro(s) ortogrfico(s)',
        'or' => 'ou',
        'Apply these changes' => 'Aplicar estas modificaes',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Deseja realmente remover este Objecto?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Selecionar as restrices para caracterizar o estado',
        'Fixed' => 'Fixo',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Selecione apenas um elemento ou desligue o botao "fixo"',
        'Absolut Period' => 'Periodo Absoluto',
        'Between' => 'Entre',
        'Relative Period' => 'Periodo relativo',
        'The last' => 'O ultimo',
        'Finish' => 'Fim',
        'Here you can make restrictions to your stat.' => 'Aqui pode fazer restricoes para a sua estatistica',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Se remover o visto na caixa "fixo", o agente gerador da estatistica pode mudar os atribudos do elemento correspondente',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Insero das especificaes comuns',
        'Permissions' => 'Permisses',
        'Format' => 'Formato',
        'Graphsize' => 'Tamanho do grafico',
        'Sum rows' => 'Mostrar Linhas',
        'Sum columns' => 'Mostrar colunas',
        'Cache' => '',
        'Required Field' => 'Campo Obrigatorio',
        'Selection needed' => 'Necessria seleco',
        'Explanation' => 'Explicao',
        'In this form you can select the basic specifications.' => 'Neste formulario pode selecionar as especificaoes basicas',
        'Attribute' => 'Atributo',
        'Title of the stat.' => 'Titulo da estatistica',
        'Here you can insert a description of the stat.' => 'Aqui pode inserir a descriao da estatistica',
        'Dynamic-Object' => '',
        'Here you can select the dynamic object you want to use.' => 'Aqui pode selecionar o Dynamic object que pretende usar ',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'Depende na sua instalao o numero de dynamic objects que pode usar',
        'Static-File' => '',
        'For very complex stats it is possible to include a hardcoded file.' => 'Para estatisticas muito complexas pode incluir hardcoded files',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Se um novo Hardcoded File esta disponivel, este atributo vai ficar visivel e pode selecionar um',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Opoes de permiosso. Aqui pode selecionar um ou mais grupos para efectuar a configuraao de estatisticas visiveis para diferentes agentes',
        'Multiple selection of the output format.' => 'Multiplas selecoes do formato de output',
        'If you use a graph as output format you have to select at least one graph size.' => 'Se utilizar um grafico como um formato de output, ter de selecionar pelo menos um tamanho de grafico',
        'If you need the sum of every row select yes' => 'Se pretende a soma de todas as linhas selecione Sim',
        'If you need the sum of every column select yes.' => 'Se pretende a soma de todas as colunas selecione Sim',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'Maioria das estatisticas podem ser feitas. Isto ir aumentar a rapidez da apresentaao da estatistica',
        '(Note: Useful for big databases and low performance server)' => 'Util para grandes databases e servers pouco potentes',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Com uma estatistica invalida  impossivel gerar uma estatistica',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Isto  util se nao pretende que ninguem veja os resultados de uma estatsitica ou uma estatistica nao esteja preparada e configurada',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Selecione os elementos para os value series',
        'Scale' => 'Escala',
        'minimal' => 'Minima',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Relembre-se que o valor da escala tem de ser superior ao valor maximo para o eixo dos X',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'Selecione o elemento que vai ser usado no eixo dos X',
        'maximal period' => 'Periodo minimo',
        'minimal scale' => 'Escala minima',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => 'Importar',
        'File is not a Stats config' => 'Ficheiro nao  uma configuraao de estatistica',
        'No File selected' => 'Sem ficheiro selecionado',

        # Template: AgentStatsOverview
        'Results' => 'Resultados',
        'Total hits' => 'Total de acertos',
        'Page' => 'Pgina',

        # Template: AgentStatsPrint
        'Print' => 'Imprimir',
        'No Element selected.' => 'Sem elemento selecionado',

        # Template: AgentStatsView
        'Export Config' => 'Exportar configuraao',
        'Information about the Stat' => 'Informaoes sobre estatisticas',
        'Exchange Axis' => 'Troca de eixos',
        'Configurable params of static stat' => 'Parametros configuraveis de estatisticas estaticas',
        'No element selected.' => 'Sem elemento selecionado',
        'maximal period from' => 'Maximo periodo desde',
        'to' => 'para',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Uma mensagem deve possuir um Para: destinatrio!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Precisa de um endereo de correio electrnico (e.g., cliente@exemplo.pt) no Para:!',
        'Bounce ticket' => 'Devolver ticket',
        'Ticket locked!' => 'Ticket bloqueado!',
        'Ticket unlock!' => 'Ticket desbloqueado!',
        'Bounce to' => 'Devolver para',
        'Next ticket state' => 'Prximo estado do ticket',
        'Inform sender' => 'Informe o remetente',
        'Send mail!' => 'Enviar mensagem de correio electrnico!',

        # Template: AgentTicketBulk
        'A message should have a subject!' => 'A mensagem deve conter um assunto!',
        'You need to account time!' => ' necessrio o tempo dispendido',
        'Ticket Bulk Action' => 'Aco sobre Lote de Tickets',
        'Spell Check' => 'Verificar Ortografia',
        'Note type' => 'Tipo de nota',
        'Next state' => 'Prximo estado',
        'Pending date' => 'Data da pendncia',
        'Merge to' => 'Juntar a',
        'Merge to oldest' => '',
        'Link together' => '',
        'Link to Parent' => '',
        'Unlock Tickets' => 'Desbloquear Tickets',

        # Template: AgentTicketClose
        'Ticket Type is required!' => '',
        'A message should have a body!' => 'A mensagem deve conter um texto!',
        'A required field is:' => '',
        'Close ticket' => 'Fechar ticket',
        'Previous Owner' => 'Proprietrio Anterior',
        'Inform Agent' => 'Informar agente',
        'Optional' => 'Opcional',
        'Inform involved Agents' => 'Informar agentes envolvidos',
        'Attach' => 'Anexo',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'Tem de verificar a ortografia da mensagem!',
        'Compose answer for ticket' => 'Compor uma resposta para o ticket',
        'Pending Date' => 'Prazo de pendncia',
        'for pending* states' => 'para os estados "pendente ..."',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Modificar o cliente do ticket',
        'Set customer user and customer id of a ticket' => 'Atribua o nome de utilizador e o ID do cliente do ticket',
        'Customer User' => 'Nome de Utilizador do Cliente',
        'Search Customer' => 'Procurar Cliente',
        'Customer Data' => 'Dados do Cliente',
        'Customer history' => 'Histrico do cliente',
        'All customer tickets.' => 'Todos os tickets do cliente.',

        # Template: AgentTicketEmail
        'Compose Email' => 'Compor Mensagem de Correio Electrnico',
        'new ticket' => 'novo ticket',
        'Refresh' => 'Actualizar',
        'Clear To' => 'Clear para',
        'All Agents' => 'Todos os Agentes',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Tipo de artigo',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Alterar Texto livre do ticket',

        # Template: AgentTicketHistory
        'History of' => 'Histrico de',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Ter de usar um numero de ticket!',
        'Ticket Merge' => 'Juntar Ticket',

        # Template: AgentTicketMove
        'Move Ticket' => 'Mover Ticket',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Adicionar nota ao ticket',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => 'Primeiro tempo de resposta',
        'Service Time' => 'Tempo de servio',
        'Update Time' => 'Tempo de actualizao',
        'Solution Time' => 'Tempo de soluo',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Precisa de seleccionar pelo menos um Ticket!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Filtro',
        'Change search options' => 'Alterar opes de procura',
        'Tickets' => 'Tickets',
        'of' => 'de',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Compor resposta',
        'Contact customer' => 'Contactar o cliente',
        'Change queue' => 'Modificar a fila',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'ordenar crescentemente',
        'up' => 'crescente',
        'sort downward' => 'ordenar decrescentemente',
        'down' => 'decrescente',
        'Escalation in' => 'Escalado em',
        'Locked' => 'Bloqueado',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Modificar o proprietrio do ticket',

        # Template: AgentTicketPending
        'Set Pending' => 'Definir como Pendente',

        # Template: AgentTicketPhone
        'Phone call' => 'Chamada telefnica',
        'Clear From' => 'Limpar De',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Verbatim',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Informao de Ticket',
        'Accounted time' => 'Tempo contabilizado',
        'Linked-Object' => 'Objecto-Ligado',
        'by' => 'por',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Modificar a prioridade do ticket',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Tickets mostrados',
        'Tickets available' => 'Tickets disponveis',
        'All tickets' => 'Todos os tickets',
        'Queues' => 'Filas',
        'Ticket escalation!' => 'Escalamento de tickets!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Mudar responsavel do ticket',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Procura de Tickets',
        'Profile' => 'Perfil',
        'Search-Template' => 'Modelo de procura',
        'TicketFreeText' => 'Texto Livre do Ticket',
        'Created in Queue' => 'Criado na Fila',
        'Article Create Times' => '',
        'Article created' => '',
        'Article created between' => '',
        'Change Times' => '',
        'No change time settings.' => '',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Result Form' => 'Formato do resultado',
        'Save Search-Profile as Template?' => 'Guardar Perfil de Procura como Modelo?',
        'Yes, save it with name' => 'Sim, guardar com o nome',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => '',
        'Collapse View' => '',
        'Split' => 'Dividir',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => '',
        'Save filter settings as default' => '',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Retroceder',

        # Template: CustomerFooter
        'Powered by' => 'Produzido por',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'Autenticao',
        'Lost your password?' => 'Esqueceu a palavra-passe?',
        'Request new password' => 'Solicitar nova palavra-passe',
        'Create Account' => 'Criar Conta',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Bem-vindo, %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Tempos',
        'No time settings.' => 'Sem definies de tempo.',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Clique aqui para reportar um erro!',

        # Template: Footer
        'Top of Page' => 'Topo da Pgina',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Incio',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Instalador Web',
        'Welcome to %s' => 'Bem Vindo a %s',
        'Accept license' => 'Aceitar licena',
        'Don\'t accept license' => 'Nao aceitar licena',
        'Admin-User' => 'Utilizador de Admin',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Admin-Password' => 'Password de admnistrador',
        'Database-User' => 'Utilizador da Base de Dados',
        'default \'hot\'' => 'por omisso \'hot\'',
        'DB connect host' => 'Anfitrio para ligaes  Base de Dados',
        'Database' => 'Base de dados',
        'Default Charset' => 'Codificao por Omisso',
        'utf8' => '',
        'false' => 'falso',
        'SystemID' => 'ID do sistema',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(A identidade do sistema. Cada nmero de ticket e cada id. da sesso http, inicia com este nmero)',
        'System FQDN' => 'FQDN do sistema',
        '(Full qualified domain name of your system)' => '(Nome de domnio totalmente qualificado do seu sistema)',
        'AdminEmail' => 'Correio Electrnico do Administrador',
        '(Email of the system admin)' => '(Endereo de correio electrnico do administrador do sistema)',
        'Organization' => 'Organizao',
        'Log' => 'Registo',
        'LogModule' => 'Mdulo de Registos',
        '(Used log backend)' => '(Usei o sistema de registos)',
        'Logfile' => 'Ficheiro de Log',
        '(Logfile just needed for File-LogModule!)' => '(Ficheiro de registo para File-LogModule)',
        'Webfrontend' => 'Interface Web',
        'Use utf-8 it your database supports it!' => 'Usar UTF-8 se a base de dados o suportar',
        'Default Language' => 'Idioma por Omisso',
        '(Used default language)' => '(Idioma por omisso utilizado)',
        'CheckMXRecord' => 'Verificar registo MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Verifica os registos MX dos endereos de correio electrnico usados quando compe uma resposta. No usar caso esteja a usar uma ligao telefnica!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para usar o OTRS tem de dar o seguinte comando no seu Terminal/Consola, como administrador.',
        'Restart your webserver' => 'Reinicie o seu servidor Web',
        'After doing so your OTRS is up and running.' => 'Depois de o fazer, o seu OTRS estar funcional.',
        'Start page' => 'Pgina inicial',
        'Your OTRS Team' => 'A sua Equipa OTRS',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Sem Autorizao',

        # Template: Notify
        'Important' => 'Importante',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'impresso por',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'Pgina de Teste do OTRS',
        'Counter' => 'Contador',

        # Template: Warning

        # Template: YUI

        # Misc
        'Edit Article' => 'Editar Artigo',
        'Create Database' => 'Criar Base de Dados',
        'DB Host' => 'Servidor Base de Dados',
        'Multiplier:' => 'Multiplicador:',
        'Ticket Number Generator' => 'Gerador de Nmeros de Tickets',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificao do ticket. Algumas pessoas usam \'Ticket#\', \'Chamada#\' or \'MeuTicket#\')',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Desta forma pode alterar directamente o keyring configurado no Kernel/Config.pm',
        'Create new Phone Ticket' => 'Criar novo Ticket via Telefone',
        'Symptom' => 'Sintoma',
        'U' => 'C',
        'Site' => 'Pgina',
        'Customer history search (e. g. "ID342425").' => 'Procura no histrico do cliente (e.g., "ID342425")',
        'Can not delete link with %s!' => '',
        'Close!' => 'Fechar!',
        'for agent firstname' => 'para o nome prprio do agente',
        'No means, send agent and customer notifications on changes.' => 'Nao significa, enviar ao agent e cliente notificaoes quando houver alteraes',
        'A web calendar' => 'Um calendrio na Web',
        'to get the realname of the sender (if given)' => 'para obter o nome do remetente (se indicado na mensagem)',
        'OTRS DB Name' => 'Nome da Base de Dados OTRS',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
        'Notification (Customer)' => 'Notificaao (cliente)',
        'PGP Key' => 'Chave PGP',
        'Select Source (for add)' => 'Seleccionar fonte (para a adio)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Opes dos dados do ticket (e.g., &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Child-Object' => 'Objecto-Descendente',
        'Queue ID' => 'ID da Queue',
        'System History' => 'Histrico do Sistema',
        'customer realname' => 'nome do cliente',
        'First Response' => 'Primeira Reposta',
        'Pending messages' => 'Mensagens pendentes',
        'Modules' => 'Mdulos',
        'for agent login' => 'para o nome de utilizador do agente',
        'PGP Key Upload' => 'Carregamento de Chave PGP',
        'Keyword' => 'Palavra-chave',
        'Close type' => 'Tipo de fecho',
        'DB Admin User' => 'Utilizador Admin da Base de Dados',
        'for agent user id' => 'para o ID de utilizador do agente',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_TicketNumber&gt;, &lt;OTRS_TICKET_TicketID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
        'Change user <-> group settings' => 'Modificar users <-> configuraes de grupos',
        'Problem' => 'Problema',
        'Escalation' => '',
        '"}' => '',
        'Order' => 'Ordem',
        'next step' => 'prximo passo',
        'Follow up' => 'Seguimento',
        'Customer history search' => 'Procura no histrico do cliente',
        'Admin-Email' => 'Endereo de Correio Electrnico do Administrador',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_UserFirstname&gt;)' => 'Opoes do Cliente corrente (Ex. &lt;OTRS_CUSTOMER_DATA_UserFirstname&gt;)',
        'Stat#' => '',
        'OTRS-Admin Info!' => 'Informao do Administrador OTRS!',
        'SMIME Certificate Upload' => 'Carregamento de Certificado SMIME',
        'Create new database' => 'Criar nova base de dados',
        'ArticleID' => 'ID de Artigo',
        'Keywords' => 'Palavras-chave',
        'Ticket Escalation View' => '',
        'Today' => '',
        'Select:' => 'Seleccionar:',
        'No * possible!' => 'No so possveis *!',
        'PostMaster Filter' => 'Filtros do Chefe do Correio',
        'PostMaster POP3 Account' => 'Conta do Chefe do Correio',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opoes do user actual que pediu esta aco',
        'Message for new Owner' => 'Mensagem para o novo Proprietrio',
        'to get the first 5 lines of the email' => 'para obter as 5 primeiras linhas da mensagem de correio electrnico',
        'Sort by' => 'Ordenado pela',
        'OTRS DB Password' => 'Palavra-passe da Base de Dados OTRS',
        'Last update' => 'ltima actualizao',
        'Sorry, feature not active!' => 'Lamentamos, caracterstica no activa!',
        'Tomorrow' => '',
        'to get the first 20 character of the subject' => 'para obter os 20 primeiros caracteres do assunto',
        'Select the customeruser:service relations.' => '',
        'DB Admin Password' => 'Palavra-passe de Administrador da Base de Dados',
        'Drop Database' => 'Apagar Base de Dados',
        'Advisory' => 'Recomendao',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',
        'FileManager' => 'Gestor de Ficheiros',
        'Pending type' => 'Tipo de pendncia',
        'Comment (internal)' => 'Comentrio (interno)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opoes do dono do ticket',
        'Note!' => 'Nota!',
        '(Used ticket number format)' => '(Formato de nmero de ticket utilizado)',
        'Reminder' => 'Lembretes',
        'Fulltext' => 'Texto completo',
        'Incident' => 'Incidente',
        'Ticket\#' => 'No. de Ticket',
        'OTRS DB connect host' => 'Servidor de ligao da Base de Dados OTRS',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_UserFirstname&gt;)' => 'Opes do dono do ticket',
        ' (work units)' => ' (unidades de trabalho)',
        'Next Week' => '',
        'All Customer variables like defined in config option CustomerUser.' => 'todas as variveis de Cliente tais como definidas na opo de configurao CustomerUser',
        'accept license' => 'aceitar licena',
        'for agent lastname' => 'para o apelido do agente',
        'Reminder messages' => 'Mensagens com lembretes',
        'Parent-Object' => 'Objecto-Ascendente',
        'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Se a sua conta for acreditada, cabealhos X-OTRS existentes  chegada (para prioridade, etc.) sero usados! O filtro do Chefe do Correio ser sempre usado, no entanto.',
        'Of couse this feature will take some system performance it self!' => 'Obviamente que esta opo vai por si usar alguma performance de sistema',
        'Ticket Hook' => 'Identificador do Ticket',
        'Detail' => 'Pormenor',
        'Your own Ticket' => 'O seu Ticket',
        'TicketZoom' => 'DetalhesDoTicket',
        'Don\'t forget to add a new user to groups!' => 'No esquea de adicionar um novo user nos grupos!',
        'Open Tickets' => 'Tickets Abertos',
        'You have to select two or more attributes from the select field!' => 'Dever selecionar dois ou mais atributos dos campos slectionaveis',
        'System Settings' => 'Propriedades de Sistema',
        'WebWatcher' => 'Observador da Web',
        'Finished' => 'Terminado',
        'D' => '',
        'All messages' => 'Todas as mensagens',
        'System Status' => 'Estado do Sistema',
        'Artefact' => 'Artefacto',
        'Object already linked as %s.' => '',
        'A article should have a title!' => 'Um artigo tem de ter um ttulo!',
        'Benchmark' => 'Desempenho',
        'Event' => 'Evento',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Opes de Configurao (Ex. &lt;OTRS_CONFIG_HttpType&gt;)',
        'Update:' => 'Actualizar:',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'don\'t accept license' => 'no aceitar licena',
        'A web mail client' => 'Um cliente de correio electrnico na Web',
        'Compose Follow up' => 'Compor Seguimento',
        'WebMail' => 'Correio electrnico na Web',
        'Name is required!' => ' necessrio um nome!',
        'DB Type' => 'Tipo da Base de Dados',
        'kill all sessions' => 'Finalizar todas as sesses',
        'to get the from line of the email' => 'para obter a linha "De:" da mensagem',
        'Solution' => 'Soluo',
        'Requests:' => 'Pedidos:',
        'QueueView' => 'Filas',
        'Select Box' => 'Caixa de Seleco',
        'New messages' => 'Mensagens novas',
        'SMIME Certificate' => 'Certificado SMIME',
        'Can not create link with %s!' => '',
        'Linked as' => '',
        'Welcome to OTRS' => 'Bem-vindo ao OTRS',
        'Delete old database' => 'Eliminar base de dados antiga',
        'Ticket %s locked.' => 'Ticket %s bloqueado.',
        'A web file manager' => 'Um gestor de ficheiros na Web',
        'Have a lot of fun!' => 'Divirta-se!',
        'send' => 'enviar',
        'Send no notifications' => 'Nao enviar notificao',
        'Note Text' => 'Nota',
        'POP3 Account Management' => 'Gesto de Contas POP3',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opoes de dados do actual user (Ex. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'Insert:' => 'Inserir:',
        'Security Note: You should activate %s because applications is already running!' => 'Nota de Segurana: Deve activar o %s, pois a aplicao est j em produo!',
        'System State Management' => 'Gesto de Estados do Sistema',
        'OTRS DB User' => 'Utilizador de Base de Dados OTRS',
        'Mailbox' => 'Caixa de Entrada',
        'PhoneView' => 'Visualizao de Chamada',
        'maximal period form' => 'Maximo periodo desde',
        'TicketID' => 'ID de Ticket',
        'Yes means, send no agent and customer notifications on changes.' => 'Sim significa, no enviar ao agent e cliente notificaes quando houver alteraes',
        'SMIME Management' => 'Gesto de SMIME',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Seu email com o nmero de ticket "<OTRS_TICKET>" foi devolvido para "<OTRS_BOUNCE_TO>". Contate este endereo para mais informaes.',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_UserFirstname&gt;)' => 'Opes do utilizador que requereu a aco (Ex. &lt;OTRS_CURRENT_UserFirstname&gt;)',
        'Ticket Status View' => 'Visualizao do Estado dos Tickets',
        'Modified' => 'Modificado',
        'Ticket selected for bulk action!' => 'Ticket seleccionado para aco em lote!',
    };
    # $$STOP$$
    return;
}

1;
