# --
# Kernel/Language/cz.pm - provides cz language translation
# Copyright (C) 2003 Lukas Vicanek alias networ <lulka at centrum dot cz>
# Copyright (C) 2004 BENETA.cz, s.r.o. (Marta Macalkova, Vadim Buzek, Petr Ocasek) <info at beneta dot cz>
# --
# $Id: cz.pm,v 1.73 2009/06/08 05:44:12 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::cz;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.73 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Mon Jun  8 07:33:25 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D/%M/%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %Y %T';
    $Self->{DateFormatShort}     = '%D/%M/%Y';
    $Self->{DateInputFormat}     = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Ano',
        'No' => 'Ne',
        'yes' => 'ano',
        'no' => 'ne',
        'Off' => 'Vypnuto',
        'off' => 'vypnuto',
        'On' => 'Zapnuto',
        'on' => 'zapnuto',
        'top' => 'nahoru',
        'end' => 'konec',
        'Done' => 'Hotovo',
        'Cancel' => 'Stornovat',
        'Reset' => '',
        'last' => 'posledn',
        'before' => 'ped',
        'day' => 'den',
        'days' => 'dn(dny)',
        'day(s)' => 'den(dn)',
        'hour' => 'hodina',
        'hours' => 'hodin',
        'hour(s)' => '',
        'minute' => 'minuta',
        'minutes' => 'minut',
        'minute(s)' => '',
        'month' => '',
        'months' => '',
        'month(s)' => 'msc(e)',
        'week' => '',
        'week(s)' => 'tden(tdny)',
        'year' => '',
        'years' => '',
        'year(s)' => 'rok(y)',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        'wrote' => 'napsal',
        'Message' => 'Zprva',
        'Error' => 'Chyba',
        'Bug Report' => 'Upozornn na chybu',
        'Attention' => 'Upozornn',
        'Warning' => 'Varovn',
        'Module' => 'Modul',
        'Modulefile' => 'Modulov soubor',
        'Subfunction' => 'Podfunkce',
        'Line' => 'Linka',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'Pklad',
        'Examples' => 'Pklady',
        'valid' => 'platn',
        'invalid' => 'neplatn',
        '* invalid' => '',
        'invalid-temporarily' => '',
        ' 2 minutes' => ' 2 minuty',
        ' 5 minutes' => ' 5 minut',
        ' 7 minutes' => ' 7 minut',
        '10 minutes' => '10 minut',
        '15 minutes' => '15 minut',
        'Mr.' => '',
        'Mrs.' => '',
        'Next' => '',
        'Back' => 'Zpt',
        'Next...' => '',
        '...Back' => '',
        '-none-' => '',
        'none' => 'dn',
        'none!' => 'dn!',
        'none - answered' => 'dn - odpovzeno',
        'please do not edit!' => 'prosme neupravujte!',
        'AddLink' => 'Pidat Odkaz',
        'Link' => 'Odkaz',
        'Unlink' => '',
        'Linked' => '',
        'Link (Normal)' => '',
        'Link (Parent)' => '',
        'Link (Child)' => '',
        'Normal' => 'Normln',
        'Parent' => '',
        'Child' => '',
        'Hit' => 'Pstup',
        'Hits' => 'Prstup',
        'Text' => '',
        'Lite' => 'Omezen',
        'User' => 'Uivatel',
        'Username' => 'Jmno uivatele',
        'Language' => 'Jazyk',
        'Languages' => 'Jazyky',
        'Password' => 'Heslo',
        'Salutation' => 'Osloven',
        'Signature' => 'Podpis',
        'Customer' => 'Klient',
        'CustomerID' => 'ID klienta',
        'CustomerIDs' => '',
        'customer' => 'klient',
        'agent' => '',
        'system' => 'systm',
        'Customer Info' => 'Informace o klientovi',
        'Customer Company' => '',
        'Company' => '',
        'go!' => 'jdi!',
        'go' => 'jdi',
        'All' => 'Ve',
        'all' => 've',
        'Sorry' => 'Omluva',
        'update!' => 'aktualizovat!',
        'update' => 'aktualizovat',
        'Update' => 'Aktualizovat',
        'Updated!' => '',
        'submit!' => 'Odeslat!',
        'submit' => 'odeslat',
        'Submit' => '',
        'change!' => 'zmnit!',
        'Change' => 'Zmnit',
        'change' => 'zmnit',
        'click here' => 'kliknte zde',
        'Comment' => 'Koment',
        'Valid' => 'Platnost',
        'Invalid Option!' => '',
        'Invalid time!' => '',
        'Invalid date!' => '',
        'Name' => 'Jmno',
        'Group' => 'Skupina',
        'Description' => 'Popis',
        'description' => 'popis',
        'Theme' => 'Design',
        'Created' => 'Vytvoeno',
        'Created by' => '',
        'Changed' => '',
        'Changed by' => '',
        'Search' => 'Vyhledat',
        'and' => 'a',
        'between' => '',
        'Fulltext Search' => '',
        'Data' => '',
        'Options' => 'Monosti',
        'Title' => '',
        'Item' => '',
        'Delete' => 'Smazat',
        'Edit' => 'Editovat',
        'View' => 'Nhled',
        'Number' => '',
        'System' => 'Systm',
        'Contact' => 'Konktakt',
        'Contacts' => '',
        'Export' => '',
        'Up' => '',
        'Down' => '',
        'Add' => 'Pidat',
        'Added!' => '',
        'Category' => 'Kategorie',
        'Viewer' => '',
        'Expand' => '',
        'New message' => 'Nov zprva',
        'New message!' => 'Nov zprva!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosm, odpovzte na tento (tyto) tiket(y) pro nvrat do normlnho nhledu fronty!',
        'You got new message!' => 'Mte novou zprvu!',
        'You have %s new message(s)!' => 'Mte %s novou zprvu (novch zprv)!',
        'You have %s reminder ticket(s)!' => 'Mte %s upomnkov(ch) ticket()',
        'The recommended charset for your language is %s!' => 'Doporuen znakov sada pro V jazyk je %s!',
        'Passwords doesn\'t match! Please try it again!' => '',
        'Password is already in use! Please use an other password!' => '',
        'Password is already used! Please use an other password!' => '',
        'You need to activate %s first to use it!' => '',
        'No suggestions' => 'dn nvrhy',
        'Word' => 'Slovo',
        'Ignore' => 'Ignorovat',
        'replace with' => 'nahradit',
        'There is no account with that login name.' => 'dn et s tmto pihlaovacm jmnem neexistuje.',
        'Login failed! Your username or password was entered incorrectly.' => 'Pihlen nespn! Vae uivatelsk jmno i heslo bylo zadno nesprvn.',
        'Please contact your admin' => 'Kontaktujte, prosm, Vaeho administrtora',
        'Logout successful. Thank you for using OTRS!' => 'Odhlen bylo spsn. Dkujeme Vm za pouvn OTRS!',
        'Invalid SessionID!' => 'Neplatn ID relace!',
        'Feature not active!' => 'Funkce je neaktivn!',
        'Login is needed!' => '',
        'Password is needed!' => '',
        'License' => 'Licence',
        'Take this Customer' => '',
        'Take this User' => 'Pouj tohoto uivatele',
        'possible' => 'mon',
        'reject' => 'zamtnout',
        'reverse' => '',
        'Facility' => 'Funkce',
        'Timeover' => 'as vyprel',
        'Pending till' => 'ekn na vyzen do',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Z bezpenostnch dvod nepracujte se superuivatelskm tem - vytvote si novho uivatele!',
        'Dispatching by email To: field.' => 'Piadit podle e-mailu - pole KOMU:.',
        'Dispatching by selected Queue.' => 'Piadit do vybran fronty.',
        'No entry found!' => 'Nebyl nalezen dn zznam!',
        'Session has timed out. Please log in again.' => 'Relace vyprela. Prosm, pihlate se znovu.',
        'No Permission!' => '',
        'To: (%s) replaced with database email!' => 'To: (%s) nahrazeno emailem z databze!',
        'Cc: (%s) added database email!' => '',
        '(Click here to add)' => '(Pro pidn kliknte zde)',
        'Preview' => 'Zobrazit',
        'Package not correctly deployed! You should reinstall the Package again!' => '',
        'Added User "%s"' => '',
        'Contract' => '',
        'Online Customer: %s' => '',
        'Online Agent: %s' => '',
        'Calendar' => '',
        'File' => '',
        'Filename' => 'Nzev souboru',
        'Type' => 'Typ',
        'Size' => '',
        'Upload' => '',
        'Directory' => '',
        'Signed' => '',
        'Sign' => '',
        'Crypted' => '',
        'Crypt' => '',
        'Office' => '',
        'Phone' => '',
        'Fax' => '',
        'Mobile' => '',
        'Zip' => '',
        'City' => '',
        'Street' => '',
        'Country' => '',
        'Location' => '',
        'installed' => '',
        'uninstalled' => '',
        'Security Note: You should activate %s because application is already running!' => '',
        'Unable to parse Online Repository index document!' => '',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => '',
        'No Packages or no new Packages in selected Online Repository!' => '',
        'printed at' => '',
        'Dear Mr. %s,' => '',
        'Dear Mrs. %s,' => '',
        'Dear %s,' => '',
        'Hello %s,' => '',
        'This account exists.' => '',
        'New account created. Sent Login-Account to %s.' => '',
        'Please press Back and try again.' => '',
        'Sent password token to: %s' => '',
        'Sent new password to: %s' => '',
        'Invalid Token!' => '',
        'For more info see:' => '',
        'Package verification failed!' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Header' => '',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'Led',
        'Feb' => 'no',
        'Mar' => 'Be',
        'Apr' => 'Dub',
        'May' => 'Kv',
        'Jun' => 'vc',
        'Jul' => 'er',
        'Aug' => 'Srp',
        'Sep' => 'Z',
        'Oct' => 'j',
        'Nov' => 'Lis',
        'Dec' => 'Pro',
        'January' => '',
        'February' => '',
        'March' => '',
        'April' => '',
        'June' => '',
        'July' => '',
        'August' => '',
        'September' => '',
        'October' => '',
        'November' => '',
        'December' => '',

        # Template: AAANavBar
        'Admin-Area' => 'Administran zna',
        'Agent-Area' => 'Zna agent',
        'Ticket-Area' => '',
        'Logout' => 'Odhlsit',
        'Agent Preferences' => '',
        'Preferences' => 'Nastaven',
        'Agent Mailbox' => '',
        'Stats' => 'Statistiky',
        'Stats-Area' => '',
        'Admin' => '',
        'Customer Users' => '',
        'Customer Users <-> Groups' => '',
        'Users <-> Groups' => '',
        'Roles' => '',
        'Roles <-> Users' => '',
        'Roles <-> Groups' => '',
        'Salutations' => '',
        'Signatures' => '',
        'Email Addresses' => '',
        'Notifications' => '',
        'Category Tree' => '',
        'Admin Notification' => '',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Nastaven spn aktualizovno!',
        'Mail Management' => 'Sprva e-mail',
        'Frontend' => 'Rozhran',
        'Other Options' => 'Jin monosti',
        'Change Password' => '',
        'New password' => '',
        'New password again' => '',
        'Select your QueueView refresh time.' => 'Vyberte si dobu obnoven nhledu fronty.',
        'Select your frontend language.' => 'Vyberte si jazyk Vaeho rozhran.',
        'Select your frontend Charset.' => 'Vyberte si znakovou sadu Vaeho rozhran.',
        'Select your frontend Theme.' => 'Vyberte si design Vaeho rozhran.',
        'Select your frontend QueueView.' => 'Vyberte si nhled fronty Vaeho rozhran.',
        'Spelling Dictionary' => 'Slovnk kontroly pravopisu',
        'Select your default spelling dictionary.' => 'Vyberte si V vchoz pravopisn slovnk',
        'Max. shown Tickets a page in Overview.' => 'Max. zobrazench tiket v pehledu na strnku',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => '',
        'Can\'t update password, invalid characters!' => '',
        'Can\'t update password, need min. 8 characters!' => '',
        'Can\'t update password, need 2 lower and 2 upper characters!' => '',
        'Can\'t update password, need min. 1 digit!' => '',
        'Can\'t update password, need min. 2 characters!' => '',

        # Template: AAAStats
        'Stat' => '',
        'Please fill out the required fields!' => '',
        'Please select a file!' => '',
        'Please select an object!' => '',
        'Please select a graph size!' => '',
        'Please select one element for the X-axis!' => '',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => '',
        'If you use a checkbox you have to select some attributes of the select field!' => '',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '',
        'The selected end time is before the start time!' => '',
        'You have to select one or more attributes from the select field!' => '',
        'The selected Date isn\'t valid!' => '',
        'Please select only one or two elements via the checkbox!' => '',
        'If you use a time scale element you can only select one element!' => '',
        'You have an error in your time selection!' => '',
        'Your reporting time interval is too small, please use a larger time scale!' => '',
        'The selected start time is before the allowed start time!' => '',
        'The selected end time is after the allowed end time!' => '',
        'The selected time period is larger than the allowed time period!' => '',
        'Common Specification' => '',
        'Xaxis' => '',
        'Value Series' => '',
        'Restrictions' => '',
        'graph-lines' => '',
        'graph-bars' => '',
        'graph-hbars' => '',
        'graph-points' => '',
        'graph-lines-points' => '',
        'graph-area' => '',
        'graph-pie' => '',
        'extended' => '',
        'Agent/Owner' => '',
        'Created by Agent/Owner' => '',
        'Created Priority' => '',
        'Created State' => '',
        'Create Time' => '',
        'CustomerUserLogin' => '',
        'Close Time' => '',
        'TicketAccumulation' => '',
        'Attributes to be printed' => '',
        'Sort sequence' => '',
        'Order by' => '',
        'Limit' => '',
        'Ticketlist' => '',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '',
        'Total Time' => '',
        'Ticket Average' => '',
        'Ticket Min Time' => '',
        'Ticket Max Time' => '',
        'Number of Tickets' => '',
        'Article Average' => '',
        'Article Min Time' => '',
        'Article Max Time' => '',
        'Number of Articles' => '',
        'Accounted time by Agent' => '',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => '',
        'Ticket Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Zmek',
        'Unlock' => 'Zmek',
        'History' => 'Historie',
        'Zoom' => 'Zobrazit',
        'Age' => 'St',
        'Bounce' => 'Odeslat zpt',
        'Forward' => 'Pedat',
        'From' => 'Od',
        'To' => 'Komu',
        'Cc' => 'Kopie',
        'Bcc' => 'Slep kopie',
        'Subject' => 'Pedmt',
        'Move' => 'Pesunout',
        'Queue' => 'Fronta',
        'Priority' => 'Priorita',
        'Priority Update' => '',
        'State' => 'Stav',
        'Compose' => 'Sestavit',
        'Pending' => 'ek na vyzen',
        'Owner' => 'Vlastnk',
        'Owner Update' => '',
        'Responsible' => '',
        'Responsible Update' => '',
        'Sender' => 'Odeslatel',
        'Article' => 'Poloka',
        'Ticket' => 'Tiket',
        'Createtime' => 'Doba vytvoen',
        'plain' => 'jednoduch',
        'Email' => '',
        'email' => '',
        'Close' => 'Zavt',
        'Action' => 'Akce',
        'Attachment' => 'Ploha',
        'Attachments' => 'Plohy',
        'This message was written in a character set other than your own.' => 'Tato zprva byla napsna v jin znakov sad ne Vae.',
        'If it is not displayed correctly,' => 'Pokud nen zobrazeno sprvn,',
        'This is a' => 'Toto je',
        'to open it in a new window.' => 'pro oteven v novm okn.',
        'This is a HTML email. Click here to show it.' => 'Toto je HTML email. Pro zobrazen kliknte zde.',
        'Free Fields' => '',
        'Merge' => '',
        'merged' => '',
        'closed successful' => 'uzaveno - vyeeno',
        'closed unsuccessful' => 'uzaveno - nevyeeno',
        'new' => 'nov',
        'open' => 'otevt',
        'Open' => '',
        'closed' => 'uzaveno',
        'Closed' => '',
        'removed' => 'odstrann',
        'pending reminder' => 'upomnka pi ekn na vyzen',
        'pending auto' => '',
        'pending auto close+' => 'ek na vyzen - automaticky zavt+',
        'pending auto close-' => 'ek na vyzen - automaticky zavt-',
        'email-external' => 'extern email',
        'email-internal' => 'intern email',
        'note-external' => 'poznmka-extern',
        'note-internal' => 'poznmka-intern',
        'note-report' => 'poznmka-report',
        'phone' => 'telefon',
        'sms' => '',
        'webrequest' => 'poadavek pes web',
        'lock' => 'zameno',
        'unlock' => 'nezamen',
        'very low' => 'velmi nzk',
        'low' => 'nzk',
        'normal' => 'normaln',
        'high' => 'vysok',
        'very high' => 'velmi vysok',
        '1 very low' => '1 velmi nzk',
        '2 low' => '2 nzk',
        '3 normal' => '3 normln',
        '4 high' => '4 vysok',
        '5 very high' => '5 velmi vysok',
        'Ticket "%s" created!' => 'Tiket "%s" vytvoen!',
        'Ticket Number' => '',
        'Ticket Object' => '',
        'No such Ticket Number "%s"! Can\'t link it!' => '',
        'Don\'t show closed Tickets' => 'Nezobrazovat uzaven tikety',
        'Show closed Tickets' => 'Zobrazit zaven tikety',
        'New Article' => 'Nov poloka',
        'Email-Ticket' => '',
        'Create new Email Ticket' => '',
        'Phone-Ticket' => '',
        'Search Tickets' => '',
        'Edit Customer Users' => '',
        'Edit Customer Company' => '',
        'Bulk Action' => '',
        'Bulk Actions on Tickets' => '',
        'Send Email and create a new Ticket' => '',
        'Create new Email Ticket and send this out (Outbound)' => '',
        'Create new Phone Ticket (Inbound)' => '',
        'Overview of all open Tickets' => '',
        'Locked Tickets' => '',
        'Watched Tickets' => '',
        'Watched' => '',
        'Subscribe' => '',
        'Unsubscribe' => '',
        'Lock it to work on it!' => '',
        'Unlock to give it back to the queue!' => '',
        'Shows the ticket history!' => '',
        'Print this ticket!' => '',
        'Change the ticket priority!' => '',
        'Change the ticket free fields!' => '',
        'Link this ticket to an other objects!' => '',
        'Change the ticket owner!' => '',
        'Change the ticket customer!' => '',
        'Add a note to this ticket!' => '',
        'Merge this ticket!' => '',
        'Set this ticket to pending!' => '',
        'Close this ticket!' => '',
        'Look into a ticket!' => '',
        'Delete this ticket!' => '',
        'Mark as Spam!' => '',
        'My Queues' => '',
        'Shown Tickets' => '',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',
        'Ticket %s: first response time is over (%s)!' => '',
        'Ticket %s: first response time will be over in %s!' => '',
        'Ticket %s: update time is over (%s)!' => '',
        'Ticket %s: update time will be over in %s!' => '',
        'Ticket %s: solution time is over (%s)!' => '',
        'Ticket %s: solution time will be over in %s!' => '',
        'There are more escalated tickets!' => '',
        'New ticket notification' => 'Nov oznmen tiketu',
        'Send me a notification if there is a new ticket in "My Queues".' => '',
        'Follow up notification' => 'Nsledujc oznmen',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Poli mi oznmen, pokud klient pole nsledujc a jsem vlastnk tohoto tiketu.',
        'Ticket lock timeout notification' => 'Oznmen o vypren asu uzamen tiketu',
        'Send me a notification if a ticket is unlocked by the system.' => 'Poli mi oznmen, pokud je tiket odemknut systmem.',
        'Move notification' => 'Pesunout oznmen',
        'Send me a notification if a ticket is moved into one of "My Queues".' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => '',
        'Custom Queue' => 'Vlastn fronta',
        'QueueView refresh time' => 'Doba obnoven nhledu fronty',
        'Screen after new ticket' => '',
        'Select your screen after creating a new ticket.' => '',
        'Closed Tickets' => 'Uzaven Tikety',
        'Show closed tickets.' => 'Ukzat uzaven tikety.',
        'Max. shown Tickets a page in QueueView.' => 'Max. zobrazench tiket v nhledu fronty na strnku',
        'Watch notification' => '',
        'Send me a notification of an watched ticket like an owner of an ticket.' => '',
        'Out Of Office' => '',
        'Select your out of office time.' => '',
        'CompanyTickets' => '',
        'MyTickets' => '',
        'New Ticket' => '',
        'Create new Ticket' => '',
        'Customer called' => '',
        'phone call' => '',
        'Reminder Reached' => '',
        'Reminder Tickets' => '',
        'Escaladed Tickets' => '',
        'New Tickets' => '',
        'Open Tickets / Need to be answered' => '',
        'Responses' => 'Odpovdi',
        'Responses <-> Queue' => '',
        'Auto Responses' => '',
        'Auto Responses <-> Queue' => '',
        'Attachments <-> Responses' => '',
        'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'AutoReject sent to "%s".',
        'History::SendAutoReply' => 'AutoReply sent to "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Forwarded to "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'Email sent to "%s".',
        'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
        'History::SendCustomerNotification' => 'Notification sent to "%s".',
        'History::EmailAgent' => 'Email sent to customer.',
        'History::EmailCustomer' => 'Added email. %s',
        'History::PhoneCallAgent' => 'Agent called customer.',
        'History::PhoneCallCustomer' => 'Customer called us.',
        'History::AddNote' => 'Added note (%s)',
        'History::Lock' => 'Locked ticket.',
        'History::Unlock' => 'Unlocked ticket.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Updated: %s',
        'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Updated: %s',
        'History::StateUpdate' => 'Old: "%s" New: "%s"',
        'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Customer request via web.',
        'History::TicketLinkAdd' => 'Added link to ticket "%s".',
        'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Ne',
        'Mon' => 'Po',
        'Tue' => 't',
        'Wed' => 'St',
        'Thu' => 't',
        'Fri' => 'P',
        'Sat' => 'So',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Sprva ploh',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Sprva automatickch odpovd',
        'Response' => 'Odpov',
        'Auto Response From' => 'Automatick odpov Od',
        'Note' => 'Poznmka',
        'Useable options' => 'Dostupn monosti',
        'To get the first 20 character of the subject.' => '',
        'To get the first 5 lines of the email.' => '',
        'To get the realname of the sender (if given).' => '',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => '',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => '',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => '',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => '',
        'Search for' => '',
        'Add Customer Company' => '',
        'Add a new Customer Company.' => '',
        'List' => '',
        'This values are required.' => '',
        'This values are read only.' => '',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'Vytven zprva byla uzavena. Opoutm.',
        'This window must be called from compose window' => 'Toto okno mus bt vyvolno z okna vytven',
        'Customer User Management' => 'Sprva Klient',
        'Add Customer User' => '',
        'Source' => '',
        'Create' => '',
        'Customer user will be needed to have a customer history and to login via customer panel.' => '',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => '',
        'Change %s settings' => 'Zmnit nastaven %s',
        'Select the user:group permissions.' => 'Vybrat uivatele:prva skupiny',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Pokud nebylo nic vybrno, nejsou v tto skupin dn prva (tikety nebudou pro uivatele dostupn).',
        'Permission' => 'Prva',
        'ro' => 'jen ten',
        'Read only access to the ticket in this group/queue.' => 'Pstup pouze pro ten tiketu v tto skupin/ad.',
        'rw' => 'ten/psan',
        'Full read and write access to the tickets in this group/queue.' => 'Pln pstup pro ten a psan do tiket v tto skupin/front.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => '',
        'CustomerUser' => 'Klient',
        'Service' => '',
        'Edit default services.' => '',
        'Search Result' => 'Vsledky vyhledvn',
        'Allocate services to CustomerUser' => '',
        'Active' => '',
        'Allocate CustomerUser to service' => '',

        # Template: AdminEmail
        'Message sent to' => 'Zprva odeslna',
        'Recipents' => 'Adresti',
        'Body' => 'Tlo',
        'Send' => '',

        # Template: AdminGenericAgent
        'GenericAgent' => '',
        'Job-List' => '',
        'Last run' => '',
        'Run Now!' => '',
        'x' => '',
        'Save Job as?' => '',
        'Is Job Valid?' => '',
        'Is Job Valid' => '',
        'Schedule' => '',
        'Currently this generic agent job will not run automatically.' => '',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fulltextov vyhledvn v poloce (nap. "Mar*in" or "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '(nap. 10*5155 or 105658*)',
        '(e. g. 234321)' => '(nap. 234321)',
        'Customer User Login' => 'Pihlen klienta',
        '(e. g. U5150)' => '(nap. U5150)',
        'SLA' => '',
        'Agent' => '',
        'Ticket Lock' => '',
        'TicketFreeFields' => '',
        'Create Times' => '',
        'No create time settings.' => '',
        'Ticket created' => 'Tiket vytvoen',
        'Ticket created between' => 'Tiket vytvoen mezi',
        'Close Times' => '',
        'No close time settings.' => '',
        'Ticket closed' => '',
        'Ticket closed between' => '',
        'Pending Times' => '',
        'No pending time settings.' => '',
        'Ticket pending time reached' => '',
        'Ticket pending time reached between' => '',
        'Escalation Times' => '',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - First Response Time' => '',
        'No escalation time settings.' => '',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - Update Time' => '',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - Solution Time' => '',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'New Service' => '',
        'New SLA' => '',
        'New Priority' => '',
        'New Queue' => 'Nov fronta',
        'New State' => '',
        'New Agent' => '',
        'New Owner' => 'Nov vlastnk',
        'New Customer' => '',
        'New Ticket Lock' => '',
        'New Type' => '',
        'New Title' => '',
        'New TicketFreeFields' => '',
        'Add Note' => 'Pidat poznmku',
        'Time units' => 'Jednotky asu',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
        'Delete tickets' => '',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => '',
        'Send Notification' => '',
        'Param 1' => '',
        'Param 2' => '',
        'Param 3' => '',
        'Param 4' => '',
        'Param 5' => '',
        'Param 6' => '',
        'Send agent/customer notifications on changes' => '',
        'Save' => '',
        '%s Tickets affected! Do you really want to use this job?' => '',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Sprva skupiny',
        'Add Group' => '',
        'Add a new Group.' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Skupina administrtora m pstup do administran a statistick zny.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Vytvoit nov skupiny pro piazen prv pstup ruznm skupinm agent (nap. oddlen nkupu, oddlen podpory, oddlen prodeje...).',
        'It\'s useful for ASP solutions.' => 'To je vhodn pro een ASP',

        # Template: AdminLog
        'System Log' => 'Log systmu',
        'Time' => '',

        # Template: AdminMailAccount
        'Mail Account Management' => '',
        'Host' => 'Hostitel',
        'Trusted' => 'Oveno',
        'Dispatching' => 'Zaazen',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Vechny pchoz emaily z danho tu budou zaazeny do vybran fronty!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

        # Template: AdminNavigationBar
        'Users' => '',
        'Groups' => 'Skupiny',
        'Misc' => 'Rzn',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'Sprva oznmen',
        'Add Notification' => '',
        'Add a new Notification.' => '',
        'Name is required!' => '',
        'Event is required!' => '',
        'A message should have a subject!' => 'Zprva by mla mt pedmt!',
        'A message should have a body!' => 'Zprva by mla mt tlo!',
        'Recipient' => '',
        'Group based' => '',
        'Recipient' => '',
        'Agent based' => '',
        'Email based' => '',
        'Event' => '',
        'Article Type' => '',
        'Only for ArticleCreate Event.' => '',
        'Subject match' => '',
        'Only for ArticleCreate Event.' => '',
        'Body match' => '',
        'Notifications are sent to an agent or a customer.' => 'Oznmen jsou odeslna agentovi i klientovi',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminNotificationForm
        'Notification' => '',

        # Template: AdminPackageManager
        'Package Manager' => '',
        'Uninstall' => '',
        'Version' => '',
        'Do you really want to uninstall this package?' => '',
        'Reinstall' => '',
        'Do you really want to reinstall this package (all manual changes get lost)?' => '',
        'Continue' => '',
        'Install' => '',
        'Package' => '',
        'Online Repository' => '',
        'Vendor' => '',
        'Module documentation' => '',
        'Upgrade' => '',
        'Local Repository' => '',
        'Status' => 'Stav',
        'Overview' => 'Pehled',
        'Download' => '',
        'Rebuild' => '',
        'ChangeLog' => '',
        'Date' => '',
        'Filelist' => '',
        'Download file from package!' => '',
        'Required' => '',
        'PrimaryKey' => '',
        'AutoIncrement' => '',
        'SQL' => '',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => '',
        'This feature is enabled!' => '',
        'Just use this feature if you want to log each request.' => '',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => '',
        'This feature is disabled!' => '',
        'Enable it here!' => '',
        'Logfile too large!' => '',
        'Logfile too large, you need to reset it!' => '',
        'Range' => '',
        'Interface' => '',
        'Requests' => '',
        'Min Response' => '',
        'Max Response' => '',
        'Average Response' => '',
        'Period' => '',
        'Min' => '',
        'Max' => '',
        'Average' => '',

        # Template: AdminPGPForm
        'PGP Management' => '',
        'Result' => '',
        'Identifier' => '',
        'Bit' => '',
        'Key' => 'Kl',
        'Fingerprint' => '',
        'Expires' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => '',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => '',
        'Filtername' => '',
        'Stop after match' => '',
        'Match' => 'Obsahuje',
        'Value' => 'Hodnota',
        'Set' => 'Nastavit',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => '',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Řízení priorit',
        'Add Priority' => 'Dodat prioritou',
        'Add a new Priority.' => 'Dodat novou prioritou',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => '',
        'settings' => '',

        # Template: AdminQueueForm
        'Queue Management' => 'Sprva front',
        'Sub-Queue of' => 'Podfronta ',
        'Unlock timeout' => 'as do odemknut',
        '0 = no unlock' => '0 = dn odemknut',
        'Only business hours are counted.' => '',
        '0 = no escalation' => '0 = dn stupovn',
        'Notify by' => '',
        'Follow up Option' => 'Nsledujc volba',
        'Ticket lock after a follow up' => 'Zamknout tiket po nsledujcm',
        'Systemaddress' => 'Systmov adresa',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Pokud agent uzamkne tiket a neodele v tto dob odpov, tiket bude automaticky odemknut. Tak se stane tiket viditeln pro vechny ostatn agenty.',
        'Escalation time' => 'Doba stupovn',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => '',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Pokud je tiket uzaven a klient odele nsledujc, tiket bude pro starho vlastnka uzamknut.',
        'Will be the sender address of this queue for email answers.' => 'Bude adresou odeslatele z tto fronty pro emailov odpovdi.',
        'The salutation for email answers.' => 'Osloven pro emailov odpovdi.',
        'The signature for email answers.' => 'Podpis pro emailov odpovdi.',
        'Customer Move Notify' => 'Oznmen Klientovi o zmn fronty',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS pole klientovi emailem oznmen, pokud bude tiket pesunut.',
        'Customer State Notify' => 'Oznmen Klientovi o zmn stavu',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn stav tiketu.',
        'Customer Owner Notify' => 'Oznmen Klientovi o zmn vlastnka',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn vlastnk tiketu.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => '',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Odpov',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => '',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Sprva odpovd',
        'A response is default text to write faster answer (with default text) to customers.' => 'Odpov je obsahuje vchoz text slouc k rychlej reakci (spolu s vchozm textem) klientm.',
        'Don\'t forget to add a new response a queue!' => 'Nezapomete pidat novou reakci odpove do fronty!',
        'The current ticket state is' => 'Aktuln stav tiketu je',
        'Your email address is new' => '',

        # Template: AdminRoleForm
        'Role Management' => '',
        'Add Role' => '',
        'Add a new Role.' => '',
        'Create a role and put groups in it. Then add the role to the users.' => '',
        'It\'s useful for a lot of users and groups.' => '',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => '',
        'move_into' => 'pesunout do',
        'Permissions to move tickets into this group/queue.' => 'Prva pesunout tikety do tto skupiny/fronty',
        'create' => 'vytvoit',
        'Permissions to create tickets in this group/queue.' => 'Prva vytvoit tikety v tto skupin/front',
        'owner' => 'vlastnk',
        'Permissions to change the ticket owner in this group/queue.' => 'Prva zmnit vlastnk tiketu v tto skupin/front',
        'priority' => 'priorita',
        'Permissions to change the ticket priority in this group/queue.' => 'Prva zmnit prioritu tiketu v tto skupin/front',

        # Template: AdminRoleGroupForm
        'Role' => '',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => '',
        'Select the role:user relations.' => '',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Sprva osloven',
        'Add Salutation' => '',
        'Add a new Salutation.' => '',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBoxForm
        'SQL Box' => '',
        'Go' => '',
        'Select Box Result' => 'Vsledek SQL dotazu',

        # Template: AdminService
        'Service Management' => '',
        'Add Service' => '',
        'Add a new Service.' => '',
        'Sub-Service of' => '',

        # Template: AdminSession
        'Session Management' => 'Sprva relace',
        'Sessions' => 'Relace',
        'Uniq' => 'Poet',
        'Kill all sessions' => '',
        'Session' => '',
        'Content' => '',
        'kill session' => 'zruit relaci',

        # Template: AdminSignatureForm
        'Signature Management' => 'Sprva podpis',
        'Add Signature' => '',
        'Add a new Signature.' => '',

        # Template: AdminSLA
        'SLA Management' => '',
        'Add SLA' => '',
        'Add a new SLA.' => '',

        # Template: AdminSMIMEForm
        'S/MIME Management' => '',
        'Add Certificate' => '',
        'Add Private Key' => '',
        'Secret' => '',
        'Hash' => '',
        'In this way you can directly edit the certification and private keys in file system.' => '',

        # Template: AdminStateForm
        'State Management' => '',
        'Add State' => '',
        'Add a new State.' => '',
        'State Type' => 'Typ stavu',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Ujistte se, e jste aktualizovali tak vchoz hodnoty ve Vaem Kernel/Config.pm!',
        'See also' => 'Viz. tak',

        # Template: AdminSysConfig
        'SysConfig' => '',
        'Group selection' => '',
        'Show' => '',
        'Download Settings' => '',
        'Download all system config changes.' => '',
        'Load Settings' => '',
        'Subgroup' => '',
        'Elements' => '',

        # Template: AdminSysConfigEdit
        'Config Options' => '',
        'Default' => '',
        'New' => 'Nov',
        'New Group' => '',
        'Group Ro' => '',
        'New Group Ro' => '',
        'NavBarName' => '',
        'NavBar' => '',
        'Image' => '',
        'Prio' => '',
        'Block' => '',
        'AccessKey' => '',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Sprva emailovch adres systmu',
        'Add System Address' => '',
        'Add a new System Address.' => '',
        'Realname' => 'Skuten jmno',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Vechny pchoz emaily obsahujc tohoto adresta (v poli KOMU) budou zaazeny to vybran fronty!',

        # Template: AdminTypeForm
        'Type Management' => '',
        'Add Type' => '',
        'Add a new Type.' => '',

        # Template: AdminUserForm
        'User Management' => 'Sprva uivatel',
        'Add User' => '',
        'Add a new Agent.' => '',
        'Login as' => '',
        'Firstname' => 'Kestn jmno',
        'Lastname' => 'Pjmen',
        'Start' => '',
        'End' => '',
        'User will be needed to handle tickets.' => 'Uivatel bude potebovat prva pro ovldn tiket.',
        'Don\'t forget to add a new user to groups and/or roles!' => '',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => '',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Adres',
        'Return to the compose screen' => 'Vrtit se zpt do okna vytven',
        'Discard all changes and return to the compose screen' => 'Zruit vechny zmny a vrtit se zpt do okna vytven',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',
        'Settings' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => '',
        'Object' => '',
        'Link Object' => '',
        'with' => '',
        'Select' => 'Vybrat',
        'Unlink Object: %s' => '',

        # Template: AgentLookup
        'Lookup' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Funkce na kontrolu pravopisu',
        'spelling error(s)' => 'chyba(y) v pravopisu',
        'or' => 'nebo',
        'Apply these changes' => 'Aplikovat tyto zmny',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => '',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => '',
        'Fixed' => '',
        'Please select only one element or turn off the button \'Fixed\'.' => '',
        'Absolut Period' => '',
        'Between' => '',
        'Relative Period' => '',
        'The last' => '',
        'Finish' => '',
        'Here you can make restrictions to your stat.' => '',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => '',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => '',
        'Permissions' => '',
        'Format' => '',
        'Graphsize' => '',
        'Sum rows' => '',
        'Sum columns' => '',
        'Cache' => '',
        'Required Field' => '',
        'Selection needed' => '',
        'Explanation' => '',
        'In this form you can select the basic specifications.' => '',
        'Attribute' => '',
        'Title of the stat.' => '',
        'Here you can insert a description of the stat.' => '',
        'Dynamic-Object' => '',
        'Here you can select the dynamic object you want to use.' => '',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '',
        'Static-File' => '',
        'For very complex stats it is possible to include a hardcoded file.' => '',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => '',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => '',
        'Multiple selection of the output format.' => '',
        'If you use a graph as output format you have to select at least one graph size.' => '',
        'If you need the sum of every row select yes' => '',
        'If you need the sum of every column select yes.' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => '',
        '(Note: Useful for big databases and low performance server)' => '',
        'With an invalid stat it isn\'t feasible to generate a stat.' => '',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => '',
        'Scale' => '',
        'minimal' => '',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => '',
        'maximal period' => '',
        'minimal scale' => '',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => '',
        'File is not a Stats config' => '',
        'No File selected' => '',

        # Template: AgentStatsOverview
        'Results' => 'Vsledky',
        'Total hits' => 'Celkov poet zznam',
        'Page' => 'Strana',

        # Template: AgentStatsPrint
        'Print' => 'Tisknout',
        'No Element selected.' => '',

        # Template: AgentStatsView
        'Export Config' => '',
        'Information about the Stat' => '',
        'Exchange Axis' => '',
        'Configurable params of static stat' => '',
        'No element selected.' => '',
        'maximal period from' => '',
        'to' => '',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Zprva by mla obsahovat Komu: pjemce!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Muste mt  uvedenu emailovou adresu (nap. klient@priklad.cz) v poli Komu:!',
        'Bounce ticket' => 'Odeslat tiket zpt',
        'Ticket locked!' => 'Tiket zamknut!',
        'Ticket unlock!' => 'Tiket odemknut!',
        'Bounce to' => 'Odeslat zpt',
        'Next ticket state' => 'Nsledujc stav tiketu',
        'Inform sender' => 'Informovat odeslatele',
        'Send mail!' => 'Poslat mail!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Potebujete tovat dobu!',
        'Ticket Bulk Action' => '',
        'Spell Check' => 'Kontrola pravopisu',
        'Note type' => 'Typ poznmky',
        'Next state' => 'Nasledujc stav',
        'Pending date' => 'Datum ekn na vyzen',
        'Merge to' => '',
        'Merge to oldest' => '',
        'Link together' => '',
        'Link to Parent' => '',
        'Unlock Tickets' => '',

        # Template: AgentTicketClose
        'Ticket Type is required!' => '',
        'A required field is:' => '',
        'Close ticket' => 'Zavt tiket',
        'Previous Owner' => 'Pedchoz vlastnk',
        'Inform Agent' => '',
        'Optional' => '',
        'Inform involved Agents' => '',
        'Attach' => 'Pipojit',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'Zprva mus bt pravopisn zkontrolovan!',
        'Compose answer for ticket' => 'Sestavit odpov pro tiket',
        'Pending Date' => 'Doba ekn na vyzen',
        'for pending* states' => 'pro stavy ekn na vyzen*',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Zmnit klienta tiketu',
        'Set customer user and customer id of a ticket' => 'Nastavit klienta a nastavit ID klienta tiketu',
        'Customer User' => 'Klient - Uivatel',
        'Search Customer' => 'Vyhledat klienta',
        'Customer Data' => 'Data klienta',
        'Customer history' => 'Historie klienta',
        'All customer tickets.' => 'Vechny tikety klienta',

        # Template: AgentTicketEmail
        'Compose Email' => '',
        'new ticket' => 'nov tiket',
        'Refresh' => '',
        'Clear To' => '',
        'All Agents' => 'Vichni agenti',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Typ poloky',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Zmnit pln text tiketu',

        # Template: AgentTicketHistory
        'History of' => 'Historie',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => '',
        'Ticket Merge' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Pesunout tiket',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Pidat poznmku k tiketu',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => '',
        'Service Time' => '',
        'Update Time' => '',
        'Solution Time' => '',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => '',

        # Template: AgentTicketOverviewNavBar
        'Filter' => '',
        'Change search options' => 'Zmnit monosti vyhledvn',
        'Tickets' => 'Tikety',
        'of' => 'z',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Odpovdt',
        'Contact customer' => 'Kontaktovat klienta',
        'Change queue' => 'Zmnit frontu',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'setdit nahoru',
        'up' => 'nahoru',
        'sort downward' => 'setdit dol',
        'down' => 'dol',
        'Escalation in' => 'Stupovn v',
        'Locked' => '',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Zmnit vlastnka tiketu',

        # Template: AgentTicketPending
        'Set Pending' => 'Nastavit - ek na vyzen',

        # Template: AgentTicketPhone
        'Phone call' => 'Telefon hovor',
        'Clear From' => 'Vymazat pole Od',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Jednoduch',

        # Template: AgentTicketPrint
        'Ticket-Info' => '',
        'Accounted time' => 'tovan doba',
        'Linked-Object' => '',
        'by' => 'pes',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Zmnit dleitost tiketu',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Zobrazen tikety',
        'Tickets available' => 'Tiket k dispozici',
        'All tickets' => 'Vechny tikety',
        'Queues' => 'ady',
        'Ticket escalation!' => 'Eskalace tiket',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => '',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Hledn tiketu',
        'Profile' => 'Profil',
        'Search-Template' => 'Forma vyhledvn',
        'TicketFreeText' => 'Voln text tiketu',
        'Created in Queue' => '',
        'Article Create Times' => '',
        'Article created' => '',
        'Article created between' => '',
        'Change Times' => '',
        'No change time settings.' => '',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Result Form' => 'Forma vsledku',
        'Save Search-Profile as Template?' => 'Uloit profil vyhledvn jako ablonu?',
        'Yes, save it with name' => 'Ano, uloit pod nzvem',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => '',
        'Collapse View' => '',
        'Split' => 'Rozdlit',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => '',
        'Save filter settings as default' => '',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Jt zpt',

        # Template: CustomerFooter
        'Powered by' => 'Vytvoeno',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => '',
        'Lost your password?' => 'Ztratil/a jste heslo?',
        'Request new password' => 'Podat o nov heslo',
        'Create Account' => 'Vytvoit et',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Vtejte %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Doba',
        'No time settings.' => 'dn nastaven doby',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Kliknte zde pro nahlen chyby!',

        # Template: Footer
        'Top of Page' => 'Hlava strnky',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Dom',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Web-instaltor',
        'Welcome to %s' => 'Vtejte v %s',
        'Accept license' => '',
        'Don\'t accept license' => '',
        'Admin-User' => 'Administrtor',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Admin-Password' => '',
        'Database-User' => '',
        'default \'hot\'' => 'vchoz \'hot\'',
        'DB connect host' => '',
        'Database' => '',
        'Default Charset' => 'Vchoz znakov sada',
        'utf8' => '',
        'false' => '',
        'SystemID' => 'Systmov ID',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identita systmu. Kad slo tiketu a ID kad HTTP relace zan tmto slem)',
        'System FQDN' => 'Systm FQDN',
        '(Full qualified domain name of your system)' => '(Platn nzev domny pro v systm (FQDN))',
        'AdminEmail' => 'Email Administrtora',
        '(Email of the system admin)' => '(Email administrtora systmu)',
        'Organization' => 'Organizace',
        'Log' => '',
        'LogModule' => 'Log Modul',
        '(Used log backend)' => '(Pouit vstup do logu)',
        'Logfile' => 'Log soubor',
        '(Logfile just needed for File-LogModule!)' => '(Pro logovn do souboru je nutn zadat nzev souboru logu!)',
        'Webfrontend' => 'Webove rozhran',
        'Use utf-8 it your database supports it!' => 'Pouijte utf-8 pokud to Vae databze podporuje',
        'Default Language' => 'Vchoz jazyk',
        '(Used default language)' => '(Pouit vchoz jazyk)',
        'CheckMXRecord' => 'Kontrolovat MX zznam',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontroluj MX zznamy pouitch emailovch adres pi sestavovn odpovdi. Nepouvejte pokud OTRS server pipojen pomoc vyten linky!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Abyste mohli pouvat OTRS, muste zadat nsledujc dek do Vaeho pkazovho dku (Terminal/Shell) jako root.',
        'Restart your webserver' => 'Restartujte V webserver',
        'After doing so your OTRS is up and running.' => 'Po dokonen nsledujcch operac je V OTRS sputn a pob',
        'Start page' => 'vodn strnka',
        'Your OTRS Team' => 'V OTRS tm',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'dn prva',

        # Template: Notify
        'Important' => '',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'tisknuto',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'Testovac OTRS strnka',
        'Counter' => '',

        # Template: Warning

        # Template: YUI

        # Misc
        'Create Database' => 'Vytvoit Databazi',
        'DB Host' => 'Hostitel (server) databze',
        'Change roles <-> groups settings' => '',
        'Ticket Number Generator' => 'Genertor sel tiket',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiktor tiket. Nekte lid chtj nastavit nap. \'Tiket#\',  \'Hovor#\' nebo \'MujTiket#\')',
        'Create new Phone Ticket' => '',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
        'Symptom' => 'Pznak',
        'U' => 'Z-A',
        'Site' => 'Umstn',
        'Customer history search (e. g. "ID342425").' => 'Vyhledvn historie klienta (nap. "ID342425")',
        'Can not delete link with %s!' => '',
        'for agent firstname' => 'pro kestn jmno agenta',
        'Close!' => 'Zavt!',
        'No means, send agent and customer notifications on changes.' => '',
        'A web calendar' => '',
        'to get the realname of the sender (if given)' => 'pro zskan skutenho jmna odeslatele (pokud je zadno)',
        'OTRS DB Name' => 'Nzev OTRS databze',
        'Notification (Customer)' => '',
        'Select Source (for add)' => '',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
        'Child-Object' => '',
        'Queue ID' => 'ID fronty',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => '',
        'System History' => '',
        'customer realname' => 'skuten jmno klienta',
        'Pending messages' => 'Zprvy ekajc na vyzen',
        'Port' => '',
        'Modules' => '',
        'for agent login' => 'pro pihlen agenta',
        'Keyword' => 'Klov slovo',
        'Close type' => 'Zavt typ',
        'DB Admin User' => 'Administrtor databze',
        'for agent user id' => 'pro uivatelsk ID agenta',
        'Change user <-> group settings' => 'Zmnit uivatele <-> nastaven skupiny',
        'Problem' => 'Problm',
        'Escalation' => '',
        '"}' => '',
        'Order' => 'Seadit',
        'next step' => 'dal krok',
        'Follow up' => 'Nsledujc',
        'Customer history search' => 'Vyhledvn historie klienta',
        'Admin-Email' => 'Email administrtora',
        'Stat#' => '',
        'ArticleID' => 'ID poloky',
        'Keywords' => 'Klov slova',
        'Ticket Escalation View' => '',
        'Today' => '',
        'No * possible!' => 'dn * mon!',
        'Options ' => '',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
        'Message for new Owner' => 'Zprva pro novho vlastnka',
        'to get the first 5 lines of the email' => 'pro zskn prvnch 5 dk z emailu',
        'Sort by' => 'Setdit dle',
        'OTRS DB Password' => 'Heslo OTRS databze',
        'Last update' => 'Posledn aktualizace',
        'Tomorrow' => '',
        'to get the first 20 character of the subject' => 'pro zskni prvnch 20 znak z pedmtu',
        'Select the customeruser:service relations.' => '',
        'DB Admin Password' => 'Heslo administrtora databze',
        'Advisory' => '',
        'Drop Database' => 'Odstranit databazi',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',
        'FileManager' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => '',
        'Pending type' => 'Typ ekn na vyzen',
        'Comment (internal)' => 'Koment (intern)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        '(Used ticket number format)' => '(Pouit formt sel tiket)',
        'Reminder' => 'Upomnka',
        'Fulltext' => '',
        'OTRS DB connect host' => 'Hostitel OTRS databze (server)',
        'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Nebude-li tiket odpovzen v danm ase, bude zobrazen pouze tento Tiket.',
        'All Agent variables.' => '',
        ' (work units)' => '(jednotky prce)',
        'Next Week' => '',
        'All Customer variables like defined in config option CustomerUser.' => '',
        'accept license' => 'souhlasm s licenc',
        'for agent lastname' => 'pro pjmen agenta',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => '',
        'Reminder messages' => 'Upomnkov zprvy',
        'Parent-Object' => '',
        'Of couse this feature will take some system performance it self!' => '',
        'Ticket Hook' => 'Oznaen tiketu',
        'Your own Ticket' => 'V vlastn tiket',
        'Detail' => '',
        'TicketZoom' => 'Zobrazen tiketu',
        'Open Tickets' => '',
        'Don\'t forget to add a new user to groups!' => 'Nezapomete pidat novho uivatele do skupin!',
        'CreateTicket' => 'Vytvoeno Tiketu',
        'You have to select two or more attributes from the select field!' => '',
        'System Settings' => 'Nastaven systmu',
        'WebWatcher' => '',
        'Finished' => 'Dokoneno',
        'Account Type' => '',
        'D' => 'A-Z',
        'System Status' => '',
        'All messages' => 'Vechny zprvy',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Object already linked as %s.' => '',
        'A article should have a title!' => '',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
        'don\'t accept license' => 'nesouhlasm s licenc',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'A web mail client' => '',
        'Compose Follow up' => 'Sestavit nsledujc',
        'WebMail' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => '',
        'DB Type' => 'Typ databze',
        'kill all sessions' => 'Zruit vechny relace',
        'to get the from line of the email' => 'pro zskan dku Od z emailu',
        'Solution' => 'een',
        'QueueView' => 'Nhled fronty',
        'Select Box' => 'Poadavek na SQL databzi',
        'New messages' => 'Nov zprvy',
        'Can not create link with %s!' => '',
        'Linked as' => '',
        'Welcome to OTRS' => '',
        'modified' => '',
        'Delete old database' => 'Smazat starou databzi',
        'A web file manager' => '',
        'Have a lot of fun!' => 'Pejeme hodn spch s OTRS!',
        'send' => 'poslat',
        'Send no notifications' => '',
        'Note Text' => 'Text poznmky',
        'POP3 Account Management' => 'Sprva POP3 t',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
        'System State Management' => 'Sprva stavu systmu',
        'OTRS DB User' => 'Uivatel OTRS databze',
        'Mailbox' => 'Potovn schrnka',
        'PhoneView' => 'Nov tiket / hovor',
        'maximal period form' => '',
        'TicketID' => 'ID tiketu',
        'Yes means, send no agent and customer notifications on changes.' => '',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'V email s slem ticketu "<OTRS_TICKET>" je odesln zpt na "<OTRS_BOUNCE_TO>". Kontaktujte tuto adresu pro dal infromace.',
        'Ticket Status View' => '',
        'Modified' => 'Zmnno',
        'Ticket selected for bulk action!' => '',
    };
    # $$STOP$$
    return;
}

1;
