# --
# Kernel/Language/es.pm - provides es language translation
# Copyright (C) 2003-2006 Jorge Becerra <jorge at hab.desoft.cu>
# Copyright (C) 2007 Carlos Oyarzabal <carlos.oyarzabal at grupocash.com.mx>
# Copyright (C) 2008 Pelayo Romero Martn <pelayo.romero at gmail.com>
# --
# $Id: es.pm,v 1.89 2009/06/08 05:44:12 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::es;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.89 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Mon Jun  8 07:33:40 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D/%M/%Y - %T';
    $Self->{DateFormatLong}      = '%A, %D %B %Y - %T';
    $Self->{DateFormatShort}     = '%D/%M/%Y';
    $Self->{DateInputFormat}     = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'S',
        'No' => 'No',
        'yes' => 's',
        'no' => 'no',
        'Off' => 'Off',
        'off' => 'off',
        'On' => 'On',
        'on' => 'on',
        'top' => 'inicio',
        'end' => 'fin',
        'Done' => 'Hecho',
        'Cancel' => 'Cancelar',
        'Reset' => 'Resetear',
        'last' => 'ltimo',
        'before' => 'antes',
        'day' => 'da',
        'days' => 'das',
        'day(s)' => 'das(s)',
        'hour' => 'hora',
        'hours' => 'horas',
        'hour(s)' => 'hora(s)',
        'minute' => 'minuto',
        'minutes' => 'minutos',
        'minute(s)' => 'minuto(s)',
        'month' => 'mes',
        'months' => 'meses',
        'month(s)' => 'mes(es)',
        'week' => 'semana',
        'week(s)' => 'semana(s)',
        'year' => 'ao',
        'years' => 'aos',
        'year(s)' => 'ao(s)',
        'second(s)' => 'segundo(s)',
        'seconds' => 'segundos',
        'second' => 'segundo',
        'wrote' => 'escribi',
        'Message' => 'Mensaje',
        'Error' => '',
        'Bug Report' => 'Informe de errores',
        'Attention' => 'Atencin',
        'Warning' => 'Atencin',
        'Module' => 'Mdulo',
        'Modulefile' => 'Archivo de mdulo',
        'Subfunction' => 'Subfunciones',
        'Line' => 'Lnea',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'Ejemplo',
        'Examples' => 'Ejemplos',
        'valid' => 'vlido',
        'invalid' => 'invlido',
        '* invalid' => '* invlido',
        'invalid-temporarily' => 'invlido-temporalmente',
        ' 2 minutes' => ' 2 minutos',
        ' 5 minutes' => ' 5 minutos',
        ' 7 minutes' => ' 7 minutos',
        '10 minutes' => '10 minutos',
        '15 minutes' => '15 minutos',
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Next' => 'Siguiente',
        'Back' => 'Atrs',
        'Next...' => 'Siguiente...',
        '...Back' => '...Regresar',
        '-none-' => '-ninguno-',
        'none' => 'ninguno',
        'none!' => 'ninguno!',
        'none - answered' => 'ninguno  - respondido',
        'please do not edit!' => 'Por favor, no lo edite!',
        'AddLink' => 'Aadir enlace',
        'Link' => 'Vincular',
        'Unlink' => 'Desvincular',
        'Linked' => 'Vinculado',
        'Link (Normal)' => 'Enlazar (Normal)',
        'Link (Parent)' => 'Enlazar (Padre)',
        'Link (Child)' => 'Enlazar (Hijo)',
        'Normal' => 'Normal',
        'Parent' => 'Padre',
        'Child' => 'Hijo',
        'Hit' => 'Acierto',
        'Hits' => 'Aciertos',
        'Text' => 'Texto',
        'Lite' => 'Reducida',
        'User' => 'Usuario',
        'Username' => 'Nombre de Usuario',
        'Language' => 'Idioma',
        'Languages' => 'Idiomas',
        'Password' => 'Contrasea',
        'Salutation' => 'Saludo',
        'Signature' => 'Firmas',
        'Customer' => 'Cliente',
        'CustomerID' => 'N cliente',
        'CustomerIDs' => 'Nmeros de cliente',
        'customer' => 'cliente',
        'agent' => 'agente',
        'system' => 'Sistema',
        'Customer Info' => 'Informacin del Cliente',
        'Customer Company' => 'Compaa del Cliente',
        'Company' => 'Compaa',
        'go!' => 'ir!',
        'go' => 'ir',
        'All' => 'Todo',
        'all' => 'todo',
        'Sorry' => 'Disculpe',
        'update!' => 'Actualizar!',
        'update' => 'actualizar',
        'Update' => 'Actualizar',
        'Updated!' => '',
        'submit!' => 'enviar!',
        'submit' => 'enviar',
        'Submit' => 'Enviar',
        'change!' => 'modificar!',
        'Change' => 'Modificar',
        'change' => 'modificar',
        'click here' => 'haga click aqu',
        'Comment' => 'Comentario',
        'Valid' => 'Vlido',
        'Invalid Option!' => 'Opcin no vlida',
        'Invalid time!' => 'Hora no vlida!',
        'Invalid date!' => 'Fecha no vlida!',
        'Name' => 'Nombre',
        'Group' => 'Grupo',
        'Description' => 'Descripcin',
        'description' => 'descripcin',
        'Theme' => 'Tema',
        'Created' => 'Creado',
        'Created by' => 'Creado por',
        'Changed' => 'Modificado',
        'Changed by' => 'Modificado por',
        'Search' => 'Buscar',
        'and' => 'y',
        'between' => 'entre',
        'Fulltext Search' => 'Bsqueda de texto completo',
        'Data' => 'Datos',
        'Options' => 'Opciones',
        'Title' => 'Ttulo',
        'Item' => 'Artculo',
        'Delete' => 'Borrar',
        'Edit' => 'Editar',
        'View' => 'Ver',
        'Number' => 'Nmero',
        'System' => 'Sistema',
        'Contact' => 'Contacto',
        'Contacts' => 'Contactos',
        'Export' => 'Exportar',
        'Up' => 'Arriba',
        'Down' => 'Abajo',
        'Add' => 'Aadir',
        'Added!' => '',
        'Category' => 'Categora',
        'Viewer' => 'Visor',
        'Expand' => '',
        'New message' => 'Nuevo mensaje',
        'New message!' => 'Nuevo mensaje!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor, responda a este ticket para regresar a la vista normal de la cola.',
        'You got new message!' => 'Ud. tiene un nuevo mensaje',
        'You have %s new message(s)!' => 'Ud. tiene %s nuevo(s) mensaje(s)!',
        'You have %s reminder ticket(s)!' => 'Ud. tiene %s tickets recordatorios',
        'The recommended charset for your language is %s!' => 'EL juego de caracteres recomendado para su idioma es %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Las contraseas no coinciden. Por favor, reintente!',
        'Password is already in use! Please use an other password!' => 'La contrasea ya se est utilizando! Por favor, utilice otra!',
        'Password is already used! Please use an other password!' => 'La contrasea ya fue usada! Por favor, utilice otra!',
        'You need to activate %s first to use it!' => 'Necesita activar %s primero para usarlo!',
        'No suggestions' => 'Sin sugerencias',
        'Word' => 'Palabra',
        'Ignore' => 'Ignorar',
        'replace with' => 'reemplazar con',
        'There is no account with that login name.' => 'No existe ninguna cuenta con ese login',
        'Login failed! Your username or password was entered incorrectly.' => 'Identificacin incorrecta. Su nombre de usuario o contrasea fueron introducidos incorrectamente',
        'Please contact your admin' => 'Por favor, contace con su administrador',
        'Logout successful. Thank you for using OTRS!' => 'Desconexin satisfactoria. Gracias por utilizar OTRS!',
        'Invalid SessionID!' => 'Sesin no vlida',
        'Feature not active!' => 'Caracterstica no activa',
        'Login is needed!' => 'Se requiere login',
        'Password is needed!' => 'Se requiere la contrasea!',
        'License' => 'Licencia',
        'Take this Customer' => 'Utilizar este cliente',
        'Take this User' => 'Utilizar este usuario',
        'possible' => 'posible',
        'reject' => 'rechazar',
        'reverse' => 'revertir',
        'Facility' => 'Instalacin',
        'Timeover' => 'Vencimiento',
        'Pending till' => 'Pendiente hasta',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabaje con el Identificador 1 (cuenta de sistema)! Cree nuevos usuarios! ',
        'Dispatching by email To: field.' => 'Despachar por correo del campo Para:',
        'Dispatching by selected Queue.' => 'Despachar por la cola seleccionada',
        'No entry found!' => 'No se encontr ninguna entrada!',
        'Session has timed out. Please log in again.' => 'La sesin ha caducado. Por favor, conctese nuevamente.',
        'No Permission!' => 'No tiene Permiso!',
        'To: (%s) replaced with database email!' => 'Para: (%s) sustituido con email de la base de datos!',
        'Cc: (%s) added database email!' => 'Cc: (%s) aadido a la base de datos de correo!',
        '(Click here to add)' => '(Haga click aqu para aadir)',
        'Preview' => 'Vista Previa',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Paquete no instalado correctamente! Ud. debe reinstalar el paquete nuevamente!',
        'Added User "%s"' => 'Aadido usuario "%s"',
        'Contract' => 'Contrato',
        'Online Customer: %s' => 'Cliente Conectado: %s',
        'Online Agent: %s' => 'Agente Conectado: %s',
        'Calendar' => 'Calendario',
        'File' => 'Archivo',
        'Filename' => 'Nombre del archivo',
        'Type' => 'Tipos',
        'Size' => 'Tamao',
        'Upload' => 'Subir',
        'Directory' => 'Directorio',
        'Signed' => 'Firmado',
        'Sign' => 'Firma',
        'Crypted' => 'Encriptado',
        'Crypt' => 'Encriptar',
        'Office' => 'Oficina',
        'Phone' => 'Telfono',
        'Fax' => '',
        'Mobile' => 'Mvil',
        'Zip' => '',
        'City' => 'Ciudad',
        'Street' => 'Calle',
        'Country' => 'Pas',
        'Location' => 'Localidad',
        'installed' => 'instalado',
        'uninstalled' => 'desinstalado',
        'Security Note: You should activate %s because application is already running!' => 'Nota de seguridad: Ud. debe activar %s porque la aplicacin ya est ejecutndose!',
        'Unable to parse Online Repository index document!' => 'Incapaz de interpretar el documento ndice del Repositorio en Lnea!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'No hay paquetes para el Framework solicitado en este Repositorio en Lnea, pero s hay para otros Frameworks',
        'No Packages or no new Packages in selected Online Repository!' => 'No hay paquetes o no hay paquetes nuevos en el Repositorio en Lnea seleccionado',
        'printed at' => 'impreso en',
        'Dear Mr. %s,' => 'Estimado Sr. %s.',
        'Dear Mrs. %s,' => 'Estimada Sra. %s.',
        'Dear %s,' => 'Estimado %s.',
        'Hello %s,' => 'Hola %s.',
        'This account exists.' => 'Esta cuenta existe.',
        'New account created. Sent Login-Account to %s.' => 'Nueva cuenta creada. Enve el Login de la cuenta a %s.',
        'Please press Back and try again.' => 'Por favor, presione Atrs e intntelo de nuevo.',
        'Sent password token to: %s' => 'Enviado recordatorio de clave a: %s',
        'Sent new password to: %s' => 'Enviada nueva clave a: %s',
        'Invalid Token!' => 'Recordatorio no vlido!',
        'For more info see:' => '',
        'Package verification failed!' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Header' => 'Encabezado',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'Ene',
        'Feb' => 'Feb',
        'Mar' => 'Mar',
        'Apr' => 'Abr',
        'May' => 'May',
        'Jun' => 'Jun',
        'Jul' => 'Jul',
        'Aug' => 'Ago',
        'Sep' => 'Sep',
        'Oct' => 'Oct',
        'Nov' => 'Nov',
        'Dec' => 'Dic',
        'January' => 'Enero',
        'February' => 'Febrero',
        'March' => 'Marzo',
        'April' => 'Abril',
        'June' => 'Junio',
        'July' => 'Julio',
        'August' => 'Agosto',
        'September' => 'Septiembre',
        'October' => 'Octubre',
        'November' => 'Noviembre',
        'December' => 'Diciembre',

        # Template: AAANavBar
        'Admin-Area' => 'Area de administracin',
        'Agent-Area' => 'Area de Agente',
        'Ticket-Area' => 'Area de Ticket',
        'Logout' => 'Desconectar',
        'Agent Preferences' => 'Preferencias de Agente',
        'Preferences' => 'Preferencias',
        'Agent Mailbox' => 'Buzn de Agente',
        'Stats' => 'Estadsticas',
        'Stats-Area' => 'Area de Estadsticas',
        'Admin' => 'Administrar',
        'Customer Users' => 'Clientes',
        'Customer Users <-> Groups' => 'Clientes <-> Grupos',
        'Users <-> Groups' => 'Usuarios <-> Grupos',
        'Roles' => '',
        'Roles <-> Users' => 'Roles <-> Usuarios',
        'Roles <-> Groups' => 'Roles <-> Grupos',
        'Salutations' => 'Saludos',
        'Signatures' => 'Firmas',
        'Email Addresses' => 'Direcciones de Correo',
        'Notifications' => 'Notificaciones',
        'Category Tree' => 'Arbol de categoras',
        'Admin Notification' => 'Notificacin del Administrador',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Las preferencias se actualizaron satisfactoriamente!',
        'Mail Management' => 'Gestin de Correo',
        'Frontend' => 'Interfaz de usuario',
        'Other Options' => 'Otras Opciones',
        'Change Password' => 'Cambiar contrasea',
        'New password' => 'Nueva contrasea',
        'New password again' => 'Repetir Contrasea',
        'Select your QueueView refresh time.' => 'Seleccione su tiempo de actualizacin de la vista de colas',
        'Select your frontend language.' => 'Seleccione su idioma de trabajo',
        'Select your frontend Charset.' => 'Seleccione su juego de caracteres',
        'Select your frontend Theme.' => 'Seleccione su tema',
        'Select your frontend QueueView.' => 'Seleccione su Vista de cola de trabajo',
        'Spelling Dictionary' => 'Diccionario Ortogrfico',
        'Select your default spelling dictionary.' => 'Seleccione su diccionario por defecto',
        'Max. shown Tickets a page in Overview.' => 'Cantidad de Tickets a mostrar en Resumen',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => 'No se puede actualizar la contrasea, no coinciden! Por favor, reintntelo!',
        'Can\'t update password, invalid characters!' => 'No se puede actualizar la contrasea, caracteres no vlidos!',
        'Can\'t update password, need min. 8 characters!' => 'No se puede actualizar la contrasea, se necesitan al menos 8 caracteres',
        'Can\'t update password, need 2 lower and 2 upper characters!' => 'No se puede actualizar la contrasea, se necesitan al menos 2 en minscula y 2 en mayscula!',
        'Can\'t update password, need min. 1 digit!' => 'No se puede actualizar la contrasea, se necesita al menos 1 dgito!',
        'Can\'t update password, need min. 2 characters!' => 'No se puede actualizar la contrasea, se necesitan al menos 2 caracteres!',

        # Template: AAAStats
        'Stat' => 'Estadsticas',
        'Please fill out the required fields!' => 'Por favor, rellene los campos requeridos',
        'Please select a file!' => 'Por favor, seleccione un archivo',
        'Please select an object!' => 'Por favor, seleccione un objeto',
        'Please select a graph size!' => 'Por favor, seleccione un tamao de grfico',
        'Please select one element for the X-axis!' => 'Por favor, seleccione un elemento para el eje X',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Por favor, selecciones un solo elemento o desactive el botn \'Fijado\' donde el campo seleccionado est marcado!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Si usa una casilla de seleccin, debe seleccionar algunos atributos del campo seleccionado',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Por favor, inserte un valor en el campo de entrada o desactive la seleccion \'Fijado\'',
        'The selected end time is before the start time!' => 'La fecha de finalizacin es anterior a la de inicio!',
        'You have to select one or more attributes from the select field!' => 'Debe seleccionar uno o ms atributos del campo seleccionado!',
        'The selected Date isn\'t valid!' => 'La fecha seleccionada no es vlida',
        'Please select only one or two elements via the checkbox!' => 'Por favor, seleccione slo uno o dos elementos usando la casilla de seleccin!',
        'If you use a time scale element you can only select one element!' => 'Si utiliza una escala de tiempo, slo puede seleccionar un elemento!',
        'You have an error in your time selection!' => 'Tiene un error en la seleccin de tiempo!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'El intervalo de tiempo para informes es pequeo, por favor use uno mayor!',
        'The selected start time is before the allowed start time!' => 'El momento de inicio es anterior al permitido!',
        'The selected end time is after the allowed end time!' => 'El momento de finalizacin es posterior al permitido!',
        'The selected time period is larger than the allowed time period!' => 'El periodo de tiempo es mayor que el permitido!',
        'Common Specification' => 'Especificacin comn',
        'Xaxis' => 'EjeX',
        'Value Series' => 'Serie de Valores',
        'Restrictions' => 'Restricciones',
        'graph-lines' => 'grfico-de-lineas',
        'graph-bars' => 'grfico-de-barras ',
        'graph-hbars' => 'grfico-de-barras-horiz',
        'graph-points' => 'grfico-de-puntos',
        'graph-lines-points' => 'grfico-punteado',
        'graph-area' => 'grfico-de-rea',
        'graph-pie' => 'grfico-de-pastel',
        'extended' => 'extendido',
        'Agent/Owner' => 'Agente/Propietario',
        'Created by Agent/Owner' => 'Creado por Agente/Propietario',
        'Created Priority' => 'Prioridad de Creacin',
        'Created State' => 'Estado de Creacin',
        'Create Time' => 'Fecha de Creacin',
        'CustomerUserLogin' => 'Login de Usuario Cliente',
        'Close Time' => 'Fecha de Cierre',
        'TicketAccumulation' => '',
        'Attributes to be printed' => '',
        'Sort sequence' => '',
        'Order by' => '',
        'Limit' => 'Lmite',
        'Ticketlist' => '',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '',
        'Total Time' => '',
        'Ticket Average' => '',
        'Ticket Min Time' => '',
        'Ticket Max Time' => '',
        'Number of Tickets' => '',
        'Article Average' => '',
        'Article Min Time' => '',
        'Article Max Time' => '',
        'Number of Articles' => '',
        'Accounted time by Agent' => '',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => '',
        'Ticket Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Bloquear',
        'Unlock' => 'Desbloquear',
        'History' => 'Historia',
        'Zoom' => 'Detalle',
        'Age' => 'Antigedad',
        'Bounce' => 'Rebotar',
        'Forward' => 'Reenviar',
        'From' => 'De',
        'To' => 'Para',
        'Cc' => 'Copia ',
        'Bcc' => 'Copia Invisible',
        'Subject' => 'Asunto',
        'Move' => 'Mover',
        'Queue' => 'Cola',
        'Priority' => 'Prioridad',
        'Priority Update' => 'Modificar prioridad',
        'State' => 'Estado',
        'Compose' => 'Redactar',
        'Pending' => 'Pendiente',
        'Owner' => 'Propietario',
        'Owner Update' => 'Modificar Propietario',
        'Responsible' => 'Responsable',
        'Responsible Update' => 'Modificar Responsable',
        'Sender' => 'Emisor',
        'Article' => 'Artculo',
        'Ticket' => '',
        'Createtime' => 'Fecha de creacin ',
        'plain' => 'texto plano',
        'Email' => 'Correo',
        'email' => 'correo',
        'Close' => 'Cerrar',
        'Action' => 'Accin',
        'Attachment' => 'Anexo',
        'Attachments' => 'Anexos',
        'This message was written in a character set other than your own.' => 'Este mensaje fue escrito usando un juego de caracteres distinto al suyo',
        'If it is not displayed correctly,' => 'Si no se muestra correctamente',
        'This is a' => 'Este es un',
        'to open it in a new window.' => 'para abrir en una nueva ventana',
        'This is a HTML email. Click here to show it.' => 'Este es un mensaje HTML. Haga click aqu para mostrarlo.',
        'Free Fields' => 'Campos Libres',
        'Merge' => 'Fusionar',
        'merged' => 'fusionado',
        'closed successful' => 'cerrado exitosamente',
        'closed unsuccessful' => 'cerrado sin xito',
        'new' => 'nuevo',
        'open' => 'abierto',
        'Open' => '',
        'closed' => 'cerrado',
        'Closed' => '',
        'removed' => 'eliminado',
        'pending reminder' => 'recordatorio pendiente',
        'pending auto' => 'pendiente auto',
        'pending auto close+' => 'pendiente auto close+',
        'pending auto close-' => 'pendiente auto close-',
        'email-external' => 'correo-externo',
        'email-internal' => 'correo-interno',
        'note-external' => 'nota-externa',
        'note-internal' => 'nota-interna',
        'note-report' => 'nota-informe',
        'phone' => 'telfono',
        'sms' => '',
        'webrequest' => 'solicitud va web',
        'lock' => 'bloquear',
        'unlock' => 'desbloquear',
        'very low' => 'muy bajo',
        'low' => 'bajo',
        'normal' => '',
        'high' => 'alto',
        'very high' => 'muy alto',
        '1 very low' => '1 - muy bajo',
        '2 low' => '2 - bajo',
        '3 normal' => '3 - normal',
        '4 high' => '4 - alto',
        '5 very high' => '5 - muy alto',
        'Ticket "%s" created!' => 'Ticket "%s" creado!',
        'Ticket Number' => 'Ticket Nmero',
        'Ticket Object' => 'Objeto Ticket',
        'No such Ticket Number "%s"! Can\'t link it!' => 'No existe el Ticket Nmero "%s"! No se puede vincular!',
        'Don\'t show closed Tickets' => 'No mostrar los tickets cerrados',
        'Show closed Tickets' => 'Mostrar Tickets cerrados',
        'New Article' => 'Nuevo Artculo',
        'Email-Ticket' => 'Ticket de Email',
        'Create new Email Ticket' => 'Crea nuevo Ticket de Email',
        'Phone-Ticket' => 'Ticket Telefnico',
        'Search Tickets' => 'Buscar Tickets',
        'Edit Customer Users' => 'Editar Clientes',
        'Edit Customer Company' => 'Editar Compaa de Clientes',
        'Bulk Action' => 'Accin Mltiple',
        'Bulk Actions on Tickets' => 'Accin Mltiple sobre Tickets',
        'Send Email and create a new Ticket' => 'Enviar un correo y crear un nuevo ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'Crea nuevo Ticket de Email y descartar este (saliente)',
        'Create new Phone Ticket (Inbound)' => 'Crea nuevo Ticket Telefnico (entrante)',
        'Overview of all open Tickets' => 'Resumen de todos los tickets abiertos',
        'Locked Tickets' => 'Tickets Bloqueados',
        'Watched Tickets' => 'Ticket Monitoreados',
        'Watched' => 'Monitoreado',
        'Subscribe' => 'Subscribir',
        'Unsubscribe' => 'Desubscribir',
        'Lock it to work on it!' => 'Bloquearlo para trabajar en l!',
        'Unlock to give it back to the queue!' => 'Desbloquearlo para devolverlo a la cola!',
        'Shows the ticket history!' => 'Mostrar la historia del ticket!',
        'Print this ticket!' => 'Imprimir este ticket!',
        'Change the ticket priority!' => 'Cambiar la prioridad del ticket!',
        'Change the ticket free fields!' => 'Cambiar los campos libres del ticket!',
        'Link this ticket to an other objects!' => 'Enlazar este ticket a otros objetos',
        'Change the ticket owner!' => 'Cambiar el propietario del ticket!',
        'Change the ticket customer!' => 'Cambiar el cliente del ticket!',
        'Add a note to this ticket!' => 'Aadir una nota a este ticket!',
        'Merge this ticket!' => 'Fusionar este ticket!',
        'Set this ticket to pending!' => 'Poner este ticket como pendiente!',
        'Close this ticket!' => 'Cerrar este ticket!',
        'Look into a ticket!' => 'Revisar un ticket',
        'Delete this ticket!' => 'Eliminar este ticket!',
        'Mark as Spam!' => 'Marcar como correo no deseado!',
        'My Queues' => 'Mis Colas',
        'Shown Tickets' => 'Tickets Mostrados',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Su correo con nmero de ticket "<OTRS_TICKET>" se uni a "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: Tiempo para primera respuesta ha vencido (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: Tiempo para primera respuesta vencer en %s!',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: Tiempo para actualizacin ha vencido (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: Tiempo para actualizacin vencer en %s!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: Tiempo para solucin ha vencido (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Ticket %s: Tiempo para solucin vencer en %s!',
        'There are more escalated tickets!' => 'No hay ms tickets escalados',
        'New ticket notification' => 'Notificacin de nuevos tickets',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Notifqueme si hay un nuevo ticket en "Mis Colas".',
        'Follow up notification' => 'Notificacin de seguimiento',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Notifqueme si un cliente solicita un seguimiento y yo soy el dueo del ticket.',
        'Ticket lock timeout notification' => 'Notificacin de bloqueo de tickets por tiempo',
        'Send me a notification if a ticket is unlocked by the system.' => 'Notifqueme si un ticket es desbloqueado por el sistema',
        'Move notification' => 'Notificacin de movimientos',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Notifqueme si un ticket es colocado en una de "Mis Colas".',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Cola de seleccin de colas favoritas. Ud. tambin puede ser notificado de estas colas va correo si est habilitado',
        'Custom Queue' => 'Cola personal',
        'QueueView refresh time' => 'Tiempo de actualizacin de la vista de colas',
        'Screen after new ticket' => 'Pantalla posterior a nuevo ticket',
        'Select your screen after creating a new ticket.' => 'Seleccione la pantalla a mostrar despus de crear un ticket',
        'Closed Tickets' => 'Tickets Cerrados',
        'Show closed tickets.' => 'Mostrar Tickets cerrados',
        'Max. shown Tickets a page in QueueView.' => 'Cantidad de Tickets a mostrar en la Vista de Cola',
        'Watch notification' => '',
        'Send me a notification of an watched ticket like an owner of an ticket.' => '',
        'Out Of Office' => '',
        'Select your out of office time.' => '',
        'CompanyTickets' => 'TicketsCompaa',
        'MyTickets' => 'MisTickets',
        'New Ticket' => 'Nuevo Ticket',
        'Create new Ticket' => 'Crear un nuevo Ticket',
        'Customer called' => 'Llamada de Cliente',
        'phone call' => 'llamada telefnica',
        'Reminder Reached' => '',
        'Reminder Tickets' => '',
        'Escaladed Tickets' => '',
        'New Tickets' => '',
        'Open Tickets / Need to be answered' => '',
        'Responses' => 'Respuestas',
        'Responses <-> Queue' => 'Respuestas <-> Colas',
        'Auto Responses' => 'Respuestas Automticas',
        'Auto Responses <-> Queue' => 'Respuestas Automticas <-> Colas',
        'Attachments <-> Responses' => 'Anexos <-> Respuestas',
        'History::Move' => 'Ticket movido a la cola "%s" (%s) de la cola "%s" (%s).',
        'History::TypeUpdate' => 'Tipo actualizado a %s (ID=%s).',
        'History::ServiceUpdate' => 'Servicio actualizado a %s (ID=%s).',
        'History::SLAUpdate' => 'SLA actualizado a %s (ID=%s).',
        'History::NewTicket' => 'Nuevo Ticket [%s] creado (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Seguimiento para [%s]. %s',
        'History::SendAutoReject' => 'Rechazo automtico enviado a "%s".',
        'History::SendAutoReply' => 'Respuesta automtica enviada a "%s".',
        'History::SendAutoFollowUp' => 'Seguimiento automtico enviado a "%s".',
        'History::Forward' => 'Reenviado a "%s".',
        'History::Bounce' => 'Reenviado a "%s".',
        'History::SendAnswer' => 'Correo enviado a "%s".',
        'History::SendAgentNotification' => '"%s"-notificacin enviada a "%s".',
        'History::SendCustomerNotification' => 'Notificacin; enviada a "%s".',
        'History::EmailAgent' => 'Correo enviado al cliente.',
        'History::EmailCustomer' => 'Correo aadido. %s',
        'History::PhoneCallAgent' => 'El agente llam al cliente.',
        'History::PhoneCallCustomer' => 'El cliente llam.',
        'History::AddNote' => 'Nota aadida (%s)',
        'History::Lock' => 'Ticket bloqueado.',
        'History::Unlock' => 'Ticket desbloqueado.',
        'History::TimeAccounting' => '%s unidad(es) de tiempo contabilizadas. Nuevo total : %s unidad(es) de tiempo.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Actualizado: %s',
        'History::PriorityUpdate' => 'Cambiar prioridad de "%s" (%s) a "%s" (%s).',
        'History::OwnerUpdate' => 'El nuevo propietario es "%s" (ID=%s).',
        'History::LoopProtection' => 'Proteccin de bucle! NO se envi auto-respuesta a "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Actualizado: %s',
        'History::StateUpdate' => 'Antiguo: "%s". Nuevo: "%s"',
        'History::TicketFreeTextUpdate' => 'Actualizado: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Solicitud de cliente va web.',
        'History::TicketLinkAdd' => 'Aadido enlace al ticket "%s".',
        'History::TicketLinkDelete' => 'Eliminado enlace al ticket "%s".',
        'History::Subscribe' => 'Aadida subscripcin para el usuario "%s".',
        'History::Unsubscribe' => 'Eliminada subscripcin para el usuario "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Dom',
        'Mon' => 'Lun',
        'Tue' => 'Mar',
        'Wed' => 'Mie',
        'Thu' => 'Jue',
        'Fri' => 'Vie',
        'Sat' => 'Sab',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Gestin de Anexos',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Gestin de respuestas automticas',
        'Response' => 'Respuesta',
        'Auto Response From' => 'Respuesta automtica De ',
        'Note' => 'Nota',
        'Useable options' => 'Opciones accesibles',
        'To get the first 20 character of the subject.' => 'Para obtener los primeros 20 caracteres del asunto',
        'To get the first 5 lines of the email.' => 'Para obtener las primeras 5 lneas del correo',
        'To get the realname of the sender (if given).' => 'Para obtener el nombre real del remitente (si existe)',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Para obtener el atributo del artculo (p.e. <OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> y <OTRS_CUSTOMER_Body>).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Opciones de datos del actual usuario del cliente (ej. <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Opciones del propietario del ticket (ej. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Opciones del responsable del ticket (ej. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Opciones del actual usuario que requiri esta accin (ej. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Opciones de los datos del ticket (ej. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Opciones de configuracin (ej. <OTRS_CONFIG_HttpType>).',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Administracin de Compaa de Cliente',
        'Search for' => 'Buscar por',
        'Add Customer Company' => 'Aadir Compaa de Cliente',
        'Add a new Customer Company.' => 'Aadir una nueva Compaa de Cliente',
        'List' => 'Listar',
        'This values are required.' => 'Estos valores son obligatorios',
        'This values are read only.' => 'Estos valores son de slo-lectura',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'El mensaje que se estaba redactando ha sido cerrado. Saliendo.!',
        'This window must be called from compose window' => 'Esta ventana debe ser llamada desde la ventana de redaccin',
        'Customer User Management' => 'Gestin de clientes',
        'Add Customer User' => 'Aadir Cliente Usuario',
        'Source' => 'Origen',
        'Create' => 'Crear',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'El cliente necesita tener una historia y conectarse va panel de clientes',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Gestin de Clientes <-> Grupos',
        'Change %s settings' => 'Cambiar %s especificaciones',
        'Select the user:group permissions.' => 'Seleccionar los permisos de usuario:grupo',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Si no se selecciona algo, no habr permisos en este grupo (Los tickets no estarn disponibles para este cliente).',
        'Permission' => 'Permisos',
        'ro' => '',
        'Read only access to the ticket in this group/queue.' => 'Acceso de slo lectura a los tickets en este grupo/cola.',
        'rw' => '',
        'Full read and write access to the tickets in this group/queue.' => 'Acceso completo de lectura y escritura a los tickets en este grupo/cola.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'Gestin de Clientes <-> Servicios',
        'CustomerUser' => 'Usuario Cliente',
        'Service' => 'Servicios',
        'Edit default services.' => 'Editar servicios por defecto',
        'Search Result' => 'Buscar resultados',
        'Allocate services to CustomerUser' => 'Relacionar Servicios con Clientes',
        'Active' => 'Activo',
        'Allocate CustomerUser to service' => 'Relacionar Clientes con Servicios',

        # Template: AdminEmail
        'Message sent to' => 'Mensaje enviado a',
        'Recipents' => 'Destinatarios',
        'Body' => 'Cuerpo',
        'Send' => 'Enviar',

        # Template: AdminGenericAgent
        'GenericAgent' => 'AgenteGenrico',
        'Job-List' => 'Lista de Tareas',
        'Last run' => 'ltima ejecucin',
        'Run Now!' => 'Ejecutar ahora',
        'x' => '',
        'Save Job as?' => 'Guardar Tarea como?',
        'Is Job Valid?' => 'Es la tarea vlida?',
        'Is Job Valid' => 'Es una tarea vlida',
        'Schedule' => 'Horario',
        'Currently this generic agent job will not run automatically.' => '',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Bsqueda de texto en Artculo (ej. "Mar*in" o "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '(ej: 10*5155 o 105658*)',
        '(e. g. 234321)' => '(ej: 234321)',
        'Customer User Login' => 'Identificador del cliente',
        '(e. g. U5150)' => '(ej: U5150)',
        'SLA' => '',
        'Agent' => 'Agente',
        'Ticket Lock' => 'Ticket Bloqueado',
        'TicketFreeFields' => 'CamposLibresDeTicket',
        'Create Times' => 'Tiempos de Creacin',
        'No create time settings.' => 'No hay valores para tiempo de creacin',
        'Ticket created' => 'Ticket creado',
        'Ticket created between' => 'Ticket creado entre',
        'Close Times' => 'Tiempos de Cierre',
        'No close time settings.' => 'No hay Tiempos de Cierre configurados',
        'Ticket closed' => 'Ticket cerrado',
        'Ticket closed between' => 'Ticket cerrado entre',
        'Pending Times' => 'Tiempos de Pendiente',
        'No pending time settings.' => 'No hay valores para tiempo de Pendiente',
        'Ticket pending time reached' => 'Tiempo de Pendiente del Ticket alcanzado',
        'Ticket pending time reached between' => 'Tiempo de Pendiente del Ticket alcanzado entre',
        'Escalation Times' => '',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - First Response Time' => 'Escalado - Tiempo para Primera Respuesta',
        'No escalation time settings.' => '',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - Update Time' => 'Escalado - Tiempo para Actualizacin',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - Solution Time' => 'Escalado - Tiempo para Solucin',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'New Service' => 'Nuevo Servicio',
        'New SLA' => 'Nuevo SLA',
        'New Priority' => 'Nueva prioridad',
        'New Queue' => 'Nueva Cola',
        'New State' => 'Nuevo estado',
        'New Agent' => 'Nuevo Agente',
        'New Owner' => 'Nuevo Propietario',
        'New Customer' => 'Nuevo Cliente',
        'New Ticket Lock' => 'Nuevo bloqueo de ticket!',
        'New Type' => 'Nuevo Tipo',
        'New Title' => 'Nuevo Ttulo',
        'New TicketFreeFields' => 'Nuevo CampoLibredeTicket',
        'Add Note' => 'Aadir Nota',
        'Time units' => 'Unidades de tiempo',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Se ejecutar el comando. ARG[0] ser el nmero del ticket, ARG[0] el id del ticket.',
        'Delete tickets' => 'Eliminar tickets',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Aviso! Estos tickets sern eliminados de la base de datos! Por tanto, se perdern!',
        'Send Notification' => 'Enviar Notificacin',
        'Param 1' => 'Parmetro 1',
        'Param 2' => 'Parmetro 2',
        'Param 3' => 'Parmetro 3',
        'Param 4' => 'Parmetro 4',
        'Param 5' => 'Parmetro 5',
        'Param 6' => 'Parmetro 6',
        'Send agent/customer notifications on changes' => '',
        'Save' => 'Grabar',
        '%s Tickets affected! Do you really want to use this job?' => '%s Tickets afectados! Realmente desea utilizar esta tarea?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Administracin de grupos',
        'Add Group' => 'Aadir Grupo',
        'Add a new Group.' => 'Aadir nuevo Grupo',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'El grupo admin es para usar el rea de administracin y el grupo stats para usar el rea estadisticas.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crear nuevos grupos para manipular los permisos de acceso por distintos grupos de agente (ej: departamento de compra, departamento de soporte, departamento de ventas,...).',
        'It\'s useful for ASP solutions.' => 'Esto es til para soluciones ASP.',

        # Template: AdminLog
        'System Log' => 'Trazas del Sistema',
        'Time' => 'Tiempo',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Gestin de Cuentas de Correo',
        'Host' => '',
        'Trusted' => 'Validado',
        'Dispatching' => 'Remitiendo',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Todos los correos entrantes con una cuenta sern enviados a la cola seleccionada',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Si su cuenta est validada, las cabeceras X-OTRS ya existentes en la llegada se utilizarn para la prioridad! El filtro Postmaster se usa de todas formas.',

        # Template: AdminNavigationBar
        'Users' => 'Usuarios',
        'Groups' => 'Grupos',
        'Misc' => 'Miscelnea',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'Gestin de Notificaciones',
        'Add Notification' => '',
        'Add a new Notification.' => '',
        'Name is required!' => 'Debe especificar nombre!',
        'Event is required!' => '',
        'A message should have a subject!' => 'Los mensajes deben tener asunto!',
        'A message should have a body!' => 'Los mensajes deben tener contenido',
        'Recipient' => '',
        'Group based' => '',
        'Recipient' => '',
        'Agent based' => '',
        'Email based' => '',
        'Event' => 'Evento',
        'Article Type' => '',
        'Only for ArticleCreate Event.' => '',
        'Subject match' => '',
        'Only for ArticleCreate Event.' => '',
        'Body match' => '',
        'Notifications are sent to an agent or a customer.' => 'Las notificaciones se envan a un agente o cliente',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminNotificationForm
        'Notification' => 'Notificaciones',

        # Template: AdminPackageManager
        'Package Manager' => 'Gestor de paquetes',
        'Uninstall' => 'Desinstalar',
        'Version' => 'Versin',
        'Do you really want to uninstall this package?' => 'Est seguro de que desea desinstalar este paquete?',
        'Reinstall' => 'Reinstalar',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Realmente desea reinstalar este paquete (todos los cambios manuales se perdern)?',
        'Continue' => 'Continuar',
        'Install' => 'Instalar',
        'Package' => 'Paquete',
        'Online Repository' => 'Repositorio Online',
        'Vendor' => 'Vendedor',
        'Module documentation' => '',
        'Upgrade' => 'Actualizar',
        'Local Repository' => 'Repositorio Local',
        'Status' => 'Estados',
        'Overview' => 'Resumen',
        'Download' => 'Descargar',
        'Rebuild' => 'Reconstruir',
        'ChangeLog' => 'Log de Cambios',
        'Date' => 'Fecha',
        'Filelist' => 'Lista de Archivos',
        'Download file from package!' => 'Descargar archivo del paquete!',
        'Required' => 'Obligatorio',
        'PrimaryKey' => 'ClavePrimaria',
        'AutoIncrement' => 'AutoIncrementar',
        'SQL' => '',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Trazas de rendimiento',
        'This feature is enabled!' => 'Esta caracterstica est habilitada',
        'Just use this feature if you want to log each request.' => 'Use esta caracterstica slo si desea registrar cada peticin.',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => 'Deshabiltelo aqu',
        'This feature is disabled!' => 'Esta caracterstica est deshabilitada',
        'Enable it here!' => 'Habiltelo aqu',
        'Logfile too large!' => 'Archivo de trazas muy grande',
        'Logfile too large, you need to reset it!' => 'Archivo de trazas muy grande, necesita reinicializarlo!',
        'Range' => 'Rango',
        'Interface' => '',
        'Requests' => 'Solicitudes',
        'Min Response' => 'Respuesta Mnima',
        'Max Response' => 'Respuesta Mxima',
        'Average Response' => 'Respuesta Promedio',
        'Period' => 'Periodo',
        'Min' => 'Min',
        'Max' => 'Max',
        'Average' => 'Promedio',

        # Template: AdminPGPForm
        'PGP Management' => 'Administracin PGP',
        'Result' => 'Resultado',
        'Identifier' => 'Identificador',
        'Bit' => '',
        'Key' => 'Clave',
        'Fingerprint' => '',
        'Expires' => 'Expira',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'De esta forma puede editar directamente el anillo de Claves configurado en Sysconfig',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Gestin del filtro maestro',
        'Filtername' => 'Nombre del filtro',
        'Stop after match' => '',
        'Match' => 'Coincidir',
        'Value' => 'Valor',
        'Set' => 'Ajustar',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Clasificar o filtrar correos entrantes basado en encabezamientos X-Headers! Puede utilizar expresiones regulares.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Si desea chequear slo la direccin del email, use EMAILADDRESS:info@example.com en De, Para o Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Si utiliza expresiones regulares, puede tambin usar el valor encontrado en () as [***] en \'Set\'.',

        # Template: AdminPriority
        'Priority Management' => 'Gestin de Prioridades',
        'Add Priority' => 'Aadir Prioridad',
        'Add a new Priority.' => 'Aadir una nueva Prioridad.',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Gestin de Cola <-> respuestas automticas',
        'settings' => '',

        # Template: AdminQueueForm
        'Queue Management' => 'Gestin de Colas',
        'Sub-Queue of' => 'Subcola de',
        'Unlock timeout' => 'Tiempo para desbloqueo automtico',
        '0 = no unlock' => '0 = sin desbloqueo',
        'Only business hours are counted.' => 'Slo se contarn las horas de trabajo',
        '0 = no escalation' => '0 = sin escalado',
        'Notify by' => 'Notificado por',
        'Follow up Option' => 'Opcin de seguimiento',
        'Ticket lock after a follow up' => 'Bloquear un ticket despus del seguimiento',
        'Systemaddress' => 'Direcciones de correo del sistema',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un agente bloquea un ticket y no enva una respuesta en este tiempo, el ticket ser desbloqueado automticamente. El Ticket ser visible por todos los dems agentes.',
        'Escalation time' => 'Tiempo de escalado',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Si un ticket no ha sido respondido es este tiempo, slo este ticket se mostrar',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si el ticket est cerrado y el cliente enva un seguimiento al mismo, ste ser bloqueado para el antiguo propietario',
        'Will be the sender address of this queue for email answers.' => 'Ser la direccin del emisor en esta cola para respuestas por correo.',
        'The salutation for email answers.' => 'Saludo para respuestas por correo.',
        'The signature for email answers.' => 'Firma para respuestas por correo.',
        'Customer Move Notify' => 'Notificar al Cliente al Mover',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS enva una notificacin por correo al cliente si el ticket se mueve',
        'Customer State Notify' => 'Notificacin de estado al Cliente',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS enva una notificacin por correo al cliente si el estado del ticket cambia',
        'Customer Owner Notify' => 'Notificar al Propietario al Mover',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS enva una notificacin por correo al cliente si el propietario del ticket cambia',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Gestin de Respuestas <-> Colas',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Responder',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Gestin de Respuestas <-> Anexos',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Gestin de Respuestas',
        'A response is default text to write faster answer (with default text) to customers.' => 'Una respuesta es el texto por defecto para responder ms rpido (con el texto por defecto) a los clientes.',
        'Don\'t forget to add a new response a queue!' => 'No olvide incluir una nueva respuesta en la cola!',
        'The current ticket state is' => 'El estado actual del ticket es',
        'Your email address is new' => 'Su direccin de correo es nueva',

        # Template: AdminRoleForm
        'Role Management' => 'Gestin de Roles',
        'Add Role' => 'Aadir Rol',
        'Add a new Role.' => 'Aadir un nuevo Rol',
        'Create a role and put groups in it. Then add the role to the users.' => 'Cree un rol y coloque grupos en el mismo. Luego aada el rol a los usuarios.',
        'It\'s useful for a lot of users and groups.' => 'Es til para gestionar muchos usuarios y grupos.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Gestin de Roles <-> Grupos',
        'move_into' => 'mover_a',
        'Permissions to move tickets into this group/queue.' => 'Permiso para mover tickets a este grupo/cola',
        'create' => 'crear',
        'Permissions to create tickets in this group/queue.' => 'Permiso para crear tickets en este grupo/cola',
        'owner' => 'propietario',
        'Permissions to change the ticket owner in this group/queue.' => 'Permiso para cambiar el propietario del ticket en este grupo/cola',
        'priority' => 'prioridad',
        'Permissions to change the ticket priority in this group/queue.' => 'Permiso para cambiar la prioridad del ticket en este grupo/cola',

        # Template: AdminRoleGroupForm
        'Role' => 'Rol',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Gestin de Roles <-> Usuarios',
        'Select the role:user relations.' => 'Seleccionar las relaciones Rol-Cliente',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Gestin de Saludos',
        'Add Salutation' => 'Aadir Saludo',
        'Add a new Salutation.' => 'Aadir un nuevo Saludo',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'Consola SQL',
        'Go' => 'Ir',
        'Select Box Result' => 'Seleccione tipo de resultado',

        # Template: AdminService
        'Service Management' => 'Gestin de Servicios',
        'Add Service' => 'Aadir Servicio',
        'Add a new Service.' => 'Aadir un nuevo Servicio',
        'Sub-Service of' => 'Sub-Servicio de',

        # Template: AdminSession
        'Session Management' => 'Gestin de Sesiones',
        'Sessions' => 'Sesiones',
        'Uniq' => 'nico',
        'Kill all sessions' => 'Finalizar todas las sesiones',
        'Session' => 'Sesin',
        'Content' => 'Contenido',
        'kill session' => 'finalizar la sesin',

        # Template: AdminSignatureForm
        'Signature Management' => 'Gestin de Firmas',
        'Add Signature' => 'Aadir Firma',
        'Add a new Signature.' => 'Aadir una nueva Firma',

        # Template: AdminSLA
        'SLA Management' => 'Gestin de SLA',
        'Add SLA' => 'Aadir SLA',
        'Add a new SLA.' => 'Aadir un nuevo SLA',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'Gestion S/MIME',
        'Add Certificate' => 'Aadir un certificado',
        'Add Private Key' => 'Aadir una Clave privada',
        'Secret' => 'Secreto',
        'Hash' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'De esta forma Ud. puede editar directamente la certificacin y claves privadas en el sistema de archivos.',

        # Template: AdminStateForm
        'State Management' => 'Gestin de Estados',
        'Add State' => 'Aadir Estado',
        'Add a new State.' => 'Aadir un nuevo Estado',
        'State Type' => 'Tipo de estado',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Recuerde tambin actualizar los estados en su archivo Kernel/Config.pm! ',
        'See also' => 'Vea tambin',

        # Template: AdminSysConfig
        'SysConfig' => '',
        'Group selection' => 'Seleccin de Grupo',
        'Show' => 'Mostrar',
        'Download Settings' => 'Descargar Configuracin',
        'Download all system config changes.' => 'Descargar todos los cambios de configuracin',
        'Load Settings' => 'Cargar Configuracin',
        'Subgroup' => 'Subgrupo',
        'Elements' => 'Elementos',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Opciones de Configuracin',
        'Default' => 'Por Defecto',
        'New' => 'Nuevo',
        'New Group' => 'Nuevo grupo',
        'Group Ro' => 'Grupo Ro',
        'New Group Ro' => 'Nuevo Grupo Ro',
        'NavBarName' => 'NombreBarraNavegacin',
        'NavBar' => 'BarraNavegacin',
        'Image' => 'Imagen',
        'Prio' => '',
        'Block' => 'Bloquear',
        'AccessKey' => 'TeclaAcceso',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Gestin de Direcciones de Correo del sistema',
        'Add System Address' => 'Aadir Direccin de Sistema',
        'Add a new System Address.' => 'Aadir una Direccin de Sistema',
        'Realname' => 'Nombre real',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todos los mensajes entrantes con esta direccin (Para:) sern enviados a la cola seleccionada!',

        # Template: AdminTypeForm
        'Type Management' => 'Gestin de Tipos',
        'Add Type' => 'Aadir Tipo',
        'Add a new Type.' => 'Aadir un nuevo Tipo',

        # Template: AdminUserForm
        'User Management' => 'Administracin de usuarios',
        'Add User' => 'Aadir Usuario',
        'Add a new Agent.' => 'Aadir un nuevo Agente',
        'Login as' => 'Conectarse como',
        'Firstname' => 'Nombre',
        'Lastname' => 'Apellido',
        'Start' => 'Iniciar',
        'End' => '',
        'User will be needed to handle tickets.' => 'Se necesita un usuario para manipular los tickets.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'No olvide aadir los nuevos usuarios a grupos y/o roles',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Gestin de Usuarios <-> Grupos',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Libreta de Direcciones',
        'Return to the compose screen' => 'Volver a la pantalla de redaccin',
        'Discard all changes and return to the compose screen' => 'Descartar todos los cambios y volver a la pantalla de redaccin',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',
        'Settings' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => 'Informacin',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Objeto Vinculado: %s',
        'Object' => 'Objeto',
        'Link Object' => 'Enlazar Objeto',
        'with' => '',
        'Select' => 'Seleccionar',
        'Unlink Object: %s' => 'Objecto desvinculado: %s',

        # Template: AgentLookup
        'Lookup' => 'Observar',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Chequeo Ortogrfico',
        'spelling error(s)' => 'errores ortogrficos',
        'or' => 'o',
        'Apply these changes' => 'Aplicar los cambios',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Seguro que desea eliminar este objeto?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Seleccione las restricciones para caracterizar la estadstica',
        'Fixed' => 'Fijado',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Por favor seleccione slo un elemento o desactive el botn \'Fijado\.',
        'Absolut Period' => 'Periodo Absoluto',
        'Between' => 'Entre',
        'Relative Period' => 'Periodo Relativo',
        'The last' => 'El ltimo',
        'Finish' => 'Finalizar',
        'Here you can make restrictions to your stat.' => 'Aqu puede declarar restricciones para sus estadsticas.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Si elimina el candado en la casilla "Fijado", el agente que genera la estadstica puede cambiar los atributos del elemento correspondiente',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Inserte las especificaciones comunes',
        'Permissions' => 'Permisos',
        'Format' => 'Formato',
        'Graphsize' => 'Tamao de Grfico',
        'Sum rows' => 'Sumar filas',
        'Sum columns' => 'Sumar columnas',
        'Cache' => '',
        'Required Field' => 'Campos obligatorios',
        'Selection needed' => 'Seleccin obligatoria',
        'Explanation' => 'Explicacin',
        'In this form you can select the basic specifications.' => 'En esta pantalla puede seleccionar las especificaciones bsicas',
        'Attribute' => 'Atributo',
        'Title of the stat.' => 'Ttulo de la estadstica',
        'Here you can insert a description of the stat.' => 'Aqu puede insertar una descripcin de la estadstica.',
        'Dynamic-Object' => 'Objeto-Dinmico',
        'Here you can select the dynamic object you want to use.' => 'Aqu puede seleccionar el elemento dinmico que desea utilizar',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Nota: Depende de su instalacin cuntos objetos dinmicos puede utilizar',
        'Static-File' => 'Archivo-Esttico',
        'For very complex stats it is possible to include a hardcoded file.' => 'Para una estadstica muy compleja es posible incluir un archivo prefijado',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Si un nuevo archivo prefijado est disponible, este atributo se le mostrar y podr seleccionar uno',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Configuracin de permisos. Puede seleccionar uno o ms grupos para hacer visibles las estadsticas configuradas a distintos agentes',
        'Multiple selection of the output format.' => 'Seleccin mltiple del formato de salida',
        'If you use a graph as output format you have to select at least one graph size.' => 'Si utiliza un grfico como formato de salida debe seleccionar al menos un tamao de grfico.',
        'If you need the sum of every row select yes' => 'Si necesita la suma de cada fila seleccione S',
        'If you need the sum of every column select yes.' => 'Si necesita las suma de cada columna seleccione S',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'La mayora de las estadisticas pueden ser conservadas en cache. Esto acelera la presentacin de esta estadstica.',
        '(Note: Useful for big databases and low performance server)' => '(Nota: Util para bases de datos grandes y servidores de bajo rendimiento)',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Con una estadistica invlida, no es posible generar estadsticas.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Esto es til si desea que nadie pueda obtener el resultado de una estadstica o la misma an no est configurada',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Seleccione los elementos para los valores de la serie',
        'Scale' => 'Escala',
        'minimal' => 'mnimo',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Recuerde, la escala para los valores de la serie debe ser mayor que la escala para el eje-X (ej: eje-X => Mes, ValorSeries => Ao).',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Aqu puede definir la serie de valores. Tiene la posibilidad de seleccionar uno o ms elementos. Luego, puede seleccionar los atributos de los elementos. Cada atributo ser mostrado como un elemento de la serie. Si no selecciona ningn atributo, todos los atributos del elemento sern utilizados si genera una estadstica. Asimismo un nuevo atributo es aadido desde la ltima configuracin.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'Seleccione el elemento, que ser utilizado en el eje-X',
        'maximal period' => 'periodo mximo',
        'minimal scale' => 'escala mnima',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => 'Importar',
        'File is not a Stats config' => 'El archivo no es una configuracin de estadsticas',
        'No File selected' => 'No hay archivo seleccionado',

        # Template: AgentStatsOverview
        'Results' => 'Resultados',
        'Total hits' => 'Total de coincidencias',
        'Page' => 'Pgina',

        # Template: AgentStatsPrint
        'Print' => 'Imprimir',
        'No Element selected.' => 'No hay elemento seleccionado',

        # Template: AgentStatsView
        'Export Config' => 'Exportar Configuracin',
        'Information about the Stat' => 'Informacin sobre la estadstica',
        'Exchange Axis' => 'Intercambiar Ejes',
        'Configurable params of static stat' => 'Parmetro configurable de estadstica esttica',
        'No element selected.' => 'No hay elemento seleccionado',
        'maximal period from' => 'periodo mximo desde',
        'to' => 'a',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Con los campos de entrada y seleccin, puede configurar las estadsticas a sus necesidades. Los elementos de estadsticas que puede editar dependen de cmo haya sido configurado por el administrador',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'El mensaje debe tener el destinatario Para: !',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Necesita una direccin de correo (ej: cliente@ejemplo.com) en Para:!',
        'Bounce ticket' => 'Ticket rebotado',
        'Ticket locked!' => 'Ticket bloqueado!',
        'Ticket unlock!' => 'Ticket desbloqueado!',
        'Bounce to' => 'Rebotar a',
        'Next ticket state' => 'Nuevo estado del ticket',
        'Inform sender' => 'Informar al emisor',
        'Send mail!' => 'Enviar correo!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Necesita contabilizar el tiempo!',
        'Ticket Bulk Action' => 'Accin mltiple con Tickets',
        'Spell Check' => 'Chequeo Ortogrfico',
        'Note type' => 'Tipo de nota',
        'Next state' => 'Siguiente estado',
        'Pending date' => 'Fecha pendiente',
        'Merge to' => 'Fusionar con',
        'Merge to oldest' => '',
        'Link together' => '',
        'Link to Parent' => '',
        'Unlock Tickets' => 'Desbloquear Tickets',

        # Template: AgentTicketClose
        'Ticket Type is required!' => '',
        'A required field is:' => '',
        'Close ticket' => 'Cerrar el ticket',
        'Previous Owner' => 'Propietario Anterior',
        'Inform Agent' => 'Notificar a Agente',
        'Optional' => 'Opcional',
        'Inform involved Agents' => 'Notificar a Agentes involucrados',
        'Attach' => 'Anexo',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'El mensaje debe ser verificado ortogrficamente!',
        'Compose answer for ticket' => 'Redacte una respuesta para el ticket',
        'Pending Date' => 'Fecha pendiente',
        'for pending* states' => 'en estado pendiente*',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Cambiar cliente del ticket',
        'Set customer user and customer id of a ticket' => 'Asignar agente y cliente de un ticket',
        'Customer User' => 'Cliente',
        'Search Customer' => 'Bsqueda de cliente',
        'Customer Data' => 'Informacin del cliente',
        'Customer history' => 'Historia del cliente',
        'All customer tickets.' => 'Todos los tickets de un cliente',

        # Template: AgentTicketEmail
        'Compose Email' => 'Redactar Correo',
        'new ticket' => 'nuevo ticket',
        'Refresh' => 'Refrescar',
        'Clear To' => 'Vaciar Para',
        'All Agents' => 'Todos los Agentes',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Tipo de artculo',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Cambiar el texto libre del ticket',

        # Template: AgentTicketHistory
        'History of' => 'Historia de',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Necesita user un nmero de ticket!',
        'Ticket Merge' => 'Fusionar Ticket',

        # Template: AgentTicketMove
        'Move Ticket' => 'Mover Ticket',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Aadir nota al ticket',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => 'Tiempo para Primera Respuesta',
        'Service Time' => 'Tiempo de Servicio',
        'Update Time' => 'Tiempo para Actualizacin',
        'Solution Time' => 'Tiempo para Solucin',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Necesita al menos seleccionar un Ticket!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Filtro',
        'Change search options' => 'Cambiar opciones de bsqueda',
        'Tickets' => '',
        'of' => 'de',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Responder',
        'Contact customer' => 'Contactar con el cliente',
        'Change queue' => 'Modificar cola',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'ordenar ascendente',
        'up' => 'arriba',
        'sort downward' => 'ordenar descendente',
        'down' => 'abajo',
        'Escalation in' => 'Escalado en',
        'Locked' => 'Bloqueado',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Cambiar el propietario del ticket',

        # Template: AgentTicketPending
        'Set Pending' => 'Establecer como pendiente',

        # Template: AgentTicketPhone
        'Phone call' => 'Llamada telefnica',
        'Clear From' => 'Vaciar De',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Texto plano',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Informacion-Ticket',
        'Accounted time' => 'Tiempo contabilizado',
        'Linked-Object' => 'Objeto-vinculado',
        'by' => 'por',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Cambiar la prioridad del ticket',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Tickets mostrados',
        'Tickets available' => 'Tickets disponibles',
        'All tickets' => 'Todos los tickets',
        'Queues' => 'Colas',
        'Ticket escalation!' => 'Escalado de ticket',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Cambiar responsable del ticket',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Buscar ticket',
        'Profile' => 'Perfil',
        'Search-Template' => 'Buscar-Modelo',
        'TicketFreeText' => 'TextoLibreTicket',
        'Created in Queue' => 'Creado en Cola',
        'Article Create Times' => '',
        'Article created' => '',
        'Article created between' => '',
        'Change Times' => '',
        'No change time settings.' => '',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Result Form' => 'Modelo de Resultados',
        'Save Search-Profile as Template?' => 'Guardar perfil de bsqueda como patrn?',
        'Yes, save it with name' => 'S, guardarlo con nombre',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'Vista ampliada',
        'Collapse View' => 'Vista reducida',
        'Split' => 'Dividir',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => '',
        'Save filter settings as default' => '',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => '',

        # Template: CustomerFooter
        'Powered by' => '',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'Identificador',
        'Lost your password?' => 'Perdi su contrasea',
        'Request new password' => 'Solicitar una nueva contrasea',
        'Create Account' => 'Crear Cuenta',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Bienvenido %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Veces',
        'No time settings.' => 'Sin especificacin de tiempo',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Haga click aqu para informar de un error!',

        # Template: Footer
        'Top of Page' => 'Inicio de pgina',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Inicio',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Instalador Web',
        'Welcome to %s' => 'Bienvenido a %s',
        'Accept license' => 'Aceptar licencia',
        'Don\'t accept license' => 'No aceptar licencia',
        'Admin-User' => 'Usuario-Admin',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Si ha fijado una clave para su base de datos, debe especificarla aqu. Si no, djelo en blanco. Por razones de seguridad, recomendamos establecer una clave para root. PAra ms informacin, consulte la documentacin de su base de datos.',
        'Admin-Password' => 'Contrasea-Administrador',
        'Database-User' => 'Usuario-Base de datos',
        'default \'hot\'' => 'por defecto \'hot\'',
        'DB connect host' => 'Host de conexin a la Base de datos',
        'Database' => 'Base de Datos',
        'Default Charset' => 'Juego de caracteres por defecto',
        'utf8' => '',
        'false' => 'falso',
        'SystemID' => 'ID de sistema',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(La identidad del sistema. Cada nmero de ticket y cada id de sesin http comienza con este nmero)',
        'System FQDN' => 'FQDN del sistema',
        '(Full qualified domain name of your system)' => '(Nombre completo del dominio de su sistema)',
        'AdminEmail' => 'Correo del Administrador.',
        '(Email of the system admin)' => '(email del administrador del sistema)',
        'Organization' => 'Organizacin',
        'Log' => 'Traza',
        'LogModule' => 'Mdulo de trazas',
        '(Used log backend)' => '(Interface de trazas Utilizada)',
        'Logfile' => 'Archivo de trazas',
        '(Logfile just needed for File-LogModule!)' => '(Archivo de trazas necesario para File-LogModule)',
        'Webfrontend' => 'Interface Web',
        'Use utf-8 it your database supports it!' => 'Use utf-8 si su base de datos lo permite!',
        'Default Language' => 'Lenguaje por defecto',
        '(Used default language)' => '(Use el lenguaje por defecto)',
        'CheckMXRecord' => 'Revisar record MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Chequear registro MX de direcciones utilizadas al responder. No usarlo si su PC con el Otrs est detrs de una lnea conmutada $!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para poder utilizar el OTRS debe escribir la siguiente lnea en la consola de sistema (Terminal/Shell) como usuario root',
        'Restart your webserver' => 'Reinicie su servidor web',
        'After doing so your OTRS is up and running.' => 'Despus de hacer esto, su OTRS estar activo y ejecutndose',
        'Start page' => 'Pgina de inicio',
        'Your OTRS Team' => 'Su equipo OTRS',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'No tiene autorizacin',

        # Template: Notify
        'Important' => 'Importante',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'impreso por',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'Pgina de Prueba de OTRS',
        'Counter' => 'Contador',

        # Template: Warning

        # Template: YUI

        # Misc
        'Edit Article' => 'Editar Artculo',
        'Create Database' => 'Crear Base de Datos',
        'Ticket Number Generator' => 'Generador de nmeros de Tickets',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificador de Ticket. Algunas personas quieren usar por ejemplo \'Ticket#\', \'Call#\' o \'MyTicket#\')',
        'Create new Phone Ticket' => 'Crear un nuevo Ticket Telefnico',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'De esta forma, Ud. puede editar directamente las claves configuradas en Kernel/Config.pm.',
        'Symptom' => 'Sntoma',
        'U' => 'A',
        'Site' => 'Sitio',
        'Customer history search (e. g. "ID342425").' => 'Historia de bsquedas del cliente (ej: "ID342425")',
        'Can not delete link with %s!' => 'No se puede eliminar vnculo con %s!',
        'for agent firstname' => 'nombre del agente',
        'Close!' => 'Cerrar!',
        'No means, send agent and customer notifications on changes.' => '"No" significa enviar a los agentes y clientes notificaciones al realizar cambios.',
        'A web calendar' => 'Calendario Web',
        'to get the realname of the sender (if given)' => 'para obtener el nombre del emisor (si lo proporcion)',
        'OTRS DB Name' => 'Nombre de la BD OTRS',
        'Notification (Customer)' => 'Notificacin (Cliente)',
        'Select Source (for add)' => 'Seleccionar Fuente (para aadir)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Opcciones de los datos del ticket (ej. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Child-Object' => 'Objeto-Hijo',
        'Days' => 'Das',
        'Queue ID' => 'Id de la Cola',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Opciones de configuracin (ej: <OTRS_CONFIG_HttpType>)',
        'System History' => 'Historia del Sistema',
        'customer realname' => 'Nombre del cliente',
        'Pending messages' => 'Mensajes pendientes',
        'Modules' => 'Mdulos',
        'for agent login' => 'login del agente',
        'Keyword' => 'palabra clave',
        'Close type' => 'Tipo de cierre',
        'DB Admin User' => 'Usuario Admin de la BD',
        'for agent user id' => 'id del agente',
        'Problem' => 'Problema',
        'Escalation' => 'Escalado',
        '"}' => '',
        'Order' => 'Orden',
        'next step' => 'prximo paso',
        'Follow up' => 'Seguimiento',
        'Customer history search' => 'Historia de bsquedas del cliente',
        'Admin-Email' => 'Correo del Administrador',
        'Stat#' => '',
        'Create new database' => 'Crear nueva base de datos',
        'ArticleID' => 'Identificador de artculo',
        'Keywords' => 'palabras clave',
        'Ticket Escalation View' => 'Ver Escalado del Ticket',
        'Today' => 'Hoy',
        'No * possible!' => 'No * posible!',
        'Options ' => 'Opciones',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opciones del usuario que solicit la accin (ej. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Message for new Owner' => 'Mensaje para el nuevo propietario',
        'to get the first 5 lines of the email' => 'para obtener las primeras 5 lneas del correo',
        'Sort by' => 'Ordenado por',
        'OTRS DB Password' => 'Contrasea para BD del usuario OTRS',
        'Last update' => 'Ultima Actualizacin',
        'Tomorrow' => 'Maana',
        'to get the first 20 character of the subject' => 'para obtener los primeros 20 caracteres del asunto ',
        'Select the customeruser:service relations.' => 'Seleccione las relaciones cliente:servicio.',
        'DB Admin Password' => 'Contrasea del Administrador de la BD',
        'Advisory' => 'Advertencia',
        'Drop Database' => 'Eliminar Base de Datos',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Aqui puede definir el eje-x. Puede seleccionar un elemento usando la casilla de seleccin. Luego debe seleccionar dos o ms atributos del elemento. Si Ud. no selecciona ninguno, todos los atributos del elemento se utilizarn para generar una estadstica. Asimismo un nuevo atributo es aadido desde la ltima configuracin.',
        'FileManager' => 'Administrador de Archivos',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Opciones del usuario activo  (ej. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'Tipo pendiente',
        'Comment (internal)' => 'Comentario (interno)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opciones del propietario del Ticket (ej. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Minutes' => 'Minutos',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opciones de la informacin del ticket (ej: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(Formato de nmero de ticket utilizado)',
        'Reminder' => 'Recordatorio',
        'Fulltext' => 'Texto Completo',
        'Incident' => 'Incidente',
        'All Agent variables.' => 'Todas las variables de Agente',
        ' (work units)' => ' (unidades de trabajo)',
        'Next Week' => 'Prxima semana',
        'All Customer variables like defined in config option CustomerUser.' => 'Todas las variables de cliente, como las declaradas en la opcin de configuracion del cliente',
        'accept license' => 'aceptar licencia',
        'for agent lastname' => 'apellido del agente',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Opciones del usuario activo que solicit esta accin (ej. <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Mensajes recordatorios',
        'Change users <-> roles settings' => 'Modificar Configuracin de Usuarios <-> Roles',
        'Parent-Object' => 'Objeto-Padre',
        'Of couse this feature will take some system performance it self!' => 'De acuerdo a esta caracterstica se efectuarn ciertas mejoras en el sistema por s mismo.',
        'Your own Ticket' => 'Sus tickets',
        'Detail' => 'Detalle',
        'TicketZoom' => 'Detalle del Ticket',
        'Open Tickets' => 'Tickets Abiertos',
        'Don\'t forget to add a new user to groups!' => 'No olvide incluir el nuevo usuario en grupos!',
        'CreateTicket' => 'CrearTicket',
        'You have to select two or more attributes from the select field!' => 'Debe seleccionar dos o ms atributos del campo seleccionado',
        'System Settings' => 'Configuracin del sistema',
        'WebWatcher' => 'ObservadorWeb',
        'Hours' => 'Horas',
        'Finished' => 'Finalizado',
        'Account Type' => 'Tipo de cuenta',
        'D' => '',
        'System Status' => 'Estado del Sistema',
        'All messages' => 'Todos los mensajes',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opciones de la informacin del ticket (ej. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Artefact' => 'Artefacto',
        'Object already linked as %s.' => 'Objecto ya vinculado como %s.',
        'A article should have a title!' => 'Los artculos deben tener ttulo',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Opciones de configuracin (ej. &lt;OTRS_CONFIG_HttpType&gt;)',
        'don\'t accept license' => 'no aceptar la licencia',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'A web mail client' => 'Un cliente de correo Web',
        'Compose Follow up' => 'Redactar seguimiento',
        'WebMail' => 'CorreoWeb',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Opciones del propietario del ticket (ej. <OTRS_OWNER_UserFirstname>)',
        'DB Type' => 'Tipo de BD',
        'kill all sessions' => 'finalizar todas las sesiones',
        'to get the from line of the email' => 'para obtener la lnea from del correo',
        'Solution' => 'Solucin',
        'Package not correctly deployed, you need to deploy it again!' => 'El paquete no ha sido correctamente instalado, necesita instalarlo nuevamente!',
        'QueueView' => 'Ver la cola',
        'Select Box' => 'Ventana de seleccin',
        'New messages' => 'Nuevos mensajes',
        'Can not create link with %s!' => 'No se puede vincular con %s!',
        'Linked as' => 'Vinculado como',
        'Welcome to OTRS' => 'Bienvenido al OTRS',
        'modified' => 'modificado',
        'Delete old database' => 'Eliminar BD antigua',
        'A web file manager' => 'Administrador web de archivos',
        'Have a lot of fun!' => 'Disfrtelo!',
        'send' => 'enviar',
        'Send no notifications' => 'No enviar notificaciones',
        'Note Text' => 'Nota!',
        'POP3 Account Management' => 'Gestin de cuenta POP3',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opciones de los datos del cliente activo (ej. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'System State Management' => 'Gestin de Estados del Sistema',
        'OTRS DB User' => 'Usuario de BD OTRS',
        'Mailbox' => 'Buzn',
        'PhoneView' => 'Vista telefnica',
        'maximal period form' => 'periodo mximo del formulario',
        'TicketID' => 'Identificador de Ticket',
        'Yes means, send no agent and customer notifications on changes.' => '"S" significa no enviar notificacin a los agentes y clientes al realizarse cambios.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Su correo con nmero de ticket "<OTRS_TICKET>"  fue rebotado a "<OTRS_BOUNCE_TO>". Contacte con dicha direccin para ms informacin.',
        'Ticket Status View' => 'Ver Estado del Ticket',
        'Modified' => 'Modificado',
        'Ticket selected for bulk action!' => 'Ticket seleccionado para accin mltiple!',
    };
    # $$STOP$$
    return;
}

1;
