# --
# Kernel/Language/hu.pm - provides de language translation
# Copyright (C) 2004 RLAN Internet <MAGIC at rlan.hu>
# --
# $Id: hu.pm,v 1.12 2005/07/28 20:32:31 martin Exp $
# Translation: Gabor Gancs /gg@magicnet.hu/ & Krisztian Gancs /krisz@gancs.hu/
# Verify: Flora Szabo /szaboflora@magicnet.hu/
# Hungary Sopron Europe
#
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::hu;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.12 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;

    # $$START$$
    # Last translation file sync: Thu Jul 28 22:14:22 2005

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%Y.%M.%D %T';
    $Self->{DateFormatLong} = '%Y %B %D %A %T';
    $Self->{DateInputFormat} = '%Y.%M.%D';
    $Self->{DateInputFormatLong} = '%Y.%M.%D - %T';

    $Self->{Translation} = {
      # Template: AAABase
      'Yes' => 'Igen',
      'No' => 'Nem',
      'yes' => 'igen',
      'no' => 'nem',
      'Off' => 'Ki',
      'off' => 'ki',
      'On' => 'Be',
      'on' => 'be',
      'top' => 'Teteje',
      'end' => 'vge',
      'Done' => 'Ksz',
      'Cancel' => 'Mgsem',
      'Reset' => 'Alaplls',
      'last' => 'utols',
      'before' => 'eltt',
      'day' => 'nap',
      'days' => 'nap',
      'day(s)' => 'nap',
      'hour' => 'ra',
      'hours' => 'ra',
      'hour(s)' => '',
      'minute' => 'Perc',
      'minutes' => 'perc',
      'minute(s)' => '',
      'month' => '',
      'months' => '',
      'month(s)' => 'hnap',
      'week' => '',
      'week(s)' => 'ht',
      'year' => '',
      'years' => '',
      'year(s)' => 'v',
      'wrote' => 'rta',
      'Message' => 'zenet',
      'Error' => 'Hiba',
      'Bug Report' => 'Hibajelents',
      'Attention' => 'Figyelem',
      'Warning' => 'Figyelem',
      'Module' => 'Modul',
      'Modulefile' => 'Modulfile',
      'Subfunction' => 'Alfunkci',
      'Line' => 'Vonal',
      'Example' => 'Plda',
      'Examples' => 'Plda',
      'valid' => 'rvnyes',
      'invalid' => 'rvnytelen',
      'invalid-temporarily' => '',
      ' 2 minutes' => ' 2 Perc',
      ' 5 minutes' => ' 5 Perc',
      ' 7 minutes' => ' 7 Perc',
      '10 minutes' => '10 Perc',
      '15 minutes' => '15 Perc',
      'Mr.' => '',
      'Mrs.' => '',
      'Next' => 'Kvetkez',
      'Back' => 'Vissza',
      'Next...' => 'Kvetkez...',
      '...Back' => '...Vissza',
      '-none-' => '',
      'none' => 'semmi',
      'none!' => 'semmi!',
      'none - answered' => 'semmi - megvlaszolt',
      'please do not edit!' => 'krjk ne javtsa!',
      'AddLink' => 'Link hozzadsa',
      'Link' => 'Hivatkozs',
      'Linked' => '',
      'Link (Normal)' => '',
      'Link (Parent)' => '',
      'Link (Child)' => '',
      'Normal' => 'Norml',
      'Parent' => '',
      'Child' => '',
      'Hit' => 'Tallat',
      'Hits' => 'Tallat',
      'Text' => 'Szveg',
      'Lite' => 'Egyszer',
      'User' => 'Felhasznl',
      'Username' => 'Felhasznlnv',
      'Language' => 'Nyelv',
      'Languages' => 'Nyelv',
      'Password' => 'Jelsz',
      'Salutation' => 'Megszlts',
      'Signature' => 'Alrs',
      'Customer' => 'gyfl',
      'CustomerID' => 'gyfl#',
      'CustomerIDs' => '',
      'customer' => 'gyfl',
      'agent' => 'gynk',
      'system' => 'rendszer',
      'Customer Info' => 'gyfl Info',
      'go!' => 'Indtsd!',
      'go' => 'indtsd',
      'All' => 'sszes',
      'all' => 'sszes',
      'Sorry' => 'Sajnlom',
      'update!' => 'Frisst!',
      'update' => 'frisst',
      'Update' => 'Frisst',
      'submit!' => 'Elkld!',
      'submit' => 'elkld',
      'Submit' => '',
      'change!' => 'Vltoztat!',
      'Change' => 'Vltoztat',
      'change' => 'vltoztat',
      'click here' => 'kattints ide',
      'Comment' => 'Megjegyzs',
      'Valid' => 'rvnyes',
      'Invalid Option!' => '',
      'Invalid time!' => '',
      'Invalid date!' => '',
      'Name' => 'Nv',
      'Group' => 'Csoport',
      'Description' => 'Lers',
      'description' => 'lers',
      'Theme' => 'Tma',
      'Created' => 'Elksztve',
      'Created by' => '',
      'Changed' => '',
      'Changed by' => '',
      'Search' => 'Keress',
      'and' => 's',
      'between' => '',
      'Fulltext Search' => '',
      'Data' => '',
      'Options' => 'Belltsok',
      'Title' => 'Cm',
      'Item' => '',
      'Delete' => 'Trl',
      'Edit' => 'Szerkeszt',
      'View' => 'Nzet',
      'Number' => '',
      'System' => 'Rendszer',
      'Contact' => 'Kapcsolat',
      'Contacts' => '',
      'Export' => '',
      'Up' => '',
      'Down' => '',
      'Add' => 'Hozzad',
      'Category' => 'Kategria',
      'Viewer' => '',
      'New message' => 'j zenet',
      'New message!' => 'j zenet!',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Krjk vlaszoljon erre(ezekre) a jegy(ek)re hogy visszatrhessen a norml gyek nzethez!',
      'You got new message!' => 'j zenete rkezett!',
      'You have %s new message(s)!' => '%s j zenete van!',
      'You have %s reminder ticket(s)!' => '%s emlkeztet jegye van!',
      'The recommended charset for your language is %s!' => 'Az ajnlott karakterkszlet az n nyelvnl %s!',
      'Passwords dosn\'t match! Please try it again!' => 'A jelszavak nem egyeznek! Prblja meg jra!',
      'Password is already in use! Please use an other password!' => '',
      'Password is already used! Please use an other password!' => '',
      'You need to activate %s first to use it!' => '',
      'No suggestions' => 'Nincsenek javaslatok',
      'Word' => 'Sz',
      'Ignore' => 'Figyelmen kvl hagy',
      'replace with' => 'csere ezzel',
      'Welcome to OTRS' => 'dvzli az OTRS',
      'There is no account with that login name.' => 'Azzal a nvvel nincs azonost.',
      'Login failed! Your username or password was entered incorrectly.' => 'Belps sikertelen! Hibsan adta meg a felhasznli nevt vagy jelszavt.',
      'Please contact your admin' => 'Krjk vegye fel a kapcsolatot a rendszergazdjval',
      'Logout successful. Thank you for using OTRS!' => 'Kilps rendben! Ksznjk, hogy az OTRS-t hasznlja!',
      'Invalid SessionID!' => 'Hibs SessionID!',
      'Feature not active!' => 'Kpessg nem aktv!',
      'Take this Customer' => 'tveszi ez az gyfl',
      'Take this User' => 'tveszi ez a felhasznl',
      'possible' => 'lehetsges',
      'reject' => 'elutast',
      'Facility' => 'Kpessg',
      'Timeover' => 'Kss',
      'Pending till' => 'Vrakozs eddig',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'Ne dolgozzon az 1-es felhasznlval (Rendszer jogosultsg)! Hozzon ltre j felhasznlt!',
      'Dispatching by email To: field.' => 'Feloszts email cmzett mez szerint.',
      'Dispatching by selected Queue.' => 'Feloszts a kivlasztott gy szerint.',
      'No entry found!' => 'Nem tallhat ttel!',
      'Session has timed out. Please log in again.' => 'Az gymenet idtllpsmiatt befejezdtt. Krjk lpjen be jra.',
      'No Permission!' => 'Nincs jogosultsg!',
      'To: (%s) replaced with database email!' => 'Cmzett: (%s) fellrva az adatbzis cmmel!',
      'Cc: (%s) added database email!' => '',
      '(Click here to add)' => '(Kattinst ide a hozzadshoz)',
      'Preview' => 'Elnzet',
      'Added User "%s"' => 'A "%s" felhasznl hozzadva',
      'Contract' => 'Kapcsolat',
      'Online Customer: %s' => 'Bejelentkezett gyfl: %s',
      'Online Agent: %s' => 'Bejelentkezett gynk: %s',
      'Calendar' => 'Naptr',
      'File' => 'Fjl',
      'Filename' => 'Fjlnv',
      'Type' => 'Tpus',
      'Size' => 'Mret',
      'Upload' => 'Feltlt',
      'Directory' => 'Knyvtr',
      'Signed' => 'Alrt',
      'Sign' => 'Alr',
      'Crypted' => 'Kdolt',
      'Crypt' => 'Kdol',

      # Template: AAAMonth
      'Jan' => '',
      'Feb' => '',
      'Mar' => 'Mr',
      'Apr' => 'pr',
      'May' => 'Mj',
      'Jun' => 'Jn',
      'Jul' => 'Jl',
      'Aug' => '',
      'Sep' => 'Sze',
      'Oct' => 'Okt',
      'Nov' => '',
      'Dec' => '',

      # Template: AAANavBar
      'Admin-Area' => 'Admin terlet',
      'Agent-Area' => 'gynk-terlet',
      'Ticket-Area' => '',
      'Logout' => 'Kilp',
      'Agent Preferences' => 'gynk belltsok',
      'Preferences' => 'Belltsok',
      'Agent Mailbox' => '',
      'Stats' => 'Statisztika',
      'Stats-Area' => '',
      'FAQ-Area' => 'GYIK terlet',
      'FAQ' => 'GYIK',
      'FAQ-Search' => '',
      'FAQ-Article' => '',
      'New Article' => 'j cikk',
      'FAQ-State' => '',
      'Admin' => '',
      'A web calendar' => '',
      'WebMail' => '',
      'A web mail client' => '',
      'FileManager' => '',
      'A web file manager' => '',
      'Artefact' => '',
      'Incident' => '',
      'Advisory' => '',
      'WebWatcher' => '',
      'Customer Users' => '',
      'Customer Users <-> Groups' => '',
      'Users <-> Groups' => '',
      'Roles' => 'Szablyok',
      'Roles <-> Users' => '',
      'Roles <-> Groups' => '',
      'Salutations' => '',
      'Signatures' => '',
      'Email Addresses' => '',
      'Notifications' => '',
      'Category Tree' => '',
      'Admin Notification' => '',

      # Template: AAAPreferences
      'Preferences updated successfully!' => 'Belltsok sikeresen frisstve!',
      'Mail Management' => 'Email kezels',
      'Frontend' => 'Munkafellet',
      'Other Options' => 'Egyb belltsok',
      'Change Password' => '',
      'New password' => '',
      'New password again' => '',
      'Select your QueueView refresh time.' => 'Vlassza ki az gyekNzet frisstsi idejt.',
      'Select your frontend language.' => 'Vlassza ki a munkafellet nyelvt.',
      'Select your frontend Charset.' => 'Vlassza ki a munkafellet karakterkszlett.',
      'Select your frontend Theme.' => 'Vlassza ki a munkafellet stlust.',
      'Select your frontend QueueView.' => 'Vlassza ki a munkafellet gyek-nzett.',
      'Spelling Dictionary' => 'Helyesrs-ellenrz sztr',
      'Select your default spelling dictionary.' => 'Vlassza ki az alaprtelmezett helyesrsellenrz sztrat.',
      'Max. shown Tickets a page in Overview.' => 'Max. megjelentett jegy az ttekintsnl.',
      'Can\'t update password, passwords dosn\'t match! Please try it again!' => '',
      'Can\'t update password, invalid characters!' => '',
      'Can\'t update password, need min. 8 characters!' => '',
      'Can\'t update password, need 2 lower and 2 upper characters!' => '',
      'Can\'t update password, need min. 1 digit!' => '',
      'Can\'t update password, need min. 2 characters!' => '',
      'Password is needed!' => '',

      # Template: AAATicket
      'Lock' => 'Zrol',
      'Unlock' => 'Felold',
      'History' => 'Trtnet',
      'Zoom' => 'Nagyt',
      'Age' => 'Kor',
      'Bounce' => 'Visszakld',
      'Forward' => 'Tovbbt',
      'From' => 'Felad',
      'To' => 'Cmzett',
      'Cc' => 'Msolat',
      'Bcc' => 'Vakmsolat',
      'Subject' => 'Trgy',
      'Move' => 'thelyez',
      'Queue' => 'gyek',
      'Priority' => 'Srgssg',
      'State' => 'llapot',
      'Compose' => 'Kszt',
      'Pending' => 'Vrakozik',
      'Owner' => 'Tulajdonos',
      'Owner Update' => '',
      'Sender' => 'Kld',
      'Article' => 'Cikk',
      'Ticket' => 'Jegy',
      'Createtime' => 'Elkszlt ',
      'plain' => 'sima',
      'eMail' => '',
      'email' => '',
      'Close' => 'Lezr',
      'Action' => 'Mvelet',
      'Attachment' => 'Csatols',
      'Attachments' => 'Csatols',
      'This message was written in a character set other than your own.' => 'Ezt az zenetet ms karakterkszlettel rtk mint amit n hasznl.',
      'If it is not displayed correctly,' => 'Ha nem helyesen jelent meg,',
      'This is a' => 'Ez egy',
      'to open it in a new window.' => 'hogy megnyissa j ablakban.',
      'This is a HTML email. Click here to show it.' => 'Ez egy HTML email. Kattintson ide a megtekintshez.',
      'Free Fields' => '',
      'Merge' => '',
      'closed successful' => 'sikeresen lezrva',
      'closed unsuccessful' => 'sikertelenl lezrva',
      'new' => 'j',
      'open' => 'nyitva',
      'closed' => 'lezrt',
      'removed' => 'trlve',
      'pending reminder' => 'emlkeztetre vrakozik',
      'pending auto close+' => 'automatikus zrsra vrakozik+',
      'pending auto close-' => 'automatikus zrsra vrakozik-',
      'email-external' => 'kls email',
      'email-internal' => 'bels email',
      'note-external' => 'kls jegyzet',
      'note-internal' => 'bels jegyzet',
      'note-report' => 'jegyzet jelents',
      'phone' => 'telefon',
      'sms' => '',
      'webrequest' => 'webkrs',
      'lock' => 'zrolt',
      'unlock' => 'feloldva',
      'very low' => 'nagyon alacsony',
      'low' => 'alacsony',
      'normal' => 'norml',
      'high' => 'magas',
      'very high' => 'nagyon magas',
      '1 very low' => '1 nagyon alacsony',
      '2 low' => '2 alacsony',
      '3 normal' => '3 norml',
      '4 high' => '4 magas',
      '5 very high' => '5 nagyon magas',
      'Ticket "%s" created!' => 'A "%s" jegy ltrehozva!',
      'Ticket Number' => 'Jegy szm',
      'Ticket Object' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => 'Nincs "%s" szm jegy! Nem tudom csatolni!',
      'Don\'t show closed Tickets' => 'Ne jelentse meg a lezrt jegyeket.',
      'Show closed Tickets' => 'Mutasd a lezrt jegyeket',
      'Email-Ticket' => '',
      'Create new Email Ticket' => '',
      'Phone-Ticket' => '',
      'Create new Phone Ticket' => 'j telefon jegy ltrehozsa',
      'Search Tickets' => '',
      'Edit Customer Users' => '',
      'Bulk-Action' => '',
      'Bulk Actions on Tickets' => '',
      'Send Email and create a new Ticket' => '',
      'Overview of all open Tickets' => 'sszes nyitott jegy ttekintse',
      'Locked Tickets' => '',
      'Lock it to work on it!' => '',
      'Unlock to give it back to the queue!' => '',
      'Shows the ticket history!' => '',
      'Print this ticket!' => '',
      'Change the ticket priority!' => '',
      'Change the ticket free fields!' => '',
      'Link this ticket to an other objects!' => '',
      'Change the ticket owner!' => '',
      'Change the ticket customer!' => '',
      'Add a note to this ticket!' => '',
      'Merge this ticket!' => '',
      'Set this ticket to pending!' => '',
      'Close this ticket!' => '',
      'Look into a ticket!' => '',
      'Delete this ticket!' => '',
      'Mark as Spam!' => '',
      'My Queues' => '',
      'Shown Tickets' => '',
      'New ticket notification' => 'j jegy rtests',
      'Send me a notification if there is a new ticket in "My Queues".' => 'Kldjn nekem rtestst, ha j jegy van a "Sajt gyeim"-ben.',
      'Follow up notification' => 'Vlaszlevl rtests',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Kldjn rtestst ha az gyfl vlaszol s n vagyok a tulajdonosa a jegynek.',
      'Ticket lock timeout notification' => 'Jegyzrols-lejrat rtests',
      'Send me a notification if a ticket is unlocked by the system.' => 'Kldjn rtestst ha a jegy zrolst a renszer feloldotta.',
      'Move notification' => 'thelyezs rtests',
      'Send me a notification if a ticket is moved into one of "My Queues".' => 'Kldjn nekem rtestst, ha egy jegyet a "Sajt gyeim" egyikbe mozgattk.',
      'Your queue selection of your favorite queues. You also get notified about this queues via email if enabled.' => '',
      'Custom Queue' => 'Egyedi gyek',
      'QueueView refresh time' => 'gyekNzet frisstsi id',
      'Screen after new ticket' => 'j jegy utni kperny',
      'Select your screen after creating a new ticket.' => 'Vlassza ki a kpernyt j jegy ltrehozsa utn.',
      'Closed Tickets' => 'Lezrt jegyek',
      'Show closed tickets.' => 'Mutasd a lezrt jegyeket.',
      'Max. shown Tickets a page in QueueView.' => 'Max. megjelentett jegy az gyek nzetnl.',
      'Responses' => 'Vlaszok',
      'Responses <-> Queue' => '',
      'Auto Responses' => '',
      'Auto Responses <-> Queue' => '',
      'Attachments <-> Responses' => '',
      'History::Move' => 'Trtnet::Mozgat',
      'History::NewTicket' => 'Trtnet::jJegy',
      'History::FollowUp' => 'Trtnet::Vlasz',
      'History::SendAutoReject' => 'Trtnet::AutomatikusElutastsKlds',
      'History::SendAutoReply' => 'Trtnet::AutomatikusVlaszKlds',
      'History::SendAutoFollowUp' => 'Trtnet::AutomatikusReakciKlds',
      'History::Forward' => 'Trtnet::Tovbbt',
      'History::Bounce' => 'Trtnet::Visszakld',
      'History::SendAnswer' => 'Trtnet::VlaszKlds',
      'History::SendAgentNotification' => 'Trtnet::gynkrtestsKlds',
      'History::SendCustomerNotification' => 'Trtnet::gyflrtestsKlds',
      'History::EmailAgent' => 'Trtnet::Emailgynk',
      'History::EmailCustomer' => 'Trtnet::Emailgyfl',
      'History::PhoneCallAgent' => 'Trtnet::gynkTelefonHvs',
      'History::PhoneCallCustomer' => 'Trtnet::gyflTelefonHvs',
      'History::AddNote' => 'Trtnet::MegjegyzsHozzads',
      'History::Lock' => 'Trtnet::Zrol',
      'History::Unlock' => 'Trtnet::Felolds',
      'History::TimeAccounting' => 'Trtnet::IdElszmols',
      'History::Remove' => 'Trtnet::Eltvolts',
      'History::CustomerUpdate' => 'Trtnet::gyflMdosts',
      'History::PriorityUpdate' => 'Trtnet::SrgssgMdosts',
      'History::OwnerUpdate' => 'Trtnet::TulajdonosVlts',
      'History::LoopProtection' => 'Trtnet::VisszacsatolsVdelem',
      'History::Misc' => 'Trtnet::Vegyes',
      'History::SetPendingTime' => 'Trtnet::VrakozsiIdBellts',
      'History::StateUpdate' => 'Trtnet::llapotMdosts',
      'History::TicketFreeTextUpdate' => 'Trtnet::JegySzabadSzvegMdosts',
      'History::WebRequestCustomer' => 'Trtnet::gyflWebKrs',
      'History::TicketLinkAdd' => 'Trtnet::JegyCsatolsHozzads',
      'History::TicketLinkDelete' => 'Trtnet::JegyCsatolsTrls',

      # Template: AAAWeekDay
      'Sun' => 'Vas',
      'Mon' => 'Ht',
      'Tue' => 'Ked',
      'Wed' => 'Sze',
      'Thu' => 'Cs',
      'Fri' => 'Pn',
      'Sat' => 'Szo',

      # Template: AdminAttachmentForm
      'Attachment Management' => 'Csatols kezelse',

      # Template: AdminAutoResponseForm
      'Auto Response Management' => 'Automatikus vlasz kezelnek',
      'Response' => 'Vlasz',
      'Auto Response From' => 'Automatikus vlasz feladnak',
      'Note' => 'Jegyzet',
      'Useable options' => 'Hasznlhat opcik',
      'to get the first 20 character of the subject' => 'hogy megkapja az els 20 karaktert a trgybl',
      'to get the first 5 lines of the email' => 'hogy megkapja az els 5 sort az email-bl',
      'to get the from line of the email' => 'hogy megkapja a feladt az email-bl',
      'to get the realname of the sender (if given)' => 'hogy megkapja a felad valdi nevt (ha lehetsges)',
      'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',

      # Template: AdminCustomerUserForm
      'The message being composed has been closed.  Exiting.' => 'Az ppen elkszlt levl lezrsra kerlt. Kilps.',
      'This window must be called from compose window' => 'Ezt az ablakot a szerkeszt ablakbl kell hvni',
      'Customer User Management' => 'gyfl felhasznlk kezelse',
      'Search for' => 'Keresd a',
      'Result' => 'Eredmnyek',
      'Select Source (for add)' => 'Vlassza ki a forrst (hozzadshoz)',
      'Source' => 'Forrs',
      'This values are read only.' => 'Ezek az rtkek csak olvashatk.',
      'This values are required.' => 'Ezek az rtkek szksgesek.',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => 'gyfl felhasznlra lesz szksg, hogy legyen gyfl trtnet s be lehessen lpni az gyfl panelen.',

      # Template: AdminCustomerUserGroupChangeForm
      'Customer Users <-> Groups Management' => '',
      'Change %s settings' => '%s belltsainak mdostsa',
      'Select the user:group permissions.' => 'A felhasznl:csoport jogok kivlasztsa.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Ha nincs semmi kivlasztva, akkor nincsenek jogosultsgok ebben a csoportban (a jegyek nem lesznek elrhetk a felhasznlnak).',
      'Permission' => 'Jogosultsg',
      'ro' => 'Csak olvass',
      'Read only access to the ticket in this group/queue.' => 'Csak olvassi jogosultsg a jegyekhez ebben a csoportban/gyben.',
      'rw' => 'rs/Olvass',
      'Full read and write access to the tickets in this group/queue.' => 'Teljes rs s olvassi jog a jegyekhez ebben a csoportban/gyben.',

      # Template: AdminCustomerUserGroupForm

      # Template: AdminEmail
      'Message sent to' => 'zenet elkldve',
      'Recipents' => 'Cmzettek',
      'Body' => 'Trzs',
      'send' => 'kld',

      # Template: AdminGenericAgent
      'GenericAgent' => 'ltalnosgynk',
      'Job-List' => 'Feladat-Lista',
      'Last run' => 'Utols vgrehajts',
      'Run Now!' => '',
      'x' => '',
      'Save Job as?' => 'Feladat mentse mskpp?',
      'Is Job Valid?' => '',
      'Is Job Valid' => '',
      'Schedule' => 'Idzt',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Teljesszveg keress a cikkben (pl. "Mar*in" oder "Baue*")',
      '(e. g. 10*5155 or 105658*)' => 'pl. 10*5144 vagy 105658*',
      '(e. g. 234321)' => 'pl. 234321',
      'Customer User Login' => 'gyfl felhasznl belps',
      '(e. g. U5150)' => 'pl. U5150',
      'Agent' => 'gynk',
      'TicketFreeText' => 'Jegy szabadszveg',
      'Ticket Lock' => 'Jegy zrols',
      'Times' => 'Idk',
      'No time settings.' => 'Nincs idbellts.',
      'Ticket created' => 'Jegy ltrehozva',
      'Ticket created between' => 'Jegy ltrehozva kzttk:',
      'New Priority' => 'j srgssg',
      'New Queue' => 'j gy',
      'New State' => 'j llapot',
      'New Agent' => 'j gynk',
      'New Owner' => 'j tulajdonos',
      'New Customer' => 'j gyfl',
      'New Ticket Lock' => 'j jegy zrols',
      'CustomerUser' => 'gyflFelhasznl',
      'Add Note' => 'Megjegyzs hozzadsa',
      'CMD' => 'PARANCS',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Ez a parancs lesz vgrehajtva. Az ARG[0] lesz a jegy szma. Az ARG[1] lesz a jegy azonostja.',
      'Delete tickets' => 'Jegyek trlse',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Figyelem! Ezek a jegyek el lesznek tvoltva az adatbzisbl! Ezek a jegyek elvesztek!',
      'Modules' => 'Modul',
      'Param 1' => '1. paramter',
      'Param 2' => '2. paramter',
      'Param 3' => '3. paramter',
      'Param 4' => '4. paramter',
      'Param 5' => '5. paramter',
      'Param 6' => '6. paramter',
      'Save' => 'Ment',

      # Template: AdminGroupForm
      'Group Management' => 'Csoport kezels',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'Az admin csoport megkapja az admin terletet s a sttusz csoport megkapja a sttusz terletet.',
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Hozzon ltre j csoportot a klnbz gynk csoportok (pl. beszerz osztly, tmogat osztly, elad osztly, ...) hozzfrsi jogainak kezelshez.',
      'It\'s useful for ASP solutions.' => 'Ez hasznos ASP megoldsokhoz.',

      # Template: AdminLog
      'System Log' => 'Rendszernapl',
      'Time' => 'Id',

      # Template: AdminNavigationBar
      'Users' => '',
      'Groups' => 'Csoportok',
      'Misc' => 'Egyb',

      # Template: AdminNotificationForm
      'Notification Management' => 'rtestskezels',
      'Notification' => '',
      'Notifications are sent to an agent or a customer.' => 'Az rtestsek gynknek vagy gyflnek kerlnek elkldsre.',
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Bellts opcik (pl. &lt;OTRS_CONFIG_HttpType&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Jegy tulajdonos opcik (pl. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opcik a aktulis felhasznlnl aki krte ezt az eljrst. (pl. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opcik az aktulis gyfl felhasznli adatokhoz (pl. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',

      # Template: AdminPackageManager
      'Package Manager' => '',
      'Uninstall' => '',
      'Verion' => '',
      'Do you really want to uninstall this package?' => '',
      'Install' => '',
      'Package' => '',
      'Online Repository' => '',
      'Version' => '',
      'Vendor' => '',
      'Upgrade' => '',
      'Local Repository' => '',
      'Status' => 'llapot',
      'Overview' => 'ttekint',
      'Download' => 'Letlt',
      'Rebuild' => '',
      'Reinstall' => '',

      # Template: AdminPGPForm
      'PGP Management' => '',
      'Identifier' => 'Azonost',
      'Bit' => '',
      'Key' => 'Kulcs',
      'Fingerprint' => 'Ujjlenyomat',
      'Expires' => 'Lejr',
      'In this way you can directly edit the keyring configured in SysConfig.' => '',

      # Template: AdminPOP3Form
      'POP3 Account Management' => 'POP3 azonost kezelse',
      'Host' => 'Gazda',
      'Trusted' => 'Megbzhat',
      'Dispatching' => 'Hozzrendels',
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Az sszes egy azonostval rendelkez bejv email egy kivlasztott gynlhz lesz rendelve!',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Ha az n azonostjamegbzhat, a mr ltez x-otrs fejlcet hasznljuk az rkezskor (srgssghez, ...)! Egyb esetben a PostMaster szr lesz alkalmazva.',

      # Template: AdminPostMasterFilter
      'PostMaster Filter Management' => 'PostMaster Szr Kezels',
      'Filtername' => 'Szrnv',
      'Match' => 'Egyezs',
      'Header' => 'Fejlc',
      'Value' => 'rtk',
      'Set' => 'Bellt',
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'A berkez emailek az X-Fejlcek alapjn legyen hozzrendelve! Szablyos kifelyezsek alkalmazhatk.',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Ha szablyos kifelyezseket hasznl, hasznlhatja az egyez rtkeket a ()-ben mint [***] a \'Halmaz\'-ban.',

      # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Responses Management' => '',

      # Template: AdminQueueAutoResponseTable

      # Template: AdminQueueForm
      'Queue Management' => 'gyek kezelse',
      'Sub-Queue of' => 'Al-gye a(z)',
      'Unlock timeout' => 'Felolds idtllps',
      '0 = no unlock' => '0 = nincs felolds',
      'Escalation time' => 'Eszkalci id',
      '0 = no escalation' => '0 = nincs eszkalci',
      'Follow up Option' => 'Vlasz opcik',
      'Ticket lock after a follow up' => 'Jegy zrolsa vlasz rkezse utn.',
      'Systemaddress' => 'Rendszercm',
      'Customer Move Notify' => 'gyfl rtests mozgatskor',
      'Customer State Notify' => 'gyfl rtests llapotvltozskor',
      'Customer Owner Notify' => 'gyfl rtests tulajdonsovltskor',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ha az gynk zrolja a jegyet s nem kld vlaszt ezen idn bell, a jegy zrolsa megsznik. gy a jegy lthat lesz minden gynknek.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Ha a jegy nem kerl megvlaszolsra a megadott idn bell, csak ez a jegy lesz megjelentve.',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ha a jegy le van zrva s az gyfl vlaszol a jegyre, akkor az zrolsra kerl a rgi tulajdonosnak.',
      'Will be the sender address of this queue for email answers.' => 'Ennl az gynl ez lesz a felad email vlaszokhoz.',
      'The salutation for email answers.' => 'A megszlts az email vlaszokhoz.',
      'The signature for email answers.' => 'Az alrs a vlasz emailekhez.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy thelyezsre kerlt.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy llapota megvltozott.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy tulajdonosa megvltozott.',

      # Template: AdminQueueResponsesChangeForm
      'Responses <-> Queue Management' => '',

      # Template: AdminQueueResponsesForm
      'Answer' => 'Vlasz',

      # Template: AdminResponseAttachmentChangeForm
      'Responses <-> Attachments Management' => '',

      # Template: AdminResponseAttachmentForm

      # Template: AdminResponseForm
      'Response Management' => 'Reakci kezels',
      'A response is default text to write faster answer (with default text) to customers.' => 'Egy reakci az alaprtelmezett szveg gyors vlaszokhoz (az alaprtelmezett szveggel) az gyfeleknek.',
      'Don\'t forget to add a new response a queue!' => 'Ne felejtsen el j reakcit hozzadni az gyhz!',
      'Next state' => 'Kvetkez llapot',
      'All Customer variables like defined in config option CustomerUser.' => 'Az sszes gyfl vltoz ahogyan az gyflFelhasznl opciknl lett belltva.',
      'The current ticket state is' => 'A jegy aktulis llapota',
      'Your email address is new' => 'Az n e-mail cme j',

      # Template: AdminRoleForm
      'Role Management' => 'Szably Kezels',
      'Create a role and put groups in it. Then add the role to the users.' => 'Hozzon ltre egy szablyt s tegyen bele csoportokat. Azutn adja a szablyt a felhasznlkhoz.',
      'It\'s useful for a lot of users and groups.' => 'Ez hasznos egy csom felhasznlnak s csoportnak',

      # Template: AdminRoleGroupChangeForm
      'Roles <-> Groups Management' => '',
      'move_into' => 'mozgat',
      'Permissions to move tickets into this group/queue.' => 'Jogosultsgok jegyek thelyezshez ebbe a csoportba/gybe.',
      'create' => 'kszt',
      'Permissions to create tickets in this group/queue.' => 'Jogosultsgok j jegyek ltrehozshoz ebben a csoportban/gyben.',
      'owner' => 'tulajdonos',
      'Permissions to change the ticket owner in this group/queue.' => 'Jogosultsgok a jegy tulajdonosnak megvltoztatshoz ebben a csoportban/gyben.',
      'priority' => 'srgssg',
      'Permissions to change the ticket priority in this group/queue.' => 'Jogosultgok a jegy prioritsnak megvltoztatshoz ebben a csoportban/gyben.',

      # Template: AdminRoleGroupForm
      'Role' => 'Szably',

      # Template: AdminRoleUserChangeForm
      'Roles <-> Users Management' => '',
      'Active' => 'Aktv',
      'Select the role:user relations.' => 'Vlassza ki a szably:felhasznl kapcsolatokat.',

      # Template: AdminRoleUserForm

      # Template: AdminSalutationForm
      'Salutation Management' => 'Megszlts kezels',
      'customer realname' => 'gyfl valdi nv',
      'for agent firstname' => 'gynk keresztnvhez',
      'for agent lastname' => 'gynk csaldinvhez',
      'for agent user id' => 'gynk felhasznl azonostjhoz',
      'for agent login' => 'gynk belpshez',

      # Template: AdminSelectBoxForm
      'Select Box' => 'SQL Parancsok',
      'SQL' => '',
      'Limit' => 'Korlt',
      'Select Box Result' => 'SQL Parancs eredmny',

      # Template: AdminSession
      'Session Management' => 'Folyamatkezels',
      'Sessions' => 'Eljrsok',
      'Uniq' => 'Egyedi',
      'kill all sessions' => 'Minden eljrs kilvse',
      'Session' => 'Eljrs',
      'kill session' => 'folyamat lelltsa',

      # Template: AdminSignatureForm
      'Signature Management' => 'Alrs kezels',

      # Template: AdminSMIMEForm
      'SMIME Management' => '',
      'Add Certificate' => 'Tanustvny Hozzadsa',
      'Add Private Key' => 'Titkos Kulcs Hozadsa',
      'Secret' => 'Titok',
      'Hash' => 'Kivonat',
      'In this way you can directly edit the certification and private keys in file system.' => 'ly mdon kzvetlenl szerkesztheti a fjlrendszeren trolt tanustvnyokat s titkos kulcsokat.',

      # Template: AdminStateForm
      'System State Management' => 'Rendszerllapot kezels',
      'State Type' => 'llapot tpus',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Figyeljen oda, hogy az Kernel/Config.pm fjlban is frisstse az alaprtelmezett llapotokat!',
      'See also' => 'Lsd mg',

      # Template: AdminSysConfig
      'SysConfig' => '',
      'Group selection' => '',
      'Show' => '',
      'Download Settings' => '',
      'Download all system config changes.' => '',
      'Load Settings' => '',
      'Subgroup' => '',
      'Elements' => '',

      # Template: AdminSysConfigEdit
      'Config Options' => '',
      'Default' => '',
      'Content' => '',
      'New' => 'j',
      'New Group' => '',
      'Group Ro' => '',
      'New Group Ro' => '',
      'NavBarName' => '',
      'Image' => '',
      'Prio' => '',
      'Block' => '',
      'NavBar' => '',
      'AccessKey' => '',

      # Template: AdminSystemAddressForm
      'System Email Addresses Management' => 'Rendszer email cmek kezelse',
      'Email' => '',
      'Realname' => 'Valdi nv',
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Az sszes bejv email ezzel az "Email"-el (Cmzett:) a kivlasztott gyhz lesz rendelve!',

      # Template: AdminUserForm
      'User Management' => 'Felhasznl kezels',
      'Firstname' => 'Keresztnv',
      'Lastname' => 'Csaldi nv',
      'User will be needed to handle tickets.' => 'Felhasznl kell a jegyek kezelshez.',
      'Don\'t forget to add a new user to groups and/or roles!' => '',

      # Template: AdminUserGroupChangeForm
      'Users <-> Groups Management' => '',

      # Template: AdminUserGroupForm

      # Template: AgentBook
      'Address Book' => 'Cmjegyzk',
      'Return to the compose screen' => 'Visszatrs a szerkesztkpernyre',
      'Discard all changes and return to the compose screen' => 'Minden vltoztats megsemmistse s visszatrs a szerkesztkpernyre',

      # Template: AgentCalendarSmall

      # Template: AgentCalendarSmallIcon

      # Template: AgentCustomerTableView

      # Template: AgentInfo
      'Info' => '',

      # Template: AgentLinkObject
      'Link Object' => '',
      'Select' => 'Kivlaszt',
      'Results' => 'Eredmnyek',
      'Total hits' => 'sszes tallat',
      'Site' => 'Gp',
      'Detail' => '',

      # Template: AgentLookup
      'Lookup' => 'Keres',

      # Template: AgentNavigationBar
      'Ticket selected for bulk action!' => 'Jegy kivlasztva csoportos mvelethez!',
      'You need min. one selected Ticket!' => 'Legalbb egy jegyet ki kell vlasztani!',

      # Template: AgentPreferencesForm

      # Template: AgentSpelling
      'Spell Checker' => 'Helyesrsellenrz',
      'spelling error(s)' => 'helyesrsi hiba(k)',
      'or' => 'vagy',
      'Apply these changes' => 'Mdostsok rvnyestse',

      # Template: AgentTicketBounce
      'A message should have a To: recipient!' => 'Egy zenethez kellene legyen cmzett!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Kell egy email cm (pl. customer@example.com) cmzettnek!',
      'Bounce ticket' => 'Jegy visszakldse',
      'Bounce to' => 'Visszaklds ide:',
      'Next ticket state' => 'A jegy kvetkez llapota',
      'Inform sender' => 'Kld tjkoztatsa',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Az n "<OTRS_TICKET>" szm jegyhez rendelt emailje visszakldsre kerlt a "<OTRS_BOUNCE_TO>" cmre. Vegye fel ezzel a cmmel a kapcsolatot tovbbi informcikrt.',
      'Send mail!' => 'Email kldse!',

      # Template: AgentTicketBulk
      'A message should have a subject!' => 'Egy zenetnek kell legyen trgya!',
      'Ticket Bulk Action' => 'Csoportos Jegy Mvelet',
      'Spell Check' => 'Helyesrsellenrzs',
      'Note type' => 'Jegyzet tpus',
      'Unlock Tickets' => '',

      # Template: AgentTicketClose
      'A message should have a body!' => 'Egy zenetnek kell legyen trzse!',
      'You need to account time!' => 'El kell szmolnia az idvel!',
      'Close ticket' => 'Jegy lezrsa',
      'Note Text' => 'Jegyzet szveg',
      'Close type' => 'Tpus lezrsa',
      'Time units' => 'Id egysgek',
      ' (work units)' => ' (munkaegysg)',

      # Template: AgentTicketCompose
      'A message must be spell checked!' => 'Az zenetnek helyesrsellenrzsen kell tmennie!',
      'Compose answer for ticket' => 'Vlaszads a jegyre',
      'Attach' => 'Csatol',
      'Pending Date' => 'Vrakozs dtuma',
      'for pending* states' => 'vrakoz* sttuszhoz',

      # Template: AgentTicketCustomer
      'Change customer of ticket' => 'A jegy gyfelnek megvltoztatsa',
      'Set customer user and customer id of a ticket' => 'A jegy gyfl felhasznljnak s gyfl azonostjnak megbelltsa',
      'Customer User' => 'gyfl felhasznl',
      'Search Customer' => 'gyfl keresse',
      'Customer Data' => 'gyfl adatok',
      'Customer history' => 'gyfl trtnet',
      'All customer tickets.' => 'sszes gyfl jegy.',

      # Template: AgentTicketCustomerMessage
      'Follow up' => 'Vlasz',

      # Template: AgentTicketEmail
      'Compose Email' => 'j Email rsa',
      'new ticket' => 'j jegy',
      'Clear To' => 'Tisztts Neki',
      'All Agents' => 'Minden gynk',
      'Termin1' => '',

      # Template: AgentTicketForward
      'Article type' => 'Cikk tpusa',

      # Template: AgentTicketFreeText
      'Change free text of ticket' => 'Szabad szveg vltoztatsa a jegyben',

      # Template: AgentTicketHistory
      'History of' => 'Trtnete ennek:',

      # Template: AgentTicketLocked
      'Ticket locked!' => 'Jegy lezrva!',
      'Ticket unlock!' => 'Jegy feloldva!',

      # Template: AgentTicketMailbox
      'Mailbox' => 'Postafik',
      'Tickets' => 'Jegyek',
      'All messages' => 'Minden zenet',
      'New messages' => 'j zenetek',
      'Pending messages' => 'Vrakoz zenetek',
      'Reminder messages' => 'Emlkeztet zenetek',
      'Reminder' => 'Emlkeztet',
      'Sort by' => 'Rendezs gy',
      'Order' => 'Sorrend',
      'up' => 'fel',
      'down' => 'le',

      # Template: AgentTicketMerge
      'You need to use a ticket number!' => '',
      'Ticket Merge' => '',
      'Merge to' => '',
      'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',

      # Template: AgentTicketMove
      'Queue ID' => 'gy azonost',
      'Move Ticket' => 'Jegy thelyezse',
      'Previous Owner' => 'Korbbi tulajdonos',

      # Template: AgentTicketNote
      'Add note to ticket' => 'Megjegyzs hozzadsa a jegyhez',
      'Inform Agent' => '',
      'Optional' => '',
      'Inform involved Agents' => '',

      # Template: AgentTicketOwner
      'Change owner of ticket' => 'Jegy tulajdonosnak mdostsa',
      'Message for new Owner' => 'zenet az j tulajdonosnak',

      # Template: AgentTicketPending
      'Set Pending' => 'Vrakozs bellts',
      'Pending type' => 'Vrakozs tpusa',
      'Pending date' => 'Vrakozsi dtum',

      # Template: AgentTicketPhone
      'Phone call' => 'Telefonhvs',

      # Template: AgentTicketPhoneNew
      'Clear From' => 'Felad trlse',

      # Template: AgentTicketPlain
      'Plain' => 'Egyszer',
      'TicketID' => 'Jegyazonost',
      'ArticleID' => 'Cikkazonost',

      # Template: AgentTicketPrint
      'Ticket-Info' => '',
      'Accounted time' => 'Elszmolt id',
      'Escalation in' => 'Eszkalci ebben',
      'Linked-Object' => '',
      'Parent-Object' => '',
      'Child-Object' => '',
      'by' => 'ltala:',

      # Template: AgentTicketPriority
      'Change priority of ticket' => 'Jegy srgssgnek mdostsa',

      # Template: AgentTicketQueue
      'Tickets shown' => 'Mutatott jegy',
      'Page' => 'Oldal',
      'Tickets available' => 'Elrhet jegy',
      'All tickets' => 'sszes jegy',
      'Queues' => 'gyek',
      'Ticket escalation!' => 'Jegy eszkalci!',

      # Template: AgentTicketQueueTicketView
      'Your own Ticket' => 'Az n sajt jegye',
      'Compose Follow up' => 'Vlasz rsa',
      'Compose Answer' => 'Vlasz rsa',
      'Contact customer' => 'Kapcsolatbalps az gyfllel',
      'Change queue' => 'gy vltoztats',

      # Template: AgentTicketQueueTicketViewLite

      # Template: AgentTicketSearch
      'Ticket Search' => 'Jegy keress',
      'Profile' => 'Profil',
      'Search-Template' => 'Keres sablon',
      'Created in Queue' => '',
      'Result Form' => 'Eredmny rlap',
      'Save Search-Profile as Template?' => 'Elmenti a keres profilt sablonknt?',
      'Yes, save it with name' => 'Igen, elmentve ezen a nven',
      'Customer history search' => 'Keress az gyfl trtnetben',
      'Customer history search (e. g. "ID342425").' => 'Keress az gyfl trtnetben (pl. "ID342425").',
      'No * possible!' => 'A "*" nem lehetsges!',

      # Template: AgentTicketSearchResult
      'Search Result' => 'Keressi eredmny',
      'Change search options' => 'Keressi belltsok mdostsa',

      # Template: AgentTicketSearchResultPrint
      '"}' => '}',

      # Template: AgentTicketSearchResultShort
      'sort upward' => 'rendezs felfel',
      'U' => 'A',
      'sort downward' => 'rendezs lefel',
      'D' => 'Z',

      # Template: AgentTicketStatusView
      'Ticket Status View' => '',
      'Open Tickets' => '',

      # Template: AgentTicketZoom
      'Split' => 'Feloszts',

      # Template: AgentTicketZoomStatus
      'Locked' => 'Zrolt',

      # Template: AgentWindowTabStart

      # Template: AgentWindowTabStop

      # Template: Copyright

      # Template: css

      # Template: customer-css

      # Template: CustomerAccept

      # Template: CustomerCalendarSmallIcon

      # Template: CustomerError
      'Traceback' => 'Visszakvets',

      # Template: CustomerFAQ
      'Print' => 'Nyomtat',
      'Keywords' => 'Kulcssz',
      'Symptom' => 'Jelensg',
      'Problem' => 'Problma',
      'Solution' => 'Megolds',
      'Modified' => 'Mdostva',
      'Last update' => 'Utols frissts',
      'FAQ System History' => 'GYIK rendszer trtnet',
      'modified' => '',
      'FAQ Search' => 'GYIK keress',
      'Fulltext' => 'Teljesszveg',
      'Keyword' => 'Kulcssz',
      'FAQ Search Result' => 'GYIK keress eredmny',
      'FAQ Overview' => 'GYIK ttekint',

      # Template: CustomerFooter
      'Powered by' => 'Ksztette',

      # Template: CustomerFooterSmall

      # Template: CustomerHeader

      # Template: CustomerHeaderSmall

      # Template: CustomerLogin
      'Login' => 'Belps',
      'Lost your password?' => 'Elfelejtette a jelszavt?',
      'Request new password' => 'j jelsz krse',
      'Create Account' => 'Azonost ltrehozsa',

      # Template: CustomerNavigationBar
      'Welcome %s' => 'dvzljk %s',

      # Template: CustomerPreferencesForm

      # Template: CustomerStatusView
      'of' => 'kitl',

      # Template: CustomerTicketMessage

      # Template: CustomerTicketMessageNew

      # Template: CustomerTicketSearch

      # Template: CustomerTicketSearchResultCSV

      # Template: CustomerTicketSearchResultPrint

      # Template: CustomerTicketSearchResultShort

      # Template: CustomerTicketZoom

      # Template: CustomerWarning

      # Template: Error
      'Click here to report a bug!' => 'Kattintson ide j hiba bejelentshez!',

      # Template: FAQ
      'Comment (internal)' => 'Megjegyzs (bels)',
      'A article should have a title!' => 'Egy cikknek kellene legyen cme!',
      'New FAQ Article' => '',
      'Do you really want to delete this Object?' => '',
      'System History' => '',

      # Template: FAQCategoryForm
      'Name is required!' => 'A nevet meg kell adni!',
      'FAQ Category' => 'GYIK kategria',

      # Template: FAQLanguageForm
      'FAQ Language' => 'GYIK nyelv',

      # Template: Footer
      'QueueView' => 'gyekNzet',
      'PhoneView' => 'TelefonNzet',
      'Top of Page' => 'Lap teteje',

      # Template: FooterSmall

      # Template: Header
      'Home' => 'Otthon',

      # Template: HeaderSmall

      # Template: Installer
      'Web-Installer' => 'Web-telept',
      'accept license' => 'Licenc elfogadsa',
      'don\'t accept license' => 'Licenc elutastsa',
      'Admin-User' => 'Admin-felhasznl',
      'Admin-Password' => '',
      'your MySQL DB should have a root password! Default is empty!' => 'Az n MySQL adatbzisnak kell legyen root jelszava! Az alaprtelmezett res!',
      'Database-User' => '',
      'default \'hot\'' => 'alaprtelmezett',
      'DB connect host' => '',
      'Database' => '',
      'Create' => '',
      'false' => '',
      'SystemID' => 'Rendszer azonost',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Azonosts a rendszerben. Minden jegyhez s minden http eljrs ezzel a sorszmmal indul)',
      'System FQDN' => 'Rendszer FQDN',
      '(Full qualified domain name of your system)' => '(Teljes ellenrztt domain nv a rendszerben)',
      'AdminEmail' => 'KezelEmail',
      '(Email of the system admin)' => '(E-Mail a rendszergazdnak)',
      'Organization' => 'Szervezet',
      'Log' => '',
      'LogModule' => 'Log modul',
      '(Used log backend)' => '(Hasznlt httr log)',
      'Logfile' => 'Log file',
      '(Logfile just needed for File-LogModule!)' => '(Logfile szksges a File-LogModul szmra!)',
      'Webfrontend' => 'Web-munkafellet',
      'Default Charset' => 'Alaprtelmezett karakterkszlet',
      'Use utf-8 it your database supports it!' => 'Hasznld utf-8-at az adatbzis tmogatsoknl!',
      'Default Language' => 'Alaprtelmezett nyelv',
      '(Used default language)' => '(A felhasznl alaprtelmezett nyelve)',
      'CheckMXRecord' => 'MX Rekord ellenrzs',
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Ellenrizd le az MX rekordot a hasznlt email cmben a vlasz rsakor!)',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Ahhoz, hogy az OTRS-t hasznlni tudja, a kvetkez parancsot kell begpelnie parancssorban (terminlban/hjjban) root-knt.',
      'Restart your webserver' => 'Indtsa jra a web-kiszolglt',
      'After doing so your OTRS is up and running.' => 'Ha ez ksz, az OTRS ksz s fut.',
      'Start page' => 'Start oldal',
      'Have a lot of fun!' => 'Sok sikert!',
      'Your OTRS Team' => 'Az n OTRS csapata',

      # Template: Login

      # Template: Motd

      # Template: NoPermission
      'No Permission' => 'Nincs jogosultsg',

      # Template: Notify
      'Important' => '',

      # Template: PrintFooter
      'URL' => '',

      # Template: PrintHeader
      'printed by' => 'Nyomtatta',

      # Template: Redirect

      # Template: SystemStats
      'Format' => '',

      # Template: Test
      'OTRS Test Page' => 'OTRS tesztoldal',
      'Counter' => '',

      # Template: Warning
      # Misc
      'OTRS DB connect host' => 'OTRS DB kapcsoldik a gazdhoz',
      'Create Database' => 'Adatbzis ltrehozsa',
      'DB Host' => 'DB Gazda',
      'Ticket Number Generator' => 'Jegy sorszm genertor',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Jegy azonosts. pl. \'Jegy#\', \'Hv#\' vagy \'Jegyem#\')',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'ly mdon kzvetlenl szerkesztheti a Kernel/Config.pm-ben belltott kulcskarikt.',
      'Ticket Hook' => 'Jegy pck',
      'Close!' => 'Lezr!',
      'TicketZoom' => 'JegyNagyts',
      'Don\'t forget to add a new user to groups!' => 'Ne felejtsen el j felhasznlt hozzadni a csoportokhoz!',
      'License' => 'Licenc',
      'CreateTicket' => 'Jegyltrehozs',
      'OTRS DB Name' => 'OTRS DB nv',
      'System Settings' => 'Rendszerbelltsok',
      'Hours' => 'ra',
      'Finished' => 'Befejezve',
      'Days' => 'Nap',
      'DB Admin User' => 'DB Admin felhasznl',
      'Change user <-> group settings' => 'A felhasznl <-> csoport belltsok megvltoztatsa',
      'DB Type' => 'DB tpusa',
      'next step' => 'kvetkez lps',
      'Admin-Email' => 'Kezel-Email',
      'Create new database' => 'j adatbzis ltrehozsa',
      'Delete old database' => 'Rgi adatbzis trlse',
      'OTRS DB User' => 'OTRS DB felhasznl',
      'Options ' => '',
      'OTRS DB Password' => 'OTRS DB jelsz',
      'DB Admin Password' => 'DB Admin jelsz',
      'Drop Database' => 'Adatbzis trlse',
      'Minutes' => 'Perc',
      '(Used ticket number format)' => '(Nyitott jegyek sorszmnak formtuma)',
      'FAQ History' => 'GYIK trtnet',
    };
    # $$STOP$$
}
# --
1;
