# --
# Kernel/Language/vi_VN.pm - provides de language translation
# Copyright (C) 2008 Nguyen Nguyet. Phuong <phuongnn at iwayvietnam dot com>
# --
# $Id: vi_VN.pm,v 1.1.2.2 2008/01/13 22:02:36 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::vi_VN;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.1.2.2 $) [1];

sub Data {
    my ( $Self, %Param ) = @_;

    # $$START$$
    # Last translation file sync: Tue May 29 15:05:19 2007

    # possible charsets
    $Self->{Charset} = [ 'viscii' ];

    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%T - %D.%M.%Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes'                 => 'C',
        'No'                  => 'Khng',
        'yes'                 => 'C',
        'no'                  => 'Khng',
        'Off'                 => 'Tt',
        'off'                 => 'tt',
        'On'                  => 'M',
        'on'                  => 'm',
        'top'                 => 'trn u',
        'end'                 => 'cui',
        'Done'                => ' xong',
        'Cancel'              => 'Hy',
        'Reset'               => 'Lm li',
        'last'                => 'Sau',
        'before'              => 'Tr߾c',
        'day'                 => 'ngy',
        'days'                => 'ngy',
        'day(s)'              => 'ngy',
        'hour'                => 'gi',
        'hours'               => 'gi',
        'hour(s)'             => 'gi',
        'minute'              => 'pht',
        'minutes'             => 'pht',
        'minute(s)'           => 'pht',
        'month'               => 'thng',
        'months'              => 'thng',
        'month(s)'            => 'thng',
        'week'                => 'tun',
        'week(s)'             => 'tun',
        'year'                => 'nm',
        'years'               => 'nm',
        'year(s)'             => 'nm',
        'second(s)'           => 'giy',
        'seconds'             => 'giy',
        'second'              => 'giy',
        'wrote'               => 'vit',
        'Message'             => 'Thng bo',
        'Error'               => 'Li',
        'Bug Report'          => 'Bo co li',
        'Attention'           => 'Ch ',
        'Warning'             => 'Cnh bo',
        'Module'              => 'M un',
        'Modulefile'          => 'File m un',
        'Subfunction'         => 'Chc nng con',
        'Line'                => 'Dng',
        'Example'             => 'V d',
        'Examples'            => 'Cc v d',
        'valid'               => 'Hp l',
        'invalid'             => 'Khng hp l',
        '* invalid'           => '* khng hp l',
        'invalid-temporarily' => 'tm thi khng hp l',
        ' 2 minutes'          => '2 pht',
        ' 5 minutes'          => '5 pht',
        ' 7 minutes'          => '7 pht',
        '10 minutes'          => '10 pht',
        '15 minutes'          => '15 pht',
        'Mr.'                 => 'ng',
        'Mrs.'                => 'B',
        'Next'                => 'Tip',
        'Back'                => 'Tr li',
        'Next...'             => 'Tip...',
        '...Back'             => '...Tr li',
        '-none-'              => 'khng',
        'none'                => 'khng',
        'none!'               => 'khng!',
        'none - answered'     => 'khng c tr li',
        'please do not edit!' => 'Xin ng chnh sa!',
        'AddLink'             => 'Thm lin kt',
        'Link'                => 'Lin kt',
        'Linked'              => ' lin kt',
        'Link (Normal)'       => 'Lin kt (Th߶ng)',
        'Link (Parent)'       => 'Lin kt (Cha)',
        'Link (Child)'        => 'Lin kt (Con)',
        'Normal'              => 'Th߶ng',
        'Parent'              => 'Cha',
        'Child'               => 'Con',
        'Hit'                 => 'Nhn chut',
        'Hits'                => 'Nhn chut',
        'Text'                => 'Vn bn',
        'Lite'                => 'Nh',
        'User'                => 'Ng߶i dng',
        'Username'            => 'Tn ng nhp',
        'Language'            => 'Ngn ng',
        'Languages'           => 'Cc ngn ng',
        'Password'            => 'Mt khu',
        'Salutation'          => 'Li cho',
        'Signature'           => 'Ch k',
        'Customer'            => 'Khch hng',
        'CustomerID'          => 'M khch hng',
        'CustomerIDs'         => 'M khch hng',
        'customer'            => 'khch hng',
        'agent'               => 'i l',
        'system'              => 'h thng',
        'Customer Info'       => 'Thng tin khch hng',
        'Customer Company'    => 'Cng ty khch hng',
        'Company'             => 'Cng ty',
        'go!'                 => 'tip tc!',
        'go'                  => 'tip tc',
        'All'                 => 'tt c',
        'all'                 => 'tt c',
        'Sorry'               => 'Xin li',
        'update!'             => 'cp nht!',
        'update'              => 'cp nht',
        'Update'              => 'Cp nht',
        'submit!'             => 'xc nhn!',
        'submit'              => 'xc nhn',
        'Submit'              => 'Xc nhn',
        'change!'             => 'thay i!',
        'Change'              => 'Thay i',
        'change'              => 'thay i',
        'click here'          => 'Nhn chut vo y',
        'Comment'             => 'Nhn xt',
        'Valid'               => 'Hp l',
        'Invalid Option!'     => 'La chn khng hp l!',
        'Invalid time!'       => 'Thi gian khng hp l!',
        'Invalid date!'       => 'Ngy thng khng hp l!',
        'Name'                => 'Tn',
        'Group'               => 'Nhm',
        'Description'         => 'M t',
        'description'         => 'm t',
        'Theme'               => 'Giao din',
        'Created'             => ' khi to',
        'Created by'          => 'Khi to bi',
        'Changed'             => ' thay i',
        'Changed by'          => 'Thay i bi',
        'Search'              => 'Tm kim',
        'and'                 => 'v',
        'between'             => 'gia',
        'Fulltext Search'     => 'Tm kim ton b vn bn',
        'Data'                => 'D liu',
        'Options'             => 'Cc ty chn',
        'Title'               => 'Tiu ',
        'Item'                => 'Mc',
        'Delete'              => 'Xa',
        'Edit'                => 'Sa',
        'View'                => 'Xem',
        'Number'              => 'S',
        'System'              => 'H thng',
        'Contact'             => 'Lin h',
        'Contacts'            => 'Lin h',
        'Export'              => 'Xut',
        'Up'                  => 'Trn',
        'Down'                => 'D߾i',
        'Add'                 => 'Thm',
        'Category'            => 'Phn loi',
        'Viewer'              => 'Trnh xem',
        'New message'         => 'Tin nhn mi',
        'New message!'        => 'Tin nhn mi!',
        'Please answer this ticket(s) to get back to the normal queue view!' =>
            'Hy tr li th ny  tr li phn xem cc hng i thng th߶ng!',
        'You got new message!'            => 'Bn c tin nhn mi!',
        'You have %s new message(s)!'     => 'Bn c %s tin nhn mi!',
        'You have %s reminder ticket(s)!' => 'Bn c %s th nhc cng vic!',
        'The recommended charset for your language is %s!' =>
            'B k t gi  cho ngn ng ca bn l %s!',
        'Passwords doesn\'t match! Please try it again!' =>
            'Cc mt khu khng khp nhau! Hy th li!',
        'Password is already in use! Please use an other password!' =>
            'Mt khu  tng c s dng! Hy s dng mt mt khu khc!',
        'Password is already used! Please use an other password!' =>
            'Mt khu  tng c s dng! Hy s dng mt mt khu khc!',
        'You need to activate %s first to use it!' =>
            '%s cn c kch hot ln u tin  s dng!',
        'No suggestions' => 'Khng c gi  no',
        'Word'           => 'T',
        'Ignore'         => 'B qua',
        'replace with'   => 'thay th bng',
        'There is no account with that login name.' =>
            'Khng c ti khon no vi tn truy cp nh th.',
        'Login failed! Your username or password was entered incorrectly.' =>
            'ng nhp tht bi! Tn truy cp hoc mt khu nhp khng chnh xc.',
        'Please contact your admin' => 'Hy lin h vi qun tr h thng ca bn',
        'Logout successful. Thank you for using OTRS!' =>
            'ng xut thnh cng! Cm n bn  s dng OTRS!',
        'Invalid SessionID!'  => 'M phin khng hp l!',
        'Feature not active!' => 'Tnh nng khng hot ng!',
        'Login is needed!'    => 'Cn ng nhp!',
        'Password is needed!' => 'Cn mt khu!',
        'License'             => 'Giy php',
        'Take this Customer'  => 'Chp nhn khch hng ny',
        'Take this User'      => 'Chp nhn ng߶i dng ny',
        'possible'            => 'c th',
        'reject'              => 't chi',
        'reverse'             => 'o ngc',
        'Facility'            => 'Tin ch',
        'Timeover'            => 'Ht thi gian',
        'Pending till'        => 'Treo ti khi',
        'Don\'t work with UserID 1 (System account)! Create new users!' =>
            'Khng lm vic vi m ng߶i dng 1 (ti khon h thng)! Hy to ng߶i dng mi!',
        'Dispatching by email To: field.' => 'Gi bng email ti: tr߶ng.',
        'Dispatching by selected Queue.'  => 'Gi bi hng i  chn.',
        'No entry found!'                 => 'Khng tm thy mc no!',
        'Session has timed out. Please log in again.' =>
            'Phin  b gin on. Xin hy ng nhp li.',
        'No Permission!'                         => 'Khng c quyn!',
        'To: (%s) replaced with database email!' => 'Ti: (%s) c thay th bi email c s d liu!',
        'Cc: (%s) added database email!'         => 'Cc: (%s) email c s d liu thm!',
        '(Click here to add)'                    => '(Nhn chut vo y  thm)',
        'Preview'                                => 'Xem tr߾c',
        'Package not correctly deployed! You should reinstall the Package again!' =>
            'Gi cha c trin khai chnh xc! Bn nn ci t li gi ln na!',
        'Added User "%s"'     => 'Ng߶i dng "%s"  c thm.',
        'Contract'            => 'Hp ng',
        'Online Customer: %s' => 'Khch hng trc tuyn: %s',
        'Online Agent: %s'    => 'i l trc tuyn: %s',
        'Calendar'            => 'Lch',
        'File'                => 'File',
        'Filename'            => 'Tn file',
        'Type'                => 'Loi',
        'Size'                => 'C',
        'Upload'              => 'Ti ln',
        'Directory'           => '߶ng dn',
        'Signed'              => ' k',
        'Sign'                => 'K',
        'Crypted'             => ' gn m',
        'Crypt'               => 'Gn m',
        'Office'              => 'Vn phng',
        'Phone'               => 'in thoi',
        'Fax'                 => 'Fax',
        'Mobile'              => 'Di ng',
        'Zip'                 => 'M vng',
        'City'                => 'Thnh ph',
        'Country'             => 'N߾c',
        'installed'           => ' ci t',
        'uninstalled'         => ' g ci t',
        'Security Note: You should activate %s because application is already running!' =>
            'Lu  bo mt: Bn nn kch hot %s bi ng dng  hot ng!',
        'Unable to parse Online Repository index document!' =>
            'Khng th phn tch ti liu ch mc Kho cha trc tuyn!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!'
            => 'Khng c gi no cho cu trc yu cu trong Kho cha trc tuyn ny, nhng c cc gi cho nhng cu trc khc.',
        'No Packages or no new Packages in selected Online Repository!' =>
            'Khng c gi no hoc khng c gi mi no trong Kho cha trc tuyn  chn!',
        'printed at' => 'c in ti',

        # Template: AAAMonth
        'Jan'       => 'Thng 1',
        'Feb'       => 'Thng 2',
        'Mar'       => 'Thng 3',
        'Apr'       => 'Thng 4',
        'May'       => 'Thng 5',
        'Jun'       => 'Thng 6',
        'Jul'       => 'Thng 7',
        'Aug'       => 'Thng 8',
        'Sep'       => 'Thng 9',
        'Oct'       => 'Thng 10',
        'Nov'       => 'Thng 11',
        'Dec'       => 'Thng 12',
        'January'   => 'Thng Mt',
        'February'  => 'Thng Hai',
        'March'     => 'Thng Ba',
        'April'     => 'Thng T',
        'June'      => 'Thng Su',
        'July'      => 'Thng By',
        'August'    => 'Thng Tm',
        'September' => 'Thng Chn',
        'October'   => 'Thng M߶i',
        'November'  => 'Thng M߶i mt',
        'December'  => 'Thng M߶i hai',

        # Template: AAANavBar
        'Admin-Area'                  => 'Khu vc dnh cho qun tr',
        'Agent-Area'                  => 'Khu vc dnh cho i l',
        'Ticket-Area'                 => 'Khu vc th',
        'Logout'                      => 'ng xut',
        'Agent Preferences'           => 'Giao din i l',
        'Preferences'                 => 'Giao din',
        'Agent Mailbox'               => 'Hp th dnh cho i l',
        'Stats'                       => 'Thng k',
        'Stats-Area'                  => 'Khu vc dnh cho thng k',
        'Admin'                       => 'Qun tr',
        'Customer Users'              => 'Ng߶i dng khch hng',
        'Customer Users <-> Groups'   => 'Ng߶i dng khch hng <-> Nhm',
        'Customer Users <-> Services' => 'Ng߶i dng khch hng <-> Dch v',
        'Users <-> Groups'            => 'Ng߶i dng <-> Nhm',
        'Roles'                       => 'Vai tr',
        'Roles <-> Users'             => 'Vai tr <-> Ng߶i dng',
        'Roles <-> Groups'            => 'Vai tr <-> Nhm',
        'Salutations'                 => 'Li cho',
        'Signatures'                  => 'Ch k',
        'Email Addresses'             => 'иa ch email',
        'Notifications'               => 'Thng bo',
        'Category Tree'               => 'Cy th mc',
        'Admin Notification'          => 'Thng bo qun tr',

        # Template: AAAPreferences
        'Preferences updated successfully!'   => 'Giao din  c cp nht thnh cng!',
        'Mail Management'                     => 'Qun tr mail',
        'Frontend'                            => 'Mt ngoi',
        'Other Options'                       => 'Cc ty chn khc',
        'Change Password'                     => 'бi mt khu',
        'New password'                        => 'Mt khu mi',
        'New password again'                  => 'Mt khu mi ln na',
        'Select your QueueView refresh time.' => 'Hy chn thi gian lm mi hng i ca bn.',
        'Select your frontend language.'      => 'Hy chn ngn ng mt ngoi ca bn.',
        'Select your frontend Charset.'       => 'Hy chn b m k t mt ngoi ca bn.',
        'Select your frontend Theme.'         => 'Hy chn giao din mt ngoi ca bn.',
        'Select your frontend QueueView.'     => 'Hy chn cch xem hng i mt ngoi ca bn.',
        'Spelling Dictionary'                 => 'T in chnh t',
        'Select your default spelling dictionary.' => 'Hy chn t in chnh t mc nh ca bn.',
        'Max. shown Tickets a page in Overview.' =>
            'S th hin th ti a trn mt trang trong phn Tng quan.',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' =>
            'Khng th cp nht mt khu, cc mt khu khng khp nhau! Hy th li ln na!',
        'Can\'t update password, invalid characters!' =>
            'Khng th cp nht mt khu, cc k t khng hp l.',
        'Can\'t update password, need min. 8 characters!' =>
            'Khng th cp nht mt khu, mt khu phi t nht 8 k t.',
        'Can\'t update password, need 2 lower and 2 upper characters!' =>
            'Khng th cp nht mt khu, cn c 2 k t d߾i v 2 k t trn.',
        'Can\'t update password, need min. 1 digit!' =>
            'Khng th cp nht mt khu, mt khu cn c t nht 1 con s!',
        'Can\'t update password, need min. 2 characters!' =>
            'Khng th cp nht mt khu, mt khu cn c t nht 2 k t!',

        # Template: AAAStats
        'Stat'                                 => 'Thng k',
        'Please fill out the required fields!' => 'Hy nhp vo cc tr߶ng bt buc!',
        'Please select a file!'                => 'Hy chn 1 file!',
        'Please select an object!'             => 'Hy chn 1 i tng!',
        'Please select a graph size!'          => 'Hy chn 1 c biu !',
        'Please select one element for the X-axis!' =>
            'Hy chn 1 thnh t cho trc X!',
        'You have to select two or more attributes from the select field!' =>
            'Bn phi chn 2 hay nhiu thuc tnh t tr߶ng  chn!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!'
            => 'Hy chn duy nht 1 thnh t hoc tt nt \' sa\'ni tr߶ng  chn c nh du!',
        'If you use a checkbox you have to select some attributes of the select field!' =>
            'Nu bn s dng mt hp chn bn phi chn mt s thuc tnh ca tr߶ng  chn!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' =>
            'Hy chn mt gi tr trong tr߶ng nhp  chn hoc tt hp chn \' sa\'!',
        'The selected end time is before the start time!' =>
            'Thi gian kt thc  chn tr߾c thi gian bt u!',
        'You have to select one or more attributes from the select field!' =>
            'Bn phi chn 1 hoc nhiu thuc tnh t tr߶ng  chn!',
        'The selected Date isn\'t valid!' => 'Ngy  chn khng hp l!',
        'Please select only one or two elements via the checkbox!' =>
            'Hy chn ch 1 hoc 2 thnh t thng qua hp chn!',
        'If you use a time scale element you can only select one element!' =>
            'Nu bn s dng thnh t khung thi gian bn c th ch chn 1 thnh t!',
        'You have an error in your time selection!' =>
            'C 1 li trong qu trnh chn thi gian ca bn!',
        'Your reporting time interval is too small, please use a larger time scale!' =>
            'Khong thi gian bo co qu nh, hy s dng khung thi gian ln hn!',
        'The selected start time is before the allowed start time!' =>
            'Thi gian bt u  chn tr߾c thi gian bt u cho php!',
        'The selected end time is after the allowed end time!' =>
            'Thi gian kt thc  chn sau thi gian kt thc cho php!',
        'The selected time period is larger than the allowed time period!' =>
            'Khong thi gian  chn ln hn khong thi gian cho php!',
        'Common Specification'   => 'Уc t chung',
        'Xaxis'                  => 'Trc X',
        'Value Series'           => 'Chui gi tr',
        'Restrictions'           => 'Cc hn ch',
        'graph-lines'            => 'Biu  ߶ng k',
        'graph-bars'             => 'Biu  thanh',
        'graph-hbars'            => 'Biu  thanh ngang',
        'graph-points'           => 'Biu  chm',
        'graph-lines-points'     => 'Biu  ߶ng k chm',
        'graph-area'             => 'Biu  vng',
        'graph-pie'              => 'Biu  trn',
        'extended'               => 'm rng',
        'Agent/Owner'            => 'i l/Ph trch',
        'Created by Agent/Owner' => 'c to bi i l/Ph trch',
        'Created Priority'       => 'u tin khi to',
        'Created State'          => 'Trng thi khi to',
        'Create Time'            => 'Thi gian khi to',
        'CustomerUserLogin'      => 'Ng߶i dng khch hng ng nhp',
        'Close Time'             => 'Thigian ng',
        'CSV'                    => 'CSV',

        # Template: AAATicket
        'Lock'               => 'Kha',
        'Unlock'             => 'M kha',
        'History'            => 'Lch s',
        'Zoom'               => 'Phng i',
        'Age'                => 'Tui',
        'Bounce'             => 'B',
        'Forward'            => 'Chuyn tip',
        'From'               => 'T',
        'To'                 => 'Ti',
        'Cc'                 => 'Cc',
        'Bcc'                => 'Bcc',
        'Subject'            => 'Tiu ',
        'Move'               => 'Chuyn',
        'Queue'              => 'Hng i',
        'Priority'           => 'u tin',
        'State'              => 'Trng thi',
        'Compose'            => 'To',
        'Pending'            => 'ang treo',
        'Owner'              => 'Ph trch',
        'Owner Update'       => 'Cp nht ph trch',
        'Responsible'        => 'Chu trch nhim',
        'Responsible Update' => 'Cp nht trch nhim',
        'Sender'             => 'Ng߶i gi',
        'Article'            => 'Bi vit',
        'Ticket'             => 'Th',
        'Createtime'         => 'Thi gian khi to',
        'plain'              => 'gc',
        'Email'              => 'E-Mail',
        'email'              => 'E-Mail',
        'Close'              => 'ng',
        'Action'             => 'Hnh ng',
        'Attachment'         => 'nh km',
        'Attachments'        => 'nh km',
        'This message was written in a character set other than your own.' =>
            'Tin nhn ny  c vit bng b k t khc vi ca bn.',
        'If it is not displayed correctly,' => 'Nu n khng hin th chnh xc,',
        'This is a'                         => 'y l mt',
        'to open it in a new window.' => 'm trong ca s mi',
        'This is a HTML email. Click here to show it.' =>
            'y l mt email HTML. Nhn chut vo y  xem.',
        'Free Fields'          => 'Cc tr߶ng t do',
        'Merge'                => 'Trn',
        'merged'               => ' trn',
        'closed successful'    => 'ng thnh cng',
        'closed unsuccessful'  => 'ng khng thnh cng',
        'new'                  => 'mi',
        'open'                 => 'm',
        'closed'               => 'ng',
        'removed'              => 'g b',
        'pending reminder'     => 'ang treo nhc nh',
        'pending auto'         => 'ang treo t ng',
        'pending auto close+'  => 'ang treo t ng ng+',
        'pending auto close-'  => 'ang treo t ng ng-',
        'email-external'       => 'E-mail bn ngoi',
        'email-internal'       => 'E-mail ni b',
        'note-external'        => 'lu  bn ngoi',
        'note-internal'        => 'lu  ni b',
        'note-report'          => 'lu  bo co',
        'phone'                => 'in thoi',
        'sms'                  => 'tin nhn sms',
        'webrequest'           => 'yu cu web',
        'lock'                 => 'kha',
        'unlock'               => 'khng kha',
        'very low'             => 'rt chm',
        'low'                  => 'chm',
        'normal'               => 'bnh th߶ng',
        'high'                 => 'cao',
        'very high'            => 'rt cao',
        '1 very low'           => '1 rt chm',
        '2 low'                => '2 chm',
        '3 normal'             => '3 bnh th߶ng',
        '4 high'               => '4 cao',
        '5 very high'          => '5 rt cao',
        'Ticket "%s" created!' => 'Th "%s"  c to!',
        'Ticket Number'        => 'S th',
        'Ticket Object'        => 'Яi tng th',
        'No such Ticket Number "%s"! Can\'t link it!' =>
            'Khng c th no c s "%s" nh vy! Khng th lin kt ti !',
        'Don\'t show closed Tickets'         => 'Khng hin th cc th  ng',
        'Show closed Tickets'                => 'Hin th cc th  ng',
        'New Article'                        => 'Bi vit mi',
        'Email-Ticket'                       => 'Th e-mail',
        'Create new Email Ticket'            => 'To th e-mail mi',
        'Phone-Ticket'                       => 'Th in thoi',
        'Search Tickets'                     => 'Tm kim th',
        'Edit Customer Users'                => 'Sa ng߶i dng khch hng',
        'Bulk-Action'                        => 'Hnh ng hng lot',
        'Bulk Actions on Tickets'            => 'Hng lot hnh ng trn cc th',
        'Send Email and create a new Ticket' => 'Gi e-mail v to 1 th mi',
        'Create new Email Ticket and send this out (Outbound)' =>
            'To 1 th e-mail mi v gi ra ngoi',
        'Create new Phone Ticket (Inbound)' => 'To th in thoi mi (vo trong)',
        'Overview of all open Tickets'      => 'Tng quan tt c cc th m',
        'Locked Tickets'                    => 'Cc th  kha',
        'Watched Tickets'                   => 'Cc th  xem',
        'Watched'                           => ' xem',
        'Subscribe'                         => 'Xc nhn',
        'Unsubscribe'                       => 'Khng xc nhn',
        'Lock it to work on it!'            => 'Kha  lm vic trn !',
        'Unlock to give it back to the queue!'  => 'M kha  a tr v hng i!',
        'Shows the ticket history!'             => 'Xem lch s th!',
        'Print this ticket!'                    => 'In th ny!',
        'Change the ticket priority!'           => 'Thay i u tin th',
        'Change the ticket free fields!'        => 'Thay i cc tr߶ng t do ca th',
        'Link this ticket to an other objects!' => 'Lin kt th ny vi cc i tng khc!',
        'Change the ticket owner!'              => 'Thay i ph trch th!',
        'Change the ticket customer!'           => 'Thay i khch hng th!',
        'Add a note to this ticket!'            => 'Thm lu  i vi th ny!',
        'Merge this ticket!'                    => 'Trn th ny!',
        'Set this ticket to pending!'           => 'Thit t treo th ny!',
        'Close this ticket!'                    => 'ng th ny!',
        'Look into a ticket!'                   => 'Xem xt mt th!',
        'Delete this ticket!'                   => 'Xa th ny!',
        'Mark as Spam!'                         => 'nh du l th rc!',
        'My Queues'                             => 'Hng i ca ti',
        'Shown Tickets'                         => 'Cc th c hin th',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' =>
            'E-mail ca bn vi s th "<OTRS_TICKET>" c trn thnh "<OTRS_MERGE_TO_TICKET>"!',
        'Ticket %s: first response time is over (%s)!' =>
            'Th %s: ln phn hi u tin qu (%s)!',
        'Ticket %s: first response time will be over in %s!' =>
            'Th %s: ln phn hi u tin s qu %s!',
        'Ticket %s: update time is over (%s)!' =>
            'Th %s: ln cp nht qu (%s)!',
        'Ticket %s: update time will be over in %s!' =>
            'Th %s: ln cp nht s qu %s!',
        'Ticket %s: solution time is over (%s)!' => '',
        'Ticket %s: solution time will be over in %s!' =>
            'Th %s: ln gii php s qu %s!',
        'There are more escalated tickets!' => 'C nhiu th hn!',
        'New ticket notification'           => 'Thng bo th mi',
        'Send me a notification if there is a new ticket in "My Queues".' =>
            'Gi thng bo cho ti nu c th mi trong "Hng i ca ti".',
        'Follow up notification' => 'Theo di thng bo',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.'
            => 'Gi thng bo cho ti nu c khch hng gi theo di v ti l ph trch ca th ny.',
        'Ticket lock timeout notification' => 'Thng bo thi gian ch kha th',
        'Send me a notification if a ticket is unlocked by the system.' =>
            'Gi thng bo cho ti nu mt th cha c kha bi h thng.',
        'Move notification' => 'Thng bo chuyn',
        'Send me a notification if a ticket is moved into one of "My Queues".' =>
            'Gi thng bo cho ti nu mt th c chuyn vo trong "Hng i ca ti".',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.'
            => 'La chn hng i ca bn ca cc hng i a thch. Bn cng s c thng bo v cc hng i  thng qua email nu c th',
        'QueueView refresh time'  => 'Thi gian lm mi Hng i',
        'Screen after new ticket' => 'Mn hnh sau th mi',
        'Select your screen after creating a new ticket.' =>
            'Chn mn hnh ca bn sau khi to mt th mi.',
        'Closed Tickets'       => 'Cc th  ng',
        'Show closed tickets.' => 'Hin th cc th  ng.',
        'Max. shown Tickets a page in QueueView.' =>
            'Cc th hin th ti a trn mi trang trong Hng i.',
        'CompanyTickets'            => 'Th cng ty',
        'MyTickets'                 => 'Th ca ti',
        'New Ticket'                => 'Th mi',
        'Create new Ticket'         => 'To th mi',
        'Customer called'           => 'Khch hng c gi',
        'phone call'                => 'cuc gi',
        'Responses'                 => 'Cc tr li',
        'Responses <-> Queue'       => 'Cc tr li <-> Hng i',
        'Auto Responses'            => 'Cc tr li t ng',
        'Auto Responses <-> Queue'  => 'Cc tr li t ng <-> Hng i',
        'Attachments <-> Responses' => 'Cc nh km <-> Cc tr li',
        'History::Move'             => 'Lch s::Chuyn.',
        'History::TypeUpdate'       => 'Lch s::Cp nht loi.',
        'History::ServiceUpdate'    => 'Lch s::Cp nht dch v.',
        'History::SLAUpdate'        => 'Lch s::Cp nht SLA "%s" (ID=%s).',
        'History::NewTicket'        => 'Lch s::Th mi [%s] (Q=%s;P=%s;S=%s).',
        'History::FollowUp'         => 'Lch s::Theo di',
        'History::SendAutoReject'   => 'Lch s::Gi t chi t ng.',
        'History::SendAutoReply'    => 'Lch s::Gi phn hi t ng.',
        'History::SendAutoFollowUp' => 'Lch s::Gi theo di t ng.',
        'History::Forward'          => 'Lch s::Chuyn tip.',
        'History::Bounce'           => 'Lch s::T b',
        'History::SendAnswer'       => 'Lch s::Gi tr li',
        'History::SendAgentNotification'    => 'Lch s::Gi thng bo i l',
        'History::SendCustomerNotification' => 'Lch s::Gi thng bo khch hng',
        'History::EmailAgent'               => 'Lch s::Email i l',
        'History::EmailCustomer'            => 'Lch s::Email khch hng',
        'History::PhoneCallAgent'           => 'Lch s::Cuc gi i l',
        'History::PhoneCallCustomer'        => 'Lch s::Cuc gi khch hng',
        'History::AddNote'                  => 'Lch s::Thm lu ',
        'History::Lock'                     => 'Lch s::Kha',
        'History::Unlock'                   => 'Lch s::M kha',
        'History::TimeAccounting' => 'Lch s::Gii thch thi gian',
        'History::Remove'         => 'Lch s::G b',
        'History::CustomerUpdate' => 'Lch s::Cp nht khch hng',
        'History::PriorityUpdate' => 'Lch s::Cp nht u tin',
        'History::OwnerUpdate'    => 'Lch s::Cp nht ph trch',
        'History::LoopProtection' => 'Lch s::Bo v vng lp',
        'History::Misc'           => 'Lch s::Linh tinh',
        'History::SetPendingTime' => 'Lch s::Уt thi gian treo',
        'History::StateUpdate'    => 'Lch s::Cp nht trng thi',
        'History::TicketFreeTextUpdate' => 'Lch s::Cp nht th',
        'History::WebRequestCustomer'   => 'Lch s::Khch hng yu cu web',
        'History::TicketLinkAdd'        => 'Lch s::Thm lin kt th',
        'History::TicketLinkDelete'     => 'Lch s::Xa lin kt th',

        # Template: AAAWeekDay
        'Sun' => 'Ch nht',
        'Mon' => 'Th hai',
        'Tue' => 'Th ba',
        'Wed' => 'Th t',
        'Thu' => 'Th nm',
        'Fri' => 'Th su',
        'Sat' => 'Th by',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Qun tr nh km',

        # Template: AdminAutoResponseForm
        'Auto Response Management'                      => 'Qun tr phn hi t ng',
        'Response'                                      => 'Phn hi',
        'Auto Response From'                            => 'Phn hi t ng t',
        'Note'                                          => 'Lu ',
        'Useable options'                               => 'Cc ty chn c th s dng',
        'To get the first 20 character of the subject.' => 'Ly 20 k t u tin ca tiu ',
        'To get the first 5 lines of the email.'        => 'Ly 5 dng u tin ca email',
        'To get the realname of the sender (if given).' =>
            'Ly tn thc ca ng߶i gi (nu  cho)',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).'
            => 'Ly thuc tnh bi vit (v d: (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' =>
            'Cc ty chn ca d liu ng߶i dng khch hng hin ti (v d: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' =>
            'Cc ty chn ca ph trch th (v d: <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' =>
            'Cc ty chn trch nhim th (v d:<OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).'
            => 'Cc ty chn ca ng߶i dng khch hng yu cu hnh ng ny (v d: <OTRS_CURRENT_UserFirstname).',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).'
            => 'Cc ty chn ca d liu th (v d: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' =>
            'Ty chn cu hnh (v d: <OTRS_CONFIG_HttpType).',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Qun tr cng ty khch hng',
        'Add Customer Company'        => 'Thm cng ty khch hng',
        'Add a new Customer Company.' => 'Thm 1 cng ty khch hng mi',
        'List'                        => 'Danh sch',
        'This values are required.'   => 'Gi tr ny c yu cu',
        'This values are read only.'  => 'Gi tr ny ch c',

        # Template: AdminCustomerUserForm
        'Customer User Management' => 'Qun tr ng߶i dng khch hng',
        'Search for'               => 'Tm kim cho',
        'Add Customer User'        => 'Thm ng߶i dng khch hng',
        'Source'                   => 'Ngun',
        'Create'                   => 'To',
        'Customer user will be needed to have a customer history and to login via customer panel.'
            => 'Ng߶i dng khch hng s cn c mt lch s khch hng v ng nhp thng qua bng iu khin khch hng',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Ng߶i dng khch hng <-> Qun tr nhm',
        'Change %s settings'                   => 'Thay i %s thit t',
        'Select the user:group permissions.'   => 'La chn ng߶i dng: cc quyn ca nhm.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).'
            => 'Nu khng chn ci g th s khng c quyn no trong nhm ny (cc th s khng sn sng s dng i vi ng߶i dng).',
        'Permission' => 'Quyn',
        'ro'         => 'Ch c',
        'Read only access to the ticket in this group/queue.' =>
            'Quyn ch c truy cp vo th trong nhm/hng i ny.',
        'rw' => 'c v ghi',
        'Full read and write access to the tickets in this group/queue.' =>
            'Quyn c v ghi truy cp vo th trong nhm/hng i ny.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserServiceChangeForm
        'Customer Users <-> Services Management' => 'Ng߶i dng khch hng <-> Qun tr dch v',
        'Select the customeruser:service relations.' =>
            'Chn mi quan h ng߶i dng khch hng:dch v.',
        'Allocate services to CustomerUser' => 'Phn phi dch v ti ng߶i dng khch hng',
        'Allocate CustomerUser to service'  => 'Phn phi ng߶i dng khch hng ti dch v',

        # Template: AdminCustomerUserServiceForm
        'Edit default services.' => 'Sa dch v mc nh.',

        # Template: AdminEmail
        'Message sent to' => 'Tin nhn c gi ti',
        'Recipents'       => 'Ng߶i nhn',
        'Body'            => 'Ni dung',
        'Send'            => 'Gi',

        # Template: AdminGenericAgent
        'GenericAgent'  => 'i l c c im chung',
        'Job-List'      => 'Danh sch cng vic',
        'Last run'      => 'Ln vn hnh tr߾c',
        'Run Now!'      => 'Vn hnh ngay!',
        'x'             => 'x',
        'Save Job as?'  => 'Lu cng vic?',
        'Is Job Valid?' => 'Cng vic c hp l?',
        'Is Job Valid'  => 'Cng vic c hp l',
        'Schedule'      => 'K hoch',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' =>
            'Tm kim trong bi vit (v d: "Mar*in" hoc "Baue*")',
        '(e. g. 10*5155 or 105658*)'          => 'v d: 10*5144 hoc 105658*',
        '(e. g. 234321)'                      => 'v d: 234321',
        'Customer User Login'                 => 'ng nhp ng߶i dng khch hng',
        '(e. g. U5150)'                       => 'v d: U5150',
        'Agent'                               => 'i l',
        'Ticket Lock'                         => 'Kha th',
        'TicketFreeFields'                    => 'Cc tr߶ng khng th',
        'Create Times'                        => 'Cc ln khi to',
        'No create time settings.'            => 'Khng c thit t ln khi to',
        'Ticket created'                      => 'Th  to',
        'Ticket created between'              => 'Th  to gia',
        'Pending Times'                       => 'Cc ln treo',
        'No pending time settings.'           => 'Khng c thit t ln treo',
        'Ticket pending time reached'         => 'Ln treo th  t ti',
        'Ticket pending time reached between' => 'Ln treo th  t ti gia',
        'New Priority'                        => 'u tin mi',
        'New Queue'                           => 'Hng i mi',
        'New State'                           => 'Trng thi mi',
        'New Agent'                           => 'i l mi',
        'New Owner'                           => 'Ph trch mi',
        'New Customer'                        => 'Khch hng mi',
        'New Ticket Lock'                     => 'Kha th mi',
        'CustomerUser'                        => 'Ng߶i dng khch hng',
        'New TicketFreeFields'                => 'Cc tr߶ng khng th mi',
        'Add Note'                            => 'Thm lu ',
        'CMD'                                 => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' =>
            'Lnh ny s c chy. ARG[0] s l s th. ARG[1] l m th.',
        'Delete tickets' => 'Xa th',
        'Warning! This tickets will be removed from the database! This tickets are lost!' =>
            'Lu ! Cc th ny s b g b khi c s d liu! Cc th ny s b mt!',
        'Send Notification'     => 'Gi thng bo',
        'Param 1'               => 'Tham s 1',
        'Param 2'               => 'Tham s 2',
        'Param 3'               => 'Tham s 3',
        'Param 4'               => 'Tham s 4',
        'Param 5'               => 'Tham s 5',
        'Param 6'               => 'Tham s 6',
        'Send no notifications' => 'Khng gi thng bo no',
        'Yes means, send no agent and customer notifications on changes.' =>
            'C ngha l, khng gi thng bo i l v khch hng no v cc thay i.',
        'No means, send agent and customer notifications on changes.' =>
            'Khng ngha l, gi thng bo i l v khch hng no v cc thay i.',
        'Save' => 'Lu',
        '%s Tickets affected! Do you really want to use this job?' =>
            '%s th b nh h߷ng! Bn c thc s mun dng cng vic ny?',

        # Template: AdminGroupForm
        'Group Management' => 'Qun tr nhm',
        'Add Group'        => 'Thm nhm',
        'Add a new Group.' => 'Thm 1 nhm mi.',
        'The admin group is to get in the admin area and the stats group to get stats area.' =>
            'Nhm qun tr ly trong khu vc qun tr v nhm thng k ly trong khu vc thng k.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).'
            => 'To cc nhm mi  iu khin quyn truy cp cho cc nhm i l khc nhau (v d: b phn mua hng, b phn h tr, b phn kinh doanh,...).',
        'It\'s useful for ASP solutions.' => 'N hu ch cho gii php ASP.',

        # Template: AdminLog
        'System Log' => 'Bn ghi h thng',
        'Time'       => 'Thi giab',

        # Template: AdminNavigationBar
        'Users'  => 'Ng߶i dng',
        'Groups' => 'Nhm',
        'Misc'   => 'Linh tinh',

        # Template: AdminNotificationForm
        'Notification Management' => 'Qun tr thng bo',
        'Notification'            => 'Thng bo',
        'Notifications are sent to an agent or a customer.' =>
            'Cc thng bo  c gi ti 1 i l hoc khch hng.',

        # Template: AdminPackageManager
        'Package Manager' => 'Qun tr gi',
        'Uninstall'       => 'G ci t',
        'Version'         => 'Phin bn',
        'Do you really want to uninstall this package?' =>
            'Bn c thc s mun g ci t gi ny?',
        'Reinstall' => 'Ci li',
        'Do you really want to reinstall this package (all manual changes get lost)?' =>
            'Bn c thc s mun ci li t gi ny (tt c nhng thay i b mt)?',
        'Continue'                    => 'Tip tc',
        'Install'                     => 'Ci t',
        'Package'                     => 'Gi',
        'Online Repository'           => 'Kho trc tuyn',
        'Vendor'                      => 'Ng߶i bn',
        'Upgrade'                     => 'Nng cp',
        'Local Repository'            => 'Kho cc b',
        'Status'                      => 'Trng thi',
        'Overview'                    => 'Tng quan',
        'Download'                    => 'Ti xung',
        'Rebuild'                     => 'Dng li',
        'ChangeLog'                   => 'Bn ghi thay i',
        'Date'                        => 'D liu',
        'Filelist'                    => 'Danh sch file',
        'Download file from package!' => 'Ti file t gi xung!',
        'Required'                    => 'c yu cu',
        'PrimaryKey'                  => 'Kha chnh',
        'AutoIncrement'               => 'Gia tng t ng',
        'SQL'                         => 'SQL',
        'Diff'                        => 'Khc nhau',

        # Template: AdminPerformanceLog
        'Performance Log'          => 'Bn ghi thc thi',
        'This feature is enabled!' => 'Tnh nng ny  c kch hot!',
        'Just use this feature if you want to log each request.' =>
            'Ch s dng tnh nng ny nu bn mun ghi mi yu cu.',
        'Of couse this feature will take some system performance it self!' =>
            'Tt nhin tnh nng ny s t thc thi h thng.',
        'Disable it here!'          => 'V hiu ha ti y!',
        'This feature is disabled!' => 'Tnh nng ny  b v hiu ha!',
        'Enable it here!'           => 'Kch hot ti y!',
        'Logfile too large!'        => 'File bn ghi qu ln!',
        'Logfile too large, you need to reset it!' =>
            'File bn ghi qu ln, bn cn thit t li!',
        'Range'            => 'Di',
        'Interface'        => 'Giao din',
        'Requests'         => 'Yu cu',
        'Min Response'     => 'Phn hi ti thiu',
        'Max Response'     => 'Phn hi ti a',
        'Average Response' => 'Phn hi trung bnh',

        # Template: AdminPGPForm
        'PGP Management' => 'Qun tr PGP',
        'Result'         => 'Kt qu',
        'Identifier'     => 'T nh danh',
        'Bit'            => 'Bit',
        'Key'            => 'Kha',
        'Fingerprint'    => 'Du tay',
        'Expires'        => 'Ht hn',
        'In this way you can directly edit the keyring configured in SysConfig.' =>
            'Theo cch ny bn c th sa trc tip cu hnh kha trong Cu hnh h thng.',

        # Template: AdminPOP3
        'POP3 Account Management' => 'Qun tr ti khon POP3',
        'Host'                    => 'My ch host',
        'Trusted'                 => 'Tin cy',
        'Dispatching'             => 'ang gi',
        'All incoming emails with one account will be dispatched in the selected queue!' =>
            'Tt c cc email n vi 1 ti khon s c gi vo trong hng i  chn!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.'
            => 'Nu ti khon ca bn l ng tin cy, u trang X-OTRS  c ti thi gian n (cho mc  u tin, ...) s c s dng! B lc PostMaster cng s c dng.',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Qun tr b lc PostMaster',
        'Filtername'                   => 'Lc tn',
        'Match'                        => 'Kt hp',
        'Header'                       => 'Хu trang',
        'Value'                        => 'Gi tr',
        'Set'                          => 'Thit t',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.'
            => 'Gi hoc lc cc email n da trn X-Headers email! RegExp cng c th.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.'
            => 'Nu bn mun kt hp cc a ch email, hy dng EMAILADDRESS:info@example.com trong tr߶ng T, Ъn hoc Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' =>
            'Nu bn dng RegExp, bn cng c th s dng gi tr kt hp trong () thnh [***] trong \'Thit t\'.',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Hng i <-> Qun tr phn hi t ng',

        # Template: AdminQueueForm
        'Queue Management'                 => 'Qun tr hng i',
        'Sub-Queue of'                     => 'Hng i con ca',
        'Unlock timeout'                   => 'Thi gian ch m kha',
        '0 = no unlock'                    => '0 = khng m kha',
        'Escalation - First Response Time' => 'Tip tc - Thi gian phn hi u tin',
        '0 = no escalation'                => '0 = khng tip tc',
        'Escalation - Update Time'         => 'Tip tc - Thi gian cp nht',
        'Escalation - Solution Time'       => 'Tip tc - Thi gian gii php',
        'Follow up Option'                 => 'Theo di ty chn',
        'Ticket lock after a follow up'    => 'Kha th sau khi theo di',
        'Systemaddress'                    => 'иa ch h thng',
        'Customer Move Notify'             => 'Thng bo chuyn khch hng',
        'Customer State Notify'            => 'Thng bo trng thi khch hng',
        'Customer Owner Notify'            => 'Thng bo ph trch khch hng',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.'
            => 'Nu 1 a l kha mt th v h s khng gi tr li trong thi gian ny, th s c t ng m kha. Do vy tt c cc i l khc u c th nhn thy th .',
        'Escalation time' => 'Thi gian tip tc',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' =>
            'Nu mt th khng c tr li trong thi gian ny, ch duy nht th ny s c hin th.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.'
            => 'Nu mt th c ng v khch hng gi theo di, th s b kha cho ng߶i ph trch c.',
        'Will be the sender address of this queue for email answers.' =>
            'S l a ch ng߶i gi ca hng i ny cho cc email tr li.',
        'The salutation for email answers.' => 'Li cho cho cc email tr li.',
        'The signature for email answers.'  => 'Ch k cho cc email tr li.',
        'OTRS sends an notification email to the customer if the ticket is moved.' =>
            'OTRS gi mt email thng bo ti khch hng nu th c chuyn.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' =>
            'OTRS gi mt email thng bo ti khch hng nu trng thi th thay i.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' =>
            'OTRS gi mt email thng bo ti khch hng nu ph trch th thay i.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Phn hi <-> Qun tr hng i',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Tr li',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Phn hi <-> Qun tr nh km',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Qun tr phn hi',
        'A response is default text to write faster answer (with default text) to customers.' =>
            'Mt phn hi l mt vn bn mc nh c vit cu tr li nhanh gi cho khch hng.',
        'Don\'t forget to add a new response a queue!' =>
            'ng qun thm phn hi mi vo hng i!',
        'The current ticket state is' => 'Trng thi th hin ti l',
        'Your email address is new'   => 'иa ch email ca bn l mi',

        # Template: AdminRoleForm
        'Role Management' => 'Qun tr vai tr',
        'Add Role'        => 'Thm vai tr',
        'Add a new Role.' => 'Thm vai tr mi.',
        'Create a role and put groups in it. Then add the role to the users.' =>
            'To 1 vai tr v t cc nhm vo . Ri thm vai tr cho ng߶i dng.',
        'It\'s useful for a lot of users and groups.' =>
            'N hu ch i vi nhiu ng߶i dng v nhm.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Vai tr <-> Qun tr nhm',
        'move_into'                   => 'chuyn ti',
        'Permissions to move tickets into this group/queue.' =>
            'Cc quyn  chuyn th vo trong nhm/hng i ny.',
        'create' => 'to',
        'Permissions to create tickets in this group/queue.' =>
            'Cc quyn  to th trong nhm/hng i ny.',
        'owner' => 'ph trch',
        'Permissions to change the ticket owner in this group/queue.' =>
            'Cc quyn  thay i ph trch th trong nhm/hng i ny.',
        'priority' => 'u tin',
        'Permissions to change the ticket priority in this group/queue.' =>
            'Cc quyn  thay i u tin th trong nhm/hng i ny.',

        # Template: AdminRoleGroupForm
        'Role' => 'Vai tr',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management'      => 'Vai tr <-> Qun tr ng߶i dng',
        'Active'                          => 'Hot ng',
        'Select the role:user relations.' => 'Chn mi quan h vai tr:ng߶i dng.',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Qun tr li cho',
        'Add Salutation'        => 'Thm li cho',
        'Add a new Salutation.' => 'Thm li cho mi.',

        # Template: AdminSelectBoxForm
        'Select Box'        => 'Chn ',
        'Limit'             => 'Gii hn',
        'Go'                => 'Ti',
        'Select Box Result' => 'Chn  kt qu',

        # Template: AdminService
        'Service Management' => 'Qun tr dch v',
        'Add Service'        => 'Thm dch v',
        'Add a new Service.' => 'Thm dch v mi.',
        'Service'            => 'Dch v',
        'Sub-Service of'     => 'Dch v con ca',

        # Template: AdminSession
        'Session Management' => 'Qun tr phin',
        'Sessions'           => 'Cc phin',
        'Uniq'               => 'Duy nht',
        'Kill all sessions'  => 'Xa tt c cc phin',
        'Session'            => 'Phin',
        'Content'            => 'Ni dung',
        'kill session'       => 'xa phin',

        # Template: AdminSignatureForm
        'Signature Management' => 'Qun tr ch k',
        'Add Signature'        => 'Thm ch k',
        'Add a new Signature.' => 'Thm ch k mi.',

        # Template: AdminSLA
        'SLA Management'      => 'Qun tr SLA',
        'Add SLA'             => 'Thm SLA',
        'Add a new SLA.'      => 'Thm SLA mi.',
        'SLA'                 => 'SLA',
        'First Response Time' => 'Ln phn hi u tin',
        'Update Time'         => 'Thi gian cp nht',
        'Solution Time'       => 'Thi gian gii php',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'Qun tr S/MIME',
        'Add Certificate'   => 'Thm chng ch',
        'Add Private Key'   => 'Thm kha c nhn',
        'Secret'            => 'B mt',
        'Hash'              => 'Bm',
        'In this way you can directly edit the certification and private keys in file system.' =>
            'Theo cch ny bn c th sa chng ch v kha c nhn trc tip trong h thng file.',

        # Template: AdminStateForm
        'State Management' => 'Qun tr trng thi',
        'Add State'        => 'Thm trng thi',
        'Add a new State.' => 'Thm trng thi mi.',
        'State Type'       => 'Loi trng thi',
        'Take care that you also updated the default states in you Kernel/Config.pm!' =>
            'Hy lu  rng bn  cp nht cc trng thi mc nh trong Kernel/Config.pm!',
        'See also' => 'Xem',

        # Template: AdminSysConfig
        'SysConfig'         => 'Cu hnh h thng',
        'Group selection'   => 'La chn nhm',
        'Show'              => 'Hin th',
        'Download Settings' => 'Cc thit t ti xung',
        'Download all system config changes.' =>
            'Ti xung cc thay i cu hnh h thng.',
        'Load Settings' => 'Cc thit t ti',
        'Subgroup'      => 'Nhm con',
        'Elements'      => 'Cc thnh t',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Cc ty chn cu hnh',
        'Default'        => 'Mc nh',
        'New'            => 'Mi',
        'New Group'      => 'Nhm mi',
        'Group Ro'       => 'Nhm ch c',
        'New Group Ro'   => 'Nhm ch c mi',
        'NavBarName'     => 'Tn thanh iu h߾ng',
        'NavBar'         => 'Thanh iu h߾ng',
        'Image'          => 'nh',
        'Prio'           => 'u tin',
        'Block'          => 'Khi',
        'AccessKey'      => 'Phm truy cp',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Qun tr a ch email h thng',
        'Add System Address'                => 'Thm a ch h thng',
        'Add a new System Address.'         => 'Thm a ch h thng mi.',
        'Realname'                          => 'Tn thc',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' =>
            'Tt c cc email n vi c t "Email" (Ti:) s c gi vo trong hng i  chn.',

        # Template: AdminTypeForm
        'Type Management' => 'Qun tr loi',
        'Add Type'        => 'Thm loi',
        'Add a new Type.' => 'Thm loi mi.',

        # Template: AdminUserForm
        'User Management'  => 'Qun tr ng߶i dng',
        'Add User'         => 'Thm ng߶i dng',
        'Add a new Agent.' => 'Thm mt i l mi.',
        'Login as'         => 'ng nhp vi',
        'Firstname'        => 'H',
        'Lastname'         => 'Tn',
        'User will be needed to handle tickets.' =>
            'Ng߶i dng s cn iu khin th.',
        'Don\'t forget to add a new user to groups and/or roles!' =>
            'ng qun thm mt ng߶i dng mi vo nhm v/hoc vai tr!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Ng߶i dng <-> Qun tr nhm',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book'                 => 'S a ch',
        'Return to the compose screen' => 'Tr li mn hnh son',
        'Discard all changes and return to the compose screen' =>
            'T b mi thay i v tr li mn hnh son',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerTableView

        # Template: AgentInfo
        'Info' => 'Thng tin',

        # Template: AgentLinkObject
        'Link Object' => 'Яi tng lin kt',
        'Select'      => 'Chn',
        'Results'     => 'Kt qu',
        'Total hits'  => 'Tng s lt bm',
        'Page'        => 'Trang',
        'Detail'      => 'Chi tit',

        # Template: AgentLookup
        'Lookup' => 'Tra',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker'       => 'Kim tra chnh t',
        'spelling error(s)'   => 'Li chnh t',
        'or'                  => 'hoc',
        'Apply these changes' => 'p dng nhng thay i ny',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Bn c thc s mun xa i tng ny khng?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' =>
            'La chn cc gii hn c trng cho thng k',
        'Fixed' => ' sa',
        'Please select only one element or turn off the button \'Fixed\'.' =>
            'Hy chn ch 1 thnh t hoc tt nt \' sa\'!',
        'Absolut Period'  => 'Chu k tuyt i',
        'Between'         => 'Gia',
        'Relative Period' => 'Chu k lin quan',
        'The last'        => 'Cui cng',
        'Finish'          => 'Kt thc',
        'Here you can make restrictions to your stat.' =>
            'Bn c th to cc gii hn cho thng k ti y.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.'
            => 'Nu bn b nh du trong  " sa", i l sinh thng k c th thay i cc thuc tnh ca thnh t lin quan.',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Chn cu hnh chung',
        'Permissions'                         => 'Cc quyn',
        'Format'                              => 'иnh dng',
        'Graphsize'                           => 'C biu ',
        'Sum rows'                            => 'Tng s hng',
        'Sum columns'                         => 'Tng s ct',
        'Cache'                               => 'Lu tr',
        'Required Field'                      => 'Tr߶ng bt buc',
        'Selection needed'                    => 'La chn cn',
        'Explanation'                         => 'Gii thch',
        'In this form you can select the basic specifications.' =>
            'Trong mu ny bn c th chn cc c t c bn.',
        'Attribute'          => 'Thuc tnh',
        'Title of the stat.' => 'Tiu  thng k.',
        'Here you can insert a description of the stat.' =>
            'Bn c th chn m t thng k ti y.',
        'Dynamic-Object' => 'Яi tng ng',
        'Here you can select the dynamic object you want to use.' =>
            'Bn c th chn i tng ng mun s dng ti y.',
        '(Note: It depends on your installation how many dynamic objects you can use)' =>
            '(Lu : N ph thuc vo ci t ca bn c bao nhiu i tng ng bn mun dng)',
        'Static-File' => 'File tnh',
        'For very complex stats it is possible to include a hardcoded file.' =>
            'Яi vi cc thng k phc tp c th bao gm c file  m ha.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.'
            => 'Nu mt file  m ha sn sng s dng, thuc tnh ny s c hin th v bn c th chn n.',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.'
            => 'Cc thit t quyn. Bn c th la chn 1 hoc nhiu nhm  to thng k  c cu hnh m cc i l khc nhau u c th nhn thy.',
        'Multiple selection of the output format.' => 'Nhiu la chn ca nh dng u ra.',
        'If you use a graph as output format you have to select at least one graph size.' =>
            'Nu bn dng mt biu  lm nh dng u ra, bn phi chn t nht 1 c biu .',
        'If you need the sum of every row select yes' =>
            'Nu bn cn tng s hng, Hy chn \'C\'.',
        'If you need the sum of every column select yes.' =>
            'Nu bn cn tng s ct, Hy chn \'C\'.',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' =>
            'Hu ht cc thng k u c th c lu. iu ny s y nhanh tc  trnh din ca thng k.',
        '(Note: Useful for big databases and low performance server)' =>
            '(Lu : Hu dng i vi cc c s d liu ln v my ch cu hnh thp)',
        'With an invalid stat it isn\'t feasible to generate a stat.' =>
            'Яi vi thng k khng hp l, khng kh thi  sinh thng k.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.'
            => 'iu ny s c ch nu bn mun khng ai c th ly kt qu ca thng k hoc thng k khng sn sng c cu hnh.',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Chn cc thnh t cho chui gi tr',
        'Scale'                                    => 'Phm vi',
        'minimal'                                  => 'ti thiu',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).'
            => 'Hy nh rng, phm vi cho chui gi tr phi ln hn phm vi cho trc X (v d: trc X => Thng; Chui gi tr => Nm).',
        'Here you can the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.'
            => 'Bn c th nh ngha chui gi tr ti y. Bn c kh nng chon 1 hoc 2 thnh t. Sau  c th chn cc thuc tnh ca thnh t. Mi thuc tnh s c hin th l mt chui gi tr n l. Nu khng chn thuc tnh no, tt c thuc tnh ca thnh t s c s dng nu bn sinh thng k. Cng vi  mt thuc tnh mi cng c thm k t ln cu hnh cui cng.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' =>
            'Chn thnh t s dng trn trc X.',
        'maximal period' => 'chu k ti a',
        'minimal scale'  => 'phm vi ti thiu',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.'
            => 'Bn c th nh ngha trc X ti y. Bn c th chn 1 thnh t thng qua nt bm radio. Sau  phi chn 1 hoc nhiu thuc tnh ca thnh t. Nu khng chn tt c thuc tnh ca thnh t s c s dng nu bn sinh thng k. Cng vi  mt thuc tnh mi cng c thm k t ln cu hnh cui cng.',

        # Template: AgentStatsImport
        'Import'                     => 'Nhp',
        'File is not a Stats config' => 'File khng phi l mt cu hnh thng k',
        'No File selected'           => 'Khng c file no c chn',

        # Template: AgentStatsOverview
        'Object' => 'Яi tng',

        # Template: AgentStatsPrint
        'Print'                => 'In',
        'No Element selected.' => 'Khng thnh t no c chn.',

        # Template: AgentStatsView
        'Export Config'               => 'Cu hnh xut',
        'Informations about the Stat' => 'Thng tin v thng k',
        'Exchange Axis'               => 'Trc trao i',
        'Configurable params of static stat' =>
            'Tham s cu hnh ca thng k tnh',
        'No element selected.' => 'Khng thnh t no c chn.',
        'maximal period from'  => 'chu k ti a t',
        'to'                   => 'n',
        'Start'                => 'bt u',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.'
            => 'Vi cc tr߶ng u vo v  chn bn c th cu hnh thng k theo yu cu. Vi cc thnh t ca mt thng k bn c th sa ty theo ng߶i qun tr thng k   cu hnh',

        # Template: AgentTicketBounce
        'Bounce ticket'     => 'Th  b',
        'Ticket locked!'    => 'Th kha!',
        'Ticket unlock!'    => 'Th m!',
        'Bounce to'         => 'T b t',
        'Next ticket state' => 'Trng thi th tip theo',
        'Inform sender'     => 'Thng bo ng߶i gi',
        'Send mail!'        => 'Gi mail!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Th hot ng hng lot',
        'Spell Check'        => 'Kim tra chnh t',
        'Note type'          => 'Loi lu ',
        'Unlock Tickets'     => 'Cc th m',

        # Template: AgentTicketClose
        'Close ticket'           => 'ng th',
        'Previous Owner'         => 'Ph trch tr߾c',
        'Inform Agent'           => 'Thng bo i l',
        'Optional'               => 'Ty chn',
        'Inform involved Agents' => 'Thng bo cc i l lin quan',
        'Attach'                 => 'nh km',
        'Next state'             => 'Trng thi tip',
        'Pending date'           => 'Ngy treo',
        'Time units'             => 'Cc n v thi gian',

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Son tr li cho th',
        'Pending Date'              => 'Ngy treo',
        'for pending* states'       => 'i vi cc trng thi treo*',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Thay i khch hng ca th',
        'Set customer user and customer id of a ticket' =>
            'Thit t m khch hng v ng߶i dng khch hng ca th',
        'Customer User'         => 'Ng߶i dng khch hng',
        'Search Customer'       => 'Tm kim khch hng',
        'Customer Data'         => 'D liu khch hng',
        'Customer history'      => 'Lch s khch hng',
        'All customer tickets.' => 'Tt c cc th khch hng.',

        # Template: AgentTicketCustomerMessage
        'Follow up' => 'Theo di',

        # Template: AgentTicketEmail
        'Compose Email' => 'Son email',
        'new ticket'    => 'th mi',
        'Refresh'       => 'Lm mi',
        'Clear To'      => 'Xa ti',

        # Template: AgentTicketForward
        'Article type' => 'Loi bi vit',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Thay i ni dung th',

        # Template: AgentTicketHistory
        'History of' => 'Lch s ca',

        # Template: AgentTicketLocked

        # Template: AgentTicketMailbox
        'Mailbox'      => 'Hp mail',
        'Tickets'      => 'Cc th',
        'of'           => 'ca',
        'Filter'       => 'Lc',
        'New messages' => 'Tin nhn mi',
        'Reminder'     => 'Nhc nh',
        'Sort by'      => 'Sp xp theo',
        'Order'        => 'Trt t',
        'up'           => 'ln',
        'down'         => 'xung',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Trn th',
        'Merge to'     => 'Trn vi',

        # Template: AgentTicketMove
        'Move Ticket' => 'Chuyn th',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Thm lu  cho th',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Thay i ph trch th',

        # Template: AgentTicketPending
        'Set Pending' => 'Thit t treo',

        # Template: AgentTicketPhone
        'Phone call' => 'Cuc gi',
        'Clear From' => 'Xa t',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Gc',

        # Template: AgentTicketPrint
        'Ticket-Info'    => 'Thng tin th',
        'Accounted time' => 'Thi gian k khai',
        'Escalation in'  => 'Tip tc trong',
        'Linked-Object'  => 'Яi tng lin kt',
        'Parent-Object'  => 'Яi tng cha',
        'Child-Object'   => 'Яi tng con',
        'by'             => 'bi',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Thay i mc  u tin ca th',

        # Template: AgentTicketQueue
        'Tickets shown'      => 'Cc th hin th',
        'Tickets available'  => 'Cc th sn sng s dng',
        'All tickets'        => 'Tt c cc th',
        'Queues'             => 'Hng i',
        'Ticket escalation!' => 'Cc th tip tc!',

        # Template: AgentTicketQueueTicketView
        'Service Time'      => 'Thi gian dch v',
        'Your own Ticket'   => 'Th ca bn',
        'Compose Follow up' => 'Son theo di',
        'Compose Answer'    => 'Son tr li',
        'Contact customer'  => 'Lin h khch hng',
        'Change queue'      => 'Thay i hng i',

        # Template: AgentTicketQueueTicketViewLite

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Thay i ng߶i chu trch nhim ca th',

        # Template: AgentTicketSearch
        'Ticket Search'                    => 'Tm kim th',
        'Profile'                          => 'H s',
        'Search-Template'                  => 'Tm kim mu',
        'TicketFreeText'                   => 'Ni dung th',
        'Created in Queue'                 => ' to trong hng i',
        'Result Form'                      => 'Kt qu t',
        'Save Search-Profile as Template?' => 'Lu h s tm kim thnh mu?',
        'Yes, save it with name'           => 'C, lu vi cng mt tn',

        # Template: AgentTicketSearchResult
        'Search Result'         => 'Kt qu tm kim',
        'Change search options' => 'Thay i ty chn tm kim',

        # Template: AgentTicketSearchResultShort
        'U' => 'U',
        'D' => 'D',

        # Template: AgentTicketStatusView
        'Ticket Status View' => 'Xem trng thi th',
        'Open Tickets'       => 'M th',
        'Locked'             => ' kha',

        # Template: AgentTicketZoom

        # Template: AgentWindowTab

        # Template: Copyright

        # Template: css

        # Template: customer-css

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Truy nguyn',

        # Template: CustomerFooter
        'Powered by' => 'c iu hnh bi',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login'                  => 'ng nhp',
        'Lost your password?'    => 'Mt mt khu?',
        'Request new password'   => 'Yu cu mt khu mi',
        'Create Account'         => 'To ti khon',
        'Sent new password to: ' => ' gi mt khu mi ti: ',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Cho mng %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times'             => 'Ln',
        'No time settings.' => 'Khng c thit t thi gian.',

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning
        'This account exists.'             => 'Ti khon ny  tn ti.',
        'Please press Back and try again.' => 'Xin hy nhn Tr li v th li ln na.',

        # Template: Error
        'Click here to report a bug!' => 'Nhn chut vo y  gi bo co li!',

        # Template: Footer
        'Top of Page' => 'Хu trang',

        # Template: FooterSmall

        # Template: Header

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer'         => 'Ng߶i ci t web',
        'Accept license'        => 'Chp nhn giy php',
        'Don\'t accept license' => 'Khng chp nhn giy php',
        'Admin-User'            => 'Tn truy cp qun tr',
        'Admin-Password'        => 'Mt khu qun tr',
        'your MySQL DB should have a root password! Default is empty!' =>
            'C s d liu MySQL ca bn nn c mt khu gc! Mc nh l  trng!',
        'Database-User'   => 'Ng߶i dng c s d liu',
        'default \'hot\'' => 'mc nh \'hot\'',
        'DB connect host' => 'My ch host kt ni c s d liu',
        'Database'        => 'C s d liu',
        'false'           => 'Li',
        'SystemID'        => 'M h thng',
        '(The identify of the system. Each ticket number and each http session id starts with this number)'
            => '(Nhn dng ca h thng. Mi s th v mi m phin http u bt u bng s ny)',
        'System FQDN' => 'H thng FQDN',
        '(Full qualified domain name of your system)' =>
            '(Tn min y  iu kin ca h thng)',
        'AdminEmail'                                => 'Email qun tr',
        '(Email of the system admin)'               => '(Email ca qun tr h thng)',
        'Organization'                              => 'T chc',
        'Log'                                       => 'Bn ghi',
        'LogModule'                                 => 'M un bn ghi',
        '(Used log backend)'                        => '( s dng cc bn ghi mt sau)',
        'Logfile'                                   => 'File bn ghi',
        '(Logfile just needed for File-LogModule!)' => '(File bn ghi ch cn cho m un File-Log!)',
        'Webfrontend'                               => 'Mt ngoi web',
        'Default Charset'                           => 'M k t mc nh',
        'Use utf-8 it your database supports it!' =>
            'Hy dng utf-8 nu c s d liu ca bn c h tr!',
        'Default Language'        => 'Ngn ng mc nh',
        '(Used default language)' => '(Dng ngn ng mc nh)',
        'CheckMXRecord'           => 'Kim tra bn ghi MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)'
            => '(Kim tra cc bn ghi MX ca cc a ch email  s dng bng cch to mt tr li. Khng dng Kim tra bn ghi MX nu h thng OTRS ca bn nm sau 1 ߶ng dial-up!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.'
            => 'Ь c th s dng OTRS bn phi nhp dng sau vo dng lnh ca bn (Terminal/Shell) lm gc.',
        'Restart your webserver'                      => 'Khi ng li my ch web.',
        'After doing so your OTRS is up and running.' => 'Sau khi thc hin OTRS ca bn  hot ng.',
        'Start page'                                  => 'Trang bt u',
        'Have a lot of fun!'                          => 'Hy tn h߷ng s vui thch!',
        'Your OTRS Team'                              => 'еi OTRS ca bn',

        # Template: Login
        'Welcome to %s' => 'Cho mng ti %s',

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Khng c quyn',

        # Template: Notify
        'Important' => 'Quan trng',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'c in bi',

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'Trang test OTRS',
        'Counter'        => 'B m',

        # Template: Warning
        # Misc
        'Create Database'         => 'To c s d liu',
        'verified'                => 'xc nhn',
        'File-Name'               => 'Tn file',
        'Ticket Number Generator' => 'H sinh s th',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')'
            => '(Nhn dng th. Mt s ng߶i mun thit t iu ny thnh v d nh \'Ticket#\', \'Call#\' hoc \'MyTicket#\')',
        'Create new Phone Ticket' => 'To th cuc gi mi',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' =>
            'Theo cch ny bn c th sa trc tip cu hnh kha trong Kernel/Config.pm',
        'A message should have a To: recipient!' =>
            'Mt tin nhn nn c tr߶ng ng߶i nhn!',
        'Site' => 'Site',
        'Customer history search (e. g. "ID342425").' =>
            'Tm kim lch s khch hng (v d: "ID342425").',
        'for agent firstname' => 'cho h (tn) ca i l',
        'Close!'              => 'ng!',
        'Reporter'            => 'Ng߶i bo co',
        'Process-Path'        => '߶ng dn quy trnh',
        'The message being composed has been closed.  Exiting.' =>
            'Tin nhn ang son b ng. ang thot.',
        'to get the realname of the sender (if given)' =>
            ' ly tn thc ca ng߶i gi (nu c)',
        'FAQ Search Result'       => 'Kt qu tm kim FAQ',
        'Notification (Customer)' => 'Thng bo (Khch hng)',
        'Select Source (for add)' => 'Chn ngun ( thm)',
        'Node-Name'               => 'Tn nt',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)'
            => 'Cc ty chn ca d liu th (v d: &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Home'                  => 'Trang ch',
        'Workflow Groups'       => 'Cc nhm Dng cng vic',
        'Current Impact Rating' => 'Mc nh h߷ng hin ti',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' =>
            'Cc ty chn cu hnh (v d: <OTRS_CONFIG_HttpType>)',
        'FAQ System History'             => 'Lch s h thng FAQ',
        'customer realname'              => 'tn thc khch hng',
        'Pending messages'               => 'Cc tin nhn treo',
        'Modules'                        => 'M un',
        'for agent login'                => 'cho ng nhp i l',
        'Keyword'                        => 'T kha',
        'Reference'                      => 'Tham chiu',
        'with'                           => 'vi',
        'Close type'                     => 'ng loi',
        'DB Admin User'                  => 'Ng߶i dng qun tr C s d liu',
        'for agent user id'              => 'i vi m ng߶i dng i l',
        'sort upward'                    => 'sp xp theo h߾ng tng',
        'Classification'                 => 'Phn loi',
        'Change user <-> group settings' => 'Thay i ng߶i dng <-> cc thit t nhm',
        'next step'                      => 'b߾c tip theo',
        'Customer history search'        => 'Tm kim lch s khch hng',
        'not verified'                   => 'cha c xc nhn',
        'Stat#'                          => 'Thng k s',
        'Create new database'            => 'To c s d liu mi',
        'Year'                           => 'Nm',
        'A message must be spell checked!' =>
            'Tin nhn phi c kim tra chnh t!',
        'X-axis' => 'trc X',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.'
            => 'Email ca bn vi s th "<OTRS_TICKET>" c chuyn ti "<OTRS_BOUNCE_TO>". Hy lin h vi a ch ny  c thm thng tin.',
        'A message should have a body!' => 'Tin nhn nn c ni dung!',
        'All Agents'                    => 'Tt c cc i l',
        'Keywords'                      => 'T kha',
        'No * possible!'                => 'Khng * c th!',
        'Load'                          => 'Ti',
        'Change Time'                   => 'Thay i thi gian',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)'
            => 'Cc ty chn ca ng߶i dng hin ti yu cu hnh ng ny (v d: &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Message for new Owner'                 => 'Tin nhn cho ph trch mi',
        'to get the first 5 lines of the email' => ' ly 5 dng u tin ca email',
        'OTRS DB Password'                      => 'Mt khu c s d liu OTRS',
        'Last update'                           => 'Ln cp nht tr߾c',
        'not rated'                             => 'cha xp hng',
        'to get the first 20 character of the subject' =>
            ' ly 20 k t u tin ca tiu ',
        'DB Admin Password' => 'Mt khu qun tr C s d liu',
        'Drop Database'     => 'B qua C s d liu',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' =>
            'Cc ty chn ca d liu ng߶i dng khch hng hin ti (v d: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type'       => 'Loi treo',
        'Comment (internal)' => 'Nhn xt (ni b)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' =>
            'Cc ty chn ph trch th (v d: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'This window must be called from compose window' =>
            'Ca s ny cn phi c gi t ca s son tho',
        'User-Number'                        => 'S ng߶i dng',
        'You need min. one selected Ticket!' => 'Bn cn ti thiu 1 th c chn!',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)'
            => 'Cc ty chn ca d liu th (v d: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(иnh dng s th s dng)',
        'Fulltext'                    => 'Ton b vn bn',
        'Month'                       => 'Thng',
        'Node-Address'                => 'иa ch nt',
        'All Agent variables.'        => 'Tt c cc bin s i l',
        ' (work units)'               => ' (cc n v lm vic)',
        'You use the DELETE option! Take care, all deleted Tickets are lost!!!' =>
            'Bn s dng ty chn Xa! Hy cn thn, tt c cc th xa s b mt!',
        'All Customer variables like defined in config option CustomerUser.' =>
            'Tt c cc bin s khch hng  nh ngha trong cu hnh ty chn ng߶i dng khch hng.',
        'for agent lastname' => 'tn i l',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)'
            => 'Cc ty chn ca ng߶i dng hin ti ng߶i yu cu hnh ng ny (v d: <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages'                => 'Tin nhn nhc nh',
        'A message should have a subject!' => 'Th nn c tiu !',
        'TicketZoom'                       => 'Phng i th',
        'Don\'t forget to add a new user to groups!' =>
            'ng qun b sung mt ng߶i dng mi vo nhm!',
        'You need a email address (e. g. customer@example.com) in To:!' =>
            'Bn cn a ch email trong tr߶ng Ti (v d: kunde@example.com)!',
        'CreateTicket'              => 'To th',
        'unknown'                   => 'cha xc nh',
        'You need to account time!' => 'Bn cn ti thi gian ti khon!',
        'System Settings'           => 'Thit t h thng',
        'Finished'                  => 'Kt thc',
        'Imported'                  => 'Nhp',
        'unread'                    => 'cha c',
        'Split'                     => 'Chia',
        'All messages'              => 'Tt c tin nhn',
        'System Status'             => 'Trng thi h thng',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)'
            => 'Cc ty chn ca d liu th (v d: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'A article should have a title!' => 'Bi vit nn c tiu !',
        'Event'                          => 'S kin',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' =>
            'Cc ty chn cu hnh (v d: &lt;OTRS_CONFIG_HttpType&gt;)',
        'Imported by' => 'Nhp bi',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' =>
            'Cc ty chn ch th (v d <OTRS_OWNER_UserFirstname>)',
        'read'                              => 'c',
        'Product'                           => 'Sn phm',
        'Name is required!'                 => 'Tn c yu cu!',
        'kill all sessions'                 => 'xa tt c cc phin',
        'to get the from line of the email' => ' ly t dng email',
        'Solution'                          => 'Gii php',
        'QueueView'                         => 'Xem hng i',
        'My Queue'                          => 'Hng i ca ti',
        'Instance'                          => 'Tr߶ng hp',
        'Day'                               => 'Ngy',
        'Service-Name'                      => 'Tn dch v',
        'Welcome to OTRS'                   => 'Cho mng bn n vi OTRS',
        'tmp_lock'                          => 'kha_tmp',
        'modified'                          => ' chnh sa',
        'Delete old database'               => 'Xa c s d liu c',
        'sort downward'                     => 'sp xp theo h߾ng gim',
        'You need to use a ticket number!'  => 'Bn cn dng s th!',
        'Watcher'                           => 'Ng߶i xem',
        'send'                              => 'gi',
        'Note Text'                         => 'Lu ',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)'
            => 'Cc ty chn ca d liu ng߶i dng khch hng hin ti ((v d: &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;).',
        'System State Management'          => 'Qun tr trng thi h thng',
        'PhoneView'                        => 'Xem s in thoi',
        'User-Name'                        => 'Tn ng nhp',
        'File-Path'                        => '߶ng dn file',
        'Modified'                         => ' chnh sa',
        'Ticket selected for bulk action!' => 'Th  c chn cho hnh ng hng lot',
    };

    # $$STOP$$
    return;
}

1;
