# --
# Kernel/Language/fr.pm - provides fr language translation
# Copyright (C) 2002 Bernard Choppy <choppy at imaginet.fr>
# Copyright (C) 2002 Nicolas Goralski <ngoralski at oceanet-technology.com>
# Copyright (C) 2004 Igor Genibel <igor.genibel at eds-opensource.com>
# Copyright (C) 2007 Remi Seguy <remi.seguy at laposte.net>
# Copyright (C) 2007 Massimiliano Franco <max-lists at ycom.ch>
# Copyright (C) 2004-2008 Yann Richard <ze at nbox.org>
# Copyright (C) 2009 Olivier Sallou <olivier.sallou at irisa.fr>
# --
# $Id: fr.pm,v 1.114 2009/07/13 09:49:47 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::fr;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.114 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Thu Jul  9 03:06:53 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Oui',
        'No' => 'Non',
        'yes' => 'oui',
        'no' => 'non',
        'Off' => 'Dsactiv',
        'off' => 'dsactiv',
        'On' => 'Activ',
        'on' => 'activ',
        'top' => 'haut',
        'end' => 'fin',
        'Done' => 'Fait',
        'Cancel' => 'Annuler',
        'Reset' => 'Remise  zro',
        'last' => 'dernier',
        'before' => 'avant',
        'day' => 'jour',
        'days' => 'jours',
        'day(s)' => 'jour(s)',
        'hour' => 'heure',
        'hours' => 'heures',
        'hour(s)' => 'heure(s)',
        'minute' => 'minute',
        'minutes' => 'minutes',
        'minute(s)' => 'minute(s)',
        'month' => 'mois',
        'months' => 'mois',
        'month(s)' => 'mois',
        'week' => 'semaine',
        'week(s)' => 'semaine(s)',
        'year' => 'anne',
        'years' => 'annes',
        'year(s)' => 'anne(s)',
        'second(s)' => 'seconde(s)',
        'seconds' => 'secondes',
        'second' => 'seconde',
        'wrote' => 'a crit',
        'Message' => 'Message',
        'Error' => 'Erreur',
        'Bug Report' => 'Rapport d\'anomalie',
        'Attention' => 'Attention',
        'Warning' => 'Attention',
        'Module' => 'Module',
        'Modulefile' => 'Fichier de module',
        'Subfunction' => 'sous-fonction',
        'Line' => 'Ligne',
        'Setting' => 'Paramtre',
        'Settings' => 'Paramtres',
        'Example' => 'Exemple',
        'Examples' => 'Exemples',
        'valid' => 'valide',
        'invalid' => 'invalide',
        '* invalid' => '* invalide',
        'invalid-temporarily' => 'temporairement invalide',
        ' 2 minutes' => ' 2 minutes',
        ' 5 minutes' => ' 5 minutes',
        ' 7 minutes' => ' 7 minutes',
        '10 minutes' => '10 minutes',
        '15 minutes' => '15 minutes',
        'Mr.' => 'M.',
        'Mrs.' => 'Mme',
        'Next' => 'Suivant',
        'Back' => 'Retour',
        'Next...' => 'Suivant...',
        '...Back' => '...Retour',
        '-none-' => '-aucun-',
        'none' => 'aucun',
        'none!' => 'aucun !',
        'none - answered' => 'aucun - rponse faite',
        'please do not edit!' => 'Ne pas modifier !',
        'AddLink' => 'Ajouter un lien',
        'Link' => 'Lier',
        'Unlink' => 'Dlier',
        'Linked' => 'Lie',
        'Link (Normal)' => 'Lien (Normal)',
        'Link (Parent)' => 'Lien (Parent)',
        'Link (Child)' => 'Lien (Enfant)',
        'Normal' => 'Normal',
        'Parent' => 'Parent',
        'Child' => 'Enfant',
        'Hit' => 'Occurence',
        'Hits' => 'Occurences',
        'Text' => 'Texte',
        'Lite' => 'allge',
        'User' => 'Utilisateur',
        'Username' => 'Nom d\'utilisateur',
        'Language' => 'Langue',
        'Languages' => 'Langues',
        'Password' => 'Mot de Passe',
        'Salutation' => 'En-tte',
        'Signature' => 'Signature',
        'Customer' => 'Client',
        'CustomerID' => 'Numro de client',
        'CustomerIDs' => 'Numro de client (Groupe)',
        'customer' => 'client',
        'agent' => 'technicien',
        'system' => 'systme',
        'Customer Info' => 'Information client',
        'Customer Company' => 'Entreprise du client',
        'Company' => 'Entreprise',
        'go!' => 'c\'est parti !',
        'go' => 'aller',
        'All' => 'Tout',
        'all' => 'tout',
        'Sorry' => 'Dsol',
        'update!' => 'mettre  jour !',
        'update' => 'mettre  jour',
        'Update' => 'Mettre  jour',
        'Updated!' => 'Mis(e)  jour',
        'submit!' => 'soumettre !',
        'submit' => 'soumettre',
        'Submit' => 'Soumettre',
        'change!' => 'modifier !',
        'Change' => 'Modifier',
        'change' => 'modifier',
        'click here' => 'Cliquer ici',
        'Comment' => 'Commentaire',
        'Valid' => 'Valide',
        'Invalid Option!' => 'Option invalide !',
        'Invalid time!' => 'Temps invalide !',
        'Invalid date!' => 'Date invalide !',
        'Name' => 'Nom',
        'Group' => 'Groupe',
        'Description' => 'Description',
        'description' => 'description',
        'Theme' => 'Thme',
        'Created' => 'Cr',
        'Created by' => 'Cr par',
        'Changed' => 'Chang',
        'Changed by' => 'Chang par',
        'Search' => 'Chercher',
        'and' => 'et le',
        'between' => 'entre',
        'Fulltext Search' => 'Recherche sur tout le texte',
        'Data' => 'Donnes',
        'Options' => 'Options',
        'Title' => 'Titre',
        'Item' => 'lment',
        'Delete' => 'Effacer',
        'Edit' => 'diter',
        'View' => 'Vue',
        'Number' => 'Nombre',
        'System' => 'Systme',
        'Contact' => 'Contact',
        'Contacts' => 'Contacts',
        'Export' => 'Exporter',
        'Up' => 'Haut',
        'Down' => 'Bas',
        'Add' => 'Ajouter',
        'Added!' => 'Ajout',
        'Category' => 'Catgorie',
        'Viewer' => 'Visionneuse',
        'Expand' => 'Etendre',
        'New message' => 'Nouveau message',
        'New message!' => 'Nouveau message !',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Veuillez rpondre  ce(s) ticket(s) pour revenir  une vue normale de la file !',
        'You got new message!' => 'Vous avez un nouveau message !',
        'You have %s new message(s)!' => 'Vous avez %s nouveau(x) message(s) !',
        'You have %s reminder ticket(s)!' => 'Vous avez %s rappel(s) de ticket(s) !',
        'The recommended charset for your language is %s!' => 'Le jeu de caractre correspondant  votre langue est %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Les mots de passes diffrent! Essayez de nouveau svp!',
        'Password is already in use! Please use an other password!' => 'Mot de passe dj utilis! Essayez en un autre svp!',
        'Password is already used! Please use an other password!' => 'Ce mot de passe a dj t utilis! Essayez en un autre svp!',
        'You need to activate %s first to use it!' => 'Vous devez d\'abord activer %s pour l\'utiliser !',
        'No suggestions' => 'Pas de suggestions',
        'Word' => 'Mot',
        'Ignore' => 'Ignorer',
        'replace with' => 'remplacer par',
        'There is no account with that login name.' => 'Il n\'y a aucun compte avec ce nom de connexion',
        'Login failed! Your username or password was entered incorrectly.' => 'La connection a chou ! Votre nom d\'utilisateur ou votre mot de passe sont errons.',
        'Please contact your admin' => 'Veuillez contacter votre admnistrateur',
        'Logout successful. Thank you for using OTRS!' => 'Dconnexion russie. Merci d\'avoir utilis OTRS!',
        'Invalid SessionID!' => 'ID de Session Invalide !',
        'Feature not active!' => 'Cette fonctionnalit n\'est pas active !',
        'Notification (Event)' => 'Notification (Evenement)',
        'Login is needed!' => 'Authentification requise !',
        'Password is needed!' => 'Le mot de passe est requis !',
        'License' => 'Licence',
        'Take this Customer' => 'Choisir ce client',
        'Take this User' => 'Choisir cet utilisateur',
        'possible' => 'possible',
        'reject' => 'rejet',
        'reverse' => 'inverse',
        'Facility' => 'Service',
        'Timeover' => 'Temp coul',
        'Pending till' => 'En attendant jusqu\'',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Cela ne fonctionne pas avec l\'identifiant utilisateur 1 (Compte Systme)! Veuillez crer un nouvel utilisateur!',
        'Dispatching by email To: field.' => 'Rpartition par le champs \':\' du courriel',
        'Dispatching by selected Queue.' => 'Rpartition selon la file slectionne',
        'No entry found!' => 'Aucun rsultat n\'a t trouv !',
        'Session has timed out. Please log in again.' => 'Le dlai de votre session est dpass, veuillez vous r-authentifier.',
        'No Permission!' => 'Pas de permission!',
        'To: (%s) replaced with database email!' => 'Le champ \':\' (%s) a t remplac avec la valeur de la base de donnes des des adresses de courriel !',
        'Cc: (%s) added database email!' => 'Cc: (%s) a t ajout  la base de donne d\'e-mail',
        '(Click here to add)' => '(Cliquez ii pour ajouter)',
        'Preview' => 'Aperu',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Le paquet n\'a pas t correctement dploy ! Vous devez le rinstaller  nouveau !',
        'Added User "%s"' => 'Ajout de l\'utilisateur "%s"',
        'Contract' => 'Contrat',
        'Online Customer: %s' => 'Clients en ligne: %s',
        'Online Agent: %s' => 'Techniciens en ligne: %s',
        'Calendar' => 'Calendrier',
        'File' => 'Fichier',
        'Filename' => 'Nom de fichier',
        'Type' => 'Type',
        'Size' => 'Taille',
        'Upload' => 'Uploader',
        'Directory' => 'Rpertoire',
        'Signed' => 'Sign',
        'Sign' => 'Signer',
        'Crypted' => 'Crypt',
        'Crypt' => 'Crypter',
        'Office' => 'Bureau',
        'Phone' => 'Tlphone',
        'Fax' => 'Fax',
        'Mobile' => 'Tlphone portable',
        'Zip' => 'Code postal',
        'City' => 'Ville',
        'Street' => 'Rue',
        'Country' => 'Pays',
        'Location' => 'Plan',
        'installed' => 'install',
        'uninstalled' => 'dsinstall',
        'Security Note: You should activate %s because application is already running!' => 'Note de Scurit: Vous devriez activer %s parce que l\'application est dj lance !',
        'Unable to parse Online Repository index document!' => 'Impossible d\'analyser l\'index du dpt en ligne',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Aucun paquet pour le Framework slectionn dans ce dpot en ligne, mais des paquets pour d\'autres Frameworks !',
        'No Packages or no new Packages in selected Online Repository!' => 'Pas de paquets ou de nouveau paquets dans le dpot en ligne slectionn !',
        'printed at' => 'imprim ',
        'Dear Mr. %s,' => 'Cher M. %s',
        'Dear Mrs. %s,' => 'Cher Mme %s',
        'Dear %s,' => 'Cher %s',
        'Hello %s,' => 'Bonjour %s',
        'This account exists.' => 'Ce compte existe dj.',
        'New account created. Sent Login-Account to %s.' => 'Nouveau compte cre. Identifiant envoy  %s',
        'Please press Back and try again.' => 'SVP, reculer d\'une page et rssayez.',
        'Sent password token to: %s' => 'Envoit du jeton : %s',
        'Sent new password to: %s' => 'Envoit du nouveau mot de passe : %s',
        'Upcoming Events' => 'vnements  venir',
        'Event' => 'vnement',
        'Events' => 'vnements',
        'Invalid Token!' => 'Jeton invalide !',
        'more' => 'plus',
        'For more info see:' => 'Pour plus d\'informations, allez ',
        'Package verification failed!' => 'Vrification du paquet choue',
        'Collapse' => 'Rduire',
        'News' => 'Nouvelles',
        'Product News' => 'Nouvelles du produit',
        'OTRS News' => '',
        '7 Day Stats' => '',
        'Bold' => 'Gras',
        'Italic' => 'Italique',
        'Underline' => 'Soulign',
        'Font Color' => 'Couleur de police',
        'Background Color' => 'Couleur de fond',
        'Remove Formatting' => 'Supprimer le formattage',
        'Show/Hide Hidden Elements' => 'Montrer/Cacher les lments cachs',
        'Align Left' => 'Aligner  Gauche',
        'Align Center' => 'Aligner au Centre',
        'Align Right' => 'Aligner  Droite',
        'Justify' => 'Justifier',
        'Header' => 'En-tte',
        'Indent' => 'Ajouter indentation',
        'Outdent' => 'Supprimer indentation',
        'Create an Unordered List' => 'Crer une liste non ordonne',
        'Create an Ordered List' => 'Crer une liste ordonne',
        'HTML Link' => 'Lien HTML',
        'Insert Image' => 'Insrer image',
        'CTRL' => 'Contrle',
        'SHIFT' => 'Shift',
        'Undo' => 'Annuler',
        'Redo' => 'Refaire',

        # Template: AAAMonth
        'Jan' => 'Jan',
        'Feb' => 'Fv',
        'Mar' => 'Mar',
        'Apr' => 'Avr',
        'May' => 'Mai',
        'Jun' => 'Juin',
        'Jul' => 'Juil',
        'Aug' => 'Ao',
        'Sep' => 'Sep',
        'Oct' => 'Oct',
        'Nov' => 'Nov',
        'Dec' => 'Dc',
        'January' => 'Janvier',
        'February' => 'Fvrier',
        'March' => 'Mars',
        'April' => 'Avril',
        'June' => 'Juin',
        'July' => 'Juillet',
        'August' => 'Aot',
        'September' => 'Septembre',
        'October' => 'Octobre',
        'November' => 'Novembre',
        'December' => 'Dcembre',

        # Template: AAANavBar
        'Admin-Area' => 'Zone d\'administration',
        'Agent-Area' => 'Interface du technicien',
        'Ticket-Area' => 'Tickets',
        'Logout' => 'Dconnexion',
        'Agent Preferences' => 'Prfrences du technicien',
        'Preferences' => 'Prfrences',
        'Agent Mailbox' => 'Boite e-mail du technicien',
        'Stats' => 'Statistiques',
        'Stats-Area' => 'Statistiques',
        'Admin' => 'Administrateur',
        'Customer Users' => 'Clients',
        'Customer Users <-> Groups' => 'Clients <-> Groupes',
        'Users <-> Groups' => 'Agent <-> Groupes',
        'Roles' => 'Rles',
        'Roles <-> Users' => 'Rles <-> Agents',
        'Roles <-> Groups' => 'Rles <-> Groupes',
        'Salutations' => 'En-ttes',
        'Signatures' => 'Signatures',
        'Email Addresses' => 'Adresses lectroniques',
        'Notifications' => 'Notifications',
        'Category Tree' => 'Liste des catgories',
        'Admin Notification' => 'Notification des administrateurs',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Les prfrences ont bien t mises  jours !',
        'Mail Management' => 'Gestion des e-mails',
        'Frontend' => 'Interface',
        'Other Options' => 'Autres options',
        'Change Password' => 'Changer de mot de passe',
        'New password' => 'Nouveau mot de passe',
        'New password again' => 'Nouveau mot de passe (encore)',
        'Select your QueueView refresh time.' => 'Choix du dlai de rafrachissement de la vue des files',
        'Select your frontend language.' => 'Choix de la langue de l\'interface',
        'Select your frontend Charset.' => 'Choix du jeu de caractres de l\'interface',
        'Select your frontend Theme.' => 'Choix du thme de l\'interface',
        'Select your frontend QueueView.' => 'Choisissez votre interface de vue des files',
        'Spelling Dictionary' => 'Correcteur orthographique',
        'Select your default spelling dictionary.' => 'Slectionnez votre correcteur orthographique par dfaut',
        'Max. shown Tickets a page in Overview.' => 'Nombre de tickets maximum sur la page d\'aperu des tickets',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Mise  jour du mot de passe impossible, les mots de passe diffrent! Essayez  nouveau svp!',
        'Can\'t update password, invalid characters!' => 'Mise  jour du mot de passe impossible, caractres invalides!',
        'Can\'t update password, must be at least %s characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit avoir au moins %s caractres!',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 majuscules et 2 minuscules!',
        'Can\'t update password, needs at least 1 digit!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter un chiffre minimum!',
        'Can\'t update password, needs at least 2 characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 caractres minimum!',

        # Template: AAAStats
        'Stat' => 'Stat',
        'Please fill out the required fields!' => 'Remplissez les champs obligatoires svp !',
        'Please select a file!' => 'Slectionnez un fichier svp !',
        'Please select an object!' => 'Slectionnez un objet svp !',
        'Please select a graph size!' => 'Slectionnez un graphique svp !',
        'Please select one element for the X-axis!' => 'Slectionnez un lment pour l\'axe des X svp !',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Veuillez slectionner un seul lment ou dsactiver le bouton \'Fixe\' l o le champ slectionn est en surbrillance! ',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Si vous cochez une case, vous devez indiquer des attributs du champ slectionn',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Veuillez donner une valeur pour le champ slectionn ou dsactiver la case',
        'The selected end time is before the start time!' => 'La date de fin est antrieure  la date de dbut',
        'You have to select one or more attributes from the select field!' => 'Vous devez slectionner un ou plusieurs attributs du champ slectionn',
        'The selected Date isn\'t valid!' => 'La date slectionne n\'est pas valide !',
        'Please select only one or two elements via the checkbox!' => 'Slectionnez uniquement un ou deux lments via les cases  cocher!',
        'If you use a time scale element you can only select one element!' => 'Si vous employez un lment d\'chelle de temps vous pouvez seulement choisir un lment',
        'You have an error in your time selection!' => 'Vous avez une erreur dans le choix de la date',
        'Your reporting time interval is too small, please use a larger time scale!' => 'La priode choisie pour le rapport est trop courte, veuillez indiquer une plage plus grande',
        'The selected start time is before the allowed start time!' => 'La date de dbut choisie est antrieure  la date de dbut autorise',
        'The selected end time is after the allowed end time!' => 'La date de fin choisie esst posterieure  la date de fin autorise',
        'The selected time period is larger than the allowed time period!' => 'La plage de temps choisie est suprieure  la date de temps autorise',
        'Common Specification' => 'Caractristiques Communes',
        'Xaxis' => 'Axe X',
        'Value Series' => 'Sries de valeurs',
        'Restrictions' => 'Restrictions',
        'graph-lines' => 'Graphique-Lignes',
        'graph-bars' => 'Graphique-Barres',
        'graph-hbars' => 'Graphique-Barres horizontales',
        'graph-points' => 'Graphique-Points',
        'graph-lines-points' => 'Graphique-Lignes-Points',
        'graph-area' => 'Graphique-Surface',
        'graph-pie' => 'Graphique-Camenbert',
        'extended' => 'tendu',
        'Agent/Owner' => 'Technicien/Propritaire',
        'Created by Agent/Owner' => 'Cr par le Technicien/Propritaire',
        'Created Priority' => 'Priorit cre',
        'Created State' => 'tat cr',
        'Create Time' => 'Date de cration',
        'CustomerUserLogin' => 'Identifiant Client',
        'Close Time' => 'Date de fermeture',
        'TicketAccumulation' => '',
        'Attributes to be printed' => 'Attributs  imprimer',
        'Sort sequence' => 'Ordre de tri',
        'Order by' => 'Trier par',
        'Limit' => 'Limite',
        'Ticketlist' => 'Liste des tickets',
        'ascending' => 'ascendant',
        'descending' => 'descendant',
        'First Lock' => 'Premier verrou',
        'Evaluation by' => 'Evaluation par',
        'Total Time' => 'Temps Total',
        'Ticket Average' => 'Moyenne des tickets',
        'Ticket Min Time' => 'Temps minimum du ticket',
        'Ticket Max Time' => 'Temps maximum du ticket',
        'Number of Tickets' => 'Nombre de tickets',
        'Article Average' => 'Moyenne des articles',
        'Article Min Time' => 'Temps minimum des articles',
        'Article Max Time' => 'Temps maximum des articles',
        'Number of Articles' => 'Nombre d\'articles',
        'Accounted time by Agent' => 'Temps pass par agent',
        'Ticket/Article Accounted Time' => 'Temps pass par Ticket/Article',
        'TicketAccountedTime' => 'Temps pass sur le ticket',
        'Ticket Create Time' => 'Heure de cration du ticket',
        'Ticket Close Time' => 'Heure de fermeture du ticket',

        # Template: AAATicket
        'Lock' => 'Verrouiller',
        'Unlock' => 'Dverrouiller',
        'History' => 'Historique',
        'Zoom' => 'Dtails',
        'Age' => 'ge',
        'Bounce' => 'Renvoyer',
        'Forward' => 'Transmettre',
        'From' => 'De',
        'To' => '',
        'Cc' => 'Copie ',
        'Bcc' => 'Copie Invisible',
        'Subject' => 'Sujet',
        'Move' => 'Dplacer',
        'Queue' => 'File',
        'Priority' => 'Priorit',
        'Priority Update' => 'Mise  jour de la priorit',
        'State' => 'tat',
        'Compose' => 'Composer',
        'Pending' => 'En attente',
        'Owner' => 'Propritaire',
        'Owner Update' => 'Mise  jour du propritaire',
        'Responsible' => 'Responsable',
        'Responsible Update' => 'Mise  jour du responsable',
        'Sender' => 'metteur',
        'Article' => 'Article',
        'Ticket' => 'Ticket',
        'Createtime' => 'Cration du',
        'plain' => 'tel quel',
        'Email' => 'Courrier lectronique',
        'email' => 'courriel',
        'Close' => 'Fermer',
        'Action' => 'Action',
        'Attachment' => 'Pice jointe',
        'Attachments' => 'Pices jointes',
        'This message was written in a character set other than your own.' => 'Ce message a t crit dans un jeu de caractres diffrent du vtre.',
        'If it is not displayed correctly,' => 'S\'il n\'est pas affich correctement',
        'This is a' => 'Ceci est un',
        'to open it in a new window.' => 'L\'ouvrir dans une nouvelle fentre',
        'This is a HTML email. Click here to show it.' => 'Ceci est un message au format HTML ; cliquer ici pour l\'afficher.',
        'Free Fields' => 'Champs libres',
        'Merge' => 'Fusionner',
        'merged' => 'Fusionn',
        'closed successful' => 'clture russie',
        'closed unsuccessful' => 'clture manque',
        'new' => 'nouveau',
        'open' => 'ouvrir',
        'Open' => 'Ouvert',
        'closed' => 'ferm',
        'Closed' => 'Ferm',
        'removed' => 'supprim',
        'pending reminder' => 'Attente du rappel',
        'pending auto' => 'En attente auto',
        'pending auto close+' => 'En attente de la fermeture automatique(+)',
        'pending auto close-' => 'En attente de la fermeture automatique(-)',
        'email-external' => 'message externe',
        'email-internal' => 'message interne',
        'note-external' => 'Note externe',
        'note-internal' => 'Note interne',
        'note-report' => 'Note rapport',
        'phone' => 'tlphone',
        'sms' => 'SMS',
        'webrequest' => 'Requte par le web',
        'lock' => 'verrouiller',
        'unlock' => 'dverrouiller',
        'very low' => 'trs basse',
        'low' => 'confort de fonctionnement',
        'normal' => 'normal',
        'high' => 'important',
        'very high' => 'trs haut',
        '1 very low' => '1 trs bas',
        '2 low' => '2 bas',
        '3 normal' => '3 normal',
        '4 high' => '4 important',
        '5 very high' => '5 trs important',
        'Ticket "%s" created!' => 'Le ticket %s a t cr !',
        'Ticket Number' => 'Numro de ticket',
        'Ticket Object' => 'Objet ticket',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Pas de numro de ticket "%s"! Je ne peut pas le lier',
        'Don\'t show closed Tickets' => 'Ne pas montrer les tickets cloturs',
        'Show closed Tickets' => 'Voir les tickets cloturs',
        'New Article' => 'Nouvel Article',
        'Email-Ticket' => 'crire un e-mail',
        'Create new Email Ticket' => 'Crer un nouveau ticket en envoyant un e-mail',
        'Phone-Ticket' => 'Vue tlphone',
        'Search Tickets' => 'Recherche de tickets',
        'Edit Customer Users' => 'Editer clients',
        'Edit Customer Company' => 'diter l\'entreprise cliente',
        'Bulk Action' => 'Action groupe',
        'Bulk Actions on Tickets' => 'Action groupes sur les tickets',
        'Send Email and create a new Ticket' => 'Envoyer un courriel et crer un nouveau Ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'Crer un ticket Email et l\'envoyer (Sortant)',
        'Create new Phone Ticket (Inbound)' => 'Crer un ticket Tlphone (Entrant)',
        'Overview of all open Tickets' => 'Vue de tous les Tickets',
        'Locked Tickets' => 'Tickets verrouills',
        'Watched Tickets' => 'Tickets surveills',
        'Watched' => 'Surveill',
        'Subscribe' => 'S\'abonner',
        'Unsubscribe' => 'Se dsabonner',
        'Lock it to work on it!' => 'Verrouillez le pour travailler dessus!',
        'Unlock to give it back to the queue!' => 'Dverrouillez pour qu\'il retourne dans sa file!',
        'Shows the ticket history!' => 'Voir l\'historique du ticket!',
        'Print this ticket!' => 'Imprimer ce ticket!',
        'Change the ticket priority!' => 'Changer la priorit du ticket',
        'Change the ticket free fields!' => 'Changer les champs libres du ticket',
        'Link this ticket to an other objects!' => 'Lier ce ticket  un autre objet!',
        'Change the ticket owner!' => 'Changer le propritaire du ticket!',
        'Change the ticket customer!' => 'Changer le client du ticket!',
        'Add a note to this ticket!' => 'Ajouter une note au ticket!',
        'Merge this ticket!' => 'Fusionner ce ticket!',
        'Set this ticket to pending!' => 'Mettre le ticket en attente!',
        'Close this ticket!' => 'Fermer ce ticket!',
        'Look into a ticket!' => 'Voir le dtail du ticket!',
        'Delete this ticket!' => 'Effacer ce ticket!',
        'Mark as Spam!' => 'Marquer comme Spam!',
        'My Queues' => 'Mes files',
        'Shown Tickets' => 'Tickets affichs',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Votre ticket numro "<OTRS_TICKET>" a t fusionn avec le ticket numro "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: le temps imparti pour la premire rponse est dpass (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: le temps imparti pour la premire rponse sera dpass dans %s!',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: le temps imparti pour la rvision est dpass (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: le temps imparti pour la rvision sera dpass dans %s!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: le temps imparti pour fournir une solution est dpass (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Ticket %s: le temps imparti pour fournir une solution sera dpass dans %s!',
        'There are more escalated tickets!' => 'Il y a d\'autres tickets en escalade',
        'New ticket notification' => 'Notification de nouveau ticket',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Me prvenir si il y a un nouveau ticket dans une de "Mes files".',
        'Follow up notification' => 'Notification de suivi',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Me prvenir si un client envoie un suivi (follow-up) sur un ticket dont je suis propritaire.',
        'Ticket lock timeout notification' => 'Prvenir du dpassement du dlai d\'un verrou',
        'Send me a notification if a ticket is unlocked by the system.' => 'Me prvenir si un ticket est dverrouill par le systme',
        'Move notification' => 'Notification de mouvement',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Me prvenir si un ticket est dplac dans une de "Mes files".',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Votre slection des files prfres. Vous recevrez une information par email si disponible',
        'Custom Queue' => 'File d\'attente personnalise',
        'QueueView refresh time' => 'Temps de rafrachissement de la vue des files',
        'Screen after new ticket' => 'cran aprs un nouveau ticket',
        'Select your screen after creating a new ticket.' => 'Slectionnez l\'cran qui sera affich aprs avoir cr un nouveau ticket.',
        'Closed Tickets' => 'Tickets ferms',
        'Show closed tickets.' => 'Voir les tickets ferms',
        'Max. shown Tickets a page in QueueView.' => 'Nombre de tickets maximum sur la page de la vue d\'une file',
        'Watch notification' => 'Notification de suivi',
        'Send me a notification of an watched ticket like an owner of an ticket.' => '',
        'Out Of Office' => 'Absent du bureau',
        'Select your out of office time.' => 'Slectionnez vos heures d\'absence du bureau',
        'CompanyTickets' => 'Tickets de l\'entreprise cliente',
        'MyTickets' => 'Mes tickets',
        'New Ticket' => 'Nouveau ticket',
        'Create new Ticket' => 'Cration d\'un nouveau ticket',
        'Customer called' => 'Client appell',
        'phone call' => 'Appel tlphonique',
        'Reminder Reached' => 'Rappel atteint',
        'Reminder Tickets' => 'Tickets de rappel',
        'Escalated Tickets' => 'Tickets escalads',
        'New Tickets' => 'Nouveaux tickets',
        'Open Tickets / Need to be answered' => 'Tickets ouverts en attente de rponse',
        'Tickets which need to be answered!' => 'Tickets en attente de rponse',
        'All new tickets!' => 'Tous les nouveaux tickets',
        'All tickets which are escalated!' => 'Tous les tickets devant tre escalads',
        'All tickets where the reminder date has reached!' => 'Tous les tickets dont la date de rappel est atteinte',
        'Responses' => 'Rponses',
        'Responses <-> Queue' => 'Rponses <-> Files',
        'Auto Responses' => 'Rponses automatiques',
        'Auto Responses <-> Queue' => 'Rponses automatiques <-> Files',
        'Attachments <-> Responses' => 'Pices jointes <-> Rponses',
        'History::Move' => 'Le ticket a t dplac dans la file "%s" (%s) - Ancienne file: "%s" (%s).',
        'History::TypeUpdate' => 'Type positionn  %s (ID=%s).',
        'History::ServiceUpdate' => 'Service positionn  %s (ID=%s).',
        'History::SLAUpdate' => 'SLA positionn  %s (ID=%s).',
        'History::NewTicket' => 'Un nouveau ticket a t cre: [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Un suivie du ticket [%s]. %s',
        'History::SendAutoReject' => 'Rejet automatique envoy  "%s".',
        'History::SendAutoReply' => 'Rponse automatique envoy  "%s".',
        'History::SendAutoFollowUp' => 'Suivie automatique envoy  "%s".',
        'History::Forward' => 'Transfr vers "%s".',
        'History::Bounce' => 'Redirig vers "%s".',
        'History::SendAnswer' => 'Email envoy  "%s".',
        'History::SendAgentNotification' => '"%s"-notification envoy  "%s".',
        'History::SendCustomerNotification' => 'Notification envoy  "%s".',
        'History::EmailAgent' => 'Email envoy au client.',
        'History::EmailCustomer' => 'Ajout d\'une adresse email. %s',
        'History::PhoneCallAgent' => 'Le technicien a appell le client.',
        'History::PhoneCallCustomer' => 'Le client nous a appell.',
        'History::AddNote' => 'Ajout d\'une note (%s)',
        'History::Lock' => 'Ticket verrouill.',
        'History::Unlock' => 'Ticket dverrouill.',
        'History::TimeAccounting' => 'Temps pass sur l\'action: %s . Total du temps pass pour ce ticket: %s unit(s).',
        'History::Remove' => 'Supprimer %s',
        'History::CustomerUpdate' => 'Mise  jour: %s',
        'History::PriorityUpdate' => 'Changement de priorit de "%s" (%s) pour "%s" (%s).',
        'History::OwnerUpdate' => 'Le nouveau propritaire est "%s" (ID=%s).',
        'History::LoopProtection' => 'Protection anti-boucle! Pas d\'auto rponse envoy  "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Mise  jour: %s',
        'History::StateUpdate' => 'Avant: "%s" Aprs: "%s"',
        'History::TicketFreeTextUpdate' => 'Mise  jour: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Requte du client via le web.',
        'History::TicketLinkAdd' => 'Added link to ticket "%s".',
        'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Dim',
        'Mon' => 'Lun',
        'Tue' => 'Mar',
        'Wed' => 'Mer',
        'Thu' => 'Jeu',
        'Fri' => 'Ven',
        'Sat' => 'Sam',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Gestion des pices jointes',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Gestion des rponses automatiques',
        'Response' => 'Rponse',
        'Auto Response From' => 'Rponse automatique de ',
        'Note' => 'Note',
        'Useable options' => 'Options accessibles',
        'To get the first 20 character of the subject.' => 'Pour avoir les 20 premiers caractres',
        'To get the first 5 lines of the email.' => 'Pour avoir les 5 premires lignes',
        'To get the realname of the sender (if given).' => 'Pour avoir le nom de l\'expditeur s\'il est fourni.',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'pour avoir les attributs de l\'article (par ex. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> et <OTRS_CUSTOMER_Body>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Proprits des donnes personnelles du client',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Proprits du propritaire du ticket',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Proprits du responsable du ticket',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Proprits du client qui a demand cette action',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Proprits du ticket',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Proprits de la configuration',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Gestion des services clients',
        'Search for' => 'Chercher ',
        'Add Customer Company' => 'Ajouter un client au service',
        'Add a new Customer Company.' => 'Ajouter un nouveau service',
        'List' => 'Lister',
        'This values are required.' => 'Ces valeurs sont obligatoires.',
        'This values are read only.' => 'Ces valeurs sont en lecture seule.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'Le message en cours de rdaction a t cltur. Sortie.',
        'This window must be called from compose window' => 'Cette fentre doit tre appele de la fentre depuis la fentre de rdaction',
        'Customer User Management' => 'Gestion des clients utilisateurs',
        'Add Customer User' => 'Ajouter un client utilisateur',
        'Source' => 'Source',
        'Create' => 'Cration',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Les clients utilisateurs seront invits  se connecter par la page client.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Clients <-> Gestion des groupes',
        'Change %s settings' => 'Changer les param&ecirc;tres de %s',
        'Select the user:group permissions.' => 'Slectionnez les permissions pour l\'utilisateur:groupe.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Si rien n\'est slectionn, il n\'y aura pas de droits dans ce groupe (Les tickets ne seront plus disponible pour l\'utilisateur).',
        'Permission' => 'Droits',
        'ro' => 'lecture seule',
        'Read only access to the ticket in this group/queue.' => 'Accs en lecture seulement aux tickets de cette file/groupe.',
        'rw' => 'lecture/criture',
        'Full read and write access to the tickets in this group/queue.' => 'Accs complet en lecture et criture aux tickets dans cette file/groupe.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'Client utilisateur <-> Gestion des Services',
        'CustomerUser' => 'Client utilisateur',
        'Service' => 'Service',
        'Edit default services.' => 'diter le Service par dfaut',
        'Search Result' => 'Rsultat de la recherche',
        'Allocate services to CustomerUser' => 'Allouer les services au client utilisateur',
        'Active' => 'Actif',
        'Allocate CustomerUser to service' => 'Allouer le client utilisateur au service',

        # Template: AdminEmail
        'Message sent to' => 'Message envoy ',
        'A message should have a subject!' => 'Un message doit avoir un sujet !',
        'Recipents' => 'Rcipients',
        'Recipients' => 'Rcipients',
        'Body' => 'Corps',
        'Send' => 'Envoyer',

        # Template: AdminGenericAgent
        'GenericAgent' => 'Automate gnrique',
        'Job-List' => 'Liste de tches',
        'Last run' => 'Dernier lancement',
        'Run Now!' => 'Lancer maintenant!',
        'x' => 'x',
        'Save Job as?' => 'Sauver la tche en tant que?',
        'Is Job Valid?' => 'Cette tche est-elle valide?',
        'Is Job Valid' => 'Cette tche est-elle valide',
        'Schedule' => 'Planifier',
        'Currently this generic agent job will not run automatically.' => 'Actuellement, cet agent gnrique ne s\'excutera pas automatiquement',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Pour permettre l\'excution automatique, slectionnez au moins une valeur dans minutes, heures et jours!',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Recherche sur le texte d\'un article (ex: "Mar*in" or "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '(ex: 10*5155 or 105658*)',
        '(e. g. 234321)' => '(ex: 234321)',
        'Customer User Login' => 'Nom de connexion du client',
        '(e. g. U5150)' => '(ex: U5150)',
        'SLA' => 'SLA',
        'Agent' => 'Technicien',
        'Ticket Lock' => 'Ticket verrouill',
        'TicketFreeFields' => 'Champs libres du ticket',
        'Create Times' => 'Dates de cration',
        'No create time settings.' => 'Pas de critre de date de cration',
        'Ticket created' => 'Ticket cr',
        'Ticket created between' => 'Ticket cr entre le',
        'Close Times' => 'Temps de fermeture',
        'No close time settings.' => 'Pas de paramtre de temps de fermeture',
        'Ticket closed' => 'Ticket ferm',
        'Ticket closed between' => 'Ticket ferm entre',
        'Pending Times' => 'Dates d\'chance',
        'No pending time settings.' => 'pas de critre de date d\'chance',
        'Ticket pending time reached' => 'Date d\'chance atteinte le',
        'Ticket pending time reached between' => 'Date d\'chance atteinte entre le',
        'Escalation Times' => 'Temps d\'escalade',
        'No escalation time settings.' => 'Pas de paramtres de temps d\'escalade',
        'Ticket escalation time reached' => 'Temps d\'escalade du ticket atteinte',
        'Ticket escalation time reached between' => 'Temps d\'escalade du ticket atteinte entre',
        'Escalation - First Response Time' => 'Rmonte du ticket - Premier temps de rponse',
        'Ticket first response time reached' => 'Premier temps de rponse du ticket atteint',
        'Ticket first response time reached between' => 'Premier temps de rponse du ticket atteint entre',
        'Escalation - Update Time' => 'Escalade - chance pour le suivi',
        'Ticket update time reached' => 'Temps de mise  jour du ticket atteint',
        'Ticket update time reached between' => 'Temps de mise  jour du ticket atteint entre',
        'Escalation - Solution Time' => 'Escalade - chance pour la solution',
        'Ticket solution time reached' => 'Temps de rsolution du ticket atteint',
        'Ticket solution time reached between' => 'Temps de rsolution du ticket atteint entre',
        'New Service' => 'Nouveau Service',
        'New SLA' => 'Nouveau SLA',
        'New Priority' => 'Nouvelle Priorit',
        'New Queue' => 'Nouvelle File',
        'New State' => 'Nouvel tat',
        'New Agent' => 'Nouveau Technicien',
        'New Owner' => 'Nouveau Propritaire',
        'New Customer' => 'Nouveau Client',
        'New Ticket Lock' => 'Nouveau Verrou',
        'New Type' => 'Nouveau Type',
        'New Title' => 'Nouveau Titre',
        'New TicketFreeFields' => 'Nouveau champs libres',
        'Add Note' => 'Ajouter une note',
        'Time units' => 'Unit de temps',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Cette commande sera excut. ARG[0] sera le numro du ticket et ARG[1] son identifiant.',
        'Delete tickets' => 'Effacer les tickets',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Attention, ces tickets seront ffacs de la base de donne ! Ils seront dfinitivement perdus !',
        'Send Notification' => 'Envoyer une notification',
        'Param 1' => 'Paramtre 1',
        'Param 2' => 'Paramtre 2',
        'Param 3' => 'Paramtre 3',
        'Param 4' => 'Paramtre 4',
        'Param 5' => 'Paramtre 5',
        'Param 6' => 'Paramtre 6',
        'Send agent/customer notifications on changes' => 'Envoyer des notifications  l\'agent/au client sur changement',
        'Save' => 'Sauver',
        '%s Tickets affected! Do you really want to use this job?' => '%s tickets affects! Voulez vous vraiment utiliser cette commande ?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'ATTENTION: Lorsque vous modifier le nom du group \'admin\', avant de faire les changements appropris dans SysConfig, vous serez dconnect du panneau d\'administration. Si cela arrive, veuillez renommer  nouveau le groupe admin par une requte SQL.',
        'Group Management' => 'Administration des groupes',
        'Add Group' => 'Ajouter un groupe',
        'Add a new Group.' => 'Ajouter un nouveau groupe',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Le groupe admin permet d\'accder  la zone d\'administration et le groupe stats  la zone de statistiques.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crer de nouveaux groupes permettra de grer les droits d\'accs pour les diffrents groupes du technicien (exemple: achats, comptabilit, support, ventes...).',
        'It\'s useful for ASP solutions.' => 'C\'est utile pour les fournisseurs d\'applications.',

        # Template: AdminLog
        'System Log' => 'Journaux du Systme',
        'Time' => 'Date et heure',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Gestion du compte de messagerie',
        'Host' => 'Hte',
        'Trusted' => 'Vrifi',
        'Dispatching' => 'Rpartition',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Tous les courriels entrants avec un compte seront rpartis dans la file slectionne !',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Si votre compte est vrifi, les ent&ecirc;tes X-OTRS (pour les priorits,...) seront utiliss !',

        # Template: AdminNavigationBar
        'Users' => 'Utilisateurs',
        'Groups' => 'Groupes',
        'Misc' => 'Divers',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'Gestion des notifications',
        'Add Notification' => 'Ajouter notification',
        'Add a new Notification.' => 'Ajouter une nouvelle notification',
        'Name is required!' => 'Un nom est requis!',
        'Event is required!' => 'Un evenement est requis',
        'A message should have a body!' => 'Un message doit avoir un corps !',
        'Recipient' => 'Destinataire',
        'Group based' => 'Bas sur le Groupe',
        'Agent based' => 'Bas sur l\'Agent',
        'Email based' => 'Bas sur l\'Email',
        'Article Type' => 'Type d\'Article',
        'Only for ArticleCreate Event.' => 'Seulement pour l\'vnement Cration d\'article',
        'Subject match' => 'Correspondance du sujet',
        'Body match' => 'Correspondance du corps du message',
        'Notifications are sent to an agent or a customer.' => 'Des notifications sont envoyes  un technicien ou  un client.',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Pour avoir les 20 premiers caractres du sujet (du dernier article de l\'agent).',
        'To get the first 5 lines of the body (of the latest agent article).' => 'Pour avoir les 5 premires ligne du corps (du dernier article de l\'agent).',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Pour avoir l\'attribut d\'article (i.e. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Pour avoir les 20 premiers caractres du sujet (du dernier article du client).',
        'To get the first 5 lines of the body (of the latest customer article).' => 'Pour avoir les 5 premires lignes du sujet (du dernier article du client).',

        # Template: AdminNotificationForm
        'Notification' => 'Notification',

        # Template: AdminPackageManager
        'Package Manager' => 'Gestionnaire de paquet',
        'Uninstall' => 'Dinstallation',
        'Version' => 'Version',
        'Do you really want to uninstall this package?' => 'Voulez-vous vraiment dinstaller ce paquet ?',
        'Reinstall' => 'R-installation',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Voulez-vous vraiment rinstaller ce paquet (Tous les changements manuels seront perdus) ?',
        'Continue' => 'Continuer',
        'Install' => 'Installation',
        'Package' => 'Paquet',
        'Online Repository' => 'Dpot en ligne',
        'Vendor' => 'Vendeur',
        'Module documentation' => 'Documentation du module',
        'Upgrade' => 'Mise  jour',
        'Local Repository' => 'Dpt local',
        'Status' => 'tat',
        'Overview' => 'Aperu',
        'Download' => 'Tlchargement',
        'Rebuild' => 'Re-construction',
        'ChangeLog' => 'Enregistrement des changements',
        'Date' => 'Date',
        'Filelist' => 'Liste des fichiers',
        'Download file from package!' => 'Tlcharger le fichier depuis le paquet',
        'Required' => 'Obligatoire',
        'PrimaryKey' => 'Cl primaire',
        'AutoIncrement' => 'Auto incrmentation',
        'SQL' => 'SQL',
        'Diff' => 'Diff',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Enregistrement des indicateurs de performance',
        'This feature is enabled!' => 'Cette fonctionnalit est active',
        'Just use this feature if you want to log each request.' => 'N\'employer cette fonction que si vous voulez enregitrer chaque requte',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => 'Dsactivez l ici',
        'This feature is disabled!' => 'Cette fonctionnalit est dsactive',
        'Enable it here!' => 'Activez l ici',
        'Logfile too large!' => 'Fichier de log trop grand !',
        'Logfile too large, you need to reset it!' => 'Fichier de log trop grand, une remise  zro est ncessaire !',
        'Range' => 'Plage',
        'Interface' => 'Interface',
        'Requests' => 'Requtes',
        'Min Response' => 'Temps de rponse minimum',
        'Max Response' => 'Temps de rponse maximun',
        'Average Response' => 'Temps de rponse moyen',
        'Period' => 'Priode',
        'Min' => 'Min',
        'Max' => 'Max',
        'Average' => 'Moyenne',

        # Template: AdminPGPForm
        'PGP Management' => 'Gestion de PGP',
        'Result' => 'Rsultat',
        'Identifier' => 'Identifiant',
        'Bit' => 'Bit',
        'Key' => 'Cl',
        'Fingerprint' => 'Empreinte',
        'Expires' => 'Expiration',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Dans ce cas vous pouvez directement diter le trousseau configur dans SysConfig.',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Gestion des filtres PostMaster',
        'Filtername' => 'Nom du filtre',
        'Stop after match' => 'Stopper aprs correspondance',
        'Match' => 'Correspond',
        'Value' => 'Valeur',
        'Set' => 'Assigner',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'dispatcher ou filtrer les courriels entrants en se basant sur les en-ttes (X-*)! L\'utilisationd\'expression rgulire est aussi possible.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Si vous voulez tester uniquement l\'email, utiliser EMAILADDRESS:info@example.com dans From, To ou Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Si vous utilisez RegExp, vous pouvez aussi tester la valeur entre () comme [***] dans \'Set\'.',

        # Template: AdminPriority
        'Priority Management' => 'Gestion de la priorit',
        'Add Priority' => 'Ajouter la priorit',
        'Add a new Priority.' => 'Ajouter une nouvelle priorit',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Files <-> Gestion des rponses automatiques',
        'settings' => 'Paramtres',

        # Template: AdminQueueForm
        'Queue Management' => 'Gestion des files',
        'Sub-Queue of' => 'Sous-file',
        'Unlock timeout' => 'Dlai du dverrouillage',
        '0 = no unlock' => '0 = pas de verrouillage',
        'Only business hours are counted.' => 'Seuls les plages horaires de bureau sont compts',
        '0 = no escalation' => '0 = pas de remonte du ticket',
        'Notify by' => 'Notification par',
        'Follow up Option' => 'Option des suivis',
        'Ticket lock after a follow up' => 'Ticket verrouill aprs un suivi',
        'Systemaddress' => 'Adresse du Systme',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un technicien verrouille un ticket et qu\'il/elle n\'envoie pas une rponse dans le temps imparti, le ticket sera dverrouill automatiquement. Le ticket sera alors visible de tous les autres techniciens',
        'Escalation time' => 'Dlai de remonte du ticket',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Si une rponse n\'est pas apporte au ticket dans le temps imparti, seul ce ticket sera affich',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si un ticket est cltur et que le client envoie une note, le ticket sera verrouill pour l\'ancien propritaire',
        'Will be the sender address of this queue for email answers.' => 'Sera l\'adresse d\'expdition pour les rponses par courriel pour cette file.',
        'The salutation for email answers.' => 'La formule de politesse pour les rponses par mail',
        'The signature for email answers.' => 'La signature pour les rponses par courriel',
        'Customer Move Notify' => 'Notification lors d\'un changement de file',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS envoi un courriel au client lorsque le ticket change de file.',
        'Customer State Notify' => 'Notification lors d\'un changement d\'tat',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS envoi un courriel au client lorsque le ticket change d\'tat.',
        'Customer Owner Notify' => 'Notification lors d\'un changement de propritaire',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS envoi un courriel au client lorsque le ticket change de propritaire.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Rponses <-> Gestion des files',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Rponse',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Rponses <-> Gestion des pices jointes',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Gestion des rponses',
        'A response is default text to write faster answer (with default text) to customers.' => 'Une rponse est un texte par dfaut destin  rdiger plus rapidement des rponses standards aux clients.',
        'Don\'t forget to add a new response a queue!' => 'Ne pas oublier d\'ajouter une file  une nouvelle rponse !',
        'The current ticket state is' => 'L\'tat actuel du ticket est',
        'Your email address is new' => 'Votre adresse lectronique est nouvelle',

        # Template: AdminRoleForm
        'Role Management' => 'Gestion des Rles',
        'Add Role' => 'Ajouter un rle',
        'Add a new Role.' => 'Ajoute un nouveau rle.',
        'Create a role and put groups in it. Then add the role to the users.' => 'Cre un rle et y ajoute des groupes. Ajoute alors le rle aux utilisateurs.',
        'It\'s useful for a lot of users and groups.' => 'Pratique lorsqu\'on a beaucoup d\'utilisateurs et de groupes',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Rles <-> Gestion des groupes',
        'move_into' => 'dplacer dans',
        'Permissions to move tickets into this group/queue.' => 'Permission de dplacer un ticket dans cette file/groupe.',
        'create' => 'crer',
        'Permissions to create tickets in this group/queue.' => 'Permission de crer un ticket dans cette file/groupe.',
        'owner' => 'propritaire',
        'Permissions to change the ticket owner in this group/queue.' => 'Permission de changer le propritaire d\'un ticket dans cette file/groupe.',
        'priority' => 'priorit',
        'Permissions to change the ticket priority in this group/queue.' => 'Permission de changer la priorit d\'un ticket dans cette file/groupe.',

        # Template: AdminRoleGroupForm
        'Role' => 'Rles',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Rles <-> Gestion des utilisateurs',
        'Select the role:user relations.' => 'Slection des relations role/utilisateur',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Prfixes des messages',
        'Add Salutation' => 'Ajouter une en-tte',
        'Add a new Salutation.' => 'Ajoute une nouvelle en-tte.',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => 'Le mode scuris doit tre activ',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Le mode scuris sera (normallement) activ lorsque l\'installation initiale sera termine.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Le mode scuris doit tre dsactiv dans le but de rinstaller en utilisant le web-installer (installateur web)',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Si le mode scuris n\'est pas activ, activer le via le SysConfig car votre application est dj en train de tourner.',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'Reqtes SQL',
        'CVS' => '',
        'HTML' => '',
        'Select Box Result' => 'Choisissez le rsultat',

        # Template: AdminService
        'Service Management' => 'Gestion des Services',
        'Add Service' => 'Ajouter un Service',
        'Add a new Service.' => 'Ajoute un nouveau Service.',
        'Sub-Service of' => 'Sous-service de',

        # Template: AdminSession
        'Session Management' => 'Gestion des sessions',
        'Sessions' => 'Sessions',
        'Uniq' => 'Unique',
        'Kill all sessions' => 'Supprimer toutes les sessions',
        'Session' => 'Session',
        'Content' => 'Contenu',
        'kill session' => 'Supprimer la session',

        # Template: AdminSignatureForm
        'Signature Management' => 'Gestion des signatures',
        'Add Signature' => 'Ajouter une signature',
        'Add a new Signature.' => 'Ajouter une nouvelle signature.',

        # Template: AdminSLA
        'SLA Management' => 'Gestion des Accords sur la qualit de service (Service Level Agreement)',
        'Add SLA' => 'Ajouter un SLA',
        'Add a new SLA.' => 'Ajouter un nouveau SLA',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'Gestion S/MIME',
        'Add Certificate' => 'Ajouter un certificat',
        'Add Private Key' => 'Ajouter une cl prive',
        'Secret' => 'Secret',
        'Hash' => 'Hashage',
        'In this way you can directly edit the certification and private keys in file system.' => 'Dans ce cas vous pouvez directement diter le certificat et la cl prive dans le systme de fichier',

        # Template: AdminStateForm
        'State Management' => 'Gestion des tats',
        'Add State' => 'Ajouter un tat',
        'Add a new State.' => 'Ajoute un nouvel tat.',
        'State Type' => 'Type d\'tat',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Prenez garde de bien mettre  jour les tats par dfaut dans votre Kernel/Config.pm !',
        'See also' => 'Voir aussi',

        # Template: AdminSysConfig
        'SysConfig' => 'Configuration Systme',
        'Group selection' => 'Slection du groupe',
        'Show' => 'Voir',
        'Download Settings' => 'Paramtres de tlchargement',
        'Download all system config changes.' => 'Tlcharger tous les changements de la configuration systme.',
        'Load Settings' => 'Charger les paramtres',
        'Subgroup' => 'Sous-groupe',
        'Elements' => 'lments',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Options de configuration',
        'Default' => 'Dfaut',
        'New' => 'Nouveau',
        'New Group' => 'Nouveau groupe',
        'Group Ro' => 'Groupe lecture seule',
        'New Group Ro' => 'Nouveau groupe (lecture seule)',
        'NavBarName' => 'Nom de la barre de navigation',
        'NavBar' => 'Barre de navigation',
        'Image' => 'Image',
        'Prio' => 'Priorit',
        'Block' => 'Bloc',
        'AccessKey' => 'Accs clavier',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Gestion des adresses courriel du systme',
        'Add System Address' => 'Ajouter une adresse systme',
        'Add a new System Address.' => 'Ajoute une nouvelle adresse systme',
        'Realname' => 'Vritable Nom',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tous les courriels avec cette adresse en destinataire (:) seront rpartis dans la file slectionne !',

        # Template: AdminTypeForm
        'Type Management' => 'Gestion des Types',
        'Add Type' => 'Ajouter un Type',
        'Add a new Type.' => 'Ajoute un nouveau Type.',

        # Template: AdminUserForm
        'User Management' => 'Administration des utilisateurs',
        'Add User' => 'Ajouter un utilisateur',
        'Add a new Agent.' => 'Ajoute un nouvel agent.',
        'Login as' => 'Connect en tant que',
        'Firstname' => 'Prnom',
        'Lastname' => 'Nom',
        'Start' => 'Dmarrer',
        'End' => 'Fin',
        'User will be needed to handle tickets.' => 'Un utilisateur sera ncessaire pour grer les tickets.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'N\'oubliez pas d\'ajouter un nouvel utilisateur  des groupes et/ou des rles !',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Utilisateurs <-> Gestion des groupes',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Carnet d\'adresses',
        'Return to the compose screen' => 'Retourner  l\'cran de saisie',
        'Discard all changes and return to the compose screen' => 'Annuler tous les changements et retourner  l\'cran de saisie',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Tableau de bord',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s est disponible',
        'Please update now.' => 'Merci de mettre  jour maintenant',
        'Release Note' => 'Note de version',
        'Level' => 'Niveau',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Envoy il y a %s',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => 'Information',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Lier l\'Objet: %s',
        'Object' => 'Objet',
        'Link Object' => 'Lier l\'objet',
        'with' => 'avec',
        'Select' => 'Slectionner',
        'Unlink Object: %s' => 'Dlier l\'objet: %s',

        # Template: AgentLookup
        'Lookup' => 'Consulter',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Vrificateur orthographique',
        'spelling error(s)' => 'erreurs d\'orthographe',
        'or' => 'ou',
        'Apply these changes' => 'Appliquer ces changements',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Voulez vous vraiment effacer cet objet ?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Slectionnez les restrictions pour affiner les statistiques',
        'Fixed' => 'Fix',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Slectionnez un seul lment ou dsactivez le bouton \'Fix\'',
        'Absolut Period' => 'Priode absolue',
        'Between' => 'Entre',
        'Relative Period' => 'Priode relative',
        'The last' => 'Le dernier',
        'Finish' => 'Terminer',
        'Here you can make restrictions to your stat.' => 'Vous pouvez ici appliquer des restrictions  vos statistiques.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Si vous enlevez la coche dans la case, le technicien generant les statistiques peut changer les attributs de l\lement correspondant',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Insertion des caractristiques communes',
        'Permissions' => 'Permissions',
        'Format' => 'Format',
        'Graphsize' => 'Taille du graphique',
        'Sum rows' => 'Ligne de somme',
        'Sum columns' => 'Colonnes de somme',
        'Cache' => 'Cache',
        'Required Field' => 'Champ requis',
        'Selection needed' => 'Slection requise',
        'Explanation' => 'Explication',
        'In this form you can select the basic specifications.' => 'Dans ce formulaire, vous pouvez choisir les caractristiques de base',
        'Attribute' => 'Attributs',
        'Title of the stat.' => 'Titre des statistiques',
        'Here you can insert a description of the stat.' => 'Vous pouvez insrer ici une description des statistiques.',
        'Dynamic-Object' => 'Objet dynamique',
        'Here you can select the dynamic object you want to use.' => 'Ici vous pouvez slectionner l\'objet dynamique que vous voulez utiliser',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'Note: Le nombre d\'objets dynamiques que vous pouvez utiliser dpend de votre configuration technique',
        'Static-File' => 'Fichier statique',
        'For very complex stats it is possible to include a hardcoded file.' => 'Pour des statistiques trs complexes, il est possible d\'inclure un fichier dj encod',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Si un nouveau fichier encod est disponible, cet attribut sera visible et vous pourrez le slectionner',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Permissions. Vous pouvez slectionner un ou plusieurs groupes pour autoriser la consultation des statistiques pour diffrents techniciens.',
        'Multiple selection of the output format.' => 'Selection multiple du format de sortie',
        'If you use a graph as output format you have to select at least one graph size.' => 'Si vous choisissez Graphe comme format de sortie, vous devez choisir la taille',
        'If you need the sum of every row select yes' => 'Si vous avez besoin de la somme pour chaque ligne, choisissez Oui',
        'If you need the sum of every column select yes.' => 'Si vous avez besoin de la somme pour chaque colonne, choisissez Oui',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'La plus grande part des stats peuvent tre mise en cache. Cela acclere leur prsentation',
        '(Note: Useful for big databases and low performance server)' => 'Note: utile pour les bases de donnes volumineuses et les serveurs peu performants',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Il est impossible de produire des statistiques avec des donnes invalides.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ceci est utilie si vous voulez que personne n\'obtienne les statistiques ou si elles ne sont pas encore configures',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Slectionnez les lments de la srie de donnes',
        'Scale' => 'chelle',
        'minimal' => 'minimale',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'SVP, rappelez vous que la plage pour la srie de donnes doit tre plus grande que l\'echelle de l\'axe des X (ex. axe des X => Mois, Srie => Anne',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Ici vous pouvez dfinir les sries de valeurs. Vous avez la possibilit de slectionner un ou deux lments. Ensuite vous pouvez slectionner les attributs des lments. Chaque attribut sera affich comme une srie  une valeur. Si vous ne slectionnez aucun attribut, tous les attributs de l\'lment seront utiliss si vous gnrez une statistique. De la mme faon si un nouvel attribut est ajout depuis la dernire configuration.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'Slectionnez l\'lment qui sera utilis pour l\'axe des X',
        'maximal period' => 'priode minimale',
        'minimal scale' => 'chelle minimale',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Ici vous pouvez dfinir l\'axe x. Vous pouvez slectionner un lment par le bouton radio. Si aucune slection n\'est faite, tous les attributs de l\'lment seront utiliss si vous gnrez une statistique. De la mme faon si un nouvel attribut est ajout depuis la dernire configuration.',

        # Template: AgentStatsImport
        'Import' => 'Importer',
        'File is not a Stats config' => 'Ce n\'est pas un fichier de configuration de statistiques',
        'No File selected' => 'Aucun fichier slectionn',

        # Template: AgentStatsOverview
        'Results' => 'Rsultat',
        'Total hits' => 'Nombre de rsultats trouvs',
        'Page' => 'Page',

        # Template: AgentStatsPrint
        'Print' => 'Imprimer',
        'No Element selected.' => 'Aucun lment slectionn.',

        # Template: AgentStatsView
        'Export Config' => 'Exporter la configuration',
        'Information about the Stat' => 'Informations  propos de la statistique',
        'Exchange Axis' => 'changez les axes',
        'Configurable params of static stat' => 'Paramtres modifiables des statistiques',
        'No element selected.' => 'Aucun lment slectionn.',
        'maximal period from' => 'Priode maximale de',
        'to' => 'vers',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Un message doit avoir un destinataire (:)!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Il faut une adresse courriel (ex&nbsp;: client@exemple.fr)&nbsp;!',
        'Bounce ticket' => 'Renvoyer le ticket',
        'Ticket locked!' => 'Ticket verrouill !',
        'Ticket unlock!' => 'Rendre le ticket !',
        'Bounce to' => 'Renvoyer ',
        'Next ticket state' => 'Prochain tat du ticket',
        'Inform sender' => 'Informer l\'emetteur',
        'Send mail!' => 'Envoyer le courriel !',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Vous devez comptabiliser le temps;!',
        'Ticket Bulk Action' => 'Ticket en action groupe',
        'Spell Check' => 'Vrification orthographique',
        'Note type' => 'Type de note',
        'Next state' => 'tat suivant',
        'Pending date' => 'Dlais d\'attente',
        'Merge to' => 'Fusionner avec',
        'Merge to oldest' => 'Fusionner avec le plus ancien',
        'Link together' => 'Lier ensemble',
        'Link to Parent' => 'Lier au Parent',
        'Unlock Tickets' => 'Dverrouiller les Tickets',

        # Template: AgentTicketClose
        'Ticket Type is required!' => 'Le Type du Ticket est requis',
        'A required field is:' => 'Un champ requis est:',
        'Close ticket' => 'Ticket clos',
        'Previous Owner' => 'Propritaire Prcdent',
        'Inform Agent' => 'Informer l\'agent',
        'Optional' => 'Optionnel',
        'Inform involved Agents' => 'Informer les agents impliqus',
        'Attach' => 'Attacher',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'L\'orthographe d\'un message doit tre vrifie!',
        'Compose answer for ticket' => 'Rdiger une rponse pour le ticket',
        'Pending Date' => 'En attendant la date',
        'for pending* states' => 'pour tous les tats de mise en attente',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Changer le client du ticket',
        'Set customer user and customer id of a ticket' => 'Assigner un utilisateur client et un identifiant client pour le ticket.',
        'Customer User' => 'Client Utilisateur',
        'Search Customer' => 'Recherche de client',
        'Customer Data' => 'Donnes client',
        'Customer history' => 'Historique du client',
        'All customer tickets.' => 'Tous les tickets du client',

        # Template: AgentTicketEmail
        'Compose Email' => 'crire un courriel',
        'new ticket' => 'nouveau ticket',
        'Refresh' => 'Rafrachir',
        'Clear To' => 'Effacer la zone de saisie "De:"',
        'All Agents' => 'Tous les techniciens',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Type d\'article',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Changer le texte libre du ticket',

        # Template: AgentTicketHistory
        'History of' => 'Historique de',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Vous devez utiliser un numro de ticket!',
        'Ticket Merge' => 'Fusion de Ticket',

        # Template: AgentTicketMove
        'Move Ticket' => 'Changer la file du ticket',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Ajouter une note au ticket',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => 'Temps pour fournir la premire rponse (prise en compte)',
        'Service Time' => 'Temps pour le service',
        'Update Time' => 'Temps pour fournir un point d\'avancement',
        'Solution Time' => 'Temps pour fournir la rponse',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Vous devez nommer au moins un Ticket!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Filtre',
        'Change search options' => 'Changer les options de recherche',
        'Tickets' => 'Ticket',
        'of' => 'de',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Rdiger une rponse',
        'Contact customer' => 'Contacter le client',
        'Change queue' => 'Changer de file',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'Tri croissant',
        'up' => 'vers le haut',
        'sort downward' => 'Tri dcroissant',
        'down' => 'vers le bas',
        'Escalation in' => 'Remonte dans',
        'Locked' => 'Verrouill',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Changer le propritaire du ticket',

        # Template: AgentTicketPending
        'Set Pending' => 'Dfinir la mise en attente',

        # Template: AgentTicketPhone
        'Phone call' => 'Appel tlphonique',
        'Clear From' => 'Vider le formulaire',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Tel quel',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Information du Ticket',
        'Accounted time' => 'Temp pass',
        'Linked-Object' => 'Objet li',
        'by' => 'par',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Modification de la priorit du ticket',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Tickets affichs',
        'Tickets available' => 'Tickets disponibles',
        'All tickets' => 'tous les tickets',
        'Queues' => 'Files',
        'Ticket escalation!' => 'Remonte du ticket !',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Changer le responsable du ticket',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Recherche de ticket',
        'Profile' => 'Profil',
        'Search-Template' => 'Profil de recherche',
        'TicketFreeText' => 'Texte Libre du Ticket',
        'Created in Queue' => 'Cr dans la file',
        'Article Create Times' => 'Heures de cration d\'article',
        'Article created' => 'Article cr',
        'Article created between' => 'Article cr entre',
        'Change Times' => 'Heures de modification',
        'No change time settings.' => 'Paramtrage de non modification d\'heure',
        'Ticket changed' => 'Ticket modifi',
        'Ticket changed between' => 'Ticket modifi entre',
        'Result Form' => 'Format du rsultat',
        'Save Search-Profile as Template?' => 'Sauver le profil de recherche ?',
        'Yes, save it with name' => 'Oui, le sauver avec le nom',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'Texte Complet',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'Afficher plus',
        'Collapse View' => 'Rduire',
        'Split' => 'Scinder',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => 'Paramtres de filtrage d\'article',
        'Save filter settings as default' => 'Sauvegarder les paramtres de filtrage comme paramtres par dfaut',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Trace du retour d\'erreur',

        # Template: CustomerFooter
        'Powered by' => 'Fonction assure par',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'S\'authentifier',
        'Lost your password?' => 'Mot de passe oubli ?',
        'Request new password' => 'Demande de nouveau mot de passe',
        'Create Account' => 'Crer un compte',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Bienvenue %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Fois',
        'No time settings.' => 'Pas de paramtre de temps',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Cliquer ici pour signaler une anomalie!',

        # Template: Footer
        'Top of Page' => 'Haut de page',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Accueil',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Installeur Web',
        'Welcome to %s' => 'Bienvenue dans %s',
        'Accept license' => 'Accepter la licence',
        'Don\'t accept license' => 'Ne pas accepter la licence',
        'Admin-User' => 'Administrateur',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Admin-Password' => 'Mot de passe de l\'administrateur',
        'Database-User' => 'Nom de l\'utilisateur de la base de donne',
        'default \'hot\'' => 'hte par dfaut',
        'DB connect host' => 'Nom d\'hte de la base de donne',
        'Database' => 'Base de donne',
        'Default Charset' => 'Charset par dfaut',
        'utf8' => 'UTF-8',
        'false' => 'faux',
        'SystemID' => 'ID Systme',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(L\'identit du systme. Chaque numro de ticket et chaque id de session http commence avec ce nombre)',
        'System FQDN' => 'Nom de Domaine complet du systme',
        '(Full qualified domain name of your system)' => '(Nom de domaine complet de votre machine)',
        'AdminEmail' => 'Courriel de l\'administrateur.',
        '(Email of the system admin)' => '(Adresse de l\'administrateur systme)',
        'Organization' => 'Socit',
        'Log' => 'Log',
        'LogModule' => 'Module de log',
        '(Used log backend)' => '(Backend de log utilis)',
        'Logfile' => 'fichier de log',
        '(Logfile just needed for File-LogModule!)' => '(fichier de log ncessaire pour le Module File-Log !)',
        'Webfrontend' => 'Frontal web',
        'Use utf-8 it your database supports it!' => 'Utilisez UTF-8 si votre base de donne le supporte !',
        'Default Language' => 'Langage par dfaut ',
        '(Used default language)' => '(Langage par dfaut utilis)',
        'CheckMXRecord' => 'Vrifier les enregistrements MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Verifie les enregistrements MX des adresses lectroniques utilises lors de la rdaction d\'une rponse. N\'utilisez pas la "Vrification des enregistrements MX" si votre serveur OTRS est derrire une ligne modem $!',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Pour pouvoir utiliser OTRS, vous devez entrer les commandes suivantes dans votre terminal en tant que root.',
        'Restart your webserver' => 'Redmarrer votre serveur web',
        'After doing so your OTRS is up and running.' => 'Aprs avoir fait ceci votre OTRS est en service',
        'Start page' => 'Page de dmarrage',
        'Your OTRS Team' => 'Votre quipe OTRS',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Pas d\'autorisation',

        # Template: Notify
        'Important' => 'Important',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'Imprim par :',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: Test
        'OTRS Test Page' => 'Page de test d\'OTRS',
        'Counter' => 'Compteur',

        # Template: Warning

        # Misc
        'Edit Article' => 'diter l\'article',
        'Create Database' => 'Crer la base de donnes',
        'DB Host' => 'Nom d\'hte de la base',
        'Change roles <-> groups settings' => 'Changer les rles <-> paramtres des groupes',
        'Ticket Number Generator' => 'Gnrateur de numro pour les tickets',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiant des tickets. Certaines personnes veulent le configurer avec par ex: \'Ticket#\', \'Appel#\' ou \'MonTicket#\')',
        'Create new Phone Ticket' => 'Saisie d\'une demande tlphonique',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Dans ce cas vous pouvez directement diter le trousseau de cl dans Kernel/Config.pm',
        'Symptom' => 'Symptme',
        'U' => 'A-Z',
        'Site' => 'Site',
        'Customer history search (e. g. "ID342425").' => 'Recherche dans l\'historique client (ex: "ID342425")',
        'Can not delete link with %s!' => 'Impossible d\'effacer le lien avec %s !',
        'for agent firstname' => 'pour le prnom du technicien',
        'Close!' => 'Clture!',
        'No means, send agent and customer notifications on changes.' => 'Non signifie : Envoyer un mail au technicien et au client sur changement.',
        'A web calendar' => 'Un calendrier Web',
        'to get the realname of the sender (if given)' => 'pour avoir le nom rel de l\'utilisateur (s\il est donn)',
        'FAQ Search Result' => 'Rsultat de la recherche dans la FAQ',
        'OTRS DB Name' => 'Nom de la base OTRS',
        'Notification (Customer)' => 'Notification (Client)',
        'FAQ Category' => 'Catgorie dans la FAQ',
        'Select Source (for add)' => 'Slectionnez une source (pour ajout)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Options des donnes du ticket (ex: &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Child-Object' => 'Objet Enfant',
        'New FAQ Article' => '(FAQ) Nouvel article',
        'Days' => 'Jours',
        'Queue ID' => 'Identifiant de la File',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Options de configuration (ex: <OTRS_CONFIG_HttpType>)',
        'System History' => 'Historique du systme',
        'FAQ System History' => 'Historique systme de la FAQ',
        'customer realname' => 'nom rel du client',
        'Pending messages' => 'Message en attente',
        'Modules' => 'Modules',
        'for agent login' => 'pour le nom de connexion (login) du technicien',
        'Keyword' => 'Mot cl',
        'Close type' => 'Type de clture',
        'FAQ-Article' => '(FAQ) Article',
        'DB Admin User' => 'nom de connexion de l\'administrateur base de donne',
        'for agent user id' => 'pour l\'identifiant du technicien',
        'Change user <-> group settings' => 'Modifier les paramtres utilisateurs <-> groupes',
        'FAQ-Area' => 'Foire Aux Questions',
        'Problem' => 'Problme',
        'Escalation' => 'Remonte',
        '"}' => '"}',
        'Order' => 'Ordre',
        'next step' => 'tape suivante',
        'Follow up' => 'Note',
        'Customer history search' => 'Recherche dans l\'historique client',
        'Admin-Email' => 'Email de l\'administrateur',
        'Stat#' => '',
        'Create new database' => 'Crer une nouvelle base de donnes',
        'FAQ Language' => 'Langue dans la FAQ',
        'ArticleID' => 'Identifiant de l\'Article',
        'Go' => 'Valider',
        'Keywords' => 'Mots cls',
        'Ticket Escalation View' => 'Vue des remontes du ticket',
        'Today' => 'Aujourd\'hui',
        'No * possible!' => 'Pas de * possible !',
        'Options ' => 'Options',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Options ',
        'Message for new Owner' => 'Message pour le nouveau propritaire',
        'to get the first 5 lines of the email' => 'pour avoir les 5 premires lignes du mail',
        'Sort by' => 'Trier par',
        'OTRS DB Password' => 'Mot de passe de la base OTRS',
        'Last update' => 'Dernire mise  jour',
        'Tomorrow' => 'Demain',
        'to get the first 20 character of the subject' => 'pour avoir les 20 premiers caractres du sujet ',
        'Select the customeruser:service relations.' => '',
        'DB Admin Password' => 'Mot de passe administrateur base de donnes',
        'Advisory' => 'Avertissement',
        'Drop Database' => 'Effacer la base de donnes',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',
        'FileManager' => 'Gestionnaire de fichiers',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Options concernant les donnes du client actuel (ex: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'Type d\'attente',
        'Comment (internal)' => 'Commentaire interne',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Options du propritaire du ticket (ex: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'FAQ-Search' => '(FAQ) Rechercher',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Options des donnes du ticket (ex: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(Format numrique utilis pour les tickets)',
        'Reminder' => 'Rappel',
        'OTRS DB connect host' => 'Hte de la base OTRS',
        ' (work units)' => ' Unit de travail',
        'Next Week' => 'La semaine prochaine',
        'All Customer variables like defined in config option CustomerUser.' => 'Toutes les variables client tels que dfinies dans les options "Client utilisateur"',
        'accept license' => 'Accepter la licence',
        'for agent lastname' => 'pour le nom du technicien',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Options concernant l\'utilisateur actuel ayant effectu cet action (ex: <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Message de rappel',
        'Change users <-> roles settings' => 'Changement d\'utilisateur <-> parramttres des rles',
        'Parent-Object' => 'Objet Parent',
        'Of couse this feature will take some system performance it self!' => 'Bien videmment, cette fonction consomme des ressources systme',
        'Your own Ticket' => 'Votre propre ticket',
        'Detail' => 'Dtail',
        'TicketZoom' => 'Vue en dtails',
        'Open Tickets' => 'Tickets ouverts',
        'Don\'t forget to add a new user to groups!' => 'Ne pas oublier d\'ajouter un nouvel utilisateur aux groupes !',
        'CreateTicket' => 'Crer Ticket',
        'You have to select two or more attributes from the select field!' => 'Vous avez slectionn deux attributs ou plus !',
        'System Settings' => 'Paramtres Systme',
        'WebWatcher' => 'WebWatcher',
        'Hours' => 'Heures',
        'Finished' => 'Fini',
        'Account Type' => 'Type de compte',
        'D' => 'Z-A',
        'System Status' => 'tat du systme',
        'All messages' => 'Tous les messages',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Options des donnes du ticket (ex: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Object already linked as %s.' => 'Objet dj li en tant que %s',
        'A article should have a title!' => 'Un article doit avoir un titre',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Options de configuration (ex: &lt;OTRS_CONFIG_HttpType&gt;)',
        'FAQ Overview' => 'Vue d\'ensemble de la FAQ',
        'don\'t accept license' => 'Ne pas accepter la licence',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'A web mail client' => 'Un logiciel de messagerie via le web',
        'Compose Follow up' => 'Fermer le suivi',
        'FAQ-State' => 'tat FAQ',
        'WebMail' => 'Webmail',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Options des donnes du ticket (ex: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Options du propritaire d\'un ticket (ex: <OTRS_OWNER_UserFirstname>)',
        'FAQ Search' => 'Chercher dans la FAQ',
        'DB Type' => 'Type de SGBD',
        'Termin1' => 'Termin1',
        'kill all sessions' => 'Terminer toutes les sessions',
        'to get the from line of the email' => 'pour avoir les lignes \'De\' du courriel',
        'Solution' => 'Solution',
        'QueueView' => 'Vue file',
        'Select Box' => 'Requte SQL libre.',
        'New messages' => 'Nouveaux messages',
        'Can not create link with %s!' => 'Impossible de crer un lien avec %s !',
        'Linked as' => 'Lie en tant que',
        'Welcome to OTRS' => 'Bienvenue dans OTRS',
        'modified' => 'modifi',
        'Delete old database' => 'Effacer l\'ancienne base de donnes',
        'A web file manager' => 'Un gestionnaire de fichier via le web',
        'Have a lot of fun!' => 'Amusez vous bien !',
        'send' => 'envoyer',
        'Send no notifications' => 'Ne pas envoyer de notifications',
        'Note Text' => 'Note',
        'POP3 Account Management' => 'Gestion du compte POP3',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Options des donnes du client actuel (ex:  &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'System State Management' => 'Gestion des tats du systme',
        'OTRS DB User' => 'Utilisateur de la base OTRS',
        'Mailbox' => 'Boite aux lettres',
        'PhoneView' => 'Vue tlphone',
        'maximal period form' => 'Formulaire de dure maximum',
        'TicketID' => 'Identifiant du Ticket',
        'Escaladed Tickets' => 'Tickets escalads',
        'Yes means, send no agent and customer notifications on changes.' => 'Oui signifie : ne rien envoyer sur changement au technicien et au client.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Votre message concernant le ticket numro "<OTRS_TICKET> est rmis  "<OTRS_BOUNCE_TO>". Contactez cette adresse pour de plus amples renseignements',
        'FAQ History' => 'Historique de la FAQ',
        'Ticket Status View' => 'Vue de l\'tat du ticket',
        'Modified' => 'Modifi',
        'Ticket selected for bulk action!' => 'Ticket slectionn pour une action groupe!',
    };

    # $$STOP$$
    return;
}

1;
