# --
# Kernel/Language/pl.pm - provides pl language translation
# Copyright (C) 2007 Tomasz Melissa <janek at rumianek.com>
# Copyright (C) 2009 Artur Skalski <skal.ar at wp.pl>
# --
# $Id: pl.pm,v 1.82 2009/07/13 09:49:47 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::pl;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.82 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Thu Jul  9 03:58:03 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Tak',
        'No' => 'Nie',
        'yes' => 'tak',
        'no' => 'nie',
        'Off' => 'Wyczone',
        'off' => 'wyczone',
        'On' => 'Wczone',
        'on' => 'wczone',
        'top' => 'gra',
        'end' => 'koniec',
        'Done' => 'Zrobione',
        'Cancel' => 'Anuluj',
        'Reset' => 'Resetuj',
        'last' => 'ostatnie',
        'before' => 'przedtem',
        'day' => 'dzie',
        'days' => 'dni',
        'day(s)' => 'dzie(dni)',
        'hour' => 'godzina',
        'hours' => 'godz.',
        'hour(s)' => 'godz.',
        'minute' => 'minuta',
        'minutes' => 'minut',
        'minute(s)' => 'minuta(minut)',
        'month' => 'miesic',
        'months' => 'miesicy',
        'month(s)' => 'miesic(-cy)',
        'week' => 'tydzie',
        'week(s)' => 'tydzie(tygodnie)',
        'year' => 'rok',
        'years' => 'lat',
        'year(s)' => 'rok(lat)',
        'second(s)' => 'sekund(a)',
        'seconds' => 'sekund',
        'second' => 'drugi',
        'wrote' => 'napisa',
        'Message' => 'Wiadomo',
        'Error' => 'Bd',
        'Bug Report' => 'Zgo bd',
        'Attention' => 'Uwaga',
        'Warning' => 'Ostrzeenie',
        'Module' => 'Modu',
        'Modulefile' => 'Plik Moduu',
        'Subfunction' => 'Funkcja podrzdna',
        'Line' => 'Linia',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'Przykad',
        'Examples' => 'Przykady',
        'valid' => 'Poprawne',
        'invalid' => 'Niewane',
        '* invalid' => '* Niewane',
        'invalid-temporarily' => 'Czasowo niewane',
        ' 2 minutes' => ' 2 Minuty',
        ' 5 minutes' => ' 5 Minut',
        ' 7 minutes' => ' 7 Minut',
        '10 minutes' => '10 Minut',
        '15 minutes' => '15 Minut',
        'Mr.' => 'Pan',
        'Mrs.' => 'Pani',
        'Next' => 'Dalej',
        'Back' => 'Powrt',
        'Next...' => 'Dalej...',
        '...Back' => '...Powrt',
        '-none-' => '-brak-',
        'none' => 'brak danych',
        'none!' => 'brak!',
        'none - answered' => 'brak - odpowiedziane',
        'please do not edit!' => 'nie edytowa!',
        'AddLink' => 'Dodaj link',
        'Link' => 'Pocz',
        'Unlink' => 'Rozcz',
        'Linked' => 'Poczone',
        'Link (Normal)' => 'Poczone (rwnorzdnie)',
        'Link (Parent)' => 'Poczone (Rodzic)',
        'Link (Child)' => 'Poczone (Potomek)',
        'Normal' => 'Normalne',
        'Parent' => 'Rodzic',
        'Child' => 'Potomek',
        'Hit' => 'Odsona',
        'Hits' => 'Odson',
        'Text' => 'Tre',
        'Lite' => 'Lekkie',
        'User' => 'Uytkownik',
        'Username' => 'Nazwa uytkownika',
        'Language' => 'Jzyk',
        'Languages' => 'Jzyki',
        'Password' => 'Haso',
        'Salutation' => 'Zwrot grzecznociowy',
        'Signature' => 'Podpis',
        'Customer' => 'Klient',
        'CustomerID' => 'ID klienta',
        'CustomerIDs' => 'IDs Klienta',
        'customer' => 'klient',
        'agent' => 'agent',
        'system' => 'System',
        'Customer Info' => 'Informacja o kliencie',
        'Customer Company' => 'Firma klienta',
        'Company' => 'Firma',
        'go!' => 'Start!',
        'go' => 'Start',
        'All' => 'Wszystkie',
        'all' => 'wszystkie',
        'Sorry' => 'Przykro mi',
        'update!' => 'uaktualnij!',
        'update' => 'uaktualnij',
        'Update' => 'Uaktualnij',
        'Updated!' => 'Uaktualniono!',
        'submit!' => 'akceptuj!',
        'submit' => 'akceptuj',
        'Submit' => 'Akceptuj',
        'change!' => 'Zmie!',
        'Change' => 'Zmie',
        'change' => 'zmie',
        'click here' => 'kliknij tutaj',
        'Comment' => 'Komentarz',
        'Valid' => 'Poprawne',
        'Invalid Option!' => 'Bdna opcja!',
        'Invalid time!' => 'Bdny czas!',
        'Invalid date!' => 'Bedna data!',
        'Name' => 'Nazwa',
        'Group' => 'Grupa',
        'Description' => 'Opis',
        'description' => 'opis',
        'Theme' => 'Schemat',
        'Created' => 'Utworzone',
        'Created by' => 'Utworzone przez',
        'Changed' => 'Zmienione',
        'Changed by' => 'Zmienione przez',
        'Search' => 'Szukaj',
        'and' => 'i',
        'between' => 'pomidzy',
        'Fulltext Search' => 'Wyszukiwanie penotekstowe',
        'Data' => 'Data',
        'Options' => 'Opcje',
        'Title' => 'Tytu',
        'Item' => 'Pozycja',
        'Delete' => 'Kasuj',
        'Edit' => 'Edytuj',
        'View' => 'Widok',
        'Number' => 'Liczba',
        'System' => 'System',
        'Contact' => 'Kontakt',
        'Contacts' => 'Kontakty',
        'Export' => 'Eksport',
        'Up' => 'Gra',
        'Down' => 'D',
        'Add' => 'Dodaj',
        'Added!' => 'Dodano!',
        'Category' => 'Kategoria',
        'Viewer' => 'Przegldarka',
        'Expand' => '',
        'New message' => 'Nowa wiadomo',
        'New message!' => 'Nowa wiadomo!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosz odpowiedz na to zgoszenie, by mc powroci do zwykego widoku kolejki zgosze!',
        'You got new message!' => 'Masz now wiadomo!',
        'You have %s new message(s)!' => 'Masz %s nowych wiadomoci!',
        'You have %s reminder ticket(s)!' => 'Masz %s przypomnie o zgoszeniach!',
        'The recommended charset for your language is %s!' => 'Sugerowane kodowanie dla Twojego jzyka to %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Hasa nie s zgodne! Sprbuj ponownie!',
        'Password is already in use! Please use an other password!' => 'Haso obecnie uywane! Wybierz inne haso!',
        'Password is already used! Please use an other password!' => 'Haso uyte! Wybierz inne haso!',
        'You need to activate %s first to use it!' => 'Musisz aktywowa %s przed uyciem!',
        'No suggestions' => 'Brak podpowiedzi',
        'Word' => 'Sowo',
        'Ignore' => 'Ignoruj',
        'replace with' => 'zamie z',
        'There is no account with that login name.' => 'Nie istnieje konto z takim loginem.',
        'Login failed! Your username or password was entered incorrectly.' => 'Logowanie niepoprawne! Twj login lub haso zostay wpisane niepoprawnie.',
        'Please contact your admin' => 'Skontaktuj si z Administratorem',
        'Logout successful. Thank you for using OTRS!' => 'Wylogowanie zakoczone! Dzikujemy za uywanie OTRS!',
        'Invalid SessionID!' => 'Niepoprawne ID Sesji!',
        'Feature not active!' => 'Funkcja nie aktywna!',
        'Notification (Event)' => '',
        'Login is needed!' => 'Wymagane zalogowanie!',
        'Password is needed!' => 'Haso jest wymagane!',
        'License' => 'Licencja',
        'Take this Customer' => 'Uyj tego klienta!',
        'Take this User' => 'Uyj tego uytkownika',
        'possible' => 'moliwe',
        'reject' => 'odrzu',
        'reverse' => 'odwr',
        'Facility' => 'Uatwienie',
        'Timeover' => 'Przekroczenie czasu',
        'Pending till' => 'Oczekuje do',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Nie uywaj uytkownika z UserID 1 (Konto systemowe)! Stwrz nowych uytkownikw!',
        'Dispatching by email To: field.' => 'Przekazywanie na podstawie pola DO:',
        'Dispatching by selected Queue.' => 'Przekazywanie na podstawie zaznaczonej kolejki.',
        'No entry found!' => 'Nic nie odnaleziono!',
        'Session has timed out. Please log in again.' => 'Sesja wygasa. Zaloguj si ponownie',
        'No Permission!' => 'Brak uprawnie',
        'To: (%s) replaced with database email!' => 'DO: (%s) zamienione z adresem email z bazy danych',
        'Cc: (%s) added database email!' => 'Cc: (%s) zamienione z adresem email z bazy danych',
        '(Click here to add)' => '(By doda kliknij tutaj)',
        'Preview' => 'Podgld',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Pakiet niewaciwie zainstalowany! Naley reinstalowa pakiet!',
        'Added User "%s"' => 'Dodano uytkownika "%s"',
        'Contract' => 'Umowa',
        'Online Customer: %s' => 'Klient zalogowany: %s',
        'Online Agent: %s' => 'Agent zalogowany: %s',
        'Calendar' => 'Kalendarz',
        'File' => 'Plik',
        'Filename' => 'Nazwa pliku',
        'Type' => 'Typ',
        'Size' => 'Rozmiar',
        'Upload' => 'Wysyanie',
        'Directory' => 'Katalog',
        'Signed' => 'Podpisany',
        'Sign' => 'Podpis',
        'Crypted' => 'Zaszyfrowany',
        'Crypt' => 'Szyfr',
        'Office' => 'Biuro',
        'Phone' => 'Tel.',
        'Fax' => 'Fax',
        'Mobile' => 'Tel. komrkowy',
        'Zip' => 'Kod',
        'City' => 'Miasto',
        'Street' => 'Ulica',
        'Country' => 'Kraj',
        'Location' => 'Miejsce',
        'installed' => 'zainstalowany',
        'uninstalled' => 'odinstalowany',
        'Security Note: You should activate %s because application is already running!' => 'Nota bezpieczestwa: Naley aktywowa %s poniewa aplikacja jest uruchomiona!',
        'Unable to parse Online Repository index document!' => 'Niedostpne repozytorium on-line',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Brak pakietw dla uywanej wersji Frameworka w tym repozytorium, ale s pakiety dla innych wersji!',
        'No Packages or no new Packages in selected Online Repository!' => 'Brak pakietw lub brak nowych pakietw w wybranym repozytorium!',
        'printed at' => 'wydrukowano',
        'Dear Mr. %s,' => 'Drogi Panie %s,',
        'Dear Mrs. %s,' => 'Droga Pani %s,',
        'Dear %s,' => 'Drogi %s,',
        'Hello %s,' => 'Witaj %s,',
        'This account exists.' => 'Konto istnieje.',
        'New account created. Sent Login-Account to %s.' => 'Utworzono konto. Wysano login do %s.',
        'Please press Back and try again.' => 'Prosze wybrac Cofnij i sprbowac ponownie.',
        'Sent password token to: %s' => 'Wysano token hasa do: %s',
        'Sent new password to: %s' => 'Wysano nowe haso do: %s',
        'Upcoming Events' => '',
        'Event' => 'Zdarzenie',
        'Events' => '',
        'Invalid Token!' => 'Bdny token!',
        'more' => '',
        'For more info see:' => '',
        'Package verification failed!' => '',
        'Collapse' => '',
        'News' => '',
        'Product News' => '',
        'OTRS News' => '',
        '7 Day Stats' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Header' => '',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'Sty',
        'Feb' => 'Lut',
        'Mar' => 'Mar',
        'Apr' => 'Kwi',
        'May' => 'Maj',
        'Jun' => 'Cze',
        'Jul' => 'Lip',
        'Aug' => 'Sie',
        'Sep' => 'Wrz',
        'Oct' => 'Pa',
        'Nov' => 'Lis',
        'Dec' => 'Gru',
        'January' => 'Stycze',
        'February' => 'Luty',
        'March' => 'Marzec',
        'April' => 'Kwiecie',
        'June' => 'Czerwiec',
        'July' => 'Lipiec',
        'August' => 'Sierpie',
        'September' => 'Wrzesie',
        'October' => 'Padziernik',
        'November' => 'Listopad',
        'December' => 'Grudzie',

        # Template: AAANavBar
        'Admin-Area' => 'Administracja',
        'Agent-Area' => 'Obsuga',
        'Ticket-Area' => 'Zgoszenia',
        'Logout' => 'Wyloguj',
        'Agent Preferences' => 'Ustawienia agenta',
        'Preferences' => 'Ustawienia',
        'Agent Mailbox' => 'Poczta',
        'Stats' => 'Statystyki',
        'Stats-Area' => 'Staystyki',
        'Admin' => 'Administracja',
        'Customer Users' => 'Klienci',
        'Customer Users <-> Groups' => 'Klienci <-> Grupy',
        'Users <-> Groups' => 'Uytkownicy <-> Grupy',
        'Roles' => 'Role',
        'Roles <-> Users' => 'Role <-> Uytkownicy',
        'Roles <-> Groups' => 'Role <-> Grupy',
        'Salutations' => 'Powitania',
        'Signatures' => 'Podpisy',
        'Email Addresses' => 'Adresy e-mail',
        'Notifications' => 'Powiadomienia',
        'Category Tree' => 'Drzewo kategorii',
        'Admin Notification' => 'Powiadomienia administratora',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Ustawienia zapisano pomylnie!',
        'Mail Management' => 'Zarzdzanie poczt',
        'Frontend' => 'Interfejs',
        'Other Options' => 'Inne opcje',
        'Change Password' => 'Zmie haso',
        'New password' => 'Nowe haso',
        'New password again' => 'Ponownie nowe haso',
        'Select your QueueView refresh time.' => 'Wybierz okres odwierzania Podgldu Kolejki.',
        'Select your frontend language.' => 'Wybierz jzyk.',
        'Select your frontend Charset.' => 'Wybierz kodowanie.',
        'Select your frontend Theme.' => 'Wybierz schemat wygldu systemu.',
        'Select your frontend QueueView.' => 'Wybierz Podgld Kolejki.',
        'Spelling Dictionary' => 'Sownik pisowni',
        'Select your default spelling dictionary.' => 'Wybierz domylny sownik.',
        'Max. shown Tickets a page in Overview.' => 'Limit pokazywanych zgosze na stronie Podsumowania',
        'Can\'t update password, your new passwords do not match! Please try again!' => '',
        'Can\'t update password, invalid characters!' => 'Nie mona zmieni hasa, niedozwolone znaki!',
        'Can\'t update password, must be at least %s characters!' => '',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => '',
        'Can\'t update password, needs at least 1 digit!' => '',
        'Can\'t update password, needs at least 2 characters!' => '',

        # Template: AAAStats
        'Stat' => 'Statystyki',
        'Please fill out the required fields!' => 'Wypenij wymagane pola!',
        'Please select a file!' => 'Wybierz plik!',
        'Please select an object!' => 'Wybierz obiekt!',
        'Please select a graph size!' => 'Wybierz rozmiar wykresu!',
        'Please select one element for the X-axis!' => 'Wybierz element dla osi X!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Wybierz tylko jeden element lyb wycz klawisz\'Stae\' przy zaznaczonym polu!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Po zaznaczeniu pola wyboru musisz wskaza atrybuty wybranego pola!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Wprowad warto w wybrane pole lub odznacz pole \'Stay\'!',
        'The selected end time is before the start time!' => 'Czas zakoczenia wczeniejszy od czasu rozpoczcia!',
        'You have to select one or more attributes from the select field!' => 'Wska jeden lub wicej atrybut z pola wyboru!',
        'The selected Date isn\'t valid!' => 'Wybrana data jest nieprawidowa!',
        'Please select only one or two elements via the checkbox!' => 'Zaznacz tylko jeden lub dwa pola wyboru!',
        'If you use a time scale element you can only select one element!' => 'Jeeli uywasz skalowania czasu moesz wybra tylko jeden element!',
        'You have an error in your time selection!' => 'Bd w wyborze czasu!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Wybrany zakres czasu jest za may, uyj wikszej skali czasu!',
        'The selected start time is before the allowed start time!' => 'Wybrany czas pocztku jest przed dozwolonym czasem rozpoczcia!',
        'The selected end time is after the allowed end time!' => 'Wybrany czas koca przekracza dopuszczalny czas zakoczenia!',
        'The selected time period is larger than the allowed time period!' => 'Wybrany zakres czasu przekracza maksymalny dopuszczalny!',
        'Common Specification' => 'Podstawowa specyfikacja',
        'Xaxis' => 'O X',
        'Value Series' => 'Serie wartoci',
        'Restrictions' => 'Ograniczenia',
        'graph-lines' => 'wykres-linie',
        'graph-bars' => 'wykres-supki',
        'graph-hbars' => 'wykres-supki poziome',
        'graph-points' => 'wykres-punkty',
        'graph-lines-points' => 'wykres- linie i punkty',
        'graph-area' => 'obszar wykresu',
        'graph-pie' => 'wykres-koowy',
        'extended' => 'rozszerzony',
        'Agent/Owner' => 'Obsugujcy/Waciciel',
        'Created by Agent/Owner' => 'Utworzony przez Obsugujcego/Waciciela',
        'Created Priority' => 'Utworzony prirytet',
        'Created State' => 'Utworzony status',
        'Create Time' => 'Czas utworzenia',
        'CustomerUserLogin' => 'Login klienta',
        'Close Time' => 'Czas zamknicia',
        'TicketAccumulation' => '',
        'Attributes to be printed' => '',
        'Sort sequence' => '',
        'Order by' => '',
        'Limit' => '',
        'Ticketlist' => '',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '',
        'Total Time' => '',
        'Ticket Average' => '',
        'Ticket Min Time' => '',
        'Ticket Max Time' => '',
        'Number of Tickets' => '',
        'Article Average' => '',
        'Article Min Time' => '',
        'Article Max Time' => '',
        'Number of Articles' => '',
        'Accounted time by Agent' => '',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => '',
        'Ticket Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Zablokuj',
        'Unlock' => 'Odblokuj',
        'History' => 'Historia',
        'Zoom' => 'Podgld',
        'Age' => 'Wiek',
        'Bounce' => 'Odbij',
        'Forward' => 'Przelij dalej',
        'From' => 'Od',
        'To' => 'Do',
        'Cc' => 'Cc',
        'Bcc' => 'Bcc',
        'Subject' => 'Temat',
        'Move' => 'Przesu',
        'Queue' => 'Kolejka',
        'Priority' => 'Priorytet',
        'Priority Update' => 'Aktualizacja priorytetu',
        'State' => 'Status',
        'Compose' => 'Stwrz',
        'Pending' => 'Oczekujce',
        'Owner' => 'Waciciel',
        'Owner Update' => 'Aktualizacja wasciciela',
        'Responsible' => 'Odpowiedzialny',
        'Responsible Update' => 'Aktualizacja odpowiedzialnego',
        'Sender' => 'Nadawca',
        'Article' => 'Artyku',
        'Ticket' => 'Zgoszenie',
        'Createtime' => 'Utworzone o',
        'plain' => 'bez formatowania',
        'Email' => 'E-Mail',
        'email' => 'e-mail',
        'Close' => 'Zamknij',
        'Action' => 'Akcja',
        'Attachment' => 'Zacznik',
        'Attachments' => 'Zaczniki',
        'This message was written in a character set other than your own.' => 'Ta wiadomo zostaa napisana z uyciem kodowania znakw innego ni Twj.',
        'If it is not displayed correctly,' => 'Jeli nie jest wywietlane poprawnie,',
        'This is a' => 'To jest',
        'to open it in a new window.' => 'by otworzy w oddzielnym oknie',
        'This is a HTML email. Click here to show it.' => 'To jest e-mail w formacie HTML. Kliknij tutaj, by go przeczyta.',
        'Free Fields' => 'Wolne pola',
        'Merge' => 'Scalaj',
        'merged' => 'scalone',
        'closed successful' => 'zamknite z powodzeniem',
        'closed unsuccessful' => 'zamknite bez powodzenia',
        'new' => 'nowe',
        'open' => 'otwarte',
        'Open' => '',
        'closed' => 'zamknite',
        'Closed' => '',
        'removed' => 'usunite',
        'pending reminder' => 'oczekujce przypomnienie',
        'pending auto' => 'oczekujce auto',
        'pending auto close+' => 'oczekujce na automatyczne zamknicie+',
        'pending auto close-' => 'oczekujce na automatyczne zamknicie-',
        'email-external' => 'e-mail zewntrzny',
        'email-internal' => 'e-mail wewntrzny',
        'note-external' => 'Notatka zewntrzna',
        'note-internal' => 'Notatka wewntrzna',
        'note-report' => 'Notatka raportujaca',
        'phone' => 'telefon',
        'sms' => 'SMS',
        'webrequest' => 'zgoszenie WWW',
        'lock' => 'zablokuj',
        'unlock' => 'odblokuj',
        'very low' => 'bardzo niski',
        'low' => 'niski',
        'normal' => 'normalny',
        'high' => 'wysoki',
        'very high' => 'bardzo wysoki',
        '1 very low' => '1 bardzo niski',
        '2 low' => '2 niski',
        '3 normal' => '3 normalny',
        '4 high' => '4 wysoki',
        '5 very high' => '5 bardzo wysoki',
        'Ticket "%s" created!' => 'Zgoszenie "%s" utworzone!',
        'Ticket Number' => 'Numer zgoszenia',
        'Ticket Object' => 'Obiekt zgoszenia',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Nie znaleziono zgoszenia numer "%s"! Nie mozna poczy!',
        'Don\'t show closed Tickets' => 'Nie pokazuj zamknitych zgosze',
        'Show closed Tickets' => 'Poka zamknite zgoszenia',
        'New Article' => 'Nowy artyku',
        'Email-Ticket' => 'Zgoszenie e-mail',
        'Create new Email Ticket' => 'Utwrz nowe zgoszenie e-mail',
        'Phone-Ticket' => 'Zgoszenie telefoniczne',
        'Search Tickets' => 'Szukaj zgosze',
        'Edit Customer Users' => 'Edycja klientw',
        'Edit Customer Company' => 'Edycja firm',
        'Bulk Action' => '',
        'Bulk Actions on Tickets' => 'Akcja grupowa na zgoszeniach',
        'Send Email and create a new Ticket' => 'Wylij e-mail i utwrz nowe zgoszenie',
        'Create new Email Ticket and send this out (Outbound)' => 'Utwrz nowe zgoszenie e-mail i wylij (wychodzce)',
        'Create new Phone Ticket (Inbound)' => 'Utwrz zgoszenie telefoniczne (przychodzce)',
        'Overview of all open Tickets' => 'Przegld otwartych zgosze',
        'Locked Tickets' => 'Zablokowane zgoszenia',
        'Watched Tickets' => 'Obserwowane zgoszenia',
        'Watched' => 'Obserwowane',
        'Subscribe' => 'Zapisz',
        'Unsubscribe' => 'Wypisz',
        'Lock it to work on it!' => 'Zablokuj w celu obsugi',
        'Unlock to give it back to the queue!' => 'Odblokuj i skieruj do kolejki!',
        'Shows the ticket history!' => 'Poka histori zgoszenia!',
        'Print this ticket!' => 'Wydrukuj zgoszenie!',
        'Change the ticket priority!' => 'Zmie priorytet zgoszenia!',
        'Change the ticket free fields!' => 'Zmie wolne pola zgoszenia!',
        'Link this ticket to an other objects!' => 'Pocz zgoszenie z innym!',
        'Change the ticket owner!' => 'Zmie waciciela zgoszenia!',
        'Change the ticket customer!' => 'Zmie klienta zgoszenia!',
        'Add a note to this ticket!' => 'Dodaj notatk do zgoszenia!',
        'Merge this ticket!' => 'Docz zgoszenie!',
        'Set this ticket to pending!' => 'Ustaw zgoszenie jako oczekujce!',
        'Close this ticket!' => 'Zamknij zgoszenie!',
        'Look into a ticket!' => 'Szczegy zgoszenia!',
        'Delete this ticket!' => 'Usu zgoszenie!',
        'Mark as Spam!' => 'Oznacz jako spam!',
        'My Queues' => 'Moje kolejki',
        'Shown Tickets' => 'Poka zgoszenia',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Twoje zgoszenie o numerze "<OTRS_TICKET>" zostao doczone do "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Zgoszenie %s: czas pierwszej odpowiedzi przekroczony (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Zgoszenie %s: czas pierwszej odpowiedzi zostanie przekroczony za %s!',
        'Ticket %s: update time is over (%s)!' => 'Zgoszenie %s: czas aktualizacji przekroczony (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Zgoszenie %s: czas aktualizacji zostanie przekroczony za %s!',
        'Ticket %s: solution time is over (%s)!' => 'Zgoszenie %s: czas rozwizania przekroczony (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Zgoszenie %s: czas rozwizania zostanie przekroczony za %s!',
        'There are more escalated tickets!' => 'Wicej przeterminowanych zgosze!',
        'New ticket notification' => 'Powiadomienie o nowym zgoszeniu',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Powiadom o nowym zgoszeniu w moich kolejkach.',
        'Follow up notification' => 'Powiadomienie o odpowiedzi',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Wylij mi wiadomo, gdy klient odpowie na zgoszenie, ktrego ja jestem wacicielem.',
        'Ticket lock timeout notification' => 'Powiadomienie o przekroczonym czasie blokady zgoszenia',
        'Send me a notification if a ticket is unlocked by the system.' => 'Wylij mi wiadomo, gdy zgoszenie zostanie odblokowane przez system.',
        'Move notification' => 'Powiadomienie o przesuniciu',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Powiadom o przesuniciu do mojej kolejki',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Twj zestaw wybranych kolejek spord ulubionych. Bedziesz powiadamiany o tych kolejkach przez e-mail jeeli usug wczono.',
        'Custom Queue' => 'Kolejka modyfikowana',
        'QueueView refresh time' => 'Okres odwierzania Podgldu Kolejki',
        'Screen after new ticket' => 'Ekran po nowym zgoszeniu',
        'Select your screen after creating a new ticket.' => 'Wybierz ekran, ktry pokae si po rejestracji nowego zgoszenia',
        'Closed Tickets' => 'Zamknite zgoszenia',
        'Show closed tickets.' => 'Poka zamknite zgoszenia.',
        'Max. shown Tickets a page in QueueView.' => 'Limit pokazywanych zgosze na stronie Podgldu Kolejki',
        'Watch notification' => 'Obserwuj powiadomienia',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Wylij mi powiadomienie obserwowaych zgosze tak jak wacicielowi zgoszenia.',
        'Out Of Office' => 'Poza biurem',
        'Select your out of office time.' => 'Wybierz czas nieobecnosci',
        'CompanyTickets' => 'Zgoszenia firmy',
        'MyTickets' => 'Moje zgoszenia',
        'New Ticket' => 'Nowe zgoszenie',
        'Create new Ticket' => 'Utwrz nowe zgoszenie',
        'Customer called' => 'Telefon od klienta',
        'phone call' => 'rozmowa telefoniczna',
        'Reminder Reached' => 'Przypomnienie osignito',
        'Reminder Tickets' => '',
        'Escalated Tickets' => '',
        'New Tickets' => '',
        'Open Tickets / Need to be answered' => '',
        'Tickets which need to be answered!' => '',
        'All new tickets!' => '',
        'All tickets which are escalated!' => '',
        'All tickets where the reminder date has reached!' => '',
        'Responses' => 'Odpowiedzi',
        'Responses <-> Queue' => 'Odpowied <-> Kolejka',
        'Auto Responses' => 'Automatyczna odpowied',
        'Auto Responses <-> Queue' => 'Automatyczna odpowied <-> Kolejka',
        'Attachments <-> Responses' => 'Zaczniki <-> Odpowiedzi',
        'History::Move' => 'Zgoszenie przeniesiono do kolejki "%s" (%s) z kolejki "%s" (%s).',
        'History::TypeUpdate' => 'Zaktualizowano typ do %s (ID=%s).',
        'History::ServiceUpdate' => 'Zaktualizowano usug do %s (ID=%s).',
        'History::SLAUpdate' => 'Zaktualizowano SLA do %s (ID=%s).',
        'History::NewTicket' => 'Nowe zgoszenie [%s] utworzone (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp dla [%s]. %s',
        'History::SendAutoReject' => 'Automatyczne odrzucenie wysano do "%s".',
        'History::SendAutoReply' => 'Auto odpowied wysano do "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp wysano do "%s".',
        'History::Forward' => 'Przekazano do "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'E-mail wysano do "%s".',
        'History::SendAgentNotification' => '"%s"-powiadomienie wysano do "%s".',
        'History::SendCustomerNotification' => 'Powiadomienie wysano do "%s".',
        'History::EmailAgent' => 'E-mail wysany do klienta.',
        'History::EmailCustomer' => 'Dodano e-mail. %s',
        'History::PhoneCallAgent' => 'Agent telefonowa do klienta.',
        'History::PhoneCallCustomer' => 'klient telefonowa.',
        'History::AddNote' => 'Dodano notatk (%s)',
        'History::Lock' => 'Zablokowano zgoszenie.',
        'History::Unlock' => 'Odblokowano zgoszenie.',
        'History::TimeAccounting' => '%s jednostek czasu zliczono. Czas cakowity %s jednostek.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Zaktualizowano: %s',
        'History::PriorityUpdate' => 'Zmieniono priorytet z "%s" (%s) na "%s" (%s).',
        'History::OwnerUpdate' => 'Nowym wacicielem jest "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! Nie wyslano auto-odpowiedzi do "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Zaktualizowano: %s',
        'History::StateUpdate' => 'Stary: "%s" nowy: "%s"',
        'History::TicketFreeTextUpdate' => 'Zaktualizowano: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'danie klienta przez www.',
        'History::TicketLinkAdd' => 'Dodano cze do zgoszenia "%s".',
        'History::TicketLinkDelete' => 'Usunito acze ze zgoszenia "%s".',
        'History::Subscribe' => 'Dodano subskrypcje dla uytkownika "%s".',
        'History::Unsubscribe' => 'Usunito subskrypcje dla uytkownika "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Nie',
        'Mon' => 'Pon',
        'Tue' => 'Wt',
        'Wed' => 'r',
        'Thu' => 'Czw',
        'Fri' => 'Pi',
        'Sat' => 'Sob',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Zarzdzanie zacznikami',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Zarzdzanie automatycznymi odpowiedziami',
        'Response' => 'Odpowied',
        'Auto Response From' => 'Automatyczna odpowied Od',
        'Note' => 'Uwagi',
        'Useable options' => 'Uyteczne opcje',
        'To get the first 20 character of the subject.' => 'Poka pierwsze 20 znakw tematu.',
        'To get the first 5 lines of the email.' => 'Poka 5 linii wiadomoci e-mail.',
        'To get the realname of the sender (if given).' => 'Poka imi i nazwisko nadawcy (jeeli poda).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Atrybuty artykuu (np. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Wasnoci aktualnego klienta(np. <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Wasnoci wasciciela zgoszenia (np. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Wasnoci odpowiedzialnego agenta (np. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Wasnoci aktualnego uytkownika ktry wykona akcj (np. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Wasnoci zgoszenia (np. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Wasnoci systemu (np. <OTRS_CONFIG_HttpType>).',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Zarzdzanie firmami',
        'Search for' => 'Szukaj',
        'Add Customer Company' => 'Dodaj firm',
        'Add a new Customer Company.' => 'Dodaj now firm',
        'List' => 'Lista',
        'This values are required.' => 'Warto wymagana.',
        'This values are read only.' => 'Warto tylko do odczytu.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'Wiadomo edytowana zostaa zamknita.  Wychodz.',
        'This window must be called from compose window' => 'To okno musi zosta wywoane z okna edycji',
        'Customer User Management' => 'Zarzadzanie klientami',
        'Add Customer User' => 'Dodaj klienta',
        'Source' => 'rdo',
        'Create' => 'Utwrz',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Klient jest wymagany aby obejrze histori i zalogowa si do panelu.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Klienci <-> Grupy',
        'Change %s settings' => 'Zmie %s ustawienia',
        'Select the user:group permissions.' => 'Wybierz prawa dostpu dla uytkownika:grupy',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Jeli nic nie zaznaczono, wtedy uytkownik nie bdzie mia praw w tej grupie (zgoszenia bd niedostpne)',
        'Permission' => 'Prawo dostpu',
        'ro' => 'odczyt',
        'Read only access to the ticket in this group/queue.' => 'Prawo jedynie do odczytu zgosze w tej grupie/kolejce',
        'rw' => 'odczyt/zapis',
        'Full read and write access to the tickets in this group/queue.' => 'Prawa penego odczytu i zapisu zgosze w tej grupie/kolejce',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'Klienci <-> Usugi',
        'CustomerUser' => 'Klient',
        'Service' => 'Usuga',
        'Edit default services.' => 'Edycja domylnych usug.',
        'Search Result' => 'Wyniki wyszukiwania',
        'Allocate services to CustomerUser' => 'Przypisz usugi do klienta',
        'Active' => 'Aktywne',
        'Allocate CustomerUser to service' => 'Przypisz klienta do usugi',

        # Template: AdminEmail
        'Message sent to' => 'Wiadomo wysana do',
        'A message should have a subject!' => 'Wiadomosc powinna posiada temat!',
        'Recipents' => 'Adresaci',
        'Recipients' => 'Adresaci',
        'Body' => 'Tre',
        'Send' => 'Wylij',

        # Template: AdminGenericAgent
        'GenericAgent' => 'Agent automatyczny',
        'Job-List' => 'Lista zada',
        'Last run' => 'Ostatnie uruchomienie',
        'Run Now!' => 'Uruchom teraz',
        'x' => '',
        'Save Job as?' => 'Zapisz zadanie jako',
        'Is Job Valid?' => 'Zadanie jest wane?',
        'Is Job Valid' => 'Zadanie jest wane',
        'Schedule' => 'Harmonogram',
        'Currently this generic agent job will not run automatically.' => 'Zadanie nie zostanie uruchomione automatycznie.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Przeszukiwanie penotekstowe w artykule (np. "Ja*k" lub "Rumia*)',
        '(e. g. 10*5155 or 105658*)' => '(np. 10*5155 lub 105658*)',
        '(e. g. 234321)' => '(np. 3242442)',
        'Customer User Login' => 'Login Klienta',
        '(e. g. U5150)' => '(np. U4543)',
        'SLA' => 'SLA',
        'Agent' => 'Agent',
        'Ticket Lock' => 'Zablokowanie zgoszenia',
        'TicketFreeFields' => 'Wolne pola zgoszenia',
        'Create Times' => 'Czasy utworzenia',
        'No create time settings.' => 'Bez czasw utworzenia.',
        'Ticket created' => 'Zgoszenie utworzone',
        'Ticket created between' => 'Zgoszenie utworzone midzy',
        'Close Times' => 'Czasy zamknicia',
        'No close time settings.' => 'Bez czasw zamkniecia.',
        'Ticket closed' => 'Zgoszenie zamknite',
        'Ticket closed between' => 'Zgoszenie zamknite midzy',
        'Pending Times' => 'Czasy oczekiwania',
        'No pending time settings.' => 'Bez czasw oczekiwania.',
        'Ticket pending time reached' => 'Oczekiwanie zakoczone',
        'Ticket pending time reached between' => 'Oczekiwanie zakoczone midzy',
        'Escalation Times' => '',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - First Response Time' => 'Eskalacja - czas pierwszej odpowiedzi',
        'No escalation time settings.' => '',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - Update Time' => 'Eskalacja - czas aktualizacji',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - Solution Time' => 'Eskalacja - czas rozwizania',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'New Service' => 'Nowa usuga',
        'New SLA' => 'Nowa SLA',
        'New Priority' => 'Nowy priorytet',
        'New Queue' => 'Nowa kolejka',
        'New State' => 'Nowy status',
        'New Agent' => 'Nowy agent',
        'New Owner' => 'Nowy waciciel',
        'New Customer' => 'Nowy klient',
        'New Ticket Lock' => 'Nowa blokada zgoszenia',
        'New Type' => 'Nowy typ',
        'New Title' => 'Nowy tytu',
        'New TicketFreeFields' => 'Nowe wolne pole',
        'Add Note' => 'Dodaj notatk',
        'Time units' => 'Jednostek czasu',
        'CMD' => 'linia polece',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Komenda zostanie wykonana. ARG[0] to numer zgoszenia. ARG[1] to id zgoszenia.',
        'Delete tickets' => 'Usu zgoszenia',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Uwaga! Zgoszenia zostan usuniete z bazy danych! Zgoszenia zostan utracone!',
        'Send Notification' => 'Wylij powiadomienie',
        'Param 1' => 'Parametr 1',
        'Param 2' => 'Parametr 2',
        'Param 3' => 'Parametr 3',
        'Param 4' => 'Parametr 4',
        'Param 5' => 'Parametr 5',
        'Param 6' => 'Parametr 6',
        'Send agent/customer notifications on changes' => 'Wylij powidomienia agentowi/klientowi przy zmianie ',
        'Save' => 'Zapisz',
        '%s Tickets affected! Do you really want to use this job?' => '%s zgosze dotyczy! Chcesz wykona zadanie?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'Uwaga: Jezeli zmienisz nazw grupy \'admin\', przed wykonaniem waciwych zmian w SysConfig, zablokujesz panel administratorw! Jeeli to nastpi, przywr nazw grupy admin z uyciem SQL.',
        'Group Management' => 'Zarzdzanie grupami',
        'Add Group' => 'Dodaj grup',
        'Add a new Group.' => 'Dodaj now grup',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Grupa Admin pozwala posiada prawa Administracji systemem. Grupa Stats umoliwia przegldanie statystyk zgosze.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Stwrz nowe grupy, by mc efektywniej zarzdza dostpem do zgosze rnych grup ow (np. Serwisu, Sprzeday itp...).',
        'It\'s useful for ASP solutions.' => 'Pomocne w rozwizanich ASP.',

        # Template: AdminLog
        'System Log' => 'Log Systemu',
        'Time' => 'Czas',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Zarzdzanie kontami e-mail',
        'Host' => 'Komputer',
        'Trusted' => 'Zaufane',
        'Dispatching' => 'Przekazanie',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Wszystkie przychodzce na jedno konto wiadomoci bd umieszczone w zaznacznej kolejce!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Jezeli konto jest zaufane, istniejce w chwili przybycia nagwki X-OTRS (priorytet, ...) zostan uyte! Filtr PostMaster zostanie wykonany.',

        # Template: AdminNavigationBar
        'Users' => 'Uytkownicy',
        'Groups' => 'Grupy',
        'Misc' => 'Rne',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'Konfiguracja Powiadomie',
        'Add Notification' => '',
        'Add a new Notification.' => '',
        'Name is required!' => 'Nazwa jest wymagana!',
        'Event is required!' => '',
        'A message should have a body!' => 'Wiadomo powinna zawiera jak tre!',
        'Recipient' => '',
        'Group based' => '',
        'Recipient' => '',
        'Agent based' => '',
        'Email based' => '',
        'Article Type' => '',
        'Only for ArticleCreate Event.' => '',
        'Subject match' => '',
        'Only for ArticleCreate Event.' => '',
        'Body match' => '',
        'Notifications are sent to an agent or a customer.' => 'Powiadomienia s wysyane do agenta obsugi lub klienta',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminNotificationForm
        'Notification' => 'Powiadomienie',

        # Template: AdminPackageManager
        'Package Manager' => 'Meneder pakietw',
        'Uninstall' => 'Odinstaluj',
        'Version' => 'Wersja',
        'Do you really want to uninstall this package?' => 'Czy na pewno chcesz odinstalowa ten pakiet?',
        'Reinstall' => 'Przeinstaluj',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Czy chcesz przeinstalowa pakiet (wszystkie zmiany rczne zostan utracone)?',
        'Continue' => 'Kontynuuj',
        'Install' => 'Instaluj',
        'Package' => 'Pakiet',
        'Online Repository' => 'Baza on-line',
        'Vendor' => 'Wydawca',
        'Module documentation' => 'Dokumentacja moduu',
        'Upgrade' => 'Aktualizacja',
        'Local Repository' => 'Lokalna baza',
        'Status' => 'Status',
        'Overview' => 'Podsumowanie',
        'Download' => 'Pobierz',
        'Rebuild' => 'Przebuduj',
        'ChangeLog' => 'Lista zmian',
        'Date' => 'Data',
        'Filelist' => 'Lista plikw',
        'Download file from package!' => 'Pobierz plik z pakietu!',
        'Required' => 'Wymagany',
        'PrimaryKey' => 'Klucz podstawowy',
        'AutoIncrement' => 'Zwikszaj automatycznie',
        'SQL' => 'SQL',
        'Diff' => 'Rnica',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Log wydajnosci',
        'This feature is enabled!' => 'Ta funkcja jest wczona!',
        'Just use this feature if you want to log each request.' => 'Wybierz t opcj jezeli chcesz logowa kade danie.',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => 'Wycz tutaj!',
        'This feature is disabled!' => 'Ta funkcja jest wyczona!',
        'Activating this feature might affect your system performance!' => '',
        'Enable it here!' => 'Wcz tutaj!',
        'Logfile too large!' => 'Plik log jest za duy!',
        'Logfile too large, you need to reset it!' => 'Plik log jest za duy, naley go usun!',
        'Range' => 'Zakres',
        'Interface' => 'Interfejs',
        'Requests' => 'dania',
        'Min Response' => 'Min. odpowied',
        'Max Response' => 'Max odpowied',
        'Average Response' => 'rednia odpowied',
        'Period' => 'Okres',
        'Min' => 'Min.',
        'Max' => 'Max.',
        'Average' => 'rednia',

        # Template: AdminPGPForm
        'PGP Management' => 'Zarzdzanie PGP',
        'Result' => 'Wynik',
        'Identifier' => 'Identyfikator',
        'Bit' => 'Bit',
        'Key' => 'Klucz',
        'Fingerprint' => 'Znacznik (fingerprint)',
        'Expires' => 'Wygasa',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'W ten sposb mozesz bezporednio edytowa plik kluczy skonfigurowany w SysConfig.',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Zarzdzanie filtrami poczty',
        'Filtername' => 'Nazwa filtra',
        'Stop after match' => 'Zatrzymaj po dopasowaniu',
        'Match' => 'Odpowiada',
        'Header' => '',
        'Value' => 'Warto',
        'Set' => 'Ustaw',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Dostarcz lub filtruj przychodzce wiadomoci w oparciu o nagwki X-Headers! Wyraenia regularne (RegExp) take mog by uyte.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Jeeli chcesz tylko dopasowa adres e-mail uyj EMAILADDRESS:info@example.com w polach Od, Do lub Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Jeeli uywasz wzorcw regularnych (RegExp), moesz take uy dopasowanych wartoci w () jako [***] w \'Set\'.',

        # Template: AdminPriority
        'Priority Management' => 'Zarzdzanie priorytetami',
        'Add Priority' => 'Dodaj priorytet',
        'Add a new Priority.' => 'Dodaj nowy priorytet',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Kolejka <-> Zarzdzanie automatycznymi odpowiedziami',
        'settings' => 'ustawienia',

        # Template: AdminQueueForm
        'Queue Management' => 'Zarzadzanie kolejkami',
        'Sub-Queue of' => 'Kolejka podrzdna',
        'Unlock timeout' => 'Limit czasowy odblokowania',
        '0 = no unlock' => '0 = bez odblokowania',
        'Only business hours are counted.' => 'Tylko godziny pracy s liczone.',
        '0 = no escalation' => '0 = brak eskalacji',
        'Notify by' => 'Powiadom przez',
        'Follow up Option' => 'Opcja Follow Up',
        'Ticket lock after a follow up' => 'Zgoszenie zablokowane po odpowiedzi (Follow Up)',
        'Systemaddress' => 'Adres systemowy',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Jeli agent zablokuje zgoszenie, a nastpnie nie odpowie na nie w cigu wskazanego czasu, wtedy zgoszenie zostanie automatycznie odblokowane. Dziki temu pozostali agenci bd mogli je zobaczy.',
        'Escalation time' => 'Czas eskalacji',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Jeli, w podanym czasie, nie zostanie udzielona odpowied na zgoszenie, wtedy tylko to zgoszenie bdzie widoczne w kolejce.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Jeli zgoszenie byo zamknite, a klient przyle do niego kolejn odpowied, wtedy zgoszenie zostanie zablokowane w kolejce starego waciciela.',
        'Will be the sender address of this queue for email answers.' => 'Bdzie adresem nadawcy odpowiedzi emailowych wysyanych z tej kolejki.',
        'The salutation for email answers.' => 'Zwrot grzecznociowy dla odpowiedzi emailowych.',
        'The signature for email answers.' => 'Podpis dla odpowiedzi emailowych.',
        'Customer Move Notify' => 'Powiadomienie klienta o przesuniciu',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'System wyle powiadomienie do klienta, gdy zgoszenie zostanie przesunite do innej kolejki.',
        'Customer State Notify' => 'Powiadomienie klienta o zmianie statusu',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie status zgoszenia.',
        'Customer Owner Notify' => 'Powiadomienie klienta o zmianie waciciela',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'System wyle powiadomienie do klienta, gdy zmieni sie waciciel zgoszenia.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Odpowiedzi <-> Zarzdzanie kolejkami',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Odpowied',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Odpowiedzi <-> Zarzdzanie zacznikami',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Konfiguracja Odpowiedzi',
        'A response is default text to write faster answer (with default text) to customers.' => 'Odpowied to domylny tekst wstawiany do odpowiedzi klientowi, dziki czemu agent moe szybciej odpowiedzie na zgoszenie.',
        'Don\'t forget to add a new response a queue!' => 'Nie zapomnij powiza nowej odpowiedzi z jak kolejk!',
        'The current ticket state is' => 'Aktualny status zgoszenia to',
        'Your email address is new' => 'Ustawiono nowy adres e-mail',

        # Template: AdminRoleForm
        'Role Management' => 'Zarzdzanie rolami',
        'Add Role' => 'Dodaj rol',
        'Add a new Role.' => 'Dodaj now rol',
        'Create a role and put groups in it. Then add the role to the users.' => 'Utwrz rol i dodaj grup do niej. Potem dodaj rol do uytkownika.',
        'It\'s useful for a lot of users and groups.' => 'Uyteczne dla wielu uytkownikw i grup.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Role <-> Zarzdzanie grupami',
        'move_into' => 'przesu do',
        'Permissions to move tickets into this group/queue.' => 'Uprawnienia do przesuwania zgosze do tej grupy/kolejki',
        'create' => 'utwrz',
        'Permissions to create tickets in this group/queue.' => 'Uprawnienia do tworzenia zgosze w tej grupie/kolejce',
        'owner' => 'waciciel',
        'Permissions to change the ticket owner in this group/queue.' => 'Uprawnienia do zmiany waciciela zgoszenia w tej grupie/kolejce',
        'priority' => 'priorytet',
        'Permissions to change the ticket priority in this group/queue.' => 'Uprawnienia do zmiany priorytetu zgoszenia w tej grupie/kolejce',

        # Template: AdminRoleGroupForm
        'Role' => 'Rola',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => ' Role <-> Zarzdzanie uytkownikami',
        'Select the role:user relations.' => 'Wybierz role: relacje uytkownikw.',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Konfiguracja zwrotw grzecznociowych',
        'Add Salutation' => 'Dodaj zwrot grzecznociowy',
        'Add a new Salutation.' => 'Dodaj nowy zwrot grzecznociowy',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'Konsola SQL',
        'Limit' => '',
        'CVS' => '',
        'HTML' => '',
        'Select Box Result' => 'Wyniki Zapytania',

        # Template: AdminService
        'Service Management' => 'Konfiguracja usug',
        'Add Service' => 'Dodaj usug',
        'Add a new Service.' => 'Dodaj now usug',
        'Sub-Service of' => 'Usuga podrzdna wobec',

        # Template: AdminSession
        'Session Management' => 'Zarzdzanie sesjami',
        'Sessions' => 'Sesje',
        'Uniq' => 'Unikalne',
        'Kill all sessions' => 'Zakocz wszystkie sesje',
        'Session' => 'Sesja',
        'Content' => 'Zawarto',
        'kill session' => 'Zamknij sesj',

        # Template: AdminSignatureForm
        'Signature Management' => 'Konfiguracja podpisw',
        'Add Signature' => 'Dodaj podpis',
        'Add a new Signature.' => 'Dodaj nowy podpis',

        # Template: AdminSLA
        'SLA Management' => 'KOnfiguracja SLA',
        'Add SLA' => 'Dodaj SLA',
        'Add a new SLA.' => 'Dodaj now SLA',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'Konfiguracja S/MIME',
        'Add Certificate' => 'Dodaj certyfikat',
        'Add Private Key' => 'Dodaj klucz prywatny',
        'Secret' => 'Haso',
        'Hash' => 'Skrt (hash)',
        'In this way you can directly edit the certification and private keys in file system.' => 'W taki sposb moesz bezporednio edytowa certyfikaty i klucze prywarne w systemie plikw',

        # Template: AdminStateForm
        'State Management' => 'Konfiguracja statusw',
        'Add State' => 'Dodaj status',
        'Add a new State.' => 'Dodaj nowy status',
        'State Type' => 'Typ statusu',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Pamitaj, by auktualni rwnie domylne statusy w pliku Kernel/Config.pm !',
        'See also' => 'Zobacz take',

        # Template: AdminSysConfig
        'SysConfig' => 'Konfiguracja systemu',
        'Group selection' => 'Wybierz grup',
        'Show' => 'Poka',
        'Download Settings' => 'Pobierz ustawienia',
        'Download all system config changes.' => 'Pobierz wszystkie ustawienia systemowe.',
        'Load Settings' => 'Zaaduj ustawienia',
        'Subgroup' => 'Podgrupa',
        'Elements' => 'Elementy',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Opcje konfiguracyjne',
        'Default' => 'Domyslne',
        'New' => 'Nowe',
        'New Group' => 'Nowa grupa',
        'Group Ro' => 'Grupa ro',
        'New Group Ro' => 'Nowa grupa ro',
        'NavBarName' => 'Nazwa paska nawigacyjnego',
        'NavBar' => 'Pasek nawigacyjny',
        'Image' => 'Obraz',
        'Prio' => 'Priorytet',
        'Block' => 'Blok',
        'AccessKey' => 'Klawisz skrtu',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Konfiguracja adresw email Systemu',
        'Add System Address' => 'Dodaj adres systemowy',
        'Add a new System Address.' => 'Dodaj nowy adres systemowy',
        'Realname' => 'Prawdziwe Imi i Nazwisko',
        'All email addresses get excluded on replaying on composing an email.' => 'Wszystkie adresy e-mail zostan wykluczone z odpowiedzi.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Wszystkie wiadomoci przysane na ten adres w polu (Do:) zostan umieszczone w tej kolejce.',

        # Template: AdminTypeForm
        'Type Management' => 'Zarzdzanie typami',
        'Add Type' => 'Dodaj typ',
        'Add a new Type.' => 'Dodaj nowy typ',

        # Template: AdminUserForm
        'User Management' => 'Zarzdzanie uytkownikami',
        'Add User' => 'Dodaj agenta',
        'Add a new Agent.' => 'Dodaj nowego agenta',
        'Login as' => 'Zaloguj jako',
        'Firstname' => 'Imi',
        'Lastname' => 'Nazwisko',
        'Start' => 'Pocztek',
        'End' => 'Koniec',
        'User will be needed to handle tickets.' => 'Uytkownik bdzie niezbdny do obsugi zgoszenia.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Nie zapomnij doda uytkownika do grup i/lub rl!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Uytkownicy <-> Zarzdzanie grupami',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Ksika adresowa',
        'Return to the compose screen' => 'Powr do ekranu edycji',
        'Discard all changes and return to the compose screen' => 'Anuluj wszystkie zmiany i powr do ekranu edycji',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',
        'more' => '',
        'Settings' => '',
        'Expand' => '',
        'Collapse' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => '',
        'Release Note' => '',
        'Level' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats
        'Closed' => '',

        # Template: AgentInfo
        'Info' => 'Info',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Przypisz obiekt: %s',
        'Object' => 'Obiekt',
        'Link Object' => 'Przypisz obiekt',
        'with' => 'z',
        'Select' => 'Zaznacz',
        'Unlink Object: %s' => 'Oddziel obiekt: %s',

        # Template: AgentLookup
        'Lookup' => 'Wyszukiwanie',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Sownik',
        'spelling error(s)' => 'bdw jzykowych',
        'or' => 'lub',
        'Apply these changes' => 'Zastosuj te zmiany',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Na pewno chcesz usun ten obiekt?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Wybierz ograniczenia do opisania raportu.',
        'Fixed' => 'Stay',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Wybierz jeden element lub odznacz przycisk \'Stay\'',
        'Absolut Period' => 'Bezwzgldny przedzia',
        'Between' => 'Pomiedzy',
        'Relative Period' => 'Wzgledny przedzia',
        'The last' => 'Ostatni',
        'Finish' => 'Koniec',
        'Here you can make restrictions to your stat.' => 'Tu moesz naoy ograniczenia na swj raport.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Jeeli usuniesz znacznik  w polu "Fixed", agent bdzie mg zmieni atrybuty powiazanego elementu.',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Wstaw podstawowe parametry',
        'Permissions' => 'Prawa',
        'Format' => 'Format',
        'Graphsize' => 'Wielko wykresu',
        'Sum rows' => 'Suma wierszy',
        'Sum columns' => 'Suma kolumn',
        'Cache' => 'Pami podrczna',
        'Required Field' => 'Pole wymagane',
        'Selection needed' => 'Wybr wymagany',
        'Explanation' => 'Wyjanienie',
        'In this form you can select the basic specifications.' => 'W tym formularzu moesz wybra podstawowe parametry.',
        'Attribute' => 'Atrybut',
        'Title of the stat.' => 'Tytu statystyki.',
        'Here you can insert a description of the stat.' => 'Tu moesz doda opis startstyki.',
        'Dynamic-Object' => 'Obiekt dynamiczny',
        'Here you can select the dynamic object you want to use.' => 'Tu moesz wybra obiekt dynamiczny ktrego chcesz uy.',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Uwaga: Od instalacji zaley ile obiektw dynamicznych moesz uy)',
        'Static-File' => 'Plik statyczny',
        'For very complex stats it is possible to include a hardcoded file.' => 'Dla bardzo skomplikowanych statystyk mona uy pliku prekompilowanego.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Jeeli nowy plik prekompilowany bedzie dostepny, ten atrybut zostanie wywietlony i bedziesz mg wybra jeden.',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Ustawienia dostepu. Wybierz grupy mogce udostpnia przygotowane raporty dla innych agentw.',
        'Multiple selection of the output format.' => 'Wielokrotny wybr formatu wyjsciowego.',
        'If you use a graph as output format you have to select at least one graph size.' => 'Jeeli uywasz wykresu jako formaty wyjsciowego musisz okresli jego rozmiar.',
        'If you need the sum of every row select yes' => 'Jeeli chcesz sumowa wiersze wybierz tak.',
        'If you need the sum of every column select yes.' => 'Jeeli chcesz sumowa kolumny wybierz tak.',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'Wikszo raportw moe by umieszczona w pamici podrcznej. Przyspiesza to wywietlanie tych raportw.',
        '(Note: Useful for big databases and low performance server)' => '(Uwaga: Uyteczne dla duzych baz i wolnych serwerw)',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Niewany raport nie moe zosta wygenerowany.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'To jest uyteczna blokada jeeli chcesz uniemoliwi generowanie raportu przed zakoczeniem tworzenia wzorca.',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Wybierz elementy dla serii danych',
        'Scale' => 'Skala',
        'minimal' => 'minimum',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Pamitaj e skala wartoci moze by wiksza od skali osi X (np. o X => Miesice, Wartoci => Rok).',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Tu mozesz zdefiniowac wartoci. Moesz wybra jeden lub dwa elementy. Potemmozesz wybrac atrybuty elementw. Kady atrybut zostanie pokazany jako seria wartoci. Jezeli nie wybierzesz adnego z atrybutw elementu wszystkie zostana uyte przy generowaniu raportu. Tak samo jak nowe atrybuty dodane po ostatniej konfiguracji szablonu.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'Wybierz element ktry bdzie uzyty jako o X',
        'maximal period' => 'maksymalny przedzia',
        'minimal scale' => 'minimalna skala',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => 'Import',
        'File is not a Stats config' => 'Plik nie jest szablonem rapoortu',
        'No File selected' => 'Nie wybrano pliku',

        # Template: AgentStatsOverview
        'Results' => 'Wyniki',
        'Total hits' => 'Wszystkich trafie',
        'Page' => 'Strona',

        # Template: AgentStatsPrint
        'Print' => 'Drukuj',
        'No Element selected.' => 'Nie wybrano elementu.',

        # Template: AgentStatsView
        'Export Config' => 'Eksportuj Config',
        'Information about the Stat' => 'Informacja o szablonie',
        'Exchange Axis' => 'Zamie osie',
        'Configurable params of static stat' => 'Konfigurowalne parametry statycznego raportu',
        'No element selected.' => 'Nie wybrano elementu',
        'maximal period from' => 'maksymalny przedzia od',
        'to' => 'do',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Moesz utworzy szablony z wykorzystaniem pl wyboru i wprowadzania danych wedug wasnych potrzeb. Ktre elementy moesz edytowa okreli administrator statystyk ktry konfigurowa modu statystyk.',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Wiadomo musi zawiera wypenione adresem polu Do: (odbiorca)!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'W polu Do: musi znale si adres email (np. klient@przyklad.pl)!',
        'Bounce ticket' => 'Odbij zgoszenie',
        'Ticket locked!' => 'Zgoszenie zablokowane!',
        'Ticket unlock!' => 'Zgoszenie odblokowane!',
        'Bounce to' => 'Odbij do',
        'Next ticket state' => 'Nastpny status zgoszenia',
        'Inform sender' => 'Powiadom nadawc',
        'Send mail!' => 'Wylij wiadomo!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Musisz zaraportowa czas!',
        'Ticket Bulk Action' => 'Akcja grupowa',
        'Spell Check' => 'Sprawd poprawno',
        'Note type' => 'Typ notatki',
        'Next state' => 'Nastpny status',
        'Pending date' => 'Data oczekiwania',
        'Merge to' => 'Przycz do',
        'Merge to oldest' => 'Przycz do najstarszego',
        'Link together' => 'Pocz razem',
        'Link to Parent' => 'Docz do rodzica',
        'Unlock Tickets' => 'Odblokuj zgoszenia',

        # Template: AgentTicketClose
        'Ticket Type is required!' => 'Typ zgoszenia jest wymagany!',
        'A required field is:' => 'Wymagane pole to:',
        'Close ticket' => 'Zamknij zgoszenie',
        'Previous Owner' => 'Poprzedni waciciel',
        'Inform Agent' => 'Poinformuj agenta',
        'Optional' => 'Opcjonalny',
        'Inform involved Agents' => 'Poinformuj zaangaowanych agentw',
        'Attach' => 'Wstaw',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'Wiadomo musi zosta sprawdzona sownikiem!',
        'Compose answer for ticket' => 'Edytuj odpowied na zgoszenie',
        'Pending Date' => 'Termin wyznaczony',
        'for pending* states' => 'dla statusw "oczekujcych" z pola powyej',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Zmie klienta dla zgoszenia',
        'Set customer user and customer id of a ticket' => 'Wska klienta i ID klienta dla zgoszenia',
        'Customer User' => 'Klienci',
        'Search Customer' => 'Szukaj klienta',
        'Customer Data' => 'Dane klienta',
        'Customer history' => 'Historia klienta',
        'All customer tickets.' => 'Wszystkie zgoszenia klienta',

        # Template: AgentTicketEmail
        'Compose Email' => 'Nowa wiadomo',
        'new ticket' => 'Nowe zgoszenie',
        'Refresh' => 'Odswie',
        'Clear To' => 'Wyczy do',
        'All Agents' => 'Wszyscy agenci',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Typ artykuu',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Dodaj lub zmie dodatkowe informacje o zgoszeniu',

        # Template: AgentTicketHistory
        'History of' => 'Historia',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Musisz uy numeru zgoszenia!',
        'Ticket Merge' => 'Scal zgoszenie',

        # Template: AgentTicketMove
        'Move Ticket' => 'Przesu zgoszenie',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Dodaj notatk do zgoszenia',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => 'Czas pierwszej odpowiedzi',
        'Service Time' => 'Czas obsugi',
        'Update Time' => 'Czas aktualizacji',
        'Solution Time' => 'Czas rozwiazania',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Musisz wybra conajmniej jedno zgoszenie!',
        'Bulk Action' => '',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Filtr',
        'Change search options' => 'Zmie kryteria wyszukiwania',
        'Tickets' => 'Zgoszenia',
        'of' => 'z',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Napisz odpowied',
        'Contact customer' => 'Skontaktuj si z klientem',
        'Change queue' => 'Zmie kolejk',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'sortuj rosnco',
        'up' => 'gra',
        'sort downward' => 'sortuj malejco',
        'down' => 'd',
        'Escalation in' => 'Eskalowane w',
        'Locked' => 'Zablokowane',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Zmie waciciela zgoszenia',

        # Template: AgentTicketPending
        'Set Pending' => 'Ustaw oczekiwanie',

        # Template: AgentTicketPhone
        'Phone call' => 'Telefon',
        'Clear From' => 'Wyczy pole Od:',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Puste',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Informacje o zgoszeniu',
        'Accounted time' => 'Zaraportowany czas',
        'Linked-Object' => 'Powizany obiekt',
        'by' => 'przez',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Zmie priorytet zgoszenia',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Pokazane zgoszenia',
        'Tickets available' => 'Dostpne zgoszenia',
        'All tickets' => 'Wszystkie zgoszenia',
        'Queues' => 'Kolejki',
        'Ticket escalation!' => 'Eskalacja zgoszenia!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Zmie odpowiedzialnego za zgoszenie',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Wyszukiwanie zgoszenia',
        'Profile' => 'Profil',
        'Search-Template' => 'Szablon wyszukiwania',
        'TicketFreeText' => 'Dodatkowe informacje o zgoszeniu',
        'Created in Queue' => 'Utworzono w kolejce',
        'Article Create Times' => 'Czasy utworzenia artykuu',
        'Article created' => 'Artuku utworzono',
        'Article created between' => 'Artuku utworzono pomidzy',
        'Change Times' => 'Zmie czasy',
        'No change time settings.' => 'Brak zmiany ustawie czasu',
        'Ticket changed' => 'Zgoszenie zmieniono',
        'Ticket changed between' => 'Zgoszenie zmieniono pomidzy',
        'Result Form' => 'Formularz wynikw',
        'Save Search-Profile as Template?' => 'Zachowaj profil wyszukiwania jako szablon',
        'Yes, save it with name' => 'Tak, zapisz to pod nazw',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'Penotekstowe',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'Rozwi widok',
        'Collapse View' => 'Zwi widok',
        'Split' => 'Podziel',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => 'Ustawienie filtra artykuw',
        'Save filter settings as default' => 'Zapisz ustawienia filtru jako domylne',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'led wstecz',

        # Template: CustomerFooter
        'Powered by' => 'Oparte na',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'Login',
        'Lost your password?' => 'Zapomniae hasa?',
        'Request new password' => 'Proba o nowe haso',
        'Create Account' => 'Utwrz konto',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Witaj %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Razy',
        'No time settings.' => 'Brak ustawie czasu',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Kliknij tutaj, by zgosi bd systemu OTRS!',

        # Template: Footer
        'Top of Page' => 'Gra strony',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Pocztek',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Instalator Web',
        'Welcome to %s' => 'Witamy w %s',
        'Accept license' => 'Akceptuj licencj',
        'Don\'t accept license' => 'Nie akceptuje licencji',
        'Admin-User' => 'Administrator',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Jeeli masz haso administratora bazy danych wpisz je tutaj. Jeeli nie, zostaw pole puste. Ze wzgledw bezpieczestwa zalecamy ustawienia hasa administratoa bazy danych. Po szczegy signij do dokumentacji bazy danych.',
        'Admin-Password' => 'Haso administratora',
        'Database-User' => 'Uytkownik bazy danych',
        'default \'hot\'' => 'domylne \'hot\'',
        'DB connect host' => 'komputer bazy danych',
        'Database' => 'baza danych',
        'Default Charset' => 'Domylne kodowanie',
        'utf8' => 'UTF8',
        'false' => 'fasz',
        'SystemID' => 'ID Systemu',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identyfikator systemu. Wszystkie zgoszenia oraz sesje http bd zaczynay si od tego cigu)',
        'System FQDN' => 'Pena domena systemu FQDN',
        '(Full qualified domain name of your system)' => '(Pena nazwa domeny Twojego systemu FQDN)',
        'AdminEmail' => 'Email od Admina',
        '(Email of the system admin)' => '(Adres E-Mail Administratora Systemu)',
        'Organization' => 'Organizacja',
        'Log' => 'Log',
        'LogModule' => 'Modu logowania',
        '(Used log backend)' => '(Uywany log backend)',
        'Logfile' => 'Plik logu',
        '(Logfile just needed for File-LogModule!)' => '(Logfile jest potrzebny jedynie dla moduu File-Log!)',
        'Webfrontend' => 'Interfejs webowy',
        'Use utf-8 it your database supports it!' => 'Uywaj kodowania UTF-8 jeli pozwala Ci na to baza danych!',
        'Default Language' => 'Domylny jzyk',
        '(Used default language)' => '(Domylny jzyk)',
        'CheckMXRecord' => 'Sprawd rekord MX',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Sprawd rekord MX uzytego adresu e-mailprzy tworzeniu odpowiedzi. Nie uywaj sprawdzania rekordu MX jeeli twoja maszyna z OTRS jest na aczu z dynamicznym IP $!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Musisz wpisa nastpujce polecenie w linii komend (Terminal/Shell).',
        'Restart your webserver' => 'Uruchom ponownie serwer WWW',
        'After doing so your OTRS is up and running.' => 'Po zakoczeniu tych czynnoci Twj system OTRS bdzie gotowy do pracy',
        'Start page' => 'Strona startowa',
        'Your OTRS Team' => 'Twj Team OTRS',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Brak dostpu',

        # Template: Notify
        'Important' => 'Wane',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'wydrukowane przez',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor
        'Bold' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: Test
        'OTRS Test Page' => 'OTRS Strona testowa',
        'Counter' => 'Licznik',

        # Template: Warning

        # Misc
        'Edit Article' => 'Edytuj artyku',
        'Create Database' => 'Stwrz baz danych',
        'DB Host' => 'Host bazy danych',
        'Ticket Number Generator' => 'Generator numerw zgosze',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identyfikator zgoszenia. np. \'Ticket#\', \'Call#\' lub \'MyTicket#\')',
        'Create new Phone Ticket' => 'Utwrz zgoszenie telefoniczne',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'W ten sposb mona edytowa pk kluczy skofigurowany w Kernel/Config.pm',
        'Symptom' => 'Objawy',
        'U' => 'G',
        'Site' => 'Witryna',
        'Customer history search (e. g. "ID342425").' => 'Przeszukiwanie historii klienta (np. "ID342425").',
        'Can not delete link with %s!' => 'Nie mona usun powizania z %s',
        'for agent firstname' => 'dla imienia agenta',
        'Close!' => 'Zamknij!',
        'No means, send agent and customer notifications on changes.' => '\'Nie\' oznacza - wylij agentowi i klientowi powiadomienia o zmianach.',
        'A web calendar' => 'Kalendarz',
        'to get the realname of the sender (if given)' => 'by wstawi prawdziwe imi i nazwisko klienta (jeli podano)',
        'OTRS DB Name' => 'Nazwa bazy danych OTRS',
        'To enable automatic execusion select at least one value form minutes, hours and days!' => 'Aby wczy automatyczne wykonywanie ustaw dni, godziny i minuty!',
        'Notification (Customer)' => 'Powiadomienie (Klient)',
        'Select Source (for add)' => 'Wybierz rdo (dla dodania)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Opcjonalne dane (np. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Child-Object' => 'Obiekt potomny',
        'Queue ID' => 'ID Kolejki',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Opcje konfiguracyjne (np. <OTRS_CONFIG_HttpType>)',
        'customer realname' => 'Prawdziwe dane klienta',
        'Pending messages' => 'Oczekujce wiadomoci',
        'for agent login' => 'dla loginu agenta',
        'Keyword' => 'Sowo kluczowe',
        'Close type' => 'Typ zamknicia',
        'Can\'t update password, need min. 2 characters!' => 'Nie mona zmieni hasa, wymagane conajmniej 2 znaki!',
        'DB Admin User' => 'Uytkownik administrujcy baz danych',
        'for agent user id' => 'dla ID agenta',
        'Change user <-> group settings' => 'Zmie uytkownika <-> Ustawienia grupy',
        'Problem' => 'Problem',
        'Escalation' => 'Eskalacja',
        '"}' => '"}',
        'Order' => 'Porzdek',
        'next step' => 'Nastpny krok',
        'Follow up' => 'Odpowiedz',
        'Customer history search' => 'Przeszukiwanie historii klienta',
        'Admin-Email' => 'Wiadomo od Administratora',
        'Stat#' => 'Statystyka',
        'Create new database' => 'Stwrz now baz danych',
        'Can\'t update password, need min. 1 digit!' => 'Nie mona zmieni hasa, wymagana conajmniej 1 cyfra!',
        'ArticleID' => 'ID Artykuu',
        'Go' => 'Start',
        'Keywords' => 'Sowa kluczowe',
        'Ticket Escalation View' => 'Widok eskalowanych zgosze',
        'Today' => 'Dzi',
        'No * possible!' => 'Nie uywaj znaku "*"!',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opcje biecego uytkownika ktry wykona akcj (np. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Message for new Owner' => 'Wiadomo do nowego waciciela',
        'to get the first 5 lines of the email' => 'by wstawi 5 pierwszych linii wiadomoci',
        'Sort by' => 'Sortuj wedug',
        'OTRS DB Password' => 'Haso dostpu do bazy dla OTRS',
        'Last update' => 'Ostatnia aktualizacja',
        'Tomorrow' => 'Jutro',
        'to get the first 20 character of the subject' => 'by wstawi pierwsze 20 znakw tematu',
        'Select the customeruser:service relations.' => 'Wybierz relacj klient:usuga.',
        'DB Admin Password' => 'Haso Administratora bazy danych',
        'Bulk-Action' => 'Akcja grupowa',
        'Drop Database' => 'Usu baz danych',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Tu moesz zdefiniowac o X. Moesz wybra jeden element ze zdefiniowanych. Nastpnie musisz wybra dwa lub wicej atrybutw wskazanego elementu. Jeeli nie wybrae wszystkich atrybutw elementu uyte one zostan przy generowaniu raportu. Tak samo jak nowe atrybuty dodane od ostatniej konfiguracji.',
        'FileManager' => 'Meneder plikw',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Opcje aktualnego klienta (np. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'Typ oczekiwania',
        'Comment (internal)' => 'Komentarz (wewntrzny)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opcje waciciela zgoszenia (np. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opcje zgoszenia (np. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(Uywany format numerowania zgosze)',
        'Reminder' => 'Przypomnienie',
        'Can\'t update password, passwords doesn\'t match! Please try it again!' => 'Nie mona zmieni hasa, podano rne hasa! Sprbuj ponownie!',
        'OTRS DB connect host' => 'Host bazy danych',
        ' (work units)' => ' (jednostek roboczych)',
        'Next Week' => 'Nastpny tydzie',
        'All Customer variables like defined in config option CustomerUser.' => 'Wszystkie zdefiniowane zmienne klienta.',
        'accept license' => 'akceptuj Licencj',
        'for agent lastname' => 'dla nazwiska agenta',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Opcje aktualnego agenta obsugi (np. <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Tekst przypomnienia',
        'Parent-Object' => 'Obiekt macierzysty',
        'Of couse this feature will take some system performance it self!' => 'Oczywicie ta funkcja zabiera cz wydajnoci do obsugi samej siebie!',
        'Ticket Hook' => 'Identyfikator zgoszenia',
        'Your own Ticket' => 'Twoje wasne zgoszenie',
        'Detail' => 'Szczeg',
        'TicketZoom' => 'Podgld zgoszenia',
        'Open Tickets' => 'Otwarte zgoszenia',
        'Don\'t forget to add a new user to groups!' => 'Nie zapomnij doda uytkownika do grup!',
        'You have to select two or more attributes from the select field!' => 'Musisz wybra dwa lub wicej atrybutw z pola wyboru!',
        'System Settings' => 'Ustawienia systemu',
        'WebWatcher' => 'Obserwator Web',
        'Finished' => 'Zakoczono',
        'D' => '',
        'All messages' => 'Wszystkie wiadomoci',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Wasnoci zgoszenia (np. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Object already linked as %s.' => 'Obiekt ju przypisany jako %s',
        'A article should have a title!' => 'Artyku musi miec tytu!',
        'Customer Users <-> Services' => 'Klienci <-> Usugi',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Parametry konfiguracyjne (np. &lt;OTRS_CONFIG_HttpType&gt;)',
        'don\'t accept license' => 'nie akceptuj Licencji',
        'All email addresses get excluded on replaying on composing and email.' => 'Wszystkie adresy zostan pominite przy odpowiedzi, tworzeniu i wysyaniu wiadomoci.',
        'A web mail client' => 'Klient poczty przez www',
        'Compose Follow up' => 'Napisz Odpowied (Follow Up)',
        'Can\'t update password, need min. 8 characters!' => 'Nie mona zmieni hasa, wymagane conajmniej 8 znakw!',
        'WebMail' => 'Poczta przez www',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Opcje dotyczce waciciela zgoszenia (np. <OTRS_OWNER_UserFirstname>)',
        'DB Type' => 'Typ bazy danych',
        'kill all sessions' => 'Zamknij wszystkie sesje',
        'to get the from line of the email' => 'by wstawi pole Od wiadomoci',
        'Solution' => 'Rozwizanie',
        'QueueView' => 'Przegld kolejki',
        'Select Box' => 'Zapytanie SQL',
        'New messages' => 'Nowe wiadomoci',
        'Can not create link with %s!' => 'Nie poczono z %s!',
        'Linked as' => 'Poczono jako',
        'Welcome to OTRS' => 'Witamy w OTRS',
        'modified' => 'zmieniony',
        'Delete old database' => 'Usu star baz danych',
        'A web file manager' => 'Meneder plikw przez www ',
        'Have a lot of fun!' => 'yczymy dobrej zabawy!',
        'send' => 'wylij',
        'Send no notifications' => 'Wylij bez powiadomie',
        'Note Text' => 'Tekst notatki',
        'POP3 Account Management' => 'Konfiguracja kont POP3',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Cechy aktualnego klienta (np. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'System State Management' => 'Konfiguracja statusw',
        'OTRS DB User' => 'Uytkownik bazy danych OTRS',
        'Mailbox' => 'Skrzynka',
        'PhoneView' => 'Nowy telefon',
        'maximal period form' => 'maksymalny okres formularza',
        'TicketID' => 'ID Zgoszenia',
        'Yes means, send no agent and customer notifications on changes.' => '\'Tak\' oznacza - nie wysyaj powiadomie agentowi i klientowpi przy zmianach.',
        'Can\'t update password, need 2 lower and 2 upper characters!' => 'Nie mona zmieni hasa, wymagane 2 mae i 2 wielkie litery!',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Twoja wiadomo o numerze zgoszenia: "<OTRS_TICKET>" zostaa przekazana na adres "<OTRS_BOUNCE_TO>" . Prosimy kontaktowa si pod tym adresem we wszystkich sprawach dotyczcych tego zgoszenia.',
        'Ticket Status View' => 'Status zgoszenia',
        'Modified' => 'Zmodyfikowany',
        'Ticket selected for bulk action!' => 'Zgoszenie wybrano do akcji grupowej!',
    };
    # $$STOP$$
    return;
}

1;
