# --
# Kernel/Language/sk_SK.pm - provides Slovak language translation
# Copyright (C) 2001-2009 OTRS AG, http://otrs.org/
# --
# $Id: sk_SK.pm,v 1.55 2009/08/25 12:19:24 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::sk_SK;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.55 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Sat Jun 27 13:55:41 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'no',
        'No' => 'Nie',
        'yes' => 'no',
        'no' => 'iadny',
        'Off' => 'vypn',
        'off' => 'vypn',
        'On' => 'zapn',
        'on' => 'zapn',
        'top' => 'hore',
        'end' => 'koniec',
        'Done' => 'hotovo',
        'Cancel' => 'zrui',
        'Reset' => '',
        'last' => 'posledn',
        'before' => 'pred',
        'day' => 'de',
        'days' => 'dni',
        'day(s)' => 'de/dni',
        'hour' => 'hodina',
        'hours' => 'hodiny',
        'hour(s)' => 'hodina/hodiny',
        'minute' => 'minuta',
        'minutes' => 'minuty',
        'minute(s)' => 'minuta/minuty',
        'month' => 'mesiac',
        'months' => 'mesiace',
        'month(s)' => 'mesiac/mesiace',
        'week' => 'tde',
        'week(s)' => 'tdne',
        'year' => 'rok',
        'years' => 'roky',
        'year(s)' => 'rok/roky',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        'wrote' => 'psa',
        'Message' => 'sprva',
        'Error' => 'Chyba',
        'Bug Report' => 'chybov hlsenie',
        'Attention' => 'Pozor',
        'Warning' => 'Varovanie',
        'Module' => 'Modul',
        'Modulefile' => 'modulov prieinok',
        'Subfunction' => 'Podfunkcia',
        'Line' => 'riadok',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'Prklad',
        'Examples' => 'Prklady',
        'valid' => 'platn',
        'invalid' => 'neplatn',
        '* invalid' => '',
        'invalid-temporarily' => 'doasne neplatn',
        ' 2 minutes' => ' 2 minuty',
        ' 5 minutes' => ' 5 mint',
        ' 7 minutes' => ' 7 mint',
        '10 minutes' => ' 10 mint',
        '15 minutes' => ' 15 mint',
        'Mr.' => 'Pn',
        'Mrs.' => 'Pani',
        'Next' => 'alej',
        'Back' => 'sp',
        'Next...' => 'alej...',
        '...Back' => '...sp',
        '-none-' => '-iadny-',
        'none' => 'iadny',
        'none!' => 'iaden',
        'none - answered' => 'iadna odpove',
        'please do not edit!' => 'Prosm neupravova!',
        'AddLink' => 'Prida odkaz.',
        'Link' => 'Prepojenie',
        'Unlink' => '',
        'Linked' => 'spojen',
        'Link (Normal)' => 'Prepojenie (obyajn)',
        'Link (Parent)' => 'Prepojenie (zdroj)',
        'Link (Child)' => 'Prepojenie (nslednk)',
        'Normal' => 'obyajn',
        'Parent' => 'zdroj',
        'Child' => 'diea',
        'Hit' => 'der',
        'Hits' => 'dery',
        'Text' => '',
        'Lite' => 'Odahen',
        'User' => 'Uvate',
        'Username' => 'Uvatesk meno',
        'Language' => 'Jazyk',
        'Languages' => 'Jazyky',
        'Password' => 'Heslo',
        'Salutation' => 'Oslovenie',
        'Signature' => 'Podpis',
        'Customer' => 'Zkaznk',
        'CustomerID' => 'Zkazncke ',
        'CustomerIDs' => 'Zkazncke sla',
        'customer' => 'Zkaznk',
        'agent' => 'Agent',
        'system' => 'Systm',
        'Customer Info' => 'Zkaznke info',
        'Customer Company' => '',
        'Company' => '',
        'go!' => 'tart!',
        'go' => 'tart',
        'All' => 'Vetko',
        'all' => 'vetko',
        'Sorry' => 'Pardon',
        'update!' => 'Aktualizuj!',
        'update' => 'Aktualizova',
        'Update' => 'Aktualizcia',
        'Updated!' => '',
        'submit!' => 'predlo!',
        'submit' => 'predloi',
        'Submit' => 'Predloenie',
        'change!' => 'Zme!',
        'Change' => 'Zmena',
        'change' => 'Zmeni',
        'click here' => 'klikni tu',
        'Comment' => 'poznmka',
        'Valid' => 'Platn',
        'Invalid Option!' => 'Neplatn monos!',
        'Invalid time!' => 'Neplatn as!',
        'Invalid date!' => 'Neplatn dtum!',
        'Name' => 'Meno',
        'Group' => 'Skupina',
        'Description' => 'Popis ',
        'description' => 'Popis ',
        'Theme' => 'Schema',
        'Created' => 'Vytvoren',
        'Created by' => 'Vytvoren (km)',
        'Changed' => 'Zmenen',
        'Changed by' => 'Zmenen (km)',
        'Search' => 'Hada',
        'and' => 'a',
        'between' => 'medzi',
        'Fulltext Search' => 'Fulltextov vyhadvanie ',
        'Data' => 'daje',
        'Options' => 'Monosti',
        'Title' => 'Nzov',
        'Item' => 'Poloka',
        'Delete' => 'Zmaza',
        'Edit' => 'Upravi',
        'View' => 'Zobrazi',
        'Number' => 'slo',
        'System' => 'Systm',
        'Contact' => 'Kontakt',
        'Contacts' => 'Kontakty',
        'Export' => '',
        'Up' => 'Hore',
        'Down' => 'Dolu',
        'Add' => 'Prida ',
        'Added!' => '',
        'Category' => 'Kategria',
        'Viewer' => 'Zobraz',
        'Expand' => '',
        'New message' => 'Nov sprva',
        'New message!' => 'Nov sprva!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosim odpovedajte na tento tiket',
        'You got new message!' => 'Mte nov sprvu!',
        'You have %s new message(s)!' => 'Mte % novch sprv!',
        'You have %s reminder ticket(s)!' => 'Mte % pripomienok!',
        'The recommended charset for your language is %s!' => 'Odporan znakov sada pre v jazyk je %',
        'Passwords doesn\'t match! Please try it again!' => 'Hesl sa nezhoduju! Prosm skste znova!',
        'Password is already in use! Please use an other password!' => 'Heslo je u pouvan. Prosm pouite in heslo!',
        'Password is already used! Please use an other password!' => 'Heslo je u pouvan. Prosm pouite in heslo!',
        'You need to activate %s first to use it!' => 'Na pouvanie muste najprv aktivova %',
        'No suggestions' => 'iadne nvrhy.',
        'Word' => 'Slovo',
        'Ignore' => 'Ignorova',
        'replace with' => 'nahradi s',
        'There is no account with that login name.' => 'Neexistuje iadny et s tmto vateskm menom',
        'Login failed! Your username or password was entered incorrectly.' => 'Prihlsenie zlyhalo! Vae pouvatesk meno alebo heslo bolo vloen nesprvne.',
        'Please contact your admin' => 'Prosm kontaktujte vho administrtora.',
        'Logout successful. Thank you for using OTRS!' => 'Odhlsenie spen. akujeme za pouvanie OTRS!',
        'Invalid SessionID!' => 'Neplatn SessionID',
        'Feature not active!' => 'Funkcia neaktvna!',
        'Notification (Event)' => '',
        'Login is needed!' => '',
        'Password is needed!' => 'Je potrebn heslo.',
        'License' => 'Licencia',
        'Take this Customer' => 'Poui tohto klienta.',
        'Take this User' => 'Pui tohto uvatea.',
        'possible' => 'mon',
        'reject' => 'odmietnu',
        'reverse' => '',
        'Facility' => 'Prsluenstvo',
        'Timeover' => '',
        'Pending till' => 'Odloen do.',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Nepracujte s pouvateskm slom 1 (systmov et)! Vytvorte novho pouvatea.',
        'Dispatching by email To: field.' => 'Posielam emailom =>  prijemca: pole',
        'Dispatching by selected Queue.' => 'Posielam vybranm radom.',
        'No entry found!' => 'Nenjden iaden vstup.',
        'Session has timed out. Please log in again.' => 'Relcia timeout. Prosm =>  prihlste sa znova.',
        'No Permission!' => 'Nepovolen!',
        'To: (%s) replaced with database email!' => 'Prjemca: % je nahraden databzovm emailom!',
        'Cc: (%s) added database email!' => 'Kpia: % pridan databzov email.',
        '(Click here to add)' => '(Ak chcete prida poloku =>  kliknete sem.)',
        'Preview' => 'Nhad',
        'Package not correctly deployed! You should reinstall the Package again!' => '',
        'Added User "%s"' => '',
        'Contract' => 'Zmluva',
        'Online Customer: %s' => 'Online uvate: %',
        'Online Agent: %s' => 'Online Agent %',
        'Calendar' => 'Kalendr',
        'File' => '',
        'Filename' => '',
        'Type' => 'Typ',
        'Size' => 'Vekos',
        'Upload' => '',
        'Directory' => '',
        'Signed' => 'Podpsan',
        'Sign' => 'Podpsa',
        'Crypted' => 'Zaifrovan',
        'Crypt' => 'ifrova',
        'Office' => 'Kancelria',
        'Phone' => 'Telefn',
        'Fax' => '',
        'Mobile' => '',
        'Zip' => '',
        'City' => '',
        'Street' => '',
        'Country' => '',
        'Location' => '',
        'installed' => 'naintalovan',
        'uninstalled' => 'odintalovan',
        'Security Note: You should activate %s because application is already running!' => '',
        'Unable to parse Online Repository index document!' => '',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => '',
        'No Packages or no new Packages in selected Online Repository!' => '',
        'printed at' => '',
        'Dear Mr. %s,' => '',
        'Dear Mrs. %s,' => '',
        'Dear %s,' => '',
        'Hello %s,' => '',
        'This account exists.' => '',
        'New account created. Sent Login-Account to %s.' => '',
        'Please press Back and try again.' => '',
        'Sent password token to: %s' => '',
        'Sent new password to: %s' => '',
        'Upcoming Events' => '',
        'Event' => '',
        'Events' => '',
        'Invalid Token!' => '',
        'more' => '',
        'For more info see:' => '',
        'Package verification failed!' => '',
        'Collapse' => '',
        'News' => '',
        'Product News' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => '',
        'Font Color' => '',
        'Background Color' => '',
        'Remove Formatting' => '',
        'Show/Hide Hidden Elements' => '',
        'Align Left' => '',
        'Align Center' => '',
        'Align Right' => '',
        'Justify' => '',
        'Header' => '',
        'Indent' => '',
        'Outdent' => '',
        'Create an Unordered List' => '',
        'Create an Ordered List' => '',
        'HTML Link' => '',
        'Insert Image' => '',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'jan',
        'Feb' => 'feb',
        'Mar' => 'mar',
        'Apr' => 'aprl',
        'May' => 'mj',
        'Jun' => 'jn',
        'Jul' => 'jl',
        'Aug' => 'aug',
        'Sep' => 'sept',
        'Oct' => 'okt',
        'Nov' => 'nov',
        'Dec' => 'dec',
        'January' => '',
        'February' => '',
        'March' => '',
        'April' => '',
        'May_long' => '',
        'June' => '',
        'July' => '',
        'August' => '',
        'September' => '',
        'October' => '',
        'November' => '',
        'December' => '',

        # Template: AAANavBar
        'Admin-Area' => 'Admin-oblas',
        'Agent-Area' => '',
        'Ticket-Area' => '',
        'Logout' => 'Odhlsenie ',
        'Agent Preferences' => 'Nastavenia vatea',
        'Preferences' => 'Nastavenia',
        'Agent Mailbox' => '',
        'Stats' => 'tatistika',
        'Stats-Area' => 'tatistick oblas',
        'Admin' => '',
        'Customer Users' => 'Klientsk uvatelia.',
        'Customer Users <-> Groups' => 'Klientsk uvatelia <-> skupiny ',
        'Users <-> Groups' => 'Uvatelia <-> Skupiny',
        'Roles' => 'Funkcie',
        'Roles <-> Users' => 'Funkcie <-> Uvatelia',
        'Roles <-> Groups' => 'Funkcie <-> Skupiny',
        'Salutations' => 'Oslovenia',
        'Signatures' => 'Podpisy',
        'Email Addresses' => 'Emailov adresy',
        'Notifications' => 'Oznamovanie',
        'Category Tree' => 'Strom kategri',
        'Admin Notification' => 'Administrtorsk oznamovanie',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Predvoby spene aktualizovan!',
        'Mail Management' => 'Sprva poty.',
        'Frontend' => '',
        'Other Options' => 'Ostatn Monosti',
        'Change Password' => 'Zmena hesla',
        'New password' => 'Nov heslo',
        'New password again' => 'Znova nov heslo',
        'Select your QueueView refresh time.' => 'Vyberte si refresh time fronty',
        'Select your frontend language.' => 'Vyberte si jazyk.',
        'Select your frontend Charset.' => 'Vyberte si znakov sadu.',
        'Select your frontend Theme.' => 'Vyberte si vzhad.',
        'Select your frontend QueueView.' => 'Vyberte si QueueView',
        'Spelling Dictionary' => 'Slovnk pravopisu.',
        'Select your default spelling dictionary.' => 'Vyberte si slovnk na kontrolu pravopisu.',
        'Max. shown Tickets a page in Overview.' => 'Maximlny poet poiadaviek zobrazovanch v prehade.',
        'Can\'t update password, your new passwords do not match! Please try again!' => '',
        'Can\'t update password, invalid characters!' => '',
        'Can\'t update password, must be at least %s characters!' => '',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => '',
        'Can\'t update password, needs at least 1 digit!' => '',
        'Can\'t update password, needs at least 2 characters!' => '',

        # Template: AAAStats
        'Stat' => '',
        'Please fill out the required fields!' => '',
        'Please select a file!' => '',
        'Please select an object!' => '',
        'Please select a graph size!' => '',
        'Please select one element for the X-axis!' => '',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => '',
        'If you use a checkbox you have to select some attributes of the select field!' => '',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '',
        'The selected end time is before the start time!' => '',
        'You have to select one or more attributes from the select field!' => '',
        'The selected Date isn\'t valid!' => '',
        'Please select only one or two elements via the checkbox!' => '',
        'If you use a time scale element you can only select one element!' => '',
        'You have an error in your time selection!' => '',
        'Your reporting time interval is too small, please use a larger time scale!' => '',
        'The selected start time is before the allowed start time!' => '',
        'The selected end time is after the allowed end time!' => '',
        'The selected time period is larger than the allowed time period!' => '',
        'Common Specification' => '',
        'Xaxis' => '',
        'Value Series' => '',
        'Restrictions' => '',
        'graph-lines' => '',
        'graph-bars' => '',
        'graph-hbars' => '',
        'graph-points' => '',
        'graph-lines-points' => '',
        'graph-area' => '',
        'graph-pie' => '',
        'extended' => '',
        'Agent/Owner' => '',
        'Created by Agent/Owner' => '',
        'Created Priority' => '',
        'Created State' => '',
        'Create Time' => '',
        'CustomerUserLogin' => '',
        'Close Time' => '',
        'TicketAccumulation' => '',
        'Attributes to be printed' => '',
        'Sort sequence' => '',
        'Order by' => '',
        'Limit' => '',
        'Ticketlist' => '',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '',
        'Total Time' => '',
        'Ticket Average' => '',
        'Ticket Min Time' => '',
        'Ticket Max Time' => '',
        'Number of Tickets' => '',
        'Article Average' => '',
        'Article Min Time' => '',
        'Article Max Time' => '',
        'Number of Articles' => '',
        'Accounted time by Agent' => '',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => '',
        'Ticket Close Time' => '',

        # Template: AAATicket
        'Lock' => 'Zamkn',
        'Unlock' => 'Odomkn',
        'History' => 'Histria',
        'Zoom' => 'Zvi',
        'Age' => 'Vek',
        'Bounce' => 'Skoi na',
        'Forward' => 'Nasledujci',
        'From' => 'Od ',
        'To' => 'Prjemca',
        'Cc' => '',
        'Bcc' => '',
        'Subject' => 'Predmet',
        'Move' => 'Presun',
        'Queue' => 'Fronta',
        'Priority' => 'Priorita',
        'Priority Update' => '',
        'State' => 'Stav',
        'Compose' => 'Vytvori',
        'Pending' => 'akanie',
        'Owner' => 'Vlastnk',
        'Owner Update' => 'aktualizcia vlastnka',
        'Responsible' => '',
        'Responsible Update' => '',
        'Sender' => 'Odosielate',
        'Article' => 'lnok',
        'Ticket' => 'Poiadavka',
        'Createtime' => 'Doba spracovania',
        'plain' => 'jednoduch',
        'Email' => 'Realname',
        'email' => 'e-mail',
        'Close' => 'Zatvorit',
        'Action' => 'Akcia',
        'Attachment' => 'Prloha',
        'Attachments' => 'Prlohy',
        'This message was written in a character set other than your own.' => 'Tto sprva bola napsan v inej znakovej sade =>  ako je vaa.',
        'If it is not displayed correctly,' => '',
        'This is a' => 'To je',
        'to open it in a new window.' => 'Otvori v novom okne',
        'This is a HTML email. Click here to show it.' => 'Toto je HMTL  e-mail. Na otvorenie =>  kliknite tu',
        'Free Fields' => 'Von polia',
        'Merge' => 'Zli',
        'merged' => '',
        'closed successful' => 'zatvoren spene',
        'closed unsuccessful' => 'zatvoren nespene',
        'new' => 'nov',
        'open' => 'otvori',
        'Open' => '',
        'closed' => 'zatvoren',
        'Closed' => '',
        'removed' => 'odstrnen',
        'pending reminder' => 'nevybaven pripomienka',
        'pending auto' => '',
        'pending auto close+' => 'poas automatickho zatvrania +',
        'pending auto close-' => 'poas automatickho zatvrania -',
        'email-external' => 'extern e-mail',
        'email-internal' => 'intern e-mail',
        'note-external' => 'extern poznmka',
        'note-internal' => 'intern poznmka',
        'note-report' => 'hlsnie poznmky',
        'phone' => 'telefn',
        'sms' => '',
        'webrequest' => 'webov poiadavka',
        'lock' => 'zamkn',
        'unlock' => 'odomkn',
        'very low' => 'vemi nzka',
        'low' => 'nzka',
        'normal' => 'normlna',
        'high' => 'vysok',
        'very high' => 'vemi vysok',
        '1 very low' => '1 vemi nzka',
        '2 low' => '2 nzka',
        '3 normal' => '3 normlna',
        '4 high' => '4 vysok',
        '5 very high' => '5 vemi vysok',
        'Ticket "%s" created!' => '',
        'Ticket Number' => 'slo poiadavky',
        'Ticket Object' => 'predmet poiadavky',
        'No such Ticket Number "%s"! Can\'t link it!' => '',
        'Don\'t show closed Tickets' => 'Nezobrazuj uzavret poiadavky.',
        'Show closed Tickets' => 'Zobraz uzavret poiadavky.',
        'New Article' => 'Nov lnok',
        'Email-Ticket' => 'e-mailov poiadavka',
        'Create new Email Ticket' => 'Vytvor nov e-mailov poiadavku',
        'Phone-Ticket' => 'Telefonick poiadavka',
        'Search Tickets' => 'Hadaj poiadavky',
        'Edit Customer Users' => 'Uprav zkaznckeho uvatea.',
        'Edit Customer Company' => '',
        'Bulk Action' => 'Hromadn akcia',
        'Bulk Actions on Tickets' => 'hromadn akcie na poiadavkch.',
        'Send Email and create a new Ticket' => 'Poli e-mail a vytvor nov poiadavku',
        'Create new Email Ticket and send this out (Outbound)' => '',
        'Create new Phone Ticket (Inbound)' => '',
        'Overview of all open Tickets' => 'Prehad vetkch otvorench poiadaviek.',
        'Locked Tickets' => 'Lockovan poiadavky',
        'Watched Tickets' => '',
        'Watched' => '',
        'Subscribe' => '',
        'Unsubscribe' => '',
        'Lock it to work on it!' => 'Kvli prci na nich =>  lock.',
        'Unlock to give it back to the queue!' => 'Unlock a daj sp do radu.',
        'Shows the ticket history!' => 'Zobraz histriu poiadaviek.',
        'Print this ticket!' => 'Vytla tto poiadavku.',
        'Change the ticket priority!' => 'Zme prioritu poiadavky.',
        'Change the ticket free fields!' => 'Zme von polia poiadavky.',
        'Link this ticket to an other objects!' => 'Prepoj poiadavku s inmi objektami!',
        'Change the ticket owner!' => 'Zme majitea poiadavky.',
        'Change the ticket customer!' => 'Zme klienta poiadavky.',
        'Add a note to this ticket!' => 'Pridaj poznmku k tejto poiadavke.',
        'Merge this ticket!' => 'Pripoj tto poiadavku.',
        'Set this ticket to pending!' => 'Nastav poiadavku na vyrieenie.',
        'Close this ticket!' => 'Zatvor tto poiadavku.',
        'Look into a ticket!' => 'Vyhadaj poiadavku.',
        'Delete this ticket!' => 'Vyma tto poiadavku.',
        'Mark as Spam!' => 'Ozna ako Spam!',
        'My Queues' => 'Moje rady.',
        'Shown Tickets' => 'Zobraz poiadavky.',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => '',
        'Ticket %s: first response time is over (%s)!' => '',
        'Ticket %s: first response time will be over in %s!' => '',
        'Ticket %s: update time is over (%s)!' => '',
        'Ticket %s: update time will be over in %s!' => '',
        'Ticket %s: solution time is over (%s)!' => '',
        'Ticket %s: solution time will be over in %s!' => '',
        'There are more escalated tickets!' => '',
        'New ticket notification' => 'Hlsenie novej poiadavky.',
        'Send me a notification if there is a new ticket in "My Queues".' => '',
        'Follow up notification' => 'Nasleduj hlsenie.',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Poli mi oznmenie =>  ak klient pole overenie a ja som vlastnk tejto poiadavky.',
        'Ticket lock timeout notification' => 'Poiadavka blokuje asov limit oznmenia.',
        'Send me a notification if a ticket is unlocked by the system.' => 'Poli mi oznmenie =>  ak je poiadavka odblokovan systmom.',
        'Move notification' => 'Premiestni hlsenie',
        'Send me a notification if a ticket is moved into one of "My Queues".' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'V vber z obbench radov. Tie mete by oboznmen s poiadavkou cez e-mail =>  ak je to mon.',
        'Custom Queue' => 'Klientsk rady.',
        'QueueView refresh time' => '?',
        'Screen after new ticket' => 'Okno po novej poiadavke.',
        'Select your screen after creating a new ticket.' => 'Vyberte si okno zobrazujce sa po vytvoren novej poiadavky.',
        'Closed Tickets' => 'Zatvoren poiadavky.',
        'Show closed tickets.' => 'Uk zatvoren poiadavky.',
        'Max. shown Tickets a page in QueueView.' => 'Maximlny poet poiadaviek zobrazovanch v prehade.',
        'Watch notification' => '',
        'Send me a notification of an watched ticket like an owner of an ticket.' => '',
        'Out Of Office' => '',
        'Select your out of office time.' => '',
        'CompanyTickets' => 'Firemn poiadavky',
        'MyTickets' => 'Moje poiadavky',
        'New Ticket' => 'Nov poiadavka',
        'Create new Ticket' => 'Vytvor nov poiadavku',
        'Customer called' => 'Zkazncky hovor',
        'phone call' => '',
        'Reminder Reached' => '',
        'Reminder Tickets' => '',
        'Escalated Tickets' => '',
        'New Tickets' => '',
        'Open Tickets / Need to be answered' => '',
        'Tickets which need to be answered!' => '',
        'All new tickets!' => '',
        'All tickets which are escalated!' => '',
        'All tickets where the reminder date has reached!' => '',
        'Responses' => 'Odpovede',
        'Responses <-> Queue' => 'Odpovede <-> rad',
        'Auto Responses' => 'Automatick odpovede',
        'Auto Responses <-> Queue' => 'Automatick odpovede <-> rad',
        'Attachments <-> Responses' => 'Prlohy <-> Odpovede',
        'History::Move' => 'Histria: pohyb',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Histria: Nov pripomienka',
        'History::FollowUp' => 'Histria: sleduj',
        'History::SendAutoReject' => 'Histria: poli automatick odpove',
        'History::SendAutoReply' => 'Histria: poli automatick zamietnutie',
        'History::SendAutoFollowUp' => 'Histria: SendAutoFollowUp',
        'History::Forward' => 'Histria: Forward',
        'History::Bounce' => 'Histria: ',
        'History::SendAnswer' => 'Histria:: Poli odpove',
        'History::SendAgentNotification' => 'Histria:: poli notifikciu zstupcovi',
        'History::SendCustomerNotification' => 'Histria:: Poli zkazncku notifikciu',
        'History::EmailAgent' => 'Histria: email zstupcu',
        'History::EmailCustomer' => 'Histria: Email klienta',
        'History::PhoneCallAgent' => 'Histria: Hovor agenta',
        'History::PhoneCallCustomer' => 'Histria: Hovor klienta',
        'History::AddNote' => 'Histria: Pridaj poznmku',
        'History::Lock' => 'Histria: zamkni',
        'History::Unlock' => 'Histria: odomkni',
        'History::TimeAccounting' => 'Histria: asov et',
        'History::Remove' => 'Histria: odstrnen',
        'History::CustomerUpdate' => 'Histria: klientsk aktualizcia',
        'History::PriorityUpdate' => 'Histria: aktualizcia priort',
        'History::OwnerUpdate' => 'Histria: aktualizcia majitea',
        'History::LoopProtection' => 'Histria: LoopProtection',
        'History::Misc' => 'Histria: ',
        'History::SetPendingTime' => 'Histria: Nastav as rieenia',
        'History::StateUpdate' => 'Histria: Aktualizcia stavu',
        'History::TicketFreeTextUpdate' => 'Histria: ',
        'History::WebRequestCustomer' => 'Histria: ',
        'History::TicketLinkAdd' => 'Histria: ',
        'History::TicketLinkDelete' => 'Histria: ',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Ned',
        'Mon' => 'Pon',
        'Tue' => 'Ut',
        'Wed' => 'Str',
        'Thu' => 'Stv',
        'Fri' => 'Pia',
        'Sat' => 'Sob',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'riadenie prloh',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'riadenie automatickch odpoved',
        'Response' => 'Odpove',
        'Auto Response From' => 'Automatick odpove od',
        'Note' => 'Poznmka',
        'Useable options' => 'pouiten monos',
        'To get the first 20 character of the subject.' => '',
        'To get the first 5 lines of the email.' => '',
        'To get the realname of the sender (if given).' => '',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => '',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => '',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => '',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => '',
        'Search for' => 'Hada',
        'Add Customer Company' => '',
        'Add a new Customer Company.' => '',
        'List' => '',
        'This values are required.' => 'Tto hodnota je poadovan.',
        'This values are read only.' => 'Tto hodnota je iba na tanie',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'Vytvoren sprva bola zatvoren. ',
        'This window must be called from compose window' => 'Toto okno mus by vyvolan z okna na vytvranie.',
        'Customer User Management' => 'Riadenie klientskch uvateov.',
        'Add Customer User' => '',
        'Source' => 'zdroj',
        'Create' => '',
        'Customer user will be needed to have a customer history and to login via customer panel.' => '',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Klientsk uvatelia <-> Skupiny riadenia',
        'Change %s settings' => 'Zmeni % nastavenia',
        'Select the user:group permissions.' => 'Vyber pouvatea: skupina povolen',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => '',
        'Permission' => 'Povolenie',
        'ro' => '',
        'Read only access to the ticket in this group/queue.' => 'taj iba prstup k poiadavkm v tejto skupine/rade.',
        'rw' => '',
        'Full read and write access to the tickets in this group/queue.' => 'Message sent to',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => '',
        'CustomerUser' => '',
        'Service' => '',
        'Edit default services.' => '',
        'Search Result' => '',
        'Allocate services to CustomerUser' => '',
        'Active' => '',
        'Allocate CustomerUser to service' => '',

        # Template: AdminEmail
        'Message sent to' => '',
        'A message should have a subject!' => '',
        'Recipients' => '',
        'Body' => '',
        'Send' => '',

        # Template: AdminGenericAgent
        'GenericAgent' => '',
        'Job-List' => '',
        'Last run' => '',
        'Run Now!' => '',
        'x' => 'Save Job as?',
        'Save Job as?' => '',
        'Is Job Valid?' => '',
        'Is Job Valid' => '',
        'Schedule' => '',
        'Currently this generic agent job will not run automatically.' => '',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => '',
        '(e. g. 10*5155 or 105658*)' => '',
        '(e. g. 234321)' => '',
        'Customer User Login' => '',
        '(e. g. U5150)' => '',
        'SLA' => '',
        'Agent' => '',
        'Ticket Lock' => '',
        'TicketFreeFields' => '',
        'Create Times' => '',
        'No create time settings.' => '',
        'Ticket created' => 'Pripomienka vytvoren',
        'Ticket created between' => 'Pripomienka vytvoren medzi',
        'Close Times' => '',
        'No close time settings.' => '',
        'Ticket closed' => '',
        'Ticket closed between' => '',
        'Pending Times' => '',
        'No pending time settings.' => '',
        'Ticket pending time reached' => '',
        'Ticket pending time reached between' => '',
        'Escalation Times' => '',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - First Response Time' => '',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - Update Time' => '',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - Solution Time' => '',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'New Service' => '',
        'New SLA' => '',
        'New Priority' => 'Nov priorita',
        'New Queue' => 'Nov rad',
        'New State' => 'Nov stav',
        'New Agent' => 'Nov zstupca',
        'New Owner' => 'Nov ',
        'New Customer' => 'Nov zkaznk',
        'New Ticket Lock' => 'CustomerUser',
        'New Type' => '',
        'New Title' => '',
        'New TicketFreeFields' => '',
        'Add Note' => '',
        'Time units' => '',
        'CMD' => 'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Delete tickets',
        'Delete tickets' => '',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => '',
        'Send Notification' => '',
        'Param 1' => '',
        'Param 2' => '',
        'Param 3' => '',
        'Param 4' => '',
        'Param 5' => '',
        'Param 6' => '',
        'Send agent/customer notifications on changes' => '',
        'Save' => '',
        '%s Tickets affected! Do you really want to use this job?' => '',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => '',
        'Add Group' => '',
        'Add a new Group.' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department =>  support department =>  sales department =>  ...).',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => '',
        'It\'s useful for ASP solutions.' => 'System Log',

        # Template: AdminLog
        'System Log' => '',
        'Time' => '',

        # Template: AdminMailAccount
        'Mail Account Management' => '',
        'Host' => 'Trusted',
        'Trusted' => '',
        'Dispatching' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => '',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',

        # Template: AdminNavigationBar
        'Users' => '',
        'Groups' => '',
        'Misc' => '',

        # Template: AdminNotificationEventForm
        'Notification Management' => '',
        'Add Notification' => '',
        'Add a new Notification.' => '',
        'Name is required!' => '',
        'Event is required!' => '',
        'A message should have a body!' => '',
        'Recipient' => '',
        'Group based' => '',
        'Agent based' => '',
        'Email based' => '',
        'Article Type' => '',
        'Only for ArticleCreate Event.' => '',
        'Subject match' => '',
        'Body match' => '',
        'Notifications are sent to an agent or a customer.' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminNotificationForm
        'Notification' => '',

        # Template: AdminPackageManager
        'Package Manager' => '',
        'Uninstall' => '',
        'Version' => '',
        'Do you really want to uninstall this package?' => '',
        'Reinstall' => '',
        'Do you really want to reinstall this package (all manual changes get lost)?' => '',
        'Continue' => '',
        'Install' => '',
        'Package' => '',
        'Online Repository' => 'Version',
        'Vendor' => 'Upgrade',
        'Module documentation' => '',
        'Upgrade' => 'Local Repository',
        'Local Repository' => '',
        'Status' => '',
        'Overview' => '',
        'Download' => '',
        'Rebuild' => '',
        'ChangeLog' => '',
        'Date' => '',
        'Filelist' => '',
        'Download file from package!' => '',
        'Required' => '',
        'PrimaryKey' => '',
        'AutoIncrement' => '',
        'SQL' => 'Limit',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => '',
        'This feature is enabled!' => '',
        'Just use this feature if you want to log each request.' => '',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => '',
        'This feature is disabled!' => '',
        'Enable it here!' => '',
        'Logfile too large!' => '',
        'Logfile too large, you need to reset it!' => '',
        'Range' => '',
        'Interface' => '',
        'Requests' => '',
        'Min Response' => '',
        'Max Response' => '',
        'Average Response' => '',
        'Period' => '',
        'Min' => '',
        'Max' => '',
        'Average' => '',

        # Template: AdminPGPForm
        'PGP Management' => '',
        'Result' => 'vsledok',
        'Identifier' => '',
        'Bit' => '',
        'Key' => '',
        'Fingerprint' => 'Expires',
        'Expires' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => '',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Filtername',
        'Filtername' => 'Match',
        'Stop after match' => '',
        'Match' => '',
        'Value' => '',
        'Set' => '',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => '',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',

        # Template: AdminPriority
        'Priority Management' => '',
        'Add Priority' => '',
        'Add a new Priority.' => '',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => '',
        'settings' => '',

        # Template: AdminQueueForm
        'Queue Management' => '',
        'Sub-Queue of' => '',
        'Unlock timeout' => '0 = no unlock',
        '0 = no unlock' => '',
        'Only business hours are counted.' => '',
        '0 = no escalation' => '',
        'Notify by' => '',
        'Follow up Option' => '',
        'Ticket lock after a follow up' => '',
        'Systemaddress' => '',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => '',
        'Escalation time' => '',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => '',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => '',
        'Will be the sender address of this queue for email answers.' => '',
        'The salutation for email answers.' => '',
        'The signature for email answers.' => '',
        'Customer Move Notify' => '',
        'OTRS sends an notification email to the customer if the ticket is moved.' => '',
        'Customer State Notify' => '',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => '',
        'Customer Owner Notify' => '',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => '',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => '',

        # Template: AdminQueueResponsesForm
        'Answer' => '',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => '',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => '',
        'A response is default text to write faster answer (with default text) to customers.' => '',
        'Don\'t forget to add a new response a queue!' => '',
        'The current ticket state is' => '',
        'Your email address is new' => '',

        # Template: AdminRoleForm
        'Role Management' => '',
        'Add Role' => '',
        'Add a new Role.' => '',
        'Create a role and put groups in it. Then add the role to the users.' => '',
        'It\'s useful for a lot of users and groups.' => '',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => '',
        'move_into' => '',
        'Permissions to move tickets into this group/queue.' => '',
        'create' => '',
        'Permissions to create tickets in this group/queue.' => '',
        'owner' => '',
        'Permissions to change the ticket owner in this group/queue.' => '',
        'priority' => '',
        'Permissions to change the ticket priority in this group/queue.' => '',

        # Template: AdminRoleGroupForm
        'Role' => '',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => '',
        'Select the role:user relations.' => '',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'customer realname',
        'Add Salutation' => '',
        'Add a new Salutation.' => '',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBoxForm
        'SQL Box' => '',
        'Go' => '',
        'Select Box Result' => '',

        # Template: AdminService
        'Service Management' => '',
        'Add Service' => '',
        'Add a new Service.' => '',
        'Sub-Service of' => '',

        # Template: AdminSession
        'Session Management' => '',
        'Sessions' => '',
        'Uniq' => 'kill all sessions',
        'Kill all sessions' => '',
        'Session' => '',
        'Content' => '',
        'kill session' => '',

        # Template: AdminSignatureForm
        'Signature Management' => '',
        'Add Signature' => '',
        'Add a new Signature.' => '',

        # Template: AdminSLA
        'SLA Management' => '',
        'Add SLA' => '',
        'Add a new SLA.' => '',

        # Template: AdminSMIMEForm
        'S/MIME Management' => '',
        'Add Certificate' => '',
        'Add Private Key' => '',
        'Secret' => '',
        'Hash' => 'In this way you can directly edit the certification and private keys in file system.',
        'In this way you can directly edit the certification and private keys in file system.' => '',

        # Template: AdminStateForm
        'State Management' => '',
        'Add State' => '',
        'Add a new State.' => '',
        'State Type' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => '',
        'See also' => '',

        # Template: AdminSysConfig
        'SysConfig' => 'Group selection',
        'Group selection' => '',
        'Show' => '',
        'Download Settings' => '',
        'Download all system config changes.' => '',
        'Load Settings' => '',
        'Subgroup' => '',
        'Elements' => '',

        # Template: AdminSysConfigEdit
        'Config Options' => '',
        'Default' => '',
        'New' => '',
        'New Group' => '',
        'Group Ro' => '',
        'New Group Ro' => '',
        'NavBarName' => '',
        'NavBar' => 'AccessKey',
        'Image' => '',
        'Prio' => '',
        'Block' => '',
        'AccessKey' => '',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => '',
        'Add System Address' => '',
        'Add a new System Address.' => '',
        'Realname' => '',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => '',

        # Template: AdminTypeForm
        'Type Management' => '',
        'Add Type' => '',
        'Add a new Type.' => '',

        # Template: AdminUserForm
        'User Management' => '',
        'Add User' => '',
        'Add a new Agent.' => '',
        'Login as' => '',
        'Firstname' => '',
        'Lastname' => '',
        'Start' => '',
        'End' => '',
        'User will be needed to handle tickets.' => '',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Nezabudnite prida novho pouvatea do skupn a/alebo loh!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Uvatelia <-> skupiny ',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'adresr',
        'Return to the compose screen' => 'Sp na obrazovku vytvorenia.',
        'Discard all changes and return to the compose screen' => 'Info',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => '',
        'Release Note' => '',
        'Level' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => '',
        'Object' => '',
        'Link Object' => '',
        'with' => 's',
        'Select' => '',
        'Unlink Object: %s' => '',

        # Template: AgentLookup
        'Lookup' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => '',
        'spelling error(s)' => '',
        'or' => '',
        'Apply these changes' => '',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => '',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => '',
        'Fixed' => '',
        'Please select only one element or turn off the button \'Fixed\'.' => '',
        'Absolut Period' => '',
        'Between' => '',
        'Relative Period' => '',
        'The last' => '',
        'Finish' => '',
        'Here you can make restrictions to your stat.' => '',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => '',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => '',
        'Permissions' => '',
        'Format' => 'Formt',
        'Graphsize' => '',
        'Sum rows' => '',
        'Sum columns' => '',
        'Cache' => '',
        'Required Field' => '',
        'Selection needed' => '',
        'Explanation' => '',
        'In this form you can select the basic specifications.' => '',
        'Attribute' => '',
        'Title of the stat.' => '',
        'Here you can insert a description of the stat.' => '',
        'Dynamic-Object' => '',
        'Here you can select the dynamic object you want to use.' => '',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '',
        'Static-File' => '',
        'For very complex stats it is possible to include a hardcoded file.' => '',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => '',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => '',
        'Multiple selection of the output format.' => '',
        'If you use a graph as output format you have to select at least one graph size.' => '',
        'If you need the sum of every row select yes' => '',
        'If you need the sum of every column select yes.' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => '',
        '(Note: Useful for big databases and low performance server)' => '',
        'With an invalid stat it isn\'t feasible to generate a stat.' => '',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => '',
        'Scale' => '',
        'minimal' => '',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => '',
        'maximal period' => '',
        'minimal scale' => '',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => '',
        'File is not a Stats config' => '',
        'No File selected' => '',

        # Template: AgentStatsOverview
        'Results' => '',
        'Total hits' => '',
        'Page' => '',

        # Template: AgentStatsPrint
        'Print' => '',
        'No Element selected.' => '',

        # Template: AgentStatsView
        'Export Config' => '',
        'Information about the Stat' => '',
        'Exchange Axis' => '',
        'Configurable params of static stat' => '',
        'No element selected.' => '',
        'maximal period from' => '',
        'to' => '',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => '',
        'You need a email address (e. g. customer@example.com) in To:!' => '',
        'Bounce ticket' => '',
        'Ticket locked!' => 'zamknut poiadavka',
        'Ticket unlock!' => 'neuzamknut poiadavka!',
        'Bounce to' => '',
        'Next ticket state' => '',
        'Inform sender' => '',
        'Send mail!' => '',

        # Template: AgentTicketBulk
        'You need to account time!' => '',
        'Ticket Bulk Action' => '',
        'Spell Check' => '',
        'Note type' => '',
        'Next state' => '',
        'Pending date' => 'termn vybavenia',
        'Merge to' => '',
        'Merge to oldest' => '',
        'Link together' => '',
        'Link to Parent' => '',
        'Unlock Tickets' => '',

        # Template: AgentTicketClose
        'Ticket Type is required!' => '',
        'A required field is:' => '',
        'Close ticket' => '',
        'Previous Owner' => '',
        'Inform Agent' => '',
        'Optional' => '',
        'Inform involved Agents' => '',
        'Attach' => '',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => '',
        'Compose answer for ticket' => '',
        'Pending Date' => '',
        'for pending* states' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Zme klienta poiadavky.',
        'Set customer user and customer id of a ticket' => 'Nastavi klientskho uvatea a klientsk id poiadavky',
        'Customer User' => 'Klient-uvate',
        'Search Customer' => 'Hada klienta',
        'Customer Data' => 'Klientsk daje',
        'Customer history' => 'Histria klienta',
        'All customer tickets.' => 'poiadavky vetkch klientov',

        # Template: AgentTicketEmail
        'Compose Email' => 'vytvori e-mail',
        'new ticket' => 'nov poiadavka',
        'Refresh' => '',
        'Clear To' => 'vyma: Komu',
        'All Agents' => 'vetci agenti',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'typ lnku',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'zmeni von text poiadavky',

        # Template: AgentTicketHistory
        'History of' => 'histria',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => '',
        'Ticket Merge' => '',

        # Template: AgentTicketMove
        'Move Ticket' => '',

        # Template: AgentTicketNote
        'Add note to ticket' => '',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => '',
        'Service Time' => '',
        'Update Time' => '',
        'Solution Time' => '',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => '',

        # Template: AgentTicketOverviewNavBar
        'Filter' => '',
        'Change search options' => '',
        'Tickets' => '',
        'of' => '',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => '',
        'Contact customer' => '',
        'Change queue' => '',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => '',
        'up' => '',
        'sort downward' => '',
        'down' => '',
        'Escalation in' => '',
        'Locked' => '',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Zme poiadavku majitea.',

        # Template: AgentTicketPending
        'Set Pending' => 'nastavi vybavenie',

        # Template: AgentTicketPhone
        'Phone call' => 'hovor',
        'Clear From' => 'zmaza Od',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'ist',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'info o poiadavkch',
        'Accounted time' => 'Escalation in',
        'Linked-Object' => '',
        'by' => '',

        # Template: AgentTicketPriority
        'Change priority of ticket' => '',

        # Template: AgentTicketQueue
        'Tickets shown' => '',
        'Tickets available' => '',
        'All tickets' => '',
        'Queues' => '',
        'Ticket escalation!' => '',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => '',

        # Template: AgentTicketSearch
        'Ticket Search' => '',
        'Profile' => '',
        'Search-Template' => '',
        'TicketFreeText' => '',
        'Created in Queue' => '',
        'Article Create Times' => '',
        'Article created' => '',
        'Article created between' => '',
        'Change Times' => '',
        'No change time settings.' => '',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Result Form' => '',
        'Save Search-Profile as Template?' => '',
        'Yes, save it with name' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'Keyword',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => '',
        'Collapse View' => '',
        'Split' => '',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => '',
        'Save filter settings as default' => '',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Print',

        # Template: CustomerFooter
        'Powered by' => 'Login',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'Lost your password?',
        'Lost your password?' => '',
        'Request new password' => '',
        'Create Account' => '',

        # Template: CustomerNavigationBar
        'Welcome %s' => '',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'as',
        'No time settings.' => 'iadne asov nastavenia',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => '',

        # Template: Footer
        'Top of Page' => '',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Web-Installer',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'accept license',
        'Welcome to %s' => 'Vitajte v %',
        'Accept license' => '',
        'Don\'t accept license' => '',
        'Admin-User' => '',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Admin-Password' => '',
        'Database-User' => '',
        'default \'hot\'' => '',
        'DB connect host' => '',
        'Database' => '',
        'Default Charset' => 'Predvolen znakov sada',
        'utf8' => '',
        'false' => '',
        'SystemID' => '',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => 'Identifikcia systmu. Kad slo poiadavky a kad http zana tmto slo.',
        'System FQDN' => '',
        '(Full qualified domain name of your system)' => 'Cel nzov domny vho systmu',
        'AdminEmail' => '',
        '(Email of the system admin)' => 'E-mail systmovho administrtora',
        'Organization' => 'Organizcia',
        'Log' => '',
        'LogModule' => '',
        '(Used log backend)' => '',
        'Logfile' => '',
        '(Logfile just needed for File-LogModule!)' => 'Sbor zznamov je potrebn pre Sbor Log Module!',
        'Webfrontend' => 'webov rozhranie',
        'Use utf-8 it your database supports it!' => 'Poui utf-8 na podporu Vaej databzy.',
        'Default Language' => 'Predvolen jazyk',
        '(Used default language)' => 'Pouvan predvolen jazyk',
        'CheckMXRecord' => '',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'Pri skladani (kompozicii) odpovede skontroluje MX zaznamy pouzitych emailovych adries. ',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Aby ste mohli pouzivat OTRS =>  musite zadat nasledovne: do Vasho prikazoveho riadku (terminal/shell) =>  pricom musite byt prihlaseny ako root:',
        'Restart your webserver' => 'dat "nasledovne") do Vasho prikazoveho riadku (terminal/shell) =>  pricom musite byt prihlaseny ako root:',
        'After doing so your OTRS is up and running.' => 'Ak to urobte =>  V OTRS je spusten.',
        'Start page' => 'Prv strana',
        'Your OTRS Team' => 'V OTRS tm',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Nepovolen',

        # Template: Notify
        'Important' => 'Dleit',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'vytlaen',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'OTRS test strany',
        'Counter' => 'Potadlo',

        # Template: Warning

        # Template: YUI

        # Misc
        'Edit Article' => '',
        'al ' => 'All Customer variables like defined in config option CustomerUser.',
        'Hlsenia s poslan zstupcovi alebo zkaznkovi.' => 'Config options (e. g. <OTRS_CONFIG_HttpType>)',
        'Nhad' => 'Download',
        'Poli mail!' => 'A message should have a subject!',
        'Moduly' => 'Param 1',
        'Create Database' => 'Vytvor databzu',
        'vsetky zakaznikove premenne ako tie definovane v konfiguracnej moznosti (volbe) CustomerUser' => 'The current ticket state is',
        'parameter 1' => 'Param 2',
        'Skupiny' => 'Misc',
        'DB Host' => 'DB ',
        'V e-mail s slom poiadavky <OTRS_POIADAVKA> je pripojen k <OTRS_PRIPOJI_K_POIADAVKE>' => 'Queue ID',
        'monosti konfigurcie (napr. <OTRS_CONFIG_HttpType>)' => 'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)',
        'Meno' => 'Lastname',
        'Stiahnu' => 'Rebuild',
        'bit' => 'Key',
        'Reakcie <-> Rady manamentu' => 'Answer',
        'dolu' => 'You need to use a ticket number!',
        'Ticket Number Generator' => 'Generova sel poiadaviek',
        'vsledok hadania ' => 'Change search options',
        'predchdzajci' => 'Block',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Tmto spsobom mete priamo upravova kov nastavenie v Kenel/Config.',
        'Create new Phone Ticket' => 'Vytvor nov telefonick poiadavku',
        'U' => 'sort downward',
        'riadenie relcie' => 'Sessions',
        'Poiadavky vybran pre hromadn akciu!' => 'You need min. one selected Ticket!',
        'hlsenie klientovho pohybu' => 'Customer State Notify',
        'kontaktova klienta' => 'Change queue',
        'priorita' => 'Permissions to change the ticket priority in this group/queue.',
        'If it is not displayed correctly => ' => 'Ak nie je zobrazen sprvne =>  ',
        'Prehad radu.' => 'PhoneView',
        'Chyba pravopisu' => 'or',
        'Can\'t update password =>  need min. 1 digit!' => 'Nemono aktualizova heslo =>  potrebujete minimlne 1 slicu.',
        'Hodnota' => 'Set',
        'Can not delete link with %s!' => '',
        'Can\'t update password =>  passwords doesn\'t match! Please try it again!' => 'Nemono aktualizova heslo =>  hesl nezhoduj.',
        'Zstupca' => 'TicketFreeText',
        'as vybavenia' => 'for pending* states',
        'Close!' => 'Zatvori!',
        'Vyhadvacia ablna' => 'Created in Queue',
        'Pre hlsenie chyby =>  kliknite tu!' => 'Comment (internal)',
        'Vetky poiadavky' => 'Queues',
        'info' => 'Link Object',
        'Sprva mus ma telo.' => 'You need to account time!',
        'Typ zatvorenia' => 'Time units',
        'premiestni_do' => 'Permissions to move tickets into this group/queue.',
        'Added User %s""' => 'Pridan pouvate %',
        'Prestava' => 'Reinstall',
        'No means, send agent and customer notifications on changes.' => '',
        'Rady <-> Riadenie automatickch odpoved' => 'Queue Management',
        'predvolen (?)' => 'DB connect host',
        'A web calendar' => 'webov kalendr',
        'Tmto spsobom moene priamo meni osvedenie a osobn k v systme sborov.' => 'System State Management',
        'to get the realname of the sender (if given)' => 'zobrazi skuton meno odosielatea (ak je dan)',
        'podskupina' => 'Elements',
        'OTRS DB Name' => 'OTRS DB meno',
        'pre agentovo pouvatesk id' => 'for agent login',
        'Notification (Customer)' => '',
        'Histria systmu' => 'Name is required!',
        'Reakcia je prednastaven text pre rchlejie psanie odpoved klientom.' => 'Don\'t forget to add a new response a queue!',
        'neformlny zstupca' => 'Optional',
        'Select Source (for add)' => 'vyber zdroj (pre pridanie)',
        'PGP manament' => 'Identifier',
        'Can\'t update password =>  need min. 2 characters!' => 'Nemono aktualizova heslo =>  potrebujete minimlne 2 psmen!',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => '',
        'asov jednotka' => ' (work units)',
        'Child-Object' => '',
        'Days' => 'Dni',
        'vyhadvanie poiadavky' => 'Profile',
        'Can\'t update password =>  need min. 8 characters!' => 'Nemono aktualizova heslo =>  potrebujete minimlne 8 psmen.',
        'Ak zstupca uzamkne poiadavku a on/ona nepole odpove do uritho asu =>  bude poiadavka automaticky odomknut a tak zobraziten pre vetkch zstupcov.' => 'If a ticket will not be answered in this time =>  just only this ticket will be shown.',
        'poet derov' => 'Site',
        'komentr (vntorn)' => 'A article should have a title!',
        'Prehad hovorov' => 'Top of Page',
        'Workflow Groups' => '?',
        'Zaiatok strany' => 'Home',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => '',
        'systmov zznam' => 'Time',
        'pre priezvisko agenta' => 'for agent user id',
        'ID radu' => 'Move Ticket',
        'OTRS posiela klientom oznmenie e-mailom =>  ak bola poiadavka premiestnen.' => 'OTRS sends an notification email to the customer if the ticket state has changed.',
        'as' => 'Users',
        'pre meno agenta' => 'for agent lastname',
        'Adresti' => 'Body',
        'SMIME riadenie' => 'Add Certificate',
        'Tlai' => 'Keywords',
        'riadenie balka' => 'Uninstall',
        'prida poznmku k poiadavke' => 'Inform Agent',
        'vyber prieinok' => 'SQL',
        'Ticket %s" created!"' => 'poiadavka % vytvoren',
        'pripomienkov sprva' => 'Reminder',
        'DB Admin User' => 'DB admin pouvate',
        'detail' => 'Lookup',
        'for agent user id' => '',
        'Otvoren poiadavky' => 'Split',
        'parameter 4' => 'Param 5',
        'Change user <-> group settings' => 'Zme pouvatea <-> nastavenie skupiny',
        'No such Ticket Number %s"! Can\'t link it!"' => 'iadna poiadavka slo %. ',
        'Can\'t update password =>  need 2 lower and 2 upper characters!' => 'Nemono aktualizova heslo =>  potrebujete 2 mal a 2 vek psmen',
        'klientsk uvate' => 'Add Note',
        'Je to pouiten pre mnostvo uvateov a skupn.' => 'Roles <-> Groups Management',
        'vber skupiny' => 'Show',
        'Problem' => 'Solution',
        'Zmazan poiadavky' => 'Warning! This tickets will be removed from the database! This tickets are lost!',
        'vsledky' => 'Total hits',
        'Escalation' => '',
        'Podrad (oho)' => 'Unlock timeout',
        '"}' => '',
        'Order' => '',
        'poiadavky' => 'All messages',
        'next step' => 'da krok',
        'Follow up' => 'nasledujci',
        'odpove' => 'Responses <-> Attachments Management',
        'Naozaj chcete zmaza tento objekt?' => 'System History',
        'prepojen objekt' => 'Parent-Object',
        'Stat#' => '',
        'prednastaven' => 'Prio',
        'hlsenie majitea klienta' => 'If an agent locks a ticket and he/she will not send an answer within this time =>  the ticket will be unlock automatically. So the ticket is viewable for all other agents.',
        'OTRS posiela klientom oznmenie e-mailom =>  ak sa zmenil stav poiadavky.' => 'OTRS sends an notification email to the customer if the ticket owner has changed.',
        'Spusti!' => 'x',
        'Ine' => 'Notification Management',
        'Create new database' => 'Vytvor nov databzu',
        'nov skupina RO' => 'New Group Ro',
        'Kontrola pravopisu' => 'spelling error(s)',
        'Riadenie radov' => 'Sub-Queue of',
        'Potrebujete asov konto!' => 'Close ticket',
        'Send me a notification if a ticket is moved into one of My Queues"."' => 'Poli mi oznmenie =>  ak je poiadavka premiestnen do jednho z mojich radov.',
        'priloi' => 'Pending Date',
        'zobrazen poiadavky' => 'Page',
        'Reintalova' => 'PGP Management',
        'loha' => 'Roles <-> Users Management',
        'zme monosti hadania' => '"}',
        'neakceptova licenciu' => 'Admin-User',
        'Neue Gruppe Ro' => 'NavBarName',
        'pripomienkova' => 'Sort by',
        'Prstupov k' => 'System Email Addresses Management',
        'ukza' => 'Download Settings',
        'ArticleID' => 'ID lnku',
        'Monosti majitea poiadavky (napr. <OTRS_OWNER_UserFirstname>)' => 'Options of the current user who requested this action (e. g. <OTRS_OWNER_UserFirstname>)',
        'triedi hore' => 'U',
        'hromadn akcia poiadaviek' => 'Spell Check',
        'nevybaven sprvy' => 'Reminder messages',
        'Kov slov' => 'Symptom',
        'as eskalcie' => '0 = no escalation',
        'pridaj osobn k' => 'Secret',
        '(Ticket identifier. Some people want to set this to e. g. \'Ticket#\',\'Call#\' or \'MyTicket#\')' => '(Identifiktor poiadavky. Niektor udia to chc nastavi naprklad: \'Ticket#\', \'Call#\' alebo \'MyTicket#\')',
        'monosti' => 'Inform involved Agents',
        'Balk' => 'Online Repository',
        'monosti configurcie' => 'Default',
        'Ticket Escalation View' => '',
        'Today' => '',
        'parameter 6' => 'Save',
        'Load' => 'Nata',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => '',
        'Message for new Owner' => 'sprva od novho majitea.',
        'to get the first 5 lines of the email' => 'zobrazi prvch 5 riadkov emailu',
        'Package not correctly deployed =>  you need to deploy it again!' => 'Balk nie je sprvne rozmiestnen =>  muste ho rozmiestni ete raz.',
        'Uloi' => 'Group Management',
        'login klientskho uvatea' => '(e. g. U5150)',
        'km' => 'Change priority of ticket',
        'informova odosielatea.' => 'Your email with ticket number <OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information."',
        'Sort by' => '',
        'nata nastavenia' => 'Subgroup',
        'OTRS DB Password' => 'OTRS DB heslo',
        'Hlavika' => 'Value',
        'Tomorrow' => '',
        'matersk objekt' => 'Child-Object',
        'Zatvori poiadavku' => 'Note Text',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number> =>  <OTRS_TICKET_ID> =>  <OTRS_TICKET_Queue> =>  <OTRS_TICKET_State>)' => 'Monosti dajov poiadavky (napr. <OTRS_TICKET_Number> =>  <OTRS_TICKET_ID> =>  <OTRS_TICKET_Queue> =>  <OTRS_TICKET_State>)',
        'to get the first 20 character of the subject' => 'zobrazi prvch 20 vlastnost subjektu',
        'Select the customeruser:service relations.' => '',
        'DB Admin Password' => 'DB heslo administrtora',
        'miestna schrnka' => 'Status',
        'zrui relcie' => 'Signature Management',
        'histria klientskho hadania' => 'Customer history search (e. g. ID342425")."',
        'Povolenie zmeni majitea poiadavky v tejto skupine/rade.' => 'priority',
        'preskoi poiadavku' => 'Bounce to',
        'Drop Database' => 'vymaza databzu',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',
        'vytvori odpove' => 'Contact customer',
        'DB pripojenie host' => 'Database',
        'Vytvori v rade.' => 'Result Form',
        'FileManager' => 'Sprvca sborov',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => '',
        'Pending type' => 'typ vybavenia',
        'Rozdeli' => 'Locked',
        'Povolenie presun poiadavky do tejto skupiny/radu.' => 'create',
        'Poadova nov heslo' => 'Create Account',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => '',
        'odintalova' => 'Verion',
        'Zamkn' => 'Traceback',
        'Vybavi =>  alebo filtrova prichdzujce e-maly =>  na bze e-mailu X-header! Reg-Exp je tie mon!' => 'If you use RegExp =>  you also can use the matched value in () as [***] in \'Set\'.',
        'vytvorit nove skupiny pre osetrenie pristupovych prav roznych skupin agentov (napr. Oddelenie nkupu =>  oddelenie predaja => ..)' => 'It\'s useful for ASP solutions.',
        '0 = iadne odomknanie' => 'Escalation time',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'predchdzajci majite' => 'Add note to ticket',
        'Hlsenie' => 'Notifications are sent to an agent or a customer.',
        '(Used ticket number format)' => '(Pouite seln formt poiadavky)',
        'Reminder' => '',
        'Vaa vlastn poiadavka' => 'Compose Follow up',
        'Je prca platn' => 'Schedule',
        'Incident' => 'Udalos',
        'Vytvori odpove na poiadavku.' => 'Attach',
        'nov' => 'New Group',
        'OTRS DB connect host' => 'OTRS DB pripojenie',
        'Sprva hlsen' => 'Notification',
        'All Agent variables.' => '',
        ' (work units)' => '',
        'hore' => 'down',
        'Next Week' => '',
        'All Customer variables like defined in config option CustomerUser.' => '',
        'pozri aj' => 'SysConfig',
        'Ak je poiadavka zatvoren a klient pole nasledujcu poiadavku =>  poiadavka bude zamknut pre starho majitea.' => 'Will be the sender address of this queue for email answers.',
        'relcia' => 'kill session',
        'Poui tieto zmeny.' => 'A message should have a To: recipient!',
        'funkcia <-> riadenie uvateov' => 'Active',
        'accept license' => '',
        'strana' => 'Tickets available',
        'Podpis pre e-mailov odpove.' => 'OTRS sends an notification email to the customer if the ticket is moved.',
        'Telo sprvy' => 'send',
        'for agent lastname' => '',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => '',
        'posledn spustenie' => 'Run Now!',
        'Reminder messages' => '',
        'nasledujce monosti' => 'Ticket lock after a follow up',
        'Verzia' => 'Vendor',
        'Parent-Object' => '',
        'Vitajte v %' => 'of',
        'Of couse this feature will take some system performance it self!' => '',
        'Nastavi' => 'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.',
        'z' => 'Click here to report a bug!',
        'Rozvrh' => 'Fulltext-Search in Article (e. g. Mar*in" or "Baue*")"',
        'Detail' => '',
        'Your own Ticket' => '',
        'TicketZoom' => 'Zvi poiadavku',
        'vytvori' => 'Permissions to create tickets in this group/queue.',
        'Reakcie <-> Prlohy manamentu' => 'Response Management',
        'histria klientskho hadania (napr. ID342425")' => 'No * possible!',
        'Send me a notification if there is a new ticket in My Queues"."' => 'Poli mi notifikciu =>  ak je nov poiadavka v MyQueue ?',
        'Rieenie' => 'Modified',
        'Don\'t forget to add a new user to groups!' => 'Nezabudnite prida novho pouvatea do skupn!',
        'Open Tickets' => '',
        'Ak pouvate RegExp =>  mete tie pouva prepojen hodnoty v () ako [***] v \'Set\'.' => 'Queue <-> Auto Responses Management',
        'Text bez poiadavky' => 'Ticket Lock',
        'Rady' => 'Ticket escalation!',
        'presu poiadavku' => 'Previous Owner',
        'triedi dolu' => 'D',
        'Uvatelia' => 'Groups',
        'CreateTicket' => 'Vytvor poiadavku',
        'If nothing is selected =>  then there are no permissions in this group (tickets will not be available for the user).' => 'Ak nie je ni vybran =>  nie je dovolen pracova v tejto skupine (poiadavky nie s dostupn pre uvatea)',
        'You have to select two or more attributes from the select field!' => '',
        'vytvori nasledujcu' => 'Compose Answer',
        'parameter 2' => 'Param 3',
        'Vae MySQL DB' => 'Database-User',
        'obraz' => 'Image',
        'System Settings' => 'Systmov nastavenia',
        'WebWatcher' => '',
        'stav' => 'Overview',
        'Povolenie zmeni prioritu poiadavky v tejto skupine/rade.' => 'Role',
        'Finished' => 'Ukonen',
        'vyhada' => 'Ticket selected for bulk action!',
        'nov sprvy' => 'Pending messages',
        'D' => 'Ticket Status View',
        'typ poznmky' => 'Unlock Tickets',
        'nov skupina' => 'Group Ro',
        'All messages' => '',
        'System Status' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'lohy  <-> riadenie skupn' => 'move_into',
        'odpove riadenia' => 'A response is default text to write faster answer (with default text) to customers.',
        'Artefact' => 'Artefakt',
        'Object already linked as %s.' => '',
        'zru vetky relcie' => 'Session',
        '0 = iadne zvyovanie' => 'Follow up Option',
        'relcie' => 'Uniq',
        'pripojen poiadavka' => 'Merge to',
        'uzamkn poiadavku po nasledovnom' => 'Systemaddress',
        'Pozor! Tto poiadavka bude vymazan z databzy. Tieto poiadavky s straten!' => 'Modules',
        'profil' => 'Search-Template',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
        'Posla' => 'GenericAgent',
        'Monosti dajov aktulnohe klientskho uvatea (napr. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Package Manager',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'akceptova licenciu' => 'don\'t accept license',
        'obsah' => 'New',
        'A web mail client' => 'Web mail client',
        'Nezabudnite prida nov odpove radu!' => 'Next state',
        'Select Box vsledok' => 'Session Management',
        'preskoi na' => 'Next ticket state',
        'pre login agenta' => 'Select Box',
        'vyber funkciu: prepojenia uvateov' => 'Salutation Management',
        'Ak je v et ' => 'PostMaster Filter Management',
        'poradie' => 'up',
        'Compose Follow up' => '',
        'dcrsky objekt' => 'by',
        '(napr. U5150)' => 'Agent',
        'identifiktor' => 'Bit',
        'parameter 3' => 'Param 4',
        'pripoji k' => 'Your email with ticket number <OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>"."',
        'zmeni rady' => 'Ticket Search',
        'Databza' => 'Create',
        'WebMail' => '',
        'generovan zstupca' => 'Job-List',
        'Potrebujete minimlne 1 vybran poiadavku!' => 'Spell Checker',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => '',
        'Spoji' => 'Header',
        'zoznam loh' => 'Last run',
        'Uloi vyhadvac profil ako ablnu?' => 'Yes =>  save it with name',
        'kontrola pravopisu' => 'Note type',
        'Stiahnu vetky zmeny systmovej konfigurcie.' => 'Load Settings',
        'DB Type' => 'DB typ',
        'Termin1' => 'Termn1',
        'Vytvori' => '0',
        'Sprva skupn' => 'The admin group is to get in the admin area and the stats group to get stats area.',
        'Fulltextov vyhadvanie v lnku (napr. Mar*in" alebo "Baue*")"' => '(e. g. 10*5155 or 105658*)',
        'kill all sessions' => '',
        'to get the from line of the email' => 'zobrazi ',
        'iadna * nie je mon' => 'Search Result',
        'k' => 'Fingerprint',
        'OTRS posiela klientom oznmenie e-mailom =>  ak sa zmenil majite poiadavky.' => 'Responses <-> Queue Management',
        'Vetky prichdzajce e-maily s jednm tom bud vybaven vo vybranom rade.' => 'If your account is trusted =>  the already existing x-otrs header at arrival time (for priority =>  ...) will be used! PostMaster filter will be used anyway.',
        'Sprva uvateov' => 'Firstname',
        'zvyova v' => 'Linked-Object',
        'My Queue' => 'Mj rad',
        'intalova' => 'Package',
        'Select Box' => '',
        'Riadenie stavu systmu.' => 'State Type',
        'Admin-pouvate' => 'Admin-Password',
        'Monosti aktulneho pouvatea =>  ktor poaduje tieto akcie (napr. <OTRS_CURRENT_UserFirstname>)' => 'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Text poznmky' => 'Close type',
        'New messages' => '',
        'parameter 5' => 'Param 6',
        'zobrazenie stavu poiadavky' => 'Open Tickets',
        'Can\'t update password =>  invalid characters!' => 'Nemono aktualizova heslo =>  neplatn znaky.',
        '(pracovn jednotka)' => 'A message must be spell checked!',
        'Can not create link with %s!' => '',
        'stupovanie poiadaviek' => 'Your own Ticket',
        'Sajn' => 'Hash',
        'vber' => 'Results',
        'Adresa odosielatea tohto radu pre e-mailov odpove.' => 'The salutation for email answers.',
        'majite' => 'Permissions to change the ticket owner in this group/queue.',
        'Povolenie vytvori poiadavku v tejto skupine/rade.' => 'owner',
        'Ak nebude na poiadavku odpovedan do uritho asu =>  bude tto poiadavka zobrazen!' => 'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.',
        '(napr. 234321)' => 'Customer User Login',
        'hlsenie stavu klienta' => 'Customer Owner Notify',
        'Linked as' => '',
        'typ postavenia' => 'Take care that you also updated the default states in you Kernel/Config.pm!',
        'Stiahnu nastavenia.' => 'Download all system config changes.',
        'Zme prioritu poiadavky.' => 'Tickets shown',
        'Pozdrav pre e-mailov odpove.' => 'The signature for email answers.',
        'vetky sprvy' => 'New messages',
        'Dveryhodn' => 'Dispatching',
        'Zabudli ste heslo?' => 'Request new password',
        'Priezvisko' => 'User will be needed to handle tickets.',
        'asti' => 'Config Options',
        'Sprva mus ma prjemcu!' => 'You need a email address (e. g. customer@example.com) in To:!',
        'Delete old database' => 'Vyma star databzu',
        'Skuton meno' => 'All incoming emails with this Email" (To:) will be dispatched in the selected queue!"',
        'alebo' => 'Apply these changes',
        'Vsledok z' => 'Save Search-Profile as Template?',
        'Vetky prichdzajce e-maily s prjemcom =>  bud vybaven v radoch.' => 'User Management',
        'Vykonanie' => 'All incoming emails with one account will be dispatched in the selected queue!',
        'skuton meno klienta' => 'for agent firstname',
        'riadenie funkci' => 'Create a role and put groups in it. Then add the role to the users.',
        'Muste napsa emailov adresu (napr. klient@prklad.com) do Prjemca:!' => 'Bounce ticket',
        'Tmto spsobom mete priamo upravova konfigurcie' => 'POP3 Account Management',
        'Muste pouva slo poiadavky!' => 'Ticket Merge',
        'A web file manager' => 'Sprvca weborch sborov',
        'Have a lot of fun!' => 'Vea zbavy',
        'Symptm' => 'Problem',
        'Uloi prcu ako?' => 'Is Job Valid?',
        'no =>  ulo s menom.' => 'Customer history search',
        'Platnos' => 'In this way you can directly edit the keyring configured in SysConfig.',
        'Send no notifications' => '',
        'POP3 Account Management' => 'Host',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
        'sprva systmovej e-mailovej adresy' => 'Email',
        'Skutone chcete odintalova tento balk?' => 'Install',
        'System State Management' => '',
        'OTRS DB User' => 'OTRS DB pouvate',
        'Mailbox' => 'Tickets',
        'systmov adresa' => 'Customer Move Notify',
        'maximal period form' => '',
        'Vytvori et' => 'Welcome %s',
        'Unlock poiadavky.' => 'A message should have a body!',
        'TicketID' => 'ID poiadavky',
        'Vaa e-mailov adresa je nov.' => 'Role Management',
        'aktvny' => 'Select the role:user relations.',
        'triedi poda' => 'Order',
        'dostupn poiadavky' => 'All tickets',
        'priada poznmku' => 'CMD',
        'limit' => 'Select Box Result',
        'Escaladed Tickets' => '',
        'Dvajte pozor =>  i je aktualizovan tie ' => 'See also',
        'Zmenen' => 'Last update',
        '(napr. 10*5155 alebo 105658*)' => '(e. g. 234321)',
        'Yes means, send no agent and customer notifications on changes.' => '',
        'Stav dalej poiadavky' => 'Inform sender',
        'V sprve mus by skontrolovan pravopis.' => 'Compose answer for ticket',
        'podpis vedenia' => 'SMIME Management',
        'Je prca platn?' => 'Is Job Valid',
        'Vytvori funkciu a da ju do skupiny. Potom prida funkciu uvateom.' => 'It\'s useful for a lot of users and groups.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => '',
        'Aktulny stav poiadavky je' => 'Your email address is new',
        'pouvate databzy' => 'default \'hot\'',
        'Sprva by mala ma predmet!' => 'Ticket Bulk Action',
        'Ticket Status View' => '',
        'blokova' => 'NavBar',
        'Ticket selected for bulk action!' => '',
    };
    # $$STOP$$
    return;
}

1;
