# --
# Kernel/Language/hu.pm - provides hu language translation
# Copyright (C) 2006 Gabor Gancs /gg@magicnet.hu/
# Copyright (C) 2006 Krisztian Gancs /krisz@gancs.hu/
# Copyright (C) 2006 Flora Szabo /szaboflora@magicnet.hu/
# Copyright (C) 2007 Aron Ujvari <ujvari@hungary.com>
# Copyright (C) 2009 Arnold Matyasi <arn@webma.hu>
# --
# $Id: hu.pm,v 1.91.2.4 2012-03-09 07:37:04 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::hu;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.91.2.4 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2012-03-09 08:31:55

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%Y.%M.%D %T';
    $Self->{DateFormatLong}      = '%Y %B %D %A %T';
    $Self->{DateFormatShort}     = '%Y.%M.%D';
    $Self->{DateInputFormat}     = '%Y.%M.%D';
    $Self->{DateInputFormatLong} = '%Y.%M.%D - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'Igen',
        'No' => 'Nem',
        'yes' => 'igen',
        'no' => 'nem',
        'Off' => 'Ki',
        'off' => 'ki',
        'On' => 'Be',
        'on' => 'be',
        'top' => 'Teteje',
        'end' => 'vge',
        'Done' => 'Ksz',
        'Cancel' => 'Mgsem',
        'Reset' => 'Alaplls',
        'last' => 'legfeljebb ennyi ideje',
        'before' => 'legalbb ennyi ideje',
        'Today' => 'Ma',
        'Tomorrow' => 'Holnap',
        'Next Week' => 'Kvetkez Ht',
        'day' => 'nap',
        'days' => 'nap',
        'day(s)' => 'nap',
        'd' => '',
        'hour' => 'ra',
        'hours' => 'ra',
        'hour(s)' => 'ra',
        'Hours' => '',
        'h' => '',
        'minute' => 'Perc',
        'minutes' => 'perc',
        'minute(s)' => 'perc',
        'Minutes' => '',
        'm' => '',
        'month' => 'hnap',
        'months' => 'hnap',
        'month(s)' => 'hnap',
        'week' => 'ht',
        'week(s)' => 'ht',
        'year' => 'v',
        'years' => 'v',
        'year(s)' => 'v',
        'second(s)' => 'mp',
        'seconds' => 'mp',
        'second' => 'mp',
        's' => '',
        'wrote' => 'rta',
        'Message' => 'zenet',
        'Error' => 'Hiba',
        'Bug Report' => 'Hibajelents',
        'Attention' => 'Figyelem',
        'Warning' => 'Figyelem',
        'Module' => 'Modul',
        'Modulefile' => 'Modulfile',
        'Subfunction' => 'Alfunkci',
        'Line' => 'Vonal',
        'Setting' => 'Bellts',
        'Settings' => 'Belltsok',
        'Example' => 'Plda',
        'Examples' => 'Plda',
        'valid' => 'rvnyes',
        'invalid' => 'rvnytelen',
        '* invalid' => '* rvnytelen',
        'invalid-temporarily' => 'ideiglenesen rvnytelen',
        ' 2 minutes' => ' 2 Perc',
        ' 5 minutes' => ' 5 Perc',
        ' 7 minutes' => ' 7 Perc',
        '10 minutes' => '10 Perc',
        '15 minutes' => '15 Perc',
        'Mr.' => 'Mr.',
        'Mrs.' => 'Mrs.',
        'Next' => 'Kvetkez',
        'Back' => 'Vissza',
        'Next...' => 'Kvetkez...',
        '...Back' => '...Vissza',
        '-none-' => '-nincs-',
        'none' => 'semmi',
        'none!' => 'semmi!',
        'none - answered' => 'semmi - megvlaszolt',
        'please do not edit!' => 'krjk ne javtsa!',
        'Need Action' => '',
        'AddLink' => 'Kapcsolat hozzadsa',
        'Link' => 'Kapcsolat',
        'Unlink' => 'Kapcsolat feloldsa',
        'Linked' => 'Kapcsolat',
        'Link (Normal)' => 'Link (Norml)',
        'Link (Parent)' => 'Link (Szl)',
        'Link (Child)' => 'Link (Gyerek)',
        'Normal' => 'Norml',
        'Parent' => 'Szl',
        'Child' => 'Gyerek',
        'Hit' => 'Tallat',
        'Hits' => 'Tallatok',
        'Text' => 'Szveg',
        'Standard' => '',
        'Lite' => 'Egyszer',
        'User' => 'Felhasznl',
        'Username' => 'Felhasznlnv',
        'Language' => 'Nyelv',
        'Languages' => 'Nyelv',
        'Password' => 'Jelsz',
        'Preferences' => 'Belltsok',
        'Salutation' => 'Megszlts',
        'Salutations' => 'Megszltsok',
        'Signature' => 'Alrs',
        'Signatures' => 'Alrsok',
        'Customer' => 'gyfl',
        'CustomerID' => 'gyflazonost',
        'CustomerIDs' => 'gyflazonostk',
        'customer' => 'gyfl',
        'agent' => 'gyintz',
        'system' => 'rendszer',
        'Customer Info' => 'gyfl Info',
        'Customer Information' => '',
        'Customer Company' => 'gyfl cg',
        'Customer Companies' => '',
        'Company' => 'Cg',
        'go!' => 'Indts!',
        'go' => 'indts',
        'All' => 'sszes',
        'all' => 'sszes',
        'Sorry' => 'Sajnlom',
        'update!' => 'Mdosts!',
        'update' => 'mdosts',
        'Update' => 'Mdosts',
        'Updated!' => 'Frisstve!',
        'submit!' => 'Elklds!',
        'submit' => 'elklds',
        'Submit' => 'Elklds',
        'change!' => 'Vltoztats!',
        'Change' => 'Vltoztats',
        'change' => 'vltoztats',
        'click here' => 'kattints ide',
        'Comment' => 'Megjegyzs',
        'Valid' => 'rvnyessg',
        'Invalid Option!' => 'rvnytelen bellts',
        'Invalid time!' => 'Hibs idpont!',
        'Invalid date!' => 'Hibs dtum!',
        'Name' => 'Nv',
        'Group' => 'Csoport',
        'Description' => 'Lers',
        'description' => 'lers',
        'Theme' => 'Tma',
        'Created' => 'Ltrehozs ideje',
        'Created by' => 'Ltrehozta',
        'Changed' => 'Mdosts ideje',
        'Changed by' => 'Mdostotta',
        'Search' => 'Keress',
        'and' => 's',
        'between' => 'kztt',
        'Fulltext Search' => 'Szabadszavas Keress',
        'Data' => 'Adat',
        'Options' => 'Belltsok',
        'Title' => 'Cm',
        'Item' => 'Ttel',
        'Delete' => 'Trls',
        'Edit' => 'Szerkeszts',
        'View' => 'Nzet',
        'Number' => 'Szm',
        'System' => 'Rendszer',
        'Contact' => 'Kapcsolat',
        'Contacts' => 'Kapcsolatok',
        'Export' => 'Exportl',
        'Up' => 'Fel',
        'Down' => 'Le',
        'Add' => 'Hozzads',
        'Added!' => 'Hozzadva!',
        'Category' => 'Kategria',
        'Viewer' => 'Nz',
        'Expand' => 'Bvt',
        'Small' => '',
        'Medium' => '',
        'Large' => '',
        'Date picker' => '',
        'New message' => 'j zenet',
        'New message!' => 'j zenet!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Krjk vlaszoljon erre(ezekre) a jegy(ek)re hogy visszatrhessen a norml vrlista nzethez!',
        'You have %s new message(s)!' => '%s j zenete van!',
        'You have %s reminder ticket(s)!' => '%s emlkeztet jegye van!',
        'The recommended charset for your language is %s!' => 'Az ajnlott karakterkszlet az n nyelvnl %s!',
        'Change your password.' => '',
        'Please activate %s first!' => '',
        'No suggestions' => 'Nincsenek javaslatok',
        'Word' => 'Sz',
        'Ignore' => 'Figyelmen kvl hagy',
        'replace with' => 'csere ezzel',
        'There is no account with that login name.' => 'Azzal a nvvel nincs azonost.',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => 'Kilps',
        'Logout successful. Thank you for using OTRS!' => 'Kilps megtrtnt! Ksznjk, hogy az OTRS-t hasznlja!',
        'Invalid SessionID!' => 'Hibs folyamat azonost!',
        'Feature not active!' => 'Kpessg nem aktv!',
        'Agent updated!' => 'gyintz mdostva!',
        'Create Database' => 'Adatbzis ltrehozsa',
        'System Settings' => 'Rendszerbelltsok',
        'Mail Configuration' => '',
        'Finished' => 'Befejezve',
        'Login is needed!' => 'Belps szksges!',
        'Password is needed!' => 'Jelsz szksges!',
        'License' => 'Licensz',
        'Take this Customer' => 'tveszi ez az gyfl',
        'Take this User' => 'tveszi ez a felhasznl',
        'possible' => 'lehetsges',
        'reject' => 'elutasts',
        'reverse' => 'fordtott',
        'Facility' => 'Kpessg',
        'Time Zone' => '',
        'Pending till' => 'Vrakozs eddig',
        'Don\'t use the Superuser account to work with OTRS! Create new Agents and work with these accounts instead.' => '',
        'Dispatching by email To: field.' => 'Sztvlogats az e-mail cmzett mezje szerint.',
        'Dispatching by selected Queue.' => 'Sztvlogats a kivlasztott vrlista szerint.',
        'No entry found!' => 'Nem tallhat ttel!',
        'Session has timed out. Please log in again.' => 'Az folyamat idtllps miatt befejezdtt. Krjk lpjen be jra.',
        'No Permission!' => 'Nincs jogosultsg!',
        'To: (%s) replaced with database email!' => 'Cmzett: (%s) fellrva az adatbzis cmmel!',
        'Cc: (%s) added database email!' => 'Msolat: (%s) e-mail cme hozzadva az adatbzishoz!',
        '(Click here to add)' => '(Kattinston ide a hozzadshoz)',
        'Preview' => 'Elnzet',
        'Package not correctly deployed! You should reinstall the Package again!' => 'A csomag nincsen megfelelen teleptve! Teleptse jra a csomagot!',
        '%s is not writable!' => '',
        'Cannot create %s!' => '',
        'Check to activate this date' => '',
        'Customer %s added' => '',
        'Role added!' => '',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'Kapcsolat',
        'Online Customer: %s' => 'Bejelentkezett gyfl: %s',
        'Online Agent: %s' => 'Bejelentkezett gyintz: %s',
        'Calendar' => 'Naptr',
        'File' => 'Fjl',
        'Filename' => 'Fjlnv',
        'Type' => 'Tpus',
        'Size' => 'Mret',
        'Upload' => 'Feltlts',
        'Directory' => 'Knyvtr',
        'Signed' => 'Alrt',
        'Sign' => 'Alrs',
        'Crypted' => 'Kdolt',
        'Crypt' => 'Kdols',
        'PGP' => '',
        'PGP Key' => '',
        'PGP Keys' => '',
        'S/MIME' => 'S/MIME',
        'S/MIME Certificate' => '',
        'S/MIME Certificates' => '',
        'Office' => 'Iroda',
        'Phone' => 'Telefonszm',
        'Fax' => 'Fax szm',
        'Mobile' => 'Mobil szm',
        'Zip' => 'Irnytszm',
        'City' => 'Vros',
        'Street' => 'Utca',
        'Country' => 'Orszg',
        'Location' => 'Hely',
        'installed' => 'teleptett',
        'uninstalled' => 'nem teleptett',
        'Security Note: You should activate %s because application is already running!' => 'Biztonsgi megjegyzs: Aktivlnia kellene a %s modult, mert az alakalmazs mr fut!',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '',
        'printed at' => 'nyomtatva',
        'Loading...' => '',
        'Dear Mr. %s,' => 'Kedves %s r!',
        'Dear Mrs. %s,' => 'Kedves %s Hlgy',
        'Dear %s,' => 'Kedves %s!',
        'Hello %s,' => 'Hello %s!',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => 'Krem nyomja meg a Vissza gombot s prblja jra!',
        'Sent password reset instructions. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => 'Kvetkez esemnyek',
        'Event' => 'Esemny',
        'Events' => 'Esemny',
        'Invalid Token!' => 'rvnytelen token!',
        'more' => 'tovbb',
        'For more info see:' => 'Tovbbi informcirt:',
        'Package verification failed!' => 'Csomag ellenrzs nem sikerlt!',
        'Collapse' => 'sszecsuk',
        'Shown' => '',
        'News' => 'Hrek',
        'Product News' => 'Termk hrek',
        'OTRS News' => '',
        '7 Day Stats' => '',
        'Bold' => 'Kvr',
        'Italic' => 'Dlt',
        'Underline' => 'Alhzott',
        'Font Color' => 'Bet szn',
        'Background Color' => 'Httr szn',
        'Remove Formatting' => 'Formzs eltvoltsa',
        'Show/Hide Hidden Elements' => 'Mutatja/Elrejti a rejtett elemeket ',
        'Align Left' => 'Balra rendez',
        'Align Center' => 'Kzpre rendez',
        'Align Right' => 'Jobbra rendez',
        'Justify' => 'Sorkizr',
        'Header' => 'Fejlc',
        'Indent' => 'Bekezds befele',
        'Outdent' => 'Bekezds kifele',
        'Create an Unordered List' => 'Sorszmozatlan lista ltrehozsa',
        'Create an Ordered List' => 'Sorszmozott lista ltrehozsa',
        'HTML Link' => 'HTML Link',
        'Insert Image' => 'Kp beszrsa',
        'CTRL' => 'CRTL',
        'SHIFT' => 'SHIFT',
        'Undo' => 'Visszavon',
        'Redo' => 'jravon',

        # Template: AAAMonth
        'Jan' => 'Jan',
        'Feb' => 'Feb',
        'Mar' => 'Mr',
        'Apr' => 'pr',
        'May' => 'Mj',
        'Jun' => 'Jn',
        'Jul' => 'Jl',
        'Aug' => 'Aug',
        'Sep' => 'Sze',
        'Oct' => 'Okt',
        'Nov' => 'Nov',
        'Dec' => 'Dec',
        'January' => 'Janur',
        'February' => 'Februr',
        'March' => 'Mrcius',
        'April' => 'prilis',
        'May_long' => 'Mjus',
        'June' => 'Jnius',
        'July' => 'Jlius',
        'August' => 'Augusztus',
        'September' => 'Szeptember',
        'October' => 'Oktber',
        'November' => 'November',
        'December' => 'December',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Belltsok sikeresen frisstve!',
        'User Profile' => '',
        'Email Settings' => '',
        'Other Settings' => '',
        'Change Password' => 'Jelsz megvltoztatsa',
        'Current Password' => '',
        'New password' => 'j jelsz',
        'Verify password' => '',
        'Spelling Dictionary' => 'Helyesrs-ellenrz sztr',
        'Default spelling dictionary' => '',
        'Max. shown Tickets a page in Overview.' => 'Max. megjelentett jegy az ttekintsnl.',
        'The current password is not correct. Please try again!' => '',
        'Can\'t update password, your new passwords do not match. Please try again!' => '',
        'Can\'t update password, it contains invalid characters!' => '',
        'Can\'t update password, it must be at least %s characters long!' => '',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => '',
        'Can\'t update password, it must contain at least 1 digit!' => '',
        'Can\'t update password, it must contain at least 2 characters!' => '',
        'Can\'t update password, this password has already been used. Please choose a new one!' => '',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'Statisztika',
        'Sum' => '',
        'Please fill out the required fields!' => 'Krem tltse ki a ktelez mezket!',
        'Please select a file!' => 'Krem vlasszon egy fjlt!',
        'Please select an object!' => 'Krem vlasszok egy objektumot!',
        'Please select a graph size!' => 'Krem vlasszon egy grafikon mretet!',
        'Please select one element for the X-axis!' => 'Krem vlasszon egy tulajdonsgot az X tengelynek',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Krem vlasszon egy rtket vagy kapcsolja ki a \'Rgztett\' kapcsolt a megjellt meznl.',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Ha egy jellngyzetet hasznl, akkor nhny rtket is ki kell vlasztania a tulajdonsghoz!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Adjon meg egy rtket a bemeneti mezben vagy kapcsolja ki a \'Rgztett\' kapcsolt!',
        'The selected end time is before the start time!' => 'A befejezsi idnek a kezdeti id utn kell lennie!',
        'You have to select one or more attributes from the select field!' => 'Vlasszon ki egy vagy tbb rtket a mezbl!',
        'The selected Date isn\'t valid!' => 'A kivlasztott dtum rvnytelen!',
        'Please select only one or two elements via the checkbox!' => 'Krem vlasszon egy vagy kt elemet a jellngyetekbl!',
        'If you use a time scale element you can only select one element!' => 'Amennyiben egy idskla elemet is vlasztott, akkro csak egy elemet vlaszthat kzlk!',
        'You have an error in your time selection!' => 'Hibs a kivlasztott id!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'A kivlasztott id intervallum tl kicsi, krem vlasszon nagyobb sklt.',
        'The selected start time is before the allowed start time!' => 'A kivlasztott kezdsi id a megengedett kezdsi id eltt van!',
        'The selected end time is after the allowed end time!' => 'A kivlasztott befejezsi id a megengedett befejezsi id utn van!',
        'The selected time period is larger than the allowed time period!' => 'A kivlasztott ismtlds a megengedett ismtldsnl nagyobb!',
        'Common Specification' => 'ltalnos belltsok',
        'X-axis' => 'X tengely',
        'Value Series' => 'Megjelentett rtkek',
        'Restrictions' => 'Megktsek',
        'graph-lines' => 'Grafikon - vonalak',
        'graph-bars' => 'Grafikon - oszlopok',
        'graph-hbars' => 'Grafikon - vzszintes oszlopok',
        'graph-points' => 'Grafikon - pontok',
        'graph-lines-points' => 'Grafikon - vonalak-pontok',
        'graph-area' => 'Grafikon - terlet',
        'graph-pie' => 'Grafikon - torta',
        'extended' => 'Kiterjesztett',
        'Agent/Owner' => 'gyintz/Tulajdonos',
        'Created by Agent/Owner' => 'Letrehoz gyintz/tulajdonos',
        'Created Priority' => 'Ltrehozskori priorits',
        'Created State' => 'Ltrehozskori llapot',
        'Create Time' => 'Ltrehozs ideje',
        'CustomerUserLogin' => 'gyfl felhasznlneve',
        'Close Time' => 'Lezrs ideje',
        'TicketAccumulation' => 'Jegytrols',
        'Attributes to be printed' => 'Nyomtatand jellemzk',
        'Sort sequence' => 'Sorrendbe rendez',
        'Order by' => 'Sorrend',
        'Limit' => 'Sorok szma legfeljebb',
        'Ticketlist' => 'Jegylista',
        'ascending' => 'nvekv',
        'descending' => 'cskken',
        'First Lock' => 'Els zrols',
        'Evaluation by' => 'rtkels',
        'Total Time' => 'Teljes Id',
        'Ticket Average' => 'Jegy tlag',
        'Ticket Min Time' => 'Jegy min. id',
        'Ticket Max Time' => 'Jegy max. id',
        'Number of Tickets' => 'Jegyek szma',
        'Article Average' => 'Cikk ltag',
        'Article Min Time' => 'Cikk min. id',
        'Article Max Time' => 'Cikk max. id',
        'Number of Articles' => 'Cikkek szma',
        'Accounted time by Agent' => 'gyintz lal elszmolt id',
        'Ticket/Article Accounted Time' => 'Jegy/Cikk elszmolt id',
        'TicketAccountedTime' => 'JegyElszmoltId',
        'Ticket Create Time' => 'Jegy ltrehozsnak ideje',
        'Ticket Close Time' => 'Jegy lezrsnak ideje',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => '',
        'Lock' => 'Zrols',
        'Unlock' => 'Felolds',
        'History' => 'Elzmnyek',
        'Zoom' => 'Rszletek',
        'Age' => 'Kor',
        'Bounce' => 'Visszaklds',
        'Forward' => 'Tovbbts',
        'From' => 'Felad',
        'To' => 'Cmzett',
        'Cc' => 'Msolat',
        'Bcc' => 'Rejtett msolat',
        'Subject' => 'Trgy',
        'Move' => 'thelyezs',
        'Queue' => 'Vrlista',
        'Queues' => 'Vrlistk',
        'Priority' => 'Priorits',
        'Priorities' => '',
        'Priority Update' => 'Priorits mdostsa',
        'SLA' => 'SLA',
        'Service Level Agreement' => '',
        'Service Level Agreements' => '',
        'Service' => 'Szolgltats',
        'Services' => '',
        'State' => 'llapot',
        'States' => '',
        'Status' => 'llapot',
        'Statuses' => '',
        'Ticket Type' => '',
        'Ticket Types' => '',
        'Compose' => 'Kszt',
        'Pending' => 'Vrakozik',
        'Owner' => 'Tulajdonos',
        'Owner Update' => 'Tulajdonos mdostsa',
        'Responsible' => 'Felels',
        'Responsible Update' => 'Felels mdostsa',
        'Sender' => 'Kld',
        'Article' => 'Bejegyzs',
        'Ticket' => 'Jegy',
        'Createtime' => 'Ltrehozs ideje',
        'plain' => 'sima',
        'Email' => 'E-mail',
        'email' => 'e-mail',
        'Close' => 'Lezrs',
        'Action' => 'Mvelet',
        'Attachment' => 'Levlmellklet',
        'Attachments' => 'Levlmellkletek',
        'This message was written in a character set other than your own.' => 'Ezt az zenetet ms karakterkszlettel rtk mint amit n hasznl.',
        'If it is not displayed correctly,' => 'Ha nem helyesen jelent meg,',
        'This is a' => 'Ez egy',
        'to open it in a new window.' => 'hogy megnyissa j ablakban.',
        'This is a HTML email. Click here to show it.' => 'Ez egy HTML e-mail. Kattintson ide a megtekintshez.',
        'Free Fields' => 'Szabad mezk',
        'Merge' => 'Egyests',
        'merged' => 'egyestett',
        'closed successful' => 'sikeresen lezrva',
        'closed unsuccessful' => 'sikertelenl lezrva',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'All tickets' => 'sszes jegy',
        'Tickets available' => 'Elrhet jegyek',
        'Escalation' => 'Eszkalci',
        'last-search' => '',
        'QueueView' => 'Vrlista nzet',
        'Ticket Escalation View' => 'Jegy Eszkalci Nzet',
        'Message from' => '',
        'End message' => '',
        'Forwarded message from' => '',
        'End forwarded message' => '',
        'new' => 'j',
        'open' => 'nyitott',
        'Open' => 'Nyitott',
        'closed' => 'lezrt',
        'Closed' => 'Lezrt',
        'removed' => 'trlt',
        'pending reminder' => 'emlkeztetre vrakozik',
        'pending auto' => 'automatikusra vrakozik',
        'pending auto close+' => 'automatikus zrsra vrakozik+',
        'pending auto close-' => 'automatikus zrsra vrakozik-',
        'email-external' => 'kls e-mail',
        'email-internal' => 'bels e-mail',
        'note-external' => 'kls jegyzet',
        'note-internal' => 'bels jegyzet',
        'note-report' => 'jegyzet jelents',
        'phone' => 'telefon',
        'sms' => 'sms',
        'webrequest' => 'webkrs',
        'lock' => 'zrolt',
        'unlock' => 'feloldott',
        'very low' => 'nagyon alacsony',
        'low' => 'alacsony',
        'normal' => 'norml',
        'high' => 'magas',
        'very high' => 'nagyon magas',
        '1 very low' => '1 nagyon alacsony',
        '2 low' => '2 alacsony',
        '3 normal' => '3 norml',
        '4 high' => '4 magas',
        '5 very high' => '5 nagyon magas',
        'Ticket "%s" created!' => 'A "%s" jegy ltrehozva!',
        'Ticket Number' => 'Jegy szma',
        'Ticket Object' => 'Jegy objektum',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Nincs "%s" szm jegy! Nem tudom csatolni!',
        'Don\'t show closed Tickets' => 'Ne jelentse meg a lezrt jegyeket.',
        'Show closed Tickets' => 'Mutasd a lezrt jegyeket',
        'New Article' => 'j bejegyzs',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'E-mail jegy',
        'Create new Email Ticket' => 'j E-mail Jegy ltrehozsa',
        'Phone-Ticket' => 'Telefon-jegy',
        'Search Tickets' => 'Jegyek keresse',
        'Edit Customer Users' => 'gyfl felhasznl szerkesztse',
        'Edit Customer Company' => 'gyfl cg szerkesztse',
        'Bulk Action' => 'Csoportos mvelet',
        'Bulk Actions on Tickets' => 'Csoportos mvelet jegyeken',
        'Send Email and create a new Ticket' => 'E-mail kldse s j Jegy ltrehozsa',
        'Create new Email Ticket and send this out (Outbound)' => 'j E-mail jegy ltrehozsa s kikldse (Kimen)',
        'Create new Phone Ticket (Inbound)' => 'j Telefon-jegy ltrehozsa (Bejv)',
        'Overview of all open Tickets' => 'sszes nyitott jegy ttekintse',
        'Locked Tickets' => 'Zrolt jegyek',
        'My Locked Tickets' => '',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'Kvetett jegyek',
        'Watched' => 'Kvetett',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'Jegy zrolsa, hogy dolgozzon rajta!',
        'Unlock to give it back to the queue!' => 'Oldja fl, hogy visszakerljn a vrlistba!',
        'Shows the ticket history!' => 'Jegy elzmnyeinek megjelentse!',
        'Print this ticket!' => 'Jegy nyomtatsa!',
        'Change the ticket priority!' => 'Jegy prioritsnak mdostsa!',
        'Change the ticket free fields!' => 'Jegy szabad mezinek mdostsa!',
        'Link this ticket to an other objects!' => 'sszekapcsolja a jegyet egy msik objektummal!',
        'Change the ticket owner!' => 'Jegy tulajdonosnak mdostsa!',
        'Change the ticket customer!' => 'Jegyhez tartoz gyfl mdostsa!',
        'Add a note to this ticket!' => 'Megjegyzs rsa a jegyhez!',
        'Merge this ticket!' => 'Egyesti a jegyet egy msikkal!',
        'Set this ticket to pending!' => 'Jegy vrakoz llapotba helyezse!',
        'Close this ticket!' => 'Jegy lezrsa!',
        'Look into a ticket!' => 'Jegy rszletesebb megtekintse!',
        'Delete this ticket!' => 'Jegy trlse!',
        'Mark as Spam!' => 'Jegy spamnek jellse!',
        'My Queues' => 'Sajt vrlistim',
        'Shown Tickets' => 'Megjelentett jegyek',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Az n "<OTRS_TICKET>" jegy szmmal rendelkez e-mailje egyestsre kerlt a "<OTRS_MERGE_TO_TICKET>" jeggyel.',
        'Ticket %s: first response time is over (%s)!' => 'Jegy %s: els vlasz ideje letelt (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Jegy %s: els vlasz ideje le fog telni %s idn bell!',
        'Ticket %s: update time is over (%s)!' => 'Jegy %s: frissts ideje letelt (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Jegy %s: frissts ideje le fog telni %s idn bell!',
        'Ticket %s: solution time is over (%s)!' => 'Jegy %s: megolds ideje letelt (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Jegy %s: megolds ideje le fog telni %s idn bell!',
        'There are more escalated tickets!' => 'Tbb kiemelt jegy van!',
        'Plain Format' => '',
        'Reply All' => '',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'Ticket is locked by another agent.' => '',
        'New ticket notification' => 'j jegy rtests',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Kldjn nekem rtestst, ha j jegy van a "Sajt vrlistim"-ban.',
        'Send new ticket notifications' => '',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => 'Jegyzrols-lejrat rtests',
        'Send me a notification if a ticket is unlocked by the system.' => 'Kldjn rtestst ha egy jegy zrolst a renszer feloldotta.',
        'Send ticket lock timeout notifications' => '',
        'Ticket move notification' => '',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Kldjn nekem rtestst, ha egy jegyet a "Sajt vrlistim" egyikbe mozgattk.',
        'Send ticket move notifications' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Sajt vrlistknak tekintett vrlistk kivlasztsa. E-mail rtesttsek fog kapni ezekrl a vrlistkrl, amennyiben ez engedlyezett.',
        'Custom Queue' => 'Egyedi vrlistk',
        'QueueView refresh time' => 'Vrlista nzet frisstsi ideje',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '',
        'Refresh QueueView after' => '',
        'Screen after new ticket' => 'j jegy utni kperny',
        'Show this screen after I created a new ticket' => '',
        'Closed Tickets' => 'Lezrt jegyek',
        'Show closed tickets.' => 'Mutasd a lezrt jegyeket.',
        'Max. shown Tickets a page in QueueView.' => 'A megjelentett jegyek szmnak maximuma a Vrlista nzetnl.',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => '',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => '',
        'New Ticket' => 'j jegy',
        'Create new Ticket' => 'j jegy ltrehozsa',
        'Customer called' => 'gyfl telefonlt',
        'phone call' => 'telefonhvs',
        'Phone Call Outbound' => '',
        'Reminder Reached' => 'Emlkeztet lejrt',
        'Reminder Tickets' => 'Emlkeztet Jegyek',
        'Escalated Tickets' => 'Eszkallt Jegyek',
        'New Tickets' => 'j Jegyek',
        'Open Tickets / Need to be answered' => 'Nyitott Jegyek / Vlaszra vrnak',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'Trtnet::Mozgat',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Trtnet::jJegy',
        'History::FollowUp' => 'Trtnet::Vlasz',
        'History::SendAutoReject' => 'Trtnet::AutomatikusElutastsKlds',
        'History::SendAutoReply' => 'Trtnet::AutomatikusVlaszKlds',
        'History::SendAutoFollowUp' => 'Trtnet::AutomatikusReakciKlds',
        'History::Forward' => 'Trtnet::Tovbbt',
        'History::Bounce' => 'Trtnet::Visszakld',
        'History::SendAnswer' => 'Trtnet::VlaszKlds',
        'History::SendAgentNotification' => 'Trtnet::gyintzrtestsKlds',
        'History::SendCustomerNotification' => 'Trtnet::gyflrtestsKlds',
        'History::EmailAgent' => 'Trtnet::Emailgyintz',
        'History::EmailCustomer' => 'Trtnet::Emailgyfl',
        'History::PhoneCallAgent' => 'Trtnet::gyintzTelefonHvs',
        'History::PhoneCallCustomer' => 'Trtnet::gyflTelefonHvs',
        'History::AddNote' => 'Trtnet::MegjegyzsHozzads',
        'History::Lock' => 'Trtnet::Zrol',
        'History::Unlock' => 'Trtnet::Felolds',
        'History::TimeAccounting' => 'Trtnet::IdElszmols',
        'History::Remove' => 'Trtnet::Eltvolts',
        'History::CustomerUpdate' => 'Trtnet::gyflMdosts',
        'History::PriorityUpdate' => 'Trtnet::PrioritsMdosts',
        'History::OwnerUpdate' => 'Trtnet::TulajdonosVlts',
        'History::LoopProtection' => 'Trtnet::VisszacsatolsVdelem',
        'History::Misc' => 'Trtnet::Vegyes',
        'History::SetPendingTime' => 'Trtnet::VrakozsiIdBellts',
        'History::StateUpdate' => 'Trtnet::llapotMdosts',
        'History::TicketFreeTextUpdate' => 'Trtnet::JegySzabadSzvegMdosts',
        'History::WebRequestCustomer' => 'Trtnet::gyflWebKrs',
        'History::TicketLinkAdd' => 'Trtnet::JegyCsatolsHozzads',
        'History::TicketLinkDelete' => 'Trtnet::JegyCsatolsTrls',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => '',
        'History::ArchiveFlagUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'Vas',
        'Mon' => 'Ht',
        'Tue' => 'Ked',
        'Wed' => 'Sze',
        'Thu' => 'Cs',
        'Fri' => 'Pn',
        'Sat' => 'Szo',

        # Template: AdminAttachment
        'Attachment Management' => 'Levlmellkletek kezelse',
        'Actions' => '',
        'Go to overview' => '',
        'Add attachment' => '',
        'List' => 'Lista',
        'No data found.' => '',
        'Download file' => '',
        'Delete this attachment' => '',
        'Add Attachment' => '',
        'Edit Attachment' => '',
        'This field is required.' => '',
        'or' => 'vagy',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Automatikus vlasz kezelnek',
        'Add auto response' => '',
        'Add Auto Response' => '',
        'Edit Auto Response' => '',
        'Response' => 'Vlasz',
        'Auto response from' => '',
        'Reference' => 'Referencia',
        'You can use the following tags' => '',
        'To get the first 20 character of the subject.' => 'Az els 20 karakter hasznlata a trgybl',
        'To get the first 5 lines of the email.' => 'Az els 5 sor hasznlata az e-mailbl.',
        'To get the realname of the sender (if given).' => 'A kld valdi nevnek hasznlata (ha van ilyen)',
        'To get the article attribute' => '',
        ' e. g.' => '',
        'Options of the current customer user data' => '',
        'Ticket owner options' => '',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => '',
        'Options of the ticket data' => '',
        'Config options' => '',
        'Example response' => '',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'gyfl cgek kezelse',
        'Wildcards like \'*\' are allowed.' => '',
        'Add customer company' => '',
        'Please enter a search term to look for customer companies.' => '',
        'Add Customer Company' => 'gyfl cg hozzadsa',

        # Template: AdminCustomerUser
        'Customer Management' => '',
        'Add customer' => '',
        'Select' => 'Kivlaszts',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => '',
        'Please enter a search term to look for customers.' => '',
        'Last Login' => '',
        'Add Customer' => '',
        'Edit Customer' => '',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'DNS problem, please check your configuration and the error log.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => '',
        'Notice' => '',
        'This feature is disabled!' => 'Ez a kpessg inaktv!',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => 'Aktivlja itt!',
        'Search for customers.' => '',
        'Edit Customer Default Groups' => '',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => '',
        'Customers' => '',
        'Groups' => 'Csoportok',
        'No matches found.' => '',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => '',
        'No changes can be made to these groups.' => '',
        'ro' => 'Csak olvass',
        'Read only access to the ticket in this group/queue.' => 'Csak olvassi jogosultsg a jegyekhez ebben a csoportban/vrlistban.',
        'rw' => 'rs/Olvass',
        'Full read and write access to the tickets in this group/queue.' => 'Teljes rs s olvassi jog a jegyekhez ebben a csoportban/vrlistban.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '',
        'Edit default services' => '',
        'Filter for Services' => '',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => 'Aktv',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Adminsztrtori rtestsek',
        'With this module, administrators can send messages to agents, group or role members.' => '',
        'Create Administrative Message' => '',
        'Your message was sent to' => '',
        'Send message to users' => '',
        'Send message to group members' => '',
        'Group members need to have permission' => '',
        'Send message to role members' => '',
        'Also send to customers in groups' => '',
        'Body' => 'Trzs',
        'Send' => 'Klds',

        # Template: AdminGenericAgent
        'Generic Agent' => '',
        'Add job' => '',
        'Last run' => 'Utols vgrehajts',
        'Run Now!' => 'Vgrehajts most!',
        'Delete this task' => '',
        'Run this task' => '',
        'Job Settings' => '',
        'Job name' => '',
        'Currently this generic agent job will not run automatically.' => 'Jelenleg ez az ltalnos gyintz munka nem fut le automatikusan.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Az automata vgrehajts belltshoz vlasszon legalbb egy rtket a perc, ra s nap kzl!',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => 'pl. 10*5144 vagy 105658*',
        '(e. g. 234321)' => 'pl. 234321',
        'Customer login' => '',
        '(e. g. U5150)' => 'pl. U5150',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => 'gyintz',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Jegy szabad mezi',
        'Create times' => '',
        'No create time settings.' => 'Nincsenek ltrehozsi id belltsok.',
        'Ticket created' => 'Jegy ltrehozva',
        'Ticket created between' => 'Jegy ltrehozva idpontok kztt:',
        'Close times' => '',
        'No close time settings.' => 'Nincs lezrs ideje bellts.',
        'Ticket closed' => 'Jegy lezrva',
        'Ticket closed between' => 'Jegy lezrva kztt:',
        'Pending times' => '',
        'No pending time settings.' => 'Nincsenek vrakozsi id belltsok.',
        'Ticket pending time reached' => 'Vrakozsi id letelt',
        'Ticket pending time reached between' => 'Vrakozsi id letelt idpontok kztt:',
        'Escalation times' => '',
        'No escalation time settings.' => 'Nincs eszkalcis id belltva.',
        'Ticket escalation time reached' => 'Jegy eszkalcis ideje lejrt',
        'Ticket escalation time reached between' => 'Jegy eszkalcis ideje lejrt idpontok kztt:',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => 'Jegy els vlasz ideje lejrt',
        'Ticket first response time reached between' => 'Jegy els vlasz ideje lejrt idpontok kztt:',
        'Escalation - update time' => '',
        'Ticket update time reached' => 'Jegy frissts ideje lejrt',
        'Ticket update time reached between' => 'Jegy frissts ideje lejrt idpontok kztt:',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => 'Jegy megolds ideje lejrt',
        'Ticket solution time reached between' => 'Jegy megolds ideje lejrt idpontok kztt:',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 'j jegy szabad mezk',
        'Archive selected tickets' => '',
        'Add Note' => 'Megjegyzs hozzadsa',
        'Time units' => 'Id egysgek',
        ' (work units)' => ' (munkaegysg)',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'Kldjn vltozatsokrl rtestst az gyintznek/gyflnek',
        'CMD' => 'PARANCS',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Ez a parancs lesz vgrehajtva. Az ARG[0] lesz a jegy szma. Az ARG[1] lesz a jegy azonostja.',
        'Delete tickets' => 'Jegyek trlse',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Ments',
        'Results' => 'Eredmnyek',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => '',
        'Run job' => '',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'Figyelem: Ha az admin csoport nevt megvltoztatja a megfelel SysConfig belltsok eltt, gy ki lesz zrva az adminisztrcis felletrl. Ha ez megtrtnt, akkor nevezze vissza a csoportot admin nvre egy megfelel SQL parancs kiadsval.',
        'Group Management' => 'Csoportok kezelse',
        'Add group' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Az admin csoport megkapja az admin terletet s a sttusz csoport megkapja a sttusz terletet.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'Csoport hozzadsa',
        'Edit Group' => '',

        # Template: AdminLog
        'System Log' => 'Rendszernapl',
        'Here you will find log information about your system.' => '',
        'Hide this message' => '',
        'Recent Log Entries' => '',
        'Time' => 'Id',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Levelezs belltsai',
        'Add mail account' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Az sszes fikkal rendelkez bejv e-mail egy kivlasztott vrlisthoz lesz rendelve!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Ha az n fikja megbzhat, a mr ltez X-OTRS fejlcet hasznljuk berkezskor (prioritshoz, ...)! Egyb esetben a levelezsi szrk lesznek alkalmazva.',
        'Host' => 'Kiszolgl',
        'Delete account' => '',
        'Fetch mail' => '',
        'Add Mail Account' => '',
        'Example: mail.example.com' => '',
        'Trusted' => 'Megbzhat',
        'Dispatching' => 'Sztvlogats',
        'Edit Mail Account' => '',

        # Template: AdminNavigationBar
        'Admin' => 'Adminisztrci',
        'Agent Management' => '',
        'Queue Settings' => '',
        'Ticket Settings' => '',
        'System Administration' => '',

        # Template: AdminNotification
        'Notification Management' => 'rtestskezels',
        'Select a different language' => '',
        'Filter for Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'Az rtestsek gyintznek vagy gyflnek kerlnek elkldsre.',
        'Notification' => 'rtests',
        'Edit Notification' => '',
        'e. g.' => '',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => '',
        'Delete this notification' => '',
        'Add Notification' => 'rtests hozzadsa',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => 'Bejegyzs tpusa',
        'Only for ArticleCreate event' => '',
        'Subject match' => 'Trgy egyezs',
        'Body match' => 'Levltrzs egyezs',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => '(Legutols gyintz cikk) trgynak els 20 karaktere.',
        'To get the first 5 lines of the body (of the latest agent article).' => '(Legutols gyintz cikk) trzsnek els 5 sora.',
        'To get the first 20 character of the subject (of the latest customer article).' => '(Legutols gyfl cikk) trgynak els 20 karaktere.',
        'To get the first 5 lines of the body (of the latest customer article).' => '(Legutols gyfl cikk) trzsnek els 5 sora.',

        # Template: AdminPGP
        'PGP Management' => 'PGP kulcs kezelse',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'gy kzvetlenl szerkesztheti a kulcstartt amit a rendszer belltsainl belltott.',
        'Introduction to PGP' => '',
        'Result' => 'Eredmnyek',
        'Identifier' => 'Azonost',
        'Bit' => 'Bitek szma',
        'Key' => 'Kulcs',
        'Fingerprint' => 'Ujjlenyomat',
        'Expires' => 'Lejrati id',
        'Delete this key' => '',
        'Add PGP Key' => '',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => 'Csomagkezel',
        'Uninstall package' => '',
        'Version' => 'Verzi',
        'Do you really want to uninstall this package?' => 'Valban el akarja tvoltani ezt a csomagot?',
        'Reinstall package' => '',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => 'Folytats',
        'Install' => 'Telepts',
        'Install Package' => '',
        'Update repository information' => '',
        'Did not find a required feature? OTRS Group provides their subscription customers with exclusive Add-Ons:' => '',
        'Online Repository' => 'On-line csomagtrol',
        'Vendor' => 'Terjeszt',
        'Module documentation' => 'Modul dokumentci',
        'Upgrade' => 'Frissts',
        'Local Repository' => 'Helyi csomagtrol',
        'Uninstall' => 'Eltvolts',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'jratelepts',
        'Download package' => '',
        'Rebuild package' => '',
        'Metadata' => '',
        'Change Log' => '',
        'Date' => 'Dtum',
        'List of Files' => '',
        'Permission' => 'Jogosultsg',
        'Download' => 'Letlts',
        'Download file from package!' => 'Fjl letltse a csomagbl!',
        'Required' => 'Kvetlemnyek',
        'PrimaryKey' => 'ElsdelegesKulcs',
        'AutoIncrement' => 'AutoNvekv',
        'SQL' => 'SQL',
        'File differences for file %s' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Teljestmny napl',
        'This feature is enabled!' => 'Ez a kpessg aktv!',
        'Just use this feature if you want to log each request.' => 'Hasznlja ezt a kpessget amennyiben naplzni szeretne minden egyes krst.',
        'Activating this feature might affect your system performance!' => 'Ha bekapcsolja ezt a funkcit a rendszer teljestmnyt jelentsen befolysolhatja!',
        'Disable it here!' => 'Inaktivlja itt!',
        'Logfile too large!' => 'A naplfjl tl nagy!',
        'The logfile is too large, you need to reset it' => '',
        'Overview' => 'ttekints',
        'Range' => 'Tartomny',
        'Interface' => 'Fellet',
        'Requests' => 'Krsek',
        'Min Response' => 'Min. Vlasz',
        'Max Response' => 'Max. Vlasz',
        'Average Response' => 'tlagos Vlasz',
        'Period' => 'Idszak',
        'Min' => 'Min.',
        'Max' => 'Max.',
        'Average' => 'tlag',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Levelezsi szrk kezelse',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Amennyiben n csak az e-mail cm egyezst kvnja vizsglni, akkor hasznlja a EMAILADDRESS:info@example.com formult a Felad (From), Cmzett (To) vagy Msolat (Cc) mezkben.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'The name is required.' => '',
        'Stop after match' => 'Megll egyezs utn',
        'Filter Condition' => '',
        'Value' => 'rtk',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => '',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Priorits kezels',
        'Add priority' => '',
        'Add Priority' => 'Priorits hozzadsa',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'Feloldsi idtllps',
        '0 = no unlock' => '0 = nincs felolds',
        'Only business hours are counted.' => 'Csak a munkark kerlek szmtsba.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'rtests',
        '0 = no escalation' => '0 = nincs kiemels',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'Vlasz kezelse',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'Jegy zrolsa vlasz rkezse utn.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => 'Ennl a vrlistnl ez lesz a felad e-mail vlaszokhoz.',
        'Default sign key' => '',
        'The salutation for email answers.' => 'A megszlts az e-mail vlaszokhoz.',
        'The signature for email answers.' => 'Az alrs a vlasz e-mailekhez.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => '',
        'Filter for Auto Responses' => '',
        'Auto Responses' => 'Automatikus vlaszok',
        'Change Auto Response Relations for Queue' => '',
        'settings' => 'belltsok',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Szr',
        'Filter for Responses' => '',
        'Responses' => 'Vlaszok',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => '',
        'Add response' => '',
        'A response is default text to write faster answer (with default text) to customers.' => 'Egy reakci az alaprtelmezett szveg gyors vlaszokhoz (az alaprtelmezett szveggel) az gyfeleknek.',
        'Don\'t forget to add a new response a queue!' => 'Ne felejtsen el j reakcit hozzadni a vrlisthoz!',
        'Delete this entry' => '',
        'Add Response' => '',
        'Edit Response' => '',
        'The current ticket state is' => 'A jegy aktulis llapota',
        'Your email address is' => '',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'Szerepek kezelse',
        'Add role' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'Hozzon ltre egy szerepet s tegyen bele csoportokat. Azutn adja a szerepet a felhasznlkhoz.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'Szerep hozzadsa',
        'Edit Role' => '',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => 'Szerepek',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'mozgat',
        'Permissions to move tickets into this group/queue.' => 'Jogosultsgok jegyek thelyezshez ebbe a csoportba/vrlistba.',
        'create' => 'kszt',
        'Permissions to create tickets in this group/queue.' => 'Jogosultsgok j jegyek ltrehozshoz ebben a csoportban/vrlistban.',
        'priority' => 'priorits',
        'Permissions to change the ticket priority in this group/queue.' => 'Jogosultgok a jegy prioritsnak megvltoztatshoz ebben a csoportban/vrlistban.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => '',
        'Agents' => '',
        'Manage Role-Agent Relations' => '',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'SLA kezelse',
        'Add SLA' => 'SLA hozzadsa',
        'Edit SLA' => '',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'S/MIME kezels',
        'Add certificate' => '',
        'Add private key' => '',
        'Filter for certificates' => '',
        'Filter for SMIME certs' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'ly mdon kzvetlenl szerkesztheti a fjlrendszeren trolt tanustvnyokat s titkos kulcsokat.',
        'See also' => 'Lsd mg',
        'Hash' => 'Kivonat',
        'Create' => 'Ltrehozs',
        'Delete this certificate' => '',
        'Add Certificate' => 'Tanustvny Hozzadsa',
        'Add Private Key' => 'Titkos Kulcs Hozadsa',
        'Secret' => 'Titok',

        # Template: AdminSalutation
        'Salutation Management' => 'Megszltsok kezelse',
        'Add salutation' => '',
        'Add Salutation' => 'Megszlts hozzadsa',
        'Edit Salutation' => '',
        'Example salutation' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Biztonsgos zemmd a teleptst kveten fog teljesen mkdni.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Biztonsgos zemmdot le kell tltani ahhoz, hogy a webes teleptvel jra lehessen dolgozni.',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => 'SQL parancsok',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => '',
        'Run Query' => '',

        # Template: AdminService
        'Service Management' => 'Szolgltatsok kezelse',
        'Add service' => '',
        'Add Service' => 'Szolgltats hozzadsa',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => 'Folyamatkezels',
        'All sessions' => '',
        'Agent sessions' => '',
        'Customer sessions' => '',
        'Unique agents' => '',
        'Unique customers' => '',
        'Kill all sessions' => 'sszes folyamat trlse',
        'Kill this session' => '',
        'Session' => 'Folyamat',
        'Kill' => '',
        'Detail View for SessionID' => '',

        # Template: AdminSignature
        'Signature Management' => 'Alrsok kezelse',
        'Add signature' => '',
        'Add Signature' => 'Alrs hozzadsa',
        'Edit Signature' => '',
        'Example signature' => '',

        # Template: AdminState
        'State Management' => 'llapotok kezelse',
        'Add state' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Figyeljen oda, hogy az Kernel/Config.pm fjlban is frisstse az alaprtelmezett llapotokat!',
        'Add State' => 'llapot hozzadsa',
        'Edit State' => '',
        'State type' => '',

        # Template: AdminSysConfig
        'SysConfig' => 'Rendszerbelltsok',
        'Navigate by searching in %s settings' => '',
        'Navigate by selecting config groups' => '',
        'Download all system config changes' => '',
        'Export settings' => '',
        'Load SysConfig settings from file' => '',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => 'Importls',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'Alcsoport',
        'Elements' => 'Elemek szma',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => '',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'Tartalom',
        'Remove this entry' => '',
        'Add entry' => '',
        'Remove entry' => '',
        'Add new entry' => '',
        'Create new entry' => '',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => 'NavMenNv',
        'NavBar' => 'NavMen',
        'LinkOption' => '',
        'Block' => 'Blokk',
        'AccessKey' => 'HozzfrsiKulcs',
        'Add NavBar entry' => '',
        'Year' => 'v',
        'Month' => 'Hnap',
        'Day' => 'Nap',
        'Invalid year' => '',
        'Invalid month' => '',
        'Invalid day' => '',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Rendszer e-mail cmek kezelse',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => 'Tpusok kezelse',
        'Add ticket type' => '',
        'Add Type' => 'Tpus hozzadsa',
        'Edit Type' => '',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'Belp mint',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'Keresztnv',
        'Lastname' => 'Vezetknv',
        'Password is required.' => '',
        'Start' => 'Eleje',
        'End' => 'Vge',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'tulajdonos',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'Cmjegyzk',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'gyfl keresse',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Vezrlpult',
        'Show or hide the content' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => 'ebben',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s elrhet!',
        'Please update now.' => 'Krem most frisstsen.',
        'Release Note' => 'Kiadsi megjegyzs',
        'Level' => 'Szint',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Bekldve %s ezeltt.',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => 'Info',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Kapcsold Objektum: %s',
        'Close window' => '',
        'go to link delete screen' => '',
        'Select Target Object' => '',
        'Link Object' => 'Objektumok sszekapcsolsa',
        'with' => 'Ezzel',
        'Unlink Object: %s' => 'Levlaszott Objektum: %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '',

        # Template: AgentSpelling
        'Spell Checker' => 'Helyesrsellenrz',
        'spelling error(s)' => 'helyesrsi hiba(k)',
        'Apply these changes' => 'Mdostsok rvnyestse',

        # Template: AgentStatsDelete
        'Delete stat' => '',
        'Stat#' => 'Stat#',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'Vlassza ki a tulajdonsgokat a grafikonon megjelen rtkekhez',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'Itt megktseket adhat a statsztikhoz.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Ha eltvoltja a "Rgztett" jellngyzetet, akkor a statisztikt elllt gyintz megvltoztathatja az rtkeit a megfelel tulajdonsgnak.',
        'Fixed' => 'Rgztett',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Krem vlasszon egy rtket vagy kapcsolja ki a \'Rgztett\' kapcsolt.',
        'Absolute Period' => '',
        'Between' => 'Idszak:',
        'Relative Period' => 'Relatv idszak',
        'The last' => 'A legutbbi',
        'Finish' => 'Befejezs',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Jogosultsgok',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'If you use a graph as output format you have to select at least one graph size.' => 'Amennyiben grafikont is kivlasztott, mint kimeneti formtum, gy ki kell vlasztania legalbb egy grafikon mretet.',
        'Sum rows' => 'Sorok sszegzse',
        'Sum columns' => 'Oszlopok sszegzse',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'A statisztikk tbbsge hasznlhat gyorsttrat. Ez gyorstja az elksztst a statisztiknak.',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Skla',
        'minimal' => 'minimlis',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Krem ne felejtse, hogy adatsorok sklzsnak nagyobbnak kell lennie az X tengely sklzsnl (pl. X-Tengely => Hnap, rtkSorozat => v )',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'maximum peridus',
        'minimal scale' => 'minimlis skla',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => 'A fjl nem egy statisztika bellts fjl',
        'No File selected' => 'Nincsen fjl kivlasztva',

        # Template: AgentStatsOverview
        'Stats' => 'Statisztika',
        'Object' => 'Objektum',

        # Template: AgentStatsPrint
        'Print' => 'Nyomtats',
        'No Element selected.' => 'Nincsen rtk kivlasztva.',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => 'Formtum',
        'Graphsize' => 'Grafikon mrete',
        'Cache' => 'Gyorsttr',
        'Exchange Axis' => 'Tengelyek flcserlse',
        'Configurable params of static stat' => 'lland statisztika konfigurlhat paramterei',
        'No element selected.' => 'Nincsenek ertkek kivlasztva.',
        'maximal period from' => 'maximlis peridus ezta',
        'to' => 'eddig',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => 'Vrakozs bellts',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => '',
        'Service invalid.' => '',
        'New Owner' => 'j tulajdonos',
        'Please set a new owner!' => '',
        'Previous Owner' => 'Korbbi tulajdonos',
        'Inform Agent' => 'gyintz rtstse',
        'Optional' => 'Nem ktelez',
        'Inform involved Agents' => 'rintett gyintzk rtestse',
        'Spell check' => '',
        'Note type' => 'Jegyzet tpusa',
        'Next state' => 'Kvetkez llapot',
        'Pending date' => 'Vrakozsi dtum',
        'Date invalid!' => '',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => 'Visszaklds ide:',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'A jegy kvetkez llapota',
        'Inform sender' => 'Kld tjkoztatsa',
        'Send mail!' => 'E-mail kldse!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Csoportos jegy-mvelet',
        'Merge to' => 'Egyesti',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'Legrgebbihez egyesti',
        'Link together' => 'sszekapcsol',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Vlaszads a jegyre',
        'Need a valid email address.' => '',
        'Address book' => '',
        'Pending Date' => 'Vrakozs dtuma',
        'for pending* states' => 'vrakoz* sttuszhoz',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'A jegyhez tartoz gyfl megvltoztatsa',
        'Customer Data' => 'gyfl adatok',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '',
        'From queue' => '',
        'Get all' => '',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Elzmnyek:',
        'History Content' => '',
        'Zoom view' => '',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Jegy egyestse',
        'You need to use a ticket number!' => 'Adja meg egy jegy szmt!',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Jegy thelyezse',
        'New Queue' => 'j vrlista',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '',
        'No ticket data found.' => '',
        'First Response Time' => 'Els vlaszid',
        'Service Time' => 'Szolgltats ideje',
        'Update Time' => 'Frissts ideje',
        'Solution Time' => 'Megolds ideje',
        'Move ticket to a different queue' => '',
        'Change queue' => 'Vrlista megvltoztatsa',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Keressi belltsok mdostsa',
        'Tickets per page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Eszkalci ebben',
        'Locked' => 'Zrols',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => '',
        'From customer' => '',
        'To queue' => '',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Telefonhvs',

        # Template: AgentTicketPlain
        'Email Text Plain View' => '',
        'Plain' => 'Egyszer',
        'Download this email' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Jegy informci',
        'Accounted time' => 'Elszmolt id',
        'Linked-Object' => 'Kapcsold objektum',
        'by' => 'ltala:',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Keres sablon',
        'Create Template' => '',
        'Create New' => '',
        'Profile link' => '',
        'Save changes in template' => '',
        'Add another attribute' => '',
        'Output' => 'Eredmny rlap',
        'Fulltext' => 'Teljes szveg',
        'Remove' => '',
        'Customer User Login' => 'gyfl felhasznl belps',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'Ltrehozskori vrlista',
        'Lock state' => '',
        'Watcher' => 'Figyel',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '',
        'Article Type' => 'Cikk tipusa',
        'Sender Type' => '',
        'Save filter settings as default' => 'Szr belltsok alaprtelmezettknti mentse',
        'Ticket Information' => '',
        'Linked Objects' => '',
        'Article(s)' => '',
        'Change Queue' => '',
        'Article Filter' => '',
        'Add Filter' => '',
        'Set' => 'Bellts',
        'Reset Filter' => '',
        'Show one article' => '',
        'Show all articles' => '',
        'Unread articles' => '',
        'No.' => '',
        'Unread Article!' => '',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'Visszakvets',

        # Template: CustomerFooter
        'Powered by' => 'Ksztette',
        'One or more errors occurred!' => '',
        'Close this dialog' => '',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'Belps',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => '',
        'Log In' => '',
        'Not yet registered?' => '',
        'Sign up now' => '',
        'Request new password' => 'j jelsz krse',
        'Your User Name' => '',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Azonost ltrehozsa',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'Welcome!' => '',
        'Please click the button below to create your first ticket.' => '',
        'Create your first ticket' => '',

        # Template: CustomerTicketPrint
        'Ticket Print' => '',

        # Template: CustomerTicketSearch
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => '',
        'Customer ID' => '',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => '',
        'Recipient' => 'Cmzett',
        'Carbon Copy' => '',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => '',
        'Save as Template' => '',
        'Template Name' => '',
        'Pick a profile name' => '',
        'Output to' => '',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'kitl',
        'Page' => 'Oldal',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Expand article' => '',
        'Reply' => '',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => '',
        'Sunday' => '',
        'Monday' => '',
        'Tuesday' => '',
        'Wednesday' => '',
        'Thursday' => '',
        'Friday' => '',
        'Saturday' => '',
        'Su' => '',
        'Mo' => '',
        'Tu' => '',
        'We' => '',
        'Th' => '',
        'Fr' => '',
        'Sa' => '',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => '',
        'Error Message' => '',
        'You can' => '',
        'Send a bugreport' => '',
        'go back to the previous page' => '',
        'Error Details' => '',

        # Template: Footer
        'Top of page' => '',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => '',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => '',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => '',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'dvzli az %s',
        'Web site' => '',
        'Database check successful.' => '',
        'Mail check successful.' => '',
        'Error in the mail settings. Please correct and try again.' => '',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => '',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => '',
        'Check mail configuration' => '',
        'Skip this step' => '',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Ha be van lltva adatbzis root jelsz, akkor azt itt kell megadni. Ha nem hagyja resen a mezt. Biztonsgi megfontolsokbl javasoljuk hogy hasznljon root jelszt. Tovbbi informcit tall az adatbzis dokumentciban.',
        'Currently only MySQL is supported in the web installer.' => '',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Adatbzis felhasznl',
        'New' => 'j',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'alaprtelmezett',
        'DB--- host' => '',
        'Database' => 'Adatbzis',
        'Check database settings' => '',
        'Result of database check' => '',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Ahhoz, hogy az OTRS-t hasznlni tudja, a kvetkez parancsot kell begpelnie parancssorban (terminlban/hjjban) root-knt.',
        'Restart your webserver' => 'Indtsa jra a web-kiszolglt',
        'After doing so your OTRS is up and running.' => 'Ha ez ksz, az OTRS ksz s fut.',
        'Start page' => 'Start oldal',
        'Your OTRS Team' => 'Az n OTRS csapata',

        # Template: InstallerLicense
        'Accept license' => 'Lincensz elfogadsa',
        'Don\'t accept license' => 'Licensz elutastsa',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'Rendszer azonost',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'Rendszer FQDN',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'AdminEmail',
        'Email address of the system administrator.' => '',
        'Organization' => 'Szervezet',
        'Log' => 'Napl',
        'LogModule' => 'Log modul',
        'Log backend to use.' => '',
        'LogFile' => '',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Webes felhasznli fellet',
        'Default language' => '',
        'Default language.' => '',
        'CheckMXRecord' => 'MX Rekord ellenrzs',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => '',

        # Template: Login
        'JavaScript Not Available' => '',
        'Browser Warning' => '',
        'The browser you are using is too old.' => '',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '',
        'Please see the documentation or ask your admin for further information.' => '',
        'Lost your password?' => 'Elfelejtette a jelszavt?',
        'Request New Password' => '',
        'Back to login' => '',

        # Template: Motd
        'Message of the Day' => '',

        # Template: NoPermission
        'Insufficient Rights' => '',
        'Back to the previous page' => '',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'Nyomtatta',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS tesztoldal',
        'Welcome %s' => 'dvzljk %s',
        'Counter' => 'Szmll',

        # Template: Warning
        'Go back to the previous page' => '',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Levlmellkletek <-> Vlaszok',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Christmas Eve' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => '',
        'Create and manage agents.' => '',
        'Create and manage attachments.' => '',
        'Create and manage companies.' => '',
        'Create and manage customers.' => '',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => '',
        'Create and manage notifications that are sent to agents.' => '',
        'Create and manage queues.' => '',
        'Create and manage response templates.' => '',
        'Create and manage responses that are automatically sent.' => '',
        'Create and manage roles.' => '',
        'Create and manage salutations.' => '',
        'Create and manage services.' => '',
        'Create and manage signatures.' => '',
        'Create and manage ticket priorities.' => '',
        'Create and manage ticket states.' => '',
        'Create and manage ticket types.' => '',
        'Create new email ticket and send this out (outbound)' => '',
        'Create new phone ticket (inbound)' => '',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '',
        'Customers <-> Services' => '',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the sender for rejected emails.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries in milliseconds.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'E-mail cmek',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'First Christmas Day' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'Automata gyintz',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'International Workers\' Day' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New Year\'s Day' => '',
        'New Year\'s Eve' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => 'rtests (Event)',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => 'Vlaszok <-> Vrlista',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Szerepek <-> Csoportok',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Second Christmas Day' => '',
        'Select your frontend Theme.' => 'Vlassza ki a felhasznli fellet stlust.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '',
        'Status view' => '',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => '',
        'Tickets' => 'Jegyek',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '',
        'View system log messages.' => '',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '"}' => '"}',
        '%s Tickets affected! Do you really want to use this job?' => '%s jegy rintett! Valban el akarja vgezni ezt a teendt a jegyeken?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Ellenrizd le az MX rekordot a hasznlt email cmben a vlasz rsakor!)',
        '(Email of the system admin)' => '(A rendszergazda e-mailje)',
        '(Full qualified domain name of your system)' => '(Teljes ellenrztt domain nv a rendszerben)',
        '(Logfile just needed for File-LogModule!)' => '(Logfile szksges a File-LogModul szmra!)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Megjegyzs: A teleptstl fgg mennyi dinamikus objektumot hasznlhat.)',
        '(Note: Useful for big databases and low performance server)' => '(Megyjegyzs: Ez hasznos nagy mret adatbzisoknl s ki teljestmny kiszolgl hasznlata esetn.)',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Azonosts a rendszerben. Minden jegyhez s minden http eljrs ezzel a sorszmmal indul)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Jegy azonosts. pl. \'Jegy#\', \'Hv#\' vagy \'Jegyem#\')',
        '(Used default language)' => '(A felhasznl alaprtelmezett nyelve)',
        '(Used log backend)' => '(Hasznlt httr log)',
        '(Used ticket number format)' => '(Nyitott jegyek sorszmnak formtuma)',
        'A article should have a title!' => 'Egy bejegyzsnek kell legyen cme!',
        'A message must be spell checked!' => 'Az zenetnek helyesrsellenrzsen kell tmennie!',
        'A message should have a To: recipient!' => 'Egy zenethez kellene legyen cmzett!',
        'A message should have a body!' => 'Egy zenetnek kell legyen trzse!',
        'A message should have a subject!' => 'Egy zenetnek kell legyen trgya!',
        'A required field is:' => 'Szksges mez:',
        'Absolut Period' => 'Abszolt idszak',
        'Add Customer User' => 'gyfl felhasznl hozzadsa',
        'Add System Address' => 'Rendszer cm hozzadsa',
        'Add User' => 'Felhasznl hozzadsa',
        'Add a new Agent.' => 'j felhasznl hozzadsa',
        'Add a new Customer Company.' => 'j gyfl cg hozzadsa',
        'Add a new Group.' => 'j csoport hozzadsa',
        'Add a new Notification.' => 'j rtests hozzadsa.',
        'Add a new Priority.' => 'j priorits hozzadsa',
        'Add a new Role.' => 'j szerep hozzadsa',
        'Add a new SLA.' => 'j SLA hozzadsa',
        'Add a new Salutation.' => 'j megszlts hozzadsa',
        'Add a new Service.' => 'j szolgltats hozzadsa',
        'Add a new Signature.' => 'j alrs hozzadsa',
        'Add a new State.' => 'j llapot hozzadsa',
        'Add a new System Address.' => 'j rendszer cm hozzadsa',
        'Add a new Type.' => 'j tpus hozzadsa',
        'Add note to ticket' => 'Megjegyzs hozzadsa a jegyhez',
        'Added User "%s"' => 'A "%s" felhasznl hozzadva',
        'Admin-Area' => 'Adminisztrcis-terlet',
        'Admin-Password' => 'Adminisztrtor jelsz',
        'Admin-User' => 'Adminisztrtor felhasznl',
        'Agent Mailbox' => 'gyintz postafikja',
        'Agent Preferences' => 'gyintz belltsai',
        'Agent based' => 'gyk alap',
        'Agent-Area' => 'gyintz-terlet',
        'All Agent variables.' => 'gyintz sszes vltozja',
        'All Agents' => 'Minden gyintz',
        'All Customer variables like defined in config option CustomerUser.' => 'Az sszes gyfl vltoz ahogyan az gyfl felhasznl opciknl lett belltva.',
        'All customer tickets.' => 'sszes gyfl jegy.',
        'All email addresses get excluded on replaying on composing an email.' => 'sszes E-mail cm ki lesz hagyva ismtelt levlrs esetn.',
        'All email addresses get excluded on replaying on composing and email.' => 'sszes E-mail cm ki lesz hagyva ismtelt levlrs esetn.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Az sszes bejv e-mail ezzel az cmzettel a kivlasztott vrlisthoz lesz rendelve!',
        'All messages' => 'Minden zenet',
        'All new tickets!' => 'sszes j jegy!',
        'All tickets where the reminder date has reached!' => 'sszes jegy ahol az emlkeztet ideje lejrt!',
        'All tickets which are escalated!' => 'sszes eszkallt jegy!',
        'Allocate CustomerUser to service' => 'gyflFelhasznlk hozzrendelse szolgltatsokhoz',
        'Allocate services to CustomerUser' => 'Szolgltatsok hozzrendelse gyflFelhasznlhoz!',
        'Answer' => 'Vlasz',
        'Article Create Times' => 'Cikk ltrehozsnak ideje',
        'Article created' => 'Cikk ltrehozva',
        'Article created between' => 'Cikk ltrehozva ekztt',
        'Article filter settings' => 'Cikk szr belltsai',
        'Attach' => 'Csatols',
        'Attribute' => 'Tulajdonsg',
        'Auto Response From' => 'Automatikus vlasz feladnak',
        'Bounce ticket' => 'Jegy visszakldse',
        'Can not create link with %s!' => 'Nem tudom a %s kapcsolatt ltrehozni!',
        'Can not delete link with %s!' => 'Nem tudom trlni %s kapcsoldst!',
        'Can\'t update password, invalid characters!' => 'Nem sikerlt modostani a jelszt, rvnytelen karakterek!',
        'Can\'t update password, must be at least %s characters!' => 'Nem sikerlt modostani a jelszt, legalbb %s karakter megadsa szksges!',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Nem sikerlt modostani a jelszt, legalbb 2 kisbetnek s 2 nagybetnek kell benne szerepelnie!',
        'Can\'t update password, needs at least 1 digit!' => 'Nem sikerlt modostani a jelszt, legalbb egy szmjegynek kell benne szerepelnie!',
        'Can\'t update password, needs at least 2 characters!' => 'Nem sikerlt modostani a jelszt, legalbb 2 karakter megadsa szksges!',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Nem sikerlt modostani a jelszt, a jelszavak nem egyeznek! Krem prblja jra!',
        'Category Tree' => 'Kategria Fa',
        'Change %s settings' => '%s belltsainak mdostsa',
        'Change Time' => 'Id megvltoztatsa',
        'Change Times' => 'Vltozs ideje',
        'Change free text of ticket' => 'Szabad szveg vltoztatsa a jegyben',
        'Change owner of ticket' => 'Jegy tulajdonosnak mdostsa',
        'Change priority of ticket' => 'Jegy prioritsnak mdostsa',
        'Change responsible of ticket' => 'Jegy felelsnek megvltoztatsa',
        'Change user <-> group settings' => 'A felhasznl <-> csoport belltsok megvltoztatsa',
        'ChangeLog' => 'Vltoztatsok',
        'Child-Object' => 'Gyerek objektum',
        'Classification' => 'Besorols',
        'Clear From' => 'Mez trlse',
        'Clear To' => 'Mez trlse',
        'Click here to report a bug!' => 'Kattintson ide j hiba bejelentshez!',
        'Close Times' => 'Lezrs ideje',
        'Close ticket' => 'Jegy lezrsa',
        'Close type' => 'Tpus lezrsa',
        'Close!' => 'Lezr!',
        'Collapse View' => 'Szktett Nzet',
        'Comment (internal)' => 'Megjegyzs (bels)',
        'CompanyTickets' => 'Cg jegyek',
        'Compose Answer' => 'Vlasz rsa',
        'Compose Email' => 'j e-mail rsa',
        'Compose Follow up' => 'Vlasz rsa',
        'Config Options' => 'Belltsi lehetsgek',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Konfigurcis rtkek (pl. &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Bellts opcik (pl. <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Konfigurcis rtkek (pl.  <OTRS_CONFIG_HttpType>).',
        'Contact customer' => 'Kapcsolatbalps az gyfllel',
        'Create Times' => 'Ltrehozsi idk',
        'Create new Phone Ticket' => 'j telefon jegy ltrehozsa',
        'Create new database' => 'j adatbzis ltrehozsa',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Hozzon ltre j csoportot a klnbz gyintz csoportok (pl. beszerz osztly, tmogat osztly, elad osztly, ...) hozzfrsi jogainak kezelshez.',
        'CreateTicket' => 'JegyLtrehozs',
        'Current Impact Rating' => 'Jelenlegi befolys besorolsa',
        'Customer Move Notify' => 'gyfl rtestse mozgatskor',
        'Customer Owner Notify' => 'gyfl rtestse tulajdonosvltskor',
        'Customer State Notify' => 'gyfl rtestse llapotvltozskor',
        'Customer User' => 'gyfl felhasznl',
        'Customer User Management' => 'gyfl felhasznlk kezelse',
        'Customer Users' => 'gyfl felhasznlk',
        'Customer Users <-> Groups' => 'gyfl felhasznlk <-> Csoportok',
        'Customer Users <-> Groups Management' => 'gyfl felhasznlk <-> Csoportok kezelse',
        'Customer Users <-> Services' => 'gyfl felhasznlk <-> Szolgltatsok',
        'Customer Users <-> Services Management' => 'gyfl felhasznlk <-> Szolgltatsok kezelse',
        'Customer history' => 'gyfl trtnet',
        'Customer history search' => 'Keress az gyfl trtnetben',
        'Customer history search (e. g. "ID342425").' => 'Keress az gyfl trtnetben (pl. "ID342425").',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'gyfl felhasznl ltrehozsa szksges, hogy legyenek gyflhez tartoz elzmnyek s be lehessen lpni az gyfl oldalon.',
        'CustomerUser' => 'gyfl felhasznl',
        'D' => 'Z',
        'DB Admin Password' => 'DB Admin jelsz',
        'DB Admin User' => 'DB Admin felhasznl',
        'DB connect host' => 'Adatbzis kiszolgl',
        'Default' => 'Alaprtelmezett',
        'Default Charset' => 'Alaprtelmezett karakterkszlet',
        'Default Language' => 'Alaprtelmezett nyelv',
        'Default Sign Key' => 'Alaprtelmezett alr kulcs',
        'Delete old database' => 'Rgi adatbzis trlse',
        'Detail' => 'Rszletek',
        'Diff' => 'Klnbsg',
        'Discard all changes and return to the compose screen' => 'Minden vltoztats megsemmistse s visszatrs a szerkesztkpernyre',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'A berkez e-mailek az X-Fejlcek alapjn legyen hozzrendelve! Szablyos kifejezsek alkalmazhatk.',
        'Do you really want to delete this Object?' => 'Valban trlni szertn ezt az objektumot?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Valban jra kvnja telepteni ezt a csomagot (minden megvltoztatott bellts elvsz)?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Ne felejtse el az j felhasznlt hozzadni csoportokhoz s/vagy szerepekhez!',
        'Don\'t forget to add a new user to groups!' => 'Ne felejtsen el j felhasznlt hozzadni a csoportokhoz!',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Ne dolgozzon az 1-es felhasznlval (Rendszer jogosultsg)! Hozzon ltre j felhasznlt!',
        'Download Settings' => 'Belltsok letltse',
        'Download all system config changes.' => 'Minden rendszerbellts modosts letltse.',
        'Drop Database' => 'Adatbzis trlse',
        'Dynamic-Object' => 'Dinamikus objektum',
        'Edit default services.' => 'Alap szolgltatsok szerkesztse.',
        'Email based' => 'E-mail alap',
        'Escaladed Tickets' => 'Eszkallt Jegyek',
        'Escalation - First Response Time' => 'Eszkalci - Els vlasz ideje',
        'Escalation - Solution Time' => 'Eszkalci - Megolds ideje',
        'Escalation - Update Time' => 'Eszkalci - Frissts ideje',
        'Escalation Times' => 'Eszkalcis id',
        'Escalation time' => 'Eszkalci ideje',
        'Event is required!' => 'Esemny megadsa szksges!',
        'Expand View' => 'Kibvtett Nzet',
        'Explanation' => 'Magyarzat',
        'Export Config' => 'Belltsok exportlsa',
        'FAQ Search Result' => 'GYIK tallati eredmnyek',
        'FAQ System History' => 'GYIK rendszer trtnet',
        'File-Name' => 'File-nv',
        'File-Path' => 'File-tvonal',
        'Filelist' => 'Fjl lista',
        'Filtername' => 'Szr neve',
        'Follow up' => 'Vlasz',
        'Follow up notification' => 'Vlaszlevl rtests',
        'For very complex stats it is possible to include a hardcoded file.' => 'Nagyon sszetett statisztikknl lehetsg elre elksztett fjlok hasznlata.',
        'Frontend' => 'Felhasznli fellet',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Szveg keresse a bejegyzsekben (pl. "Mar*in" or "Baue*")',
        'Go' => 'Indts',
        'Group Ro' => 'Csoport Ro',
        'Group based' => 'Csoport alap',
        'Group selection' => 'Csoport kivlasztsa',
        'Have a lot of fun!' => 'Sok sikert!',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Itt kivlaszthatja a grafikonon megjelen rtkeket. Egy vagy kt tulajdonsgot jellhet ki. Utn kivlaszthatja a tulajdonsg rtkeit. Minden rtk kln kerl brzolsra a grafikonon. Ha nem vlaszt ki egyetlen rtket sem a tulajdonsghoz, akkor az sszes rtk hasznlva lesz a statisztika ltrehozsakor. Szintn hozzadsra kerlnek a legutbbi bellts ta ltrejtt j rtkek is.',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Itt definilhatja az x-tengelyt. A vlasztgomb segtsgvel tud vlasztani. Ha nem vlaszt semmit, akkor minden jellemz felhaszhlsra kerl a statisztika elksztsnl. Ugyangy, ahogy egy j jellemz mr hozzadsra kerlt a legutols konfigurci ta.',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Itt llthatja be az X tengelyt. Vlasszon egyet a rdi gombok kzl. Utna vlassza ki kt vagy tbb rtkt a tulajdonsgnak. Ha nem vlaszt ki egyetlen rtket sem a tulajdonsghoz, akkor az sszes rtk hasznlva lesz a statisztika ltrehozsakor. Szintn hozzadsra kerlnek a legutbbi bellts ta ltrejtt j rtkek is.',
        'Here you can insert a description of the stat.' => 'Itt tudja megadni a statisztika lerst.',
        'Here you can select the dynamic object you want to use.' => 'Itt tudja kivlasztani azt a dinamikus objektumot, amelyet hasznni kvn.',
        'Home' => 'Otthon',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Ha a biztonsgos zemmd nincs aktivlva, akkor a SysConfig-ben aktivlja, mivel az alkalmazs mr fut.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Ha rendelkezsre ll egy jabb elre elksztett fjl akkor az itt megjelenik s vlaszthat kzlk egyet.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ha a jegy le van zrva s az gyfl vlaszol a jegyre, akkor az zrolsra kerl a rgi tulajdonos rszre.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Ha a jegy nem kerl megvlaszolsra a megadott idn bell, csak ez a jegy lesz megjelentve.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ha az gyintz zrolja a jegyet s nem kld vlaszt ezen idn bell, a jegy zrolsa megsznik. gy a jegy lthat lesz minden gyintznek.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Ha nincs semmi kivlasztva, akkor nincsenek jogosultsgok ebben a csoportban (a jegyek nem lesznek elrhetk a felhasznlnak).',
        'If you need the sum of every column select yes.' => 'Amennyiben az oszlopok sszegzsre van szksge, akkor vlassza az igent.',
        'If you need the sum of every row select yes' => 'Amennyiben a sorok sszegzsre van szksge, akkor vlassza az igent.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Ha szablyos kifejzseket hasznl, hasznlhatja a ()-ben lev egyez rtket mint [***] a \'Bellts\'-nl.',
        'Image' => 'Kp',
        'Important' => 'Fontos',
        'Imported' => 'Importlva',
        'Imported by' => 'Importlta',
        'In this form you can select the basic specifications.' => 'Ezen a felleten elvgezheti az alapvet belltsokat.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'ly mdon kzvetlenl szerkesztheti a Kernel/Config.pm-ben belltott kulcskarikt.',
        'Information about the Stat' => 'Informci a statisztikrl',
        'Insert of the common specifications' => 'Az ltalnos belltsok megadsa',
        'Instance' => 'Instancia',
        'Is Job Valid' => 'Teend rvnyes',
        'Is Job Valid?' => 'Teend rvnyes?',
        'It\'s useful for ASP solutions.' => 'Ez hasznos ASP megoldsokhoz.',
        'It\'s useful for a lot of users and groups.' => 'Ez hasznos egy csom felhasznlnak s csoportnak',
        'Job-List' => 'Teendk listja',
        'Keyword' => 'Kulcssz',
        'Keywords' => 'Kulcssz',
        'Last update' => 'Utols frissts',
        'Link to Parent' => 'Szlhz kapcsol',
        'Linked as' => 'Kapcsolva mint',
        'Load' => 'Betlts',
        'Load Settings' => 'Belltsok betltse',
        'Logfile' => 'Log file',
        'Logfile too large, you need to reset it!' => 'A naplfjl tl nagy, kitrlse szksges!',
        'Login failed! Your username or password was entered incorrectly.' => 'Belps sikertelen! Hibsan adta meg a felhasznli nevt vagy jelszavt.',
        'Lookup' => 'Keres',
        'Mail Management' => 'E-mail kezels',
        'Mailbox' => 'Postafik',
        'Match' => 'Egyezs',
        'Message for new Owner' => 'zenet az j tulajdonosnak',
        'Message sent to' => 'zenet elkldve',
        'Misc' => 'Egyb',
        'Modified' => 'Mdostva',
        'Modules' => 'Modul',
        'Move notification' => 'thelyezs rtests',
        'Multiple selection of the output format.' => 'Tbb kimeneti formtum kivlasztsa.',
        'My Queue' => 'Sajt vrlistm',
        'MyTickets' => 'Sajt jegyek',
        'Name is required!' => 'A nevet meg kell adni!',
        'New Agent' => 'j gyintz',
        'New Customer' => 'j gyfl',
        'New Group' => 'j csoport',
        'New Group Ro' => 'j Csoport Ro',
        'New Priority' => 'j priorits',
        'New SLA' => 'j SLA',
        'New Service' => 'j Szolgltats',
        'New State' => 'j llapot',
        'New Ticket Lock' => 'Jegy j zrolsi llapota',
        'New Title' => 'j cm',
        'New Type' => 'j Tipus',
        'New account created. Sent Login-Account to %s.' => 'j felhasznl ltrehozva. Belpsi informci %s rszre elkldve.',
        'New messages' => 'j zenetek',
        'New password again' => 'j jelsz megismtlse',
        'No * possible!' => 'A "*" nem lehetsges!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Nincsenek csomagok a krt Keretrendszerhez ebben az on-line csomagtrolban, viszont vannak ms Keretrendszerekhez!',
        'No Packages or no new Packages in selected Online Repository!' => 'Nincsenek csomagok vagy nincsenek j csomagok a kivlasztott on-line csomagtrolban!',
        'No Permission' => 'Nincs jogosultsg',
        'No change time settings.' => 'Nincs vltozs az idbelltsban.',
        'No means, send agent and customer notifications on changes.' => 'Nem esetn mind az gyintznek, mind az gyflnek kld rtestseket a vltozsokrl.',
        'No time settings.' => 'Nincs idbellts.',
        'Node-Address' => 'Node-cm',
        'Node-Name' => 'Node-nv',
        'Note' => 'Megjegyzs',
        'Note Text' => 'Jegyzet szveg',
        'Notification (Customer)' => 'rtests (gyfl)',
        'Notifications' => 'rtestsek',
        'OTRS DB Password' => 'OTRS DB jelsz',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy thelyezsre kerlt.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy tulajdonosa megvltozott.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy llapota megvltozott.',
        'Object already linked as %s.' => 'Objektum %s-knt mr kapcsoldik.',
        'Of couse this feature will take some system performance it self!' => 'Termszetesen ez a kpessg maga is befolysolja a rendszer teljestmnyt!',
        'Only for ArticleCreate Event.' => 'Csak CikkLtrehoz esemnyhez.',
        'Open Tickets' => 'Jegyek megnyitsa',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Az aktulis gyfl felhasznl adatai (pl. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Opcik az aktulis gyfl felhasznli adatokhoz (pl. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Az aktulis gyfl adatai (pl.  <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opcik a jelenlegi felhasznl szmra, aki krte ezt a mveletet (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Opcik a aktulis felhasznlnl aki krte ezt az eljrst. (pl. <OTRS_CURRENT_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'A mveletet vgz felhasznlnak adatai (pl. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Jegy adatok opcii (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Jegy adatok opcii (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'A jegy adatai (pl.  <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'A jegy adatai (pl. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Order' => 'Sorrend',
        'Other Options' => 'Egyb belltsok',
        'Out Of Office' => 'Hzon kvl',
        'POP3 Account Management' => 'Levelezsi POP3 fikok kezelse',
        'Package' => 'Csomag',
        'Param 1' => '1. paramter',
        'Param 2' => '2. paramter',
        'Param 3' => '3. paramter',
        'Param 4' => '4. paramter',
        'Param 5' => '5. paramter',
        'Param 6' => '6. paramter',
        'Parent-Object' => 'Szl objektum',
        'Password is already in use! Please use an other password!' => 'A jelsz mr hasznlatban van! Krem vlasszon msikat!',
        'Password is already used! Please use an other password!' => 'A jelsz mr hasznlatban van! Krem vlasszon msikat!',
        'Passwords doesn\'t match! Please try it again!' => 'A jelszavak nem egyeznek! Prblja meg jra!',
        'Pending Times' => 'Vrakozsi idk',
        'Pending messages' => 'Vrakoz zenetek',
        'Pending type' => 'Vrakozs tpusa',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Jogosultsg belltsok. Kivlaszthat egy vagy tbb csoportot, hogy a belltott statisztikt megtekinthetv tegye a klnbz gyintzk szmra.',
        'Permissions to change the ticket owner in this group/queue.' => 'Jogosultsgok a jegy tulajdonosnak megvltoztatshoz ebben a csoportban/vrlistban.',
        'PhoneView' => 'TelefonNzet',
        'Please contact your admin' => 'Krjk vegye fel a kapcsolatot a rendszergazdjval',
        'PostMaster Filter' => 'Levelezsi szrk',
        'PostMaster POP3 Account' => 'Levelezsi fikok (POP3)',
        'Prio' => 'Prio',
        'Process-Path' => 'Process-tvonal',
        'Product' => 'Termk',
        'Queue <-> Auto Responses Management' => 'Vrlista <-> Automatikus vlaszok kezelse',
        'Queue Management' => 'Vrlistk kezelse',
        'Queues <-> Auto Responses' => 'Vrlista <-> Automatikus vlaszok',
        'Realname' => 'Valdi nv',
        'Rebuild' => 'jrapts',
        'Recipients' => 'Cmzettek',
        'Refresh' => 'Frissts',
        'Reminder' => 'Emlkeztet',
        'Reminder messages' => 'Emlkeztet zenetek',
        'Reporter' => 'Bejelent',
        'Required Field' => 'Ktelez mezk',
        'Reset of escalation time.' => 'Eszkalcis id nullzsa.',
        'Reset of unlock time.' => 'Feloldsi id nullzsa.',
        'Response Management' => 'Reakci kezels',
        'Responses <-> Attachments Management' => 'Vlaszok <-> Levlmellkletek kezelse',
        'Responses <-> Queue Management' => 'Vlaszok <-> Vrlistk kezelse',
        'Return to the compose screen' => 'Visszatrs a szerkesztkpernyre',
        'Role' => 'Szerep',
        'Roles <-> Groups Management' => 'Szerepek <-> Csoportok kezelse',
        'Roles <-> Users' => 'Szerepek <-> Felhasznlk',
        'Roles <-> Users Management' => 'Szerepek <-> Felhasznlk kezelse',
        'Save Job as?' => 'Teendk mentse mskpp?',
        'Save Search-Profile as Template?' => 'Elmenti a keres profilt sablonknt?',
        'Schedule' => 'Idzts',
        'Search Result' => 'Keressi eredmny',
        'Search for' => 'Keresend',
        'Secure Mode need to be enabled!' => 'Biztonsgos zemmdot engedlyezni kell!',
        'Select Box' => 'SQL lekrdezs',
        'Select Box Result' => 'SQL parancs eredmnye',
        'Select Source (for add)' => 'Vlassza ki a forrst (hozzadshoz)',
        'Select the customeruser:service relations.' => 'Vlassza ki az gyfl felhasznl:szolgltats relcit.',
        'Select the element, which will be used at the X-axis' => 'Vlassza ki a tulajdonsgot, amely az X tengelyen fog megjelenni.',
        'Select the restrictions to characterise the stat' => 'Vlassza ki a megktseket a statsztika testre szabshoz',
        'Select the role:user relations.' => 'Vlassza ki a szerep:felhasznl kapcsolatokat.',
        'Select the user:group permissions.' => 'A felhasznl:csoport jogok kivlasztsa.',
        'Select your QueueView refresh time.' => 'Vlassza ki a Vrlista nzet frisstsi idejt.',
        'Select your default spelling dictionary.' => 'Vlassza ki az alaprtelmezett helyesrsellenrz sztrat.',
        'Select your frontend Charset.' => 'Vlassza ki a felhasznli fellet karakterkszlett.',
        'Select your frontend QueueView.' => 'Vlassza ki a felhasznli fellet Vrlista nzett.',
        'Select your frontend language.' => 'Vlassza ki a felhasznli fellet nyelvt.',
        'Select your out of office time.' => 'Vlassza ki a hzon kvl tltend idt.',
        'Select your screen after creating a new ticket.' => 'Vlassza ki a kpernyt j jegy ltrehozsa utn.',
        'Selection needed' => 'Vlasztk szksges',
        'Send Notification' => 'rtests kldse',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Kldjn rtestst ha az gyfl vlaszol s n vagyok a tulajdonosa a jegynek.',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Kldjn rtestst a figyelt jegyrl gy minta a jegy tulajdonosa lenne.',
        'Send no notifications' => 'Ne kldjn rtestseket',
        'Sent new password to: %s' => 'j jelsz %s rszre elkldve.',
        'Sent password token to: %s' => 'Jelsz token %s rszre elkldve.',
        'Service-Name' => 'Szolgltats neve',
        'SessionID invalid! Need user data!' => 'Hibs folyamat azonost! Felhasznli adatok megadsa szksges!',
        'Sessions' => 'Folyamat',
        'Set customer user and customer id of a ticket' => 'A jegyhez tartoz gyfl felhasznlnak s gyfl azonostnak belltsa',
        'Show' => 'Megjelents',
        'Site' => 'Gp',
        'Solution' => 'Megolds',
        'Sort by' => 'Rendezs gy',
        'Source' => 'Forrs',
        'Spell Check' => 'Helyesrsellenrzs',
        'Split' => 'Feloszts',
        'State Type' => 'llapot tpusa',
        'Static-File' => 'Statikus fjl',
        'Stats-Area' => 'Statisztika-terlet',
        'Sub-Queue of' => 'Vrlista al tartozik',
        'Sub-Service of' => 'Szolgtatsa al tartozik',
        'Subscribe' => 'Feliratkozs',
        'System Address updated!' => 'Rendszer cm mdostva!',
        'System State Management' => 'Rendszerllapot kezels',
        'System Status' => 'Rendszer llapota',
        'Systemaddress' => 'Rendszercm',
        'The message being composed has been closed.  Exiting.' => 'Az ppen elkszlt levl lezrsra kerlt. Kilps.',
        'These values are read-only.' => 'Ezek az rtkek csak olvashatk.',
        'These values are required.' => 'Ezen rtkek megadsa ktelez.',
        'This account exists.' => 'Ez a felhasznl mr ltezik.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ez akkor hasznos, ha nem akarja, hogy valaki elrje a statisztika eredmnyt vagy a statsztika nincsen mg teljesen belltva.',
        'This window must be called from compose window' => 'Ezt az ablakot a szerkeszt ablakbl kell hvni',
        'Ticket Lock' => 'Jegy zrols',
        'Ticket Number Generator' => 'Jegy sorszm genertor',
        'Ticket Search' => 'Jegy keress',
        'Ticket Status View' => 'Jegy llapotnak megtekintse',
        'Ticket Type is required!' => 'Jegy tipus szksges!',
        'Ticket changed' => 'Jegy vltozott',
        'Ticket changed between' => 'Jegy vltozott ekztt',
        'Ticket escalation!' => 'Jegy kiemelse!',
        'Ticket locked!' => 'Jegy zrolva!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Jegy tulajdonosnak adatai (pl. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Jegy tulajdonos opcik (pl. <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'A jegy tulajdonosnak adatai (pl.  <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'A jegy felelsnek adatai (pl. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Jegy kivlasztva csoportos mvelethez!',
        'Ticket unlock!' => 'Jegy feloldsa!',
        'Ticket-Area' => 'Jegy-terlet',
        'TicketFreeText' => 'Jegy szabadszveg',
        'TicketZoom' => 'JegyRszletek',
        'Tickets shown' => 'Mutatott jegyek',
        'Tickets which need to be answered!' => 'Vlaszra vr Jegyek!',
        'Timeover' => 'Kss',
        'Times' => 'Idk',
        'Title of the stat.' => 'A statisztika cme.',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Cikk jellemzi pl. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'A bejegyzs attributmnak hasznlata (pl. <OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> s <OTRS_CUSTOMER_Body>).',
        'Top of Page' => 'Lap teteje',
        'Total hits' => 'sszes tallat',
        'U' => 'A',
        'Unable to parse Online Repository index document!' => 'Nem sikerlt rtelmezni az on-line csomagtrol index dokumentumt!',
        'Uniq' => 'Egyedi',
        'Unlock Tickets' => 'Jegyek feloldsa',
        'Unsubscribe' => 'Leiratkozs',
        'Use utf-8 it your database supports it!' => 'Hasznld utf-8-at az adatbzis tmogatsoknl!',
        'Useable options' => 'Hasznlhat opcik',
        'User Management' => 'Felhasznlk kezelse',
        'User will be needed to handle tickets.' => 'Felhasznl szksges a jegyek kezelshez.',
        'User-Name' => 'Felhasznlnv',
        'User-Number' => 'Felhasznl-szm',
        'Users' => 'Felhasznlk',
        'Users <-> Groups' => 'Felhasznlk <-> Csoportok',
        'Users <-> Groups Management' => 'Felhasznlk <-> Csoportok kezelse',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Figyelmeztets! Ezek a jegyek el lesznek tvoltva az adatbzisbl! Ezek a jegyek elvesznek!',
        'Watch notification' => 'Figyels rtest',
        'Web-Installer' => 'Web-telept',
        'Welcome to OTRS' => 'dvzli az OTRS',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'rvnytelen statisztika esetn nem lehetsges a statiszika ellltsa.',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'A bemeneti s kivlaszthat mezkkel kivlaszthatja a kvnt statisztikt. Az n ltal szerkeszthet statisztika rtkek a statisztikt bellt adminisztrtortl fggnek.',
        'Workflow Groups' => 'Workflow csoportok',
        'Yes means, send no agent and customer notifications on changes.' => 'Igen esetn nem kld rtestsekes sem az gyintznek, sem az gyflnek a vltozsokrl.',
        'Yes, save it with name' => 'Igen, elmentve ezen a nven',
        'You got new message!' => 'j zenete rkezett!',
        'You have to select two or more attributes from the select field!' => 'Legalbb kt rtket vlasszon ki a mezben!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Kell egy e-mail cm (pl. customer@example.com) cmzettnek!',
        'You need min. one selected Ticket!' => 'Legalbb egy jegyet ki kell vlasztani!',
        'You need to account time!' => 'El kell szmolnia az idvel!',
        'You need to activate %s first to use it!' => '%s aktivlsra van szksg mieltt hasznln!',
        'You use the DELETE option! Take care, all deleted Tickets are lost!!!' => 'A TRLS opcit hasznlja! Legyen vatos, az sszes trlt jegy elveszik!!!',
        'Your email address is new' => 'Az n e-mail cme j',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Az n "<OTRS_TICKET>" szm jegyhez rendelt e-mailje visszakldsre kerlt a "<OTRS_BOUNCE_TO>" cmre. Vegye fel ezzel a cmmel a kapcsolatot tovbbi informcikrt.',
        'Your own Ticket' => 'Az n sajt jegye',
        'auto follow up' => 'automatikus vlasz',
        'auto reject' => 'automatikus visszautasts',
        'auto remove' => 'automatikus trls',
        'auto reply' => 'automatikus vlasz',
        'auto reply/new ticket' => 'automatikus vlasz/j jegy',
        'customer realname' => 'gyfl valdi nv',
        'down' => 'le',
        'false' => 'hamis',
        'for agent firstname' => 'gyintz keresztnvhez',
        'for agent lastname' => 'gyintz csaldinvhez',
        'for agent login' => 'gyintz belpshez',
        'for agent user id' => 'gynk felhasznl azonostjhoz',
        'kill all sessions' => 'Minden eljrs kilvse',
        'kill session' => 'folyamat trlse',
        'modified' => 'mdostott',
        'new ticket' => 'j jegy',
        'next step' => 'kvetkez lps',
        'not rated' => 'nincs besorolva',
        'not verified' => 'nem ellenrztt',
        'read' => 'olvasott',
        'send' => 'klds',
        'sort downward' => 'rendezs lefel',
        'sort upward' => 'rendezs felfel',
        'tmp_lock' => 'ideiglenesen zrolt',
        'to get the first 20 character of the subject' => 'hogy megkapja az els 20 karaktert a trgybl',
        'to get the first 5 lines of the email' => 'hogy megkapja az els 5 sort az e-mailbl',
        'to get the from line of the email' => 'hogy megkapja a feladt az e-mailbl',
        'to get the realname of the sender (if given)' => 'hogy megkapja a felad valdi nevt (ha lehetsges)',
        'unknown' => 'ismeretlen',
        'unread' => 'olvasatlan',
        'up' => 'fel',
        'utf8' => 'utf8',
        'verified' => 'ellenrztt',
        'x' => 'x',

    };
    # $$STOP$$
    return;
}

1;
