#!/usr/bin/perl
# --
# Copyright (C) 2001-2018 OTRS AG, https://otrs.com/
# --
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

use strict;
use warnings;

use File::Basename;
use FindBin qw($RealBin);
use lib dirname($RealBin);
use lib dirname($RealBin) . '/Kernel/cpan-lib';
use lib dirname($RealBin) . '/Custom';

use Getopt::Std;

use Kernel::System::ObjectManager;

# get options
my %Opts;
getopt( '', \%Opts );
if ( $Opts{h} ) {
    print "otrs.CleanUp.pl - OTRS cleanup\n";
    print "Copyright (C) 2001-2018 OTRS AG, https://otrs.com/\n";
    print "usage: otrs.CleanUp.pl \n";
    exit 1;
}

# create object manager
local $Kernel::OM = Kernel::System::ObjectManager->new(
    'Kernel::System::Log' => {
        LogPrefix => 'OTRS-otrs.CleanUp.pl',
    },
);

# clean up tmp storage
print "Cleaning up LogCache ...";
if ( $Kernel::OM->Get('Kernel::System::Log')->CleanUp() ) {
    print " done.\n";
}
else {
    print " failed.\n";
}

print "Cleaning up SessionData...";
if ( $Kernel::OM->Get('Kernel::System::AuthSession')->CleanUp() ) {
    print " done.\n";
}
else {
    print " failed.\n";
}

exit 0;
