#!/usr/bin/perl
# --
# Copyright (C) 2001-2018 OTRS AG, https://otrs.com/
# --
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

use strict;
use warnings;

use File::Basename;
use FindBin qw($RealBin);
use lib dirname($RealBin);
use lib dirname($RealBin) . '/Kernel/cpan-lib';
use lib dirname($RealBin) . '/Custom';

use File::Spec;
use Getopt::Std;

use Kernel::System::ObjectManager;

# get options
my %Opts;
getopt( '', \%Opts );
if ( $Opts{'h'} ) {
    print "otrs.ReprocessMails.pl - reprocess mails from spool directory\n";
    print "Copyright (C) 2001-2018 OTRS AG, https://otrs.com/\n";
    print "usage: otrs.ReprocessMails.pl \n";
    exit 1;
}

# create object manager
local $Kernel::OM = Kernel::System::ObjectManager->new(
    'Kernel::System::Log' => {
        LogPrefix => 'OTRS-otrs.ReprocessMails.pl',
    },
);

my $HomeDir    = $Kernel::OM->Get('Kernel::Config')->Get('Home');
my $SpoolDir   = File::Spec->catfile( $HomeDir, 'var/spool' );
my $PostMaster = File::Spec->catfile( $HomeDir, 'bin/otrs.PostMaster.pl' );

if ( !-d $SpoolDir ) {
    die "No spooldir found: $SpoolDir does not exist!\n";
}

print "Processing mails in $SpoolDir\n";

my @Files = $Kernel::OM->Get('Kernel::System::Main')->DirectoryRead(
    Directory => $SpoolDir,
    Filter    => '*',
);

for my $File (@Files) {
    print "Processing $File... ";
    my $Result = system("\"$^X\" \"$PostMaster\" <  $File ");

    if ( !$Result ) {
        $Kernel::OM->Get('Kernel::System::Log')->Log(
            Priority => 'info',
            Message  => "Successfully reprocessed email $File.",
        );
        unlink $File;
        print "Ok.\n\n";
    }
    else {
        $Kernel::OM->Get('Kernel::System::Log')->Log(
            Priority => 'error',
            Message  => "Could not re-process email $File.",
        );
        print "Fail.\n\n";
    }
}

print "Done.\n";

exit 0;
