# --
# Copyright (C) 2001-2017 OTRS AG, http://otrs.com/
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

use strict;
use warnings;
use utf8;

use vars (qw($Self));

# get selenium object
my $Selenium = $Kernel::OM->Get('Kernel::System::UnitTest::Selenium');

$Selenium->RunTest(
    sub {

        my $Helper = $Kernel::OM->Get('Kernel::System::UnitTest::Helper');

        my $TestUserLogin = $Helper->TestUserCreate(
            Groups => ['admin'],
        ) || die "Did not get test user";

        $Selenium->Login(
            Type     => 'Agent',
            User     => $TestUserLogin,
            Password => $TestUserLogin,
        );

        my $ScriptAlias = $Kernel::OM->Get('Kernel::Config')->Get('ScriptAlias');

        # go to agent preferences
        $Selenium->VerifiedGet("${ScriptAlias}index.pl?Action=AgentPreferences");

        # wait until form has loaded, if neccessary
        $Selenium->WaitFor( JavaScript => 'return typeof($) === "function" && $("body").length' );

        # change test user password preference, input incorrect current password
        my $NewPw = "new" . $TestUserLogin;
        $Selenium->find_element( "#CurPw",  'css' )->send_keys("incorrect");
        $Selenium->find_element( "#NewPw",  'css' )->send_keys($NewPw);
        $Selenium->find_element( "#NewPw1", 'css' )->send_keys($NewPw);

        $Selenium->execute_script("\$('button[type=submit]:eq(0)').click();");

        # check for incorrect password update preferences message on screen
        my $IncorrectUpdateMessage = "The current password is not correct. Please try again!";
        $Selenium->WaitFor(
            JavaScript =>
                "return typeof(\$) === 'function' &&  \$('.MessageBox p').text().trim().includes('$IncorrectUpdateMessage');"
        );
        $Self->True(
            index( $Selenium->execute_script("return \$('.MessageBox p').text().trim()"), $IncorrectUpdateMessage )
                > -1,
            'Agent incorrect preferences password - update'
        );

        # change test user password preference, correct input
        $Selenium->find_element( "#CurPw",  'css' )->send_keys($TestUserLogin);
        $Selenium->find_element( "#NewPw",  'css' )->send_keys($NewPw);
        $Selenium->find_element( "#NewPw1", 'css' )->send_keys($NewPw);
        $Selenium->execute_script("\$('button[type=submit]:eq(0)').click();");

        # check for correct password update preferences message on screen
        my $UpdateMessage = "Preferences updated successfully!";
        $Selenium->WaitFor(
            JavaScript =>
                "return typeof(\$) === 'function' &&  \$('.MessageBox p').text().trim().includes('$UpdateMessage');"
        );
        $Self->True(
            index( $Selenium->execute_script("return \$('.MessageBox p').text().trim()"), $UpdateMessage ) > -1,
            'Agent preference password - updated'
        );
    }
);

1;
