# --
# Copyright (C) 2001-2021 OTRS AG, https://otrs.com/
# Copyright (C) 2021 Znuny GmbH, https://znuny.org/
# Copyright (C) 2010 Milorad Jovanovic <j.milorad at gmail.com>
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

#
# THIS FILE IS AUTOGENERATED FROM sr_Cyrl WITH BY TRANSLITERATION.
#   See TranslationsUpdate.pm for details.
#

package Kernel::Language::sr_Latn;

use strict;
use warnings;
use utf8;

sub Data {
    my $Self = shift;

    # $$START$$
    # possible charsets
    $Self->{Charset} = ['utf-8', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%T - %D.%M.%Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';
    $Self->{Completeness}        = 0.916036673636802;

    # csv separator
    $Self->{Separator}         = ';';

    $Self->{DecimalSeparator}  = ',';
    $Self->{ThousandSeparator} = ' ';
    $Self->{Translation} = {

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminACL.tt
        'ACL Management' => 'Upravljanje ACL',
        'Actions' => 'Akcije',
        'Create New ACL' => 'Kreiraj novu ACL listu',
        'Deploy ACLs' => 'Rasporedi ACL liste',
        'Export ACLs' => 'Izvezi ACL liste',
        'Filter for ACLs' => 'Filter za ACL',
        'Just start typing to filter...' => 'Počnite sa kucanjem za filter...',
        'Configuration Import' => 'Uvoz konfiguracije',
        'Here you can upload a configuration file to import ACLs to your system. The file needs to be in .yml format as exported by the ACL editor module.' =>
            'Ovde možete poslati konfiguracionu datoteku za uvoz ACL lista u vaš sistem. Datoteka mora biti u .yml formatu ako se izvozi od strane ACL editor modula.',
        'This field is required.' => 'Ovo polje je obavezno.',
        'Overwrite existing ACLs?' => 'Prepiši preko postojećih ACL lista?',
        'Upload ACL configuration' => 'Otpremi ACL konfiguraciju',
        'Import ACL configuration(s)' => 'Uvezi ACL konfiguraciju',
        'Description' => 'Opis',
        'To create a new ACL you can either import ACLs which were exported from another system or create a complete new one.' =>
            'Da biste kreirali novu ACL možete ili uvesti ACL liste koje su izvezene iz drugog sistema ili napraviti kompletno novu.',
        'Changes to the ACLs here only affect the behavior of the system, if you deploy the ACL data afterwards. By deploying the ACL data, the newly made changes will be written to the configuration.' =>
            'Promene na ACL listama ovde samo utiču na ponašanje sistema, ukoliko naknadno upotrebite sve ACL podatke.',
        'ACLs' => 'ACL liste',
        'Please note: This table represents the execution order of the ACLs. If you need to change the order in which ACLs are executed, please change the names of the affected ACLs.' =>
            'Napomena: Ova tabela predstavlja redosled izvršavanja u ACL listama. Ako je potrebno da promenite redosled kojim se izvršavaju ACL liste, molimo promenite imena tih ACL lista.',
        'ACL name' => 'Naziv ACL',
        'Comment' => 'Komentar',
        'Validity' => 'Važnost',
        'Export' => 'Izvoz',
        'Copy' => 'Kopija',
        'No data found.' => 'Ništa nije pronađeno.',
        'No matches found.' => 'Ništa nije pronađeno.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminACLEdit.tt
        'Edit ACL %s' => 'Uredi ACL %s',
        'Edit ACL' => 'Uredi ACL',
        'Go to overview' => 'Idi na pregled',
        'Delete ACL' => 'Obriši ACL',
        'Delete Invalid ACL' => 'Obriši nevažeću ACL',
        'Match settings' => 'Uskladi podešavanja',
        'Set up matching criteria for this ACL. Use \'Properties\' to match the current screen or \'PropertiesDatabase\' to match attributes of the current ticket that are in the database.' =>
            'Podesite usklađene kriterijume za ovu ACL listu. Koristite Properties tako da odgovara postojećem prikazu ekrana ili PropertiesDatabase da bi odgovarao atributima postojećeg tiketa koji su u bazi podataka.',
        'Change settings' => 'Promeni podešavanja',
        'Set up what you want to change if the criteria match. Keep in mind that \'Possible\' is a white list, \'PossibleNot\' a black list.' =>
            'Podesite ono što želite da menjate ako se kriterijumi slažu. Imajte na umu da je \'Possible\' bela lista, \'PossibleNot\' crna lista.',
        'Check the official %sdocumentation%s.' => 'Pročitajte zvaničnu %sdokumentaciju%s.',
        'Show or hide the content' => 'Pokaži ili sakrij sadržaj',
        'Edit ACL Information' => 'Uredi informacije o ACL',
        'Name' => 'Naziv',
        'Stop after match' => 'Zaustavi posle poklapanja',
        'Edit ACL Structure' => 'Uredi strukturu ACL',
        'Save ACL' => 'Sačuvaj ACL',
        'Save' => 'Sačuvaj',
        'or' => 'ili',
        'Save and finish' => 'Sačuvaj i završi',
        'Cancel' => 'Otkaži',
        'Do you really want to delete this ACL?' => 'Da li stvarno želite da obrišete ovu ACL listu?',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminACLNew.tt
        'Create a new ACL by submitting the form data. After creating the ACL, you will be able to add configuration items in edit mode.' =>
            'Kreirajte novu ACL listu podnošenjem obrasca sa podacima. Nakon kreiranja ACL liste, bićete u mogućnosti da dodate konfiguracione stavke u modu izmene.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminAppointmentCalendarManage.tt
        'Calendar Management' => 'Upravljanje kalendarima',
        'Add Calendar' => 'Dodaj kalendar',
        'Edit Calendar' => 'Izmeni kalendar',
        'Calendar Overview' => 'Pregled kalendara',
        'Add new Calendar' => 'Dodaj novi kalendar',
        'Import Appointments' => 'Uvezi termine',
        'Calendar Import' => 'Uvoz kalendara',
        'Here you can upload a configuration file to import a calendar to your system. The file needs to be in .yml format as exported by calendar management module.' =>
            'Ovde možete učitati konfiguracionu datoteku za uvoz kalendara u vaš sistem. Datoteka mora biti u .yml formatu izvezena od strane modula za upravljanje kalendarima.',
        'Overwrite existing entities' => 'Napiši preko postojećih entiteta',
        'Upload calendar configuration' => 'Učitaj konfiguraciju kalendara',
        'Import Calendar' => 'Uvezi kalendar',
        'Filter for Calendars' => 'Filter za kalendare',
        'Filter for calendars' => 'Filter za kalendare',
        'Depending on the group field, the system will allow users the access to the calendar according to their permission level.' =>
            'U zavisnosti od polja grupe, sistem će dozvoliti pristup kalendaru operaterima prema njihovom nivou pristupa.',
        'Read only: users can see and export all appointments in the calendar.' =>
            'RO: operateri mogu pregledati i eksportovati sve termine u kalendaru.',
        'Move into: users can modify appointments in the calendar, but without changing the calendar selection.' =>
            'Premesti u: operateri mogu modifikovati termine u kalendaru, ali bez promene kom kalendaru pripadaju.',
        'Create: users can create and delete appointments in the calendar.' =>
            'Kreiranje: operateri mogu kreirati i brisati termine u kalendaru.',
        'Read/write: users can manage the calendar itself.' => 'RW: operateri mogu administrirati i sam kalendar.',
        'Group' => 'Grupa',
        'Changed' => 'Izmenjeno',
        'Created' => 'Kreirano',
        'Download' => 'Preuzimanje',
        'URL' => 'Adresa',
        'Export calendar' => 'Izvezi kalendar',
        'Download calendar' => 'Preuzmi kalendar',
        'Copy public calendar URL' => 'Iskopiraj javnu adresu kalendara (URL)',
        'Calendar' => 'Kalendar',
        'Calendar name' => 'Naziv kalendara',
        'Calendar with same name already exists.' => 'Kalendar sa istim nazivom već postoji.',
        'Color' => 'Boja',
        'Permission group' => 'Grupa pristupa',
        'Ticket Appointments' => 'Termini tiketa',
        'Rule' => 'Pravilo',
        'Remove this entry' => 'Ukloni ovaj unos',
        'Remove' => 'Ukloni',
        'Start date' => 'Datum početka',
        'End date' => 'Datum kraja',
        'Use options below to narrow down for which tickets appointments will be automatically created.' =>
            'Koristeći opcije ispod izaberite za koje tikete će termini biti automatski kreirani.',
        'Queues' => 'Redovi',
        'Please select a valid queue.' => 'Molimo da odaberete važeći red.',
        'Search attributes' => 'Atributi pretrage',
        'Add entry' => 'Dodaj unos',
        'Add' => 'Dodati',
        'Define rules for creating automatic appointments in this calendar based on ticket data.' =>
            'Definišite pravila za kreiranje automatskih termina u ovom kalendaru na osnovu tiketa.',
        'Add Rule' => 'Dodaj pravilo',
        'Submit' => 'Pošalji',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminAppointmentImport.tt
        'Appointment Import' => 'Uvoz termina',
        'Go back' => 'Idi nazad',
        'Uploaded file must be in valid iCal format (.ics).' => 'Poslati fajl mora biti u ispravnom iCal formatu (.ics).',
        'If desired Calendar is not listed here, please make sure that you have at least \'create\' permissions.' =>
            'Ukoliko željeni kalendar nije izlistan, proverite da li imate nivo pristupa \'kreiranje\' za grupu kalendara.',
        'Upload' => 'Otpremanje',
        'Update existing appointments?' => 'Osveži postojeće termine?',
        'All existing appointments in the calendar with same UniqueID will be overwritten.' =>
            'Svi postojeći termini u kalendaru sa istim UniqueID poljem će biti prebrisani.',
        'Upload calendar' => 'Pošalji kalendar',
        'Import appointments' => 'Uvezi termine',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminAppointmentNotificationEvent.tt
        'Appointment Notification Management' => 'Upravljanje obaveštenjima o terminima',
        'Add Notification' => 'Dodaj Obaveštenje',
        'Edit Notification' => 'Uredi obaveštenje',
        'Export Notifications' => 'Obaveštenja o izvozu',
        'Filter for Notifications' => 'Filter za obaveštenja',
        'Filter for notifications' => 'Filter za obaveštenja',
        'Here you can upload a configuration file to import appointment notifications to your system. The file needs to be in .yml format as exported by the appointment notification module.' =>
            'Ovde možete poslati konfiguracionu datoteku za uvoz obaveštenja o terminu u vaš sistem. Datoteka mora biti u istom .yml formatu koji je moguće dobiti izvozom u ekranu upravljanja obaveštenjima o terminima.',
        'Overwrite existing notifications?' => 'Prepiši preko postojećih obaveštenja?',
        'Upload Notification configuration' => 'Otpremi konfiguraciju obaveštavanja',
        'Import Notification configuration' => 'Uvezi konfiguraciju obaveštenja',
        'List' => 'Lista',
        'Delete' => 'Izbrisati',
        'Delete this notification' => 'Obriši ovo obaveštenje',
        'Show in agent preferences' => 'Prikazano u operaterskim postavkama',
        'Agent preferences tooltip' => 'Poruka za operaterska podešavanja',
        'This message will be shown on the agent preferences screen as a tooltip for this notification.' =>
            'Ova poruka će biti prikazana na ekranu operaterskih podešavanja kao ispomoć.',
        'Toggle this widget' => 'Preklopi ovaj dodatak',
        'Events' => 'Događaji',
        'Event' => 'Događaj',
        'Here you can choose which events will trigger this notification. An additional appointment filter can be applied below to only send for appointments with certain criteria.' =>
            'Ovde možete izabrati koji događaji će pokrenuti obaveštavanje. Dodatni filter za termine može biti primenjen radi slanja samo za termine po određenom kriterijumu.',
        'Appointment Filter' => 'Filter termina',
        'Type' => 'Tip',
        'Title' => 'Naslov',
        'Location' => 'Lokacija',
        'Team' => 'Tim',
        'Resource' => 'Resurs',
        'Recipients' => 'Primaoci',
        'Send to' => 'Pošalji za',
        'Send to these agents' => 'Pošalji ovim operaterima',
        'Send to all group members (agents only)' => 'Pošalji svim članovima grupe (samo operaterima)',
        'Send to all role members' => 'Pošalji svim pripadnicima uloge',
        'Send on out of office' => 'Pošalji i kad je van kancelarije',
        'Also send if the user is currently out of office.' => 'Takođe pošalji i kada je korisnik van kancelarije.',
        'Once per day' => 'Jednom dnevno',
        'Notify user just once per day about a single appointment using a selected transport.' =>
            'Obavesti korisnika samo jednom dnevno o pojedinačnom terminu korišćenjem izabranog transporta.',
        'Notification Methods' => 'Metode obaveštavanja',
        'These are the possible methods that can be used to send this notification to each of the recipients. Please select at least one method below.' =>
            'Ovo su moguće metode koje se mogu koristiti za slanje obaveštenja svakom primaocu. Molimo vas da izaberete bar jednu metodu od ponuđenih.',
        'Enable this notification method' => 'Aktiviraj ovaj metod obaveštavanja',
        'Transport' => 'Transport',
        'At least one method is needed per notification.' => 'Neophodan je najmanje jedan metod po obaveštenju.',
        'Active by default in agent preferences' => 'Podrazumevano aktivno u operaterskim postavkama',
        'This is the default value for assigned recipient agents who didn\'t make a choice for this notification in their preferences yet. If the box is enabled, the notification will be sent to such agents.' =>
            'Ovo je podrazumevana vrednost za pridružene operatere primaoce koji za ovo obaveštenje u svojim postavkama nisu još napravili izbor. Ako je boks aktiviran, obaveštenje će biti poslato takvim operaterima.',
        'This feature is currently not available.' => 'Ovo svojstvo trenutno nije dostupno.',
        'Please activate this transport in order to use it.' => 'Molimo aktivirajte ovaj transport pre korišćenja.',
        'No data found' => 'Ništa nije pronađeno',
        'No notification method found.' => 'Nije pronađena metoda obaveštavanja.',
        'Notification Text' => 'Tekst obaveštenja',
        'This language is not present or enabled on the system. This notification text could be deleted if it is not needed anymore.' =>
            'Ovaj jezik nije prisutan ili uključen na sistemu. Ovo obaveštenje može biti izbrisano ukoliko više nije neophodno.',
        'Remove Notification Language' => 'Ukloni jezik obaveštenja',
        'Subject' => 'Predmet',
        'Text' => 'Tekst',
        'Message body' => 'Sadržaj poruke',
        'Add new notification language' => 'Ukloni novi jezik obaveštenja',
        'Save Changes' => 'Sačuvaj promene',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminAppointmentNotificationEventTransportEmailSettings.tt
        'Additional recipient email addresses' => 'Imejl adresa dodatnog primaoca',
        'This field must have less then 200 characters.' => 'Ovo polje ne sme biti duže od 200 karaktera.',
        'Article visible for customer' => 'Članak vidljiv klijentima',
        'An article will be created if the notification is sent to the customer or an additional email address.' =>
            'Članak je kreiran i obaveštenje poslato klijentu ili na drugu imejl adresu.',
        'Email template' => 'Imejl šablon',
        'Use this template to generate the complete email (only for HTML emails).' =>
            'Upotrebite ovaj šablon za generisanje kompletnog imejla (samo za HTML imejlove).',
        'Enable email security' => 'Aktivirajte bezbednost imejla',
        'Email security level' => 'Nivo bezbednosti imejla',
        'If signing key/certificate is missing' => 'Ako potpisivanje ključa/sertifikata nedostaje',
        'If encryption key/certificate is missing' => 'Ako ključa/sertifikat za šifriranje nedostaje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminAttachment.tt
        'Attachment Management' => 'Upravljanje prilozima',
        'Add Attachment' => 'Dodaj prilog',
        'Edit Attachment' => 'Uredi prilog',
        'Filter for Attachments' => 'Filter za priloge',
        'Filter for attachments' => 'Filter za priloge',
        'Related Actions' => '',
        'Templates' => 'Šabloni',
        'Templates ↔ Attachments' => 'Šabloni ↔ prilozi',
        'Filename' => 'Naziv datoteke',
        'Download file' => 'Preuzmi datoteku',
        'Delete this attachment' => 'Obriši ovaj prilog',
        'Do you really want to delete this attachment?' => 'Da li stvarno želite da obrišete ovaj prilog?',
        'Attachment' => 'Prilog',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminAutoResponse.tt
        'Auto Response Management' => 'Upravljanje automatskim odgovorima',
        'Add Auto Response' => 'Dodaj Automatski Odgovor',
        'Edit Auto Response' => 'Uredi Automatski Odgovor',
        'Filter for Auto Responses' => 'Filter za automatske odgovore',
        'Filter for auto responses' => 'Filter za automatske odgovore',
        'Queues ↔ Auto Responses' => 'Redovi ↔ automatski odgovori',
        'Response' => 'Odgovor',
        'Auto response from' => 'Automatski odgovor od',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCloudServiceSupportDataCollector.tt
        'Cloud Service Management' => 'Upravljanje servisima u oblaku',
        'Support Data Collector' => 'Sakupljač podataka podrške',
        'Support data collector' => 'Sakupljač podataka podrške',
        'Hint' => 'Savet',
        'Currently support data is only shown in this system.' => 'Aktuelni podaci podrške se prikazuju samo na ovom sistemu.',
        'It is highly recommended to send this data to OTRS Group in order to get better support.' =>
            'Preporučuje se da ove podatke pošaljete OTRS grupi da bi ste dobili bolju podršku.',
        'Configuration' => 'Konfiguracija',
        'Send support data' => 'Pošalji podatke za podršku',
        'This will allow the system to send additional support data information to OTRS Group.' =>
            'Ovo će omogućiti sistemu da pošalje dodatne informacije o podacima podrške OTRS grupi.',
        'Update' => 'Ažuriranje',
        'System Registration' => 'Registracija sistema',
        'To enable data sending, please register your system with OTRS Group or update your system registration information (make sure to activate the \'send support data\' option.)' =>
            'Da bi ste omogućili slanje podataka, molimo vas da registrujete vaš sistem u OTRS grupi ili da ažurirate informacije sistemske registracije (budite sigurni da ste aktivirali opciju "Pošalji podatke za podršku")',
        'Register this System' => 'Registruj ovaj sistem',
        'System Registration is disabled for your system. Please check your configuration.' =>
            'Sistemska registracije je deaktivirana za vaš sistem. Molimo da proverite vašu konfiguraciju.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCloudServices.tt
        'System registration is a service of OTRS Group, which provides a lot of advantages!' =>
            'Registracija sistema je usluga OTRS grupe, koja obezbeđuje mnoge prednosti!',
        'Please note that the use of OTRS cloud services requires the system to be registered.' =>
            'Napominjemo da korišćenje OTRS servisa u oblaku zahtevaju da sistem bude registrovan.',
        'Here you can configure available cloud services that communicate securely with %s.' =>
            'Ovde možete podesiti da dostupni servisi u oblaku koriste sigurnu komunikaciju preko %s.',
        'Available Cloud Services' => 'Raspoloživi servisi u oblaku',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCommunicationLog.tt
        'Communication Log' => 'Komunikacioni log',
        'Time Range' => 'Vremenski opseg',
        'Show only communication logs created in specific time range.' =>
            'Prikaži samo komunikacione logove kreirane u određenom vremenskom periodu.',
        'Filter for Communications' => 'Filter za komunikacije',
        'Filter for communications' => 'Filter za komunikacije',
        'In this screen you can see an overview about incoming and outgoing communications.' =>
            'U ovom ekranu možete pregledati sve dolazne i odlazne komunikacije.',
        'You can change the sort and order of the columns by clicking on the column header.' =>
            'Možete izmeniti redosled sortiranja kolona klikom na naslove kolona.',
        'If you click on the different entries, you will get redirected to a detailed screen about the message.' =>
            'Ukoliko kliknete na pojedinačne stavke, bićete redirektovani na ekran detalja u vezi poruke.',
        'Status for: %s' => 'Status za: %s',
        'Failing accounts' => 'Nalozi sa greškama',
        'Some account problems' => 'Par problema sa nalozima',
        'No account problems' => 'Bez problema sa nalozima',
        'No account activity' => 'Bez aktivnosti naloga',
        'Number of accounts with problems: %s' => 'Broj naloga sa problemima: %s',
        'Number of accounts with warnings: %s' => 'Broj naloga sa upozorenjima: %s',
        'Failing communications' => 'Neuspele komunikacije',
        'No communication problems' => 'Bez problema sa komunikacijama',
        'No communication logs' => 'Bez komunikacionih logova',
        'Number of reported problems: %s' => 'Broj prijavljenih problema: %s',
        'Open communications' => 'Otvorene komunikacije',
        'No active communications' => 'Bez aktivnih komunikacija',
        'Number of open communications: %s' => 'Broj otvorenih komunikacija: %s',
        'Average processing time' => 'Prosečno vreme obrade',
        'List of communications (%s)' => 'Lista komunikacija (%s)',
        'Settings' => 'Podešavanja',
        'Entries per page' => 'Unosa po strani',
        'No communications found.' => 'Nisu pronađene komunikacije.',
        '%s s' => '%s s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCommunicationLogAccounts.tt
        'Account Status' => 'Status naloga',
        'Back to overview' => 'Idi nazad na pregled',
        'Filter for Accounts' => 'Filter za naloge',
        'Filter for accounts' => 'Filter za naloge',
        'You can change the sort and order of those columns by clicking on the column header.' =>
            'Možete izmeniti redosled sortiranja kolona klikom na naslove kolona.',
        'Account status for: %s' => 'Status naloga za: %s',
        'Status' => 'Status',
        'Account' => 'Nalog',
        'Edit' => 'Urediti',
        'No accounts found.' => 'Nisu pronađeni nalozi.',
        'Communication Log Details (%s)' => 'Detalji komunikacionog loga (%s)',
        'Direction' => 'Smer',
        'Start Time' => 'Vreme početka',
        'End Time' => 'Vreme završetka',
        'No communication log entries found.' => 'Nisu pronađene stavke komunikacionog loga.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCommunicationLogCommunications.tt
        'Duration' => 'Trajanje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCommunicationLogObjectLog.tt
        '#' => '#',
        'Priority' => 'Prioritet',
        'Module' => 'Modul',
        'Information' => 'Informacija',
        'No log entries found.' => 'Nisu pronađene stavke loga.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCommunicationLogZoom.tt
        'Detail view for %s communication started at %s' => 'Detaljni prikaz za komunikaciju %s započetu u %s',
        'Filter for Log Entries' => 'Filter za log stavke',
        'Filter for log entries' => 'Filter za log stavke',
        'Show only entries with specific priority and higher:' => 'Prikaži samo stavke sa odgovarajućim prioritetom i više:',
        'Communication Log Overview (%s)' => 'Pregled komunikacionih logova (%s)',
        'No communication objects found.' => 'Nisu pronađeni komunikacioni objekti.',
        'Communication Log Details' => 'Detalji komunikacionog loga',
        'Please select an entry from the list.' => 'Molimo izaberite stavku iz liste.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCustomerCompany.tt
        'Customer Management' => 'Upravljanje klijentima',
        'Add Customer' => 'Dodaj klijenta',
        'Edit Customer' => 'Izmeni klijenta',
        'Search' => 'Traži',
        'Wildcards like \'*\' are allowed.' => 'Džokerski znaci kao \'*\' su dozvoljeni.',
        'Select' => 'Izaberi',
        'Customer Users' => 'Klijenti korisnici',
        'Customers ↔ Groups' => 'Klijenti ↔ grupe',
        'List (only %s shown - more available)' => 'Lista (samo %s je prikazano - raspoloživo više)',
        'total' => 'ukupno',
        'Please enter a search term to look for customers.' => 'Molimo unesite pojam pretrage za pronalaženje klijenata.',
        'Customer ID' => 'ID klijenta',
        'Please note' => 'Napominjemo',
        'This customer backend is read only!' => 'Ovaj izvor klijenata se može samo pregledati.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCustomerGroup.tt
        'Manage Customer-Group Relations' => 'Upravljanje relacijama klijent-grupa',
        'Notice' => 'Napomena',
        'This feature is disabled!' => 'Ova funkcija je isključena!',
        'Just use this feature if you want to define group permissions for customers.' =>
            'Upotrebite ovu funkciju ako želite da definišete grupne dozvole za klijente.',
        'Enable it here!' => 'Aktivirajte je ovde!',
        'Edit Customer Default Groups' => 'Uredi podrazumevane grupe za klijenta',
        'These groups are automatically assigned to all customers.' => 'Ove grupe su automatski dodeljene svim klijentima.',
        'You can manage these groups via the configuration setting "CustomerGroupCompanyAlwaysGroups".' =>
            'Možete upravljati ovim grupama preko konfiguracionog podešavanja CustomerGroupCompanyAlwaysGroups.',
        'Filter for Groups' => 'Filter za grupe',
        'Select the customer:group permissions.' => 'Izaberi klijent:grupa dozvole.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' =>
            'Ako ništa nije izabrano, onda nema dozvola u ovoj grupi (tiketi neće biti dostupni klijentu).',
        'Customers' => 'Klijenti',
        'Groups' => 'Grupe',
        'Search Results' => 'Rezultat pretrage',
        'Change Group Relations for Customer' => 'Promeni veze sa grupama za klijenta',
        'Change Customer Relations for Group' => 'Promeni veze sa klijentima za grupu',
        'Toggle %s Permission for all' => 'Promeni %s dozvole za sve',
        'Toggle %s permission for %s' => 'Promeni %s dozvole za %s',
        'Customer Default Groups:' => 'Podrazumevane grupe za klijenta:',
        'No changes can be made to these groups.' => 'Na ovim grupama promene nisu moguće.',
        'Reference' => 'Referenca',
        'ro' => 'ro',
        'Read only access to the ticket in this group/queue.' => 'Pristup ograničen samo na čitanje za tikete u ovim grupama/redovima.',
        'rw' => 'rw',
        'Full read and write access to the tickets in this group/queue.' =>
            'Pristup bez ograničenja za tikete u ovim grupama/redovima.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCustomerUser.tt
        'Customer User Management' => 'Upravljanje klijentima klijentima',
        'Add Customer User' => 'Dodaj klijenta korisnika',
        'Edit Customer User' => 'Uredi klijenta korisnika',
        'Back to search results' => 'Vrati se na rezultate pretrage',
        'Customer user are needed to have a customer history and to login via customer panel.' =>
            'Klijent klijent treba da ima klijentski istorijat i da se prijavi preko klijentskog panela.',
        'Customer Users ↔ Customers' => 'Klijent korisnici ↔ klijenti',
        'Customer Users ↔ Groups' => 'Klijenti korisnici ↔ Grupe',
        'Customer Users ↔ Services' => 'Klijent korisnici ↔ servisi',
        'List (%s total)' => 'Lista (%s ukupno)',
        'Username' => 'Korisničko ime',
        'Email' => 'Imejl',
        'Last Login' => 'Poslednja prijava',
        'Login as' => 'Prijavi se kao',
        'Switch to customer' => 'Pređi na klijenta',
        'This customer backend is read only, but the customer user preferences can be changed!' =>
            'Ovaj izvor klijenata se može samo pregledati, ali klijentska podešavanja se mogu izmeniti!',
        'This field is required and needs to be a valid email address.' =>
            'Ovo je obavezno polje i mora da bude ispravna imejl adresa.',
        'This email address is not allowed due to the system configuration.' =>
            'Ova imejl adresa nije dozvoljena zbog sistemske konfiguracije.',
        'This email address failed MX check.' => 'Ova imejl adresa ne zadovoljava MX proveru.',
        'DNS problem, please check your configuration and the error log.' =>
            'DNS problem, molimo proverite konfiguraciju i greške u logu.',
        'The syntax of this email address is incorrect.' => 'Sintaksa ove imejl adrese je neispravna.',
        'This CustomerID is invalid.' => 'Ovaj ID klijenta je neispravan.',
        'Effective Permissions for Customer User' => 'Efektivne dozvole za klijent korisnika',
        'Group Permissions' => 'Dozvole za grupu',
        'This customer user has no group permissions.' => 'Ovaj klijent korisnik nema dozvole za grupe.',
        'Table above shows effective group permissions for the customer user. The matrix takes into account all inherited permissions (e.g. via customer groups). Note: The table does not consider changes made to this form without submitting it.' =>
            'Tabela iznad prikazuje efektivne dozvole za grupe klijent korisnika. Matrica uzima u obzir sve nasleđene dozvole (npr. putem klijent grupa). Napomena: tabela ne uzima u obzir izmene na ovoj formi bez slanja iste.',
        'Customer Access' => 'Pristup klijentu',
        'Customer' => 'Klijent',
        'This customer user has no customer access.' => 'Ovaj klijent korisnik nema pristup klijentu.',
        'Table above shows granted customer access for the customer user by permission context. The matrix takes into account all inherited access (e.g. via customer groups). Note: The table does not consider changes made to this form without submitting it.' =>
            'Tabela iznad prikazuje dodeljeni pristup klijentu za klijent korisnika prema kontekstu dozvole. Matrica uzima u obzir sav nasleđeni pristup (npr. putem klijent grupa). Napomena: tabela ne uzima u obzir izmene na ovoj formi bez slanja iste.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCustomerUserCustomer.tt
        'Manage Customer User-Customer Relations' => 'Upravljanje relacijama klijent korisnik-klijent',
        'Select the customer user:customer relations.' => 'Odaberite klijent korisnik:klijent relacije.',
        'Change Customer Relations for Customer User' => 'Promeni relacije sa klijentima za klijent korisnika',
        'Change Customer User Relations for Customer' => 'Promeni relacije sa klijent korisnicima za klijenta',
        'Toggle active state for all' => 'Promeni aktivno stanje za sve',
        'Active' => 'Aktivno',
        'Toggle active state for %s' => 'Promeni aktivno stanje za %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCustomerUserGroup.tt
        'Manage Customer User-Group Relations' => 'Upravljanje relacijama klijent korisnik-grupa',
        'Just use this feature if you want to define group permissions for customer users.' =>
            'Upotrebite ovu funkciju ako želite da definišete grupne dozvole za klijent korisnike.',
        'Edit Customer User Default Groups' => 'Uredi podrazumevane grupe za klijent korisnike',
        'These groups are automatically assigned to all customer users.' =>
            'Ove grupe su automatski dodeljene svim klijent korisnicima.',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' =>
            'Možete upravljati ovim grupama preko konfiguracionih podešavanja CustomerGroupAlwaysGroups.',
        'Filter for groups' => 'Filter za grupe',
        'Select the customer user - group permissions.' => 'Izaberi klijent korisnik:grupa dozvole.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer user).' =>
            'Ako ništa nije izabrano, onda nema dozvola u ovoj grupi (tiketi neće biti dostupni klijent korisniku).',
        'Customer User Default Groups:' => 'Podrazumevane grupe za klijent korisnika:',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminCustomerUserService.tt
        'Manage Customer User-Service Relations' => 'Upravljanje relacijama klijent korisnici-servisi',
        'Edit default services' => 'Uredi podrazumevane usluge',
        'Filter for Services' => 'Filter za servise',
        'Filter for services' => 'Filter za servise',
        'Services' => 'Usluge',
        'Service Level Agreements' => 'Sporazumi o nivou usluga',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicField.tt
        'Dynamic Fields Management' => 'Upravljanje dinamičkim poljima',
        'Add new field for object' => 'Dodaj novo polje objektu',
        'Filter for Dynamic Fields' => 'Filter za dinamička polja',
        'Filter for dynamic fields' => 'Filter za dinamička polja',
        'To add a new field, select the field type from one of the object\'s list, the object defines the boundary of the field and it can\'t be changed after the field creation.' =>
            'Za dodavanje novog polja izaberite tip polja iz jedne od lista objekata. Objekt definiše granice polja i posle kreiranja polja se ne može menjati.',
        'Import and export of configurations' => '',
        'Upload a file in YAML format (as provided by the export) to import dynamic field configurations.' =>
            '',
        'Overwrite existing configurations' => '',
        'Import configurations' => '',
        'Export configurations' => '',
        'Process Management' => 'Upravljanje procesima',
        'Dynamic fields ↔ Screens' => '',
        'Dynamic Fields List' => 'Lista dinamičkih polja',
        'Dynamic fields per page' => 'Broj dinamičkih polja po strani',
        'Label' => 'Oznaka',
        'Order' => 'Sortiranje',
        'Object' => 'Objekat',
        'Delete this field' => 'Obriši ovo polje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldCheckbox.tt
        'Dynamic Fields' => 'Dinamička polja',
        'Go back to overview' => 'Idi nazad na pregled',
        'General' => 'Opšte',
        'This field is required, and the value should be alphabetic and numeric characters only.' =>
            'Ovo polje je obavezno i može sadržati samo od slova i brojeve.',
        'Must be unique and only accept alphabetic and numeric characters.' =>
            'Mora biti jedinstveno i prihvata samo slova i brojeve.',
        'Changing this value will require manual changes in the system.' =>
            'Izmena ovog polja će zahtevati ručne promene u sistemu.',
        'This is the name to be shown on the screens where the field is active.' =>
            'Ovo je naziv koji će se prikazivati na ekranima gde je polje aktivno.',
        'Field order' => 'Redosled polja',
        'This field is required and must be numeric.' => 'Ovo polje je obavezno i mora biti numeričko.',
        'This is the order in which this field will be shown on the screens where is active.' =>
            'Ovo je redosled po kom će polja biti prikazana na ekranima gde su aktivna.',
        'Is not possible to invalidate this entry, all config settings have to be changed beforehand.' =>
            'Nije moguće obeležiti ovu stavku kao nevažeću, sva podešavanja moraju biti prvo izmenjena.',
        'Field type' => 'Tip polja',
        'Object type' => 'Tip objekta',
        'Internal field' => 'Interno polje',
        'This field is protected and can\'t be deleted.' => 'Ovo polje je zaštićeno i ne može biti obrisano.',
        'This dynamic field is used in the following config settings:' =>
            'Ovo dinamičko polje je upotrebljeno u sledećim postavkama:',
        'Field Settings' => 'Podešavanje polja',
        'Default value' => 'Podrazumevana vrednost',
        'This is the default value for this field.' => 'Ovo je podrazumevana vrednost za ovo polje.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldConfigurationImportExport.tt
        'Dynamic field configurations: %s' => '',
        'Select the dynamic fields you want to import and click on \'Import\'.' =>
            '',
        'Select the dynamic fields whose configuration you want to export and click on \'Export\' to generate a YAML file.' =>
            '',
        'Dynamic fields' => 'Dinamička polja',
        'For the following dynamic fields a configuration cannot be imported because of an invalid backend.' =>
            '',
        'Select all field configurations' => '',
        'Select all screen configurations' => '',
        'The uploaded file does not contain configuration(s), is not a YAML file, is damaged or has the wrong structure.' =>
            '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldDateTime.tt
        'Default date difference' => 'Podrazumevana razlika datuma',
        'This field must be numeric.' => 'Ovo polje mora biti numeričko.',
        'The difference from NOW (in seconds) to calculate the field default value (e.g. 3600 or -60).' =>
            'Razlika (u sekundama) od SADA, za izračunavanje podrazumevane vrednosti polja (npr. 3600 ili -60).',
        'Define years period' => 'Definiši period u godinama',
        'Activate this feature to define a fixed range of years (in the future and in the past) to be displayed on the year part of the field.' =>
            'Aktivirajte ovu opciju radi definisanja fiksnog opsega godina (u budućnost i prošlost) za prikaz pri izboru godina u polju.',
        'Years in the past' => 'Godine u prošlosti',
        'Years in the past to display (default: 5 years).' => 'Godine u prošlosti za prikaz (podrazumevano je 5 godina).',
        'Years in the future' => 'Godine u budućnosti',
        'Years in the future to display (default: 5 years).' => 'Godine u budućnosti za prikaz (podrazumevano je 5 godina).',
        'Show link' => 'Pokaži vezu',
        'Reserved keywords. The following placeholders are not allowed:' =>
            '',
        'Here you can specify an optional HTTP link for the field value in Overviews and Zoom screens.' =>
            'Ovde možete da unesete opcionu HTTP vezu za vrednost polja u ekranima pregleda.',
        'If special characters (&, @, :, /, etc.) should not be encoded, use \'url\' instead of \'uri\' filter.' =>
            'Ukoliko specijalni karakteri (&, @, :, /, itd) ne treba da budu enkodirani, koristite \'url\' filter umesto \'uri\'.',
        'Example' => 'Primer',
        'Link for preview' => 'Veza za pregled',
        'If filled in, this URL will be used for a preview which is shown when this link is hovered in ticket zoom. Please note that for this to work, the regular URL field above needs to be filled in, too.' =>
            'Ako je popunjeno, ovaj URL će se koristiti za pregled koji se prikazuje kada je pokazivač iznad veze u detaljima tiketa. Uzmite u obzir, da bi ovo radilo, normalno URL polje iznad, mora takođe da bude popunjeno.',
        'Restrict entering of dates' => 'Ograniči unos datuma',
        'Here you can restrict the entering of dates of tickets.' => 'Ovde možete ograničiti unos datuma za tikete.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldDropdown.tt
        'Possible values' => 'Moguće vrednosti',
        'Key' => 'Ključ',
        'Value' => 'Vrednost',
        'Remove value' => 'Ukloni vrednost',
        'Add value' => 'Dodaj vrednost',
        'Add Value' => 'Dodaj Vrednost',
        'Add empty value' => 'Dodaj bez vrednosti',
        'Activate this option to create an empty selectable value.' => 'Aktiviraj ovu opciju za kreiranje izbora bez vrednosti.',
        'Tree View' => 'Prikaz u obliku stabla',
        'Activate this option to display values as a tree.' => 'Aktiviraj ovu opciju za prikaz vrednosti u obliku stabla.',
        'Translatable values' => 'Prevodljive vrednosti',
        'If you activate this option the values will be translated to the user defined language.' =>
            'Ako aktivirate ovu opciju vrednosti će biti prevedene na izabrani jezik.',
        'Note' => 'Napomena',
        'You need to add the translations manually into the language translation files.' =>
            'Ove prevode morate ručno dodati u datoteke prevoda.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldScreenConfiguration.tt
        'Assignment of dynamic fields to screens' => '',
        'Overview' => 'Pregled',
        'Screens' => '',
        'Overview Default Columns' => '',
        'Add dynamic field' => 'Dodaj dinamičko polje',
        'Filter' => 'Filter',
        'You can assign elements by dragging and dropping them to the lists of available, disabled, assigned and required elements.' =>
            '',
        'Filter available elements' => '',
        'Assign selected elements to this list' => '',
        'Select all' => 'Izaberi sve',
        'Filter disabled elements' => '',
        'Filter assigned elements' => '',
        'Filter required elements' => '',
        'Reset' => 'Poništi',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldText.tt
        'Number of rows' => 'Broj redova',
        'Specify the height (in lines) for this field in the edit mode.' =>
            'Unesi visinu (u linijama) za ovo polje u modu obrade.',
        'Number of cols' => 'Broj kolona',
        'Specify the width (in characters) for this field in the edit mode.' =>
            'Unesi širinu (u znakovima) za ovo polje u modu uređivanja.',
        'Check RegEx' => 'Proveri regularne izraze',
        'Here you can specify a regular expression to check the value. The regex will be executed with the modifiers xms.' =>
            'Ovde možete da definišete regularni izraz za proveru vrednosti. Izraz će biti izvršen sa modifikatorima za xms.',
        'RegEx' => 'Regularni izraz',
        'Invalid RegEx' => 'Nevažeći regularni izraz',
        'Error Message' => 'Poruka o grešci',
        'Add RegEx' => 'Dodaj regularni izraz',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldWebservice.tt
        'Default search term' => '',
        'This is the default term for the click search.' => '',
        'Initial default search term' => '',
        'This is the default search term when the mask is loaded.' => '',
        'Attributes' => '',
        'Attributes for invoker execution (initially default values will be used).' =>
            '',
        'Attribute keys' => '',
        'Custom attribute form for invoker execution.' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldWebservice/Config.tt
        'Web service' => 'Veb servis',
        'Web service which will be used for this dynamic field.' => '',
        'Invoker to search for records' => '',
        'Invoker which will be used for this dynamic field. Searches for the search term(s) and returns an array as result. Note: The invoker needs to be enabled in the web service you specified above.' =>
            '',
        'Invoker to get a record' => '',
        'Invoker which will be used for this dynamic field. Returns a hash of the record that will be found when searching for its identifier in the field configured in \'key for stored value\' below. Note: The invoker needs to be enabled in the web service you specified above.' =>
            '',
        'Backend' => 'Modul',
        'Backend which will be used for this dynamic field.' => '',
        'Backend documentation' => '',
        'Key for search' => '',
        'The keys (separated by comma) that will be searched when using the autocomplete while entering a value for the dynamic field.' =>
            '',
        'Key for stored value' => '',
        'The key whose value will be stored in the dynamic field.' => '',
        'Key to display' => '',
        'The keys (separated by comma) that will be shown when the value of the dynamic field is being displayed. This also affects the value displayed in the autocomplete field when entering a value. If this field is left empty, the stored value from above will be displayed.' =>
            '',
        'Template Type' => '',
        'This configuration determines how the values of the dynamic field are output in templates or masks.' =>
            '',
        'Separator to display between multi-key values' => '',
        'The separator to show between the values if there\'s more than one key configured to be displayed above. If left empty, a single space will be used as separator. Use <space> to add spaces.' =>
            '',
        'Limit' => 'Ograničenje',
        'Maximum number of results for web service queries, e.g. for autocomplete selection list.' =>
            '',
        'Autocomplete min. input length' => '',
        'Minimum length of input for autocomplete field to trigger search.' =>
            '',
        'Query delay' => '',
        'Delay (in milliseconds) until the AJAX request will be sent.' =>
            '',
        'Autocompletion for search fields' => '',
        'Use autocompletion for search fields instead of a static selection of values that are currently selected in OTRS (in tickets, articles, etc.). This increases performance if many thousands of values of the dynamic field have been selected. This setting does not affect the search field displayed in AgentTicketSearch and CustomerTicketSearch.' =>
            '',
        'Input field width' => '',
        'Width of the input field (percentage).' => '',
        'Additional dynamic field storage' => '',
        'Dynamic field' => '',
        'Restore values' => '',
        'These dynamic fields are also filled with values from the same record.' =>
            '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldWebservice/Test.tt
        'Test settings' => '',
        'Error while testing configuration. Please check the configuration.' =>
            '',
        'Test was successful.' => '',
        'Test this dynamic field exactly as it is displayed in the editing dialogs.' =>
            '',
        'Enter a search term to test the current settings.' => '',
        'Click "Test settings"' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminDynamicFieldWebservice/TestData.tt
        'DisplayValue' => '',
        'StoredValue' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminEmail.tt
        'Admin Message' => 'Administrativna poruka',
        'With this module, administrators can send messages to agents, group or role members.' =>
            'Sa ovim modulom, administratori mogu slati poruke operaterima, grupama ili pripadnicima uloge.',
        'Create Administrative Message' => 'Kreiraj administrativnu poruku',
        'Your message was sent to' => 'Vaša poruka je poslata',
        'From' => 'Od',
        'Send message to users' => 'Pošalji poruku korisnicima',
        'Send message to group members' => 'Pošalji poruku članovima grupe',
        'Group members need to have permission' => 'Članovi grupe treba da imaju dozvolu',
        'Send message to role members' => 'Pošalji poruku pripadnicima uloge',
        'Also send to customers in groups' => 'Takođe pošalji klijentima u grupama',
        'Body' => 'Sadržaj',
        'Send' => 'Šalji',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericAgent.tt
        'Generic Agent Job Management' => 'Upravljanje poslovima generičkog operatera',
        'Edit Job' => 'Uredi posao',
        'Add Job' => 'Dodaj posao',
        'Run Job' => 'Pokreni posao',
        'Filter for Jobs' => 'Filter za poslove',
        'Filter for jobs' => 'Filter za poslove',
        'Last run' => 'Poslednje pokretanje',
        'Run Now!' => 'Pokreni sad!',
        'Delete this task' => 'Obriši ovaj posao',
        'Run this task' => 'Pokreni ovaj posao',
        'Job Settings' => 'Podešavanje posla',
        'Job name' => 'Naziv posla',
        'The name you entered already exists.' => 'Naziv koje ste uneli već postoji.',
        'Automatic Execution (Multiple Tickets)' => 'Automatsko izvršenje (višestruki tiketi)',
        'Execution Schedule' => 'Raspored izvršenja',
        'Schedule minutes' => 'Planirano minuta',
        'Schedule hours' => 'Planirano sati',
        'Schedule days' => 'Planirano dana',
        'Automatic execution values are in the system timezone.' => 'Vremena automatskog izvršavanja su u sistemskoj vremenskoj zoni.',
        'Currently this generic agent job will not run automatically.' =>
            'Trenutno ovaj posao generički operatera neće biti izvršen automatski.',
        'To enable automatic execution select at least one value from minutes, hours and days!' =>
            'Da biste omogućili automatsko izvršavanje izaberite bar jednu vrednost od minuta, sati i dana!',
        'Event Based Execution (Single Ticket)' => 'Izvršenje zasnovano na događaju (pojedinačni tiket)',
        'Event Triggers' => 'Okidači događaja',
        'List of all configured events' => 'Lista svih konfigurisanih događaja',
        'Delete this event' => 'Obriši ovaj događaj',
        'Additionally or alternatively to a periodic execution, you can define ticket events that will trigger this job.' =>
            'Dodatno ili alternativno za periodično izvršenje, možete definisati događaje tiketa koji će pokrenuti ovaj posao.',
        'If a ticket event is fired, the ticket filter will be applied to check if the ticket matches. Only then the job is run on that ticket.' =>
            'Ukoliko je događaj tiketa otkazao, biće primenjen tiket filter da potvrdi da li tiket odgovara. Samo tada će se posao na tiketu pokrenuti.',
        'Do you really want to delete this event trigger?' => 'Da li stvarno želite da obrišete ovaj okidač događaja?',
        'Add Event Trigger' => 'Dodaj okidač događaja',
        'To add a new event select the event object and event name' => 'Za dodavanje novog događaja izaberite objekat i naziv događaja',
        'Select Tickets' => 'Izaberi tikete',
        '(e. g. 10*5155 or 105658*)' => 'npr. 10*5144 ili 105658*',
        '(e. g. 234321)' => 'npr. 234321',
        'Customer user ID' => 'ID klijenta korisnika',
        '(e. g. U5150)' => '(npr. U5150)',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => 'Tekstualna pretraga u članku (npr. "Mar*in" ili "Baue*").',
        'To' => 'Za',
        'Cc' => 'Cc',
        'Service' => 'Usluga',
        'Service Level Agreement' => 'Sporazum o nivou usluge',
        'Queue' => 'Red',
        'State' => 'Stanje',
        'Agent' => 'Operater',
        'Owner' => 'Vlasnik',
        'Responsible' => 'Odgovoran',
        'Ticket lock' => 'Tiket zaključan',
        'Create times' => 'Vremena otvaranja',
        'No create time settings.' => 'Nema podešavanja vremena otvaranja.',
        'Ticket created' => 'Tiket otvoren',
        'Ticket created between' => 'Tiket otvoren između',
        'and' => 'i',
        'Last changed times' => 'Vreme zadnje promene',
        'No last changed time settings.' => 'Nije podešeno vreme poslednje promene.',
        'Ticket last changed' => 'Vreme zadnje promene tiketa',
        'Ticket last changed between' => 'Zadnja promena tiketa između',
        'Change times' => 'Promena vremena',
        'No change time settings.' => 'Nema promene vremena.',
        'Ticket changed' => 'Promenjen tiket',
        'Ticket changed between' => 'Tiket promenjen između',
        'Last close times' => '',
        'No last close time settings.' => '',
        'Ticket last close' => '',
        'Ticket last close between' => '',
        'Close times' => 'Vremena zatvaranja',
        'No close time settings.' => 'Nije podešeno vreme zatvaranja.',
        'Ticket closed' => 'Tiket zatvoren',
        'Ticket closed between' => 'Tiket zatvoren između',
        'Pending times' => 'Vremena čekanja',
        'No pending time settings.' => 'Nema podešavanja vremena čekanja.',
        'Ticket pending time reached' => 'Dostignuto vreme čekanja tiketa',
        'Ticket pending time reached between' => 'Vreme čekanja tiketa dostignuto između',
        'Escalation times' => 'Vremena eskalacije',
        'No escalation time settings.' => 'Nema podešavanja vremena eskalacije.',
        'Ticket escalation time reached' => 'Dostignuto vreme eskalacije tiketa',
        'Ticket escalation time reached between' => 'Vreme eskalacije tiketa dostignuto između',
        'Escalation - first response time' => 'Eskalacija - vreme prvog odziva',
        'Ticket first response time reached' => 'Dostignuto vreme prvog odziva na tiket',
        'Ticket first response time reached between' => 'Vreme prvog odziva na tiket dostignuto između',
        'Escalation - update time' => 'Eskalacija - vreme ažuriranja',
        'Ticket update time reached' => 'Dostignuto vreme ažuriranja tiketa',
        'Ticket update time reached between' => 'Vreme ažuriranja tiketa dostignuto između',
        'Escalation - solution time' => 'Eskalacija - vreme rešavanja',
        'Ticket solution time reached' => 'Dostignuto vreme rešavanja tiketa',
        'Ticket solution time reached between' => 'Vreme rešavanja tiketa dostignuto između',
        'Archive search option' => 'Opcije pretrage arhiva',
        'Update/Add Ticket Attributes' => 'Ažuriraj/Dodaj atribute tiketa',
        'Set new service' => 'Postavi nove usluge',
        'Set new Service Level Agreement' => 'Postavi novi Sporazum o nivou usluga',
        'Set new priority' => 'Postavi novi prioritet',
        'Set new queue' => 'Postavi novi red',
        'Set new state' => 'Postavi novo stanje',
        'Pending date' => 'Čekanje do',
        'Set new agent' => 'Postavi novog operatera',
        'new owner' => 'novi vlasnik',
        'new responsible' => 'novi odgovorni',
        'Set new ticket lock' => 'Postavi novo zaključavanje tiketa',
        'New customer user ID' => 'Novi ID klijent korisnika',
        'New customer ID' => 'Novi ID klijenta',
        'New title' => 'Novi naslov',
        'New type' => 'Novi tip',
        'Archive selected tickets' => 'Arhiviraj izabrane tikete',
        'Add Note' => 'Dodaj napomenu',
        'Visible for customer' => 'Vidljivo klijentu',
        'Time units' => 'Vremenske jedinice',
        'Execute Ticket Commands' => 'Izvrši komande tiketa',
        'Send agent/customer notifications on changes' => 'Pošalji obaveštenja operateru/klijentu pri promenama',
        'Delete tickets' => 'Obriši tikete',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' =>
            'UPOZORENJE: Svi obuhvaćeni tiketi će biti nepovratno uklonjeni iz baze!',
        'Execute Custom Module' => 'Pokreni izvršavanje posebnog modula',
        'Param %s key' => 'Ključ parametra %s',
        'Param %s value' => 'Vrednost parametra %s',
        'Results' => 'Rezultati',
        '%s Tickets affected! What do you want to do?' => '%s tiketa je obuhvaćeno. Šta želite da uradite?',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' =>
            'UPOZORENJE: Upotrebili ste opciju za brisanje. Svi obrisani tiketi će biti izgubljeni!',
        'Warning: There are %s tickets affected but only %s may be modified during one job execution!' =>
            'Upozorenje: Obuhvaćeno je %s tiketa ali samo %s može biti izmenjeno tokom jednog izvršavanja posla!',
        'Affected Tickets' => 'Obuhvaćeni tiketi',
        'Age' => 'Starost',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceDebugger.tt
        'GenericInterface Web Service Management' => 'Upravljanje oštim interfejsom veb servisa',
        'Web Service Management' => 'Upravljanje veb servisima',
        'Debugger' => 'Program za otklanjanje grešaka',
        'Go back to web service' => 'Idi nazad na veb servis',
        'Clear' => 'Očisti',
        'Do you really want to clear the debug log of this web service?' =>
            'Da li stvarno želite da očistite otklanjanje grešaka u logu ovog veb servisa?',
        'Request List' => 'Lista zahteva',
        'Time' => 'Vreme',
        'Communication ID' => 'ID komunikacije',
        'Remote IP' => 'Udaljena IP adresa',
        'Loading' => 'Učitavanje',
        'Select a single request to see its details.' => 'Izaberite jedan zahtev da bi videli njegove detalje.',
        'Filter by type' => 'Filter po tipu',
        'Filter from' => 'Filter od',
        'Filter to' => 'Filter do',
        'Filter by remote IP' => 'Filter po udaljenoj IP adresi',
        'Refresh' => 'Osvežavanje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceErrorHandlingDefault.tt
        'Add ErrorHandling' => 'Dodaj obradu greške',
        'Edit ErrorHandling' => 'Uredi obradu greške',
        'Do you really want to delete this error handling module?' => 'Da li stvarno želite da obrišete ovaj modul za obradu greške?',
        'All configuration data will be lost.' => 'Svi konfiguracioni podaci će biti izgubljeni.',
        'General options' => 'Opšta podešavanja',
        'The name can be used to distinguish different error handling configurations.' =>
            'Naziv se može koristiti za pravljenje razlike između pojedinačnih konfiguracija za obradu greške.',
        'Please provide a unique name for this web service.' => 'Molimo da obezbedite jedinstveni naziv za ovaj veb servis.',
        'Error handling module backend' => 'Modul za obradu greške',
        'This OTRS error handling backend module will be called internally to process the error handling mechanism.' =>
            'Ovaj modul za otklanjanje grešaka će biti pozvan interno da obradi grešku.',
        'Processing options' => 'Podešavanja obrade',
        'Configure filters to control error handling module execution.' =>
            'Konfigurišite filtere za kontrolu modula za obradu greške.',
        'Only requests matching all configured filters (if any) will trigger module execution.' =>
            'Samo zahtevi koji odgovaraju podešenim filterima (ukoliko ih ima) će rezultirati u pozivanju modula.',
        'Operation filter' => 'Filter operacije',
        'Only execute error handling module for selected operations.' => 'Izvrši modul za obradu greške samo za odgovarajuće operacije.',
        'Note: Operation is undetermined for errors occuring while receiving incoming request data. Filters involving this error stage should not use operation filter.' =>
            'Napomena: operacija za greške prilikom prijema zahteva nije definisana. Filteri za ovaj nivo obrade ne bi trebalo da koriste filter operacije.',
        'Invoker filter' => 'Filter pozivaoca',
        'Only execute error handling module for selected invokers.' => 'Izvrši modul za obradu greške samo za odgovarajuće pozivaoce.',
        'Error message content filter' => 'Filter sadržaja poruke o grešci',
        'Enter a regular expression to restrict which error messages should cause error handling module execution.' =>
            'Unesite regularni izraz za ograničenje koje poruke o grešci će rezultirati u pozivanju modula.',
        'Error message subject and data (as seen in the debugger error entry) will considered for a match.' =>
            'Naslov i sadržaj poruke o grešci (kako su prikazani u programu za otklanjanje grešaka) koji će biti smatrani kao zadovoljen uslov.',
        'Example: Enter \'^.*401 Unauthorized.*\$\' to handle only authentication related errors.' =>
            'Primer: unesite \'^.*401 Unauthorized.*\$\' za obradu samo grešaka u vezi autentikacije.',
        'Error stage filter' => 'Filter greške u odgovarućoj fazi',
        'Only execute error handling module on errors that occur during specific processing stages.' =>
            'Izvrši modul za obradu greške samo ukoliko se dogode tokom odgovarajuće faze u toku zahteva.',
        'Example: Handle only errors where mapping for outgoing data could not be applied.' =>
            'Primer: obradi samo greške kada nije moguće bilo mapirati odlazne podatke.',
        'Error code' => 'Kod greške',
        'An error identifier for this error handling module.' => 'Identifikator ovog modula za obradu grešaka.',
        'This identifier will be available in XSLT-Mapping and shown in debugger output.' =>
            'Ovaj identifikator će biti dostupan u XSLT mapiranju i prikazan u programu za otklanjanje grešaka.',
        'Error message' => 'Poruka o grešci',
        'An error explanation for this error handling module.' => 'Objašnjenje ovog modula za obradu grešaka.',
        'This message will be available in XSLT-Mapping and shown in debugger output.' =>
            'Ova poruka će biti dostupna u XSLT mapiranju i prikazana u programu za otklanjanje grešaka.',
        'Define if processing should be stopped after module was executed, skipping all remaining modules or only those of the same backend.' =>
            'Definiše da li procesiranje treba da bude zaustavljeno nakon što je modul izvršen, prilikom toka preskačući sve ostale module ili samo one istog tipa.',
        'Default behavior is to resume, processing the next module.' => 'Podrazumevano ponašanje je da se nastavi procesiranje sledećeg modula.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceErrorHandlingRequestRetry.tt
        'This module allows to configure scheduled retries for failed requests.' =>
            'Ovaj modul omogućava konfiguraciju planiranih ponovnih pokušaja za neuspele zahteve.',
        'Default behavior of GenericInterface web services is to send each request exactly once and not to reschedule after errors.' =>
            'Podrazumevano ponašanje veb servisa je da pošalje svaki zahtev samo jedanput i da ne planira ponovno izvršavanje u slučaju greške.',
        'If more than one module capable of scheduling a retry is executed for an individual request, the module executed last is authoritative and determines if a retry is scheduled.' =>
            'Ukoliko je više od jednog modula sposobno da ponovo izvrši pojedinačni zahtev, samo poslednji modul će biti uzet u obzir i odrediće da li će biti ponovnog pokušaja.',
        'Request retry options' => 'Podešavanja ponovnih pokušaja',
        'Retry options are applied when requests cause error handling module execution (based on processing options).' =>
            'Ponovni pokušaji će biti planirani kada se izvrši modul za obradu greške (na osnovu podešavanja istih).',
        'Schedule retry' => 'Ponovni pokušaj',
        'Should requests causing an error be triggered again at a later time?' =>
            'Da li zahtevi koji rezultuju u greškama treba da budu ponovo izvršeni?',
        'Initial retry interval' => 'Početni interval ponovnih pokušaja',
        'Interval after which to trigger the first retry.' => 'Vremenski interval nakon koga će biti izvršen prvi ponovni pokušaj.',
        'Note: This and all further retry intervals are based on the error handling module execution time for the initial request.' =>
            'Napomena: ovaj i svi naredni intervali ponovnih pokušaja su zasnovani na vremenu izvršavanja modula za obradu greške početnog zahteva.',
        'Factor for further retries' => 'Faktor intervala ponovnih pokušaja',
        'If a request returns an error even after a first retry, define if subsequent retries are triggered using the same interval or in increasing intervals.' =>
            'Ukoliko zahtev rezultira greškom i posle prvog ponovnog pokušaja, definiše da li su sledeći pokušaji izvršeni u istom ili uvećavajućem intervalu.',
        'Example: If a request is initially triggered at 10:00 with initial interval at \'1 minute\' and retry factor at \'2\', retries would be triggered at 10:01 (1 minute), 10:03 (2*1=2 minutes), 10:07 (2*2=4 minutes), 10:15 (2*4=8 minutes), ...' =>
            'Primer: ukoliko je zahtev pokrenut u 10:00 sa početnim intervalom od jednog minuta i faktorom intervala 2, ponovni pokušaji će biti izvršeni u 10:01 (1 minut), 10:03 (2*1=2 minuta), 10:07 (2*2=4 minuta), 10:15 (2*4=8 minuta), ...',
        'Maximum retry interval' => 'Maksimalni interval ponovnih pokušaja',
        'If a retry interval factor of \'1.5\' or \'2\' is selected, undesirably long intervals can be prevented by defining the largest interval allowed.' =>
            'Ukoliko je odabran faktor intervala ponovnih pokušaja od 1.5 ili 2, moguće je sprečiti isuviše duge intervale definisanjem maksimalno dozvoljenog intervala.',
        'Intervals calculated to exceed the maximum retry interval will then automatically be shortened accordingly.' =>
            'Interval koji prelazi maksimalno dozvoljeni interval će automatski biti skraćen.',
        'Example: If a request is initially triggered at 10:00 with initial interval at \'1 minute\', retry factor at \'2\' and maximum interval at \'5 minutes\', retries would be triggered at 10:01 (1 minute), 10:03 (2 minutes), 10:07 (4 minutes), 10:12 (8=>5 minutes), 10:17, ...' =>
            'Primer: ukoliko je zahtev pokrenut u 10:00 sa početnim intervalom od jednog minuta, faktorom intervala 2 i maksimalnim intervalom od 5 minuta, ponovni pokušaji će biti izvršeni u 10:01 (1 minut), 10:03 (2*1=2 minuta), 10:07 (2*2=4 minuta), 10:12 (8=> 5 minuta), 10:17, ...',
        'Maximum retry count' => 'Maksimalni broj ponovnih pokušaja',
        'Maximum number of retries before a failing request is discarded, not counting the initial request.' =>
            'Maksimalni dozvoljeni broj ponovnih pokušaja pre nego što je neuspeli zahtevo odbačen, ne računajući početni zahtev.',
        'Example: If a request is initially triggered at 10:00 with initial interval at \'1 minute\', retry factor at \'2\' and maximum retry count at \'2\', retries would be triggered at 10:01 and 10:02 only.' =>
            'Primer: ukoliko je zahtev pokrenut u 10:00 sa početnim intervalom od jednog minuta, faktorom intervala 2 i maksimalnim brojem ponovnih pokušaja 2, ponovni pokušaji će biti izvršeni samo u 10:01 i 10:03.',
        'Note: Maximum retry count might not be reached if a maximum retry period is configured as well and reached earlier.' =>
            'Napomena: maksimalni dozvoljenih broj ponovnih pokušaja ne mora biti dostignut ukoliko je podešen maksimalni period ponovnih pokušaja i dostignut ranije.',
        'This field must be empty or contain a positive number.' => 'Ovo polje mora da bude prazno ili pozitivan broj.',
        'Maximum retry period' => 'Maksimalni period ponovnih pokušaja',
        'Maximum period of time for retries of failing requests before they are discarded (based on the error handling module execution time for the initial request).' =>
            'Maksimalni dozvoljeni vremenski period ponovih pokušaja pre nego što je neuspeli zahtev odbačen (zasnovan na vremenu izvršavanja modula za obradu greške početnog zahteva).',
        'Retries that would normally be triggered after maximum period is elapsed (according to retry interval calculation) will automatically be triggered at maximum period exactly.' =>
            'Ponovni pokušaji koji bi standardno bili izvršeni posle maksimalnog vremenskog perioda (na osnovu izračunatog intervala) će automatski biti izvršeni tačno u maksimalnom periodu.',
        'Example: If a request is initially triggered at 10:00 with initial interval at \'1 minute\', retry factor at \'2\' and maximum retry period at \'30 minutes\', retries would be triggered at 10:01, 10:03, 10:07, 10:15 and finally at 10:31=>10:30.' =>
            'Primer: ukoliko je zahtev pokrenut u 10:00 sa početnim intervalom od jednog minuta, faktorom intervala 2 i maksimalnim periodom od 30 minuta, ponovni pokušaji će biti izvršeni u 10:01, 10:03, 10:07, 10:15 i konačno u 10:31=>10:30.',
        'Note: Maximum retry period might not be reached if a maximum retry count is configured as well and reached earlier.' =>
            'Napomena: maksimalni dozvoljeni period ne mora biti dostignut ukoliko je podešen maksimalni broj ponovnih pokušaja i dostignut ranije.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceInvokerDefault.tt
        'Add Invoker' => 'Dodaj pozivaoca',
        'Edit Invoker' => 'Uredi pozivaoca',
        'Do you really want to delete this invoker?' => 'Da li stvarno želite da izbrišete ovog pozivaoca?',
        'Invoker Details' => 'Detalji pozivaoca',
        'The name is typically used to call up an operation of a remote web service.' =>
            'Naziv se obično koristi za pokretanje operacije udaljenog veb servisa.',
        'Invoker backend' => 'Modul pozivaoca',
        'This OTRS invoker backend module will be called to prepare the data to be sent to the remote system, and to process its response data.' =>
            'Ovaj modul pozivaoca biće pozvan da pripremi podatke za slanje na udaljeni sistem i da obradi podatke njegovog odgovora.',
        'Mapping for outgoing request data' => 'Mapiranje za izlazne podatke zahteva',
        'Configure' => 'Podesi',
        'The data from the invoker of OTRS will be processed by this mapping, to transform it to the kind of data the remote system expects.' =>
            'Podaci iz OTRS pozivaoca biće obrađeni ovim mapiranjem, da bi ih transformisali u tipove podataka koje udaljeni sistem očekuje.',
        'Mapping for incoming response data' => 'Mapiranje za ulazne podatke odgovora',
        'The response data will be processed by this mapping, to transform it to the kind of data the invoker of OTRS expects.' =>
            'Podaci odgovora iz OTRS pozivaoca biće obrađeni ovim mapiranjem, da bi ih transformisali u tipove podataka koje udaljeni sistem očekuje..',
        'Asynchronous' => 'Asinhroni',
        'Condition' => 'Uslov',
        'Edit this event' => 'Uredi ovaj događaj',
        'This invoker will be triggered by the configured events.' => 'Ovaj pozivaoc će biti aktiviran preko podešenih događaja.',
        'Add Event' => 'Dodaj događaj',
        'To add a new event select the event object and event name and click on the "+" button' =>
            'Za dodavanje novog događaja izaberite objekat i naziv događaja pa kliknite na "+" dugme',
        'Asynchronous event triggers are handled by the OTRS Scheduler Daemon in background (recommended).' =>
            'Asinhronim okidačima događaja upravlja planer OTRS sistemskog servisa u pozadini (preporučeno).',
        'Synchronous event triggers would be processed directly during the web request.' =>
            'Sinhroni okidači događaja biće obrađeni direktno tokom veb zahteva.',
        'Add all attachments' => '',
        'Add all attachments to invoker payload.' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceInvokerEvent.tt
        'GenericInterface Invoker Event Settings for Web Service %s' => 'Podešavanja pozivaoca događaja u opštem interfejsu za veb servis %s',
        'Go back to' => 'Idi nazad na',
        'Delete all conditions' => 'Izbriši sve uslove',
        'Do you really want to delete all the conditions for this event?' =>
            'Da li stvarno želite da obrišete sve uslove ovog događaja?',
        'General Settings' => 'Opšta podešavanja',
        'Event type' => 'Tip događaja',
        'Conditions' => 'Uslovi',
        'Conditions can only operate on non-empty fields.' => 'Uslovi mogu da se primene samo sa polja koja nisu prazna.',
        'Type of Linking between Conditions' => 'Tip veze između uslova',
        'Remove this Condition' => 'Ukloni ovaj uslov',
        'Type of Linking' => 'Tip veze',
        'Fields' => 'Polja',
        'Add a new Field' => 'Dodaj novo polje',
        'Remove this Field' => 'Ukloni ovo polje',
        'And can\'t be repeated on the same condition.' => 'I se ne može ponoviti u istom uslovu.',
        'Add New Condition' => 'Dodaj novi uslov',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceMappingSimple.tt
        'Mapping Simple' => 'Jednostavno mapiranje',
        'Default rule for unmapped keys' => 'Podrazumevano pravilo za nemapirane ključeve',
        'This rule will apply for all keys with no mapping rule.' => 'Ovo pravilo će se primenjivati za sve ključeve bez pravila mapiranja.',
        'Default rule for unmapped values' => 'Podrazumevano pravilo za nemapirane vrednosti',
        'This rule will apply for all values with no mapping rule.' => 'Ovo pravilo će se primenjivati za sve vrednosti bez pravila mapiranja.',
        'New key map' => 'Novo mapiranje ključa',
        'Add key mapping' => 'Dodaj mapiranje ključa',
        'Mapping for Key ' => 'Mapiranje za ključ ',
        'Remove key mapping' => 'Ukloni mapiranje ključa',
        'Key mapping' => 'Mapiranje ključa',
        'Map key' => 'Mapiraj ključ',
        'matching the' => 'Podudaranje sa',
        'to new key' => 'na novi ključ',
        'Value mapping' => 'Vrednosno mapiranje',
        'Map value' => 'Mapiraj vrednost',
        'to new value' => 'na novu vrednost',
        'Remove value mapping' => 'Ukloni mapiranje vrednosti',
        'New value map' => 'Novo mapiranje vrednosti',
        'Add value mapping' => 'Dodaj mapiranu vrednost',
        'Do you really want to delete this key mapping?' => 'Da li stvarno želite da obrišete ovo mapiranje ključa?',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceMappingXSLT.tt
        'General Shortcuts' => 'Opšte prečice',
        'MacOS Shortcuts' => 'MacOS prečice',
        'Comment code' => 'Dodaj komentar koda',
        'Uncomment code' => 'Ukloni komentar koda',
        'Auto format code' => 'Formatiraj kod automatski',
        'Expand/Collapse code block' => 'Proširi/smanji blok koda',
        'Find' => 'Pronađi',
        'Find next' => 'Pronađi sledeće',
        'Find previous' => 'Pronađi prethodno',
        'Find and replace' => 'Pronađi i zameni',
        'Find and replace all' => 'Pronađi i zameni sve',
        'XSLT Mapping' => 'XSLT mapiranje',
        'XSLT stylesheet' => 'XSLT opis stilova',
        'The entered data is not a valid XSLT style sheet.' => 'Uneti podaci nisu ispravan XSLT opis stilova.',
        'Here you can add or modify your XSLT mapping code.' => 'Ovde može dodati i izmeniti kod XSLT mapiranja.',
        'The editing field allows you to use different functions like automatic formatting, window resize as well as tag- and bracket-completion.' =>
            'Polje za uređivanje vam omogućava da koristite funkcije kao što su automatsko formatiranje, promena veličine prozora i automatsko dopunjavanje komandi i zagrada.',
        'Data includes' => 'Podaci uključuju',
        'Select one or more sets of data that were created at earlier request/response stages to be included in mappable data.' =>
            'Odaberite jedan ili više skupova podataka koji su kreirani u ranijoj fazi zahteva/odgovora za uključivanje u podatke za mapiranje.',
        'These sets will appear in the data structure at \'/DataInclude/<DataSetName>\' (see debugger output of actual requests for details).' =>
            'Ovi skupovi će biti uključeni u strukturu na putanji \'/DataInclude/<DataSetName>\' (vidite program za otklanjanje grešaka za detalje).',
        'Force array for tags' => '',
        'Enter tags separated by space for which array representation should be forced.' =>
            '',
        'Keep XML attributes' => '',
        'Only needed for content type XML.' => '',
        'Data key regex filters (before mapping)' => 'Filteri regularnih izraza (pre mapiranja)',
        'Data key regex filters (after mapping)' => 'Filteri regularnih izraza (posle mapiranja)',
        'Regular expressions' => 'Regularni izrazi',
        'Replace' => 'Zameni',
        'Remove regex' => 'Ukloni regularni izraz',
        'Add regex' => 'Dodaj regularni izraz',
        'These filters can be used to transform keys using regular expressions.' =>
            'Ovi filteri se mogu koristi za transformaciju ključeva korišćenjem regularnih izraza.',
        'The data structure will be traversed recursively and all configured regexes will be applied to all keys.' =>
            'Struktura podataka će biti procesirana rekurzivno i svi podešeni regularni izrazi će biti primenjeni na sve ključeve.',
        'Use cases are e.g. removing key prefixes that are undesired or correcting keys that are invalid as XML element names.' =>
            'Primeri korišćenja su npr. uklanjanjen nepoželjnih prefiksa iz ključeva ili ispravljanje ključeva koji su neispravni kao XML nazivi.',
        'Example 1: Search = \'^jira:\' / Replace = \'\' turns \'jira:element\' into \'element\'.' =>
            'Primer 1: pronađi = \'^jira:\' / zameni = \'\' pretvara \'jira:element\' u \'element\'.',
        'Example 2: Search = \'^\' / Replace = \'_\' turns \'16x16\' into \'_16x16\'.' =>
            'Primer 2: pronađi = \'^\' / zameni = \'_\' pretvara \'16x16\' u \'_16x16\'.',
        'Example 3: Search = \'^(?<number>\d+) (?<text>.+?)\$\' / Replace = \'_\$+{text}_\$+{number}\' turns \'16 elementname\' into \'_elementname_16\'.' =>
            'Primer 3: Search = \'^(?\d+) (?.+?)\$\' / Replace = \'_\$+{text}_\$+{number}\' pretvara \'16 elementname\' u \'_elementname_16\'.',
        'For information about regular expressions in Perl please see here:' =>
            'Za informacije o Perl regularnim izrazima, molimo posetite:',
        'Perl regular expressions tutorial' => 'Priručnih Perl regularnih izraza',
        'If modifiers are desired they have to be specified within the regexes themselves.' =>
            'Ukoliko su vam neophodni modifikatori, moraćete da ih definišete u okviru samih regularnih izraza.',
        'Regular expressions defined here will be applied before the XSLT mapping.' =>
            'Regularni izrazi definisani ovde biće primenjeni pre XSLT mapiranja.',
        'Regular expressions defined here will be applied after the XSLT mapping.' =>
            'Regularni izrazi definisani ovde biće primenjeni posle XSLT mapiranja.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceOperationDefault.tt
        'Add Operation' => 'Dodaj operaciju',
        'Edit Operation' => 'Uredi operaciju',
        'Do you really want to delete this operation?' => 'Da li stvarno želite da obrišete ovu operaciju?',
        'Operation Details' => 'Detalji operacije',
        'The name is typically used to call up this web service operation from a remote system.' =>
            'Naziv se obično koristi za pozivanje operacije veb servisa iz udaljenog sistema.',
        'Operation backend' => 'Modul operacije',
        'This OTRS operation backend module will be called internally to process the request, generating data for the response.' =>
            'Ovaj modul operacije će biti interno pozvan da obradi zahtev, generisanjem podataka za odgovor.',
        'Mapping for incoming request data' => 'Mapiranje za dolazne podatke zahteva',
        'The request data will be processed by this mapping, to transform it to the kind of data OTRS expects.' =>
            'Podaci zahteva će biti obrađeni kroz mapiranje, radi transformacije u oblik koji OTRS očekuje.',
        'Mapping for outgoing response data' => 'Mapiranje za izlazne podatke odgovora',
        'The response data will be processed by this mapping, to transform it to the kind of data the remote system expects.' =>
            'Podaci odgovora će biti obrađeni kroz ovo mapiranje, radi transformacije u oblik koji udaljeni sistem očekuje.',
        'Include Ticket Data' => 'Uključi podatke tiketa',
        'Include ticket data in response.' => 'Uključi podatke tiketa u odgovoru.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceTransportHTTPREST.tt
        'Network Transport' => 'Mrežni transport',
        'Properties' => 'Svojstva',
        'Route mapping for Operation' => 'Mapiranje rute za operaciju',
        'Define the route that should get mapped to this operation. Variables marked by a \':\' will get mapped to the entered name and passed along with the others to the mapping. (e.g. /Ticket/:TicketID).' =>
            'Definiše rutu koja će biti mapirana na ovu operaciju. Promenljive obeležene sa \':\' će biti mapirane za uneti naziv i prosleđene sa ostalima (npr. /Ticket/:TicketID).',
        'Valid request methods for Operation' => 'Važeće metode zahteva za operaciju',
        'Limit this Operation to specific request methods. If no method is selected all requests will be accepted.' =>
            'Ograniči ovu opreaciju na pojedine metode zahteva. Ako ni jedna metoda nije izabrana svi zahtevi će biti prihvaćeni.',
        'Parser backend for operation' => '',
        'Defines the incoming data format.' => '',
        'Parser backend parameter' => '',
        'Please click \'Save\' to get the corresponding backend parameter if the parser backend was changed.' =>
            '',
        'Maximum message length' => 'Najveća dužina poruke',
        'This field should be an integer number.' => 'Ovo polje treba da bude ceo broj.',
        'Here you can specify the maximum size (in bytes) of REST messages that OTRS will process.' =>
            'Ovde možete uneti maksimalnu veličinu (u bajtima) REST poruka koje će OTRS da obradi.',
        'Send Keep-Alive' => 'Pošalji Keep-Alive',
        'This configuration defines if incoming connections should get closed or kept alive.' =>
            'Konfiguracija definiše da li dolazna konekcija treba da se zatvori i održava.',
        'Endpoint' => 'Krajnja tačka',
        'URI to indicate specific location for accessing a web service.' =>
            'URI za identifikaciju specifične lokacije za pristup servisu.',
        'e.g https://www.otrs.com:10745/api/v1.0 (without trailing backslash)' =>
            'npr. https://www.otrs.com:10745/api/v1.0 (bez kose crte na kraju)',
        'Disable SSL hostname certificate verification' => '',
        'Disables hostname certificate verification. This is not recommended and should only be used in test environments.' =>
            '',
        'Timeout' => 'Vremensko ograničenje',
        'Timeout value for requests.' => 'Vremensko ograničenje za zahteve.',
        'Authentication' => 'Autentifikacija',
        'An optional authentication mechanism to access the remote system.' =>
            'Opcioni mehanizam autentifikacije za pristup udaljenom sistemu.',
        'BasicAuth User' => 'BasicAuth korisnik',
        'The user name to be used to access the remote system.' => 'Korisničko ime koje će biti korišćeno za pristup udaljenom sistemu.',
        'BasicAuth Password' => 'BasicAuth lozinka',
        'The password for the privileged user.' => 'Lozinka za privilegovanog korisnika.',
        'JWT authentication: Key file' => '',
        'ATTENTION: Key file and/or password (if needed, see below) seem to be invalid.' =>
            '',
        'Path to private key file (PEM or DER). The key will be used to sign the JWT.' =>
            '',
        'JWT authentication: Key file password' => '',
        'ATTENTION: Password and/or key file (see above) seem to be invalid.' =>
            '',
        'JWT authentication: Certificate file' => '',
        'ATTENTION: Certificate file could not be parsed.' => '',
        'ATTENTION: Certificate is expired.' => '',
        'Path to X.509 certificate file (PEM). Data of the certificate can be used for the payload and/or header data of the JWT.' =>
            '',
        'JWT authentication: Algorithm' => '',
        'JWT authentication: TTL' => '',
        'TTL (time to live) in seconds for the JWT. This value will be used to calculate the expiration date which will be available in placeholders ExpirationDateTimestamp and ExpirationDateString.' =>
            '',
        'JWT authentication: Payload' => '',
        'Payload for JWT. Give key/value pairs (separated by ;), e.g.: Key1=Value1;Key2=Value2;Key3=Value3' =>
            '',
        'Available placeholders (prefixed with OTRS_JWT): ExpirationDateTimestamp, ExpirationDateString. Additionally if X.509 certificate support is present: CertSubject, CertIssuer, CertSerial, CertNotBefore, CertNotAfter, CertEmail, CertVersion.' =>
            '',
        'Placeholder usage example: Key1=<OTRS_JWT_ExpirationDateTimestamp>' =>
            '',
        'JWT authentication: Additional header data' => '',
        'Additional header data for JWT. Give key/value pairs (separated by ;), e.g.: Key1=Value1;Key2=Value2;Key3=Value3' =>
            '',
        'OAuth2 token configuration' => '',
        'Content type' => '',
        'The default content type added to HTTP header to use for POST and PUT requests.' =>
            '',
        'Use Proxy Options' => 'Koristi Proxy podešavanja',
        'Show or hide Proxy options to connect to the remote system.' => 'Prikaži ili sakrij Proxy opcije za povezivanje sa udaljenim sistemom.',
        'Proxy Server' => 'Proxy server',
        'URI of a proxy server to be used (if needed).' => 'URI od proxy servera da bude korišćen (ako je potrebno).',
        'e.g. http://proxy_hostname:8080' => 'npr. http://proxy_hostname:8080',
        'Proxy User' => 'Proxy korisnik',
        'The user name to be used to access the proxy server.' => 'Korisničko ime koje će se koristiti za pristup proxy serveru.',
        'Proxy Password' => 'Proxy lozinka',
        'The password for the proxy user.' => 'Lozinka za proxy korisnika.',
        'Skip Proxy' => 'Ignoriši Proxy',
        'Skip proxy servers that might be configured globally?' => 'Da li želite da ignorišete Proxy servere koji su možda podešeni globalno?',
        'Use SSL Options' => 'Koristi SSL opcije',
        'Show or hide SSL options to connect to the remote system.' => 'Prikaži ili sakrij SSL opcije za povezivanje sa udaljenim sistemom.',
        'Client Certificate' => 'Klijentski sertifikat',
        'The full path and name of the SSL client certificate file (must be in PEM, DER or PKCS#12 format).' =>
            'Cela putanja i naziv za datoteku SSL sertifikata (mora biti u PEM, DER ili PKCS#12 formatu).',
        'e.g. /opt/otrs/var/certificates/SOAP/certificate.pem' => 'npr. /opt/otrs/var/certificates/SOAP/certificate.pem',
        'Client Certificate Key' => 'Ključ klijentskog sertifikata',
        'The full path and name of the SSL client certificate key file (if not already included in certificate file).' =>
            'Cela putanja i naziv za datoteku ključa SSL sertifikata (ukoliko nije uključen u datoteku sertifikata).',
        'e.g. /opt/otrs/var/certificates/SOAP/key.pem' => 'npr. /opt/otrs/var/certificates/SOAP/key.pem',
        'Client Certificate Key Password' => 'Lozinka ključa klijentskog sertifikata',
        'The password to open the SSL certificate if the key is encrypted.' =>
            'Lozinka za otvaranje SSL sertifikata ukoliko je ključ šifrovan.',
        'Certification Authority (CA) Certificate' => 'Sertifikat sertifikacionog tela (CA)',
        'The full path and name of the certification authority certificate file that validates SSL certificate.' =>
            'Cela putanja i naziv sertifikacionog tela koje provera ispravnost SSL sertifikata.',
        'e.g. /opt/otrs/var/certificates/SOAP/CA/ca.pem' => 'npr. /opt/otrs/var/certificates/SOAP/CA/ca.pem',
        'Certification Authority (CA) Directory' => 'Direktorijum sertifikacionog tela (CA)',
        'The full path of the certification authority directory where the CA certificates are stored in the file system.' =>
            'Cela putanja direktorijuma sertifikacionog tela gde se skladište CA sertifikati u sistemu datoteka.',
        'e.g. /opt/otrs/var/certificates/SOAP/CA' => 'npr. /opt/otrs/var/certificates/SOAP/CA',
        'Controller mapping for Invoker' => 'Mapiranje kontrolera za pozivaoca',
        'The controller that the invoker should send requests to. Variables marked by a \':\' will get replaced by the data value and passed along with the request. (e.g. /Ticket/:TicketID?UserLogin=:UserLogin&Password=:Password).' =>
            'Kontroler kome će pozivalac prosleđivati zahteve. Promenljive obeležene sa \':\' će biti zamenjene njihovim vrednostima i prosleđene zajedno sa zahtevom (npr. /Ticket/:TicketID?UserLogin=:UserLogin&Password=:Password).',
        'Valid request command for Invoker' => 'Važeća komanda zahteva za pozivaoca',
        'A specific HTTP command to use for the requests with this Invoker (optional).' =>
            'Specifična HTTP komanda za primenu na zahteve sa ovim pozivaocem (neobavezno).',
        'Default command' => 'Podrazumevana komanda',
        'The default HTTP command to use for the requests.' => 'Podrazumevena HTTP komanda za zahteve.',
        'Additional response headers' => 'Dodatna zaglavlja u odgovorima',
        'Additional request headers' => '',
        'Add response header' => 'Dodaj zaglavlje u odgovoru',
        'Add request header' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceTransportHTTPSOAP.tt
        'e.g. https://local.otrs.com:8000/Webservice/Example' => 'npr. https://local.otrs.com:8000/Webservice/Example',
        'Set SOAPAction' => 'Definiši SOAPAction',
        'Set to "Yes" in order to send a filled SOAPAction header.' => 'Izaberi "Da" za slanje popunjenog SOAPAction zaglavlja.',
        'Set to "No" in order to send an empty SOAPAction header.' => 'Izaberi "Ne" za slanje praznog SOAPAction zaglavlja.',
        'Set to "Yes" in order to check the received SOAPAction header (if not empty).' =>
            'Izaberi "Da" za proveru primljenog SOAPAction zaglavlja (ukoliko nije prazno).',
        'Set to "No" in order to ignore the received SOAPAction header.' =>
            'Izaberi "Ne" za ignorisanje primljenog SOAPAction zaglavlja.',
        'SOAPAction scheme' => 'SOAPAction šema',
        'Select how SOAPAction should be constructed.' => 'Izaberite kako će biti konstruisan SOAPAction.',
        'Some web services require a specific construction.' => 'Pojedini veb servisi zahtevaju specifičnu konstrukciju.',
        'Some web services send a specific construction.' => 'Pojedini veb servisi šalju specifičnu konstrukciju.',
        'SOAPAction separator' => 'Separator SOAP akcije',
        'Character to use as separator between name space and SOAP operation.' =>
            'Znak koji će se koristiti kao separator između zaglavlja i SOAP metode.',
        'Usually .Net web services use "/" as separator.' => '.Net veb servisi obično koriste "/" kao separator.',
        'SOAPAction free text' => 'SOAPAction slobodan tekst',
        'Text to be used to as SOAPAction.' => 'Tekst koji će se koristiti kao SOAPAction.',
        'Namespace' => 'Vrsta zahteva',
        'URI to give SOAP methods a context, reducing ambiguities.' => 'URI koji daje kontekst SOAP metodama, smanjuje dvosmislenosti.',
        'e.g urn:otrs-com:soap:functions or http://www.otrs.com/GenericInterface/actions' =>
            'npr. urn:otrs-com:soap:functions ili http://www.otrs.com/GenericInterface/actions',
        'Omit namespace prefix' => '',
        'Omits the namespace prefix (e. g. namesp1:) in root tag of SOAP message.' =>
            '',
        'Request name scheme' => 'Zahtev za šemu naziva',
        'Select how SOAP request function wrapper should be constructed.' =>
            'Izaberite kako će biti konstruisan omotač funkcije SOAP zahteva.',
        '\'FunctionName\' is used as example for actual invoker/operation name.' =>
            '\'FunctionName\' se koristi kao primer za stvaran naziv pozivaoca/operacije.',
        '\'FreeText\' is used as example for actual configured value.' =>
            '\'FreeText\' se koristi kao primer za stvarnu podešenu vrednost.',
        'Request name free text' => 'Slobodan tekst naziva zahteva',
        'Text to be used to as function wrapper name suffix or replacement.' =>
            'Tekst koji će biti korišten kao nastavak naziva ili zamena omotača funkcije.',
        'Please consider XML element naming restrictions (e.g. don\'t use \'<\' and \'&\').' =>
            'Molimo da uzmete u obzir XML oganičenja imenovanja (npr. nemojte koristiti \'<\' i \'&\').',
        'Response name scheme' => 'Šema naziva odgovora',
        'Select how SOAP response function wrapper should be constructed.' =>
            'Izaberite kako će biti konstruisan omotač funkcije SOAP odgovora.',
        'Response name free text' => 'Slobodan tekst naziva odgovora',
        'Here you can specify the maximum size (in bytes) of SOAP messages that OTRS will process.' =>
            'Ovde možete uneti maksimalnu veličinu (u bajtima) SOAP poruka koje će OTRS da obradi.',
        'Fixed namespace prefix' => '',
        'Use a fixed namespace prefix (e. g. myns:) for the root tag of a SOAP message.' =>
            '',
        'Suffix for response tag' => '',
        'Usually OTRS expects a response tag like "&lt;Operation&gt;Response". This setting can change the "Response" part, e. g. to "Result".' =>
            '',
        'Encoding' => 'Kodni raspored',
        'The character encoding for the SOAP message contents.' => 'Kodni raspored znakova za sadržaj SOAP poruke.',
        'e.g utf-8, latin1, iso-8859-1, cp1250, Etc.' => 'npr. utf-8, latin1, iso-8859-1, cp1250, ...',
        'User' => 'Korisnik',
        'Password' => 'Lozinka',
        'Disable SSL hostname verification' => '',
        'Disables (setting "Yes") or enables (setting "No", default) the SSL hostname verification.' =>
            '',
        'Sort options' => 'Opcije sortiranja',
        'Add new first level element' => 'Dodaj novi element prvog nivoa',
        'Element' => 'Element',
        'Outbound sort order for xml fields (structure starting below function name wrapper) - see documentation for SOAP transport.' =>
            'Odlazni redosled sortiranja za XML polja (struktura ispod naziva omotača funkcije) - pogledajte dokumentaciju za SOAP transport.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceWebservice.tt
        'Add Web Service' => 'Dodaj veb servis',
        'Edit Web Service' => 'Uredi veb servis',
        'Clone Web Service' => 'Kloniraj veb servis',
        'The name must be unique.' => 'Naziv mora biti jedinstven.',
        'Clone' => 'Kloniraj',
        'Export Web Service' => 'Izvezi veb servis',
        'Import web service' => 'Uvezi veb servis',
        'Configuration File' => 'Konfiguraciona datoteka',
        'The file must be a valid web service configuration YAML file.' =>
            'Datoteka mora da bude važeća YAML konfiguraciona datoteka veb servisa.',
        'Here you can specify a name for the webservice. If this field is empty, the name of the configuration file is used as name.' =>
            'Ovde možete definisati naziv veb servisa. Ukoliko je ovo polje prazno, biće korišćen naziv konfiguracione datoteke.',
        'Import' => 'Uvezi',
        'Configuration History' => 'Istorijat konfiguracije',
        'Delete web service' => 'Obriši veb servis',
        'Do you really want to delete this web service?' => 'Da li stvarno želite da obrišete ovaj veb servis?',
        'Ready2Adopt Web Services' => 'Ready2Adopt veb servisi',
        'Import Ready2Adopt web service' => 'Uvezi Ready2Adopt veb servis',
        'After you save the configuration you will be redirected again to the edit screen.' =>
            'Nakon snimanja konfiguracije bićete ponovo preusmereni na prikaz ekrana za uređivanje.',
        'If you want to return to overview please click the "Go to overview" button.' =>
            'Ako želite da se vratite na pregled, molimo da kliknete na dugme \'Idi na pregled\'.',
        'Remote system' => 'Udaljeni sistem',
        'Provider transport' => 'Transport provajdera',
        'Requester transport' => 'Transport potražioca',
        'Debug threshold' => 'Prag uklanjanja grešaka',
        'In provider mode, OTRS offers web services which are used by remote systems.' =>
            'U režimu provajdera, OTRS nudi veb servise koji se koriste od strane udaljenih sistema.',
        'In requester mode, OTRS uses web services of remote systems.' =>
            'U režimu naručioca, OTRS koristi veb servise udaljenih sistema.',
        'Network transport' => 'Mrežni transport',
        'Error Handling Modules' => 'Moduli za obradu greške',
        'Error handling modules are used to react in case of errors during the communication. Those modules are executed in a specific order, which can be changed by drag and drop.' =>
            'Moduli za obradu greške se koriste za reakciju u slučuja grešaka u toku komunikacije. Ovi moduli se izvršavaju u odgovarajućem redosledu, koji može biti izmenjen prevlačenjem.',
        'Add error handling module' => 'Dodaj modul za obradu greške',
        'Operations are individual system functions which remote systems can request.' =>
            'Operacije su individualne sistemske funkcije koje udaljeni sistemi mogu da zahtevaju.',
        'Invokers prepare data for a request to a remote web service, and process its response data.' =>
            'Pozivaoci pripremaju podatke za zahtev na udaljenom web servisu i obrađuju podatke njegovih odgovora.',
        'Controller' => 'Kontroler',
        'Inbound mapping' => 'Ulazno mapiranje',
        'Outbound mapping' => 'Izlazno mapiranje',
        'Delete this action' => 'Obriši ovu akciju',
        'At least one %s has a controller that is either not active or not present, please check the controller registration or delete the %s' =>
            'Najmanje jedan %s ima kontroler koji ili nije aktivan ili nije prisutan, molimo proverite registraciju kontrolera ili izbrišite %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGenericInterfaceWebserviceHistory.tt
        'History' => 'Istorija',
        'Go back to Web Service' => 'Vratite se na veb servis',
        'Here you can view older versions of the current web service\'s configuration, export or even restore them.' =>
            'Ovde možete videti starije verzije konfiguracije aktuelnog veb servisa, eksportovati ih ili ih obnoviti.',
        'Configuration History List' => 'Lista - istorijat konfiguracije',
        'Version' => 'Verzija',
        'Create time' => 'Vreme kreiranja',
        'Select a single configuration version to see its details.' => 'Izaberi samo jednu konfiguracionu verziju za pregled njenih detalja.',
        'Export web service configuration' => 'Izvezi konfiguraciju veb servisa',
        'Restore web service configuration' => 'Obnovi konfiguraciju veb servisa',
        'Do you really want to restore this version of the web service configuration?' =>
            'Da li stvarno želite da vratite ovu verziju konfiguracije veb servisa?',
        'Your current web service configuration will be overwritten.' => 'Aktuelna konfiguracija veb servisa biće prepisana.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminGroup.tt
        'Group Management' => 'Upravljanje grupama',
        'Add Group' => 'Dodaj grupu',
        'Edit Group' => 'Uredi grupu',
        'The admin group is to get in the admin area and the stats group to get stats area.' =>
            '\'admin\' grupa služi za pristup administracionom prostoru, a \'stats\' grupa statistikama.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' =>
            'Napravi nove grupe za rukovanje pravima pristupa raznim grupama operatera (npr. odeljenje nabavke, tehnička podrška, prodaja, ...). ',
        'It\'s useful for ASP solutions. ' => 'Korisno za ASP rešenja. ',
        'Agents ↔ Groups' => 'Operateri ↔ grupe',
        'Roles ↔ Groups' => 'Uloge ↔ grupe',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminLog.tt
        'System Log' => 'Sistemski dnevnik',
        'Clear log entries' => '',
        'Here you will find log information about your system.' => 'Ovde ćete naći log informacije o vašem sistemu.',
        'Hide this message' => 'Sakrij ovu poruku',
        'Recent Log Entries' => 'Poslednji log unosi',
        'Facility' => 'Instalacija',
        'Message' => 'Poruka',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminMailAccount.tt
        'Mail Account Management' => 'Upravljanje imejl nalozima',
        'Add Mail Account' => 'Dodaj imejl nalog',
        'Edit Mail Account for host' => 'Uredi imejl nalog za server',
        'and user account' => 'i korisnički nalog',
        'Filter for Mail Accounts' => 'Filter za imejl naloge',
        'Filter for mail accounts' => 'Filter za imejl naloge',
        'All incoming emails with one account will be dispatched in the selected queue.' =>
            'Sve dolazne poruke sa jednog imejl naloga će biti usmerene u izabrani red.',
        'If your account is marked as trusted, the X-OTRS headers already existing at arrival time (for priority etc.) will be kept and used, for example in PostMaster filters.' =>
            'Ako je vaš nalog od poverenja, postojeća X-OTRS zaglavlja u trenutku prijema (za prioritet, itd.) će biti sačuvana korišćena, npr. u PostMaster filterima.',
        'Outgoing email can be configured via the Sendmail* settings in %s.' =>
            'Podešavanja odlazećih imejl poruka mogu biti konfigurisana putem Sendmail* opcija u %s.',
        'System Configuration' => 'Konfiguracija sistema',
        'Host' => 'Domaćin',
        'Authentication type' => '',
        'Delete account' => 'Obriši nalog',
        'Fetch mail' => 'Preuzmi poštu',
        'Do you really want to delete this mail account?' => 'Da li stvarno želite da obrišete ovaj imejl nalog?',
        'Example: mail.example.com' => 'Primer: mail.example.com',
        'IMAP Folder' => 'IMAP folder',
        'Only modify this if you need to fetch mail from a different folder than INBOX.' =>
            'Ovo izmenite samo ako je potrebno primiti poštu iz drugog foldera, a ne iz INBOX-a.',
        'Trusted' => 'Od poverenja',
        'Dispatching' => 'Otprema',
        'Edit Mail Account' => 'Uredi imejl nalog',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminNavigationBar.tt
        'Administration Overview' => 'Administrativni pregled',
        'Filter for Items' => 'Filter za stavke',
        'Favorites' => 'Omiljene',
        'You can add favorites by moving your cursor over items on the right side and clicking the star icon.' =>
            'Možete dodati omiljene prevlačenjem kursora preko stavke sa desne strane i klikom na ikonicu zvezde.',
        'Links' => 'Veze',
        'View the admin manual on Github' => 'Pregledajte uputstvo za administratore na Github',
        'No Matches' => 'Ništa nije pronađeno',
        'Sorry, your search didn\'t match any items.' => 'Žao nam je, vaša pretraga nije vratila rezultate.',
        'Set as favorite' => 'Stavi u omiljene',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminNotificationEvent.tt
        'Ticket Notification Management' => 'Upravljanje obaveštenjima o tiketima',
        'Here you can upload a configuration file to import Ticket Notifications to your system. The file needs to be in .yml format as exported by the Ticket Notification module.' =>
            'Ovde možete poslati konfiguracionu datoteku za uvoz obaveštenja o tiketu u vaš sistem. Datoteka mora biti u .yml formatu ako se izvozi od strane modula za obaveštenja o tiketu.',
        'Here you can choose which events will trigger this notification. An additional ticket filter can be applied below to only send for ticket with certain criteria.' =>
            'Ovde možete izabrati koji događaji će pokrenuti obaveštavanje. Dodatni filter za tikete može biti primenjen radi slanja samo za tikete po određenom kriterijumu.',
        'Ticket Filter' => 'Filter tiketa',
        'Lock' => 'Zaključaj',
        'SLA' => 'SLA',
        'Customer User ID' => 'ID klijenta korisnika',
        'Article Filter' => 'Filter članka',
        'Only for ArticleCreate and ArticleSend event' => 'Samo za događaj kreiranje članka i slanje članka',
        'Article sender type' => 'Tip pošiljaoca članka',
        'If ArticleCreate or ArticleSend is used as a trigger event, you need to specify an article filter as well. Please select at least one of the article filter fields.' =>
            'Ako se koriste događaji kreiranje članka i slanje članka, neophodno je definisati filter članka. Molim vas selektujte bar jedno polje za filter članka.',
        'Customer visibility' => 'Vidljivo klijentima',
        'Communication channel' => 'Komunikacioni kanal',
        'Include attachments to notification' => 'Uključi priloge uz obavštenje',
        'Notify user just once per day about a single ticket using a selected transport.' =>
            'Obaveti korisnika samo jednom dnevno o pojedinom tiketu korišćenjem izabranog transporta.',
        'This field is required and must have less than 4000 characters.' =>
            'Ovo polje je obavezno i ne sme biti duže od 4000 karaktera.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminNotificationEventTransportEmailSettings.tt
        'Use comma or semicolon to separate email addresses.' => 'Koristite zarez ili tačku-zarez za odvajanje imejl adresa.',
        'You can use OTRS-tags like <OTRS_TICKET_DynamicField_...> to insert values from the current ticket.' =>
            'Možete koristiti OTRS tagove kao <OTRS_TICKET_DynamicField_...> za umetanje vrednosti iz trenutnog tiketa.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminNotificationEventTransportWebserviceSettings.tt
        'Web service name' => '',
        'Invoker' => '',
        'Asynchronous event triggers will be handled as separate process by the scheduler daemon (recommended).' =>
            '',
        'Synchronous event triggers will be processed directly during the web request.' =>
            '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminOAuth2TokenManagement/Edit.tt
        'Queue Management' => 'Upravljanje redovima',
        'Manage OAuth2 tokens and their configurations' => '',
        'Add by template' => '',
        'Base configuration' => '',
        'An OAuth2 token configuration with this name already exists.' =>
            '',
        'Client ID' => '',
        'Client secret' => '',
        'URL for authorization code' => '',
        'URL for token by authorization code' => '',
        'URL for token by refresh token' => '',
        'Access token scope' => '',
        'Template' => 'Šablon',
        'This is the template that was used to create this OAuth2 token configuration.' =>
            '',
        'Notifications' => 'Obaveštenja',
        'Expired token' => '',
        'Shows a notification for admins below the top menu if the OAuth2 token has expired.' =>
            '',
        'Expired refresh token' => '',
        'Shows a notification for admins below the top menu if the OAuth2 refresh token has expired.' =>
            '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminOAuth2TokenManagement/Overview.tt
        'Add OAuth2 token configuration' => '',
        'Add a new OAuth2 token configuration based on the selected template.' =>
            '',
        'Import and export' => '',
        'Upload a YAML file to import token configurations. See documentation on OAuth2 token management for further details.' =>
            '',
        'Overwrite existing token configurations' => '',
        'Import token configurations' => '',
        'Export token configurations' => '',
        'OAuth2 token configurations' => '',
        'Token status' => '',
        'Refresh token status' => '',
        'Validity of token configuration' => '',
        'Last token request failed.' => '',
        'Token has expired on %s.' => '',
        'Token is valid until %s.' => '',
        'No token was requested yet.' => '',
        'Last (refresh) token request failed.' => '',
        'Refresh token has expired on %s.' => '',
        'Refresh token has expired.' => '',
        'Refresh token is valid until %s.' => '',
        'Refresh token is valid (without expiration date).' => '',
        'No refresh token was requested yet.' => '',
        'Refresh token request is not configured.' => '',
        'Request new token' => '',
        'Delete this token and its configuration.' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminOTRSBusinessInstalled.tt
        'Manage %s' => 'Upravljaj sa %s',
        'Downgrade to ((OTRS)) Community Edition' => 'Povratak na besplatno izdanje ((OTRS))',
        'Read documentation' => 'Pročitaj dokumentaciju',
        '%s makes contact regularly with cloud.otrs.com to check on available updates and the validity of the underlying contract.' =>
            '%s redovno se povezuje sa cloud.otrs.com za proveru dostupnih ažuriranja i ispravnosti internih ugovora.',
        'Unauthorized Usage Detected' => 'Detektovana neovlaštena upotreba',
        'This system uses the %s without a proper license! Please make contact with %s to renew or activate your contract!' =>
            'Ovaj sistem koristi %s bez adekvatne licence! Molimo da kontaktirate %s za obnovu ili aktivaciju vašeg ugovora!',
        '%s not Correctly Installed' => '%s nije korektno instalirana',
        'Your %s is not correctly installed. Please reinstall it with the button below.' =>
            'Vaš %s nije korektno instaliran. Molimo da reinstalirate putem dugmeta ispod.',
        'Reinstall %s' => 'Reinstaliraj %s',
        'Your %s is not correctly installed, and there is also an update available.' =>
            'Vaš %s nije korektno instaliran, a i ažuriranje je dostupno.',
        'You can either reinstall your current version or perform an update with the buttons below (update recommended).' =>
            'Možete reinstalirati aktuelnu verziju ili izvršiti ažuriranje putem dugmeta ispod (preporučuje se ažuriranje).',
        'Update %s' => 'Ažuriraj %s',
        '%s Not Yet Available' => '%s nije još dostupan',
        '%s will be available soon.' => '%s će biti uskoro dostupno.',
        '%s Update Available' => '%s dostupno ažuriranje',
        'An update for your %s is available! Please update at your earliest!' =>
            'Ažuriranje za vaš %s je dostupno! Molimo vas da ažurirate što pre!',
        '%s Correctly Deployed' => '%s korektno raspoređeno',
        'Congratulations, your %s is correctly installed and up to date!' =>
            'Čestitamo, vaš %s je korektno instaliran i ažuran!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminOTRSBusinessNotInstalled.tt
        'Upgrade to %s' => 'Unapredi na %s',
        'Go to the OTRS customer portal' => 'Idi na OTRS korisnički portal',
        '%s will be available soon. Please check again in a few days.' =>
            '%s će biti dostupna uskoro. Molimo, proverite ponovo za nekoliko dana.',
        'Please have a look at %s for more information.' => 'Molimo da pogledate %s za više informacija.',
        'Your ((OTRS)) Community Edition is the base for all future actions. Please register first before you continue with the upgrade process of %s!' =>
            'Vaše besplatno izdanje ((OTRS)) je osnova za sve buduće aktivnosti. Molimo vas da se registrujete pre nego što nastavite sa procesom ažuriranja na %s!',
        'Before you can benefit from %s, please contact %s to get your %s contract.' =>
            'Pre nego vam %s bude koristan, molimo da kontaktirate %s da biste dobili %s ugovor.',
        'Connection to cloud.otrs.com via HTTPS couldn\'t be established. Please make sure that your OTRS can connect to cloud.otrs.com via port 443.' =>
            'Konekcija prema cloud.otrs.com preko HTTPS nije mogla biti uspostavljena. Molimo osigurajte da vaš OTRS može da se poveže sa cloud.otrs.com preko porta 443.',
        'Package installation requires patch level update of OTRS.' => 'Instalacija paketa zahteva ažuriranu verziju OTRS.',
        'Please visit our customer portal and file a request.' => 'Molimo posetite naš korisnički portal i podnesite zahtev.',
        'Everything else will be done as part of your contract.' => 'Sve ostalo će biti urađeno pod vašim postojećim ugovorom.',
        'Your installed OTRS version is %s.' => 'Instalirana OTRS verzija kod vas je %s.',
        'To install this package, you need to update to OTRS %s or higher.' =>
            '',
        'To install this package, the Maximum OTRS Version is %s.' => 'Za instalaciju ovog paketa, najviša podržana verzija OTRS je %s.',
        'To install this package, the required Framework version is %s.' =>
            'Za instalaciju ovog paketa neophodna verzija OTRS je %s.',
        'Why should I keep OTRS up to date?' => '',
        'You will receive updates about relevant security issues.' => 'Dobićete ažuriranja odgovarajućih bezbednosnih izdanja.',
        'You will receive updates for all other relevant OTRS issues' => 'Dobićete ažuriranja svih relevantnih OTRS izdanja',
        'With your existing contract you can only use a small part of the %s.' =>
            'Sa vašim sadašnjim ugovorom možete koristiti samo mali deo od %s.',
        'If you would like to take full advantage of the %s get your contract upgraded now! Contact %s.' =>
            'Ako želite da iskoristite sve prednosti %s potrebno je da ažurirate vaš ugovor! Kontaktirajte %s.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminOTRSBusinessUninstall.tt
        'Cancel downgrade and go back' => 'Poništi povratak na staru verziju i vrati se nazad',
        'Go to Package Manager' => '',
        'Sorry, but currently you can\'t downgrade due to the following packages which depend on %s:' =>
            'Nažalost, trenutno ne možete da se vratite na staru verziju zbog sledećih paketa koji zavise od %s:',
        'Vendor' => 'Prodavac',
        'Please uninstall the packages first using the package manager and try again.' =>
            'Molimo vas da prvo deinstalirate pakete kroz upravljač paketima pa da pokušate ponovo.',
        'You are about to downgrade to ((OTRS)) Community Edition and will lose the following features and all data related to these:' =>
            'Vraćanjem na besplatno izdanje ((OTRS)) izgubićete sledeća svojstva i podatke povezane sa:',
        'Chat' => 'Ćaskanje',
        'Report Generator' => 'Generator izveštaja',
        'Timeline view in ticket zoom' => 'Detaljni prikaz tiketa na vremenskoj liniji',
        'DynamicField ContactWithData' => 'Dinamičko polje "Kontakt sa podacima"',
        'DynamicField Database' => 'Baza podataka dinamičkih polja',
        'SLA Selection Dialog' => 'Dijalog izbora SLA',
        'Ticket Attachment View' => 'Pregled priloga uz tiket',
        'The %s skin' => 'Izgled %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminPGP.tt
        'PGP Management' => 'Upravljanje PGP ključevima',
        'Add PGP Key' => 'Dodaj PGP ključ',
        'PGP support is disabled' => 'PGP podrška je onemogućena',
        'To be able to use PGP in OTRS, you have to enable it first.' => 'Da bi mogli da koristite PGP u OTRS, morate ga prvo omogućiti.',
        'Enable PGP support' => 'Omogući PGP podršku',
        'Faulty PGP configuration' => 'Neispravna PGP konfiguracija',
        'PGP support is enabled, but the relevant configuration contains errors. Please check the configuration using the button below.' =>
            'PGP podrška ja omogućena ali relevantna konfiguracija sadrži greške. Molimo da proverite konfiguraciju pritiskom na dugme ispod.',
        'Configure it here!' => 'Podesite to ovde!',
        'Check PGP configuration' => 'Proveri PGP konfiguraciju',
        'In this way you can directly edit the keyring configured in SysConfig.' =>
            'Na ovaj način možete direktno uređivati komplet ključeva podešen u SysConfig (sistemskim konfiguracijama).',
        'Introduction to PGP' => 'Uvod u PGP',
        'Identifier' => 'Identifikator',
        'Bit' => 'Bit',
        'Fingerprint' => 'Otisak',
        'Expires' => 'Ističe',
        'Delete this key' => 'Obriši ovaj ključ',
        'PGP key' => 'PGP ključ',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminPackageManager.tt
        'Package Manager' => 'Upravljanje paketima',
        'Uninstall Package' => 'Deinstaliraj paket',
        'Uninstall package' => 'Deinstaliraj paket',
        'Do you really want to uninstall this package?' => 'Da li stvarno želite da deinstalirate ovaj paket?',
        'Reinstall package' => 'Instaliraj ponovo paket',
        'Do you really want to reinstall this package? Any manual changes will be lost.' =>
            'Da li stvarno želite da ponovo instalirate ovaj paket? Sve ručne promene će biti izgubljene.',
        'Go to updating instructions' => 'Idi na uputstvo za ažuriranje',
        'Go to znuny.org' => '',
        'package information' => 'Informacije o paketu',
        'Package installation requires a patch level update of Znuny.' =>
            'Instalacija paketa zahteva ažuriranu verziju OTRS.',
        'Package update requires a patch level update of Znuny.' => 'Ažuriranje paketa zahteva ažuriranu verziju OTRS.',
        'Please note that your installed Znuny version is %s.' => 'Trenutno instalirana Znuny verzija je %s.',
        'To install this package, you need to update Znuny to version %s or newer.' =>
            'Da biste instalirali ovaj paket, neophodno je da ažurirate vaš Znuny na verziju %s ili noviju.',
        'This package can only be installed on Znuny version %s or older.' =>
            'Ovaj paket se može instalirati samo na Znuny verziju%s ili stariju.',
        'This package can only be installed on Znuny version %s.' => '',
        'Why should I keep Znuny up to date?' => 'Zašto bi trebalo da Znuny uvek bude ažuriran?',
        'You will receive updates for all other relevant Znuny issues.' =>
            'Dobićete ažuriranja svih drugih relevantnih Znuny izdanja.',
        'How can I do a patch level update if I don’t have a contract?' =>
            'Kako mogu da ažuriram verziju OTRS ukoliko nemam ugovor?',
        'Please find all relevant information within the updating instructions at %s.' =>
            'Molimo pronađite sve relevantne informacije u okviru instrukcija za ažuriranje na %s.',
        'In case you would have further questions we would be glad to answer them.' =>
            'U slučaju da imate dodtana pitanja, biće nam zadovoljstvo da odgovorimo na njih.',
        'Install Package' => 'Instaliraj paket',
        'Update Package' => 'Ažuriraj paket',
        'Package' => '',
        'Required package %s is already installed.' => '',
        'Required Perl module %s is already installed.' => '',
        'Required package %s needs to get installed!' => '',
        'Required package %s needs to get updated to version %s!' => '',
        'Required Perl module %s needs to get installed or updated!' => '',
        'Continue' => 'Nastavi',
        'Please make sure your database accepts packages over %s MB in size (it currently only accepts packages up to %s MB). Please adapt the max_allowed_packet setting of your database in order to avoid errors.' =>
            'Molimo vas da budete sigurni da vaša baza podataka prihvata pakete veličine preko %s MB (trenutno prihvata samo pakete do %s MB). Molimo vas da prilagodite podešavanja \'max_allowed_packet\' na vašoj bazi podataka, da bi ste izbegli greške.',
        'Install' => 'Instaliraj',
        'Update repository information' => 'Ažuriraj informacije o spremištu',
        'Update all installed packages' => 'Ažuriraj sve instalirane pakete',
        'Online Repository' => 'Mrežno spremište',
        'Action' => 'Akcija',
        'Module documentation' => 'Dokumentacija modula',
        'Local Repository' => 'Lokalno spremište',
        'Uninstall' => 'Deinstaliraj',
        'Package not correctly deployed! Please reinstall the package.' =>
            'Paket nije korektno instaliran! Instalirajte ga ponovo.',
        'Reinstall' => 'Instaliraj ponovo',
        'Package Information' => 'Informacije o paketu',
        'Download package' => 'Preuzmi paket',
        'Rebuild package' => 'Obnovi paket(rebuild)',
        'Metadata' => 'Meta podaci',
        'Change Log' => 'Promeni log',
        'Date' => 'Datum',
        'List of Files' => 'Spisak datoteka',
        'Permission' => 'Dozvola',
        'Download file from package!' => 'Preuzmi datoteku iz paketa!',
        'Required' => 'Obavezno',
        'Size' => 'Veličina',
        'Primary Key' => 'Primarni ključ',
        'Auto Increment' => 'Auto uvećanje',
        'SQL' => 'SQL',
        'File Differences for File %s' => 'Razlike za datoteku %s',
        'File differences for file %s' => 'Razlike za datoteku %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminPerformanceLog.tt
        'Performance Log' => 'Performansa log-a',
        'Range' => 'Opseg',
        'last' => 'poslednje',
        'This feature is enabled!' => 'Ova funkcija je aktivna!',
        'Just use this feature if you want to log each request.' => 'Aktivirati ovu mogućnost samo ako želite da zabeležite svaki zahtev.',
        'Activating this feature might affect your system performance!' =>
            'Aktiviranje ove funkcije može uticati na performanse sistema!',
        'Disable it here!' => 'Isključite je ovde!',
        'Logfile too large!' => 'Log datoteka je prevelika!',
        'The logfile is too large, you need to reset it' => 'Log datoteka je prevelika, treba da je resetujete',
        'Interface' => 'Interfejs',
        'Requests' => 'Zahtevi',
        'Min Response' => 'Min odziv',
        'Max Response' => 'Maks odziv',
        'Average Response' => 'Prosečan odziv',
        'Period' => 'Period',
        'minutes' => 'minuti',
        'Min' => 'Min',
        'Max' => 'Maks',
        'Average' => 'Prosek',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminPostMasterFilter.tt
        'PostMaster Filter Management' => 'Upravljanje PostMaster filterima',
        'Add PostMaster Filter' => 'Dodaj PostMaster filter',
        'Edit PostMaster Filter' => 'Uredi PostMaster filter',
        'Filter for PostMaster Filters' => 'Filter za PostMaster filtere',
        'Filter for PostMaster filters' => 'Filter za PostMaster filtere',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' =>
            'Radi otpreme ili filtriranja dolaznih imejlova na osnovu zaglavlja. Poklapanje pomoću regularnih izraza je takođe moguće.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' =>
            'Ukoliko želite poklapanje samo sa imejl adresom, koristite EMAILADDRESS:info@example.com u From, To ili Cc.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' =>
            'Ukoliko koristite regularne izraze, takođe možete koristiti i upateru vrednost u () kao (***) u \'Set\' action.',
        'You can also use named captures %s and use the names in the \'Set\' action %s (e.g. Regexp: %s, Set action: %s). A matched EMAILADDRESS has the name \'%s\'.' =>
            'Možete koristiti i imenovane skupove %s i referencirati nazive u polju \'na vrednost\' %s (npr. regularni izraz: %s, na vrednost: %s). Prepoznate imejl adrese imaju naziv \'%s\'.',
        'Delete this filter' => 'Obriši ovaj filter',
        'Do you really want to delete this postmaster filter?' => 'Da li stvarno želite da obrišete ovaj postmaster filter?',
        'A postmaster filter with this name already exists!' => 'PostMaster filter sa ovim nazivom već postoji!',
        'Filter Condition' => 'Uslov filtriranja',
        'AND Condition' => 'AND uslov',
        'Search header field' => 'Pretraži zaglavlje imejla',
        'for value' => 'za vrednost',
        'The field needs to be a valid regular expression or a literal word.' =>
            'Ovo polje treba da bude važeći regularni izraz ili doslovno reč.',
        'Negate' => 'Negirati',
        'Set Email Headers' => 'Podesi zaglavlja imejla',
        'Set email header' => 'Podesi zaglavlje imejla',
        'with value' => 'na vrednost',
        'The field needs to be a literal word.' => 'Ovo polje treba da bude doslovno reč.',
        'Header' => 'Zaglavlje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminPriority.tt
        'Priority Management' => 'Upravljanje prioritetima',
        'Add Priority' => 'Dodaj Prioritet',
        'Edit Priority' => 'Uredi Prioritet',
        'Filter for Priorities' => 'Filter za prioritete',
        'Filter for priorities' => 'Filter za prioritete',
        'Configure Priority Visibility and Defaults' => '',
        'This priority is present in a SysConfig setting, confirmation for updating settings to point to the new priority is needed!' =>
            'Ovaj prioritet se koristi u sistemskoj konfiguraciji, neophodna je dodatna potvrda za promenu podešavanja na novu vrednost!',
        'This priority is used in the following config settings:' => 'Ovaj prioritet se koristi u sledećim sistemskim podešavanjima:',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagement.tt
        'Filter for Processes' => 'Filter procesa',
        'Filter for processes' => 'Filter procesa',
        'Create New Process' => 'Kreiraj novi proces',
        'Deploy All Processes' => 'Rasporedi sve procese',
        'Here you can upload a configuration file to import a process to your system. The file needs to be in .yml format as exported by process management module.' =>
            'Ovde možete učitati konfiguracionu datoteku za uvoz procesa u vaš sistem. Datoteka mora biti u .yml formatu izvezena od strane modula za upravljanje procesom.',
        'Upload process configuration' => 'Učitaj konfiguraciju procesa',
        'Import process configuration' => 'Uvezi konfiguraciju procesa',
        'Ready2Adopt Processes' => 'Ready2Adopt procesi',
        'Here you can activate Ready2Adopt processes showcasing our best practices. Please note that some additional configuration may be required.' =>
            'Ovde možete aktivirati Ready2Adopt procese primera najbolje prakse koji su spremni za upotrebu. Molimo obratite pažnju da je možda neophodna dodatna konfiguracija.',
        'Import Ready2Adopt process' => 'Uvezi Ready2Adopt proces',
        'To create a new Process you can either import a Process that was exported from another system or create a complete new one.' =>
            'Za kreiranje novog procesa možete ili uvesti proces koji je izvezen iz drugog sistema ili kreirati kompletno nov.',
        'Changes to the Processes here only affect the behavior of the system, if you synchronize the Process data. By synchronizing the Processes, the newly made changes will be written to the Configuration.' =>
            'Promene u procesima jedino utiču na ponašanje sistema, ako sinhronizujete podatke procesa. Sinhronizovanjem procesa, novonapravljene promene će biti upisane u konfiguraciju.',
        'Access Control Lists (ACL)' => 'Liste za kontrolu pristupa (ACL)',
        'Generic Agent' => '',
        'Manage Process Widget Groups' => '',
        'Processes' => 'Procesi',
        'Process name' => 'Naziv procesa',
        'Print' => 'Štampaj',
        'Export Process Configuration' => 'Izvezi konfiguraciju procesa',
        'Copy Process' => 'Kopiraj proces',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementActivity.tt
        'Cancel & close' => 'Poništi & zatvori',
        'Go Back' => 'Vrati se nazad',
        'Please note, that changing this activity will affect the following processes' =>
            'Napominjemo da će izmene ove aktivnosti uticati na prateće procese',
        'Activity' => 'Aktivnost',
        'Activity Name' => 'Naziv aktivnosti',
        'Scope' => '',
        'Scope Entity ID' => '',
        'This field is required for activities with a scope.' => '',
        'Activity Dialogs' => 'Dijalozi aktivnosti',
        'You can assign Activity Dialogs to this Activity by dragging the elements with the mouse from the left list to the right list.' =>
            'Dijaloge aktivnosti možete dodeliti ovoj aktivnosti prevlačenjem elemenata mišem od leve liste do desne liste.',
        'Ordering the elements within the list is also possible by drag \'n\' drop.' =>
            'Menjanje redosleda elemenata unutar liste je, takođe, moguće prevračenjem elemenata i puštanjem.',
        'Filter available Activity Dialogs' => 'Filtriraj slobodne dijaloge aktivnosti',
        'Also show global %s' => '',
        'Available Activity Dialogs' => 'Slobodni dijalozi aktivnosti',
        'Name: %s, EntityID: %s' => 'Naziv: %s, ID entiteta: %s',
        'Create New Activity Dialog' => 'Kreiraj nov dijalog aktivnosti',
        'Assigned Activity Dialogs' => 'Dodeljeni dijalozi aktivnosti',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementActivityDialog.tt
        'Please note that changing this activity dialog will affect the following activities' =>
            'Napominjemo da će promena ovog dijaloga aktivnosti uticati na prateće aktivnosti',
        'Please note that customer users will not be able to see or use the following fields: Owner, Responsible, Lock, PendingTime and CustomerID.' =>
            'Napominjemo da klijenti korisnici nisu u mogućnosti da vide ili koriste sledeća polja: Owner, Responsible, Lock, PendingTime i CustomerID.',
        'The Queue field can only be used by customers when creating a new ticket.' =>
            'Polje u redu jedino može biti korišćeno od strane klijenta kada kreiraju novi tiket.',
        'Activity Dialog' => 'Dijalog aktivnosti',
        'Activity dialog Name' => 'Naziv dijaloga aktivnosti',
        'Available in' => 'Raspoloživo u',
        'Description (short)' => 'Opis (kratak)',
        'Description (long)' => 'Opis (dugačak)',
        'The selected permission does not exist.' => 'Izabrana ovlašćenja ne postoje.',
        'Required Lock' => 'Obavezno zaključaj',
        'The selected required lock does not exist.' => 'Odabrano zahtevano zaključavanje ne postoji.',
        'This field is required for activitiy dialogs with a scope.' => '',
        'Submit Advice Text' => 'Pošalji tekst saveta',
        'Submit Button Text' => 'Pošalji tekst dugmeta',
        'You can assign Fields to this Activity Dialog by dragging the elements with the mouse from the left list to the right list.' =>
            'Polja možete dodeliti u ovom dijalogu aktivnosti prevlačenjem elemenata mišem iz leve liste u desnu listu.',
        'Filter available fields' => 'Filtriraj raspoloživa polja',
        'Available Fields' => 'Raspoloživa polja',
        'Assigned Fields' => 'Dodeljena polja',
        'Communication Channel' => 'Komunikacioni kanal',
        'Is visible for customer' => 'Vidljivo klijentu',
        'Text Template' => 'Šablon teksta',
        'Auto fill' => '',
        'Display' => 'Prikaži',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementPath.tt
        'Path' => 'Putanja',
        'Edit this transition' => 'Uredite ovu tranziciju',
        'Transition Actions' => 'Tranzicione akcije',
        'You can assign Transition Actions to this Transition by dragging the elements with the mouse from the left list to the right list.' =>
            'Možete dodeliti tranzicione aktivnosti u ovoj tranziciji prevlačenjem elemenata mišem iz leve liste u desnu listu.',
        'Filter available Transition Actions' => 'Filtriraj raspoložive tranzicione aktivnosti',
        'Available Transition Actions' => 'Raspoložive tranzicione akcije',
        'Create New Transition Action' => 'Kreiraj novu tranzicionu aktivnost',
        'Assigned Transition Actions' => 'Dodeljene tranzicione aktivnosti',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementProcessAccordion.tt
        'Activities' => 'Aktivnosti',
        'Filter Activities...' => 'Filtriraj aktivnosti ...',
        'Create New Activity' => 'Kreiraj novu aktivnost',
        'Filter Activity Dialogs...' => 'Filtriraj dijaloge aktivnosti ...',
        'Transitions' => 'Tranzicije',
        'Filter Transitions...' => 'Filtriraj tranzicije ...',
        'Create New Transition' => 'Kreiraj novu tranziciju',
        'Filter Transition Actions...' => 'Filtriraj tranzicione aktivnosti ...',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementProcessEdit.tt
        'Edit Process' => 'Uredi proces',
        'Print process information' => 'Štampaj informacije procesa',
        'Delete Process' => 'Izbriši proces',
        'Delete Inactive Process' => 'Izbriši neaktivan proces',
        'Available Process Elements' => 'Raspoloživi elementi procesa',
        'The Elements listed above in this sidebar can be moved to the canvas area on the right by using drag\'n\'drop.' =>
            'Elementi, navedeni gore u izdvojenom odeljku, mogu da se pomeraju po površini na desnu stranu korišćenjem prevuci i pusti tehnike.',
        'You can place Activities on the canvas area to assign this Activity to the Process.' =>
            'Možete postaviti aktivnosti na povrsinu kako bi dodeliti ovu aktivnost procesu.',
        'To assign an Activity Dialog to an Activity drop the Activity Dialog element from this sidebar over the Activity placed in the canvas area.' =>
            'Za dodeljivanje Dijaloga Aktivnosti nekoj aktivnosti, prevucite element dijaloga aktivnosti iz izdvojenog dela, preko aktivnosti smeštene na površini.',
        'You can start a connection between two Activities by dropping the Transition element over the Start Activity of the connection. After that you can move the loose end of the arrow to the End Activity.' =>
            'Vezu između dve aktivnosti možete započeti prevlačenjem elementa tranzicije preko početka aktivnosti veze. Nakon toga možete da premestite slobodan kraj strelice do kraja aktivnosti.',
        'Actions can be assigned to a Transition by dropping the Action Element onto the label of a Transition.' =>
            'Aktivnost može biti dodeljena tranziciji prevlačenjem elementa aktivnosti na oznaku tranzicije.',
        'Edit Process Information' => 'Uredi informacije o procesu',
        'Process Name' => 'Naziv procesa',
        'The selected state does not exist.' => 'Odabrani status ne postoji.',
        'Add and Edit Activities, Activity Dialogs and Transitions' => 'Dodaj i uredi aktivosti, dijaloge aktivnosti i tranzicije',
        'Show EntityIDs' => 'Pokaži ID entiteta',
        'Extend the width of the Canvas' => 'Proširi širinu prostora',
        'Extend the height of the Canvas' => 'Produži visinu prostora',
        'Remove the Activity from this Process' => 'Ukloni aktivnost iz ovog procesa',
        'Edit this Activity' => 'Uredi ovu aktivnost',
        'Save Activities, Activity Dialogs and Transitions' => 'Sačuvaj aktivosti, dijaloge aktivnosti i tranzicije',
        'Do you really want to delete this Process?' => 'Da li stvarno želite da obrišete ovaj proces?',
        'Do you really want to delete this Activity?' => 'Da li stvarno želite da obrišete ovu aktivnost?',
        'Do you really want to delete this Activity Dialog?' => 'Da li stvarno želite da obrišete ovaj dijalog aktivnosti?',
        'Do you really want to delete this Transition?' => 'Da li stvarno želite da obrišete ovu tranziciju?',
        'Do you really want to delete this Transition Action?' => 'Da li stvarno želite da obrišete ovu tranzicionu aktivnost?',
        'Do you really want to remove this activity from the canvas? This can only be undone by leaving this screen without saving.' =>
            'Da li stvarno želite da uklonite ovu aktivnost sa površine? Ovo jedino može da se opozove ukoliko napustite ekran, a da prethodno ne sačuvate izmene.',
        'Do you really want to remove this transition from the canvas? This can only be undone by leaving this screen without saving.' =>
            'Da li stvarno želite da uklonite ovu tranziciju sa površine? Ovo jedino može da se opozove ukoliko napustite ekran, a da prethodno ne sačuvate izmene.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementProcessNew.tt
        'In this screen, you can create a new process. In order to make the new process available to users, please make sure to set its state to \'Active\' and synchronize after completing your work.' =>
            'U ovom ekranu možete kreirati novi proces. Da bi novi proces bio dostupan korisnicima, molimo vas da postavite status na \'Active\' i uradite sinhronizaciju nakon završetka vašeg rada.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementProcessPrint.tt
        'cancel & close' => 'poništi & zatvori',
        'Start Activity' => 'Početak aktivnosti',
        'Contains %s dialog(s)' => 'Sadrži %s dijaloga',
        'Assigned dialogs' => 'Dodeljeni dijalozi',
        'Activities are not being used in this process.' => 'Aktivnosti se ne koriste u ovom procesu.',
        'Assigned fields' => 'Dodeljena polja',
        'Activity dialogs are not being used in this process.' => 'Dijalozi aktivnosti se ne koriste u ovom procesu.',
        'Condition linking' => 'Uslov povezivanja',
        'Transitions are not being used in this process.' => 'Tranzicije se ne koriste u ovom procesu.',
        'Module name' => 'Naziv modula',
        'Transition actions are not being used in this process.' => 'Tranzicione aktivnosti se ne koriste u ovom procesu.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementTransition.tt
        'Please note that changing this transition will affect the following processes' =>
            'Napominjemo da bi menjenje ove tranzicije uticalo na prateće procese',
        'Transition' => 'Tranzicija',
        'Transition Name' => 'Naziv tranzicije',
        'This field is required for transitions with a scope.' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminProcessManagementTransitionAction.tt
        'Please note that changing this transition action will affect the following processes' =>
            'Napominjemo da bi menjenje ove tranzicione aktivnosti uticalo na prateće procese',
        'Transition Action' => 'Tranziciona aktivnost',
        'Transition Action Name' => 'Naziv tranzicione aktivnosti',
        'Transition Action Module' => 'Modul tranzicione aktivnosti',
        'This field is required for transition actions with a scope.' => '',
        'Config Parameters' => 'Konfiguracioni parametri',
        'Add a new Parameter' => 'Dodaj novi parametar',
        'Remove this Parameter' => 'Ukloni ovaj parametar',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminQueue.tt
        'Add Queue' => 'Dodaj Red',
        'Edit Queue' => 'Uredi Red',
        'Filter for Queues' => 'Filter za redove',
        'Filter for queues' => 'Filter za redove',
        'Email Addresses' => 'Imejl adrese',
        'PostMaster Mail Accounts' => 'PostMaster mejl nalozi',
        'Salutations' => 'Pozdravi',
        'Signatures' => 'Potpisi',
        'Templates ↔ Queues' => 'Šabloni ↔ redovi',
        'Configure Working Hours' => '',
        'Configure Queue Related Settings' => '',
        'A queue with this name already exists!' => 'Red sa ovim nazivom već postoji!',
        'This queue is present in a SysConfig setting, confirmation for updating settings to point to the new queue is needed!' =>
            'Ovaj red se koristi u sistemskoj konfiguraciji, neophodna je dodatna potvrda za promenu podešavanja na novu vrednost!',
        'Sub-queue of' => 'Pod-red od',
        'Unlock timeout' => 'Vreme do otključavanja',
        '0 = no unlock' => '0 = nema otključavanja',
        'hours' => 'sati',
        'Only business hours are counted.' => 'Računa se samo radno vreme.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' =>
            'Ako operater zaključa tiket i ne otključa ga pre isteka vremena otključavanja, tiket će se otključati i postati dostupan drugim zaposlenima.',
        'Notify by' => 'Obavešten od',
        '0 = no escalation' => '0 = nema eskalacije',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' =>
            'Ako kontakt sa klijentom, bilo spoljašnji imejl ili poziv, nije dodat na novi tiket pre isticanja definisanog vremena, tiket će eskalirati.',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' =>
            'Ako postoji dodat članak, kao npr. nastavak preko imejl poruke ili klijentskog portala, vreme ažuriranja eskalacije se resetuje. Ako ne postoje kontakt podaci o klijentu, bilo imejl ili poziv dodati na tiket pre isticanja ovde definisanog vremena, tiket će eskalirati.',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' =>
            'Ako se tiket ne zatvori pre ovde definisanog vremena, tiket eskalira.',
        'Follow up Option' => 'Opcije nastavka',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' =>
            'Definišite da li nastavak na zatvoreni tiket ponovo otvara tiket ili otvara novi.',
        'Ticket lock after a follow up' => 'Zaključavanje tiketa posle nastavka',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' =>
            'Ako je tiket zatvoren, a klijent pošalje nastavak, tiket će biti zaključan na starog vlasnika.',
        'System address' => 'Sistemska adresa',
        'Will be the sender address of this queue for email answers.' => 'Biće adresa pošiljaoca za imejl odgovore iz ovog reda.',
        'Default sign key' => 'Podrazumevani ključ potpisa',
        'To use a sign key, PGP keys or S/MIME certificates need to be added with identifiers for selected queue system address.' =>
            'Za korišćenje svojstva potpisivanja, PGP ključevi ili S/MIME sertifikati identiteta moraju biti dodati za sistemsku adresu odabranog reda.',
        'Salutation' => 'Pozdrav',
        'The salutation for email answers.' => 'Pozdrav za imejl odgovore.',
        'Signature' => 'Potpis',
        'The signature for email answers.' => 'Potpis za imejl odgovore.',
        'This queue is used in the following config settings:' => 'Ovaj red se koristi u sledećim sistemskim podešavanjima:',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminQueueAutoResponse.tt
        'Manage Queue-Auto Response Relations' => 'Upravljanje vezama red-automatski odgovor',
        'Change Auto Response Relations for Queue' => 'Promeni relacije sa automatskim odgovorima za red',
        'This filter allow you to show queues without auto responses' => 'Ovaj filter vam omogućava prikaz redova bez automatskih odgovora',
        'Queues without Auto Responses' => 'Redovi bez automatskih odgovora',
        'This filter allow you to show all queues' => 'Ovaj filter vam omogućava prikaz svih redova',
        'Show All Queues' => 'Prikaži sve redove',
        'Auto Responses' => 'Automatski odgovori',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminQueueTemplates.tt
        'Manage Template-Queue Relations' => 'Upravljanje odnosom šablon-red',
        'Filter for Templates' => 'Filter za šablone',
        'Filter for templates' => 'Filter za šablone',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminRole.tt
        'Role Management' => 'Upravljanje ulogama',
        'Add Role' => 'Dodaj Ulogu',
        'Edit Role' => 'Uredi Ulogu',
        'Filter for Roles' => 'Filter za uloge',
        'Filter for roles' => 'Filter za uloge',
        'Create a role and put groups in it. Then add the role to the users.' =>
            'Napravi ulogu i dodaj grupe u nju. Onda dodaj ulogu korisnicima.',
        'Agents ↔ Roles' => 'Operateri ↔ uloge',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' =>
            'Nema definisanih uloga. upotrebite dugme \'Add\' za kreiranje nove uloge.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminRoleGroup.tt
        'Manage Role-Group Relations' => 'Upravljanje vezama uloga-grupa',
        'Roles' => 'Uloge',
        'Select the role:group permissions.' => 'Izaberi dozvole za ulogu:grupu',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' =>
            'Ukoliko ništa nije izabrano, onda nema dozvola u ovoj grupi (tiketi neće biti dostupni za ovu ulogu).',
        'Toggle %s permission for all' => 'Promeni %s dozvole za sve',
        'move_into' => 'premesti u',
        'Permissions to move tickets into this group/queue.' => 'Dozvole da se tiketi premeste u ovu grupu/red.',
        'create' => 'kreiraj',
        'Permissions to create tickets in this group/queue.' => 'Dozvola da se tiket kreira u ovu grupu/red.',
        'note' => 'napomena',
        'Permissions to add notes to tickets in this group/queue.' => 'Dozvole za dodavanje napomena na tikete u ovoj grupi/redu.',
        'owner' => 'vlasnik',
        'Permissions to change the owner of tickets in this group/queue.' =>
            'Dozvole za promenu vlasnika tiketa u ovoj grupi/redu.',
        'priority' => 'prioritet',
        'Permissions to change the ticket priority in this group/queue.' =>
            'Dozvola da se menja prioritet tiketa u ovoj grupi/redu.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminRoleUser.tt
        'Manage Agent-Role Relations' => 'Upravljanje vezama operater-uloga',
        'Add Agent' => 'Dodaj Operatera',
        'Filter for Agents' => 'Filter za operatere',
        'Filter for agents' => 'Filter za operatere',
        'Agents' => 'Operateri',
        'Manage Role-Agent Relations' => 'Upravljanje relacijama uloga-operater',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSLA.tt
        'SLA Management' => 'Upravljanje SLA',
        'Edit SLA' => 'Uredi SLA',
        'Add SLA' => 'Dodaj SLA',
        'Filter for SLAs' => 'Filter za SLA',
        'Configure SLA Visibility and Defaults' => '',
        'Please write only numbers!' => 'Molimo pišite samo brojeve!',
        'Minimum Time Between Incidents' => 'Minimalno vreme između incidenata',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSMIME.tt
        'S/MIME Management' => 'S/MIME upravljanje',
        'Add Certificate' => 'Dodaj sertifikat',
        'Add Private Key' => 'Dodaj privatni ključ',
        'SMIME support is disabled' => 'SMIME podrška je onemogućena',
        'To be able to use SMIME in OTRS, you have to enable it first.' =>
            'Da bi mogli da koristite SMIME u OTRS, morate je prvo omogućiti.',
        'Enable SMIME support' => 'Omogući SMIME podršku',
        'Faulty SMIME configuration' => 'Neispravna SMIME konfiguracija',
        'SMIME support is enabled, but the relevant configuration contains errors. Please check the configuration using the button below.' =>
            'SMIME podrška ja omogućena ali relevantna konfiguracija sadrži greške. Molimo da proverite konfiguraciju pritiskom na dugme ispod.',
        'Check SMIME configuration' => 'Proveri SMIME konfiguraciju',
        'Filter for Certificates' => 'Filter za sertifikate',
        'Filter for certificates' => 'Filter za sertifikate',
        'To show certificate details click on a certificate icon.' => 'Za prikazivanje detalja sertifikata klikni na ikonicu sertifikat.',
        'To manage private certificate relations click on a private key icon.' =>
            'Za upravljanje vezama privatnog sertifikata kliknite na ikonicu privatni ključ.',
        'Here you can add relations to your private certificate, these will be embedded to the S/MIME signature every time you use this certificate to sign an email.' =>
            'Ovde možete dodati veze na vaš privatni sertifikat, što će biti ugrađeno u S/MIME potpis svaki put kad upotrebite ovaj sertifikat za potpis imejla.',
        'See also' => 'Pogledaj još',
        'In this way you can directly edit the certification and private keys in file system.' =>
            'Na ovaj način možete direktno da uređujete sertifikate i privatne ključeve u sistemu datoteka.',
        'Hash' => 'Hash',
        'Create' => 'Kreiraj',
        'Handle related certificates' => 'Rukovanje povezanim sertifikatima',
        'Read certificate' => 'Čitaj sertifikat',
        'Delete this certificate' => 'Obriši ovaj sertifikat',
        'File' => 'Datoteka',
        'Secret' => 'Tajna',
        'Related Certificates for' => 'Povezani sertifikati za',
        'Delete this relation' => 'Obriši ovu vezu',
        'Available Certificates' => 'Raspoloživi sertifikati',
        'Filter for S/MIME certs' => 'Filter za S/MIME sertifikate',
        'Relate this certificate' => 'Poveži ovaj sertifikat',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSMIMECertRead.tt
        'S/MIME Certificate' => 'S/MIME sertifikat',
        'Close this dialog' => 'Zatvori ovaj dijalog',
        'Certificate Details' => 'Detalji sertifikata',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSalutation.tt
        'Salutation Management' => 'Upravljanje pozdravima',
        'Add Salutation' => 'Dodaj Pozdrav',
        'Edit Salutation' => 'Uredi Pozdrav',
        'Filter for Salutations' => 'Filter za pozdrave',
        'Filter for salutations' => 'Filter za pozdrave',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSecureMode.tt
        'Secure Mode Needs to be Enabled!' => 'Potrebno je da siguran mod bude uključen!',
        'Secure mode will (normally) be set after the initial installation is completed.' =>
            'Siguran mod će (uobičajeno) biti podešen nakon inicijalne instalacije.',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' =>
            'Ukoliko siguran mod nije aktiviran, pokrenite ga kroz sistemsku konfiguraciju jer je vaša aplikacija već pokrenuta.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSelectBox.tt
        'SQL Box' => 'SQL Boks',
        'Filter for Results' => 'Filter za rezultate',
        'Filter for results' => 'Filter za rezultate',
        'Here you can enter SQL to send it directly to the application database. It is not possible to change the content of the tables, only select queries are allowed.' =>
            'Ovde možete uneti SQL komande i poslati ih direktno aplikacionoj bazi podataka. Nije moguće menjati sadržaj tabela, dozvoljen je jedino \'select\' upit.',
        'Here you can enter SQL to send it directly to the application database.' =>
            'Ovde možete uneti SQL komande i poslati ih direktno aplikacionoj bazi podataka.',
        'Options' => 'Opcije',
        'Only select queries are allowed.' => 'Dozvoljeni su samo \'select\' upiti.',
        'The syntax of your SQL query has a mistake. Please check it.' =>
            'Postoji greška u sintaksi vašeg SQL upita. Molimo proverite.',
        'There is at least one parameter missing for the binding. Please check it.' =>
            'Najmanje jedan parametar nedostaje za povezivanje. Molimo proverite.',
        'Result format' => 'Format rezultata',
        'Run Query' => 'Pokreni upit',
        '%s Results' => '%s Rezultati',
        'Query is executed.' => 'Upit je izvršen.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminService.tt
        'Service Management' => 'Upravljanje uslugama',
        'Add Service' => 'Dodaj uslugu',
        'Edit Service' => 'Uredi uslugu',
        'Configure Service Visibility and Defaults' => '',
        'Service name maximum length is 200 characters (with Sub-service).' =>
            'Maksimalna dužina naziva usluge je 200 karaktera (sa pod-uslugom).',
        'Sub-service of' => 'Pod-usluga od',
        'Criticality' => 'Značaj',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSession.tt
        'Session Management' => 'Upravljanje sesijama',
        'Detail Session View for %s (%s)' => 'Detaljni prikaz sesije za %s (%s)',
        'All sessions' => 'Sve sesije',
        'Agent sessions' => 'Sesije operatera',
        'Customer sessions' => 'Sesije klijenata',
        'Unique agents' => 'Jedinstveni operateri',
        'Unique customers' => 'Jedinstveni klijenti',
        'Kill all sessions' => 'Ugasi sve sesije',
        'Kill this session' => 'Ugasi ovu sesiju',
        'Filter for Sessions' => 'Filter za sesije',
        'Filter for sessions' => 'Filter za sesije',
        'Session' => 'Sesija',
        'Kill' => 'Ugasi',
        'Detail View for SessionID: %s - %s' => 'Detaljni pregled za ID sesije: %s - %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSignature.tt
        'Signature Management' => 'Upravljanje potpisima',
        'Add Signature' => 'Dodaj Potpis',
        'Edit Signature' => 'Uredi Potpis',
        'Filter for Signatures' => 'Filter za potpise',
        'Filter for signatures' => 'Filter za potpise',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminState.tt
        'State Management' => 'Upravljanje statusima',
        'Add State' => 'Dodaj Status',
        'Edit State' => 'Uredi Status',
        'Filter for States' => 'Filter za stanja',
        'Filter for states' => 'Filter za stanja',
        'Attention' => 'Pažnja',
        'Please also update the states in SysConfig where needed.' => 'Molimo da ažurirate stause i u sistemskoj konfiguraciji gde je to potrebno.',
        'Configure State Visibility and Defaults' => '',
        'Configure State Type Visibility and Defaults' => '',
        'This state is present in a SysConfig setting, confirmation for updating settings to point to the new type is needed!' =>
            'Ovo stanje se koristi u sistemskoj konfiguraciji, neophodna je dodatna potvrda za promenu podešavanja na novu vrednost! ',
        'State type' => 'Tip statusa',
        'It\'s not possible to invalidate this entry because there is no other merge states in system!' =>
            'Nije moguće obeležiti ovu stavku kao nevažeću jer ne postoji više statusa spojenih tiketa u sistemu!',
        'This state is used in the following config settings:' => 'Ovo stanje se koristi u sledećim sistemskim podešavanjima: ',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSupportDataCollector.tt
        'Cloud services are currently disabled.' => 'Servisi u oblaku su trenutno deaktivirani.',
        'Sending support data to OTRS Group is not possible!' => 'Slanje podataka za podršku OTRS grupi nije moguće!',
        'Enable Cloud Services' => 'Aktiviraj servise u oblaku',
        'Enable cloud services' => 'Aktiviraj servise u oblaku',
        'A support bundle (including: system registration information, support data, a list of installed packages and all locally modified source code files) can be generated by pressing this button:' =>
            'Paket za podršku (uključujući: informacije o registraciji sistema, podatke za podršku, listu instaliranih paketa i svih lokalno modifikovanih datoteka izvornog koda) može biti generisan pritiskom na ovo dugme:',
        'Generate Support Bundle' => 'Generiši paket podrške',
        'The Support Bundle has been Generated' => 'Paket podrške je generisan',
        'A file containing the support bundle will be downloaded to the local system.' =>
            'Datoteka koja sadrži paket za podršku će biti preuzeta na lokalni računar.',
        'Support Data' => 'Podaci podrške',
        'Error: Support data could not be collected (%s).' => 'Podržani podaci ne mogu biti prikupljeni (%s).',
        'Details' => 'Detalji',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemAddress.tt
        'System Email Addresses Management' => 'Upravljanje sistemskom imejl adresom',
        'Add System Email Address' => 'Dodaj sistemsku imejl adresu',
        'Edit System Email Address' => 'Uredi sistemsku imejl adresu',
        'Add System Address' => 'Dodaj sistemsku adresu',
        'Filter for System Addresses' => 'Filter za sistemske adrese',
        'Filter for system addresses' => 'Filter za sistemske adrese',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' =>
            'Sve dolazne poruke sa ovom adresom u polju To ili Cc biće otpremljene u izabrani red.',
        'Email address' => 'Imejl adresa',
        'Display name' => 'Prikaži naziv',
        'This email address is already used as system email address.' => 'Ova imejl adresa je već upotrebljena kao sistemska imejl adresa.',
        'The display name and email address will be shown on mail you send.' =>
            'Prikazano ime i imejl adresa će biti prikazani na poruci koju ste poslali.',
        'This system address cannot be set to invalid.' => 'Ova sistemska adresa se ne može označiti kao nevažeća.',
        'This system address cannot be set to invalid, because it is used in one or more queue(s) or auto response(s).' =>
            'Ova sistemska adresa se ne može označiti kao nevažeća jer se koristi u jednom ili više automatskih odgovora.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemConfiguration.tt
        'online administrator documentation' => 'priručnika za administratore',
        'System configuration' => 'Sistemska konfiguracija',
        'Navigate through the available settings by using the tree in the navigation box on the left side.' =>
            'Pregledajte dostupna podešavanjea korišćenjem navigacije sa leve strane.',
        'Find certain settings by using the search field below or from search icon from the top navigation.' =>
            'Pretražite odgovarajuća podešavanja korišćenjem polja za pretragu ispod ili preko ikonice za pretragu na gornjoj navigaciji.',
        'Find out how to use the system configuration by reading the %s.' =>
            'Saznajte kako da koristite sistemsku konfiguraciju čitanjem %s.',
        'Search in all settings...' => 'Pretražite sva podešavanja...',
        'There are currently no settings available. Please make sure to run \'otrs.Console.pl Maint::Config::Rebuild\' before using the software.' =>
            'Trenutno nema dostupnih podešavanja. Molimo proverite da li ste pokrenuli skript \'otrs.Console.pl Maint::Config::Rebuild\' pre korišćenja aplikacije.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemConfigurationDeployment.tt
        'Changes Deployment' => 'Raspored promena',
        'Help' => 'Pomoć',
        'This is an overview of all settings which will be part of the deployment if you start it now. You can compare each setting to its former state by clicking the icon on the top right.' =>
            'Ovo je pregled svih podešavanja koja će biti deo rasporeda ukoliko ga pokrenete. Moćete ih uporediti sa prethodnim stanjem klikom na ikonicu u gornjem desnom uglu.',
        'To exclude certain settings from a deployment, click the checkbox on the header bar of a setting.' =>
            'Za izuzimanje pojedinačnih podešavanja iz rasporeda, aktivirajte kućicu u zaglavlju podešavanja.',
        'By default, you will only deploy settings which you changed on your own. If you\'d like to deploy settings changed by other users, too, please click the link on top of the screen to enter the advanced deployment mode.' =>
            'Podrazumevano, biće raspoređena samo podešavanja koja ste vi izmenili. Ukoliko želite da rasporedite i podešavanja izmenjena od strane drugih korisnika, molimo kliknite na vezu pri vrhu ekrana za pristup ekranu naprednog rasporeda.',
        'A deployment has just been restored, which means that all affected setting have been reverted to the state from the selected deployment.' =>
            'Raspored je obnovljen, što znači da su sva podešavanja postavljena na vrednosti iz odabranog rasporeda.',
        'Please review the changed settings and deploy afterwards.' => 'Molimo pregledajte izmenjena podešavanja i rasporedite ih.',
        'An empty list of changes means that there are no differences between the restored and the current state of the affected settings.' =>
            'Prazna lista promena znači da nema promena između obnovljenog i trenutnog stanja vrednosti podešavanja.',
        'Changes Overview' => 'Pregled promena',
        'There are %s changed settings which will be deployed in this run.' =>
            'Ukupno %s promenjenih podešavanja će biti raspoređeno.',
        'Switch to basic mode to deploy settings only changed by you.' =>
            'Pređite na osnovni mod za raspored podešavanja koje ste samo vi promenili.',
        'You have %s changed settings which will be deployed in this run.' =>
            'Imate %s promenjenih podešavanja koja će biti raspoređena.',
        'Switch to advanced mode to deploy settings changed by other users, too.' =>
            'Pređite na napredni mod za raspored podešavanja koje su promenili i ostali korisnici.',
        'There are no settings to be deployed.' => 'Nema podešavanja koja se mogu rasporediti.',
        'Switch to advanced mode to see deployable settings changed by other users.' =>
            'Prežite na napredni mod da vidite koja podešavanja promenjena od strane ostalih korisnika mogu biti raspoređena.',
        'Deploy selected changes' => 'Rasporedi označene promene',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemConfigurationGroup.tt
        'This group doesn\'t contain any settings. Please try navigating to one of its sub groups.' =>
            'Ova kategorija ne sadrži nijedno podešavanje. Molimo probajte neku od pod-grupa.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemConfigurationImportExport.tt
        'Import & Export' => 'Uvoz & izvoz',
        'Upload a file to be imported to your system (.yml format as exported from the System Configuration module).' =>
            'Otpremite datoteku za uvoz u vaš sistem (.yml format izvezen iz modula sistemske konfiguracije).',
        'Upload system configuration' => 'Otpremi sistemsku konfiguraciju',
        'Import system configuration' => 'Uvezi sistemsku konfiguraciju',
        'Download current configuration settings of your system in a .yml file.' =>
            'Preuzmite trenutnu konfiguraciju vašeg sistema kao .yml datoteku.',
        'Include user settings' => 'Uključi korisnička podešavanja',
        'Export current configuration' => 'Izvezi trenutnu konfiguraciju',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemConfigurationSearch.tt
        'Search for' => 'Traži za',
        'Search for category' => 'Traži za kategoriju',
        'Settings I\'m currently editing' => 'Podešavanja koja trenutno menjate',
        'Your search for "%s" in category "%s" did not return any results.' =>
            'Vaša pretraga za "%s" u kategoriji "%s" nije vratila rezultate.',
        'Your search for "%s" in category "%s" returned one result.' => 'Vaša pretraga za "%s" u kategoriji "%s" je vratila jedan rezultat.',
        'Your search for "%s" in category "%s" returned %s results.' => 'Vaša pretraga za "%s" u kategoriji "%s" je vratila %s rezultat(a).',
        'You\'re currently not editing any settings.' => 'Trenutno ne menjate nijedno podešavanje.',
        'You\'re currently editing %s setting(s).' => 'Trenutno menjate %s podešavanje/a.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemConfigurationSearchDialog.tt
        'Category' => 'Kategorija',
        'Run search' => 'Pokreni pretragu',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemConfigurationView.tt
        'View a custom List of Settings' => 'Pregled liste podešavanja',
        'View single Setting: %s' => 'Pregled pojedinačnog podešavanja: %s',
        'Go back to Deployment Details' => 'Nazad na detalje raspoređivanja',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemFiles.tt
        'System file support' => '',
        'Delete cache' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemFiles/Widget.tt
        'Permissions' => 'Dozvole',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemMaintenance.tt
        'System Maintenance Management' => 'Upravljanje sistemom održavanja',
        'Schedule New System Maintenance' => 'Planiraj novo oržavanje sistema.',
        'Filter for System Maintenances' => 'Filter za održavanja sistema',
        'Filter for system maintenances' => 'Filter za održavanja sistema',
        'Schedule a system maintenance period for announcing the Agents and Customers the system is down for a time period.' =>
            'Planiranje perioda održavanja sistema radi obaveštavanja operatera i klijenata da je sistem isključen u tom periodu. ',
        'Some time before this system maintenance starts the users will receive a notification on each screen announcing about this fact.' =>
            'Neko vreme pre nego otpočne održavanje sistema, korisnici će dobiti obaveštenje koje najavljuje ovaj događaj na svaki ekran.',
        'Stop date' => 'Datum završetka',
        'Delete System Maintenance' => 'Obriši održavanje sistema',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminSystemMaintenanceEdit.tt
        'Edit System Maintenance' => 'Uredi održavanje sistema',
        'Edit System Maintenance Information' => 'Uredi održavanje sistema',
        'Date invalid!' => 'Neispravan datum',
        'Login message' => 'Poruka prijave',
        'This field must have less then 250 characters.' => 'Ovo polje ne sme biti duže od 250 karaktera.',
        'Show login message' => 'Pokaži poruku prijave',
        'Notify message' => 'Poruka obaveštenja',
        'Manage Sessions' => 'Upravljanje sesijama',
        'All Sessions' => 'Sve sesije',
        'Agent Sessions' => 'Sesije operatera',
        'Customer Sessions' => 'Sesije klijenata',
        'Kill all Sessions, except for your own' => 'Prekini sve sesije, osim sopstvene',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminTemplate.tt
        'Template Management' => 'Upravljanje šablonima',
        'Add Template' => 'Dodaj Šablon',
        'Edit Template' => 'Uredi Šablon',
        'A template is a default text which helps your agents to write faster tickets, answers or forwards.' =>
            'Šablon je podrazumevani tekst koji pomaže vašim agentima da brže ispišu tikete, odgovore ili prosleđene poruke.',
        'Don\'t forget to add new templates to queues.' => 'Ne zaboravite da dodate novi šablon u redu.',
        'Attachments' => 'Prilozi',
        'Delete this entry' => 'Obriši ovaj unos',
        'Do you really want to delete this template?' => 'Da li stvarno želite da obrišete ovaj šablon?',
        'A standard template with this name already exists!' => 'Standardni šablon sa ovim nazivom već postoji!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminTemplateAttachment.tt
        'Manage Template-Attachment Relations' => 'Upravljanje relacijama šabloni-prilozi',
        'Toggle active for all' => 'Promeni stanje u aktivan za sve',
        'Link %s to selected %s' => 'Poveži %s sa izabranim %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminTicketAttributeRelations.tt
        'Ticket attribute relations' => '',
        'Add ticket attribute relations' => '',
        'Edit ticket attribute relations' => '',
        'Import CSV or Excel file' => '',
        'Attribute' => 'Atribut',
        'Last update' => '',
        'Are you sure you want to delete entry \'%s\'?' => '',
        'Download previously imported file' => '',
        'The file needs to be in CSV (UTF-8) or Excel format. Both header columns need to contain the names of valid ticket attributes. The name of the uploaded file must be unique and must not be in use by another ticket attribute relations record.' =>
            '',
        'Add missing possible dynamic field values' => '',
        'Attribute values' => '',
        'If a value is colored red, it is missing from the possible values list of the dynamic field configuration.' =>
            '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminType.tt
        'Type Management' => 'Upravljanje tipovima',
        'Add Type' => 'Dodaj Tip ',
        'Edit Type' => 'Uredi Tip',
        'Filter for Types' => 'Filter za tipove',
        'Filter for types' => 'Filter za tipove',
        'Configure Type Visibility and Defaults' => '',
        'A type with this name already exists!' => 'Tip sa ovim nazivom već postoji!',
        'This type is present in a SysConfig setting, confirmation for updating settings to point to the new type is needed!' =>
            'Ovaj tip se koristi u sistemskoj konfiguraciji, neophodna je dodatna potvrda za promenu podešavanja na novu vrednost!',
        'This type is used in the following config settings:' => 'Ovaj tip se koristi u sledećim sistemskim podešavanjima:',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminUser.tt
        'Agent Management' => 'Upravljanje operaterima',
        'Edit Agent' => 'Uredi Operatera',
        'Edit personal preferences for this agent' => 'Uredite lična podešavanja za ovog operatera',
        'Agents will be needed to handle tickets.' => 'Biće potrebni operateri za obradu tiketa.',
        'Don\'t forget to add a new agent to groups and/or roles!' => 'Ne zaboravite da dodate novog operatera u grupe i/ili uloge!',
        'Please enter a search term to look for agents.' => 'Molimo unesite pojam za pretragu radi nalaženja operatera.',
        'Last login' => 'Prethodna prijava',
        'Switch to agent' => 'Pređi na operatera',
        'Title or salutation' => 'Naslov pozdrava',
        'Firstname' => 'Ime',
        'Lastname' => 'Prezime',
        'A user with this username already exists!' => 'Ovo korisničko ime je već upotrebljeno!',
        'Will be auto-generated if left empty.' => 'Biće automatski generisano ako se ostavi prazno.',
        'Mobile' => 'Mobilni',
        'Effective Permissions for Agent' => 'Efektivne dozole za operatera',
        'This agent has no group permissions.' => 'Ovaj operater nema dozvole za grupe.',
        'Table above shows effective group permissions for the agent. The matrix takes into account all inherited permissions (e.g. via roles).' =>
            'Tabela iznad prikazuje efektivne dozvole za grupe operatera. Matrica uzima u obzir sve nasleđene dozvole (npr. putem uloga).',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AdminUserGroup.tt
        'Manage Agent-Group Relations' => 'Upravljanje relacijama operater-grupa',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentAppointmentAgendaOverview.tt
        'Agenda Overview' => 'Pregled dnevnog reda',
        'Manage Calendars' => 'Upravljanje kalendarima',
        'Add Appointment' => 'Dodaj termin',
        'Today' => 'Danas',
        'All-day' => 'Celodnevno',
        'Repeat' => 'Ponavljanje',
        'Notification' => 'Obaveštenje',
        'Yes' => 'Da',
        'No' => 'Ne',
        'No calendars found. Please add a calendar first by using Manage Calendars page.' =>
            'Nije pronađen nijedan kalendar. Molimo prvo dodajte kalendar korišćenjem ekrana Upravljanje kalendarima.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentAppointmentCalendarOverview.tt
        'Add new Appointment' => 'Dodaj novi termin',
        'Appointments' => 'Termini',
        'Calendars' => 'Kalendari',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentAppointmentEdit.tt
        'Basic information' => 'Osnovne informacije',
        'Date/Time' => 'Datum/vreme',
        'Invalid date!' => 'Nevažeći datum!',
        'Please set this to value before End date.' => 'Molimo postavite ovaj datum pre kraja.',
        'Please set this to value after Start date.' => 'Molimo postavite ovaj datum posle početka.',
        'This an occurrence of a repeating appointment.' => 'Ovo je termin koji se ponavlja.',
        'Click here to see the parent appointment.' => 'Kliknite ovde za pregled matičnog termina.',
        'Click here to edit the parent appointment.' => 'Kliknite ovde za izmenu matičnog termina.',
        'Frequency' => 'Učestalost',
        'Every' => 'Svakog(e)',
        'day(s)' => 'dan(i)',
        'week(s)' => 'nedelja(e)',
        'month(s)' => 'mesec(i)',
        'year(s)' => 'godina(e)',
        'On' => 'Uključeno',
        'Monday' => 'ponedeljak',
        'Mon' => 'pon',
        'Tuesday' => 'utorak',
        'Tue' => 'uto',
        'Wednesday' => 'sreda',
        'Wed' => 'sre',
        'Thursday' => 'četvrtak',
        'Thu' => 'čet',
        'Friday' => 'petak',
        'Fri' => 'pet',
        'Saturday' => 'subota',
        'Sat' => 'sub',
        'Sunday' => 'nedelja',
        'Sun' => 'ned',
        'January' => 'januar',
        'Jan' => 'Jan',
        'February' => 'februar',
        'Feb' => 'Feb',
        'March' => 'mart',
        'Mar' => 'Mar',
        'April' => 'april',
        'Apr' => 'Apr',
        'May_long' => 'maj',
        'May' => 'Maj',
        'June' => 'jun',
        'Jun' => 'Jun',
        'July' => 'jul',
        'Jul' => 'Jul',
        'August' => 'avgust',
        'Aug' => 'Avg',
        'September' => 'septembar',
        'Sep' => 'Sep',
        'October' => 'oktobar',
        'Oct' => 'Okt',
        'November' => 'novembar',
        'Nov' => 'Nov',
        'December' => 'decembar',
        'Dec' => 'Dec',
        'Relative point of time' => 'Relativno vreme',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentCustomerInformationCenter.tt
        'Customer Information Center' => 'Klijentski informativni centar',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentCustomerInformationCenterSearch.tt
        'Customer User' => 'Klijent korisnik',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentCustomerTableView.tt
        'Note: Customer is invalid!' => 'Napomena: klijent je nevažeći!',
        'Start chat' => 'Počni ćaskanje',
        'Video call' => 'Video poziv',
        'Audio call' => 'Audio poziv',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentCustomerUserAddressBook.tt
        'Customer User Address Book' => 'Adresar klijent korisnika',
        'Search for recipients and add the results as \'%s\'.' => 'Pretražite za primaoce i dodajte rezultate kao \'%s\'.',
        'Search template' => 'Šablon pretrage',
        'Create Template' => 'Napravi šablon',
        'Create New' => 'Napravi nov',
        'Save changes in template' => 'Sačuvaj promene u šablonu',
        'Filters in use' => 'Filteri u upotrebi',
        'Additional filters' => 'Dodatni filteri',
        'Add another attribute' => 'Dodaj još jedan atribut',
        'The attributes with the identifier \'(Customer)\' are from the customer company.' =>
            'Atributi sa identifikatorom \'(Customer)\' dolaze iz klijent firmi.',
        '(e. g. Term* or *Term*)' => '(npr. Term* ili *Term*)',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentCustomerUserAddressBookOverview.tt
        'The customer user is already selected in the ticket mask.' => 'Klijent korisnik je već odabran u formi tiketa.',
        'Select this customer user' => 'Označi ovog klijent korisnika',
        'Add selected customer user to' => 'Dodaj označenog klijent korisnika u',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentCustomerUserAddressBookOverviewNavBar.tt
        'Change search options' => 'Promeni opcije pretrage',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentCustomerUserInformationCenter.tt
        'Customer User Information Center' => 'Klijent-korisnički informativni centar',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDaemonInfo.tt
        'The OTRS Daemon is a daemon process that performs asynchronous tasks, e.g. ticket escalation triggering, email sending, etc.' =>
            'OTRS servis je sistemski proces koji izvršava asinhrone poslove, npr. okidanje eskalacija tiketa, slanje imejlova, itd.',
        'A running OTRS Daemon is mandatory for correct system operation.' =>
            'Pokrenut OTRS sistemski servis je neophodan za ispravno funkcionisanje sistema.',
        'Starting the OTRS Daemon' => 'Pokretanje OTRS sistemskog servisa',
        'Make sure that the file \'%s\' exists (without .dist extension). This cron job will check every 5 minutes if the OTRS Daemon is running and start it if needed.' =>
            'Osigurava da datoteka \'%s\' postoji (bez .dist ekstenzije). Ovaj kron posao će proveravati svakih 5 minuta da li OTRS sistemski servis radi i pokreće ga ako je potrebno.',
        'Execute \'%s start\' to make sure the cron jobs of the \'otrs\' user are active.' =>
            'Izvršite \'%s start\' da bi bili sigurni da su kron poslovi za OTRS korisnika uvek aktivni.',
        'After 5 minutes, check that the OTRS Daemon is running in the system (\'bin/otrs.Daemon.pl status\').' =>
            'Posle 5 minuta, proverava da li OTRS sistemski servis funkcioniše u sistemu (\'bin/otrs.Daemon.pl status\').',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboard.tt
        'Dashboard' => 'Komandna tabla',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardAppointmentCalendar.tt
        'New Appointment' => 'Novi termin',
        'Tomorrow' => 'Sutra',
        'Soon' => 'Uskoro',
        '5 days' => '5 dana',
        'Start' => 'Početak',
        'none' => 'ni jedan',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardCalendarOverview.tt
        'in' => 'u',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardCommon.tt
        'Save settings' => 'Sačuvaj podešavanja',
        'Close this widget' => 'Zatvori ovaj dodatak',
        'more' => 'još',
        'Available Columns' => 'Raspoložive kolone',
        'Visible Columns (order by drag & drop)' => 'Vidljive kolone (redosled prema prevuci i pusti)',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardCustomerIDList.tt
        'Change Customer Relations' => 'Promeni relacije klijenata',
        'Open' => 'Otvoreno',
        'Closed' => 'Zatvoreni',
        '%s open ticket(s) of %s' => '%s otvorenih tiketa od %s',
        '%s closed ticket(s) of %s' => '%s zatvorenih tiketa od %s',
        'Edit customer ID' => 'Uredi ID klijenta',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardCustomerIDStatus.tt
        'Escalated tickets' => 'Eskalirani tiketi',
        'Open tickets' => 'Otvoreni tiketi',
        'Closed tickets' => 'Zatvoreni tiketi',
        'All tickets' => 'Svi tiketi',
        'Archived tickets' => 'Arhivirani tiketi',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardCustomerUserInformation.tt
        'Note: Customer User is invalid!' => 'Napomena: klijent korisnik je nevažeći!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardCustomerUserList.tt
        'Customer user information' => 'Informacije o klijent korisniku',
        'Phone ticket' => 'Tiket poziva',
        'Email ticket' => 'Imejl tiket',
        'New phone ticket from %s' => 'Novi tiket poziva od %s',
        'New email ticket to %s' => 'Novi imejl tiket od %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardMyLastChangedTickets.tt
        'No tickets found.' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardProductNotify.tt
        '%s %s is available!' => '%s %s je dostupan!',
        'Please update now.' => 'Molimo ažurirajte sada.',
        'Release Note' => 'Napomena uz izdanje',
        'Level' => 'Nivo',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardRSSOverview.tt
        'Posted %s ago.' => 'Poslato pre %s.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardStats.tt
        'The configuration for this statistic widget contains errors, please review your settings.' =>
            'Konfiguracija za ovaj statistički dodatak sadrži greške, molimo proverite vaša podešavanja.',
        'Download as SVG file' => 'Preuzmi kao SVG datoteku',
        'Download as PNG file' => 'Preuzmi kao PNG datoteku',
        'Download as CSV file' => 'Preuzmi kao CSV datoteku',
        'Download as Excel file' => 'Preuzmi kao Excel datoteku',
        'Download as PDF file' => 'Preuzmi kao PDF datoteku',
        'Please select a valid graph output format in the configuration of this widget.' =>
            'Molimo da u konfiguraciji ovog dodatka izaberete važeći izlazni format grafikona.',
        'The content of this statistic is being prepared for you, please be patient.' =>
            'Sadržaj ove statistike se priprema za vas, molimo budite strpljivi.',
        'This statistic can currently not be used because its configuration needs to be corrected by the statistics administrator.' =>
            'Ova statistika se trenutno ne može koristiti zato što administrator statistike treba da koriguje njenu konfiguraciju.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardTicketGeneric.tt
        'Assigned to customer user' => 'Dodeljeni klijent korisnik',
        'Accessible for customer user' => 'Dozvoljen pristup za klijent korisnika',
        'My locked tickets' => 'Moji zaključani tiketi',
        'My Owned Tickets' => '',
        'My watched tickets' => 'Moji praćeni tiketi',
        'My responsibilities' => 'Odgovoran sam za',
        'Tickets in My Queues' => 'Tiketi u mojim redovima',
        'Tickets in My Services' => 'Tiketi u mojim uslugama',
        'Service Time' => 'Vreme usluge',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardTicketQueueOverview.tt
        'Total' => 'Ukupno',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardUserOnline.tt
        'out of office' => 'van kancelarije',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentDashboardUserOutOfOffice.tt
        'until' => 'dok',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentInfo.tt
        'To accept some news, a license or some changes.' => 'Da bi prihvatili neke vesti, dozvole ili neke promene.',
        'Yes, accepted.' => 'Da, prihvaćeno.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentLinkObject.tt
        'Manage links for %s' => 'Uredi veze za %s',
        'Create new links' => 'Napravi nove veze',
        'Manage existing links' => 'Uredi postojeće veze',
        'Link with' => 'Poveži sa',
        'Start search' => 'Započni pretragu',
        'There are currently no links. Please click \'Create new Links\' on the top to link this item to other objects.' =>
            'Trenutno nema veza. Molimo kliknite na \'Dodaj nove veze\' pri vrhu da biste povezali ovaj objekat sa ostalim.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentOTRSBusinessBlockScreen.tt
        'Unauthorized usage of %s detected' => 'Detektovana neovlaštena upotreba %s',
        'If you decide to downgrade to ((OTRS)) Community Edition, you will lose all database tables and data related to %s.' =>
            'Ako odlučite da se vratite na besplatno izdanje ((OTRS)), izgubićete sve tabele i podatke u bazi podataka povezane sa %s.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentPreferences.tt
        'Edit your preferences' => 'Uredi lične postavke',
        'Personal Preferences' => 'Lična podešavanja',
        'Preferences' => 'Podešavanja',
        'Please note: you\'re currently editing the preferences of %s.' =>
            'Napomena: trenutno menjate podešavanja od %s.',
        'Go back to editing this agent' => 'Nazad na uređivanje ovog operatera',
        'Set up your personal preferences. Save each setting by clicking the checkmark on the right.' =>
            'Podesite svoja lična podešavanja. Sačuvajte svako podešavanje štikliranjem sa desne strane.',
        'You can use the navigation tree below to only show settings from certain groups.' =>
            'Možete koristiti navigaciju ispod za prikaz podešavanja koja pripadaju određenim grupama.',
        'Dynamic Actions' => 'Dinamičke akcije',
        'Filter settings...' => 'Izfiltrirajte podešavanja...',
        'Filter for settings' => 'Filter za podešavanja',
        'Save all settings' => 'Sačuvajte sva podešavanja',
        'Avatars have been disabled by the system administrator. You\'ll see your initials instead.' =>
            'Prikaz avatar sličice je onemogućen od strane sistem administratora. Umesto sličice biće prikazani vaši inicijali.',
        'You can change your avatar image by registering with your email address %s at %s. Please note that it can take some time until your new avatar becomes available because of caching.' =>
            'Vašu avatar sličicu možete promeniti registracijom vaše imejl adrese %s na %s. Molimo obratite pažnju da je zbog keširanja neophodno da prođe neko vreme pre nego što vaš novi avatar postane vidljiv.',
        'Off' => 'Isključeno',
        'End' => 'Kraj',
        'Left' => 'Levo',
        'The horizontal distance of the window relative to the screen, in pixels.' =>
            '',
        'Top' => '',
        'The vertical distance of the window relative to the screen, in pixels.' =>
            '',
        'Width' => '',
        'Width in pixels or percent.' => '',
        'Height' => '',
        'Height in pixels or percent.' => '',
        'This setting can currently not be saved.' => 'Ovo podešavanje trenutno ne može biti sačuvano.',
        'This setting can currently not be saved' => 'Ovo podešavanje trenutno ne može biti sačuvano',
        'Save this setting' => 'Sačuvaj ovo podešavanje',
        'Did you know? You can help translating Znuny at %s.' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentPreferences/SettingsList.tt
        'Reset to default' => 'Poništi na podrazumevanu vrednost',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentPreferencesOverview.tt
        'Choose from the groups on the right to find the settings you\'d wish to change.' =>
            'Izaberite grupu sa desne strane za prikaz podešavanja dostupnih za promene.',
        'Did you know?' => 'Da li ste znali?',
        'You can change your avatar by registering with your email address %s on %s' =>
            'Vašu avatar sličicu možete promeniti registracijom vaše imejl adrese %s na %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentSplitSelection.tt
        'Target' => 'Cilj',
        'Process' => 'Proces',
        'Split' => 'Podeli',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentStatisticsAdd.tt
        'Statistics Management' => 'Upravljanje statistikama',
        'Add Statistics' => 'Dodaj statistiku',
        'Read more about statistics in OTRS' => 'Pročitajte više o statistikama u OTRS',
        'Dynamic Matrix' => 'Dinamička matrica',
        'Each cell contains a singular data point.' => 'Svaka ćelija sadrži pojedinačni podatak.',
        'Dynamic List' => 'Dinamička lista',
        'Each row contains data of one entity.' => 'Svaki red sadrži podatke pojedinačnog objekta.',
        'Static' => 'Statički',
        'Non-configurable complex statistics.' => 'Kompleksne statistike koje nije moguće konfigurisati.',
        'General Specification' => 'Opšta specifikacija',
        'Create Statistic' => 'Kreiraj statistiku',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentStatisticsEdit.tt
        'Edit Statistics' => 'Uređivanje statistika',
        'Run now' => 'Pokreni sad',
        'Statistics Preview' => 'Pregled statistike',
        'Save Statistic' => 'Sačuvaj statistiku',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentStatisticsImport.tt
        'Import Statistics' => 'Uvoz statistika',
        'Import Statistics Configuration' => 'Uvezi konfiguraciju statistike',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentStatisticsOverview.tt
        'Statistics' => 'Statistike',
        'Run' => 'Pokreni',
        'Edit statistic "%s".' => 'Izmeni statistiku "%s".',
        'Export statistic "%s"' => 'Izvezi statistiku "%s"',
        'Export statistic %s' => 'Izmeni statistiku %s',
        'Delete statistic "%s"' => 'Obriši statistiku "%s"',
        'Delete statistic %s' => 'Obriši statistiku %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentStatisticsView.tt
        'Statistics Overview' => 'Pregled statistika',
        'View Statistics' => 'Pregled statistika',
        'Statistics Information' => 'Informacije o statistici',
        'Created by' => 'Kreirao',
        'Changed by' => 'Izmenio',
        'Sum rows' => 'Zbir redova',
        'Sum columns' => 'Zbir kolona',
        'Show as dashboard widget' => 'Prikaži kao dodatak kontrolne table',
        'Cache' => 'Keš',
        'This statistic contains configuration errors and can currently not be used.' =>
            'Ova statistika sadrži konfiguracione greške i sad se ne može koristiti.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketActionCommon.tt
        'Change Free Text of %s%s%s' => 'Promeni slobodni tekst za %s%s%s',
        'Change Owner of %s%s%s' => 'Promeni vlasnika za %s%s%s',
        'Close %s%s%s' => 'Zatvori %s%s%s',
        'Add Note to %s%s%s' => 'Dodaj napomenu %s%s%s',
        'Set Pending Time for %s%s%s' => 'Postavi vreme čekanja za %s%s%s',
        'Change Priority of %s%s%s' => 'Promeni prioritet za %s%s%s',
        'Change Responsible of %s%s%s' => 'Promeni odgovornog za %s%s%s',
        'All fields marked with an asterisk (*) are mandatory.' => 'Sva polja označena zvezdicom (*) su obavezna.',
        'The ticket has been locked' => 'Tiket je zaključan.',
        'Undo & close' => 'Odustani & zatvori',
        'Ticket Settings' => 'Podešavanje tiketa',
        'Queue invalid.' => 'Nevažeći red.',
        'Service invalid.' => 'Nevažeća usluga.',
        'SLA invalid.' => 'Nevažeći SLA.',
        'New Owner' => 'Novi vlasnik',
        'Please set a new owner!' => 'Molimo da odredite novog vlasnika!',
        'Owner invalid.' => ' Nevažeći vlasnik.',
        'New Responsible' => 'Novi odgovorni',
        'Please set a new responsible!' => 'Molimo da odredite novog odgovornog!',
        'Responsible invalid.' => 'Nevažeći odgovoran.',
        'Next state' => 'Sledeći status',
        'State invalid.' => 'Nevažeće stanje.',
        'For all pending* states.' => 'Za sva stanja* čekanja.',
        'Add Article' => 'Dodaj članak',
        'Create an Article' => 'Kreiraj članak',
        'Inform agents' => 'Obavesti operatere',
        'Inform involved agents' => 'Obavesti uključene operatere',
        'Here you can select additional agents which should receive a notification regarding the new article.' =>
            'Ovde možete izabrati dodatne operatere koji treba da primaju obaveštenja u vezi sa novim člankom.',
        'Text will also be received by' => 'Tekst će takođe primiti i:',
        'Setting a template will overwrite any text or attachment.' => 'Podešavanje šablona će prepisati svaki tekst ili prilog.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketBounce.tt
        'Bounce %s%s%s' => 'Odbaci %s%s%s',
        'Bounce to' => 'Preusmeri na',
        'You need a email address.' => 'Potrebna vam je imejl adresa.',
        'Need a valid email address or don\'t use a local email address.' =>
            'Ispravna imejl adresa je neophodna, ali ne koristite lokalnu adresu!',
        'Next ticket state' => 'Naredni status tiketa',
        'Inform sender' => 'Obavesti pošiljaoca',
        'Send mail' => 'Pošalji imejl!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketBulk.tt
        'Ticket Bulk Action' => 'Masovne akcije na tiketima',
        'Send Email' => 'Pošalji imejl',
        'Merge' => 'Spoji',
        'Merge to' => 'Objedini sa',
        'Invalid ticket identifier!' => 'Nevažeći identifikator tiketa!',
        'Merge to oldest' => 'Objedini sa najstarijom',
        'Link together' => 'Poveži zajedno',
        'Link to parent' => 'Poveži sa nadređenim',
        'Unlock tickets' => 'Otključaj tikete',
        'Execute Bulk Action' => 'Izvrši masovnu akciju',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketCompose.tt
        'Compose Answer for %s%s%s' => 'Napiši odgovor za %s%s%s',
        'This address is registered as system address and cannot be used: %s' =>
            'Ova adresa je registrovana kao sistemska i ne može biti korišćena: %s',
        'Please include at least one recipient' => 'Molimo da uključite bar jednog primaoca',
        'Select one or more recipients from the customer user address book.' =>
            'Odaberite jednog ili više primaoca iz adresara klijent korisnika.',
        'Customer user address book' => 'Adresar klijent korisnika',
        'Remove Ticket Customer' => 'Ukloni klijent sa tiketa **',
        'Please remove this entry and enter a new one with the correct value.' =>
            'Molimo da uklonite ovaj unos i unesete nov sa ispravnom vrednošću.',
        'This address already exists on the address list.' => 'Ova adresa već postoji u listi.',
        'Remove Cc' => 'Ukloni Cc',
        'Bcc' => 'Bcc',
        'Remove Bcc' => 'Ukloni Bcc',
        'Date Invalid!' => 'Neispravan datum!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketCustomer.tt
        'Change Customer of %s%s%s' => 'Promeni klijenta za %s%s%s',
        'Customer Information' => 'Informacije o klijentu',
        'Customer user' => 'Klijent korisnik',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketEmail.tt
        'Create New Email Ticket' => 'Otvori novi imejl tiket',
        'Example Template' => 'Primer šablona',
        'From queue' => 'iz reda',
        'To customer user' => 'Za klijenta korisnika',
        'Please include at least one customer user for the ticket.' => 'Molimo vas uključite barem jednog klijenta korisnika za tiket.',
        'Select this customer as the main customer.' => 'Označi ovog klijenta kao glavnog klijenta.',
        'Remove Ticket Customer User' => 'Ukloni tiket klijenta korisnika **',
        'Get all' => 'Uzmi sve',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketEmailOutbound.tt
        'Outbound Email for %s%s%s' => 'Odlazni imejl za %s%s%s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketEmailResend.tt
        'Resend Email for %s%s%s' => 'Pošalji ponovo imejl za %s %s %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketEscalation.tt
        'Ticket %s: first response time is over (%s/%s)!' => 'Tiket %s: vreme odziva je isteklo (%s/%s)!',
        'Ticket %s: first response time will be over in %s/%s!' => 'Tiket %s: vreme odziva će isteći za %s/%s!',
        'Ticket %s: update time is over (%s/%s)!' => 'Tiket %s: vreme ažuriranja je preko (%s/%s)!',
        'Ticket %s: update time will be over in %s/%s!' => 'Tiket %s: vreme ažuriranja ističe za %s/%s!',
        'Ticket %s: solution time is over (%s/%s)!' => 'Tiket %s: vreme rešavanja je isteklo (%s/%s)!',
        'Ticket %s: solution time will be over in %s/%s!' => 'Tiket %s: vreme rešavanja ističe za %s/%s!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketForward.tt
        'Forward %s%s%s' => 'Prosledi %s%s%s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketHistory.tt
        'History of %s%s%s' => 'Istorijat od %s%s%s',
        'Filter for history items' => 'Filter za stavke istorijata',
        'Expand/collapse all' => 'Proširi/skupi sve',
        'CreateTime' => 'Vreme kreiranja',
        'Article' => 'Članak',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketMerge.tt
        'Merge %s%s%s' => 'Spoji %s%s%s',
        'Merge Settings' => 'Podešavanja spajanja',
        'You need to use a ticket number!' => 'Molimo vas da koristite broj tiketa!',
        'A valid ticket number is required.' => 'Neophodan je ispravan broj tiketa.',
        'Try typing part of the ticket number or title in order to search by it.' =>
            'Unesite deo broja ili naslova tiketa za pretragu.',
        'Limit the search to tickets with same Customer ID (%s).' => 'Ograničite pretragu na tikete sa istim ID klijenta (%s).',
        'Inform Sender' => 'Obavesti pošiljaoca',
        'Need a valid email address.' => 'Potrebna je ispravna imejl adresa.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketMove.tt
        'Move %s%s%s' => 'Premesti %s%s%s',
        'New Queue' => 'Novi Red',
        'Move' => 'Premesti',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketNoteToLinkedTicket.tt
        'Add note to linked %s%s%s' => '',
        'Note to linked Ticket' => '',
        'LinkList invalid.' => '',
        'Note to origin Ticket' => '',
        'NoteToTicket invalid.' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketOverviewMedium.tt
        'No ticket data found.' => 'Nisu nađeni podaci o tiketu',
        'Open / Close ticket action menu' => 'Akcioni meni Otvaranja / Zatvaranja tiketa',
        'Select this ticket' => 'Izaberite ovaj tiket',
        'Sender' => 'Pošiljaoc',
        'First Response Time' => 'Vreme prvog odgovora',
        'Update Time' => 'Vreme ažuriranja',
        'Solution Time' => 'Vreme rešavanja',
        'Impact' => 'Uticaj',
        'CustomerID' => 'ID klijenta',
        'Move ticket to a different queue' => 'Premesti tiket u drugi red',
        'Change queue' => 'Promeni red',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketOverviewNavBar.tt
        'Remove active filters for this screen.' => 'Ukloni aktivne filtere za ovaj ekran.',
        'Remove mention' => '',
        'Tickets per page' => 'Tiketa po strani',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketOverviewPreview.tt
        'Missing channel' => 'Nedostaje kanal',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketOverviewSmall.tt
        'Reset overview' => 'Poništi pregled',
        'Column Filters Form' => 'Forma filtera kolona',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketPhone.tt
        'Split Into New Phone Ticket' => 'Podeli u novi tiket poziva',
        'Save Chat Into New Phone Ticket' => 'Sačuvaj ćaskanje u novi tiket poziva',
        'Create New Phone Ticket' => 'Otvori novi tiket poziva',
        'Please include at least one customer for the ticket.' => 'Molimo da uključite bar jednog klijenta za tiket.',
        'To queue' => 'U red',
        'Chat protocol' => 'Protokol ćaskanja',
        'The chat will be appended as a separate article.' => 'Ćaskanje će biti dodato kao poseban članak.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketPhoneCommon.tt
        'Phone Call for %s%s%s' => 'Poziv za %s%s%s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketPlain.tt
        'View Email Plain Text for %s%s%s' => 'Prikaz imejla kao običan tekst za %s%s%s',
        'Plain' => 'Neformatirano',
        'Download this email' => 'Preuzmi ovu poruku',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketProcess.tt
        'Create New Process Ticket' => 'Napravi novi proces tiket',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketProcessSmall.tt
        'Enroll Ticket into a Process' => 'Priključi tiket procesu',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketSearch.tt
        'Profile link' => 'Veza profila',
        'Output' => 'Pregled rezultata',
        'Fulltext' => 'Tekst',
        'Customer ID (complex search)' => 'ID klijenta (složena pretraga)',
        '(e. g. 234*)' => '(npr. 234*)',
        'Customer ID (exact match)' => 'ID klijenta (tačno poklapanje)',
        'Assigned to Customer User Login (complex search)' => 'Dodeljeno klijent korisniku (složena pretraga)',
        '(e. g. U51*)' => '(npr.  U51*)',
        'Assigned to Customer User Login (exact match)' => 'Dodeljeno klijent korisniku (tačno poklapanje)',
        'Accessible to Customer User Login (exact match)' => 'Vidljivo klijent korisniku (tačno poklapanje)',
        'Created in Queue' => 'Otvoreno u redu',
        'Lock state' => 'Staus zaključavanja',
        'Watcher' => 'Praćenje',
        'Article Create Time (before/after)' => 'Vreme kreiranja članka (pre/posle)',
        'Article Create Time (between)' => 'Vreme kreiranja članka (između)',
        'Please set this to value before end date.' => 'Molimo postavite ovaj datum pre kraja.',
        'Please set this to value after start date.' => 'Molimo postavite ovaj datum posle početka.',
        'Ticket Create Time (before/after)' => 'Vreme otvaranja tiketa (pre/posle)',
        'Ticket Create Time (between)' => 'Vreme otvaranja tiketa (između)',
        'Ticket Change Time (before/after)' => 'Vreme promene tiketa (pre/posle)',
        'Ticket Change Time (between)' => 'Vreme promene tiketa (između)',
        'Ticket Last Change Time (before/after)' => 'Vreme poslednje promene tiketa (pre/posle)',
        'Ticket Last Change Time (between)' => 'Vreme poslednje promene tiketa (između)',
        'Ticket Pending Until Time (before/after)' => 'Vreme tiketa na čekanju (pre/posle)',
        'Ticket Pending Until Time (between)' => 'Vreme tiketa na čekanju (između)',
        'Ticket Close Time (before/after)' => 'Vreme zatvaranja tiketa (pre/posle)',
        'Ticket Close Time (between)' => 'Vreme zatvaranja tiketa (između)',
        'Ticket Escalation Time (before/after)' => 'Vreme eskalacije tiketa (pre/posle)',
        'Ticket Escalation Time (between)' => 'Vreme eskalacije tiketa (između)',
        'Archive Search' => 'Pretraga arhiva',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketZoom.tt
        'Sender Type' => 'Tip pošiljaoca',
        'Save filter settings as default' => 'Sačuvaj podešavanja filtera kao podrazumevana',
        'Event Type' => 'Tip događaja',
        'Save as default' => 'Sačuvaj kao podrazumevano',
        'Drafts' => 'Nacrti',
        'by' => 'od',
        'Change Queue' => 'Promeni Red',
        'There are no dialogs available at this point in the process.' =>
            'U ovom trenutku nema slobodnih dijaloga u procesu.',
        'This item has no articles yet.' => 'Ova stavka još uvek nema člkanke.',
        'Ticket Timeline View' => 'Pregled tiketa na vremenskoj liniji',
        'Article Overview - %s Article(s)' => 'Pregled članaka - %s članak(a)',
        'Page %s' => 'Strana %s',
        'Add Filter' => 'Dodaj Filter',
        'Set' => 'Podesi',
        'Reset Filter' => 'Resetuj Filter',
        'No.' => 'Br.',
        'Unread articles' => 'Nepročitani članci',
        'Via' => 'Preko',
        'Important' => 'Važno',
        'Unread Article!' => 'Nepročitani Članci!',
        'Incoming message' => 'Dolazna poruka',
        'Outgoing message' => 'Odlazna poruka',
        'Internal message' => 'Interna poruka',
        'Sending of this message has failed.' => 'Slanje ove poruke nije uspelo.',
        'Resize' => 'Promena veličine',
        'Mark this article as read' => 'Označi ovaj članak kao pročitan',
        'Show Full Text' => 'Prikaži ceo tekst',
        'Full Article Text' => 'Tekst celog članka',
        'No more events found. Please try changing the filter settings.' =>
            'Nema više događaja. Pokušajte da promenite podešavanja filtera.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketZoom/ArticleRender/Chat.tt
        '#%s' => '#%s',
        'via %s' => 'preko %s',
        'by %s' => 'od strane %s',
        'Toggle article details' => 'Preklopi detalje članka',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketZoom/ArticleRender/MIMEBase.tt
        'This message is being processed. Already tried to send %s time(s). Next try will be %s.' =>
            'Ova poruka se procesira. Slanje je pokušano već %s put(a). Sledeći pokušaj biće u %s.',
        'This message contains events' => '',
        'This message contains an event' => '',
        'Show more information' => '',
        'Start: %s, End: %s' => '',
        'Calendar events details' => '',
        'Calendar event details' => '',
        'To open links in the following article, you might need to press Ctrl or Cmd or Shift key while clicking the link (depending on your browser and OS).' =>
            'Da otvorite veze u ovom članku, možda ćete morati da pritisnete Ctrl ili Cmd ili Shift taster dok kliknete na vezu (zavisi od vašeg pregledača i operativnog sistema). ',
        'Close this message' => 'Zatvori ovu poruku',
        'Image' => 'Slika',
        'PDF' => 'PDF',
        'Unknown' => 'Nepoznato',
        'View' => 'Pregled',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketZoom/LinkTable.tt
        'Linked Objects' => 'Povezani objekti',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketZoom/MentionsTable.tt
        'Mentions' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AgentTicketZoom/TicketInformation.tt
        'Archive' => 'Arhiviraj',
        'This ticket is archived.' => 'Ovaj tiket je arhiviran',
        'Note: Type is invalid!' => 'Napomena: tip je nevažeći!',
        'Pending till' => 'Na čekanju do',
        'Locked' => 'Zaključano',
        '%s Ticket(s)' => '%s tiket(a)',
        'Accounted time' => 'Obračunato vreme',

        # TT Template: Kernel/Output/HTML/Templates/Standard/ArticleContent/Invalid.tt
        'Preview of this article is not possible because %s channel is missing in the system.' =>
            'Pregled ovog članka nije moguć jer %s kanal nedostaje u sistemu.',
        'This feature is part of the %s. Please contact us at %s for an upgrade.' =>
            'Ovo svojstvo je deo %s. Molimo da nas kontaktirate na %s za ažuriranje.',
        'Please re-install %s package in order to display this article.' =>
            'Molimo ponovo instalirajte paket %s za prikaz ovog članka.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/AttachmentBlocker.tt
        'To protect your privacy, remote content was blocked.' => 'Da biste zaštitili svoju privatnost, udaljeni sadržaj je blokiran.',
        'Load blocked content.' => 'Učitaj blokirani sadržaj.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Breadcrumb.tt
        'Home' => 'Početna',
        'Back to admin overview' => 'Nazan na administratorski pregled',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Calendar/Plugin/Ticket/Create.tt
        'Ticket Creation' => '',
        'Link' => 'Poveži',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Calendar/Plugin/Ticket/Link.tt
        'Remove entry' => 'Ukloni unos',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CloudServicesDisabled.tt
        'This Feature Requires Cloud Services' => 'Ova funkcija zahteva servise u oblaku',
        'You can' => 'Vi možete',
        'go back to the previous page' => 'idi na prethodnu stranu',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerAccept.tt
        'Dear Customer,' => 'Dragi klijente,',
        'thank you for using our services.' => 'hvala vam na korišćenju naših usluga.',
        'Yes, I accept your license.' => 'Da, prihvatam vašu licencu.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerCompany/TicketCustomerIDSelection.tt
        'The customer ID is not changeable, no other customer ID can be assigned to this ticket.' =>
            'ID klijenta ne može biti promenjen, nijedan drugi ID ne može biti dodeljen ovom tiketu.',
        'First select a customer user, then you can select a customer ID to assign to this ticket.' =>
            'Prvo odaberite klijent korisnika, onda možete odabrati ID klijenta za dodelu ovom tiketu.',
        'Select a customer ID to assign to this ticket.' => 'Odaberite ID klijenta za dodelu ovom tiketu.',
        'From all Customer IDs' => 'Iz liste svih ID klijenta',
        'From assigned Customer IDs' => 'Iz liste dodeljenih ID klijenta',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerError.tt
        'An Error Occurred' => 'Dogodila se greška',
        'Error Details' => 'Detalji greške',
        'Traceback' => 'Isprati unazad',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerFooter.tt
        'Powered by %s' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerFooterJS.tt
        '%s detected possible network issues. You could either try reloading this page manually or wait until your browser has re-established the connection on its own.' =>
            '%s je detektovao moguće probleme sa vašom mrežnom vezom. Možete pokušati da ručno osvežite ovu stranicu ili da sačekate da vaš pregledač sam ponovo uspostavi vezu.',
        'The connection has been re-established after a temporary connection loss. Due to this, elements on this page could have stopped to work correctly. In order to be able to use all elements correctly again, it is strongly recommended to reload this page.' =>
            'Veza je ponovo uspostavljena nakon privremenog prekida. Zbog toga, elementi na ovoj stranici su mogli da prestanu da korektno funkcionišu. Da bi sve elemente mogli ponovo normalno da koristite, preporučujemo obavezno osvežavanje ove stranice. ',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerLogin.tt
        'JavaScript Not Available' => 'JavaScript nije dostupan.',
        'In order to experience this software, you\'ll need to enable JavaScript in your browser.' =>
            'Kako bi ste koristili aplikaciju, neophodno je da aktivirate JavaScript u vašem veb pretraživaču.',
        'Browser Warning' => 'Upozorenje veb pretraživača',
        'The browser you are using is too old.' => 'Veb pretraživač koji koristite je previše star.',
        'This software runs with a huge lists of browsers, please upgrade to one of these.' =>
            'Ova aplikacija funkcioniše na velikom broju veb pretraživača, molimo da instalirate i koristite jedan od ovih.',
        'Please see the documentation or ask your admin for further information.' =>
            'Molimo da pregledate dokumentaciju ili pitate vašeg administratora za dodatne informacije.',
        'One moment please, you are being redirected...' => 'Sačekajte momenat, bićete preusmereni...',
        'Login' => 'Prijavljivanje',
        'User name' => 'Korisničko ime',
        'Your user name' => 'Vaše korisničko ime',
        'Your password' => 'Vaša lozinka',
        'Forgot password?' => 'Zaboravili ste lozinku?',
        '2 Factor Token' => 'Dvofaktorski token',
        'Your 2 Factor Token' => 'Vaš dvofaktorski token',
        'Log In' => 'Prijavljivanje',
        'Not yet registered?' => 'Niste registrovani?',
        'Sign up now' => 'Registrujte se sada',
        'Back' => 'Nazad',
        'Request New Password' => 'Zahtev za novu lozinku',
        'Your User Name' => 'Vaše korisničko ime',
        'A new password will be sent to your email address.' => 'Nova lozinka će biti poslata na vašu imejl adresu.',
        'Create Account' => 'Kreirajte nalog',
        'Please fill out this form to receive login credentials.' => 'Molimo da popunite ovaj obrazac da bi ste dobili podatke za prijavu.',
        'How we should address you' => 'Kako da vas oslovljavamo',
        'Your First Name' => 'Vaše ime',
        'Your Last Name' => 'Vaše prezime',
        'Your email address (this will become your username)' => 'Vaša imejl adresa (to će biti vaše korisničko ime)',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerNavigationBar.tt
        'Incoming Chat Requests' => 'Dolazni zahtevi za ćaskanje',
        'Edit personal preferences' => 'Uredi lične postavke',
        'Logout %s' => 'Odjava %s',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerTicketMessage.tt
        'Service level agreement' => 'Sporazum o nivou usluge',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerTicketOverview.tt
        'Welcome!' => 'Dobrodošli!',
        'Please click the button below to create your first ticket.' => 'Molimo da pritisnete dugme ispod za kreiranje vašeg prvog tiketa.',
        'Create your first ticket' => 'Kreirajte vaš prvi tiket',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerTicketSearch.tt
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => 'npr. 10*5155 ili 105658*',
        'Fulltext Search in Tickets (e. g. "John*n" or "Will*")' => 'Tekstualno pretraživanje u tiketima (npr. "John*n" ili "Will*")',
        'Types' => 'Tipovi',
        'Time Restrictions' => 'Vremenska ograničenja',
        'No time settings' => 'Nema podešavanja vremena',
        'All' => 'Sve',
        'Specific date' => 'Određeni datum',
        'Only tickets created' => 'Samo kreirani tiketi',
        'Date range' => 'Raspon datuma',
        'Only tickets created between' => 'Samo tiketi kreirani između',
        'Ticket Archive System' => 'Sistem za arhiviranje tiketa',
        'Save Search as Template?' => 'Sačuvaj pretragu kao šablon?',
        'Save as Template?' => 'Sačuvati kao šablon?',
        'Save as Template' => 'Sačuvaj kao šablon',
        'Template Name' => 'Naziv šablona',
        'Pick a profile name' => 'Izaberi naziv profila',
        'Output to' => 'Izlaz na',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerTicketSearchResultShort.tt
        'of' => 'od',
        'Page' => 'Strana',
        'Search Results for' => 'Rezultati pretraživanja za',
        'Remove this Search Term.' => 'Ukloni ovaj izraz za pretragu.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerTicketZoom.tt
        'Start a chat from this ticket' => 'Počni ćaskanje iz ovog tiketa',
        'Next Steps' => 'Sledeći koraci',
        'Reply' => 'Odgovori',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerTicketZoom/ArticleRender/Chat.tt
        'Expand article' => 'Raširi članak',

        # TT Template: Kernel/Output/HTML/Templates/Standard/CustomerWarning.tt
        'Warning' => 'Upozorenje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/DashboardEventsTicketCalendar.tt
        'Event Information' => 'Informacije o događaju',
        'Ticket fields' => 'Polja tiketa',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Error.tt
        'Expand' => 'Proširi',

        # TT Template: Kernel/Output/HTML/Templates/Standard/FormElements/AttachmentList.tt
        'Click to delete this attachment.' => 'Kliknite ovde da obrišete prilog.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/FormElements/DraftButtons.tt
        'Update draft' => 'Ažuriraj nacrt',
        'Save as new draft' => 'Sačuvaj kao novi nacrt',

        # TT Template: Kernel/Output/HTML/Templates/Standard/FormElements/DraftNotifications.tt
        'You have loaded the draft "%s".' => 'Već ste učitali nacrt "%s".',
        'You have loaded the draft "%s". You last changed it %s.' => 'Već ste učitali nacrt "%s". Poslednji put ste ga promenili u %s.',
        'You have loaded the draft "%s". It was last changed %s by %s.' =>
            'Već ste učitali nacrt "%s". Poslednji put je promenjen u %s od strane %s.',
        'Please note that this draft is outdated because the ticket was modified since this draft was created.' =>
            'Molimo obratite pažnju da je ovaj nacrt zastareo jer je tiket modifikovan od kada je nacrt kreiran.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Header.tt
        'View notifications' => 'Pregled obaveštenja',
        'Personal preferences' => 'Lična podešavanja',
        'Logout' => 'Odjava',
        'You are logged in as' => 'Prijavljeni ste kao',
        'Last viewed' => '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Installer.tt
        'JavaScript not available' => 'JavaScript nije dostupan.',
        'Step %s' => 'Korak %s',
        'License' => 'Licenca',
        'Database Settings' => 'Podešavanje baze podataka',
        'General Specifications and Mail Settings' => 'Opšte specifikacije i podešavanje pošte',
        'Finish' => 'Završi',
        'Welcome to %s' => 'Dobrodošli u %s',
        'Phone' => 'Poziv',
        'Web site' => 'Veb sajt',
        'Community' => '',
        'Next' => 'Sledeće',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerConfigureMail.tt
        'Configure Outbound Mail' => 'Podešavanje odlazne pošte',
        'Outbound mail type' => 'Tip odlazne pošte',
        'Select outbound mail type.' => 'Izaberite tip odlazne pošte',
        'Outbound mail port' => 'Port za odlaznu poštu',
        'Select outbound mail port.' => 'Izaberite port za odlaznu poštu',
        'SMTP host' => 'SMTP server',
        'SMTP host.' => 'SMTP server.',
        'SMTP authentication' => 'SMTP autentifikacija',
        'Does your SMTP host need authentication?' => 'Da li vaš SMTP server zahteva autentifikaciju?',
        'SMTP auth user' => 'SMTP korisnik',
        'Username for SMTP auth.' => 'Korisničko ime za SMTP autentifikaciju',
        'SMTP auth password' => 'Lozinka SMTP autentifikacije',
        'Password for SMTP auth.' => 'Lozinka za SMTP autentifikaciju',
        'Configure Inbound Mail' => 'Podešavanje dolazne pošte',
        'Inbound mail type' => 'Tip dolazne pošte',
        'Select inbound mail type.' => 'Izaberi tip dolazne pošte',
        'Inbound mail host' => 'Server dolazne pošte',
        'Inbound mail host.' => 'Server dolazne pošte.',
        'Inbound mail user' => 'Korisnik dolazne pošte',
        'User for inbound mail.' => 'Korisnik za dolaznu poštu.',
        'Inbound mail password' => 'Lozinka dolazne pošte',
        'Password for inbound mail.' => 'Lozinka za dolaznu poštu.',
        'Result of mail configuration check' => 'Rezultat provere podešavanja pošte',
        'Check mail configuration' => 'Proveri konfiguraciju mejla',
        'Skip this step' => 'Preskoči ovaj korak',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerDBResult.tt
        'Done' => 'Urađeno',
        'Error' => 'Greška',
        'Database setup successful!' => 'Uspešno instaliranje baze',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerDBStart.tt
        'Install Type' => 'Instaliraj tip',
        'Create a new database for OTRS' => 'Kreiraj novu bazu podataka za OTRS',
        'Use an existing database for OTRS' => 'Koristi postojeću bazu podataka za OTRS',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerDBmssql.tt
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty.' =>
            'Ako ste postavili rut lozinku za vašu bazu podataka, ona mora biti uneta ovde. Ako niste, ovo polje ostavite prazno.',
        'Database name' => 'Naziv baze podataka',
        'Check database settings' => 'Proverite podešavanja baze',
        'Result of database check' => 'Rezultat provere baze podataka',
        'Database check successful.' => 'Uspešna provera baze podataka.',
        'Database User' => 'Korisnik baze podataka',
        'New' => 'Novo',
        'A new database user with limited permissions will be created for this OTRS system.' =>
            'Novi korisnik baze sa ograničenim pravima će biti kreiran za ovaj OTRS sistem.',
        'Repeat Password' => 'Ponovi lozinku',
        'Generated password' => 'Generisana lozinka',
        'Database' => 'Baza podataka',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerDBmysql.tt
        'Passwords do not match' => 'Lozinke se ne poklapaju',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerDBoracle.tt
        'SID' => 'SID',
        'Port' => 'Port',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerFinish.tt
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' =>
            'Da bi ste koristili OTRS morate uneti sledeće u komandnu liniju (Terminal/Shell) kao root.',
        'Restart your webserver' => 'Ponovo pokrenite vaš veb server.',
        'After doing so your OTRS is up and running.' => 'Posle ovoga vaš OTRS je uključen i radi.',
        'Start page' => 'Početna strana',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerLicense.tt
        'Don\'t accept license' => 'Ne prihvataj licencu',
        'Accept license and continue' => 'Prihvati licencu i nastavi',

        # TT Template: Kernel/Output/HTML/Templates/Standard/InstallerSystem.tt
        'SystemID' => 'Sistemski ID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' =>
            'Sistemski identifikator. Svaki broj tiketa i svaki ID HTTP sesije sadrži ovaj broj.',
        'System FQDN' => 'Sistemski FQDN',
        'Fully qualified domain name of your system.' => 'Pun naziv domena vašeg sistema',
        'AdminEmail' => 'Administrativni imejl',
        'Email address of the system administrator.' => 'Imejl adresa sistem administratora.',
        'Organization' => 'Organizacija',
        'Log' => 'Log',
        'LogModule' => 'Log modul',
        'Log backend to use.' => 'Log modul u upotrebi.',
        'LogFile' => 'Log datoteka',
        'Webfrontend' => 'Mrežni interfejs',
        'Default language' => 'Podrazumevani jezik',
        'Default language.' => 'Podrazumevani jezik',
        'CheckMXRecord' => 'Proveri MX podatke',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' =>
            'Ručno uneta imejl adresa se proverava pomoću MX podatka pronađenog u DNS. Nemojte koristiti ovu opciju ako je vaš DNS spor ili ne može da razreši javne adrese.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/LinkObject.tt
        'Delete link' => 'Obriši vezu',
        'Delete Link' => 'Obriši vezu',
        'Object#' => 'Objekat#',
        'Add links' => 'Dodaj veze',
        'Delete links' => 'Obriši veze',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Login.tt
        'Lost your password?' => 'Izgubili ste lozinku?',
        'Back to login' => 'Nazad na prijavljivanje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/MetaFloater.tt
        'Scale preview content' => 'Skaliraj sadržaj za prikaz',
        'Open URL in new tab' => 'Otvori URL u novom listu',
        'Close preview' => 'Zatvori pregled',
        'A preview of this website can\'t be provided because it didn\'t allow to be embedded.' =>
            'Pregled ove veb stranice nije moguć jer ona ne dozvoljava da bude ugrađena.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/MobileNotAvailableWidget.tt
        'Feature not Available' => 'Svojstvo nije dostupno',
        'Sorry, but this feature of OTRS is currently not available for mobile devices. If you\'d like to use it, you can either switch to desktop mode or use your regular desktop device.' =>
            'Na žalost, ovo svojstvo momentalno nije dostupno za mobilne uređaje. Ako želite da ga koristite, možete de vratiti na desktop mod ili koristiti standardni desktop uređaj.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Motd.tt
        'Message of the Day' => 'Današnja poruka',
        'This is the message of the day. You can edit this in %s.' => 'Ovo je dnevna poruka. Možete je urediti u %s.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/NoPermission.tt
        'Insufficient Rights' => 'Nedovoljna ovlaštenja',
        'Back to the previous page' => 'Vratite se na prethodnu stranu',

        # TT Template: Kernel/Output/HTML/Templates/Standard/NotificationEvent/Email/Alert.tt
        'Alert' => 'Upozorenje',
        'Powered by' => 'Pokreće',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Pagination.tt
        'Show first page' => 'Pokaži prvu stranu',
        'Show previous pages' => 'Pokaži prethodne strane',
        'Show page %s' => 'Pokaži stranu %s',
        'Show next pages' => 'Pokaži sledeće strane',
        'Show last page' => 'Pokaži poslednju stranu',

        # TT Template: Kernel/Output/HTML/Templates/Standard/PictureUpload.tt
        'Need FormID!' => 'Neophodan FormID!',
        'No file found!' => 'Datoteka nije pronađena!',
        'The file is not an image that can be shown inline!' => 'Datoteka nije slika koja se može neposredno prikazati!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/PreferencesNotificationEvent.tt
        'No user configurable notifications found.' => 'Nisu pronađena obaveštenja koja korisnik može da podesi.',
        'Receive messages for notification \'%s\' by transport method \'%s\'.' =>
            'Primite poruke za obaveštavanje \'%s\' prenete putem \'%s\'.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/ProcessManagement/ActivityDialogHeader.tt
        'Process Information' => 'Informacije o procesu',
        'Dialog' => 'Dijalog',

        # TT Template: Kernel/Output/HTML/Templates/Standard/ProcessManagement/Article.tt
        'Inform Agent' => 'Obavesti operatera',

        # TT Template: Kernel/Output/HTML/Templates/Standard/PublicDefault.tt
        'Welcome' => 'Dobrodošli',
        'This is the default public interface of OTRS! There was no action parameter given.' =>
            'Ovo je podrazumevani javni interfejs za OTRS! Nema datih akcionih parametara.',
        'You could install a custom public module (via the package manager), for example the FAQ module, which has a public interface.' =>
            'Možete instalirati dodatni modul (vidite upravljanje paketima), npr. FAQ, koji ima javni interfejs.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SmartTags/AdminAppointmentNotificationEvent.tt
        'To get the appointment attribute' => 'Da vidite atribute termina',
        ' e. g.' => ' npr.',
        'To get the first 20 character of the appointment title.' => 'Da vidite prvih 20 karaktera naslova termina.',
        'To get the calendar attribute' => 'Da vidite atribute kalendara',
        'Attributes of the recipient user for the notification' => 'Atributi korisnika primaoca za obaveštenje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SmartTags/AdminAutoResponse.tt
        'To get the first 20 character of the subject.' => 'Da vidite prvih 20 slova predmeta.',
        'To get the first 5 lines of the email.' => 'Da vidite prvih 5 linija imejla.',
        'To get the name of the ticket\'s customer user (if given).' => 'Da pribavite naziv klijenta korisnika za tiket (ako je dat).',
        'To get the article attribute' => 'Da vidite atribute članka',
        'Options of the current customer user data' => 'Opcije podataka o aktuelnom klijentu korisniku',
        'Ticket owner options' => 'Opcije vlasnika tiketa',
        'Options of the ticket data' => 'Opcije podataka o tiketu',
        'Options of ticket dynamic fields internal key values' => 'Opcije za vrednosti internih ključeva dinamičkih polja tiketa',
        'Options of ticket dynamic fields display values, useful for Dropdown and Multiselect fields' =>
            'Opcije za prikazane vrednosti dinamičkih polja tiketa, korisno za polja Dropdown i Multiselect',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SmartTags/AdminNotificationEvent.tt
        'To get the first 20 character of the subject (of the latest agent article).' =>
            'Da vidite prvih 20 slova predmeta (poslednjeg članka operatera).',
        'To get the first 5 lines of the body (of the latest agent article).' =>
            'Da vidite prvih 5 linija poruke (poslednjeg članka operatera).',
        'To get the first 20 character of the subject (of the latest customer article).' =>
            'Da vidite prvih 20 slova predmeta (poslednjeg članka klijenta).',
        'To get the first 5 lines of the body (of the latest customer article).' =>
            'Da vidite prvih 5 linija poruke (poslednjeg članka klijenta).',
        'Attributes of the current customer user data' => 'Atributi podataka aktuelnog klijenta korisnika',
        'Attributes of the current ticket owner user data' => 'Atributi podataka korisnika vlasnika aktuelnog tiketa',
        'Attributes of the ticket data' => 'Atributi podataka tiketa',
        'Ticket dynamic fields internal key values' => 'Vrednosti internih ključeva dinamičkih polja tiketa',
        'Ticket dynamic fields display values, useful for Dropdown and Multiselect fields' =>
            'Prikazane vrednosti dinamičkih polja, korisno za padajuća i polja sa višestrukim izborom',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SmartTags/AdminSalutation.tt
        'e. g.' => 'npr.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SmartTags/AdminTemplate.tt
        'To get the first 20 characters of the subject of the current/latest agent article (current for Answer and Forward, latest for Note template type). This tag is not supported for other template types.' =>
            '',
        'To get the first 5 lines of the body of the current/latest agent article (current for Answer and Forward, latest for Note template type). This tag is not supported for other template types.' =>
            '',
        'To get the first 20 characters of the subject of the current/latest article (current for Answer and Forward, latest for Note template type). This tag is not supported for other template types.' =>
            '',
        'To get the first 5 lines of the body of the current/latest article (current for Answer and Forward, latest for Note template type). This tag is not supported for other template types.' =>
            '',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SmartTags/Default.tt
        'Tag Reference' => 'Referenca oznake',
        'You can use the following tags' => 'Možete koristiti sledeće oznake',
        'Ticket responsible options' => 'Opcije odgovornog za tiket',
        'Options of the current user who requested this action' => 'Opcije aktuelnog korisnika koji je tražio ovu akciju',
        'Config options' => 'Konfiguracione opcije',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Statistics/GeneralSpecificationsWidget.tt
        'You can select one or more groups to define access for different agents.' =>
            'Možete izabrati jednu ili više grupa za definisanje pristupa za različite operatere.',
        'Result formats' => 'Format rezultata',
        'Time Zone' => 'Vremenska zona',
        'The selected time periods in the statistic are time zone neutral.' =>
            'Izabrani vremenski periodi u statistici su neutralni po pitanju vremenske zone.',
        'Create summation row' => 'Kreiraj red sa zbirom',
        'Generate an additional row containing sums for all data rows.' =>
            'Generiši dodatni red koji sadrži sume za sve redove sa podacima.',
        'Create summation column' => 'Kreiraj kolonu sa zbirom',
        'Generate an additional column containing sums for all data columns.' =>
            'Generiši dodatnu kolonu koja sadrži sume za sve kolone sa podacima.',
        'Cache results' => 'Keširaj rezultate',
        'Stores statistics result data in a cache to be used in subsequent views with the same configuration (requires at least one selected time field).' =>
            'Čuva rezultate statistika u kešu za korišćenje u sledećim pregledima sa istim podešavanjima (zahteva izabrano bar jedno vremensko polje).',
        'Provide the statistic as a widget that agents can activate in their dashboard.' =>
            'Omogući statistiku kao dodatak koji opertateri mogu aktivirati u svojoj kontrolnoj tabli.',
        'Please note that enabling the dashboard widget will activate caching for this statistic in the dashboard.' =>
            'Napominjemo da će omogućavanje dodatka keširati ovu statistiku na kontrolnoj tabli.',
        'If set to invalid end users can not generate the stat.' => 'Ako je podešeno na nevažeće, krajnji korisnici ne mogu generisati statistiku.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Statistics/PreviewWidget.tt
        'There are problems in the configuration of this statistic:' => 'Postoje neki problemi u podešavanju ove statistike:',
        'You may now configure the X-axis of your statistic.' => 'Sada možete podesiti X osu vaše statistike.',
        'This statistic does not provide preview data.' => 'Ova statistika ne omogućava privremeni prikaz.',
        'Preview format' => 'Format prikaza',
        'Please note that the preview uses random data and does not consider data filters.' =>
            'Napominjemo da prikaz koristi nasumično izabrane podatke i ne uzima u obzir filtere podataka.',
        'Configure X-Axis' => 'Podesi X osu',
        'X-axis' => 'H-osa',
        'Configure Y-Axis' => 'Podesi Y osu',
        'Y-axis' => 'Y-osa',
        'Configure Filter' => 'Podesi filter',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Statistics/RestrictionsWidget.tt
        'Please select only one element or turn off the button \'Fixed\'.' =>
            'Molimo da izaberete samo jedan element ili isključite dugme \'fiksirano\'!',
        'Absolute period' => 'Apsolutni period',
        'Between %s and %s' => 'Između %s i %s',
        'Relative period' => 'Relativni period',
        'The past complete %s and the current+upcoming complete %s %s' =>
            'Kompletna prošlost %s i kompletna trenutna+buduća %s %s',
        'Do not allow changes to this element when the statistic is generated.' =>
            'Onemogući promene ovog elementa pri generisanju statistike.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Statistics/StatsParamsWidget.tt
        'Format' => 'Format',
        'Exchange Axis' => 'Zameni ose',
        'Configurable Params of Static Stat' => 'Podesivi parametri statičke statistike',
        'No element selected.' => 'Nije izabran ni jedan element.',
        'Scale' => 'Skala',
        'show more' => 'prikaži više',
        'show less' => 'prikaži manje',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Statistics/StatsResultRender/D3.tt
        'Download SVG' => 'Preuzmi SVG',
        'Download PNG' => 'Preuzme PNG',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Statistics/XAxisWidget.tt
        'The selected time period defines the default time frame for this statistic to collect data from.' =>
            'Odabrani vremenski period definiše podrazumevan vremenski okvir za prikupljanje podataka statistike.',
        'Defines the time unit that will be used to split the selected time period into reporting data points.' =>
            'Definiše vremensku jedinicu koja se koristi za podelu izabranog vremenskog perioda u pojedinačne tačke na izveštaju.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Statistics/YAxisWidget.tt
        'Please remember that the scale for the Y-axis has to be larger than the scale for the X-axis (e.g. X-axis => Month, Y-Axis => Year).' =>
            'Molimo zapamtite, da skala za Y-osu treba da bude veća od skale za H-osu (npr. H-Osa => mesec; Y-osa => godina).',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SystemConfiguration/SettingsList.tt
        'This setting is disabled.' => 'Ovo podešavanje je isključeno.',
        'This setting is fixed but not deployed yet!' => 'Ovo podešavanje je statičko, ali nije još raspoređeno!',
        'This setting is currently being overridden in %s and can\'t thus be changed here!' =>
            'Ovo podešavanje je trenutno pregaženo u %s i ne može biti izmenjeno ovde!',
        'Changing this setting is only available in a higher config level!' =>
            'Promena ovog podešavanja je moguća samo u naprednom konfiguracionom modu.',
        '%s (%s) is currently working on this setting.' => '%s (%s) trenutno radi na ovom podešavanju.',
        'Toggle advanced options for this setting' => 'Preklopi napredne opcije za ovo podešavanje',
        'Disable this setting, so it is no longer effective' => 'Isključi ovo podešavanje, tako da više nije efektivno',
        'Disable' => 'Isključi',
        'Enable this setting, so it becomes effective' => 'Uključi ovo podešavanje, tako da postane efektivno',
        'Enable' => 'Uključi',
        'Reset this setting to its default state' => 'Poništi ovo podešavanje na podrazumevanu vrednost',
        'Reset setting' => 'Poništi podešavanje',
        'Allow users to adapt this setting from within their personal preferences' =>
            'Omogući korisnicima da menjaju ovo podešavanje u njihovim ličnim podešavanjima',
        'Allow users to update' => 'Dozvoli korisnicima da menjaju',
        'Do not longer allow users to adapt this setting from within their personal preferences' =>
            'Onemogući korisnicima da menjaju ovo podešavanje u njihovim ličnim podešavanjima',
        'Forbid users to update' => 'Zabrani korisnicima da menjaju',
        'Show user specific changes for this setting' => 'Prikaži korisničke promene za ovo podešavanje',
        'Show user settings' => 'Prikaži korisničke promene',
        'Copy a direct link to this setting to your clipboard' => 'Kopiraj direktnu vezu za ovo podešavanje',
        'Copy direct link' => 'Kopiraj direktnu vezu',
        'Remove this setting from your favorites setting' => 'Ukloni ovo podešavanje iz omiljenih',
        'Remove from favourites' => 'Ukloni iz omiljenih',
        'Add this setting to your favorites' => 'Dodaj ovo podešavanje u omiljena',
        'Add to favourites' => 'Dodaj u omiljene',
        'Cancel editing this setting' => 'Odustani od promene ovog podešavanja',
        'Save changes on this setting' => 'Sačuvaj promene za ovo podešavanje',
        'Edit this setting' => 'Promeni ovo podešavanje',
        'Enable this setting' => 'Uključi ovo podešavanje',
        'This group doesn\'t contain any settings. Please try navigating to one of its sub groups or another group.' =>
            'Ova grupa ne sadrži nijedno podešavanje. Molimo probajte neku od pod-grupa ili drugu grupu.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SystemConfiguration/SettingsListCompare.tt
        'Now' => 'Sad',
        'User modification' => 'Korisničke promene',
        'enabled' => 'uključeno',
        'disabled' => 'isključeno',
        'Setting state' => 'Vrednost podešavanja',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SystemConfiguration/Sidebar/Actions.tt
        'Edit search' => 'Uredi pretragu',
        'Go back to admin: ' => 'Nazad na admin:',
        'Deployment' => 'Raspored',
        'My favourite settings' => 'Moja omiljena podešavanja',
        'Invalid settings' => 'Nevažeća podešavanja',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SystemConfiguration/Sidebar/DynamicActions.tt
        'Filter visible settings...' => 'Izfiltriraj vidljiva podešavanja...',
        'Enable edit mode for all settings' => 'Promeni sva podešavanja',
        'Save all edited settings' => 'Snimi sva promenjena podešavanja',
        'Cancel editing for all settings' => 'Odustani od promene svih podešavanja',
        'All actions from this widget apply to the visible settings on the right only.' =>
            'Sve akcije iz ovog dodatka se odnose na vidljiva podešavanja sa desne strane.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SystemConfiguration/Sidebar/Help.tt
        'Currently edited by me.' => 'Trenutno menjate vi.',
        'Modified but not yet deployed.' => 'Promenjeno ali neraspoređeno.',
        'Currently edited by another user.' => 'Trenutno menja drugi korisnik.',
        'Different from its default value.' => 'Razlikuje se od podrazumevane vrednosti.',
        'Save current setting.' => 'Sačuvaj trenutno podešavanje.',
        'Cancel editing current setting.' => 'Odustani od promene trenutnog podešavanja.',

        # TT Template: Kernel/Output/HTML/Templates/Standard/SystemConfiguration/Sidebar/Navigation.tt
        'Navigation' => 'Navigacija',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Test.tt
        'OTRS Test Page' => 'OTRS test strana',
        'Unlock' => 'Otključaj',
        'Welcome %s %s' => 'Dobrodošli %s %s',
        'Counter' => 'Brojač',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Ticket/TimeUnits.tt
        'Invalid time!' => 'Nevažeće vreme!',

        # TT Template: Kernel/Output/HTML/Templates/Standard/Warning.tt
        'Go back to the previous page' => 'Vratite se na prethodnu stranu',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/Agent/AppointmentCalendar/CalendarSettingsDialog.html.tmpl
        'Show' => 'Prikaži',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/Agent/FormDraftAddDialog.html.tmpl
        'Draft title' => 'Naslov nacrta',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/Agent/TicketZoom/ArticleViewSettingsDialog.html.tmpl
        'Article display' => 'Prikaz članaka',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/Agent/TicketZoom/FormDraftDeleteDialog.html.tmpl
        'Do you really want to delete "%s"?' => 'Da li zaista želite da obrišete "%s"?',
        'Confirm' => 'Potvrdi',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/Agent/WidgetLoading.html.tmpl
        'Loading, please wait...' => 'Učitavanje, molimo sačekajte...',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/AjaxDnDUpload/UploadContainer.html.tmpl
        'Click to select a file for upload.' => 'Kliknite ovde za otpremanje datoteke.',
        'Click to select files or just drop them here.' => 'Kliknite da odaberete datoteke ili ih jednostavno prevucite ovde.',
        'Click to select a file or just drop it here.' => 'Kliknite da odaberete datoteku ili je jednostavno prevucite ovde.',
        'Uploading...' => 'Otpremanje...',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/PackageManager/InformationDialog.html.tmpl
        'Process state' => 'Stanje procesa',
        'Running' => 'U toku',
        'Finished' => 'Završeno',
        'No package information available.' => 'Nema informacija o paketu.',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/SysConfig/AddButton.html.tmpl
        'Add new entry' => 'Dodaj nov unos',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/SysConfig/AddHashKey.html.tmpl
        'Add key' => 'Dodaj ključ',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/SysConfig/DialogDeployment.html.tmpl
        'Deployment comment...' => 'Komentar raspoređuvanja...',
        'This field can have no more than 250 characters.' => 'Ovo polje ne može sadržati više od 250 karaktera.',
        'Deploying, please wait...' => 'Raspoređivanje u toku, molimo sačekajte...',
        'Preparing to deploy, please wait...' => 'Priprema za raspoređivanje, molimo sačekajte...',
        'Deploy now' => 'Rasporedi sad',
        'Try again' => 'Pokušajte ponovo',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/SysConfig/DialogReset.html.tmpl
        'Reset options' => 'Poništi podešavanja',
        'Reset setting on global level.' => 'Poništi podešavanje na globalnom nivou.',
        'Reset globally' => 'Poništi globalno',
        'Remove all user changes.' => 'Poništi sve korisničke promene.',
        'Reset locally' => 'Poništi lokalno',
        'user(s) have modified this setting.' => 'korisnik(a) je je promenilo ovo podešavanje.',
        'Do you really want to reset this setting to it\'s default value?' =>
            'Da li stvarno želite da poništite ovo podešavanje na njegovu podrazumevanu vrednost?',

        # JS Template: Kernel/Output/JavaScript/Templates/Standard/SysConfig/HelpDialog.html.tmpl
        'You can use the category selection to limit the navigation tree below to entries from the selected category. As soon as you select the category, the tree will be re-built.' =>
            'Možete odabrati kategoriju za ograničavanje navigacionih stavki ispod. Čim odaberete kategoriju, navigacija će biti osvežena.',

        # Perl Module: Kernel/Config/Defaults.pm
        'Database Backend' => 'Baza podataka',
        'CustomerIDs' => 'ID-evi klijenta',
        'Fax' => 'Faks',
        'Street' => 'Ulica',
        'Zip' => 'PB',
        'City' => 'Mesto',
        'Country' => 'Država',
        'Valid' => 'Važeći',
        'Mr.' => 'G-din',
        'Mrs.' => 'G-đa',
        'Address' => 'Adresa',
        'View system log messages.' => 'Pregled poruka sistemskog loga.',
        'Edit the system configuration settings.' => 'Uredi podešavanja sistemske konfiguracije.',
        'Update and extend your system with software packages.' => 'Ažuriraj i nadogradi sistem softverskim paketima.',

        # Perl Module: Kernel/Modules/AdminACL.pm
        'ACL information from database is not in sync with the system configuration, please deploy all ACLs.' =>
            'ACL informacije iz baze podataka nisu sinhronizovane sa sistemskom konfiguracijom, molimo vas da primenite sve ACL liste.',
        'ACLs could not be Imported due to a unknown error, please check OTRS logs for more information' =>
            'ACL liste ne mogu da se uvezu zbog nepoznate greške, molimo da proverite OTRS logove za više informacija',
        'The following ACLs have been added successfully: %s' => 'Sledeće ACL liste su uspešno dodate: %s',
        'The following ACLs have been updated successfully: %s' => 'Sledeće ACL liste su uspešno ažurirane: %s',
        'There where errors adding/updating the following ACLs: %s. Please check the log file for more information.' =>
            'Postoje greške u dodavanju/ažuriranju sledećih ACL: %s. Molimo proverite log datoteku za više informacija.',
        'This field is required' => 'Ovo polje je obavezno.',
        'There was an error creating the ACL' => 'Došlo je do greške pri kreiranju ACL',
        'Need ACLID!' => 'Neophodan ACLID!',
        'Could not get data for ACLID %s' => 'Ne mogu pribaviti podatke za ID ACL liste %s',
        'There was an error updating the ACL' => 'Došlo je do greške pri ažuriranju ACL',
        'There was an error setting the entity sync status.' => 'Došlo je do greške prilikom podešavanja statusa sinhronizacije entiteta.',
        'There was an error synchronizing the ACLs.' => 'Došlo je do greške pri sinhronizaciji ACLs',
        'ACL %s could not be deleted' => 'ACL listu %s nije moguće obrisati',
        'There was an error getting data for ACL with ID %s' => 'Došlo je do greške prilikom pribavljanja podataka za ACL listu sa ID %s',
        '%s (copy) %s' => '%s (kopija) %s',
        'Please note that ACL restrictions will be ignored for the Superuser account (UserID 1).' =>
            'Molimo obratite pažnju da će ACL restrikcije biti ignorisane za super-administratorski nalog (UserID 1).',
        'Exact match' => 'Tačno poklapanje',
        'Negated exact match' => 'Negirano tačno poklapanje',
        'Regular expression' => 'Regularni izraz',
        'Regular expression (ignore case)' => 'Regularni izraz (ignoriši veličinu slova)',
        'Negated regular expression' => 'Negirani regularni izraz',
        'Negated regular expression (ignore case)' => 'Negirani regularni izraz (ignoriši veličinu slova)',

        # Perl Module: Kernel/Modules/AdminAppointmentCalendarManage.pm
        'System was unable to create Calendar!' => 'Sistem nije uspeo da kreira kalendar!',
        'Please contact the administrator.' => 'Molimo kontaktirajte administratora!',
        'No CalendarID!' => 'Nema CalendarID!',
        'You have no access to this calendar!' => 'Nemate pristup ovom kalendaru!',
        'Error updating the calendar!' => 'Greška prilikom izmene kalendara',
        'Couldn\'t read calendar configuration file.' => 'Učitavanje konfiguracije kalendara nije bilo moguće.',
        'Please make sure your file is valid.' => 'Molimo vas da proverite da li je vaš fajl ispravan.',
        'Could not import the calendar!' => 'Nije moguć uvoz kalendara!',
        'Calendar imported!' => 'Kalendar je uvezen!',
        'Need CalendarID!' => 'Neophodan CalendarID!',
        'Could not retrieve data for given CalendarID' => 'Ne mogu pribaviti podatke za dati CalendarID',
        'Successfully imported %s appointment(s) to calendar %s.' => 'Uspešno uvezeno %s termin(a) u kalendar %s.',
        '+5 minutes' => '+5 minuta',
        '+15 minutes' => '+15 minuta',
        '+30 minutes' => '+30 minuta',
        '+1 hour' => '+1 sat',

        # Perl Module: Kernel/Modules/AdminAppointmentImport.pm
        'No permissions' => 'Bez dozvole',
        'System was unable to import file!' => 'Sistem nije uspeo da uveze fajl!',
        'Please check the log for more information.' => 'Molimo proverite log za više informacija.',

        # Perl Module: Kernel/Modules/AdminAppointmentNotificationEvent.pm
        'Notification name already exists!' => 'Obaveštenje sa ovim nazivom već postoji!',
        'Notification added!' => 'Obaveštenje dodato!',
        'There was an error getting data for Notification with ID:%s!' =>
            'Došlo je do greške prilikom pribavljanja podataka za ID obaveštenja:%s!',
        'Unknown Notification %s!' => 'Nepoznato obaveštenje %s!',
        '%s (copy)' => '%s (kopija)',
        'There was an error creating the Notification' => 'Došlo je do greške prilikom kreiranja obaveštenja',
        'Notifications could not be Imported due to a unknown error, please check OTRS logs for more information' =>
            'Obaveštenja ne mogu da se uvezu zbog nepoznate greške, molimo da proverite OTRS logove za više informacija',
        'The following Notifications have been added successfully: %s' =>
            'Sledeća obaveštenja su uspešno dodata: %s',
        'The following Notifications have been updated successfully: %s' =>
            'Sledeća obaveštenja su uspešno ažurirana: %s',
        'There where errors adding/updating the following Notifications: %s. Please check the log file for more information.' =>
            'Postoje greške u dodavanju/ažuriranju sledećih obaveštenja: %s. Molimo proverite log datoteku za više informacija.',
        'Notification updated!' => 'Obaveštenje ažurirano!',
        'Agent (resources), who are selected within the appointment' => 'Operater (resurs), koji je izabran u terminu',
        'All agents with (at least) read permission for the appointment (calendar)' =>
            'Svi operateri sa (najmanje) dozvolom pregleda termina (kalendara)',
        'All agents with write permission for the appointment (calendar)' =>
            'Svi operateri sa dozvolom pisanja u terminu (kalendaru)',
        'Yes, but require at least one active notification method.' => 'Da, ali traži bar jedan aktivni metod obaveštavanja.',

        # Perl Module: Kernel/Modules/AdminAutoResponse.pm
        'Auto Response added!' => 'Automatski odgovor dodat!',

        # Perl Module: Kernel/Modules/AdminCommunicationLog.pm
        'Invalid CommunicationID!' => 'Nevažeći CommunicationID!',
        'All communications' => 'Sve komunikacije',
        'Last 1 hour' => 'Poslednji 1 sat',
        'Last 3 hours' => 'Poslednja 3 sata',
        'Last 6 hours' => 'Poslednjih 6 sati',
        'Last 12 hours' => 'Poslednjih 12 sati',
        'Last 24 hours' => 'Poslednjih 24 sata',
        'Last week' => 'Prošla nedelja',
        'Last month' => 'Prošli mesec',
        'Invalid StartTime: %s!' => 'Nevažeći StartTime: %s!',
        'Successful' => 'Uspešno',
        'Processing' => 'U procesu',
        'Failed' => 'Neuspešno',
        'Invalid Filter: %s!' => 'Nevažeći filter: %s!',
        'Less than a second' => 'Kraće od sekunde',
        'sorted descending' => 'sortirano opadajuće',
        'sorted ascending' => 'sortirano rastuće',
        'Trace' => 'Ispitivanje',
        'Debug' => 'Otklanjanje neispravnosti',
        'Info' => 'Info',
        'Warn' => 'Upozorenje',
        'days' => 'dani',
        'day' => 'dan',
        'hour' => 'sat',
        'minute' => 'minut',
        'seconds' => 'sekunde',
        'second' => 'sekunda',

        # Perl Module: Kernel/Modules/AdminCustomerCompany.pm
        'Customer company updated!' => 'Ažurirana firma klijenta!',
        'Dynamic field %s not found!' => 'Dinamičko polje %s nije pronađeno!',
        'Unable to set value for dynamic field %s!' => 'Nije moguće postaviti vrednost za dinamičko polje %s!',
        'Customer Company %s already exists!' => 'Klijentska firma %s već postoji!',
        'Customer company added!' => 'Dodata firma klijenta!',

        # Perl Module: Kernel/Modules/AdminCustomerGroup.pm
        'No configuration for \'CustomerGroupPermissionContext\' found!' =>
            'Konfiguracija za \'CustomerGroupPermissionContext\' nije pronađena!',
        'Please check system configuration.' => 'Molimo proverite sistemsku konfiguraciju.',
        'Invalid permission context configuration:' => 'Nevažeća konfiguracija konteksta dozvole:',

        # Perl Module: Kernel/Modules/AdminCustomerUser.pm
        'Customer updated!' => 'Ažuriran klijent!',
        'New phone ticket' => 'Novi tiket poziva',
        'New email ticket' => 'Novi imejl tiket',
        'Customer %s added' => 'Dodat klijent %s.',
        'Customer user updated!' => 'Ažuriran klijent korisnik!',
        'Same Customer' => 'Isti klijent',
        'Direct' => 'Direktno',
        'Indirect' => 'Indirektno',

        # Perl Module: Kernel/Modules/AdminCustomerUserGroup.pm
        'Change Customer User Relations for Group' => 'Promeni relacije sa klijent korisnicima za grupu',
        'Change Group Relations for Customer User' => 'Promeni relacije sa grupama za klijent korisnika',

        # Perl Module: Kernel/Modules/AdminCustomerUserService.pm
        'Allocate Customer Users to Service' => 'Pridruži klijent korisnike servisu',
        'Allocate Services to Customer User' => 'Pridruži servise klijent korisniku',

        # Perl Module: Kernel/Modules/AdminDynamicField.pm
        'Fields configuration is not valid' => 'Konfiguracija polja je nevažeća',
        'Objects configuration is not valid' => 'Konfiguracija objekta je nevažeća',
        'Could not reset Dynamic Field order properly, please check the error log for more details.' =>
            'Nije moguće poništiti redosled dinamičkih polja, molimo da proverite OTRS logove za više informacija.',

        # Perl Module: Kernel/Modules/AdminDynamicFieldCheckbox.pm
        'Undefined subaction.' => 'Nedefinisana subakcija.',
        'Need %s' => 'Neophodan %s',
        'Add %s field' => 'Dodaj %s polje',
        'The field does not contain only ASCII letters and numbers.' => 'Polje ne sadrži samo ASCII slova i brojeve.',
        'There is another field with the same name.' => 'Postoji drugo polje sa istim imenom.',
        'The field must be numeric.' => 'Polje mora biti numeričko.',
        'Need ValidID' => 'Neophodan ValidID',
        'Could not create the new field' => 'Nije moguće kreirati novo polje',
        'Need ID' => 'Neophodan ID',
        'Could not get data for dynamic field %s' => 'Ne mogu pribaviti podatke za dinamičko polje %s',
        'Change %s field' => 'Izmeni %s polje',
        'The name for this field should not change.' => 'Naziv ovog polja nije poželjno menjati.',
        'Could not update the field %s' => 'Nije moguće ažurirati polje %s',
        'Currently' => 'Trenutno',
        'Unchecked' => 'Isključeno',
        'Checked' => 'Uključeno',

        # Perl Module: Kernel/Modules/AdminDynamicFieldDateTime.pm
        'Prevent entry of dates in the future' => 'Sprečava unos datuma u budućnosti',
        'Prevent entry of dates in the past' => 'Sprečava unos datuma u prošlosti',

        # Perl Module: Kernel/Modules/AdminDynamicFieldDropdown.pm
        'This field value is duplicated.' => 'Vrednost ovog polja je umnožena.',

        # Perl Module: Kernel/Modules/AdminDynamicFieldScreenConfiguration.pm
        'Settings were saved.' => '',
        'System was not able to save the setting!' => '',
        'Setting is locked by another user!' => 'Podešavanje je zaključano od strane drugog korisnika!',
        'System was not able to reset the setting!' => 'Sistem nije uspeo da poništi podešavanje!',
        'Settings were reset.' => '',
        'Screens for dynamic field %s' => '',
        'Dynamic fields for screen %s' => '',
        'Default columns for screen %s' => '',

        # Perl Module: Kernel/Modules/AdminDynamicFieldWebservice.pm
        'Could not get config for dynamic field %s' => '',
        'The field must contain only ASCII letters and numbers.' => '',
        'Dynamic field is configured more than once.' => '',
        'Dynamic field does not exist or is invalid.' => '',
        'Only dynamic fields for tickets are allowed.' => '',

        # Perl Module: Kernel/Modules/AdminEmail.pm
        'Select at least one recipient.' => 'Izaberite bar jednog primaoca.',

        # Perl Module: Kernel/Modules/AdminGenericAgent.pm
        'minute(s)' => 'minut(i)',
        'hour(s)' => 'sat(i)',
        'Time unit' => 'Jedinica vremena',
        'within the last ...' => 'u poslednjih ...',
        'within the next ...' => 'u sledećih ...',
        'more than ... ago' => 'pre više od ...',
        'Unarchived tickets' => 'Nearhivirani tiketi',
        'archive tickets' => 'arhiviraj tikete',
        'restore tickets from archive' => 'vrati tikete iz arhive',
        'Need Profile!' => 'Neophodan Profile!',
        'Got no values to check.' => 'Nema vrednosti za proveru.',
        'Please remove the following words because they cannot be used for the ticket selection:' =>
            'Molimo da uklonite sledeće reči jer se ne mogu koristiti za izbor tiketa:',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceDebugger.pm
        'Need WebserviceID!' => 'Neophodan WebserviceID!',
        'Could not get data for WebserviceID %s' => 'Ne mogu pribaviti podatke za ID veb servisa %s',
        'ascending' => 'rastući',
        'descending' => 'opadajući',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceErrorHandlingDefault.pm
        'Need communication type!' => 'Neophodan tip komunikacije!',
        'Communication type needs to be \'Requester\' or \'Provider\'!' =>
            'Tip komunikacije mora da bude \'Requester\' ili \'Provider\'!',
        'Invalid Subaction!' => 'Nevažeća subakcija!',
        'Need ErrorHandlingType!' => 'Neophodan ErrorHandlingType!',
        'ErrorHandlingType %s is not registered' => 'ErrorHandlingType %s nije registrovan',
        'Could not update web service' => 'Nije moguće ažurirati veb servis',
        'Need ErrorHandling' => 'Neophodan ErrorHandling',
        'Could not determine config for error handler %s' => 'Nije moguće utvrditi konfiguraciju za obradu greške %s',
        'Invoker processing outgoing request data' => 'Obrada izlaznih podataka zahteva u pozivaocu',
        'Mapping outgoing request data' => 'Mapiranje izlaznih podataka zahteva',
        'Transport processing request into response' => 'Obrada zahteva u odgovor u transportu',
        'Mapping incoming response data' => 'Mapiranje dolaznih podataka odgovora',
        'Invoker processing incoming response data' => 'Obrada dolaznih podataka odgovara u pozivaocu',
        'Transport receiving incoming request data' => 'Primanje dolaznih podataka zahteva u transportu',
        'Mapping incoming request data' => 'Mapiranje dolaznih podataka zahteva',
        'Operation processing incoming request data' => 'Obrada dolaznih podataka zahteva u operaciji',
        'Mapping outgoing response data' => 'Mapiranje odlaznih podataka odgovora',
        'Transport sending outgoing response data' => 'Slanje odlaznih podataka odgovora u transportu',
        'skip same backend modules only' => 'preskoči samo iste pozadinske module',
        'skip all modules' => 'preskoči sve module',
        'Operation deleted' => 'Operacija obrisana',
        'Invoker deleted' => 'Pozivalac obrisan',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceErrorHandlingRequestRetry.pm
        '0 seconds' => '0 sekundi',
        '15 seconds' => '15 sekundi',
        '30 seconds' => '30 sekundi',
        '45 seconds' => '45 sekundi',
        '1 minute' => '1 minut',
        '2 minutes' => '2 minuta',
        '3 minutes' => '3 minuta',
        '4 minutes' => '4 minuta',
        '5 minutes' => '5 minuta',
        '10 minutes' => '10 minuta',
        '15 minutes' => '15 minuta',
        '30 minutes' => '30 minuta',
        '1 hour' => '1 sat',
        '2 hours' => '2 sata',
        '3 hours' => '3 sata',
        '4 hours' => '4 sata',
        '5 hours' => '5 sati',
        '6 hours' => '6 sati',
        '12 hours' => '12 sati',
        '18 hours' => '18 sati',
        '1 day' => '1 dan',
        '2 days' => '2 dana',
        '3 days' => '3 dana',
        '4 days' => '4 dana',
        '6 days' => '6 dana',
        '1 week' => '1 nedelja',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceInvokerDefault.pm
        'Could not determine config for invoker %s' => 'Nije moguće utvrditi konfiguraciju za pozivaoca %s',
        'InvokerType %s is not registered' => 'Tip pozivaoca %s nije registrovan',
        'MappingType %s is not registered' => 'MappingType %s nije registrovan',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceInvokerEvent.pm
        'Need Invoker!' => 'Neophodan pozivalac!',
        'Need Event!' => 'Neophodan događaj!',
        'Could not get registered modules for Invoker' => 'Nije moguće pronaći registrovani modul pozivaoca',
        'Could not get backend for Invoker %s' => 'Nije moguće pronaći modul za pozivaoca %s',
        'The event %s is not valid.' => 'Događaj %s nije važeći.',
        'Could not update configuration data for WebserviceID %s' => 'Ne mogu ažurirati konfiguracione podatke za ID veb servisa %s',
        'This sub-action is not valid' => 'Ova podakcija je nevažeća',
        'xor' => 'xor',
        'String' => 'Niz znakova',
        'Regexp' => 'Regularni izraz',
        'Validation Module' => 'Modul validacije',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceMappingSimple.pm
        'Simple Mapping for Outgoing Data' => 'Jednostavno mapiranje izlaznih podataka',
        'Simple Mapping for Incoming Data' => 'Jednostavno mapiranje dolaznih podataka',
        'Could not get registered configuration for action type %s' => 'Ne mogu pribaviti registrovanu konfiguraciju za tip akcije %s',
        'Could not get backend for %s %s' => 'Nije moguće pronaći modul za %s %s',
        'Keep (leave unchanged)' => 'Zadrži (ostavi nepromenjeno)',
        'Ignore (drop key/value pair)' => 'Ignoriši (odbaci par ključ/vrednost)',
        'Map to (use provided value as default)' => 'Mapiraj na (upotrebi ponuđenu vrednost kao podrazumevanu)',
        'Exact value(s)' => 'Tačna vrednost(i)',
        'Ignore (drop Value/value pair)' => 'Ignoriši (odbaci par vrednost/vrednost)',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceMappingXSLT.pm
        'XSLT Mapping for Outgoing Data' => 'XSLT mapiranje odlaznih podataka',
        'XSLT Mapping for Incoming Data' => 'XSLT mapiranje dolaznih podataka',
        'Could not find required library %s' => 'Nije moguće pronaći potrebnu biblioteku %s',
        'Outgoing request data before processing (RequesterRequestInput)' =>
            'Podaci odlazećeg zahteva pre izvršavanja (RequesterRequestInput)',
        'Outgoing request data before mapping (RequesterRequestPrepareOutput)' =>
            'Podaci odlazećeg zahteva pre mapiranja (RequesterRequestPrepareOutput)',
        'Outgoing request data after mapping (RequesterRequestMapOutput)' =>
            'Podaci primljenog zahteva posle mapiranja (RequesterRequestMapOutput)',
        'Incoming response data before mapping (RequesterResponseInput)' =>
            'Podaci primljenog odgovora pre mapiranja (RequesterResponseInput)',
        'Outgoing error handler data after error handling (RequesterErrorHandlingOutput)' =>
            'Podaci o odlazećoj grešci posle obrade greške (RequesterErrorHandlingOutput)',
        'Incoming request data before mapping (ProviderRequestInput)' => 'Podaci primljenog zahteva pre mapiranja (ProviderRequestInput)',
        'Incoming request data after mapping (ProviderRequestMapOutput)' =>
            'Podaci primljenog zahteva posle mapiranja (ProviderRequestMapOutput)',
        'Outgoing response data before mapping (ProviderResponseInput)' =>
            'Podaci odlazećeg odgovora pre mapiranja (ProviderResponseInput)',
        'Outgoing error handler data after error handling (ProviderErrorHandlingOutput)' =>
            'Podaci o odlazećoj grešci posle obrade greške (ProviderErrorHandlingOutput)',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceOperationDefault.pm
        'Could not determine config for operation %s' => 'Nije moguće utvrditi konfiguraciju za operaciju %s',
        'OperationType %s is not registered' => 'Tip operacije %s nije registrovan',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceTransportHTTPREST.pm
        'Need valid Subaction!' => 'Neophodan važeći Subaction!',
        'This field should be an integer.' => 'Ovo polje mora biti ceo broj.',
        'Invalid key file and/or password (if needed, see below).' => '',
        'Invalid password and/or key file (see above).' => '',
        'Certificate is expired.' => '',
        'Certificate file could not be parsed.' => '',
        'Please enter a time in seconds (at least 10 seconds).' => '',
        'Please enter data in expected form (see explanation of field).' =>
            '',
        'File or Directory not found.' => 'Datoteka ili direktorijum nisu pronađeni.',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceWebservice.pm
        'There is another web service with the same name.' => 'Postoji drugi veb servis sa istim imenom.',
        'There was an error updating the web service.' => 'Došlo je do greške pri ažuriranju veb servisa.',
        'There was an error creating the web service.' => 'Došlo je do greške pri kreiranju veb servisa.',
        'Web service "%s" created!' => 'Veb servis "%s" je kreiran!',
        'Need Name!' => 'Neophodan Name!',
        'Need ExampleWebService!' => 'Neophodan ExampleWebService!',
        'Could not load %s.' => 'Nije bilo moguće učitati %s.',
        'Could not read %s!' => 'Nije moguće pročitati %s!',
        'Need a file to import!' => 'Neophodna datoteka za uvoz!',
        'The imported file has not valid YAML content! Please check OTRS log for details' =>
            'Uvezena datoteka nema ispravan YAML sadržaj! Molimo proverite OTRS log za detalje',
        'Web service "%s" deleted!' => 'Veb servis "%s" je obrisan!',
        'OTRS as provider' => 'OTRS kao pružalac usluga',
        'Operations' => 'Operacije',
        'OTRS as requester' => 'OTRS kao naručilac',
        'Invokers' => 'Pozivaoci',

        # Perl Module: Kernel/Modules/AdminGenericInterfaceWebserviceHistory.pm
        'Got no WebserviceHistoryID!' => 'Nema WebserviceHistoryID!',
        'Could not get history data for WebserviceHistoryID %s' => 'Ne mogu pribaviti podatke istorijata za ID veb servisa %s',

        # Perl Module: Kernel/Modules/AdminGroup.pm
        'Group updated!' => 'Ažurirana grupa!',

        # Perl Module: Kernel/Modules/AdminMailAccount.pm
        'Mail account added!' => 'Dodat imejl nalog!',
        'Email account fetch already fetched by another process. Please try again later!' =>
            'Trenutno drugi proces preuzima poštu imejl naloga. Molimo pokušajte kasnije.',
        'Dispatching by email To: field.' => 'Otpremanje putem imejla Za: polje.',
        'Dispatching by selected Queue.' => 'Otpremanje putem izabranog reda.',

        # Perl Module: Kernel/Modules/AdminNotificationEvent.pm
        'Agent who created the ticket' => 'Operater koji je kreirao tiket',
        'Agent who owns the ticket' => 'Operater koji je vlasnik tiketa',
        'Agent who is responsible for the ticket' => 'Operater koji je odgovoran za tiket',
        'All agents watching the ticket' => 'Svi operateri koji nadziru tiket',
        'All agents with write permission for the ticket' => 'Svi operateri sa dozvolom pisanja za tiket',
        'All agents subscribed to the ticket\'s queue' => 'Svi operateri pretplaćeni na red tiketa',
        'All agents subscribed to the ticket\'s service' => 'Svi operateri pretplaćeni na servis tiketa',
        'All agents subscribed to both the ticket\'s queue and service' =>
            'Svi operateri pretplaćeni i na red i na servis tiketa',
        'Customer user of the ticket' => 'Klijent korisnik tiketa',
        'All recipients of the first article' => 'Svi primaoci prvog članka',
        'All recipients of the last article' => 'Svi primaoci poslednjeg članka',
        'All agents who are mentioned in the ticket' => '',
        'Invisible to customer' => 'Nevidljivo klijentu',
        'Visible to customer' => 'Vidljivo klijentu',

        # Perl Module: Kernel/Modules/AdminOAuth2TokenManagement.pm
        'Authorization code parameters not found.' => '',

        # Perl Module: Kernel/Modules/AdminOTRSBusiness.pm
        'Your system was successfully upgraded to %s.' => 'Vaš sistem je uspešno unapređen na %s.',
        'There was a problem during the upgrade to %s.' => 'Problem tokom unapređivanja na  %s.',
        '%s was correctly reinstalled.' => '%s je korektno reinstalirana.',
        'There was a problem reinstalling %s.' => 'Problem pri reinstalaciji %s.',
        'Your %s was successfully updated.' => 'Vaša %s je uspešno ažurirana.',
        'There was a problem during the upgrade of %s.' => 'Problem tokom unapređivanja %s.',
        '%s was correctly uninstalled.' => '%s je korektno deinstalirana.',
        'There was a problem uninstalling %s.' => 'Problem pri deinstalaciji %s.',

        # Perl Module: Kernel/Modules/AdminPGP.pm
        'PGP environment is not working. Please check log for more info!' =>
            'PGP okruženje ne funkcioniše. Za više informacija proverite log.',
        'Need param Key to delete!' => 'Neophodan parametar Key za brisanje!',
        'Key %s deleted!' => 'Ključ %s je obrisan!',
        'Need param Key to download!' => 'Neophodan parametar Key za preuzimanje!',

        # Perl Module: Kernel/Modules/AdminPackageManager.pm
        'Sorry, Apache::Reload is needed as PerlModule and PerlInitHandler in Apache config file. See also scripts/apache2-httpd.include.conf. Alternatively, you can use the command line tool bin/otrs.Console.pl to install packages!' =>
            'Žao nam je, ali Apache::Reload je neophodan kao PerlModule i PerlInitHandler u konfiguraciji Apache-a. Molimo pogledajte scripts/apache2-httpd.include.conf. Alternativno, možete koristiti konzolnu alatku bin/otrs.Console.pl za instalaciju paketa!',
        'No such package!' => 'Nema takvog paketa!',
        'No such file %s in package!' => 'Nema takve datoteke %s u paketu!',
        'No such file %s in local file system!' => 'Nema takve datoteke %s u lokalnom sistemu!',
        'Can\'t read %s!' => 'Nemoguće čitanje %s!',
        'File is OK' => 'Datoteka je u redu',
        'Package has locally modified files.' => 'Paket sadrži lokalno izmenjene datoteke.',
        'Not Started' => 'Nije pokrenuto',
        'Updated' => 'Ažurirano',
        'Already up-to-date' => 'Već ažurno',
        'Installed' => 'Instalirano',
        'Not correctly deployed' => 'Nije korektno raspoređeno',
        'Package updated correctly' => 'Paket uspešno ažuriran',
        'Package was already updated' => 'Paket je već ažuran',
        'Dependency installed correctly' => 'Zavisni paketi uspešno instalirani',
        'The package needs to be reinstalled' => 'Paket mora biti reinstaliran.',
        'The package contains cyclic dependencies' => 'Paket sadrži ciklične zavisnosti',
        'Not found in on-line repositories' => 'Nije pronađen u mrežnom spremištu',
        'Required version is higher than available' => 'Neophodna verzija je veća od trenutne',
        'Dependencies fail to upgrade or install' => 'Greška priliko ažuriranja ili instalacije zavisnih paketa',
        'Package could not be installed' => 'Paket nije mogao biti instaliran',
        'Package could not be upgraded' => 'Paket nije mogao biti ažuriran',
        'Repository List' => 'Lista spremišta',
        'No packages found in selected repository. Please check log for more info!' =>
            'U izabranom spremištu nema paketa. Molimo proverite log za više informacija.',
        'Can\'t connect to OTRS Feature Add-on list server!' => 'Nije moguće povezati se sa OTRS Feature Add-on serverom!',
        'Can\'t get OTRS Feature Add-on list from server!' => 'Ne mogu pribaviti OTRS Feature Add-on listu sa servera!',
        'Can\'t get OTRS Feature Add-on from server!' => 'Ne mogu pribaviti OTRS Feature Add-on sa servera!',

        # Perl Module: Kernel/Modules/AdminPostMasterFilter.pm
        'No such filter: %s' => 'Nema takvog filtera: %s',

        # Perl Module: Kernel/Modules/AdminPriority.pm
        'Priority added!' => 'Dodat prioritet!',

        # Perl Module: Kernel/Modules/AdminProcessManagement.pm
        'Process Management information from database is not in sync with the system configuration, please synchronize all processes.' =>
            'Obrađene informacije iz baze podataka nisu sinhronizovane sa sistemskom konfiguracijom, molimo vas da sinhronizujete sve procese.',
        'Need ExampleProcesses!' => 'Neophodan ExampleProcesses!',
        'Need ProcessID!' => 'Neophodan ProcessID!',
        'Yes (mandatory)' => 'Da (obavezno)',
        'Unknown Process %s!' => 'Nepoznat proces %s!',
        'There was an error generating a new EntityID for this Process' =>
            'Došlo je do greške prilikom kreiranja novog ID entiteta za ovaj proces',
        'The StateEntityID for state Inactive does not exists' => 'StateEntityID za neaktivno stanje ne postoji',
        'There was an error creating the Process' => 'Došlo je do greške prilikom kreiranja Procesa',
        'There was an error setting the entity sync status for Process entity: %s' =>
            'Došlo je do greške prilikom podešavanja statusa sinhronizacije za entitet procesa: %s',
        'Could not get data for ProcessID %s' => 'Ne mogu pribaviti podatke za ID procesa %s',
        'There was an error updating the Process' => 'Došlo je do greške prilikom ažuriranja Procesa',
        'Process: %s could not be deleted' => 'Proces: %s se ne može obrisati',
        'There was an error synchronizing the processes.' => 'Došlo je do greške pri sinhronizaciji procesa.',
        'The %s:%s is still in use' => '%s:%s je još u upotrebi',
        'The %s:%s has a different EntityID' => '%s:%s ima različit ID entiteta',
        'Could not delete %s:%s' => 'Nije moguće obrisati %s:%s',
        'There was an error setting the entity sync status for %s entity: %s' =>
            'Došlo je do greške prilikom podešavanja statusa sinhronizacije entiteta za %s entitet: %s',
        'Could not get %s' => 'Nije moguće pribaviti %s',
        'Need %s!' => 'Neophodan %s!',
        'Process: %s is not Inactive' => 'Proces: %s nije neaktivan',

        # Perl Module: Kernel/Modules/AdminProcessManagementActivity.pm
        'There was an error generating a new EntityID for this Activity' =>
            'Došlo je do greške prilikom kreiranja novog ID entiteta za ovu aktivnost',
        'There was an error creating the Activity' => 'Došlo je do greške prilikom kreiranja Aktivnosti',
        'There was an error setting the entity sync status for Activity entity: %s' =>
            'Došlo je do greške prilikom podešavanja statusa sinhronizacije entiteta za  entitet Aktivnosti: %s',
        'Need ActivityID!' => 'Neophodan ActivityID!',
        'Could not get data for ActivityID %s' => 'Ne mogu pribaviti podatke za ID aktivnosti %s',
        'There was an error updating the Activity' => 'Došlo je do greške prilikom ažuriranja Aktivnosti',
        'Missing Parameter: Need Activity and ActivityDialog!' => 'Nedostaju parametri: neophodni Activity i ActivityDialog!',
        'Activity not found!' => 'Aktivnost nije pronađena!',
        'ActivityDialog not found!' => 'Dijalog aktivnosti nije pronađen!',
        'ActivityDialog already assigned to Activity. You cannot add an ActivityDialog twice!' =>
            'Dijalog aktivnosti je već dodeljen aktivnosti. Ne možete dodavati dijalog dva puta.',
        'Error while saving the Activity to the database!' => 'Greška pri čuvanju aktivnosti u bazi podataka!',
        'This subaction is not valid' => 'Ova podakcija je nevažeća',
        'Edit Activity "%s"' => 'Uredi aktivnost "%s"',

        # Perl Module: Kernel/Modules/AdminProcessManagementActivityDialog.pm
        'There was an error generating a new EntityID for this ActivityDialog' =>
            'Došlo je do greške prilikom kreiranja novog ID entiteta za ovaj dijalog aktivnosti',
        'There was an error creating the ActivityDialog' => 'Došlo je do greške prilikom kreiranja Dijaloga aktivnosti',
        'There was an error setting the entity sync status for ActivityDialog entity: %s' =>
            'Došlo je do greške prilikom podešavanja statusa sinhronizacije entiteta za  entitet Diajloga aktivnosti: %s',
        'Need ActivityDialogID!' => 'Neophodan ActivityDialogID!',
        'Could not get data for ActivityDialogID %s' => 'Ne mogu pribaviti podatke za ID dijaloga aktivnosti %s',
        'There was an error updating the ActivityDialog' => 'Došlo je do greške prilikom ažuriranja Dijaloga ktivnosti',
        'Edit Activity Dialog "%s"' => 'Uredi dijalog aktivnosti "%s"',
        'Agent Interface' => 'Operaterski interfejs',
        'Customer Interface' => 'Klijentski interfejs',
        'Agent and Customer Interface' => 'Operaterski i klijentski interfejs',
        'Do not show Field' => 'Ne prikazuj ovo polje',
        'Show Field' => 'Prikaži polje',
        'Show Field As Mandatory' => 'Prikaži polje kao obavezno',

        # Perl Module: Kernel/Modules/AdminProcessManagementPath.pm
        'Edit Path' => 'Uredi putanju',

        # Perl Module: Kernel/Modules/AdminProcessManagementTransition.pm
        'There was an error generating a new EntityID for this Transition' =>
            'Došlo je do greške prilikom kreiranja novog ID entiteta za ovu tranziciju',
        'There was an error creating the Transition' => 'Došlo je do greške prilikom kreiranja Tranzicije',
        'There was an error setting the entity sync status for Transition entity: %s' =>
            'Došlo je do greške prilikom podešavanja statusa sinhronizacije entiteta za  entitet Tranzicije: %s',
        'Need TransitionID!' => 'Neophodan TransitionID!',
        'Could not get data for TransitionID %s' => 'Ne mogu pribaviti podatke za ID tranzicije %s',
        'There was an error updating the Transition' => 'Došlo je do greške prilikom ažuriranja Tranzicije',
        'Edit Transition "%s"' => 'Uredi tranziciju "%s"',

        # Perl Module: Kernel/Modules/AdminProcessManagementTransitionAction.pm
        'At least one valid config parameter is required.' => 'Neophodan je bar jedan validan konfiguracioni parametar.',
        'There was an error generating a new EntityID for this TransitionAction' =>
            'Došlo je do greške prilikom kreiranja novog ID entiteta za ovu tranzicionu akciju',
        'There was an error creating the TransitionAction' => 'Došlo je do greške prilikom kreiranja Tranzicione akcije',
        'There was an error setting the entity sync status for TransitionAction entity: %s' =>
            'Došlo je do greške prilikom podešavanja statusa sinhronizacije entiteta za  entitet Tranzicione akcije: %s',
        'Need TransitionActionID!' => 'Neophodan TransitionActionID!',
        'Could not get data for TransitionActionID %s' => 'Ne mogu pribaviti podatke za ID tranzicione akcije %s',
        'There was an error updating the TransitionAction' => 'Došlo je do greške prilikom ažuriranja Tranzicione akcije',
        'Edit Transition Action "%s"' => 'Uredi tranzicionu akciju "%s"',
        'Error: Not all keys seem to have values or vice versa.' => 'Greška: Svi ključevi nemaju vrednost ili obrnuto.',

        # Perl Module: Kernel/Modules/AdminQueue.pm
        'Queue updated!' => 'Ažuriran red!',
        'Don\'t use :: in queue name!' => 'Nemojte koristiti :: u nazivu reda!',
        'Click back and change it!' => 'Kliknite na nazad i promenite to!',
        '-none-' => '-ni jedan-',

        # Perl Module: Kernel/Modules/AdminQueueAutoResponse.pm
        'Queues ( without auto responses )' => 'Redovi (bez automatskih odgovora)',

        # Perl Module: Kernel/Modules/AdminQueueTemplates.pm
        'Change Queue Relations for Template' => 'Promeni relacije sa redovima za šablon',
        'Change Template Relations for Queue' => 'Promeni relacije sa šablonima za red',

        # Perl Module: Kernel/Modules/AdminRole.pm
        'Role updated!' => 'Ažurirana uloga!',
        'Role added!' => 'Dodata uloga!',

        # Perl Module: Kernel/Modules/AdminRoleGroup.pm
        'Change Group Relations for Role' => 'Promeni relacija sa grupama za ulogu',
        'Change Role Relations for Group' => 'Promeni relacije sa ulogama za grupu',

        # Perl Module: Kernel/Modules/AdminRoleUser.pm
        'Role' => 'Uloga',
        'Change Role Relations for Agent' => 'Promeni relacije sa ulogama za operatera',
        'Change Agent Relations for Role' => 'Promeni relacije sa operaterima za ulogu',

        # Perl Module: Kernel/Modules/AdminSLA.pm
        'Please activate %s first!' => 'Molimo, prvo aktivirajte %s.',

        # Perl Module: Kernel/Modules/AdminSMIME.pm
        'S/MIME environment is not working. Please check log for more info!' =>
            'S/MIME okruženje ne funkcioniše. Za više informacija proverite log.',
        'Need param Filename to delete!' => 'Neophodan parametar Filename za brisanje!',
        'Need param Filename to download!' => 'Neophodan parametar Filename za preuzimanje!',
        'Needed CertFingerprint and CAFingerprint!' => 'Neophodan CertFingerprint i CAFingerprint!',
        'CAFingerprint must be different than CertFingerprint' => 'CAFingerprint mora biti drugačiji od CertFingerprint',
        'Relation exists!' => 'Veza postoji!',
        'Relation added!' => 'Dodata veza!',
        'Impossible to add relation!' => 'Nemoguće dodavanje veze!',
        'Relation doesn\'t exists' => 'Veza ne postoji',
        'Relation deleted!' => 'Veza obrisana!',
        'Impossible to delete relation!' => 'Nemoguće brisanje veze!',
        'Certificate %s could not be read!' => 'Sertifikat %s nije moguće pročitati!',
        'Handle Private Certificate Relations' => 'Rukovanje vezama privatnih sertifikata',

        # Perl Module: Kernel/Modules/AdminSalutation.pm
        'Salutation added!' => 'Pozdrav dodat!',

        # Perl Module: Kernel/Modules/AdminSignature.pm
        'Signature updated!' => 'Ažuriran potpis!',
        'Signature added!' => 'Dodat potpis!',

        # Perl Module: Kernel/Modules/AdminState.pm
        'State added!' => 'Dodat status!',

        # Perl Module: Kernel/Modules/AdminSupportDataCollector.pm
        'File %s could not be read!' => 'Datoteku %s nije moguće pročitati!',

        # Perl Module: Kernel/Modules/AdminSystemAddress.pm
        'System e-mail address added!' => 'Dodata sistemska imejl adresa!',

        # Perl Module: Kernel/Modules/AdminSystemConfiguration.pm
        'Invalid Settings' => 'Nevažeća podešavanja',
        'There are no invalid settings active at this time.' => 'U ovom trenutku nema nevažećih podešavanja.',
        'You currently don\'t have any favourite settings.' => 'Trenutno nemate nijedno omiljeno podešavanje.',
        'The following settings could not be found: %s' => 'Sledeća podešavanja nisu mogla biti pronađena: %s',
        'Import not allowed!' => 'Uvoz nije dozvoljen!',
        'System Configuration could not be imported due to an unknown error, please check OTRS logs for more information.' =>
            'Sistemska konfiguracija nije mogla biti uvežena zvog nepoznate greške, moliko proverite OTRS logove za više informacija.',
        'Category Search' => 'Pretraga kategorija',

        # Perl Module: Kernel/Modules/AdminSystemConfigurationDeployment.pm
        'Some imported settings are not present in the current state of the configuration or it was not possible to update them. Please check the OTRS log for more information.' =>
            'Neka uvezena podešavanja nisu prisutna u trenutnoj konfiguraciji ili nije bilo moguće ažurirati ih. Molimo proverite OTRS log za više informacija.',

        # Perl Module: Kernel/Modules/AdminSystemConfigurationGroup.pm
        'You need to enable the setting before locking!' => 'Morate uključiti podešavanje pre zaključavanja!',
        'You can\'t work on this setting because %s (%s) is currently working on it.' =>
            'Ne možete urediti ovo podešavanje zato što %s (%s) trenutno radi na njemu.',
        'Missing setting name!' => 'Nedostaje naziv podešavanja!',
        'Missing ResetOptions!' => 'Nedostaje ResetOptions!',
        'System was not able to lock the setting!' => 'Sistem nije uspeo da zaključa podešavanje!',
        'System was unable to update setting!' => 'Sistem nije uspeo da sačuva podešavanje!',
        'Missing setting name.' => 'Nedostaje naziv podešavanja.',
        'Setting not found.' => 'Podešavanje nije pronađeno.',
        'Missing Settings!' => 'Nedostaje Settings!',

        # Perl Module: Kernel/Modules/AdminSystemFiles.pm
        'Package files - %s' => '',
        '(Files where only the permissions have been changed will not be displayed.)' =>
            '',

        # Perl Module: Kernel/Modules/AdminSystemMaintenance.pm
        'Start date shouldn\'t be defined after Stop date!' => 'Datum početka ne bi trebalo odrediti posle datuma završetka!',
        'There was an error creating the System Maintenance' => 'Došlo je do greške prilikom kreiranja Održavanja sistema',
        'Need SystemMaintenanceID!' => 'Neophodan SystemMaintenanceID!',
        'Could not get data for SystemMaintenanceID %s' => 'Ne mogu pribaviti podatke za sistemsko održavanje %s',
        'System Maintenance was added successfully!' => 'Sistemsko održavanje je uspešno dodato!',
        'System Maintenance was updated successfully!' => 'Sistemsko održavanje je uspešno ažurirano!',
        'Session has been killed!' => 'Sesija je prekinuta!',
        'All sessions have been killed, except for your own.' => 'Sve sesije su prekinute, osim sopstvene.',
        'There was an error updating the System Maintenance' => 'Došlo je do greške prilikom ažuriranja Održavanja sistema',
        'Was not possible to delete the SystemMaintenance entry: %s!' => 'Nije bilo moguće obrisati unos za sistemsko održavanje: %s!',

        # Perl Module: Kernel/Modules/AdminTemplate.pm
        'Template updated!' => 'Šablon ažuriran!',

        # Perl Module: Kernel/Modules/AdminTemplateAttachment.pm
        'Change Attachment Relations for Template' => 'Promeni relacije sa prilozima za šablon',
        'Change Template Relations for Attachment' => 'Promeni relacije sa šablonima za prilog',

        # Perl Module: Kernel/Modules/AdminType.pm
        'Need Type!' => 'Neophodan Type!',
        'Type added!' => 'Dodat tip!',

        # Perl Module: Kernel/Modules/AdminUser.pm
        'Agent updated!' => 'Ažuriran operater!',

        # Perl Module: Kernel/Modules/AdminUserGroup.pm
        'Change Group Relations for Agent' => 'Promeni veze sa grupom za operatera',
        'Change Agent Relations for Group' => 'Promeni veze sa operaterom za grupu',

        # Perl Module: Kernel/Modules/AgentAppointmentAgendaOverview.pm
        'Month' => 'Mesec',
        'Week' => 'Sedmica',
        'Day' => 'Dan',

        # Perl Module: Kernel/Modules/AgentAppointmentCalendarOverview.pm
        'All appointments' => 'Svi termini',
        'Appointments assigned to me' => 'Termini dodeljeni meni',
        'Showing only appointments assigned to you! Change settings' => 'Prikaz samo termina dodeljenih vama! Izmenite podešavanja',

        # Perl Module: Kernel/Modules/AgentAppointmentEdit.pm
        'Appointment not found!' => 'Termin nije pronađen!',
        'Never' => 'Nikada',
        'Every Day' => 'Svaki dan',
        'Every Week' => 'Svake sedmice',
        'Every Month' => 'Svakog meseca',
        'Every Year' => 'Svake godine',
        'Custom' => 'Prilagođeno',
        'Daily' => 'Dnevno',
        'Weekly' => 'Sedmično',
        'Monthly' => 'Mesečno',
        'Yearly' => 'Godišnje',
        'every' => 'svakog(e)',
        'for %s time(s)' => 'ukupno %s put(a)',
        'until ...' => 'do ...',
        'for ... time(s)' => 'ukupno ... put(a)',
        'until %s' => 'do %s',
        'No notification' => 'Bez obaveštenja',
        '%s minute(s) before' => '%s minut(a) pre',
        '%s hour(s) before' => '%s sat(a) pre',
        '%s day(s) before' => '%s dan(a) pre',
        '%s week before' => '%s nedelja pre',
        'before the appointment starts' => 'pre nego što termin započne',
        'after the appointment has been started' => 'pošto termin započne',
        'before the appointment ends' => 'pre nego što se termin završi',
        'after the appointment has been ended' => 'pošto se termin završi',
        'No permission!' => 'Bez dozvole!',
        'Cannot delete ticket appointment!' => 'Nije moguće obrisati termin tiketa!',
        'No permissions!' => 'Bez dozvole!',

        # Perl Module: Kernel/Modules/AgentAppointmentList.pm
        '+%s more' => '+%s više',

        # Perl Module: Kernel/Modules/AgentCustomerSearch.pm
        'Customer History' => 'Istorijat klijenta',

        # Perl Module: Kernel/Modules/AgentCustomerUserAddressBook.pm
        'No RecipientField is given!' => 'Nije dat RecipientField!',

        # Perl Module: Kernel/Modules/AgentDashboardCommon.pm
        'No such config for %s' => 'Nema takve konfiguracije za %s',
        'Statistic' => 'Statistika',
        'No preferences for %s!' => 'Nema postavki za %s!',
        'Can\'t get element data of %s!' => 'Ne mogu pribaviti podatke elementa za %s!',
        'Can\'t get filter content data of %s!' => 'Ne mogu pribaviti podatke sadržaja filtera za %s!',
        'Customer Name' => 'Naziv klijenta',
        'Customer User Name' => 'Naziv klijent korisnika',

        # Perl Module: Kernel/Modules/AgentLinkObject.pm
        'Need SourceObject and SourceKey!' => 'Neophodni SourceObject i SourceKey!',
        'You need ro permission!' => 'Neophodna vam je ro dozvola!',
        'Can not delete link with %s!' => 'Ne može se obrisati veza sa %s!',
        '%s Link(s) deleted successfully.' => '%sveza(e) uspešno obrisana(e).',
        'Can not create link with %s! Object already linked as %s.' => 'Ne može se kreirati veza sa %s! Objekt je već povezan kao %s.',
        'Can not create link with %s!' => 'Ne može se kreirati veza sa %s!',
        '%s links added successfully.' => '%sveza(e) uspešno dodata(e).',
        'The object %s cannot link with other object!' => 'Objekt %s se ne može povezati sa drugim objektom!',

        # Perl Module: Kernel/Modules/AgentPreferences.pm
        'Param Group is required!' => 'Neophodan parametar grupe! ',
        'Updated user preferences' => 'Ažurirane korisničke postavke',
        'System was unable to deploy your changes.' => 'Sistem nije uspeo da rasporedi vaše promene.',
        'Setting not found!' => 'Podešavanje nije pronađeno!',
        'System was unable to reset the setting!' => 'Sistem nije uspeo da poništi podešavanje!',

        # Perl Module: Kernel/Modules/AgentSplitSelection.pm
        'Process ticket' => 'Proces tiket',

        # Perl Module: Kernel/Modules/AgentStatistics.pm
        'Parameter %s is missing.' => 'Nedostaje parametar %s.',
        'Invalid Subaction.' => 'Nevažeća subakcija.',
        'Statistic could not be imported.' => 'Statistika se ne može uvesti.',
        'Please upload a valid statistic file.' => 'Molimo da učitate ispravnu datoteku statistike.',
        'Export: Need StatID!' => 'Izvoz: neophodan StatID!',
        'Delete: Get no StatID!' => 'Delete: nema StatID!',
        'Need StatID!' => 'Neophodan StatID!',
        'Could not load stat.' => 'Nije moguće učitavanje statistike.',
        'Add New Statistic' => 'Dodaj novu statistiku',
        'Could not create statistic.' => 'Nije moguće kreiranje statistike.',
        'Run: Get no %s!' => 'Run: Nema %s!',

        # Perl Module: Kernel/Modules/AgentTicketActionCommon.pm
        'No TicketID is given!' => 'Nije dat TicketID!',
        'You need %s permissions!' => 'Neophodne su vam %s dozvole!',
        'Loading draft failed!' => 'Učitavanje nacrta neuspelo!',
        'Sorry, you need to be the ticket owner to perform this action.' =>
            'Na žalost, morate biti vlasnik tiketa za ovu akciju.',
        'Please change the owner first.' => 'Molimo prvo promenite vlasnika.',
        'FormDraft functionality disabled!' => 'Svojstvo FormDraft isključeno!',
        'Draft name is required!' => 'Naziv nacrta je obavezan!',
        'FormDraft name %s is already in use!' => 'Nacrta pod nazivom %s već postoji!',
        'Could not perform validation on field %s!' => 'Nije moguće obaviti validaciju za polje %s!',
        'No subject' => 'Nema predmet',
        'Could not delete draft!' => 'Nije moguće obrisati nacrt!',
        'Previous Owner' => 'Prethodni vlasnik',
        'wrote' => 'napisao/la',
        'Message from' => 'Poruka od',
        'End message' => 'Kraj poruke',

        # Perl Module: Kernel/Modules/AgentTicketBounce.pm
        '%s is needed!' => '%s je neophodno!',
        'Plain article not found for article %s!' => 'Nije pronađen običan članak za članak %s!',
        'Article does not belong to ticket %s!' => 'Članak ne pripada tiketu %s!',
        'Can\'t bounce email!' => 'Ne mogu odbaciti imejl!',
        'Can\'t send email!' => 'Ne mogu poslati imejl!',
        'Wrong Subaction!' => 'Pogrešna subakcija!',

        # Perl Module: Kernel/Modules/AgentTicketBulk.pm
        'Can\'t lock Tickets, no TicketIDs are given!' => 'Tiketi se ne mogu zaključati, nije dat TicketIDs!',
        'Ticket (%s) is not unlocked!' => 'Tiket (%s) nije otključan!',
        'The following tickets were ignored because they are locked by another agent or you don\'t have write access to tickets: %s.' =>
            'Sledeći tiketi su bili ignorisani zato što su zaključani od strane drugog operatera ili zato što nemate pravo upisa u njih: %s.',
        'The following ticket was ignored because it is locked by another agent or you don\'t have write access to ticket: %s.' =>
            'Sledeći tiket je ignorisan zato što je zaključan od strane drugog operatera ili zato što nemate pravo upisa u isti: %s.',
        'You need to select at least one ticket.' => 'Neophodno je da izaberete bar jedan tiket.',
        'Bulk feature is not enabled!' => 'Masovna funkcija nije aktivirana!',
        'No selectable TicketID is given!' => 'Nije dat TicketID koji se može izabrati!',
        'You either selected no ticket or only tickets which are locked by other agents.' =>
            'Niste selektovali ni jedan tiket ili samo tikete koje su zaključali drugi operateri.',
        'The following tickets were ignored because they are locked by another agent or you don\'t have write access to these tickets: %s.' =>
            'Sledeći tiketi su bili ignorisani zato što su zaključani od strane drugog operatera ili zato što nemate pravo upisa u njih: %s.',
        'The following tickets were locked: %s.' => 'Sledeći tiketi su bili zaključani: %s.',

        # Perl Module: Kernel/Modules/AgentTicketCompose.pm
        'Article subject will be empty if the subject contains only the ticket hook!' =>
            'Naslov članka će biti prazan ukoliko predmet sadrži samo priključak tiketa!',
        'Address %s replaced with registered customer address.' => 'Adresa %s je zamenjena registrovnom adresom klijenta.',
        'Customer user automatically added in Cc.' => 'Klijent klijent se automatski dodaje u Cc.',

        # Perl Module: Kernel/Modules/AgentTicketEmail.pm
        'Ticket "%s" created!' => 'Tiket "%s" je kreiran!',
        'No Subaction!' => 'Nema subakcije!',

        # Perl Module: Kernel/Modules/AgentTicketEmailOutbound.pm
        'Got no TicketID!' => 'Nema TicketID!',
        'System Error!' => 'Sistemska greška!',

        # Perl Module: Kernel/Modules/AgentTicketEmailResend.pm
        'No ArticleID is given!' => 'Nije dat ArticleID!',

        # Perl Module: Kernel/Modules/AgentTicketEscalationView.pm
        'Next week' => 'Sledeće nedelje',
        'Ticket Escalation View' => 'Eskalacioni pregled tiketa',

        # Perl Module: Kernel/Modules/AgentTicketForward.pm
        'Article %s could not be found!' => 'Članak %s nije pronađen!',
        'Forwarded message from' => 'Prosleđena poruka od',
        'End forwarded message' => 'Kraj prosleđene poruke',

        # Perl Module: Kernel/Modules/AgentTicketHistory.pm
        'Can\'t show history, no TicketID is given!' => 'Ne može se prikazati istorijat, nije dat TicketID!',

        # Perl Module: Kernel/Modules/AgentTicketLock.pm
        'Can\'t lock Ticket, no TicketID is given!' => 'Tiket se ne može zaključati, nije dat TicketID!',
        'Sorry, the current owner is %s!' => 'Na žalost, aktuelni vlasnik je %s!',
        'Please become the owner first.' => 'Molimo prvo preuzmite vlasništvo.',
        'Ticket (ID=%s) is locked by %s!' => 'Tiket (ID=%s) je zaključan od strane %s!',
        'Change the owner!' => 'Promeni vlasnika!',

        # Perl Module: Kernel/Modules/AgentTicketLockedView.pm
        'New Article' => 'Novi članak',
        'Pending' => 'Na čekanju',
        'Reminder Reached' => 'Dostignut podsetnik',
        'My Locked Tickets' => 'Moji zaključani tiketi',

        # Perl Module: Kernel/Modules/AgentTicketMentionView.pm
        'New mention' => '',
        'My Mentions' => '',

        # Perl Module: Kernel/Modules/AgentTicketMerge.pm
        'Can\'t merge ticket with itself!' => 'Tiket se ne može povezati sa sobom!',

        # Perl Module: Kernel/Modules/AgentTicketMove.pm
        'You need move permissions!' => 'Neophodna vam je dozvola za premeštanje!',

        # Perl Module: Kernel/Modules/AgentTicketPhone.pm
        'Chat is not active.' => 'Ćaskanje nije aktivno.',
        'No permission.' => 'Nema dozvole.',
        '%s has left the chat.' => '%s je napustio ćaskanje.',
        'This chat has been closed and will be removed in %s hours.' => 'Ovo ćaskanje je zatvoreno i biće uklonjeno za %s sati.',

        # Perl Module: Kernel/Modules/AgentTicketPhoneCommon.pm
        'Ticket locked.' => 'Zaključan tiket.',

        # Perl Module: Kernel/Modules/AgentTicketPlain.pm
        'No ArticleID!' => 'Nema ArticleID!',
        'This is not an email article.' => 'Ovo nije imejl članak.',
        'Can\'t read plain article! Maybe there is no plain email in backend! Read backend message.' =>
            'Nemoguće čitanje neformatiranog članka! Možda ne postoji neformatirana poruka u spremištu! Pročitajte poruku iz prikaza.',

        # Perl Module: Kernel/Modules/AgentTicketPrint.pm
        'Need TicketID!' => 'Neophodan TicketID!',

        # Perl Module: Kernel/Modules/AgentTicketProcess.pm
        'Couldn\'t get ActivityDialogEntityID "%s"!' => 'Ne mogu pribaviti ActivityDialogEntityID "%s"!',
        'No Process configured!' => 'Nema konfigurisanog procesa!',
        'The selected process is invalid!' => 'Označeni proces je nevažeći!',
        'Process %s is invalid!' => 'Proces %s je nevažeći!',
        'Subaction is invalid!' => 'Subakcija je nevažeća!',
        'Parameter %s is missing in %s.' => 'Nedostaje parametar %s u %s.',
        'No ActivityDialog configured for %s in _RenderAjax!' => 'Nijedan ActivityDialog nije konfigurisan za %s u _RenderAjax!',
        'Got no Start ActivityEntityID or Start ActivityDialogEntityID for Process: %s in _GetParam!' =>
            'Nema Start ActivityEntityID ili Start ActivityDialogEntityID za proces %s u _GetParam!',
        'Couldn\'t get Ticket for TicketID: %s in _GetParam!' => 'Nema tiketa za TicketID: %s u _GetParam!',
        'Couldn\'t determine ActivityEntityID. DynamicField or Config isn\'t set properly!' =>
            'Ne može se utvrditi ActivityEntityID. DynamicField ili Config nisu pravilno podešeni!',
        'Process::Default%s Config Value missing!' => 'Vrednost konfiguracije za Process::Default%s nedostaje!',
        'Got no ProcessEntityID or TicketID and ActivityDialogEntityID!' =>
            'Nema ProcessEntityID ili TicketID i ActivityDialogEntityID!',
        'Can\'t get StartActivityDialog and StartActivityDialog for the ProcessEntityID "%s"!' =>
            'Ne mogu pribaviti StartActivityDialog i StartActivityDialog za ProcessEntityID "%s"!',
        'Can\'t get Ticket "%s"!' => 'Ne mogu pribaviti tiket "%s"!',
        'Can\'t get ProcessEntityID or ActivityEntityID for Ticket "%s"!' =>
            'Ne mogu pribaviti ProcessEntityID ili ActivityEntityID za tiket "%s"!',
        'Can\'t get Activity configuration for ActivityEntityID "%s"!' =>
            'Ne mogu pribaviti konfiguraciju Activity za ActivityEntityID "%s"!',
        'Can\'t get ActivityDialog configuration for ActivityDialogEntityID "%s"!' =>
            'Ne mogu pribaviti konfiguraciju ActivityDialog za ActivityDialogEntityID "%s"!',
        'Can\'t get data for Field "%s" of ActivityDialog "%s"!' => 'Ne mogu pribaviti podatke za polje "%s" od ActivityDialog "%s"!',
        'PendingTime can just be used if State or StateID is configured for the same ActivityDialog. ActivityDialog: %s!' =>
            'Vreme čekanja tiketa može biti korišćeno ako su State ili StateID podešeni za isti dijalog aktivnosti. ActivityDialog: %s!',
        'Pending Date' => 'Datum čekanja',
        'for pending* states' => 'za stanja* čekanja',
        'ActivityDialogEntityID missing!' => 'Nedostaje ActivityDialogEntityID!',
        'Couldn\'t get Config for ActivityDialogEntityID "%s"!' => 'Ne mogu pribaviti konfiguraciju za ActivityDialogEntityID "%s"!',
        'Couldn\'t use CustomerID as an invisible field.' => 'CustomerID se ne može koristiti kao nevidljivo polje.',
        'Missing ProcessEntityID, check your ActivityDialogHeader.tt!' =>
            'Nema ProcessEntityID, proverite vaš ActivityDialogHeader.tt!',
        'No StartActivityDialog or StartActivityDialog for Process "%s" configured!' =>
            'Nema StartActivityDialog ili StartActivityDialog za proces "%s"!',
        'Couldn\'t create ticket for Process with ProcessEntityID "%s"!' =>
            'Ne mogu kreirati tiket za proces sa ProcessEntityID "%s"!',
        'Couldn\'t set ProcessEntityID "%s" on TicketID "%s"!' => 'Ne mogu postaviti ProcessEntityID "%s" za TicketID "%s"!',
        'Couldn\'t set ActivityEntityID "%s" on TicketID "%s"!' => 'Ne mogu postaviti ActivityEntityID "%s" za TicketID "%s"!',
        'Could not store ActivityDialog, invalid TicketID: %s!' => 'Ne mogu snimiti dijalog aktivnosti, nevažeći TicketID: %s!',
        'Invalid TicketID: %s!' => 'Nevažeći TicketID: %s!',
        'Missing ActivityEntityID in Ticket %s!' => 'Nedostaje ActivityEntityID u tiketu %s!',
        'This step does not belong anymore to the current activity in process for ticket \'%s%s%s\'! Another user changed this ticket in the meantime. Please close this window and reload the ticket.' =>
            'Ovaj korak ne pripada više trenutnoj aktivnosti procesa za tiket \'%s%s%s\'! Drugi korisnik je u međuvremenu promenio ovaj tiket. Molimo da zatvorite ovaj prozor i ponovo učitate tiket.',
        'Missing ProcessEntityID in Ticket %s!' => 'Nedostaje ProcessEntityID u tiketu %s!',
        'Could not set DynamicField value for %s of Ticket with ID "%s" in ActivityDialog "%s"!' =>
            'Ne mogu postaviti vrednost dinamičkog polja za %s za TicketID "%s" u ActivityDialog "%s"!',
        'Could not set attachments for ticket with ID %s in activity dialog "%s"!' =>
            '',
        'Could not set PendingTime for Ticket with ID "%s" in ActivityDialog "%s"!' =>
            'Ne mogu postaviti vreme čekanja tiketa za tiket "%s" u ActivityDialog "%s"!',
        'Wrong ActivityDialog Field config: %s can\'t be Display => 1 / Show field (Please change its configuration to be Display => 0 / Do not show field or Display => 2 / Show field as mandatory)!' =>
            'Pogrešna konfiguracija polja u dijalogu aktivnosti: %s ne može biti Display => 1 / prikazano. (Molimo podesite konfiguraciju da bude Display => 0 / nije prikazano ili Display => 2 / prikaži kao obavezno)!',
        'Could not set %s for Ticket with ID "%s" in ActivityDialog "%s"!' =>
            'Ne mogu postaviti %s za tiket "%s" u ActivityDialog "%s"!',
        'Default Config for Process::Default%s missing!' => 'Podrazumevano podešavanje za Process::Default%s nedostaje!',
        'Default Config for Process::Default%s invalid!' => 'Podrazumevano podešavanje za Process::Default%s je nevažeće!',

        # Perl Module: Kernel/Modules/AgentTicketQueue.pm
        'Available tickets' => 'Slobodni tiketi',
        'including subqueues' => 'uključujući podredove',
        'excluding subqueues' => 'isključujući podredove',
        'QueueView' => 'Pregled reda',

        # Perl Module: Kernel/Modules/AgentTicketResponsibleView.pm
        'My Responsible Tickets' => 'Tiketi za koje sam odgovoran',

        # Perl Module: Kernel/Modules/AgentTicketSearch.pm
        'last-search' => 'poslednja pretraga',
        'Untitled' => 'Nema naslov',
        'Ticket Number' => 'Broj tiketa',
        'Ticket' => 'Tiket',
        'printed by' => 'štampao',
        'CustomerID (complex search)' => 'ID klijenta (složena pretraga)',
        'CustomerID (exact match)' => 'ID klijenta (tačno poklapanje)',
        'Invalid Users' => 'Pogrešni korisnici',
        'Normal' => 'Normal',
        'CSV' => 'CSV',
        'Excel' => 'Excel',
        'in more than ...' => 'u više od ...',

        # Perl Module: Kernel/Modules/AgentTicketService.pm
        'Feature not enabled!' => 'Funkcija nije aktivirana!',
        'Service View' => 'Pregled usluge',

        # Perl Module: Kernel/Modules/AgentTicketStatusView.pm
        'Status View' => 'Pregled statusa',

        # Perl Module: Kernel/Modules/AgentTicketWatchView.pm
        'My Watched Tickets' => 'Moji nadzirani tiketi',

        # Perl Module: Kernel/Modules/AgentTicketWatcher.pm
        'Feature is not active' => 'Funkcija nije aktivna',

        # Perl Module: Kernel/Modules/AgentTicketZoom.pm
        'Link Deleted' => 'Obrisana veza',
        'Ticket Locked' => 'Zaključan tiket',
        'Pending Time Set' => 'Vremena čekanja je podešeno',
        'Dynamic Field Updated' => 'Ažurirano dinamičko polje',
        'Outgoing Email (internal)' => 'Odlazni imejl (interni)',
        'Ticket Created' => 'Kreiran tiket',
        'Type Updated' => 'Ažuriran tip',
        'Escalation Update Time In Effect' => 'Aktuelno vreme ažuriranja eskalacije',
        'Escalation Update Time Stopped' => 'Vreme ažuriranja eskalacije je zaustavljeno',
        'Escalation First Response Time Stopped' => 'Vreme prvog odziva eskalacije je zaustavljeno',
        'Customer Updated' => 'Ažuriran klijent',
        'Internal Chat' => 'Interno ćaskanje',
        'Automatic Follow-Up Sent' => 'Poslat automatski nastavak',
        'Note Added' => 'Dodata napomena',
        'Note Added (Customer)' => 'Dodata napomena (klijent)',
        'SMS Added' => 'Dodat SMS',
        'SMS Added (Customer)' => 'Dodat SMS (klijent)',
        'State Updated' => 'Ažurirano stanje',
        'Outgoing Answer' => 'Odlazni odgovor',
        'Service Updated' => 'Ažuriran servis',
        'Link Added' => 'Dodata veza',
        'Incoming Customer Email' => 'Dolazni imejl klijenta',
        'Incoming Web Request' => 'Dolazni veb zahtev',
        'Priority Updated' => 'Ažuriran prioritet',
        'Ticket Unlocked' => 'Otključan tiket',
        'Outgoing Email' => 'Odlazni imejl',
        'Title Updated' => 'Ažuriran naslov',
        'Ticket Merged' => 'Spojen tiket',
        'Outgoing Phone Call' => 'Odlazni poziv',
        'Forwarded Message' => 'Prosleđena poruka',
        'Removed User Subscription' => 'Uklonjena pretplata za korisnika',
        'Time Accounted' => 'Vreme je obračunato',
        'Incoming Phone Call' => 'Dolazni poziv',
        'System Request.' => 'Sistemski zahtev.',
        'Incoming Follow-Up' => 'Dolazni nastavak',
        'Automatic Reply Sent' => 'Poslat automatski odgovor',
        'Automatic Reject Sent' => 'Poslato automatsko odbijanje',
        'Escalation Solution Time In Effect' => 'Aktuelno vreme rešavanja eskalacije',
        'Escalation Solution Time Stopped' => 'Vreme rešenja eskalacije je zaustavljeno',
        'Escalation Response Time In Effect' => 'Aktuelno vreme odgovora na eskalaciju',
        'Escalation Response Time Stopped' => 'Vreme odziva eskalacije je zaustavljeno',
        'SLA Updated' => 'SLA je ažuriran',
        'External Chat' => 'Eksterno ćaskanje',
        'Queue Changed' => 'Promenjen red',
        'Notification Was Sent' => 'Obaveštenje je poslato',
        'This ticket does not exist, or you don\'t have permissions to access it in its current state.' =>
            'Ovaj tiket više ne postoji, ili trenutno nemate dozvolu za pristup istom.',
        'Missing FormDraftID!' => 'Nedostaje FormDraftID!',
        'Can\'t get for ArticleID %s!' => 'Ne mogu pribaviti ArticleID %s!',
        'Article filter settings were saved.' => 'Podešavanja filtera članka su sačuvana.',
        'Event type filter settings were saved.' => 'Podešavanja filtera tipa događaja su sačuvana.',
        'Need ArticleID!' => 'Neophodan ArticleID!',
        'Invalid ArticleID!' => 'Nevažeći ArticleID!',
        'Forward article via mail' => 'Prosledi članak putem mejla',
        'Forward' => 'Prosledi',
        'Fields with no group' => 'Polja bez grupe',
        'Invisible only' => 'Samo nevidljivi',
        'Visible only' => 'Samo vidljivi',
        'Visible and invisible' => 'Vidljivi i nevidljivi',
        'Article could not be opened! Perhaps it is on another article page?' =>
            'Članak se ne može otvoriti! Moguće je da je na drugoj stranici?',
        'Show one article' => 'Prikaži jedan članak',
        'Show all articles' => 'Prikaži sve članke',
        'Show Ticket Timeline View' => 'Prikaži tikete na vremenskoj liniji',

        # Perl Module: Kernel/Modules/AjaxAttachment.pm
        'Got no FormID.' => 'Nije dat FormID.',
        'Error: the file could not be deleted properly. Please contact your administrator (missing FileID).' =>
            'Greška: datoteka nije mogla biti obrisana. Molimo kontaktirajte vašeg administratora (nedostaje FileID).',

        # Perl Module: Kernel/Modules/CustomerTicketArticleContent.pm
        'ArticleID is needed!' => 'Neophodan ArticleID!',
        'No TicketID for ArticleID (%s)!' => 'Nema TicketID za ovaj ArticleID (%s)!',
        'HTML body attachment is missing!' => 'Prilog sa HTML sadržajem nedostaje!',

        # Perl Module: Kernel/Modules/CustomerTicketAttachment.pm
        'FileID and ArticleID are needed!' => 'Neophodni FileID i ArticleID!',
        'No such attachment (%s)!' => 'Nema takvog priloga (%s)!',

        # Perl Module: Kernel/Modules/CustomerTicketMessage.pm
        'Check SysConfig setting for %s::QueueDefault.' => 'Proverite podešavanja za %s::QueueDefault.',
        'Check SysConfig setting for %s::TicketTypeDefault.' => 'Proverite podešavanja za %s::TicketTypeDefault.',
        'You don\'t have sufficient permissions for ticket creation in default queue.' =>
            'Nemaš odgovarajuće dozvole za kreiranje tiketa u podrazumevanom redu.',

        # Perl Module: Kernel/Modules/CustomerTicketOverview.pm
        'Need CustomerID!' => 'Neophodan CustomerID!',
        'My Tickets' => 'Moji tiketi',
        'Company Tickets' => 'Tiketi firmi',
        'Untitled!' => 'Nema naslov!',

        # Perl Module: Kernel/Modules/CustomerTicketSearch.pm
        'Customer Realname' => 'Pravo ime klijenta',
        'Created within the last' => 'Kreirano u poslednjih',
        'Created more than ... ago' => 'Kreirano pre više od ...',
        'Please remove the following words because they cannot be used for the search:' =>
            'Molimo da uklonite sledeće reči  jer se ne mogu koristiti za pretragu:',

        # Perl Module: Kernel/Modules/CustomerTicketZoom.pm
        'Can\'t reopen ticket, not possible in this queue!' => 'Tiket se ne može ponovo otvoriti, nije moguće u ovom redu!',
        'Create a new ticket!' => 'Otvori novi tiket!',

        # Perl Module: Kernel/Modules/Installer.pm
        'SecureMode active!' => 'Siguran režim je aktivan!',
        'If you want to re-run the Installer, disable the SecureMode in the SysConfig.' =>
            'Ukoliko želite da ponovo pokrenete instalaciju, onemogućite SecureMode u podešavanjima.',
        'Directory "%s" doesn\'t exist!' => 'Direktorijum "%s" ne postoji!',
        'Configure "Home" in Kernel/Config.pm first!' => 'Prvo podesite "Home" u Kernel/Config.pm!',
        'File "%s/Kernel/Config.pm" not found!' => 'Datoteka "%s/Kernel/Config.pm" nije pronađena!',
        'Directory "%s" not found!' => 'Direktorijum "%s" nije pronađen!',
        'Install OTRS' => 'Instaliraj OTRS',
        'Intro' => 'Uvod',
        'Kernel/Config.pm isn\'t writable!' => 'Nemoguć upis u %s/Kernel/Config.pm!',
        'If you want to use the installer, set the Kernel/Config.pm writable for the webserver user!' =>
            'Ako želite da koristite instalacioni program, podesite dozvolu pisanja u Kernel/Config.pm za veb server korisnika!',
        'Database Selection' => 'Selekcija baze podataka',
        'Unknown Check!' => 'Nepoznata provera!',
        'The check "%s" doesn\'t exist!' => 'Provera "%s" ne postoji!',
        'Enter the password for the database user.' => 'Unesi lozinku za korisnika baze podataka.',
        'Database %s' => 'Baza podataka %s',
        'Configure MySQL' => 'Podesi MySQL',
        'Enter the password for the administrative database user.' => 'Unesi lozinku za korisnika administrativne baze podataka.',
        'Configure PostgreSQL' => 'Podesi PostgreSQL',
        'Configure Oracle' => 'Podesi Oracle',
        'Unknown database type "%s".' => 'Nepoznat tip baze podataka "%s".',
        'Please go back.' => 'Molimo idite nazad.',
        'Create Database' => 'Kreiraj bazu podataka',
        'Install OTRS - Error' => 'Instaliranje OTRS - greška',
        'File "%s/%s.xml" not found!' => 'Datoteka "%s/%s.xml" nije pronađena!',
        'Contact your Admin!' => 'Kontaktirajte vašeg administratora!',
        'System Settings' => 'Sistemska podešavanja',
        'Syslog' => 'Sistemski log',
        'Configure Mail' => 'Podesi imejl',
        'Mail Configuration' => 'Podešavanje imejla',
        'Can\'t write Config file!' => 'Ne mogu da upišem konfiguracionu datoteku!',
        'Unknown Subaction %s!' => 'Nepoznata subakcija %s!',
        'Can\'t connect to database, Perl module DBD::%s not installed!' =>
            'Ne mogu se povezati na bazu podataka, Perl modul DBD::%s nije instaliran!',
        'Can\'t connect to database, read comment!' => 'Ne mogu se povezati na bazu podataka, pročitajte komentar!',
        'Database already contains data - it should be empty!' => 'Baza podataka već sadrži podatke - trebalo bi da bude prazna.',
        'Error: Please make sure your database accepts packages over %s MB in size (it currently only accepts packages up to %s MB). Please adapt the max_allowed_packet setting of your database in order to avoid errors.' =>
            'Greška: Molimo da proverite da vaša baza podataka prihvata pakete po veličini veće od %s MB  (trenutno prihvata pakete veličine do %s MB). Molimo da prilagodite parametar max_allowed_packet podešavanje u vašoj bazi podataka kako bi izbegli greške.',
        'Error: Please set the value for innodb_log_file_size on your database to at least %s MB (current: %s MB, recommended: %s MB). For more information, please have a look at %s.' =>
            'Greška: Molimo da podesete vrednost za innodb_log_file_size u vašoj bazi podataka na najmanje %s MB (trenutno: %s MB, preporučeno: %s MB). Za više informacija, molimo pogledajte na %s.',
        'Wrong database collation (%s is %s, but it needs to be utf8).' =>
            'Neispravno podešena baza podataka (%s je %s, a trebalo bi da bude utf8).',

        # Perl Module: Kernel/Modules/Mentions.pm
        '%s users will be mentioned' => '',

        # Perl Module: Kernel/Modules/PublicCalendar.pm
        'No %s!' => 'Bez %s!',
        'No such user!' => 'Nepoznat korisnik!',
        'Invalid calendar!' => 'Neispravan kalendar!',
        'Invalid URL!' => 'Neispravna adresa!',
        'There was an error exporting the calendar!' => 'Greška prilikom eksportovanja kalendara!',

        # Perl Module: Kernel/Modules/PublicRepository.pm
        'Need config Package::RepositoryAccessRegExp' => 'Neophodna konfiguracija Package::RepositoryAccessRegExp',
        'Authentication failed from %s!' => 'Autentifikacija nije uspela od %s!',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketBounce.pm
        'Bounce Article to a different mail address' => 'Preusmeravanje članka na drugu imejl adresu',
        'Bounce' => 'Preusmeri',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketCompose.pm
        'Reply All' => 'Odgovori na sve',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketEmailResend.pm
        'Resend this article' => 'Pošalji ponovo ovaj članak',
        'Resend' => 'Pošalji ponovo',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketMessageLog.pm
        'View message log details for this article' => 'Pregled loga poruke za ovaj članak',
        'Message Log' => 'Log poruke',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketNote.pm
        'Reply to note' => 'Odgovori na napomenu',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketNoteToLinkedTicket.pm
        'Create notice for linked ticket' => '',
        'Transfer notice' => '',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketPhone.pm
        'Split this article' => 'Podeli ovaj članak',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketPlain.pm
        'View the source for this Article' => 'Pogledaj izvor ovog Članka',
        'Plain Format' => 'Neformatiran format',

        # Perl Module: Kernel/Output/HTML/ArticleAction/AgentTicketPrint.pm
        'Print this article' => 'Odštampaj ovaj članak',

        # Perl Module: Kernel/Output/HTML/ArticleAction/GetHelpLink.pm
        'Contact us at sales@otrs.com' => 'Kontaktirajte nas na sales@otrs.com',
        'Get Help' => 'Traži pomoć',

        # Perl Module: Kernel/Output/HTML/ArticleAction/MarkAsImportant.pm
        'Mark' => 'Označeno',
        'Unmark' => 'Neoznačeno',

        # Perl Module: Kernel/Output/HTML/ArticleAction/ReinstallPackageLink.pm
        'Upgrade to OTRS Business Solution™' => 'Unapredite na OTRS Business Solution™',
        'Re-install Package' => 'Instaliraj ponovo paket',
        'Upgrade' => 'Ažuriranje',
        'Re-install' => 'Instaliraj ponovo',

        # Perl Module: Kernel/Output/HTML/ArticleCheck/PGP.pm
        'Crypted' => 'Šifrovano',
        'Sent message encrypted to recipient!' => 'Poslata šifrovana poruka primaocu!',
        'Signed' => 'Potpisano',
        '"PGP SIGNED MESSAGE" header found, but invalid!' => '"PGP SIGNED MESSAGE" zaglavlje pronađeno, ali je neispravno!',

        # Perl Module: Kernel/Output/HTML/ArticleCheck/SMIME.pm
        '"S/MIME SIGNED MESSAGE" header found, but invalid!' => '"S/MIME SIGNED MESSAGE" zaglavlje pronađeno, ali je neispravno!',
        'Ticket decrypted before' => 'Tiket je dešifrovan pre',
        'Impossible to decrypt: private key for email was not found!' => 'Nemoguće dešifrovanje: privatni ključ za ovu adresu nije pronađen!',
        'Successful decryption' => 'Uspešno dešifrovanje',

        # Perl Module: Kernel/Output/HTML/ArticleCompose/Crypt.pm
        'There are no encryption keys available for the addresses: \'%s\'. ' =>
            'Nisu pronađeni ključevi za šifrovanje za adresu: \'%s\'.',
        'There are no selected encryption keys for the addresses: \'%s\'. ' =>
            'Nisu odabrani ključevi za šifrovanje za adresu: \'%s\'.',
        'Cannot use expired encryption keys for the addresses: \'%s\'. ' =>
            'Nije moguće koristiti istekao ključ za šifrovanje za adrese: \'%s\'.',
        'Cannot use revoked encryption keys for the addresses: \'%s\'. ' =>
            'Nije moguće koristiti povučen ključ za šifrovanje za adrese: \'%s\'.',
        'Encrypt' => 'Šifrovanje',
        'Keys/certificates will only be shown for recipients with more than one key/certificate. The first found key/certificate will be pre-selected. Please make sure to select the correct one.' =>
            'Ključevi/sertifikati će biti prikazani samo za primaoce sa više od jednog ključeva/sertifikata. Prvi pronađeni ključ/sertifikat će biti automatski odabran. Molimo proverite da li je odabran ispravan.',

        # Perl Module: Kernel/Output/HTML/ArticleCompose/Security.pm
        'Email security' => 'Imejl bezbednost',
        'PGP sign' => 'PGP potpisivanje',
        'PGP sign and encrypt' => 'PGP potpis i šifrovanje',
        'PGP encrypt' => 'PGP šifrovanje',
        'SMIME sign' => 'SMIME potpisivanje',
        'SMIME sign and encrypt' => 'SMIME potpis i šifrovanje',
        'SMIME encrypt' => 'SMIME šifrovanje',

        # Perl Module: Kernel/Output/HTML/ArticleCompose/Sign.pm
        'Cannot use expired signing key: \'%s\'. ' => 'Nije moguće koristiti istekao ključ za potpisivanje: \'%s\'.',
        'Cannot use revoked signing key: \'%s\'. ' => 'Nije moguće koristiti povučen ključ za potpisivanje: \'%s\'.',
        'There are no signing keys available for the addresses \'%s\'.' =>
            'Nema ključeva za potpisivanje za adrese \'%s\'.',
        'There are no selected signing keys for the addresses \'%s\'.' =>
            'Nema odabranih ključeva za potpisivanje za adrese \'%s\'.',
        'Sign' => 'Potpis',
        'Keys/certificates will only be shown for a sender with more than one key/certificate. The first found key/certificate will be pre-selected. Please make sure to select the correct one.' =>
            'Ključevi/sertifikati će biti prikazani samo za pošiljaoce sa više od jednog ključeva/sertifikata. Prvi pronađeni ključ/sertifikat će biti automatski odabran. Molimo proverite da li je odabran ispravan.',

        # Perl Module: Kernel/Output/HTML/Dashboard/AppointmentCalendar.pm
        'Shown' => 'Prikazan',
        'Refresh (minutes)' => 'Osveži (minuta)',
        'off' => 'isključeno',

        # Perl Module: Kernel/Output/HTML/Dashboard/CustomerIDList.pm
        'Shown customer ids' => 'Prikazani klijent ID',

        # Perl Module: Kernel/Output/HTML/Dashboard/CustomerUserList.pm
        'Shown customer users' => 'Prikazani klijenti korisnici',
        'Offline' => 'Nije na vezi',
        'User is currently offline.' => 'Korisnik trenutno nije na vezi.',
        'User is currently active.' => 'Korisnik je trenutno aktivan.',
        'Away' => 'Odsutan',
        'User was inactive for a while.' => 'Korisnik nije bio aktivan neko vreme.',

        # Perl Module: Kernel/Output/HTML/Dashboard/EventsTicketCalendar.pm
        'The start time of a ticket has been set after the end time!' => 'Vreme početka tiketa je podešeno posle vremena završetka!',

        # Perl Module: Kernel/Output/HTML/Dashboard/MyLastChangedTickets.pm
        'Shown Tickets' => 'Prikazani tiketi',

        # Perl Module: Kernel/Output/HTML/Dashboard/News.pm
        'Can\'t connect to OTRS News server!' => 'Nije moguće povezati se sa OTRS News serverom!',
        'Can\'t get OTRS News from server!' => 'Ne mogu pribaviti OTRS News sa servera!',

        # Perl Module: Kernel/Output/HTML/Dashboard/ProductNotify.pm
        'Can\'t connect to Product News server!' => 'Nije moguće povezazi se sa Product News serverom!',
        'Can\'t get Product News from server!' => 'Ne mogu pribaviti Product News sa servera!',

        # Perl Module: Kernel/Output/HTML/Dashboard/RSS.pm
        'Can\'t connect to %s!' => 'Nije moguće povezati se sa %s!',

        # Perl Module: Kernel/Output/HTML/Dashboard/TicketGeneric.pm
        'Shown Columns' => 'Prikazane kolone',
        'filter not active' => 'filter nije aktivan',
        'filter active' => 'filter je aktivan',
        'This ticket has no title or subject' => 'Ovaj tiket nema naslov ili predmet',

        # Perl Module: Kernel/Output/HTML/Dashboard/TicketStatsGeneric.pm
        '7 Day Stats' => 'Sedmodnevna statistika',

        # Perl Module: Kernel/Output/HTML/Dashboard/UserOnline.pm
        'User set their status to unavailable.' => 'Korisnik je nedostupan.',
        'Unavailable' => 'Nedostupno',

        # Perl Module: Kernel/Output/HTML/Layout.pm
        'Standard' => 'Standardan',
        'The following tickets are not updated: %s.' => 'Sledeći tiketi nisu ažurirani: %s.',
        'h' => 'č',
        'm' => 'm',
        'd' => 'd',
        'This ticket does not exist, or you don\'t have permissions to access it in its current state. You can take one of the following actions:' =>
            'Ovaj tiket više ne postoji, ili trenutno nemate dozvolu za pristup istom. Možete preduzeti jednu od sledećih akcija:',
        'This is a' => 'Ovo je',
        'email' => 'imejl',
        'click here' => 'kliknite ovde',
        'to open it in a new window.' => 'za otvaranje u novom prozoru.',
        'Year' => 'Godina',
        'Hours' => 'Sati',
        'Minutes' => 'Minuti',
        'Check to activate this date' => 'Proverite za aktiviranje ovog datuma',
        '%s TB' => '%s TB',
        '%s GB' => '%s GB',
        '%s MB' => '%s MB',
        '%s KB' => '%s KB',
        '%s B' => '%s B',
        'No Permission!' => 'Nemate dozvolu!',
        'No Permission' => 'Nema dozvole',
        'Show Tree Selection' => 'Prikaži drvo izbora',
        'Split Quote' => 'Podeli kvotu',
        'Remove Quote' => 'Ukloni kvotu.',
        'Last Views' => '',

        # Perl Module: Kernel/Output/HTML/Layout/LinkObject.pm
        'Linked as' => 'Povezano kao',
        'Search Result' => 'Rezultat pretrage',
        'Linked' => 'Povezano',
        'Bulk' => 'Masovno',

        # Perl Module: Kernel/Output/HTML/Layout/Ticket.pm
        'Lite' => 'Jednostavan',
        'Unread article(s) available' => 'Raspoliživi nepročitani članci',

        # Perl Module: Kernel/Output/HTML/LinkObject/Appointment.pm
        'Appointment' => 'Termin',

        # Perl Module: Kernel/Output/HTML/LinkObject/Ticket.pm
        'Archive search' => 'Pretraga arhive',

        # Perl Module: Kernel/Output/HTML/Notification/AgentOTRSBusiness.pm
        'Please verify your license data!' => 'Molimo proverite podatke vaše licence!',
        'The license for your %s is about to expire. Please make contact with %s to renew your contract!' =>
            'Licenca za vaš %s ističe uskoro. Molimo da kontaktirate %s radi obnove ugovora!',
        'An update for your %s is available, but there is a conflict with your framework version! Please update your framework first!' =>
            'Ažuriranje za vaš %s je dostupno, ali postoji neusaglašenost sa verzijom vašeg sistema! Molimo vas da prvo ažurirate verziju vašeg sistema!',

        # Perl Module: Kernel/Output/HTML/Notification/AgentOnline.pm
        'Online Agent: %s' => 'Operater na vezi: %s',

        # Perl Module: Kernel/Output/HTML/Notification/AgentTicketEscalation.pm
        'There are more escalated tickets!' => 'Ima još eskaliralih tiketa!',

        # Perl Module: Kernel/Output/HTML/Notification/AgentTimeZoneCheck.pm
        'Please select a time zone in your preferences and confirm it by clicking the save button.' =>
            'Molimo odaberite vremensku zonu u ličnim podešavanjima i potvrdite klikom na dugme za čuvanje.',

        # Perl Module: Kernel/Output/HTML/Notification/CustomerOnline.pm
        'Online Customer: %s' => 'Klijent na vezi: %s',

        # Perl Module: Kernel/Output/HTML/Notification/CustomerSystemMaintenanceCheck.pm
        'System maintenance is active!' => 'Održavanje sistema je aktivno!',
        'A system maintenance period will start at: %s and is expected to stop at: %s' =>
            'Period održavanja sistema će otpočeti u: %s i očekivano je da se završi u: %s',

        # Perl Module: Kernel/Output/HTML/Notification/DaemonCheck.pm
        'OTRS Daemon is not running.' => 'OTRS sistemski servis ne radi.',

        # Perl Module: Kernel/Output/HTML/Notification/OAuth2TokenManagementTokenExpired.pm
        'OAuth2 token for "%s" has expired.' => '',
        'OAuth2 refresh token for "%s" has expired.' => '',

        # Perl Module: Kernel/Output/HTML/Notification/OutofOfficeCheck.pm
        'You have Out of Office enabled, would you like to disable it?' =>
            'Aktivirana je opcija van kancelarije, želite li da je isključite?',

        # Perl Module: Kernel/Output/HTML/Notification/SystemConfigurationInvalidCheck.pm
        'You have %s invalid setting(s) deployed. Click here to show invalid settings.' =>
            'Imate %s raspoređeno(a) nevažeće(a) podešavanje(a). Kliknite ovde za prikaz nevažećih podešavanja.',

        # Perl Module: Kernel/Output/HTML/Notification/SystemConfigurationIsDirtyCheck.pm
        'You have undeployed settings, would you like to deploy them?' =>
            'Imate neraspoređenih podešavanja, da li želite da ih rasporedite?',

        # Perl Module: Kernel/Output/HTML/Notification/SystemConfigurationOutOfSyncCheck.pm
        'The configuration is being updated, please be patient...' => 'Konfiguracija se osvežava, molimo sačekajte...',
        'There is an error updating the system configuration!' => 'Greška prilikom osvežavanja sistemske konfiguracije!',

        # Perl Module: Kernel/Output/HTML/Notification/UIDCheck.pm
        'Don\'t use the Superuser account to work with %s! Create new Agents and work with these accounts instead.' =>
            'Ne koristite superkorisnički nalog za rad sa %s! Napravite nove naloge za operatere i koristite njih.',

        # Perl Module: Kernel/Output/HTML/Preferences/AppointmentNotificationEvent.pm
        'Please make sure you\'ve chosen at least one transport method for mandatory notifications.' =>
            'Molimo vas da proverite da ste izabrali bar jedan metod transporta za obavezna obaveštenja.',
        'Preferences updated successfully!' => 'Postavke su uspešno ažurirane!',

        # Perl Module: Kernel/Output/HTML/Preferences/Language.pm
        '(in process)' => '(u toku)',

        # Perl Module: Kernel/Output/HTML/Preferences/MaxArticlesPerPage.pm
        'Max. number of articles per page must be between 1 and 1000 or empty.' =>
            '',

        # Perl Module: Kernel/Output/HTML/Preferences/OutOfOffice.pm
        'Please specify an end date that is after the start date.' => 'Molimo da odredite datum završetka koji je posle datuma početka.',

        # Perl Module: Kernel/Output/HTML/Preferences/Password.pm
        'Current password' => 'Sadašnja lozinka',
        'New password' => 'Nova lozinka',
        'Verify password' => 'Potvrdi lozinku',
        'The current password is not correct. Please try again!' => 'Aktuelna lozinka je netačna. Molimo pokušajte ponovo!',
        'Please supply your new password!' => 'Molimo da obezbedite novu lozinku!',
        'Can\'t update password, your new passwords do not match. Please try again!' =>
            'Lozinka ne može biti ažurirana, novi unosi su različiti. Molimo pokušajte ponovo!',
        'This password is forbidden by the current system configuration. Please contact the administrator if you have additional questions.' =>
            'Ova lozinka je zabranjena trenutnom sistemskom konfiguracijom. Molimo kontaktirajte adminstratora za dodatna pitanja.',
        'Can\'t update password, it must be at least %s characters long!' =>
            'Lozinka ne može biti ažurirana. Minimalna dužina lozinke je %s znakova.',
        'Can\'t update password, it must contain at least 2 lowercase and 2 uppercase letter characters!' =>
            'Lozinka ne može biti ažurirana, mora sadržati najmanje 2 mala i 2 velika slova!',
        'Can\'t update password, it must contain at least 1 digit!' => 'Lozinka ne može biti ažurirana. Mora da sadrži najnmanje jednu brojku.',
        'Can\'t update password, it must contain at least 2 letter characters!' =>
            'Lozinka ne može biti ažurirana, mora sadržati najmanje 2 slova!',

        # Perl Module: Kernel/Output/HTML/Preferences/TimeZone.pm
        'Time zone updated successfully!' => 'Vremenska zona uspešno ažurirana!',

        # Perl Module: Kernel/Output/HTML/Statistics/View.pm
        'invalid' => 'nevažeći',
        'valid' => 'važeći',
        'No (not supported)' => 'Ne (nije podržano)',
        'No past complete or the current+upcoming complete relative time value selected.' =>
            'Nije odabrana vremenska vrednost sa kompletnom prošlošću ili kompletnim trenutnim i budućim relativnim periodom.',
        'The selected time period is larger than the allowed time period.' =>
            'Izabrani vremenski period je duži od dozvoljenog.',
        'No time scale value available for the current selected time scale value on the X axis.' =>
            'Nema dostupnog vremenskog opsega za aktuelnu izabranu vrednost opsega na X osi.',
        'The selected date is not valid.' => 'Izabrani datum nije važeći.',
        'The selected end time is before the start time.' => 'Izabrano vreme završetka je pre vremena početka.',
        'There is something wrong with your time selection.' => 'Nešto nije u redu sa vašim izborom vremena.',
        'Please select only one element or allow modification at stat generation time.' =>
            'Molimo da izaberete samo jedan element ili dozvolite izmene u vreme generisanja starta!',
        'Please select at least one value of this field or allow modification at stat generation time.' =>
            'Molimo da izaberete barem jednu vrednost ovog polja ili dozvolite izmenu u vreme generisanja statistike.',
        'Please select one element for the X-axis.' => 'Molimo da izaberete jedan element za X-osu.',
        'You can only use one time element for the Y axis.' => 'Možete koristiti samo jedan vremenski element za Y osu.',
        'You can only use one or two elements for the Y axis.' => 'Možete da koristite samo jedan ili dva elementa za Y osu.',
        'Please select at least one value of this field.' => 'Molimo da izaberete bar jednu vrednost za ovo polje.',
        'Please provide a value or allow modification at stat generation time.' =>
            'Molimo da obezbedite vrednost ili dozvolite izmene u vreme generisanja starta.',
        'Please select a time scale.' => 'Molimo da odaberete vremenski opseg.',
        'Your reporting time interval is too small, please use a larger time scale.' =>
            'Vaš interval izveštavanja je prekratak, molimo upotrebite veći raspon vremena.',
        'second(s)' => 'sekunde(e)',
        'quarter(s)' => 'tromesečje(a)',
        'half-year(s)' => 'polugodište(a)',
        'Please remove the following words because they cannot be used for the ticket restrictions: %s.' =>
            'Molimo da uklonite sledeće reči jer se ne mogu koristiti zbog ograničenja tiketa: %s.',

        # Perl Module: Kernel/Output/HTML/SysConfig.pm
        'Cancel editing and unlock this setting' => 'Odustani od promene i otključaj ovo podešavanje',
        'Reset this setting to its default value.' => 'Poništi ovo podešavanje na podrazumevanu vrednost',
        'Unable to load %s!' => 'Nije moguće učitati %s!',
        'Content' => 'Sadržaj',

        # Perl Module: Kernel/Output/HTML/TicketMenu/Lock.pm
        'Unlock to give it back to the queue' => 'Otključajte za vraćanje u red',
        'Lock it to work on it' => 'Zaključajte za rad na tiketu',

        # Perl Module: Kernel/Output/HTML/TicketMenu/TicketWatcher.pm
        'Unwatch' => 'Prekini nadzor',
        'Remove from list of watched tickets' => 'Ukloni sa liste praćenih tiketa',
        'Watch' => 'Posmatraj',
        'Add to list of watched tickets' => 'Dodaj na listu praćenih tiketa',

        # Perl Module: Kernel/Output/HTML/TicketOverviewMenu/Sort.pm
        'Order by' => 'Sortiraj po',

        # Perl Module: Kernel/Output/HTML/TicketZoom/TicketInformation.pm
        'Ticket Information' => 'Informacije o tiketu',

        # Perl Module: Kernel/Output/HTML/ToolBar/TicketLocked.pm
        'Locked Tickets New' => 'Novi zaključani tiketi',
        'Locked Tickets Reminder Reached' => 'Dostignut podsetnik zaključanih tiketa',
        'Locked Tickets Total' => 'Ukupno zaključnih tiketa',

        # Perl Module: Kernel/Output/HTML/ToolBar/TicketMention.pm
        'Total mentions' => '',
        'Total new mentions' => '',
        'New mentions' => '',

        # Perl Module: Kernel/Output/HTML/ToolBar/TicketOwner.pm
        'Owned Tickets New' => '',
        'Owned Tickets Reminder Reached' => '',
        'Owned Tickets Total' => '',

        # Perl Module: Kernel/Output/HTML/ToolBar/TicketResponsible.pm
        'Responsible Tickets New' => 'Novi odgovorni tiketi',
        'Responsible Tickets Reminder Reached' => 'Dostignut podsetnik odgovornih tiketa',
        'Responsible Tickets Total' => 'Ukupno odgovornih tiketa',

        # Perl Module: Kernel/Output/HTML/ToolBar/TicketWatcher.pm
        'Watched Tickets New' => 'Novi praćeni tiketi',
        'Watched Tickets Reminder Reached' => 'Dostignut podsetnik praćenih tiketa',
        'Watched Tickets Total' => 'Ukupno praćenih tiketa',

        # Perl Module: Kernel/Output/PDF/Ticket.pm
        'Ticket Dynamic Fields' => 'Dinamička polja tiketa',

        # Perl Module: Kernel/System/ACL/DB/ACL.pm
        'Couldn\'t read ACL configuration file. Please make sure the file is valid.' =>
            'Učitavanje ACL konfiguracije nije bilo moguće. Molimo proverite da li je fajl ispravan.',

        # Perl Module: Kernel/System/Auth.pm
        'It is currently not possible to login due to a scheduled system maintenance.' =>
            'Prijava trenutno nije moguća zbog planiranog održavanja sistema.',

        # Perl Module: Kernel/System/AuthSession.pm
        'You have exceeded the number of concurrent agents - contact sales@otrs.com.' =>
            'Prekoračili ste broj istovremeno prijavljenih operatera - kontaktirajte sales@otrs.com.',
        'Please note that the session limit is almost reached.' => 'Imajte u vidu da je ograničenje sesija skoro dostignuto.',
        'Login rejected! You have exceeded the maximum number of concurrent Agents! Contact sales@otrs.com immediately!' =>
            'Prijava odbijena! Prekoračili ste dozvoljeni broj istovremeno prijavljenih operatera! Pod hitno kontaktirajte sales@otrs.com!',
        'Session limit reached! Please try again later.' => 'Sesija je istekla! Molimo pokušajte kasnije!',
        'Session per user limit reached!' => 'Dostignuto ograničenje broja sesija po korisniku!',

        # Perl Module: Kernel/System/AuthSession/DB.pm
        'Session invalid. Please log in again.' => 'Sesija je nevažeća. Molimo prijavite se ponovo.',
        'Session has timed out. Please log in again.' => 'Vreme sesije je isteklo. Molimo prijavite se ponovo.',

        # Perl Module: Kernel/System/Calendar/Event/Transport/Email.pm
        'PGP sign only' => 'Samo PGP potpis',
        'PGP encrypt only' => 'Samo PGP šifrovanje',
        'SMIME sign only' => 'Samo SMIME potpis',
        'SMIME encrypt only' => 'Samo SMIME šifrovanje',
        'PGP and SMIME not enabled.' => 'PGP i SMIME nisu omogućeni!',
        'Skip notification delivery' => 'Preskoči dostavu obaveštenja',
        'Send unsigned notification' => 'Pošalji nepotpisano obaveštenje',
        'Send unencrypted notification' => 'Pošalji nešifovano obaveštenje',

        # Perl Module: Kernel/System/Calendar/Plugin/Ticket/Create.pm
        'On the date' => '',

        # Perl Module: Kernel/System/CalendarEvents.pm
        'on' => '',
        'of year' => '',
        'of month' => '',
        'all-day' => '',

        # Perl Module: Kernel/System/Console/Command/Dev/Tools/Config2Docbook.pm
        'Configuration Options Reference' => 'Referentni spisak konfiguracionih opcija',
        'This setting can not be changed.' => 'Ovo podešavanje se ne može menjati.',
        'This setting is not active by default.' => 'Ovo podešavanje nije podrazumevano aktivno.',
        'This setting can not be deactivated.' => 'Ovo podešavanje se ne može deaktivirati.',
        'This setting is not visible.' => 'Ovo podešavanje nije vidljivo.',
        'This setting can be overridden in the user preferences.' => 'Ovo podešavanje može biti pregaženo u ličnim podešavanjima korisnika.',
        'This setting can be overridden in the user preferences, but is not active by default.' =>
            'Ovo podešavanje može biti pregaženo u ličnim podešavanjima korisnika, ali nije podrazumevano aktivno.',

        # Perl Module: Kernel/System/CustomerUser.pm
        'Customer user "%s" already exists.' => 'Klijent korisnik "%s" već postoji.',

        # Perl Module: Kernel/System/CustomerUser/DB.pm
        'This email address is already in use for another customer user.' =>
            'Ova adresa elektronske pošte je već iskorišćena za drugog klijent korisnika.',

        # Perl Module: Kernel/System/DynamicField/Driver/BaseDateTime.pm
        'before/after' => 'pre/posle',
        'between' => 'između',

        # Perl Module: Kernel/System/DynamicField/Driver/BaseText.pm
        'e.g. Text or Te*t' => 'npr. Text ili Te*t',

        # Perl Module: Kernel/System/DynamicField/Driver/Checkbox.pm
        'Ignore this field.' => 'Ignoriši ovo polje.',

        # Perl Module: Kernel/System/DynamicField/Driver/TextArea.pm
        'This field is required or' => 'Ovo polje je obavezno ili',
        'The field content is too long!' => 'Sadržaj polja je predugačak!',
        'Maximum size is %s characters.' => 'Maksimalna veličina je %s karaktera.',

        # Perl Module: Kernel/System/MailQueue.pm
        'Error while validating Message data.' => '',
        'Error while validating Sender email address.' => '',
        'Error while validating Recipient email address.' => '',

        # Perl Module: Kernel/System/Mention.pm
        'LastMention' => '',

        # Perl Module: Kernel/System/NotificationEvent.pm
        'Couldn\'t read Notification configuration file. Please make sure the file is valid.' =>
            'Učitavanje konfiguracije obaveštenja nije bilo moguće. Molimo proverite da li je fajl ispravan.',
        'Imported notification has body text with more than 4000 characters.' =>
            'Tekst sadržaja uvezenog obaveštenja ima više od 4000 karaktera.',

        # Perl Module: Kernel/System/Package.pm
        'not installed' => 'nije instalirano',
        'installed' => 'instalirano',
        'Unable to parse repository index document.' => 'Nije moguće raščlaniti spremište indeksa dokumenta.',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' =>
            'Nema paketa za verziju vašeg sistema, u spremištu su samo paketi za druge verzije.',
        'File is not installed!' => 'Datoteka nije instalirana!',
        'File is different!' => 'Datoteka je različita!',
        'Can\'t read file!' => 'Nemoguće čitanje datoteke!',

        # Perl Module: Kernel/System/ProcessManagement/DB/Process.pm
        'The process "%s" and all of its data has been imported successfully.' =>
            'Proces "%s" i sve informacije vezane za njega su uspešno uvezeni.',

        # Perl Module: Kernel/System/ProcessManagement/DB/Process/State.pm
        'Inactive' => 'Neaktivno',
        'FadeAway' => 'U gašenju',

        # Perl Module: Kernel/System/Registration.pm
        'Can\'t contact registration server. Please try again later.' => 'Ne možete da kontaktirate server za registraciju. Molimo pokušajte ponovo kasnije.',
        'No content received from registration server. Please try again later.' =>
            'Sadržaj nije primljen od servera za registraciju. Molimo pokušajte ponovo kasnije.',
        'Can\'t get Token from sever' => 'Ne mogu pribaviti token od servera',
        'Username and password do not match. Please try again.' => 'Korisničko ime i lozinka se ne poklapaju. Molimo pokušajte ponovo.',
        'Problems processing server result. Please try again later.' => 'Problemi u obradi rezultata servera. Molimo pokušajte ponovo kasnije.',

        # Perl Module: Kernel/System/Stats.pm
        'Sum' => 'Zbir',
        'week' => 'nedelja',
        'quarter' => 'tromesečje',
        'half-year' => 'polugodište',

        # Perl Module: Kernel/System/Stats/Dynamic/Ticket.pm
        'State Type' => 'Tip statusa',
        'Created Priority' => 'Napravljeni prioriteti',
        'Created State' => 'Kreirani status',
        'Create Time' => 'Vreme kreiranja',
        'Pending until time' => 'Vreme čekanja',
        'Close Time' => 'Vreme zatvaranja',
        'Escalation' => 'Eskalacija',
        'Escalation - First Response Time' => 'Eskalacija - vreme prvog odziva',
        'Escalation - Update Time' => 'Eskalacija - vreme ažuriranja',
        'Escalation - Solution Time' => 'Eskalacija - vreme rešavanja',
        'Agent/Owner' => 'Operater/Vlasnik',
        'Created by Agent/Owner' => 'Kreirao Operater/Vlasnik',
        'Assigned to Customer User Login' => 'Dodeljeni klijent korisnik',

        # Perl Module: Kernel/System/Stats/Dynamic/TicketAccountedTime.pm
        'Evaluation by' => 'Procenio',
        'Ticket/Article Accounted Time' => 'Obračunato vreme',
        'Ticket Create Time' => 'Vreme otvaranja tiketa',
        'Ticket Close Time' => 'Vreme zatvaranja tiketa',
        'Accounted time by Agent' => 'Obračunato vreme po operateru',
        'Total Time' => 'Ukupno vreme',
        'Ticket Average' => 'Prosečno vreme po tiketu',
        'Ticket Min Time' => 'Minimalno vreme tiketa',
        'Ticket Max Time' => 'Maksimalno vreme tiketa',
        'Number of Tickets' => 'Broj tiketa',
        'Article Average' => 'Prosečno vreme po članku',
        'Article Min Time' => 'Minimalno vreme članka',
        'Article Max Time' => 'Maksimalno vreme članka',
        'Number of Articles' => 'Broj članaka',

        # Perl Module: Kernel/System/Stats/Dynamic/TicketList.pm
        'unlimited' => 'neograničeno',
        'Attributes to be printed' => 'Atributi za štampu',
        'Sort sequence' => 'Redosled sortiranja',
        'State Historic' => 'Istorijat statusa',
        'State Type Historic' => 'Istorijat tipa statusa',
        'Historic Time Range' => 'Vremenski opseg istorijata',
        'Number' => 'Broj',
        'Last Changed' => 'Posledni put promenjeno',

        # Perl Module: Kernel/System/Stats/Dynamic/TicketSolutionResponseTime.pm
        'Solution Average' => 'Prosečno vreme rešenja',
        'Solution Min Time' => 'Minimalno vreme rešenja',
        'Solution Max Time' => 'Maksimalno vreme rešenja',
        'Solution Average (affected by escalation configuration)' => 'Prosečno vreme rešenja (pod uticajem postavki eskalacije)',
        'Solution Min Time (affected by escalation configuration)' => 'Minimalno vreme rešenja (pod uticajem postavki eskalacije)',
        'Solution Max Time (affected by escalation configuration)' => 'Maksimalno vreme rešenja (pod uticajem postavki eskalacije)',
        'Solution Working Time Average (affected by escalation configuration)' =>
            'Prosečno radno vreme rešenja (pod uticajem postavki eskalacije)',
        'Solution Min Working Time (affected by escalation configuration)' =>
            'Minimalno radno vreme rešenja (pod uticajem postavki eskalacije)',
        'Solution Max Working Time (affected by escalation configuration)' =>
            'Maksimalno radno vreme rešenja (pod uticajem postavki eskalacije)',
        'First Response Average (affected by escalation configuration)' =>
            'Prosečno vreme prvog odgovora (pod uticajem postavki eskalacije)',
        'First Response Min Time (affected by escalation configuration)' =>
            'Minimalno vreme prvog odgovora (pod uticajem postavki eskalacije)',
        'First Response Max Time (affected by escalation configuration)' =>
            'Maksimalno vreme prvog odgovora (pod uticajem postavki eskalacije)',
        'First Response Working Time Average (affected by escalation configuration)' =>
            'Prosečno radno vreme prvog odgovora (pod uticajem postavki eskalacije)',
        'First Response Min Working Time (affected by escalation configuration)' =>
            'Minimalno radno vreme prvog odgovora (pod uticajem postavki eskalacije)',
        'First Response Max Working Time (affected by escalation configuration)' =>
            'Maksimalno radno vreme prvog odgovora (pod uticajem postavki eskalacije)',
        'Number of Tickets (affected by escalation configuration)' => 'Broj tiketa (pod uticajem postavki eskalacije)',

        # Perl Module: Kernel/System/Stats/Static/StateAction.pm
        'Days' => 'Dani',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/OutdatedTables.pm
        'Outdated Tables' => 'Zastarele tabele',
        'Outdated tables were found in the database. These can be removed if empty.' =>
            'U bazi podataka su pronađene zastarele tabele. Ukoliko su prazne, tabele mogu biti slobodno uklonjene.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/TablePresence.pm
        'Table Presence' => 'Prisustvo tabele',
        'Internal Error: Could not open file.' => 'Interna greška: Nije moguće otvoriti datoteku.',
        'Table Check' => 'Provera tabele',
        'Internal Error: Could not read file.' => 'Interna greška: Nije moguće pročitati datoteku.',
        'Tables found which are not present in the database.' => 'Pronađene tabele koje nisu prisutne u bazi podataka.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mssql/Size.pm
        'Database Size' => 'Veličina baze podataka',
        'Could not determine database size.' => 'Nije moguće utvrditi veličinu baze podataka.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mssql/Version.pm
        'Database Version' => 'Verzija baze podataka',
        'Could not determine database version.' => 'Nije moguće utvrditi verziju baze podataka',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mysql/Charset.pm
        'Client Connection Charset' => 'Karakterset za povezivanje klijenta',
        'Setting character_set_client needs to be utf8.' => 'Podešavanje character_set_client mora biti utf8.',
        'Server Database Charset' => 'Karakterset serverske baze podataka',
        'This character set is not yet supported, please see https://bugs.otrs.org/show_bug.cgi?id=12361. Please convert your database to the character set \'utf8\'.' =>
            '',
        'The setting character_set_database needs to be \'utf8\'.' => 'Podešavanje character_set_database mora biti \'utf8\'.',
        'Table Charset' => 'Tabela karakterseta',
        'There were tables found which do not have \'utf8\' as charset.' =>
            'Pronađene su tabele koje nemaju \'utf8\' kao karakterset.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mysql/InnoDBLogFileSize.pm
        'InnoDB Log File Size' => 'Veličina InnoDB log datoteke',
        'The setting innodb_log_file_size must be at least 256 MB.' => 'Podešavanje innodb_log_file_size mora biti barem 256 MB.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mysql/InvalidDefaultValues.pm
        'Invalid Default Values' => 'Neispravne podrazumevane vrednosti',
        'Tables with invalid default values were found. In order to fix it automatically, please run: bin/otrs.Console.pl Maint::Database::Check --repair' =>
            'Pronađene su tabele sa neispravnim podrazumevanim vrednostima. Da biste ih automatski ispravili, molimo pokrenite bin/otrs.Console.pl Maint::Database::Check --repair',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mysql/MaxAllowedPacket.pm
        'Maximum Query Size' => 'Maksimalna veličina upita',
        'The setting \'max_allowed_packet\' must be higher than 64 MB.' =>
            'Podešavanje \'max_allowed_packet\' mora biti više od 64 MB.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mysql/StorageEngine.pm
        'Default Storage Engine' => 'Podrazumevani mehanizam za skladištenje',
        'Table Storage Engine' => 'Mehanizam za skladištenje tabele',
        'Tables with a different storage engine than the default engine were found.' =>
            'Pronađene su tabele sa različitim mehanizmom za skladištenje nego što je predefinisani mehanizam.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/mysql/Version.pm
        'MySQL 5.x or higher is required.' => 'Neophodan je MySQL 5.x ili više.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/oracle/NLS.pm
        'NLS_LANG Setting' => 'NLS_LANG podešavanje',
        'NLS_LANG must be set to al32utf8 (e.g. GERMAN_GERMANY.AL32UTF8).' =>
            'NLS_LANG mora biti podešen na al32utf8 (npr. GERMAN_GERMANY.AL32UTF8).',
        'NLS_DATE_FORMAT Setting' => 'NLS_DATE_FORMAT podešavanje',
        'NLS_DATE_FORMAT must be set to \'YYYY-MM-DD HH24:MI:SS\'.' => 'NLS_DATE_FORMAT mora biti podešen na \'YYYY-MM-DD HH24:MI:SS\'.',
        'NLS_DATE_FORMAT Setting SQL Check' => 'SQL provera NLS_DATE_FORMAT podešavanja',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/oracle/PrimaryKeySequencesAndTriggers.pm
        'Primary Key Sequences and Triggers' => 'Sekvence i okidači primarnih ključeva',
        'The following sequences and/or triggers with possible wrong names have been found. Please rename them manually.' =>
            'Pronađene su sekvence i/ili okidači sa mogućim pogrešnim nazivima. Molimo vas da im ručno promenite nazive.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/postgresql/Charset.pm
        'Setting client_encoding needs to be UNICODE or UTF8.' => 'Podešavanje client_encoding mora biti UNICODE ili UTF8.',
        'Setting server_encoding needs to be UNICODE or UTF8.' => 'Podešavanje server_encoding mora biti UNICODE ili UTF8.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/postgresql/DateStyle.pm
        'Date Format' => 'Format datuma',
        'Setting DateStyle needs to be ISO.' => 'Podešavanje DateStyle mora biti ISO.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/postgresql/PrimaryKeySequences.pm
        'Primary Key Sequences' => 'Sekvence primarnih ključeva',
        'The following sequences with possible wrong names have been found. Please rename them manually.' =>
            'Pronađene su sekvence sa mogućim pogrešnim nazivima. Molimo vas da im ručno promenite nazive.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Database/postgresql/Version.pm
        'PostgreSQL 9.2 or higher is required.' => 'Neophodan je PostgreSQL 9.2 ili više.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/DiskPartitionOTRS.pm
        'Operating System' => 'Operativni sistem',
        'OTRS Disk Partition' => 'OTRS particija na disku',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/DiskSpace.pm
        'Disk Usage' => 'Korišćenje diska',
        'The partition where OTRS is located is almost full.' => 'Particija na kojoj je smešten OTRS je skoro puna.',
        'The partition where OTRS is located has no disk space problems.' =>
            'Particija na kojoj je smešten OTRS nema probleme sa prostorom.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/DiskSpacePartitions.pm
        'Disk Partitions Usage' => 'Korišćenje particije na disku',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/Distribution.pm
        'Distribution' => 'Raspodela',
        'Could not determine distribution.' => 'Nije moguće utvrditi raspodelu.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/KernelVersion.pm
        'Kernel Version' => 'Kernel verzija',
        'Could not determine kernel version.' => 'Nije moguće utvrditi kernel verziju',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/Load.pm
        'System Load' => 'Opterećenje sistema',
        'The system load should be at maximum the number of CPUs the system has (e.g. a load of 8 or less on a system with 8 CPUs is OK).' =>
            'Opterećenje sistema može biti najviše broj procesora koje sistem poseduje (npr. opterećenje od 8 ili manje na sistemu sa 8 jezgara je u redu).',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/PerlModules.pm
        'Perl Modules' => 'Perl moduli',
        'Not all required Perl modules are correctly installed.' => 'Svi zahtevani Perl moduli nisu korektno instalirani.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/PerlModulesAudit.pm
        'Perl Modules Audit' => 'Sigurnosna provera Perl modula',
        'CPAN::Audit reported that one or more installed Perl modules have known vulnerabilities. Please note that there might be false positives for distributions patching Perl modules without changing their version number.' =>
            'CPAN::Audit je detektovao jedan ili više ranjivih Perl modula instaliranih na sistemu. Molimo obratite pažnju da su mogući lažno pozitivni rezultati za distribucije koje osvežavaju Perl module bez promene njihove verzije.',
        'CPAN::Audit did not report any known vulnerabilities in the installed Perl modules.' =>
            'CPAN::Audit nije detektovao ranjive Perl module instalirane na sistemu.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/PerlVersion.pm
        'Perl Version' => 'Perl verzija',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OS/Swap.pm
        'Free Swap Space (%)' => 'Slobodni Swap prostor (%)',
        'No swap enabled.' => 'Razmenjivanje nije aktivirano.',
        'Used Swap Space (MB)' => 'Upotrebljen Swap prostor (MB)',
        'There should be more than 60% free swap space.' => 'Mora postojati više od 60 % slobodnog swap prostora',
        'There should be no more than 200 MB swap space used.' => 'Ne treba da bude više od 200 MB upotrebljenog Swap prostora.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/ArticleSearchIndexStatus.pm
        'OTRS' => 'OTRS',
        'Article Search Index Status' => 'Stanje indeksa pretrage članaka',
        'Indexed Articles' => 'Indeksiranih članaka',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/ArticlesPerCommunicationChannel.pm
        'Articles Per Communication Channel' => 'Članaka po komunikacionom kanalu',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/CommunicationLog.pm
        'Incoming communications' => 'Dolazne komunikacije',
        'Outgoing communications' => 'Odlazne komunikacije',
        'Failed communications' => 'Neuspele komunikacije',
        'Average processing time of communications (s)' => 'Prosečno vreme trajanja komunikacija (s)',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/CommunicationLogAccountStatus.pm
        'Communication Log Account Status (last 24 hours)' => 'Stanje naloga komunikacionog loga (poslednjih 24 sata)',
        'No connections found.' => 'Nisu pronađene konekcije.',
        'ok' => 'u redu',
        'permanent connection errors' => 'trajne greške u konekciji',
        'intermittent connection errors' => 'povremene greške u konekciji',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/ConfigSettings.pm
        'Config Settings' => 'Podešavanja konfiguracije',
        'Could not determine value.' => 'Nije moguće utvrditi vrednost.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/DaemonRunning.pm
        'Daemon' => 'Sistemski servis',
        'Daemon is running.' => 'Servis radi.',
        'Daemon is not running.' => 'Servis ne radi.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/DatabaseRecords.pm
        'Database Records' => 'Zapisi u bazi podataka',
        'Tickets' => 'Tiketi',
        'Ticket History Entries' => 'Istorija unosa tiketa',
        'Articles' => 'Članci',
        'Attachments (DB, Without HTML)' => 'Prilozi (baza podataka, bez HTML)',
        'Customers With At Least One Ticket' => 'Klijenti sa bar jednim tiketom',
        'Dynamic Field Values' => 'Vrednosti dinamičkog polja',
        'Invalid Dynamic Fields' => 'Nevažeća dinamička polja.',
        'Invalid Dynamic Field Values' => 'Nevažeće vrednosti dinamičkih polja.',
        'GenericInterface Webservices' => 'GenericInterface veb servis',
        'Process Tickets' => 'Proces tiketi',
        'Months Between First And Last Ticket' => 'Meseci između prvog i poslednjeg tiketa',
        'Tickets Per Month (avg)' => 'Tiketi mesečno (prosečno)',
        'Open Tickets' => 'Otvoreni tiketi',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/DefaultSOAPUser.pm
        'Default SOAP Username And Password' => 'Podrazumevano SOAP korisničko ime i lozinka',
        'Security risk: you use the default setting for SOAP::User and SOAP::Password. Please change it.' =>
            'Sigurnosni rizik: koristite podrazumevana podešavanja za SOAP::User i SOAP::Password. Molimo promenite ga.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/DefaultUser.pm
        'Default Admin Password' => 'Predefinisana lozinka administratora',
        'Security risk: the agent account root@localhost still has the default password. Please change it or invalidate the account.' =>
            'Sigurnosni rizik: agent nalog root@localhost još uvek ima predefinisanu lozinku. Molimo promenite je ili deaktivirajte nalog.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/EmailQueue.pm
        'Email Sending Queue' => 'Red za slanje imejlova',
        'Emails queued for sending' => 'Broj imejlova zakazanih za slanje',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/FQDN.pm
        'FQDN (domain name)' => 'FQDN (naziv domena)',
        'Please configure your FQDN setting.' => 'Molimo da konfigurišete FQDN podešavanje.',
        'Domain Name' => 'Naziv domena',
        'Your FQDN setting is invalid.' => 'Vaša FQDN podešavanja su nevažeća.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/FileSystemWritable.pm
        'File System Writable' => 'Omogućeno pisanje u sistem datoteka.',
        'The file system on your OTRS partition is not writable.' => 'Nije moguće pisanje u sistem datoteka na vašoj OTRS particiji.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/LegacyConfigBackups.pm
        'Legacy Configuration Backups' => 'Rezervne kopije prošlih konfiguracija',
        'No legacy configuration backup files found.' => 'Nisu pronađene rezervne kopije prošlih konfiguracija.',
        'Legacy configuration backup files found in Kernel/Config/Backups folder, but they might still be required by some packages.' =>
            'Pronađene su rezervne kopije prošlih konfiguracija u Kernel/Config/Backups, međutim mogu biti neophodne za rad instaliranih paketa.',
        'Legacy configuration backup files are no longer needed for the installed packages, please remove them from Kernel/Config/Backups folder.' =>
            'Rezervne kopije prošlih konfiguracija više nisu neophodne za rad instaliranih paketa, molimo uklonite ih iz Kernel/Config/Backups.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/MultipleJSFileLoad.pm
        'Views with multiple loaded JavaScript files' => '',
        'The following JavaScript files loaded multiple times:' => '',
        'Files' => '',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/PackageDeployment.pm
        'Package Installation Status' => 'Status instalacije paketa',
        'Some packages have locally modified files.' => 'Neki paketi sadrže lokalno izmenjene datoteke.',
        'Some packages are not correctly installed.' => 'Neki paketi nisu ispravno instalirani.',
        'Package Framework Version Status' => 'Status paketa za verziju sistema',
        'Some packages are not allowed for the current framework version.' =>
            'Neki paketi nisu dozvoljeni za verziju vašeg sistema. ',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/PackageList.pm
        'Package List' => 'Lista paketa',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/SessionConfigSettings.pm
        'Session Config Settings' => 'Podešavanja sesija',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/SpoolMails.pm
        'Spooled Emails' => 'Imejlovi u redu čekanja',
        'There are emails in var/spool that OTRS could not process.' => 'Postoje imejlovi u var/spool koje OTRS ne može da obradi.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/SystemID.pm
        'Your SystemID setting is invalid, it should only contain digits.' =>
            'Vaša podešavanje SystemID je nevažeće, treba da sadrži samo cifre.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/Ticket/DefaultType.pm
        'Default Ticket Type' => 'Podrazumevani tip tiketa',
        'The configured default ticket type is invalid or missing. Please change the setting Ticket::Type::Default and select a valid ticket type.' =>
            'Podešeni podrazumevani tip tiketa je nevažeći ili nedostaje. Molimo promenite podešavanje Ticket::Type::Default i izaberite važeći tip tiketa.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/Ticket/IndexModule.pm
        'Ticket Index Module' => 'Tiket indeks modul',
        'You have more than 60,000 tickets and should use the StaticDB backend. See admin manual (Performance Tuning) for more information.' =>
            'Imate više od 60.000 tiketa i treba da koristite StaticDB modul. Pogledajte administratorsko uputstvo (Podešavanje performansi) za više informacija.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/Ticket/InvalidUsersWithLockedTickets.pm
        'Invalid Users with Locked Tickets' => 'Neispravni korisnici sa zaključanim tiketima',
        'There are invalid users with locked tickets.' => 'Postoje neispravni korisnici sa zaključanim tiketima.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/Ticket/OpenTickets.pm
        'You should not have more than 8,000 open tickets in your system.' =>
            'Ne bi trebalo da imate više od 8.000 otvorenih tiketa u sistemu.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/Ticket/SearchIndexModule.pm
        'Ticket Search Index Module' => 'Modul za indeksnu pretragu tiketa',
        'The indexing process forces the storage of the original article text in the article search index, without executing filters or applying stop word lists. This will increase the size of the search index and thus may slow down fulltext searches.' =>
            'Proces indeksiranja će uključiti spremanje originalnog teksta članka u indeksu pretrage, bez izvršavanja filtera ili uklanjanja zaustavnih reči. Ovo će uvećati veličinu indeksa pretrage i može usporiti tekstualnu pretragu.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/Ticket/StaticDBOrphanedRecords.pm
        'Orphaned Records In ticket_lock_index Table' => 'Napušteni zapisi u ticket_lock_index tabeli',
        'Table ticket_lock_index contains orphaned records. Please run bin/otrs.Console.pl "Maint::Ticket::QueueIndexCleanup" to clean the StaticDB index.' =>
            'Tabela ticket_lock_index sadrži nepovezane zapise. Molimo da pokrenete bin/otrs.Console.pl Maint::Ticket::QueueIndexCleanup da bi očistili StaticDB indeks.',
        'Orphaned Records In ticket_index Table' => 'Napušteni zapisi u ticket_index tabeli',
        'Table ticket_index contains orphaned records. Please run bin/otrs.Console.pl "Maint::Ticket::QueueIndexCleanup" to clean the StaticDB index.' =>
            'Tabela ticket_lindex sadrži nepovezane zapise. Molimo da pokrenete bin/otrs.Console.pl Maint::Ticket::QueueIndexCleanup da bi očistili StaticDB indeks.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/TimeSettings.pm
        'Time Settings' => 'Podešavanja vremena',
        'Server time zone' => 'Vremenska zona servera',
        'OTRS time zone' => 'OTRS vremenska zona',
        'OTRS time zone is not set.' => 'OTRS vremenska zona nije podešena.',
        'User default time zone' => 'Podrazumevana vremenska zona korisnika',
        'User default time zone is not set.' => 'Podrazumevana vremenska zona korisnika nije podešena.',
        'Calendar time zone is not set.' => 'Vremenska zona kalendara nije podešena.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/UI/AgentSkinUsage.pm
        'UI - Agent Skin Usage' => 'UI - izgledi interfejsa operatera u korišćenju',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/UI/AgentThemeUsage.pm
        'UI - Agent Theme Usage' => 'UI - teme interfejsa operatera u korišćenju',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/UI/SpecialStats.pm
        'UI - Special Statistics' => 'UI - posebne statistike',
        'Agents using custom main menu ordering' => 'Operateri sa prilagođenim redosledom glavnog menija',
        'Agents using favourites for the admin overview' => 'Operateri sa omiljenim stavkama za administratorski pregled',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/OTRS/Version.pm
        'OTRS Version' => 'OTRS verzija',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Webserver/Apache/LoadedModules.pm
        'Webserver' => 'Veb server',
        'Loaded Apache Modules' => 'Učitani Apache moduli',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Webserver/Apache/MPMModel.pm
        'MPM model' => 'MPM model',
        'OTRS requires apache to be run with the \'prefork\' MPM model.' =>
            'OTRS zahteva da Apache bude pokrenut sa \'prefork\' MPM modelom.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Webserver/Apache/Performance.pm
        'CGI Accelerator Usage' => 'Upotreba CGI Accelerator',
        'You should use FastCGI or mod_perl to increase your performance.' =>
            'Za povećanje performansi treba da koristite FastCGI ili mod_perl.',
        'mod_deflate Usage' => 'Upotreba mod_deflate',
        'Please install mod_deflate to improve GUI speed.' => 'Molimo instalirajte mod_deflate za ubrzavanje grafičkog interfejsa.',
        'mod_filter Usage' => 'Korišćenje mod_filter',
        'Please install mod_filter if mod_deflate is used.' => 'Molimo da instalirate mod_filter ako je mod_deflate upotrebljen.',
        'mod_headers Usage' => 'Upotreba mod_headers',
        'Please install mod_headers to improve GUI speed.' => 'Molimo instalirajte mod_headers za ubrzavanje grafičkog interfejsa.',
        'Apache::Reload Usage' => 'Upotreba Apache::Reload',
        'Apache::Reload or Apache2::Reload should be used as PerlModule and PerlInitHandler to prevent web server restarts when installing and upgrading modules.' =>
            'Apache::Reload ili Apache2::Reload se koriste kao Perl modul i PerlInitHandler radi zaštite od restartovanja veb servera tokom instaliranja ili nadogradnje modula.',
        'Apache2::DBI Usage' => 'Upotreba Apache2::DBI',
        'Apache2::DBI should be used to get a better performance  with pre-established database connections.' =>
            'Apache2::DBI bi trebalo koristiti za bolje performanse sa unapred uspostavljenim vezama sa bazom podataka.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Webserver/EnvironmentVariables.pm
        'Environment Variables' => 'Promenljive za okruženje',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Webserver/InternalWebRequest.pm
        'Support Data Collection' => 'Sakupljanje podataka podrške',
        'Support data could not be collected from the web server.' => 'Podaci podrške ne mogu biti prikupljeni sa veb servera.',

        # Perl Module: Kernel/System/SupportDataCollector/Plugin/Webserver/Version.pm
        'Webserver Version' => 'Veb server verzija',
        'Could not determine webserver version.' => 'Ne može da prepozna veb server verziju.',

        # Perl Module: Kernel/System/SupportDataCollector/PluginAsynchronous/OTRS/ConcurrentUsers.pm
        'Concurrent Users Details' => 'Detalji istovremenih korisnika',
        'Concurrent Users' => 'Istovremeni korisnici',

        # Perl Module: Kernel/System/SupportDataCollector/PluginBase.pm
        'OK' => 'U redu',
        'Problem' => 'Problem',

        # Perl Module: Kernel/System/SysConfig.pm
        'Setting %s does not exists!' => 'Podešavanje %s ne postoji!',
        'Setting %s is not locked to this user!' => 'Podešavanje %s nije zaključano na ovog korisnika!',
        'Setting value is not valid!' => 'Vrednost podešavanja je nevažeća!',
        'Could not add modified setting!' => 'Nije moguće dodati promenjeno podešavanje!',
        'Could not update modified setting!' => 'Nije moguće ažurirati promenjeno podešavanje!',
        'Setting could not be unlocked!' => 'Nije moguće otključati podešavanje!',
        'Missing key %s!' => 'Nedostaje ključ %s!',
        'Invalid setting: %s' => 'Nevažeće podešavanje: %s',
        'Could not combine settings values into a perl hash.' => 'Nije bilo moguće iskombinovati vrednost podešavanja u perl mapu.',
        'Can not lock the deployment for UserID \'%s\'!' => 'Nije bilo moguće obezbediti raspoređivanje za UserID \'%s\'!',
        'All Settings' => 'Sva podešavanja',

        # Perl Module: Kernel/System/SysConfig/BaseValueType.pm
        'Default' => 'Podrazumevano',
        'Value is not correct! Please, consider updating this field.' => 'Vrednost nije ispravna! Molimo osvežite ovo polje.',
        'Value doesn\'t satisfy regex (%s).' => 'Vrednost ne zadovoljava regularni izraz (%s).',

        # Perl Module: Kernel/System/SysConfig/ValueType/Checkbox.pm
        'Enabled' => 'Omogućen',
        'Disabled' => 'Onemogućen',

        # Perl Module: Kernel/System/SysConfig/ValueType/Date.pm
        'System was not able to calculate user Date in OTRSTimeZone!' => 'Sistem nije uspeo da izračuna korisnički Date u OTRSTimeZone!',

        # Perl Module: Kernel/System/SysConfig/ValueType/DateTime.pm
        'System was not able to calculate user DateTime in OTRSTimeZone!' =>
            'Sistem nije uspeo da izračuna korisnički DateTime u OTRSTimeZone!',

        # Perl Module: Kernel/System/SysConfig/ValueType/FrontendNavigation.pm
        'Value is not correct! Please, consider updating this module.' =>
            'Vrednost nije ispravna! Molimo osvežite ovaj modul.',

        # Perl Module: Kernel/System/SysConfig/ValueType/VacationDays.pm
        'Value is not correct! Please, consider updating this setting.' =>
            'Vrednost nije ispravna! Molimo osvežite ovo podešavanje.',

        # Perl Module: Kernel/System/Ticket.pm
        'Reset of unlock time.' => 'Poništavanje vremena otključavanja.',

        # Perl Module: Kernel/System/Ticket/Article/Backend/Chat.pm
        'Chat Participant' => 'Učesnik ćaskanja',
        'Chat Message Text' => 'Poruka ćaskanja',

        # Perl Module: Kernel/System/Web/InterfaceAgent.pm
        'Login failed! Your user name or password was entered incorrectly.' =>
            'Neuspešna prijava! Netačno je uneto vaše korisničko ime ili lozinka.',
        'Authentication succeeded, but no user data record is found in the database. Please contact the administrator.' =>
            'Autentifikacija je uspela, ali podaci o klijentu nisu pronađeni u bazi. Molimo kontaktirajte administratora.',
        'Can`t remove SessionID.' => 'SessionID se ne može ukloniti.',
        'Logout successful.' => 'Uspešna odjava.',
        'Feature not active!' => 'Funkcija nije aktivna!',
        'Sent password reset instructions. Please check your email.' => 'Uputstvo za reset lozinke je poslato. Molimo proverite vaše imejlove.',
        'Invalid Token!' => 'Nevažeći Token!',
        'Sent new password to %s. Please check your email.' => 'Poslata nova lozinka za %s. Molimo proverite vaše imejlove.',
        'Error: invalid session.' => 'Greška: nevažeća sesija.',
        'No Permission to use this frontend module!' => 'Nemate dozvolu za  upotrebu ovog korisničkog modula!',

        # Perl Module: Kernel/System/Web/InterfaceCustomer.pm
        'Authentication succeeded, but no customer record is found in the customer backend. Please contact the administrator.' =>
            'Autentifikacija je uspela, ali podaci o klijentu nisu pronađeni u izvoru klijenata. Molimo kontaktirajte administratora.',
        'Reset password unsuccessful. Please contact the administrator.' =>
            'Poništavanje lozinke nije uspelo. Molimo kontaktirajte administratora',
        'This e-mail address already exists. Please log in or reset your password.' =>
            'Ova imejl adresa već postoji. Molimo, prijavite se ili resetujte vašu lozinku.',
        'This email address is not allowed to register. Please contact support staff.' =>
            'Registracija ove imejl adrese nije dozvoljeno. Molimo da kontaktirate podršku.',
        'Added via Customer Panel (%s)' => 'Dodato preko klijentskog panela (%s)',
        'Customer user can\'t be added!' => 'Ne može se dodati klijent korisnik!',
        'Can\'t send account info!' => 'Ne mogu poslati info o nalogu!',
        'New account created. Sent login information to %s. Please check your email.' =>
            'Kreiran je novi nalog. Podaci za prijavu poslati %s. Molimo proverite vaš imejl.',

        # Perl Module: Kernel/System/Web/InterfaceInstaller.pm
        'Action "%s" not found!' => 'Akcija "%s" nije pronađena!',

        # XML Definition: Kernel/Config/Files/XML/Calendar.xml
        'Frontend module registration for the public interface.' => 'Registracija pristupnog modula za javni interfejs.',
        'Frontend module registration for the agent interface.' => 'Registracija modula pristupa za interfejs operatera.',
        'Loader module registration for the agent interface.' => 'Registracija modula za učitavanje za interfejs operatera.',
        'Main menu item registration.' => 'Registracija stavke glavnog menija.',
        'Admin area navigation for the agent interface.' => 'Administratorska navigacija za intefejs operatera.',
        'Maximum number of active calendars in overview screens. Please note that large number of active calendars can have a performance impact on your server by making too much simultaneous calls.' =>
            'Maksimalni broj aktivnih kalendara u ekranima za pregled. Obratite pažnju da veliki broj aktivnih kalendara može imati uticaj na performanse vašeg servera pravljenjem previše simultanih zahteva.',
        'List of colors in hexadecimal RGB which will be available for selection during calendar creation. Make sure the colors are dark enough so white text can be overlayed on them.' =>
            'Lista boja u heksadecimalnom RGB zapisu koje će biti dostupne za izbor prilikom pravljenja kalendara. Obratite pažnju da su boje dovoljno tamne tako da beli tekst može biti ispisan na njima.',
        'Defines available groups for the appointment calendar screen.' =>
            '',
        'Defines the ticket plugin for calendar appointments.' => 'Definiše dodatni modul tiketa za kalendarske termine.',
        'Links appointments and tickets with a "Normal" type link.' => 'Povezuje termine i tikete "Normalnim" vrstama veza.',
        'Define Actions where a settings button is available in the linked objects widget (LinkObject::ViewMode = "complex"). Please note that these Actions must have registered the following JS and CSS files: Core.AllocationList.css, Core.UI.AllocationList.js, Core.UI.Table.Sort.js, Core.Agent.TableFilters.js.' =>
            'Definiše akcije na kojima je omogućen prikaz dugmeta za podešavanje u aplikativnom dodatku linkovanih objekata (LinkObject::ViewMode = "complex"). Napominjemo da ove akcije moraju imati registrovane sledeće JS i CSS datoteke: Core.AllocationList.css, Core.UI.AllocationList.js, Core.UI.Table.Sort.js, Core.Agent.TableFilters.js.',
        'Define which columns are shown in the linked appointment widget (LinkObject::ViewMode = "complex"). Possible settings: 0 = Disabled, 1 = Available, 2 = Enabled by default.' =>
            'Definiše koje kolone će biti prikazane u dodatku linkovanih termina (LinkObject::ViewMode = "složeno"). Moguća podešavanja: 0 = isključeno, 1 = uključeno, 2 = podrazumevano uključeno.',
        'OTRS doesn\'t support recurring Appointments without end date or number of iterations. During import process, it might happen that ICS file contains such Appointments. Instead, system creates all Appointments in the past, plus Appointments for the next N months (120 months/10 years by default).' =>
            'OTRS ne podržava termine koji se ponavljaju bez krajnjeg datuma ili broja iteracija. Prilikom uvoza kalendara, može se dogoditi da ICS datoteka sadrži takve \'beskonačne\' termine. Umesto takvog ponašanja, sistem će kreirati sve termine iz prošlosti, kao i termine za sledeći n broj meseci (podrazumevano 120 meseci/10 godina).',
        'Defines the ticket appointment type backend for ticket escalation time.' =>
            'Definiše modul termina tiketa za vreme eskalacije.',
        'Defines the ticket appointment type backend for ticket pending time.' =>
            'Definiše modul termina tiketa za vreme čekanja.',
        'Defines the ticket appointment type backend for ticket dynamic field date time.' =>
            'Definiše modul termina tiketa za dinamičko polje datuma.',
        'Defines the list of params that can be passed to ticket search function.' =>
            'Definiše listu parametara koji mogu biti prosleđeni funkciji pretrage tiketa.',
        'Defines the event object types that will be handled via AdminAppointmentNotificationEvent.' =>
            'Definiše tipove objekta događaja koji će biti procesirani putem AdminAppointmentNotificationEvent.',
        'List of all calendar events to be displayed in the GUI.' => 'Lista svih događaja na kalendarima koja će biti prikazana u grafičkom interfejsu.',
        'List of all appointment events to be displayed in the GUI.' => 'Lista svih obaveštenja o terminima za prikaz u grafičkom interfejsu.',
        'Appointment calendar event module that prepares notification entries for appointments.' =>
            'Modul događaja kalendara za pripremu obaveštenja o terminima.',
        'Uses richtext for viewing and editing ticket notification.' => 'Koristi richtext format za pregled i uređivanje obaveštenja o tiketima.',
        'Defines the width for the rich text editor component for this screen. Enter number (pixels) or percent value (relative).' =>
            'Određuje širinu za komponentu rich text editor za ovaj prikaz ekrana. Unesi broj (pikseli) ili procentualnu vrednost (relativnu).',
        'Defines the height for the rich text editor component for this screen. Enter number (pixels) or percent value (relative).' =>
            'Određuje visinu za komponentu Rich Text Editor za ovaj prikaz ekrana. Unesi broj (pikseli) ili procentualnu vrednost (relativnu).',
        'Transport selection for appointment notifications. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Izbor transporta za obaveštenja o terminu. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Defines the number of character per line used in case an HTML article preview replacement on TemplateGenerator for EventNotifications.' =>
            'Određuje broj znakova po liniji koji se koriste u slučaju zamene za pregled HTML članka u generatoru šablona za obaveštenja o događajima.',
        'Defines all the parameters for this notification transport.' => 'Definiše sve parametre za ovaj transport obaveštenja.',
        'Appointment calendar event module that updates the ticket with data from ticket appointment.' =>
            'Modul događaja kalendara za osvežavanje tiketa podacima iz termina.',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Definiše parametre za dodatak kontrolne table. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Shows a link in the menu for creating a calendar appointment linked to the ticket directly from the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju tiketa za kreiranje termina u kalendaru povezanog sa tim tiketom. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Defines an icon with link to the google map page of the current location in appointment edit screen.' =>
            'Definiše ikonu sa linkom na Google mapu trenutne lokacije u ekranu za izmenu termina.',
        'Triggers add or update of automatic calendar appointments based on certain ticket times.' =>
            'Aktivira dodavanje ili osvežavanje automatskih termina na osnovu vremena tiketa.',

        # XML Definition: Kernel/Config/Files/XML/CloudServices.xml
        'Defines if the communication between this system and OTRS Group servers that provide cloud services is possible. If set to \'Disable cloud services\', some functionality will be lost such as system registration, support data sending, upgrading to and use of OTRS Business Solution™, OTRS Verify™, OTRS News and product News dashboard widgets, among others.' =>
            'Definiše da li je moguća komunikacija između ovog sistema i servera OTRS grupe koji obezbeđuju servise u oblaku. Ako je podešeno na \'Onemogući servise u oblaku\' neke funkcionalnosti neće raditi, a to su registracija sistema, slanje podataka podrške, unapređenje na OTRS Business Solution™, OTRS verifikacija, OTRS novosti i novosti o proizvodu u dodacima na kontrolnoj tabli, između ostalih.',
        'Cloud service admin module registration for the transport layer.' =>
            'Registracija admin modula servisa u oblaku za transportni sloj.',

        # XML Definition: Kernel/Config/Files/XML/Daemon.xml
        'Defines the module to display a notification in the agent interface if the OTRS Daemon is not running.' =>
            'Određuje modul za prikaz obaveštenja u interfejsu operatera ako OTRS sistemski servis ne radi.',
        'List of CSS files to always be loaded for the agent interface.' =>
            'Lista CSS direktorijuma uvek učitanih za interfejs operatera.',
        'List of JS files to always be loaded for the agent interface.' =>
            'Lista JS direktorijuma uvek učitanih za interfejs operatera.',
        'Type of daemon log rotation to use: Choose \'OTRS\' to let OTRS system to handle the file rotation, or choose \'External\' to use a 3rd party rotation mechanism (i.e. logrotate). Note: External rotation mechanism requires its own and independent configuration.' =>
            'Vrsta rotacije servisnog loga: izaberite \'OTRS\' da dopustite OTRS sistemu da rotira logove, ili \'Eksterno\' za drugi mehanizam rotacije (npr. logrotate). Napomena: ekterni rotacioni mehanizmi zahtevaju sopstvenu i nezavisnu konfiguraciju.',
        'If enabled the daemon will use this directory to create its PID files. Note: Please stop the daemon before any change and use this setting only if &lt;$OTRSHome&gt;/var/run/ can not be used.' =>
            '',
        'Defines the number of days to keep the daemon log files.' => 'Određuje koliko dana će se čuvati datoteke istorijata rada sistemskog servisa',
        'If enabled the daemon will redirect the standard output stream to a log file.' =>
            'Ako je aktivirano, servis će preusmeriti standardni izlazni tok u log datoteku.',
        'If enabled the daemon will redirect the standard error stream to a log file.' =>
            'Ako je aktivirano, servis će preusmeriti standardni tok greške u log datoteku.',
        'The daemon registration for the scheduler generic agent task manager.' =>
            'Registracija modula servisa za poslove generičkog operatera.',
        'The daemon registration for the scheduler cron task manager.' =>
            'Registracija modula servisa za planirane poslove.',
        'The daemon registration for the scheduler future task manager.' =>
            'Registracija modula servisa za buduće poslove.',
        'The daemon registration for the scheduler task worker.' => 'Registracija modula servisa za radne poslove.',
        'The daemon registration for the system configuration deployment sync manager.' =>
            'Registracija modula servisa za sinhronizaciju rasporeda sistemske konfiguracije.',
        'Defines the maximum number of tasks to be executed as the same time.' =>
            'Definiše maksimalni broj poslova koji će se izvršavati u isto vreme.',
        'Specifies the email addresses to get notification messages from scheduler tasks.' =>
            'Odredi imejl adresu koja će dobijati poruke obaveštenja od poslova planera.',
        'Defines the maximum number of affected tickets per job.' => 'Definiše maksimalni broj obuhvaćenih tiketa po poslu.',
        'Defines a sleep time in microseconds between tickets while they are been processed by a job.' =>
            'Definiše vreme spavanja u mikrosekundama između tiketa dok se obrađuju od strane posla.',
        'Delete expired cache from core modules.' => 'Brisanje isteklog keša iz osnovnih modula.',
        'Delete expired upload cache hourly.' => 'Briše zastarele otpremljene datoteke svakog sata.',
        'Delete expired loader cache weekly (Sunday mornings).' => 'Briše istekli keš učitavanja sedmično (nedeljom ujutro).',
        'Fetch emails via fetchmail.' => 'Preuzima imejlove preko fetchmail programa.',
        'Fetch emails via fetchmail (using SSL).' => 'Preuzima imejlove preko fetchmail programa (putem SSL).',
        'Generate dashboard statistics.' => 'Generiši statistike kontrolne table.',
        'Triggers ticket escalation events and notification events for escalation.' =>
            'Aktivira eskalacione događaje tiketa i događaje obaveštenja za eskalacije.',
        'Process pending tickets.' => 'Proces tiket na čekanju.',
        'Reprocess mails from spool directory that could not be imported in the first place.' =>
            'Ponovo obradi imejlove iz direktorijuma reda čekanja koji prvi put nisu mogli biti uvezeni.',
        'Fetch incoming emails from configured mail accounts.' => 'Preuzimanje ',
        'Rebuild the ticket index for AgentTicketQueue.' => 'Ponovo izradi indeks tiketa za operaterski red tiketa.',
        'Delete expired sessions.' => 'Briše istekle sesije',
        'Unlock tickets that are past their unlock timeout.' => 'Otključaj tikete kojima je isteklo vreme odlaganja za otključavanje.',
        'Renew existing SMIME certificates from customer backend. Note: SMIME and SMIME::FetchFromCustomer needs to be enabled in SysConfig and customer backend needs to be configured to fetch UserSMIMECertificate attribute.' =>
            'Obnavlja postojeće SMIME sertifikate iz izvora klijenata. Napomena: SMIME i SMIME::FetchFromCustomer moraju biti uključeni u konfiguraciji i izvor klijenata mora biti podešen za preuzimanje UserSMIMECertificate atributa.',
        'Checks for articles that needs to be updated in the article search index.' =>
            'Proverava članke koje treba osvežiti u indeksu pretrage.',
        'Checks for queued outgoing emails to be sent.' => 'Proverava zakazane imejlove za slanje.',
        'Checks for communication log entries to be deleted.' => 'Proverava stavke komunikacionog loga za brisanje.',
        'Executes a custom command or module. Note: if module is used, function is required.' =>
            'Izvršava prilagođenu komandu ili modul. Napomena: ako je upotrebljen modul, funkcija je neophodna.',
        'Run file based generic agent jobs (Note: module name needs to be specified in -configuration-module param e.g. "Kernel::System::GenericAgent").' =>
            'Pokreće poslove generičkog operatera bazirane na datotekama (Napomena: naziv modula mora biti definisan u konfiguraciji parametara modula, npr. "Kernel::System::GenericAgent").',
        'Collect support data for asynchronous plug-in modules.' => 'Prikupi podatke podrške za asinhdone priključne module.',
        'Defines the default the number of seconds (from current time) to re-schedule a generic interface failed task.' =>
            'Definiše podrazumevani broj sekundi (od sadašnjeg momenta) do ponovnog rasporeda neuspešnog posla u generičkom interfejsu.',
        'Removes old system configuration deployments (Sunday mornings).' =>
            'Uklanja stare rasporede sistemske konfiguracije (nedeljom ujutru).',
        'Removes old ticket number counters (each 10 minutes).' => 'Uklanja stare brojače tiketa (svakih 10 minuta).',
        'Removes old generic interface debug log entries created before the specified amount of days.' =>
            'Uklanja stare logove otklanjanja grešaka generičkog interfejsa koji su kreirani pre definisanog broja dana.',
        'Delete expired ticket draft entries.' => 'Briše zastarele nacrte tiketa.',

        # XML Definition: Kernel/Config/Files/XML/Framework.xml
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If not enabled, the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If enabled, it also disables the GenericAgent, PackageManager and SQL Box.' =>
            'Onemogućuje pristup instalacionom ekranu (http://yourhost.example.com/otrs/installer.pl) u svrhu zaštite sistema od nedozvoljenog preuzimanja. Ako je isključeno, sistem može biti ponovo instaliran i trenutna osnovna konfiguracija će biti korišćena da unapred popuni pitanja unutar instalacionog ekrana. Ukoliko nije uključeno, takođe se onemogućuju GenericAgent, PackageManager i SQL Box.',
        'Enables or disables the debug mode over frontend interface.' => 'Uključuje ili isključuje mod traženja grešaka preko pristupnog interfejsa.',
        'Delivers extended debugging information in the frontend in case any AJAX errors occur, if enabled.' =>
            'Omogućava pribavljanje dodatnih informacija o greškama u interfejsu, u slučaju problema sa AJAX metodom.',
        'Enables or disables the caching for templates. WARNING: Do NOT disable template caching for production environments for it will cause a massive performance drop! This setting should only be disabled for debugging reasons!' =>
            'Aktivira ili deaktivira keširanje za šablone. UPOZORENJE: NEMOJTE isključivati keširanje šablona na sistemima u radu jer će to dovesti do ogromnog pada performansi. Ovo podešavanje treba koristiti samo u cilju nalaženja i otklanjanja grešaka!',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' =>
            'Postavi konfiguracioni nivo za administratora. U zavisnosti od konfiguracionog nivoa, neke sistemske opcije neće biti prikazane. Konfiguracioni nivoi poređani rastuće: Ekspert, Napredni, Početni. Što je viši nivo (npr Početni je najviši), manja je verovatnoća da korisnik može da konfiguriše sistem tako da više nije upotrebljiv.',
        'Controls if the admin is allowed to import a saved system configuration in SysConfig.' =>
            'Kontroliše da li je administratoru dozvoljeno da uveze sačuvanu sistemsku konfiguraciju u „SysConfig”.',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' =>
            'Definiše naziv aplikacije, koji se prikazuje u veb interfejsu, karticama i naslovnoj traci veb pretraživača.',
        'Defines the system identifier. Every ticket number and http session string contains this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' =>
            'Definiše identifikator sistema. Svaki broj tiketa i niz znakova „http” sesije sadrši ovaj ID. Ovo osigurava da će samo tiketi koji pripadaju vašem sistemu biti obrađeni kao operacije praćenja (korisno kada se odvija komunikacija između dve „OTRS” instance).',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' =>
            'Definiše potpuno kvalifikovano ime domena sistema. Ovo podešavanje se koristi kao promenljiva OTRS_CONFIG_FQDN, koja se nalazi u svim formama poruka i koristi od strane aplikacije, za građenje veza do tiketa unutar vašeg sistema.',
        'Defines the HTTP hostname for the support data collection with the public module \'PublicSupportDataCollector\' (e.g. used from the OTRS Daemon).' =>
            'Definiše HTTP host za slanje podataka podrške preko javnog module \'PublicSupportDataCollector\' (npr. od strane OTRS sistemskog servisa).',
        'Defines the timeout (in seconds, minimum is 20 seconds) for the support data collection with the public module \'PublicSupportDataCollector\' (e.g. used from the OTRS Daemon).' =>
            'Definiše predviđeno vreme (u sekundama, minimum je 20 sekundi) za prikupljanje podataka podrške putem modula javog interfejsa \'PublicSupportDataCollector\' (npr. kad se koristi putem OTRS sistemskog servisa).',
        'Defines the type of protocol, used by the web server, to serve the application. If https protocol will be used instead of plain http, it must be specified here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is only used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' =>
            'Definiše tip protokola korišćenog od strane veb servera, za potrebe aplikacije. Ako se koristi https protokol umesto plain http, mora biti ovde naznačeno. Pošto ovo nema uticaja na podešavanja ili ponašanje veb servera, neće promeniti način pristupa aplikaciji i, ako je to pogrešno, neće vas sprečiti da se prijavite u aplikaciju. Ovo podešavanje se koristi samo kao promenljiva, OTRS_CONFIG_HttpType koja se nalazi u svim oblicima poruka korišćenih od strane aplikacije, da izgrade veze sa tiketima u vašem sistemu.',
        'Whether to force redirect all requests from http to https protocol. Please check that your web server is configured correctly for https protocol before enable this option.' =>
            'Određuje da li će svi zahtevi sa http biti preusmereni na https protokol. Molimo proverite da li je vaš veb server pravilno podešen za https protokol pre uključivanja ove opcije.',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' =>
            'Definiše putanju foldera sa skriptama na serveru, prema podešavanju veb servera. Ova opcija se koristi kao promenljiva OTRS_CONFIG_ScriptAlias u svim oblicima komunikacije širom sistema, radi generisanja veza ka tiketima.',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' =>
            'Definiše imejl adresu sistem administratora. Ona će biti prikazana na ekranima za greške u aplikaciji.',
        'Company name which will be included in outgoing emails as an X-Header.' =>
            'Naziv firme koji će biti uključen u odlazne imejlove kao X-Zaglavlje.',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' =>
            'Definiše podrazumevani jezik glavnog korisničkog dela. Sve moguće vrednosti su određene u raspoloživim jezičkim datotekama u sistemu (pogledajte sledeća podešavanja).',
        'Defines all the languages that are available to the application. Specify only English names of languages here.' =>
            'Definiše sve jezike koji su dostupni aplikaciji. Ovde unesite imena jezika samo na engleskom.',
        'Defines all the languages that are available to the application. Specify only native names of languages here.' =>
            'Definiše sve jezike koji su dostupni aplikaciji. Ovde unesite imena jezika samo na matičnom jeziku.',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. If you like, you can add your own theme. Please refer the administrator manual located at https://doc.otrs.com/doc/.' =>
            'Određuje podrazumevanu temu glavnog interfejsa (HTML) koja će biti korišćena od strane operatera ili klijenata. Ukoliko želite možete dodati vašu ličnu temu. Molimo vas da pogledate uputstvo za administratora, koje se nalazi na https://doc.otrs.com/doc/.',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' =>
            'Moguće je podesiti različite teme za različite operatere i korisnike, koji se koriste na nivou domena u aplikaciji. Korišćenjem regularnog izraza (regex), možete podesiti par ključ/vrednost za prepoznavanje domena. Vrednost u Key bi trebalo da prepozna domen, a vrednost u Content bi trebalo da bude važeća tema u sistemu. Molimo konsultujte primere za ispravan oblik regularnog izraza.',
        'The headline shown in the customer interface.' => 'Naslov prikazan u klijentskom interfejsu.',
        'The logo shown in the header of the customer interface. The URL to the image can be a relative URL to the skin image directory, or a full URL to a remote web server.' =>
            'Logo prikazan u zaglavlju klijentskog interfejsa. URL do slike može biti relativan u odnosu na direktorijum sa slikama ili apsolutan do udaljenog servera.',
        'The logo shown in the header of the agent interface. The URL to the image can be a relative URL to the skin image directory, or a full URL to a remote web server.' =>
            'Logo prikazan u zaglavlju operaterskog interfejsa. URL do slike može biti relativan u odnosu na direktorijum sa slikama ili apsolutan do udaljenog servera.',
        'The logo shown in the header of the agent interface for the skin "default". See "AgentLogo" for further description.' =>
            'Logo prikazan u zaglavlju interfejsa operatera za izgled "podrazumevani". Pogledajte "AgentLogo" za detaljniji opis.',
        'The logo shown in the header of the agent interface for the skin "slim". See "AgentLogo" for further description.' =>
            'Logo prikazan u zaglavlju interfejsa operatera za "uprošćeni" izgled. Pogledajte "AgentLogo" za detaljniji opis.',
        'The logo shown in the header of the agent interface for the skin "ivory". See "AgentLogo" for further description.' =>
            'Logo prikazan u zaglavlju interfejsa operatera za izgled Slonovača. Pogledajte AgentLogo za detaljniji opis.',
        'The logo shown in the header of the agent interface for the skin "ivory-slim". See "AgentLogo" for further description.' =>
            'Logo prikazan u zaglavlju interfejsa operatera za izgled Slonovača (uprošćeno). Pogledajte AgentLogo za detaljniji opis.',
        'The logo shown in the header of the agent interface for the skin "High Contrast". See "AgentLogo" for further description.' =>
            'Logo prikazan u zaglavlju interfejsa operatera za izgled "High Contrast". Pogledajte "AgentLogo" za detaljniji opis.',
        'The logo shown on top of the login box of the agent interface. The URL to the image can be a relative URL to the skin image directory, or a full URL to a remote web server.' =>
            'Logo prikazan u zaglavlju interfejsa operatera. URL do slike može biti relativan u odnosu na direktorijum sa slikama ili apsolutan do udaljenog servera.',
        'Defines the URL base path of icons, CSS and Java Script.' => 'Definiše URL osnovnu putanju za ikone, CSS i Java Script.',
        'Defines the URL image path of icons for navigation.' => 'Definiše URL putanju do slika za navigacione ikone.',
        'Defines the URL CSS path.' => 'Definiše URL CSS putanju.',
        'Defines the URL java script path.' => 'Definiše URL putanju java skriptova.',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard templates, auto responses and notifications.' =>
            'Koristi richtekt format za pregled i uređivanje: članaka, pozdrava, potpisa, standardnih šablona, automatskih odgovora i obaveštenja.',
        'Defines the URL rich text editor path.' => 'Definiše URL Reach Text Editor putanju.',
        'Defines the default CSS used in rich text editors.' => 'Definiše podrazumevani CSS upotrebljen u RTF uređivanju.',
        'Defines if the enhanced mode should be used (enables use of table, replace, subscript, superscript, paste from word, etc.).' =>
            'Određuje da li treba da se koristi poboljšani režim (omogućava korišćenje tabele, zamene, indeksiranja, eksponiranja, umetanja iz Word-a, itd.).',
        'Defines if the enhanced mode should be used (enables use of table, replace, subscript, superscript, paste from word, etc.) in customer interface.' =>
            'Definiše da li će se koristiti poboljšani režim (omogućava korišćenje tabela, zamene, indeksiranja, eksponiranja, umetanja iz Word-a, itd) u interfejsu klijenta.',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' =>
            'Određuje širinu za komponentu rich text editor. Unesi broj (pikseli) ili procentualnu vrednost (relativnu).',
        'Defines the height for the rich text editor component. Enter number (pixels) or percent value (relative).' =>
            'Određuje visinu za komponentu Rich Text Editor. Unesi broj (pikseli) ili procentualnu vrednost (relativnu).',
        'Defines the selectable font sizes in the rich text editor.' => '',
        'Defines the selectable fonts in the rich text editor.' => '',
        'Defines the selectable format tags in the rich text editor.' => '',
        'Defines additional plugins for use in the rich text editor.' => '',
        'Defines extra content that is allowed for use in the rich text editor.' =>
            '',
        'Global settings for all popup profiles.' => '',
        'Disable autocomplete in the login screen.' => '',
        'Disable HTTP header "X-Frame-Options: SAMEORIGIN" to allow OTRS to be included as an IFrame in other websites. Disabling this HTTP header can be a security issue! Only disable it, if you know what you are doing!' =>
            'Onemogućava HTTP zaglavlje "X-Frame-Options: SAMEORIGIN" radi učitavanja OTRS u okviru IFRAME na drugim stranama. Onemogućavanje ovog HTTP zaglavlja snosi sigurnosni rizik! Isključite ga samo ako znate šta radite!',
        'Disable HTTP header "Content-Security-Policy" to allow loading of external script contents. Disabling this HTTP header can be a security issue! Only disable it, if you know what you are doing!' =>
            'Onemogućava HTTP zaglavlje "Content-Security-Policy" radi učitavanja eksternih skriptova. Onemogućavanje ovog HTTP zaglavlja snosi sigurnosni rizik! Isključite ga samo ako znate šta radite!',
        'Automated line break in text messages after x number of chars.' =>
            'Automatski kraj reda u tekstualnim porukama posle h karaktera.',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' =>
            'Podešava broj linija prikazanih u tekstualnim porukama (npr broj linija u detaljnom pregledu reda).',
        'Turns on drag and drop for the main navigation.' => 'Aktivira prevuci i otpusti u glavnoj navigaciji.',
        'Defines the date input format used in forms (option or input fields).' =>
            'Definiše fornosa datuma u formulare (opciono ili polja za unos).',
        'Defines the available steps in time selections. Select "Minute" to be able to select all minutes of one hour from 1-59. Select "30 Minutes" to only make full and half hours available.' =>
            'Definiše dostupne korake u vremenskoj selekciji. Izaberite "minut" za mogućnost odabira svih minuta u jednom satu od 1-59. Izaberite "30 minuta" za dostupnost punog i pola sata.',
        'Shows time in long format (days, hours, minutes), if enabled; or in short format (days, hours), if not enabled.' =>
            'Prikazuje vreme u dužem formatu (dani, sati, minuti), ukoliko je uključeno; ili u kraćem formatu (dani, sati), ukoliko je isključeno.',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' =>
            'Dozvoljava izbor između prikaza priloga u pretraživaču (neposredno) ili samo omogućavanja njegovog preuzimanja (prilog).',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' =>
            'Proverava „MX” zapis imejl adrese pre slanja poruke ili telefonskih ili imejl tiketa.',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' =>
            'Definiše adrese namenskog „DNS” servera, ukoliko je potrebno, za „CheckMXRecord” pretrage.',
        'Makes the application check the syntax of email addresses.' => 'Primorava aplikaciju da proverava sintaksu imejl aderesa.',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' =>
            'Definiše regularni izraz koji isključuje neke adrese iz provere sintakse (ako je „CheckEmailAddresses” postavljena na „Da”). Molimo vas unesite regularni izraz u ovo polje za imejl adrese, koje nisu sintaksno ispravne, ali su neophodne za sistem (npr. „root@localhost”).',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' =>
            'Definiše regularni izraz koji filtrira sve imejl adrese koje nebi trebalo koristiti u aplikaciji.',
        'Determines the way the linked objects are displayed in each zoom mask.' =>
            'Određuje način na koji se povezani objekti prikazuju u svakom detaljnom pregledu.',
        'Determines if a button to delete a link should be displayed next to each link in each zoom mask.' =>
            'Određuje da li se prikazuje dugme za brisanje pored svake veze u detaljnom pregledu tiketa.',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' =>
            'Definiše tip veze \'Normal\'. Ako naziv izvora i naziv cilja sadrže iste vrednosti, dobijena veza se smatra neusmerenom; u suprotnom se kao rezultat dobija usmerena veza. ',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' =>
            'Definiše tip veze nadređeni-podređeni. Ako naziv izvora i naziv cilja sadrže iste vrednosti, dobijena veza se smatra neusmerenom; u suprotnom se kao rezultat dobija usmerena veza. ',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' =>
            'Definiše tip veze grupa. Tipovi veze iste grupe poništavaju jedni druge. Primer: Ako je tiket A vezan preko \'Normal\' veze sa tiketom B, onda ovi tiketi ne mogu biti dodatno vezani vezom nadređeni-podređeni.',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' =>
            'Definiše log modul za sistem. "File" piše sve poruke u datoj log datoteci, "SysLog" koristi sistemski log servis, npr. syslogd.',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' =>
            'Ukoliko je podešen SysLog za LogModule, može biti definisana posebna log sekcija.',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' =>
            'Ukoliko je podešen SysLog za LogModule, može biti definisan karakterset za logovanje.',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' =>
            'Ukoliko je podešen File za LogModule, mora biti definisana lokacija log datoteke. Ukoliko datoteka ne postoji, biće kreirana od strane sistema.',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' =>
            'Dodaje tekuću godinu i mesec kao sufiks u OTRS log datoteku. Biće kreirana log datoteka za svaki mesec.',
        'Set the minimum log level. If you select \'error\', just errors are logged. With \'debug\' you get all logging messages. The order of log levels is: \'debug\', \'info\', \'notice\' and \'error\'.' =>
            'Odredite najniži nivo logovanja. Ukoliko izaberete \'error\', biće logovane samo greške. Sa \'debug\' dobićete sve poruke u logovima. Redosled nivoa logovanja je: \'debug\', \'info\', \'notice\' i \'error\'.',
        'Defines the module to send emails. "DoNotSendEmail" doesn\'t send emails at all. Any of the "SMTP" mechanisms use a specified (external) mailserver. "Sendmail" directly uses the sendmail binary of your operating system. "Test" doesn\'t send emails, but writes them to $OTRS_HOME/var/tmp/CacheFileStorable/EmailTest/ for testing purposes.' =>
            'Definiše modul za slanje imejlova. "DoNotSendEmail" ne šalje imejlove uopšte. Svaki od SMTP mehanizama koristi specifični (eksterni) mejl server.  "Sendmail" direktno koristi sendmail program vašeg operativnog sistema. "Test" ne šalje imejlove, ali ih čuva u $OTRS_HOME/var/tmp/CacheFileStorable/EmailTest/ u svrhu testiranja.',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' =>
            'Ako je kao modul za slanje imejla izabran bilo koji od "SMTP" mehanizama, uređaj koji  šalje imejlove mora da bude naveden.',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' =>
            'Ako je kao modul za slanje imejla izabran bilo koji od "SMTP" mehanizama, port na kom vaš imej server sluša mora da bude naveden.',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' =>
            'Ako je kao modul za slanje imejla izabran bilo koji od "SMTP" mehanizama, a neophodna je autentifikacija na imejl server, korisničko ime mora da bude navedeno.',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' =>
            'Ako je kao modul za slanje imejla izabran bilo koji od "SMTP" mehanizama, a neophodna je autentifikacija na imejl server, lozinka mora da bude navedena.',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' =>
            'Šalje sve odlazne imejlove kao nevidljive kopije (bcc) na određenu adresu. Molimo da ovo koristite samo za rezervne kopije.',
        'If set, this address is used as envelope sender in outgoing messages (not notifications - see below). If no address is specified, the envelope sender is equal to queue e-mail address.' =>
            'Ako je podešeno ova adresa se koristi kao okvir zaglavlja pošiljaoca u odlaznim porukama (ne za obaveštenja - vidi niže). Ako adresa nije uneta, okvir zaglavlja pošiljaoca je jednak imejl adresi reda.',
        'If set, this address is used as envelope sender header in outgoing notifications. If no address is specified, the envelope sender header is empty (unless SendmailNotificationEnvelopeFrom::FallbackToEmailFrom is set).' =>
            'Ako je podešeno ova adresa se koristi kao okvir zaglavlja pošiljaoca u odlaznim obaveštenjima. Ako adresa nije uneta, okvir zaglavlja pošiljaoca je prazan (osim ako je SendmailNotificationEnvelopeFrom::FallbackToEmailFrom podešen).',
        'If no SendmailNotificationEnvelopeFrom is specified, this setting makes it possible to use the email\'s from address instead of an empty envelope sender (required in certain mail server configurations).' =>
            'Ako SendmailNotificationEnvelopeFrom nije naveden, ova postavka omogućava korišćenje aderese pošinjaoca imejlova  umesto praznog okvira zaglavlja (obavezno u postavkama nekih imejl servera).',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' =>
            'Nameće šifriranje odlaznih imejlova (7bit|8bit|quoted-printable|base64).',
        'Defines default headers for outgoing emails.' => 'Definiše podrazumevana zaglavlja odlaznih imejlova.',
        'Registers a log module, that can be used to log communication related information.' =>
            'Registruje log modul za čuvanje informacija u vezi komunikacija.',
        'Defines the number of hours a successful communication will be stored.' =>
            'Definiše koliko će dugo u časovima komunikacija biti čuvana.',
        'Defines the number of hours a communication will be stored, whichever its status.' =>
            'Definiše koliko će dugo u časovima komunikacija biti čuvana, bez obzira na njen status.',
        'MailQueue configuration settings.' => 'Podešavanje zakazanih imejlova za slanje.',
        'Define which avatar engine should be used for the agent avatar on the header and the sender images in AgentTicketZoom. If \'None\' is selected, initials will be displayed instead. Please note that selecting anything other than \'None\' will transfer the encrypted email address of the particular user to an external service.' =>
            'Definiše koji servis će biti korišćen za avatar sličice operatera u zaglavlju i detaljnom prikazu tiketa. Ako je odabran \'Ni jedan\', biće prikazani inicijali operatera. Molimo obratite pažnju da će odabirom jedne od opcija, šifrovana imejl adresa korisnika biti prosleđena eksternom servisu.',
        'Define which avatar default image should be used for the current agent if no gravatar is assigned to the mail address of the agent. Check https://gravatar.com/site/implement/images/ for further information.' =>
            'Određuje koja sličica će biti prikazana kao podrazumevana ukoliko operater nema odgovarajuću povezanu sa imejl adresom. Pogledajte https://gravatar.com/site/implement/images/ za više informacija.',
        'Define which avatar default image should be used for the article view if no gravatar is assigned to the mail address. Check https://gravatar.com/site/implement/images/ for further information.' =>
            'Određuje koja sličica će biti prikazana u pregledu članaka ukoliko operater nema odgovarajuću povezanu sa imejl adresom. Pogledajte https://gravatar.com/site/implement/images/ za više informacija.',
        'Defines an alternate URL, where the login link refers to.' => 'Definiše alternativnu URL adresu, na koju ukazuje veza za prijavljivanje.',
        'Defines an alternate URL, where the logout link refers to.' => 'Određuje alternativnu URL adresu, na koju ukazuje veza za odavljivanje.',
        'Defines a useful module to load specific user options or to display news.' =>
            'Definiše koristan modul za učitavanje određenih korisničkih opcija ili za prikazivanje novosti.',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' =>
            'Definiše ključ koji treba proveriti sa modulom Kernel::Modules::AgentInfo. Ako je ovaj korisnički parametar ključa tačan, poruka će biti prihvaćena od strane sistema.',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Templates/Standard/AgentInfo.tt.' =>
            'Datoteka za prikaz u modulu Kernel::Modules::AgentInfo, ukoliko je snimljena pod Kernel/Output/HTML/Templates/Standard/AgentInfo.tt.',
        'Defines the module to generate code for periodic page reloads.' =>
            'Definiše modul za generisanje koda za periodično učitavanje stranica.',
        'Defines the module to display a notification in different interfaces on different occasions for OTRS Business Solution™.' =>
            'Određuje modul za prikaz obaveštenja u raznim interfejsima u različitim prilikama za OTRS Business Solution™.',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' =>
            'Definiše modul za prikazivanje obaveštenja u interfejsu operatera ako se sistem koristi od strane admin korisnika (normalno ne treba da rade kao administrator).',
        'Defines the module to display a notification in the agent interface, if the agent session limit prior warning is reached.' =>
            'Određuje modul za prikaz obaveštenja u interfejsu operatera ako .je dostignut limit sesija operatera.',
        'Defines the module that shows all the currently logged in agents in the agent interface.' =>
            'Definiše modul koji prikazuje sve trenutno prijavljene operatere u interfejsu operatera.',
        'Defines the module that shows all the currently logged in customers in the agent interface.' =>
            'Definiše modul koji prikazuje sve trenutno prijavljene klijente u interfejsu operatera.',
        'Defines the module to display a notification in the agent interface, if there are modified sysconfig settings that are not deployed yet.' =>
            'Definiše modul za prikaz obaveštenja u interfejsu operatera, ako postoje promenjena ali neraspoređena podešavanja u sistemskoj konfiguraciji.',
        'Defines the module to display a notification in the agent interface, if there are invalid sysconfig settings deployed.' =>
            'Definiše modul za prikaz obaveštenja u interfejsu operatera, ako su raspoređena nevažeća podešavanja u sistemskoj konfiguraciji.',
        'Defines the module to display a notification in the agent interface, if the agent is logged in while having out-of-office active.' =>
            'Definiše modul za prikazivanje obaveštenja u interfejsu operatera ako je operater prijavljen na sistem dok je opcija van kancelarije aktivna.',
        'Defines the module to display a notification in the agent interface, if the agent is logged in while having system maintenance active.' =>
            'Određuje modul za prikaz obaveštenja u interfejsu operatera, ako je operater prijavljen na sistem dok je aktivno održavanje sistema.',
        'Defines the module to display a notification in the agent interface if the system configuration is out of sync.' =>
            'Definiše modul za prikazivanje obaveštenja u interfejsu operatera ako je sistemska konfiguracija nesinhronizovana.',
        'Defines the module to display a notification in the agent interface, if the agent has not yet selected a time zone.' =>
            'Definiše modul za prikaz obaveštenja u interfejsu operatera, ako operater još nije podesio vremensku zonu.',
        'Defines the module that shows a generic notification in the agent interface. Either "Text" - if configured - or the contents of "File" will be displayed.' =>
            'Definiše modul koji prikazuje generičku napomenu u interfejsu operatera. Biće prikazan ili "Text" (ako je konfigurisan) ili sadržaj "File".',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' =>
            'Definiše modul koji se koristi za skladištenje podataka sesije. Sa "DB" pristupni server može biti odvojen od servera baze podataka. "FS" je brži.',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' =>
            'Definiše naziv ključa sesije. Npr. Session, SessionID ili OTRS”',
        'Defines the name of the key for customer sessions.' => 'Određuje naziv ključa za klijentske sesije.',
        'Turns on the remote ip address check. It should not be enabled if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' =>
            'Uključuje proveru udaljene IP adrese. Treba biti isključeno ako se aplikacija koristi, na primer, preko proxy farme ili dialup konekcije, zato što je udaljena IP adresa uglavnom drugačija za svaki zahtev.',
        'Deletes a session if the session id is used with an invalid remote IP address.' =>
            'Briše sesiju ukoliko je ID sesije korišćen preko nevažeće udaljene IP adrese.',
        'Defines the maximal valid time (in seconds) for a session id.' =>
            'Definiše maksimalno vreme važenja (u sekundama) za ID sesije.',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is logged out.' =>
            'Određuje vreme bez aktivnosti (u sekundama) pre nego što sesija bude ugašena a korisnik odjavljen.',
        'Deletes requested sessions if they have timed out.' => 'Briše zahtevanu sesiju ako je isteklo vreme.',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' =>
            'Određuje da li sesije koriste HTML kolačiće. Ukoliko su kolačići isključeni ili klijentski pretraživač ih ne podržava, sistem će raditi uobičajeno i dodavaće ID sesije u svim vezama.',
        'Stores cookies after the browser has been closed.' => 'Čuva kolačiće nakon zatvaranja pretraživača.',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see https://en.wikipedia.org/wiki/Cross-site_request_forgery).' =>
            'Zaštita od CSRF eksploatacije (Cross Site Request Forgery, za više informacija pogledajte https://en.wikipedia.org/wiki/Cross-site_request_forgery).',
        'Sets the maximum number of active agents within the timespan defined in SessionMaxIdleTime before a prior warning will be visible for the logged in agents.' =>
            'Postavlja maksimalni broj aktivnih operatera u vremenskom rasponu definisanom u SessionMaxIdleTime pre nego što obaveštenje bude vidljivo za prijavljene operatere.',
        'Sets the maximum number of active agents within the timespan defined in SessionMaxIdleTime.' =>
            'Postavlja maksimalni broj aktivnih operatera u vremenskom rasponu definisanom u SessionMaxIdleTime.',
        'Sets the maximum number of active sessions per agent within the timespan defined in SessionMaxIdleTime.' =>
            'Postavlja maksimalni broj aktivnih sesija po operateru u vremenskom rasponu definisanom u SessionMaxIdleTime.',
        'Sets the maximum number of active customers within the timespan defined in SessionMaxIdleTime.' =>
            'Postavlja maksimalni broj aktivnih klijenta u vremenskom rasponu definisanom u SessionMaxIdleTime.',
        'Sets the maximum number of active sessions per customers within the timespan defined in SessionMaxIdleTime.' =>
            'Postavlja maksimalni broj aktivnih sesija po korisniku u vremenskom rasponu definisanom u SessionMaxIdleTime.',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' =>
            'Ukoliko je izabrano "FS" za SessionModule, neophodno je podesiti naziv direktorijuma gde će se čuvati podaci sesija.',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' =>
            'Ukoliko je izabrano "DB" za SessionModule, neophodno je podesiti naziv tabele gde će se čuvati podaci sesija.',
        'Defines the period of time (in minutes) before agent is marked as "away" due to inactivity (e.g. in the "Logged-In Users" widget or for the chat).' =>
            'Definiše vremenski period (u minutima) posle kog će operater biti označen kao "odsutan" zbog neaktivnosti (npr. u dodatku "Prijavljeni korisnici" ili za ćaskanja).',
        'Defines the period of time (in minutes) before customer is marked as "away" due to inactivity (e.g. in the "Logged-In Users" widget or for the chat).' =>
            'Definiše vremenski period (u minutima) posle kog će klijent biti označen kao "odsutan" zbog neaktivnosti (npr. u dodatku "Prijavljeni korisnici" ili za ćaskanja).',
        'This setting is deprecated. Set OTRSTimeZone instead.' => 'Ovo podešavanje je zastarelo. Podesite OTRSTimeZone umesto njega.',
        'Sets the time zone being used internally by OTRS to e. g. store dates and times in the database. WARNING: This setting must not be changed once set and tickets or any other data containing date/time have been created.' =>
            'Podešava internu vremensku zonu OTRS za npr. čuvanje datuma i vremena u bazi podataka. Upozorenje: ovo podešavanje ne smete menjati jednom kada ga podesite i ako su kreirani tiketi ili bilo koji drugi podaci sa vremenom.',
        'Sets the time zone that will be assigned to newly created users and will be used for users that haven\'t yet set a time zone. This is the time zone being used as default to convert date and time between the OTRS time zone and the user\'s time zone.' =>
            'Podešava vremensku zonu koja će biti dodeljena novo-kreiranim korisnicima i koja će biti korišćena za one koji još nisu podesili vremensku zonu. Ovo je podrazumevana vremenska zona za konverziju datuma i vremena između interne OTRS vremenske zone i vremenske zone korisnika.',
        'If enabled, users that haven\'t selected a time zone yet will be notified to do so. Note: Notification will not be shown if (1) user has not yet selected a time zone and (2) OTRSTimeZone and UserDefaultTimeZone do match and (3) are not set to UTC.' =>
            'Ukoliko je uključeno, korisnici koji još nisu odabrali vremensku zonu biće obavešteni o tome. Napomena: obaveštenje neće biti prikazano ukoliko (1) korisnik još nije odabrao vremensku zonu i (2) OTRSTimeZone i UserDefaultTimeZone se podudaraju i (3) nisu postavljena na UTC.',
        'Maximum Number of a calendar shown in a dropdown.' => 'Maksimalni broj kalendara prikazan u listi.',
        'Define the start day of the week for the date picker.' => 'Definiši prvi dan u nedelji za izbor datuma.',
        'Adds the permanent vacation days.' => 'Trajno dodaje neradne dane.',
        'Adds the one time vacation days.' => 'Jednokratno dodaje neradne dane.',
        'Defines the hours and week days to count the working time.' => 'Određuje sate i dane u nedelji u naznačenom kalendaru, radi računanja radnog vremena.',
        'Defines the name of the indicated calendar.' => 'Definiše naziv naznačenog kalendara.',
        'Defines the time zone of the indicated calendar, which can be assigned later to a specific queue.' =>
            'Definiše vremensku zonu naznačenog kalendara, koja kasnije može biti dodeljena određenom redu.',
        'Define the start day of the week for the date picker for the indicated calendar.' =>
            'Definiši prvi dan u nedelji za izbor datuma za navedeni kalendar.',
        'Adds the permanent vacation days for the indicated calendar.' =>
            'Trajno dodaje neradne dane za izabrani kalendar.',
        'Adds the one time vacation days for the indicated calendar.' => 'Jednokratno dodaje neradne dane za izabrani kalendar.',
        'Defines the hours and week days of the indicated calendar, to count the working time.' =>
            'Određuje sate i dane u nedelji u naznačenom kalendaru, radi računanja radnog vremena.',
        'Defines the maximal size (in bytes) for file uploads via the browser. Warning: Setting this option to a value which is too low could cause many masks in your OTRS instance to stop working (probably any mask which takes input from the user).' =>
            'Definiše maksimalnu veličinu (u bajtovima) za slanje datoteke preko pretraživača. Upozorenje: Podešavanje ove opcije na suviše malu vrednost može uzrokovati da mnoge maske u vašoj OTRS instanci prestanu sa radom (verovatno svaka maska koja ima ulaz od korisnika).',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' =>
            'Bira modul za rukovanje prenešenim datotekama preko veb interfejsa. "DB" skladišti sve prenešene datoteke u bazu podataka, "FS" koristi sistem datoteka.',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' =>
            'Određuje tekst koji treba da se pojavi u log datoteci da označi ulazak CGI skripte.',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' =>
            'Definiše filter koji obrađuje tekst u člancima, da bi se istakle URL adrese.',
        'Activates lost password feature for agents, in the agent interface.' =>
            'Aktivira opciju izgubljene lozinke za operatere, na interfejsu za njih.',
        'Shows the message of the day on login screen of the agent interface.' =>
            'Prikazuje dnevnu poruku na ekranu za prijavu u interfejsu operatera.',
        'Runs the system in "Demo" mode. If enabled, agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' =>
            'Pokreće sistem u demo modu. Ukoliko je uključeno, operateri mogu promeniti svoja podešavanja kao što su izbor jezika i teme u interfejsu operatera. Ove promene će važiti samo za trenutnu sesiju. Operaterima neće biti omogućeno da promene svoje lozinke.',
        'Allows the administrators to login as other users, via the users administration panel.' =>
            'Dozvoljava administratorima da pristupe kao drugi korisnici, kroz administrativni panel.',
        'Allows the administrators to login as other customers, via the customer user administration panel.' =>
            'Dozvoljava administratorima da pristupe kao drugi klijenti, kroz administrativni panel klijenta korisnika.',
        'Specifies the group where the user needs rw permissions so that he can access the "SwitchToCustomer" feature.' =>
            'Određuje grupu gde su korisniku potrebne rw dozvole kako bi mogli pristupiti svojstvu "SwitchToCustomer".',
        'Sets the timeout (in seconds) for http/ftp downloads.' => 'Postavlja vremensko odlaganje (u sekundama) za http/ftp preuzimanja.',
        'Defines the connections for http/ftp, via a proxy.' => 'Definiše konekcije za http/ftp preko posrednika.',
        'Turns off SSL certificate validation, for example if you use a transparent HTTPS proxy. Use at your own risk!' =>
            'Isključuje proveru važnosti SSL sertifikata, npr. ukoliko koristite transparentan HTTPS proksi. Koristite na sopstvenu odgovornost!',
        'Enables file upload in the package manager frontend.' => 'Omogućava slanje datoteka u upravljaču paketima pristupnog sistema.',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' =>
            'Definiše lokaciju za dobijanje spiska online spremišta za dodatne pakete. Prvi raspoloživi rezultat će biti korišćen.',
        'List of online package repositories.' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' =>
            'Definiše regularni izraz za IP adresu za pristup lokalnom spremištu. Potrebno je da im omogućite pristup vašem lokalnom spremištu i pakovanju: :RepositoryList se zahteva na udaljenom host-u',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' =>
            'Definiše isticanje (u sekundama) za funkciju preuzimanja paketa. Preinačuje opciju "WebUserAgent::Timeout".',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' =>
            'Preuzima pakete preko proxy servera. Preinačuje opciju "WebUserAgent::Proxy".',
        'If this setting is enabled, local modifications will not be highlighted as errors in the package manager and support data collector.' =>
            'Ukoliko je ovo podešavanje uključeno, lokalne izmene neće biti prikazane kao greške u upravljaču paketima i sakupljaču podataka podrške.',
        'Package event module file a scheduler task for update registration.' =>
            'Datoteka paketa modula događaja za posao planera za ažuriranje registracije.',
        'List of all Package events to be displayed in the GUI.' => 'Lista svih događaja na paketima za prikaz u grafičkom interfejsu.',
        'List of all DynamicField events to be displayed in the GUI.' => 'Lista svih događaja na dinamičkim poljima za prikaz u grafičkom interfejsu.',
        'List of all LinkObject events to be displayed in the GUI.' => 'Lista svih LinkObject događaja za prikaz u grafičkom interfejsu.',
        'DynamicField object registration.' => 'Registarcija objekta dinamičkih polja.',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' =>
            'Definiše korisničko ime za pristup SOAP rukovanju (bin/cgi-bin/rpc.pl).',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' =>
            'Definiše lozinku za pristup SOAP rukovanju (bin/cgi-bin/rpc.pl).',
        'Enable keep-alive connection header for SOAP responses.' => 'Omogući zaglavlje za održanje aktivne konekcije za SOAP odgovore.',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png).' =>
            '',
        'Size of the logo in the page header.' => '',
        'Defines the standard size of PDF pages.' => 'Definiše standardnu veličinu PDF stranica.',
        'Defines the maximum number of pages per PDF file.' => 'Definiše maksimalni broj strana po PDF datoteci.',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' =>
            'Definiše putanju i TTF datoteku proporcionalnog fonta u PDF dokumentima.',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' =>
            'Definiše putanju i TTF datoteku podebljanog proporcionalnog fonta u PDF dokumentima.',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' =>
            'Definiše putanju i TTF datoteku proporcionalnog fonta u kurzivu u PDF dokumentima.',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' =>
            'Definiše putanju i TTF datoteku podebljanog proporcionalnog fonta u kurzivu u PDF dokumentima.',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' =>
            'Definiše putanju i TTF datoteku neproporcionalnog fonta u PDF dokumentima.',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' =>
            'Definiše putanju i TTF datoteku podebljanog neproporcionalnog fonta u PDF dokumentima.',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' =>
            'Definiše putanju i TTF datoteku neproporcionalnog fonta u kurzivu u PDF dokumentima.',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' =>
            'Definiše putanju i TTF datoteku podebljanog neproporcionalnog fonta u kurzivu u PDF dokumentima.',
        'Enables PGP support. When PGP support is enabled for signing and encrypting mail, it is HIGHLY recommended that the web server runs as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' =>
            'Obezbeđuje „PGP” podršku. Kada je „PGP” podrška omogućena za potpisivanje i enkriprovanje mejla, strogo se preporučuje da veb server radi kao „OTRS” korisnik. U suprotnom, biće problema sa privilegijama prilikom pristupa „.gnupg” direktorijumu.',
        'Defines the path to PGP binary.' => 'Određuje putanju do PGP aplikacije.',
        'Sets the options for PGP binary.' => 'Određuje opcije za PGP aplikaciju.',
        'Sets the preferred digest to be used for PGP binary.' => 'Definiše mod šifrovanja PGP aplikacije.',
        'Sets the password for private PGP key.' => 'Podesi lozinku za privatni PGP ključ.',
        'Enable this if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' =>
            'Uključite ovu opciju ako verujete u sve vaše javne i privatne PGP ključeve, čak i ako nisu potvrđeni pouzdanim potpisom.',
        'Configure your own log text for PGP.' => 'Konfiguriši sopstveni log tekst za PGP.',
        'Sets the method PGP will use to sing and encrypt emails. Note Inline method is not compatible with RichText messages.' =>
            'Definiše metod koji će „PGP” da koristi prilikom potpisivanja i šifrovanja imejlova. Napomena: metod "neposredno" nije kompatibilan sa „RichText” porukama.',
        'Enables S/MIME support.' => 'Omogućava „S/MIME” podršku.',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' =>
            'Određuje putanju do „open ssl” programa. Može biti potrebno HOME Env ($ENV{HOME} = \'/var/lib/wwwrun\';).',
        'Specifies the directory where SSL certificates are stored.' => 'Određuje direktorijum gde se „SSL” sertifikati skladište.',
        'Specifies the directory where private SSL certificates are stored.' =>
            'Određuje direktorijum gde se privatni „SSL” sertifikati skladište.',
        'Cache time in seconds for the SSL certificate attributes.' => 'Vreme keširanja u sekundama za „SSL” sertifikovane atribute.',
        'Enables fetch S/MIME from CustomerUser backend support.' => 'Omogućava podršku za pribavljanje „S/MIME” iz podrške pozadinskog sistema klijenta korisnika.',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notifications" otrs@your.example.com).' =>
            'Definiše naziv koje će aplikacija koristiti prilikom slanja obaveštenja. Naziv se koristi u nazivu pošiljaoca obaveštenja (npr. "OTRS Notifications" otrs@your.example.com).',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notifications" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address.' =>
            'Definiše imejl adresu koju će aplikacija koristiti prilikom slanja obaveštenja. Imejl adresa se koristi u nazivu pošiljaoca obaveštenja (npr. "OTRS Notifications" otrs@your.example.com). Možete koristiti promenljivu OTRS_CONFIG_FQDN iz vaše konfiguracije, ili odredite drugu imejl adresu.',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' =>
            'Definiše predmet za imejl poruke obaveštenja poslata operaterima, sa tokenom o novoj zahtevanoj lozinki.',
        'Defines the body text for notification mails sent to agents, with token about new requested password.' =>
            'Definiše sadržaj teksta obaveštenja za slanje operaterima sa tokenom za novu zahtevanu lozinku.',
        'Defines the subject for notification mails sent to agents, about new password.' =>
            'Definiše predmet za imejl poruke obaveštenja poslata operaterima, o novoj lozinki.',
        'Defines the body text for notification mails sent to agents, about new password.' =>
            'Definiše sadržaj teksta obaveštenja za slanje operaterima o novoj lozinki.',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' =>
            'Standardne raspoložive dozvole za operatere unutar aplikacije. Ukoliko je potrebno više dozvola oni mogu uneti ovde. Dozvole moraju biti definisane da budu efektivne. Neke druge dozvole su takođe obezbeđene ugrađivanjem u: napomenu, zatvori, na čekanju, klijent, slobodan tekst, pomeri, otvori, odgovoran, prosledi i povrati. Obezbedite da "rw" uvek bude poslednja registrovana dozvola.',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' =>
            'Određuje standardne dozvole raspoložive za korisnike u aplikaciji. Ukoliko je potrebno više dozvola, možete ih uneti ovde. Da bi bile efektivne, dozvole moraju biti nepromenljive. Molimo proverite kada dodajete bilo koju od gore navedenih dozvola, da "rw" dozvola ostane poslednja.',
        'This setting allows you to override the built-in country list with your own list of countries. This is particularly handy if you just want to use a small select group of countries.' =>
            'Ova opcija vam dozvoljava da ugrađenu listu država zamenite svojom. Ovo je posbno korisno ako u selekciji želite da koristite samo mali broj država.',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' =>
            'Omogućuje logovanje performansi (vreme izvršavanja strane). Utiče na performanse sistema. Opcija Frontend::Module###AdminPerformanceLog mora biti omogućena.',
        'Specifies the path of the file for the performance log.' => 'Određuje putanju datoteke za performansu log-a.',
        'Defines the maximum size (in MB) of the log file.' => 'Definiše maksimalnu veličinu log datoteke (u megabajtima).',
        'Defines the two-factor module to authenticate agents.' => 'Određuje dvofaktorski modul za identifikaciju operatera.',
        'Defines the agent preferences key where the shared secret key is stored.' =>
            'Određuje ključ operaterskih podešavanja gde se smešta deljeni tajni ključ.',
        'Defines if agents should be allowed to login if they have no shared secret stored in their preferences and therefore are not using two-factor authentication.' =>
            'Definiše da li će operaterima biti dozvoljena prijava na sistem ukoliko nemaju podešen deljeni tajni ključ i time ne koriste dvofaktorski modul za identifikaciju.',
        'Defines if the previously valid token should be accepted for authentication. This is slightly less secure but gives users 30 seconds more time to enter their one-time password.' =>
            'Određuje da li za autentifikaciju treba da bude prihvaćen token koji je ranije bio važeći. Ovo je malo manje bezbedno ali korisniku daje 30 sekundi više vremena da unese svoju jednokratnu lozinku.',
        'Defines the name of the table where the user preferences are stored.' =>
            'Određuje naziv tabele gde se smeštaju podešavanja korisnika.',
        'Defines the column to store the keys for the preferences table.' =>
            'Definiše kolonu za čuvanje ključeva tabele podešavanja.',
        'Defines the name of the column to store the data in the preferences table.' =>
            'Definiše naziv kolone za skladištenje podataka u tabeli parametara.',
        'Defines the name of the column to store the user identifier in the preferences table.' =>
            'Definiše naziv kolone za skladištenje identifikacije korisnika u tabeli parametara.',
        'Defines the config parameters of this item, to be shown in the preferences view. \'PasswordRegExp\' allows to match passwords against a regular expression. Define the minimum number of characters using \'PasswordMinSize\'. Define if at least 2 lowercase and 2 uppercase letter characters are needed by setting the appropriate option to \'1\'. \'PasswordMin2Characters\' defines if the password needs to contain at least 2 letter characters (set to 0 or 1). \'PasswordNeedDigit\' controls the need of at least 1 digit (set to 0 or 1 to control). \'PasswordMaxLoginFailed\' allows to set an agent to invalid-temporarily if max failed logins reached. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Određuje sve parametre za ovu stavku u ekranu podešavanja. PasswordRegExp omogućava proveru lozinke putem regularnog izraza. Definišite minimalni broj karaktera putem PasswordMinSize. Definišite najmanje 2 mala i 2 velika slova tako što ćete podesiti odgovarajuću opciju na 1. PasswordMin2Characters definiše da li lozinka mora da sadrži najmanje dva slova (0 ili 1). PasswordNeedDigit kontroliše potrebu za najmanje jednom cifrom (0 ili 1). PasswordMaxLoginFailed dozvoljava automatsko proglašavanje statusa operatera kao nevažeći-privremeno, ukoliko je dostignut maksimalni broj neuspešnih logovanja. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Defines the config parameters of this item, to be shown in the preferences view. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Definiše konfiguracione parametre ove stavke za prikaz u ekranu podešavanja. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Omogućava krajnjim korisnicima da zamene separator za CSV datoteke, definisan u datotekama prevoda. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Defines the users avatar. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Definiše korisnikovu avatar sličicu. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Defines the user identifier for the customer panel.' => 'Određuje identifikator klijenta za klijentski panel.',
        'Activates support for customer and customer user groups.' => 'Aktivira podršku za klijentske i klijent korisničke grupe.',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every customer user for these groups).' =>
            'Definiše podrazumevane grupe za klijent korisnike (ukoliko je CustomerGroupSupport uključen i ne želite da upravljate grupama pojedinačnih klijent korisnika).',
        'Defines the groups every customer will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every customer for these groups).' =>
            'Definiše podrazumevane grupe za klijente (ukoliko je CustomerGroupSupport uključen i ne želite da upravljate grupama pojedinačnih klijenata).',
        'Defines a permission context for customer to group assignment.' =>
            'Definiše kontekst dozvola za dodelu klijenata grupama.',
        'Defines the module that shows the currently logged in agents in the customer interface.' =>
            'Definiše modul koji prikazuje sve trenutno prijavljene operatere u interfejsu klijenta.',
        'Defines the module that shows the currently logged in customers in the customer interface.' =>
            'Definiše modul koji prikazuje sve trenutno prijavljene klijente u interfejsu klijenta.',
        'Defines the module to display a notification in the customer interface, if the customer is logged in while having system maintenance active.' =>
            'Definiše modul za prikaz obaveštenja u interfejsu klijenta, ako je klijent prijavljen na sistem dok je aktivno održavanje sistema.',
        'Defines the module to display a notification in the customer interface, if the customer user has not yet selected a time zone.' =>
            'Definiše modul za prikaz obaveštenja u interfejsu operatera, ako klijent korisnik još nije podesio vremensku zonu.',
        'Defines an alternate login URL for the customer panel..' => 'Određuje alternativnu URL adresu prijavljivanja za klijentski panel.',
        'Defines an alternate logout URL for the customer panel.' => 'Određuje alternativnu URL adresu odjavljivanja za klijentski panel.',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' =>
            'Definiše stavku koja generiše Google Maps ikonicu na kraju info bloka klijenta.',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' =>
            'Definiše stavku koja generiše Google ikonicu na kraju info bloka klijenta.',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' =>
            'Definiši stavku klijenta, koja generiše LinkedIn ikonu na kraju info bloka klijenta.',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' =>
            'Definišie stavku klijenta, koja generiše XING ikonu na kraju info bloka klijenta.',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' =>
            'Ukoliko je uključen, ovaj modul i njegova PreRun() funkcija biće  izvršeni prilikom svakog zahteva. Koristi se za proveru opcija korisnika i prikaz vesti o aplikaciji.',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' =>
            'Određuje ključ koji treba proveriti sa CustomerAccept (prihvatanje korisnika). Ako je ovaj korisnički parametar ključa tačan, poruka će biti prihvaćena od strane sistema.',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Templates/Standard/CustomerAccept.tt.' =>
            'Definiše putanju prikazanog info fajla koji je lociran pod Kernel/Output/HTML/Templates/Standard/CustomerAccept.tt.',
        'Activates lost password feature for customers.' => 'Aktivira svojstvo izgubljene lozinke za klijente.',
        'Enables customers to create their own accounts.' => 'Omogućava klijentima da kreiraju sopstvene naloge.',
        'If active, one of the regular expressions has to match the user\'s email address to allow registration.' =>
            'Ako je aktivno, jedan regularni izraz se mora poklopiti sa korisnikovom imejl adresom da bi dozvolio registraciju.',
        'If active, none of the regular expressions may match the user\'s email address to allow registration.' =>
            'Ako je aktivno, ni jedan regularni izraz se ne može poklopiti sa korisnikovom imejl adresom da bi dozvolio registraciju.',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' =>
            'Određuje predmet za imejl poruke obaveštenja poslata klijentima, sa tokenom o novoj zahtevanoj lozinki.',
        'Defines the body text for notification mails sent to customers, with token about new requested password.' =>
            'Definiše sadržaj teksta obaveštenja za slanje klijentima sa tokenom za novu zahtevanu lozinku.',
        'Defines the subject for notification mails sent to customers, about new password.' =>
            'Određuje predmet za imejl poruke obaveštenja poslata klijentima, o novoj lozinki.',
        'Defines the body text for notification mails sent to customers, about new password.' =>
            'Određuje sadržaj teksta obaveštenja za slanje klijentima o novoj lozinki.',
        'Defines the subject for notification mails sent to customers, about new account.' =>
            'Određuje predmet za imejl poruke obaveštenja poslata klijentima, o novom nalogu.',
        'Defines the body text for notification mails sent to customers, about new account.' =>
            'Određuje sadržaj teksta za obaveštenja poslata klijentima putem imejlova, o novom nalogu.',
        'Defines the module to authenticate customers.' => 'Određuje modul za autentifikaciju klijenata.',
        'If "DB" was selected for Customer::AuthModule, the encryption type of passwords must be specified.' =>
            'Ukoliko je odabran "DB" za Customer::AuthModule, neophodno je podesiti tip šifrovanja za lozinke.',
        'If "bcrypt" was selected for CryptType, use cost specified here for bcrypt hashing. Currently max. supported cost value is 31.' =>
            'Ukoliko je podešen „bcrypt” za „CryptType”, ovde možete definisati „cost" parametar za šifrovanje. Trenutno je najviša podržana vrednost 31.',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' =>
            'Ukoliko je izabrano „DB” za „Customer::AuthModule”, neophodno je podesiti naziv tabele gde će podaci o klijentima biti čuvani.',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' =>
            'Ukoliko je izabrano „DB” za „Customer::AuthModule”, neophodno je podesiti naziv kolone za „CustomerKey” u tabeli korisnika.',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' =>
            'Ukoliko je izabrano „DB” za „Customer::AuthModule”, neophodno je podesiti naziv kolone za „CustomerPassword” u tabeli klijenata.',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' =>
            'Ukoliko je izabrano „DB” za „Customer::AuthModule”, neophodno je podesiti „DSN” za konekciju ka tabeli klijenata.',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' =>
            'Ukoliko je izabrano „DB” za „Customer::AuthModule”, moguće je podesiti korisničko ime za povezivanje sa tabelom klijenata.',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' =>
            'Ukoliko je izabrano „DB” za „Customer::AuthModule”, moguće je podesiti lozinku za tabelu klienata.',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' =>
            'Ukoliko je izabrano „DB” za „Customer::AuthModule”, moguće je podesiti drajver baze podataka (obično se koristi automatsko prepoznavanje).',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' =>
            'Ukoliko je podešen HTTPBasicAuth za Customer::AuthModule, možete podesiti uklanjanje delova korisničkih imena (npr. za domene kao example_domain\user u user).',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' =>
            'Ukoliko je podešen „HTTPBasicAuth” za „Customer::AuthModule”, možete podesiti (putem RegExp) uklanjanje delova „REMOTE_USER” vrednosti (npr. radi uklanjanja dodatnih domena). Napomena: $1 će biti nova Prijava.',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, adresa „LDAP” servera mora biti navedena.',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, „BaseDN” mora biti definisan.',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, korisnički identifikator mora biti naveden.',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, možete proveriti da li je korisniku omogućena autentikacija ako pripada „posixGroup”, npr. korisnik mora da pripada grupi xyz da bi mogao da koristi „OTRS”. Definišite grupu sa pristupom sistemu.',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, ovde možete definisati pristupne parametre.',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, korisnički atributi moraju biti navedeni. Za „LDAP posixGroups” koristite UID, za ostale koristite kompletan korisnički DN.',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule” i vaši korisnici imaju samo anonimni pristup direktorijumu, ali želite da pretražujete podatke, možete podesiti korisnika koji ima pristup „LDAP” direktorijumu. Korisničko ime ovog korisnika možete podesiti ovde.',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule” i vaši korisnici imaju samo anonimni pristup direktorijumu, ali želite da pretražujete podatke, možete podesiti korisnika koji ima pristup „LDAP” direktorijumu. Lozinku za ovog korisnika možete podesiti ovde.',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, možete dodati filter svakom „LDAP” zahtevu, npr. (mail=*), (objectclass=user) ili (!objectclass=computer).',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule” i želite da dodate sufiks svakom korisničkom imenu, definišite ga ovde, npr. želite samo user za korisničko ime, ali u vašem LDAP direktorijumu postoji user@domain.',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule” i neophodni su specijalni parametri za „Net::LDAP” perl modul, možete ih podesiti ovde. Pogledajte „perldoc Net::LDAP” za više informacija o parametrima.',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' =>
            'Ukoliko je podešen „LDAP” za „Customer::AuthModule”, možete definisati da li će aplikacija prestati sa radom ukoliko npr. konekcija sa serverom ne može biti ostvarena zbog problema sa mrežom.',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' =>
            'Ukoliko je podešen „Radius” za „Customer::AuthModule”, adresa „Radius” servera mora biti definisana.',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' =>
            'Ukoliko je podešen „Radius” za „Customer::AuthModule”, morate definisati lozinku za pristup „Radius” serveru.',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' =>
            'Ukoliko je podešen „Radius” za „Customer::AuthModule”, možete definisati da li će aplikacija prestati sa radom ukoliko npr. konekcija sa serverom ne može biti ostvarena zbog problema sa mrežom.',
        'Defines the two-factor module to authenticate customers.' => 'Određuje dvofaktorski modul za identifikaciju klijenata.',
        'Defines the customer preferences key where the shared secret key is stored.' =>
            'Određuje ključ klijentskih podešavanja gde se smešta deljeni tajni ključ.',
        'Defines if customers should be allowed to login if they have no shared secret stored in their preferences and therefore are not using two-factor authentication.' =>
            'Definiše da li će klijentima biti dozvoljena prijava na sistem ukoliko nemaju podešen deljeni tajni ključ pa zbog toga ne koriste dvofaktorski modul za identifikaciju.',
        'Defines the parameters for the customer preferences table.' => 'Određuje parametre za tabelu podešavanja klijenata.',
        'Defines all the parameters for this item in the customer preferences. \'PasswordRegExp\' allows to match passwords against a regular expression. Define the minimum number of characters using \'PasswordMinSize\'. Define if at least 2 lowercase and 2 uppercase letter characters are needed by setting the appropriate option to \'1\'. \'PasswordMin2Characters\' defines if the password needs to contain at least 2 letter characters (set to 0 or 1). \'PasswordNeedDigit\' controls the need of at least 1 digit (set to 0 or 1 to control).' =>
            'Definiše sve parametre za ovu stavku u podešavanjima klijenta. PasswordRegExp omogućava proveru lozinke putem regularnog izraza. Definišite minimalni broj karaktera putem PasswordMinSize. Definišite najmanje 2 mala i 2 velika slova tako što ćete podesiti odgovarajuću opciju na 1. PasswordMin2Characters definiše da li lozinka mora da sadrži najmanje dva slova (0 ili 1). PasswordNeedDigit kontroliše potrebu za najmanje jednom cifrom (0 ili 1).',
        'Defines the config parameters of this item, to be shown in the preferences view.' =>
            'Definiše konfiguracione parametre za ovu stavku, da budu prikazani u prikazu podešavanja.',
        'Defines all the parameters for this item in the customer preferences.' =>
            'Definiše sve parametre za ovu stavku u podešavanjima klijenta.',
        'Parameters for the pages (in which the communication log entries are shown) of the communication log overview.' =>
            'Parametri stranica (na kojima su vidljive stavke komunikacionih logova) u pregledu komunikacionih logova.',
        'Search backend router.' => 'Ruter modul pretrage.',
        'JavaScript function for the search frontend.' => 'JavaScript funkcija za modul pretrage.',
        'Main menu registration.' => 'Registracija glavnog menija.',
        'Parameters for the dashboard backend of the customer company information of the agent interface. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' =>
            'Parametri za dodatak firme klijenta kontrolne table u intefejsu operatera. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je podrazumevano aktiviran ili da je potrebno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keš dodatka. ',
        'Parameters for the dashboard backend of the customer user information of the agent interface. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' =>
            'Parametri za dodatak informacija o klijent korisnicima kontrolne table u interfejsu operatera. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka.',
        'Search backend default router.' => 'Podrazumevani ruter modul pretrage.',
        'Defines available groups for the admin overview screen.' => 'Definiše dostupne kategorije za ekran administratorskog pregleda.',
        'Frontend module registration (show personal favorites as sub navigation items of \'Admin\').' =>
            'Registracija modula interfejsa (prikaz ličnih omiljenih kao podnavigacija administratorskog menija).',
        'Frontend module registration (disable company link if no company feature is used).' =>
            'Registracija modula pristupa (onemogućuje vezu klijent ako se ne koristi svojstvo klijenata).',
        'Frontend module registration for the customer interface.' => 'Registracija modula pristupa za interfejs klijenta.',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' =>
            'Aktivira raspoložive teme - šablone u sistemu. Vrednost 1 znači aktivno, 0 znači neaktivno.',
        'Defines the default value for the action parameter.' => '',
        'Defines the shown links in the footer area of the customer and public interface of this OTRS system. The value in "Key" is the external URL, the value in "Content" is the shown label.' =>
            'Određuje prikazane veze u donjem delu klijentskog i javnog interfejsa ovog OTRS sistema. Vrednost polja "Key" je eksterna adresa (URL), a vrednost polja "Content" je prikazan naziv.',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' =>
            'Definiše podrezumevanu vrednost za akcioni parametar za javni korisnički deo. Akcioni parametar je korišćen u skriptama sistema.',
        'Sets the stats hook.' => 'Definiše oznaku za statistike.',
        'Start number for statistics counting. Every new stat increments this number.' =>
            'Početni broj za brojanje statistika. Svaka nova statistika povećava ovaj broj.',
        'Defines the default maximum number of statistics per page on the overview screen.' =>
            'Definiše podrazumevani maksimalni broj rezultata statistike po strani na ekranu pregleda.',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' =>
            'Definiše podrazumevani izbor iz padajućeg menija za dinamičke objekte (Od: Zajednička specifikacija).',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' =>
            'Definiše podrazumevani izbor iz padajućeg menija za dozvole (Od: Zajednička specifikacija).',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' =>
            'Definiše podrazumevani izbor iz padajućeg menija za status formata (Od: Zajednička specifikacija). Molimo vas da ubacite ključ formata (vidi statistika :: Format).',
        'Defines the search limit for the stats.' => 'Definiše granicu pretrage za statistike.',
        'Defines all the possible stats output formats.' => 'Definiše sve moguće izlazne formate statistike.',
        'Allows agents to exchange the axis of a stat if they generate one.' =>
            'Dozvoljava operaterima da zamene ose na statistici ako je generišu.',
        'Adds the following elements for use in stats: "Agent/Owner", "Created by Agent/Owner", "Responsible", "Accounted time by Agent".' =>
            '',
        'Allows invalid agents to be used in stats. Stats::UseAgentElementInStats must be active.' =>
            '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' =>
            'Prikazuje sve klijentske identifikatore u polju višestrukog izbora (nije korisno ako imate mnogo klijentskih identifikatora).',
        'Shows all the customer user identifiers in a multi-select field (not useful if you have a lot of customer user identifiers).' =>
            'Prikazuje sve klijentske identifikatore u polju višestrukog izbora (nije korisno ako imate mnogo klijentskih identifikatora).',
        'Defines the default maximum number of X-axis attributes for the time scale.' =>
            'Definiše podrazumevani maksimalni broj atributa na H-osi vremenske skale.',
        'OTRS can use one or more readonly mirror databases for expensive operations like fulltext search or statistics generation. Here you can specify the DSN for the first mirror database.' =>
            '„OTRS” može da koristi jednu ili više preslikanih baza podataka za skupe operacije kao što su pretraga teksta ili generisanje statistika. Ovde možete definisati DSN za prvu preslikanu bazu podataka.',
        'Specify the username to authenticate for the first mirror database.' =>
            'Navedi korisničko ime za autorizaciju na prvu preslikanu bazu podataka.',
        'Specify the password to authenticate for the first mirror database.' =>
            'Navedi lozinku za autorizaciju na prvu preslikanu bazu podataka.',
        'Configure any additional readonly mirror databases that you want to use.' =>
            'Konfiguriše bilo koju dodatnu preslikanu bazu podataka, koju želite da koristite, samo za čitanje.',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Definiše parametre za dodatak kontrolne table. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Definiše parametre za dodatak kontrolne table. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTL" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Definiše parametre za dodatak kontrolne table. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTL" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Prikazuje današnju poruku na kontrolnoj tabli u interfejsu operatera. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Starts a wildcard search of the active object after the link object mask is started.' =>
            'Počinje džoker pretragu aktivnog objekta nakon pokretanja veze maske objekta.',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' =>
            'Definiše filter za obradu teksta u člancima, da bi se istakle unapred definisane ključne reči.',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' =>
            'Definiše filter za html izlaz da bi ste dodali veze iza CVE brojeva. Element Image dozvoljava dva načina ulaza. U jednom naziv slike (npr. faq.png). I tom slučaju biće korišćena OTRS putanja slike. Drugi način je unošenje veze do slike.',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' =>
            'Definiše filter za HTML izlaz da bi ste dodali veze iza bugtraq brojeva. Element Image dozvoljava dva načina ulaza. U jednom naziv slike (npr. faq.png). I tom slučaju biće korišćena OTRS putanja slike. Drugi način je unošenje putanje do slike.',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' =>
            'Definiše filter za html izlaz da bi ste dodali veze iza MSBulletin brojeva. Element Image dozvoljava dva načina ulaza. U jednom naziv slike (npr. faq.png). I tom slučaju biće korišćena OTRS putanja slike. Drugi način je unošenje veze do slike.',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' =>
            'Definiši filter za html izlaz da bi dodali veze iza definisanog niza znakova. Element Image dozvoljava dva načina ulaza. U jednom naziv slike (npr. faq.png). U tom slučaju biće korišćena OTRS putanja slike. Drugi način je unošenje veze do slike.',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' =>
            'Definiše filter za html izlaz da bi ste dodali veze iza definisanog niza znakova. Element Image dozvoljava dva načina ulaza. U jednom naziv slike (npr. faq.png). I tom slučaju biće korišćena OTRS putanja slike. Drugi način je unošenje veze do slike.',
        'If enabled, the OTRS version tag will be removed from the Webinterface, the HTTP headers and the X-Headers of outgoing mails. NOTE: If you change this option, please make sure to delete the cache.' =>
            'Ako je aktivirano, oznaka OTRS verzije će biti uklonjena iz veb interfejsa, HTTP zaglavlja i X-Headers u odlaznim imejl porukama. NAPOMENA: ako menjate ovu opciju, molimo da osigurate brisanje keša.',
        'If enabled, OTRS will deliver all CSS files in minified form.' =>
            'Ukoliko je uključeno, OTRS će isporučiti sve CSS datoteke u smanjenoj formi.',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' =>
            'Ukoliko je uključeno, OTRS će isporučiti sve JavaScript datoteke u smanjenoj formi.',
        'List of responsive CSS files to always be loaded for the agent interface.' =>
            'Lista prilagodljivih CSS datoteka uvek učitanih za interfejs operatera.',
        'List of CSS files to always be loaded for the customer interface.' =>
            'Lista CSS datoteka koje se uvek učitavaju za interfejs klijenta.',
        'List of responsive CSS files to always be loaded for the customer interface.' =>
            'Lista prilagodljivih CSS datoteka uvek učitanih za interfejs klijenta.',
        'List of JS files to always be loaded for the customer interface.' =>
            'Lista JS datoteka koje se uvek učitavaju za interfejs klijenta.',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' =>
            'Ako je aktivirano, prvi nivo glavnog menija se otvara na prelaz miša (umesto samo na klik).',
        'Specifies the order in which the firstname and the lastname of agents will be displayed.' =>
            'Određuje oblik u kome će biti prikazano ime i prezime operatera.',
        'Default skin for the agent interface.' => 'Podrazumevani izgled okruženja za interfejs operatera.',
        'Default skin for the agent interface (slim version).' => 'Podrazumevani izgled okruženja za interfejs operatera (slaba verzija).',
        'Balanced white skin by Felix Niklas.' => 'Izbalansirani beli izgled, Feliks Niklas.',
        'Balanced white skin by Felix Niklas (slim version).' => 'Izbalansirani beli izgled, Feliks Niklas (tanka verzija).',
        'High contrast skin for visually impaired users.' => 'Visoko kontrastni izgled za osobe slabijeg vida.',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' =>
            'Izled koji će se koristiti u interfejsu operatera. Molimo proverite dostupne izglede u Frontend::Agent::Skins.',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' =>
            'Moguće je podesiti različite izglede za različite operatere, koji se koriste na nivou domena u aplikaciji. Korišćenjem regularnog izraza (regex), možete podesiti par ključ/vrednost za prepoznavanje domena. Vrednost u Key bi trebalo da prepozna domen, a vrednost u Content bi trebalo da bude važeći izgled u sistemu. Molimo konsultujte primere za ispravan oblik regularnog izraza.',
        'Default skin for the customer interface.' => 'Podrazumevani izgled okruženja za interfejs klijenta.',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' =>
            'Izled koji će se koristiti u interfejsu korisnika. Molimo proverite dostupne izglede u Frontend::Customer::Skins.',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' =>
            'Moguće je podesiti različite izglede za različite korisnike, koji se koriste na nivou domena u aplikaciji. Korišćenjem regularnog izraza (regex), možete podesiti par ključ/vrednost za prepoznavanje domena. Vrednost u Key bi trebalo da prepozna domen, a vrednost u Content bi trebalo da bude važeći izgled u sistemu. Molimo konsultujte primere za ispravan oblik regularnog izraza.',
        'Shows time use complete description (days, hours, minutes), if enabled; or just first letter (d, h, m), if not enabled.' =>
            'Prikazuje potpun opis u vremenu (dani, sati, minuti), ukoliko je uključeno; ili samo prvo slovo (d, č, m), ukoliko je isključeno. ',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' =>
            'Pokreće inicijalnu džoker pretragu postojećih korisnika pri pristupu modulu AdminCustomerUser.',
        'Controls if the autocomplete field will be used for the customer ID selection in the AdminCustomerUser interface.' =>
            'Kontroliše da li će biti prikazano polje za automatsko dopunjavanje ID klijenta u interfejsu AdminCustomerUser.',
        'Runs an initial wildcard search of the existing customer company when accessing the AdminCustomerCompany module.' =>
            'Pokreće inicijalnu džoker pretragu postojećih firmi klijenata pri pristupu modulu AdminCustomerCompany.',
        'Controls if the admin is allowed to make changes to the database via AdminSelectBox.' =>
            'Kontroliše da li je administratoru dozvoljeno da napravi izemene u bazi podataka preko Administrativnog okvira za izbor.',
        'List of all CustomerUser events to be displayed in the GUI.' => 'Lista svih događaja na klijent korisnicima za prikaz u grafičkom interfejsu.',
        'List of all CustomerCompany events to be displayed in the GUI.' =>
            'Lista svih događaja na klijent firmama za prikaz u grafičkom interfejsu.',
        'Event module that updates customer users after an update of the Customer.' =>
            'Modul događaja koji ažurira klijenta korisnika posle ažuriranja klijenta.',
        'Event module that updates customer company object name for dynamic fields.' =>
            'Modul događaja koji ažurira naziv klijent firme za dinamička polja.',
        'Event module that updates customer user search profiles if login changes.' =>
            'Modul događaja koji ažurira profile pretrage klijent korisnika ako se promeni prijava.',
        'Event module that updates customer user service membership if login changes.' =>
            'Modul događaja koji ažurira servisno članstvo klijenta korisnika ako se promeni prijava.',
        'Event module that updates customer user object name for dynamic fields.' =>
            'Modul događaja koji ažurira naziv objekta klijenta korisnika za dinamička polja.',
        'Selects the cache backend to use.' => 'Modul keša koji će koristiti sistem.',
        'If enabled, the cache data be held in memory.' => 'Ako je aktibirano, keširani podaci će se čuvati u memoriji.',
        'If enabled, the cache data will be stored in cache backend.' => 'Ako je aktivirano, keširani podaci će se čuvati u kešu sistema u pozadini.',
        'Specify how many sub directory levels to use when creating cache files. This should prevent too many cache files being in one directory.' =>
            'Navođenje koliko nivoa poddirektorijuma da koristi prilikom kreiranja keš datoteka. To bi trebalo da spreči previše keš datoteka u jednom direktorijumu.',
        'Defines the config options for the autocompletion feature.' => 'Definiše konfiguracione opcije za funkciju automatskog dovršavanja.',
        'Defines the list of possible next actions on an error screen, a full path is required, then is possible to add external links if needed.' =>
            'Definiše listu mogućih sledećih akcija na prikazu ekrana sa greškom, kompletna putanja je obavezna, nakon čega je moguće dodati spoljašnje veze ako je potrebno.',
        'Sets the minutes a notification is shown for notice about upcoming system maintenance period.' =>
            'Određuje broj minuta trajanja prikaza obaveštenja o predsojećem periodu održavanja.',
        'Sets the default message for the notification is shown on a running system maintenance period.' =>
            'Određuje podrazumevanu poruku za obaveštenje koje se vidi tokom perioda održavanja.',
        'Sets the default message for the login screen on Agent and Customer interface, it\'s shown when a running system maintenance period is active.' =>
            'Postavlja podrazumevanu poruku za prijavni ekran u interfejsu operatera i klijenta, prikazuje se tokom aktivnog perioda održavanja.',
        'Sets the default error message for the login screen on Agent and Customer interface, it\'s shown when a running system maintenance period is active.' =>
            'Postavlja podrazumevanu poruku greške za prijavni ekran u interfejsu operatera i klijenta, prikazuje se tokom aktivnog perioda održavanja.',
        'Specify the channel to be used to fetch OTRS Business Solution™ updates. Warning: Development releases might not be complete, your system might experience unrecoverable errors and on extreme cases could become unresponsive!' =>
            'Definiše kanal za ažuriranje OTRS Business Solution™. Upozorenje: beta izdanja mogu biti nekompletna, vaš sistem može dobiti nepopravljive greške i, u ekstremnim slučajevima, prestati da reaguje.',
        'Use new type of select and autocomplete fields in agent interface, where applicable (InputFields).' =>
            'Koristite novi tip polja za izbor i automatsko dovršavanje u interfejsu operatera gde je to moguće (polja za unos).',
        'Use new type of select and autocomplete fields in customer interface, where applicable (InputFields).' =>
            'Koristite novi tip polja za izbor i automatsko dovršavanje u interfejsu klijenta gde je to moguće (polja za unos).',
        'Defines the fall-back path to open fetchmail binary. Note: The name of the binary needs to be \'fetchmail\', if it is different please use a symbolic link.' =>
            'Definiše rezervnu putanju za „fetchmail” program. Napomena: naziv programa mora biti „fetchmail”, ukoliko je drugačiji molimo koristite simboličku vezu.',
        'Defines an overview module to show the address book view of a customer user list.' =>
            'Definiše modul pregleda za prikaz adresara klijent korisnika.',
        'Specifies the group where the user needs rw permissions so that they can edit other users preferences.' =>
            'Određuje grupu gde su korisniku potrebne rw dozvole kako bi mogli da uređuju lična podešavanja drugih korisnika.',
        'Defines email communication channel.' => 'Definiše komunikacioni kanal imejla.',
        'Defines internal communication channel.' => 'Definiše interni komunikacioni kanal.',
        'Defines phone communication channel.' => 'Definiše komunikacioni kanal telefona.',
        'Defines chat communication channel.' => 'Definiše komunikacioni kanal ćaskanja.',
        'Defines groups for preferences items.' => 'Definiše kategorije za lična podešavanja.',
        'Defines how many deployments the system should keep.' => 'Definiše koliko rasporeda će sistem čuvati.',
        'Defines the search parameters for the AgentCustomerUserAddressBook screen. With the setting \'CustomerTicketTextField\' the values for the recipient field can be specified.' =>
            'Definiše pojmove pretrage za ekran adresara klijent korisnika. Polje za primaoca moćete podesiti putem podešavanja \'CustomerTicketTextField\'.',
        'Defines the default filter fields in the customer user address book search (CustomerUser or CustomerCompany). For the CustomerCompany fields a prefix \'CustomerCompany_\' must be added.' =>
            'Definiše podrazumevana filter polja u pretrazi adresara klijent korisnika (CustomerUser ili CustomerCompany). Za CustomerCompany polja, morate dodati prefiks \'CustomerCompany_\'.',
        'Defines the shown columns and the position in the AgentCustomerUserAddressBook result screen.' =>
            'Definiše prikazane kolone i njihov redosled u ekranu rezultata pretrage adresara klijent korisnika.',
        'Example package autoload configuration.' => 'Primer automatskog učitavanja paketne konfiguracije.',
        'Activates week number for datepickers.' => '',

        # XML Definition: Kernel/Config/Files/XML/GenericInterface.xml
        'Performs the configured action for each event (as an Invoker) for each configured web service.' =>
            'Izvršava podešenu akciju za svaki događaj (kao pozivalac) za svaki konfigurisan veb servis.',
        'Cache time in seconds for the web service config backend.' => 'Vreme keširanja u sekundama za veb servis modul konfiguracije.',
        'Cache time in seconds for agent authentication in the GenericInterface.' =>
            'Vreme keširanja u sekundama za autentifikacije operatera u generičkom interfejsu.',
        'Cache time in seconds for customer authentication in the GenericInterface.' =>
            'Vreme keširanja u sekundama za autentifikaciju klijenta u generičkom interfejsu.',
        'GenericInterface module registration for the transport layer.' =>
            'Registracija modula generičkog interfejsa za transportni sloj.',
        'GenericInterface module registration for the operation layer.' =>
            'Registracija modula generičkog interfejsa za operativni sloj.',
        'GenericInterface module registration for the invoker layer.' => 'Registracija modula generičkog interfejsa za sloj pozivaoca.',
        'GenericInterface module registration for the mapping layer.' => 'Registracija modula generičkog interfejsa za sloj mapiranja.',
        'Defines the default visibility of the article to customer for this operation.' =>
            'Definiše vidljivost članka klijentu za ovu operaciju.',
        'Defines the history type for this operation, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za ovu operaciju, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for this operation, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za ovu operaciju, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the default auto response type of the article for this operation.' =>
            'Definiše podrazumevani tip automatskog odgovora članka za ovu operaciju.',
        'Defines the maximum size in KiloByte of GenericInterface responses that get logged to the gi_debugger_entry_content table.' =>
            'Definiše maksimalnu veličinu u kilobajtima za odgovore Generičkog interfejsa koji se beleže u gi_debugger_entry_content tabelu.',
        'Maximum number of tickets to be displayed in the result of this operation.' =>
            'Maksimalni broj tiketa koji će biti prikazani u rezultatu ove operacije.',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of this operation.' =>
            'Definiše podrazumevani atribut tiketa za sortiranje tiketa u rezultatu pretrage tiketa u ovoj operaciji.',
        'Defines the default ticket order in the ticket search result of the this operation. Up: oldest on top. Down: latest on top.' =>
            'Definiše podrazumevani redosled tiketa u pregledu pretrage tiketa u ovoj operaciji. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'GenericInterface module registration for an error handling module.' =>
            'Registracija modula generičkog interfejsa za otklanjanje grešaka.',

        # XML Definition: Kernel/Config/Files/XML/ProcessManagement.xml
        'Frontend module registration (disable ticket processes screen if no process available).' =>
            'Registracija modula pristupa (onemogućite ekran procesa tiketa ako proces nije raspoloživ).',
        'Event module registration. For more performance you can define a trigger event (e. g. Event =&gt; TicketCreate).' =>
            '',
        'This option defines the dynamic field in which a Process Management process entity id is stored.' =>
            'Ova opcija određuje dinamičko polje u koje se smešta ID entiteta aktivnosti upravljanja procesima.',
        'This option defines the dynamic field in which a Process Management activity entity id is stored.' =>
            'Ova opcija određuje dinamičko polje u koje se smešta ID entiteta aktivnosti upravljanja procesima.',
        'This option defines the process tickets default queue.' => 'Ova opcija određuje podrazumevani red tiketa u obradi.',
        'This option defines the process tickets default state.' => 'Ova opcija određuje podrazumevani status tiketa u obradi.',
        'This option defines the process tickets default lock.' => 'Ova opcija određuje podrazumevano zaključavanje tiketa u obradi.',
        'This option defines the process tickets default priority.' => 'Ova opcija određuje podrazumevani prioritet tiketa u obradi.',
        'Display settings to override defaults for Process Tickets.' => 'Prikaži podešavanja da bi ste zamenili podrazumevana za tikete procesa.',
        'Dynamic fields groups for process widget. The key is the name of the group, the value contains the fields to be shown. Example: \'Key =&gt; My Group\', \'Content: Name_X, NameY\'.' =>
            '',
        'Dynamic fields shown in the process widget in ticket zoom screen of the agent interface.' =>
            'Dinamička polja prikazana u dodatku procesa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Shows a link in the menu to enroll a ticket into a process in the ticket zoom view of the agent interface.' =>
            'U meniju prikazuje vezu za priključivanje tiketa procesu u detaljnom pregledu u interfejsu operatera.',
        'Loader module registration for the customer interface.' => 'Registracija modula za učitavanje za interfejs klijenta.',
        'Frontend module registration (disable ticket processes screen if no process available) for Customer.' =>
            'Registracija modula pristupa (onemogućite ekran procesa tiketa ako proces nije raspoloživ) za Klijenta.',
        'Default ProcessManagement entity prefixes for entity IDs that are automatically generated.' =>
            'Podrazumevani prefiksi objekta za upravljanje procesom za IĐeve objekta koji su automatski generisani.',
        'Cache time in seconds for the DB process backend.' => 'Vreme keširanja u sekundama za procesni modul baze podataka.',
        'Cache time in seconds for the ticket process navigation bar output module.' =>
            'Vreme keširanja u sekundama za izlazni modul navigacione trake procesa tiketa.',
        'Determines the next possible ticket states, for process tickets in the agent interface.' =>
            'Određuje sledeći mogući status tiketa, za tikete procesa u interfejsu operatera.',
        'Shows existing parent/child (separated by ::) process lists in the form of a tree or a list.' =>
            '',
        'Determines the next possible ticket states, for process tickets in the customer interface.' =>
            'Određuje sledeći mogući status tiketa, za tikete procesa u interfejsu klijenta.',
        'Controls if CustomerID is read-only in the agent interface.' => 'Kontroliše da li se ID klijenta može samo pregledati u interfejsu operatera.',
        'If enabled debugging information for transitions is logged.' => 'Ako je aktivirano, ispravljanje grešaka za tranzicije se beleži.',
        'Defines the priority in which the information is logged and presented.' =>
            'Definiše prioritet po kom se informacije beleže i prikazuju.',
        'Filter for debugging Transitions. Note: More filters can be added in the format &lt;OTRS_TICKET_Attribute&gt; e.g. &lt;OTRS_TICKET_Priority&gt;.' =>
            '',
        'Parameters for the dashboard backend of the running process tickets overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Parametri za dodatak liste proces tiketa u toku kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'DynamicField backend registration.' => 'Registracija modula dinamičkih polja.',
        'Defines the default keys and values for the transition action module parameters. Mandatory fields are marked with "(* required)". Note: For most of the keys the AttributeID can also be used, e.g. "Owner" can be "OwnerID". Keys that define the same Attribute should only be used once, e.g. "Owner" and "OwnerID" are redundant.' =>
            '',

        # XML Definition: Kernel/Config/Files/XML/Ticket.xml
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' =>
            'Identifikator tiketa, npr. Ticket#, Call#, MyTicket#. Podrazumevano je Ticket#.',
        'The divider between TicketHook and ticket number. E.g \': \'.' =>
            'Delilac između priključka i broja tiketa, npr. \': \'.',
        'Max size of the subjects in an email reply and in some overview screens.' =>
            'Maksimalna veličina predmeta u imejl odgovoru i nekim ekranima pregleda.',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' =>
            'Tekst na početku predmeta u odgovoru na imejl, npr. RE, AW ili AS.',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' =>
            'Tekst na početku predmeta kada se imejl prosleđuje, npr. FW, Fwd, ili WG.',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the latter case you should verify that the setting PostMaster::CheckFollowUpModule###0200-References is activated to recognize followups based on email headers.' =>
            'Format polja predmeta. \'Left\' znači \'[TicketHook#:12345] Neki naslov\', \'Right\' znači \'Neki naslov [TicketHook#:12345]\', \'None\' znači \'Neki naslov\' i bez broja tiketa. U poslednjem slučaju, obavezno proverite da li je podešavanje PostMaster::CheckFollowUpModule###0200-References aktivirano za prepoznavanje nastavaka na osnovu zaglavlja imejl poruka.',
        'A list of dynamic fields that are merged into the main ticket during a merge operation. Only dynamic fields that are empty in the main ticket will be set.' =>
            'Lista dinamičkih polja koja su spoajena u glavni tiket tokom operacije spajanja. Biće podešena samo dinamička polja koja su prazna u glavnom tiketu.',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' =>
            'Naziv namenskog reda. Namenski red je izbor redova po vašoj želji i može se izabrati u podešavanjima.',
        'Name of custom service. The custom service is a service selection of your preferred services and can be selected in the preferences settings.' =>
            'Naziv namenske usluge. Namenska usluga je izbor usluga po vašoj želji i može se izabrati u podešavanjima.',
        'Ignore system sender article types (e. g. auto responses or email notifications) to be flagged as \'Unread Article\' in AgentTicketZoom or expanded automatically in Large view screens.' =>
            'Ignoriše vrstu pošiljaoca članaka (npr. automatski odgovori ili imejl obaveštenja) prilikom prikaza nepročitanih članaka u detaljnom pregledu tiketa ili automatskog proširivanja u velikom ekranu pregleda.',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' =>
            'Promeni vlasnika tiketa za sve (korisno za ASP). Obično se pokazuje samo agent sa dozvlama za čitanje/pisanje u redu tiketa.',
        'Enables ticket responsible feature, to keep track of a specific ticket.' =>
            'Aktivira funkciju odgovornog za tiket radi evidentiranja specifičnog tiketa',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled). This will only work by manually actions of the logged in user. It does not work for automated actions e.g. GenericAgent, Postmaster and GenericInterface.' =>
            'Automatski podešava vlasnika tiketa kao odgovornog za njega (ako je funcija odgovornog za tiket aktivirana). Ovo funcioniše samo u ručnim akcijama prijavnjenog korisnika. ne važi za automatske akcije, npr. generičkog operatera, Postmaster i generičkog interfejsa.',
        'Automatically change the state of a ticket with an invalid owner once it is unlocked. Maps from a state type to a new ticket state.' =>
            'Automatski promeni stanje tiketa sa nevažećim vlasnikom kada se otključa. Mapirajte tip stanja na novo stanje tiketa.',
        'Enables ticket type feature.' => 'Uključuje svojstvo tipa tiketa.',
        'Defines the default ticket type.' => 'Određuje podrazumevani tip tiketa.',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' =>
            'Dozvoljava definisanje usluge i SLA za tikete (npr. imejl, radna površina, mreža, ...), i eskalacione atribute za SLA (ako je aktivirana funkcija usluga/SLA za tiket).',
        'Retains all services in listings even if they are children of invalid elements.' =>
            'Zadrži sve servise u listi čak iako su deca nevažećih elemenata.',
        'Allows default services to be selected also for non existing customers.' =>
            'Dozvoljava da podrazumevane usluge budu izabrane i za nepostojeće klijente.',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' =>
            'Aktivira arhivski sistem radi ubrzanja rada, tako što ćete neke tikete ukloniti van dnevnog praćenja. Da biste pronašli ove tikete, marker arhive mora biti omogućen za pretragu tiketa.',
        'Controls if the ticket and article seen flags are removed when a ticket is archived.' =>
            'Kontroliše da li su zastavicom obeleženi tiket i članak uklonjeni kada je tiket arhiviran.',
        'Removes the ticket watcher information when a ticket is archived.' =>
            'Uklanja informacije posmatrača tiketa kada se tiket arhivira.',
        'Activates the ticket archive system search in the customer interface.' =>
            'Aktivira mogućnost pretraživanja arhive tiketa u klijentskom interfejsu.',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). With "Random" the ticket numbers will be generated by 12 random numbers. The format looks like SystemID.RandomNumbers (e.g. 10123456789012).' =>
            '',
        'Checks the SystemID in ticket number detection for follow-ups. If not enabled, SystemID will be changed after using the system.' =>
            'Proverava SystemID u detekciji broja tiketa za nastavljanja. Ako je isključeno, SystemID će biti promenjen nakon korišćenja sistema.',
        'Sets the minimal ticket counter size if "AutoIncrement" was selected as TicketNumberGenerator. Default is 5, this means the counter starts from 10000.' =>
            'Definiše minimalnu veličinu brojača tiketa ukoliko je izabran "AutoIncrement" kao TicketNumberGenerator. Podrazumevano je 5, što znači da brojač počinje od 10000.',
        'Enables the minimal ticket counter size (if "Date" was selected as TicketNumberGenerator).' =>
            'Aktivira minimalnu veličinu brojača tiketa (ako je izabran "Datum" kao generator broja tiketa).',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the command "bin/otrs.Console.pl Maint::Ticket::QueueIndexRebuild" for initial index creation.' =>
            'Ubrzivač indeksiranja: za odabir TicketViewAccelerator modula. "RuntimeDB" generiše svaki pregled reda u hodu iz tabele tiketa (nema uticaja na performanse do oko 60.000 tiketa ukupno i 6.000 otvorenih tiketa u sistemu). "StaticDB" je najmoćniji modul, koristi dodatnu tiket indeks tabelu koja radi kao pregled (preporučuje se za više od 80.000 i 6.000 otvorenih tiketa u sistemu). Korišćenjem komande "bin/otrs.Console.pl Maint::Ticket::QueueIndexRebuild" možete kreirati početni indeks.',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data. Note: Searching for attachment names is not supported when "FS" is used.' =>
            'Čuva priloge u člancima. „DB” snima sve priloge u bazi podataka (nije preporučljivo za čuvanje velikih priloga). „FS” snima priloge u sistemu datoteka; ovo je brža opcija, ali veb server mora biti pokrenut pod „OTRS” sistemskim korisnikom. Dozvoljena je promena modula čak i na produkcijskim sistemima bez bilo kakvog gubitka podataka. Napomena: pretraga priloga po nazivu nije moguća kada je „FS” u funkciji.',
        'Specifies whether all storage backends should be checked when looking for attachments. This is only required for installations where some attachments are in the file system, and others in the database.' =>
            'Definiše da li će biti pregledani svi pozadinski moduli prilikom pretrage priloga. Ovo je neophodno samo na sistemima gde su neki prilozi u sistemu datoteka, a drugi u bazi podataka.',
        'Specifies the directory to store the data in, if "FS" was selected for ArticleStorage.' =>
            'Određuje direktorijum za skladištenje podataka ako je "FS" izabran za skladište članaka.',
        'Specifies whether the (MIMEBase) article attachments will be indexed and searchable.' =>
            'Određuje da li će prilozi (MIMEBase) članaka biti indeksirani za pretragu.',
        'The duration in minutes after emitting an event, in which the new escalation notify and start events are suppressed.' =>
            'Vreme u minutima posle emitovanja događaja, u kom su novo obaveštenje o eskalaciji i startu događaja prikriveni.',
        'Restores a ticket from the archive (only if the event is a state change to any open available state).' =>
            'Vraća tiket iz arhive (samo ako je događaj promena stanja na bilo koje dostupno otvoreno stanje).',
        'Updates the ticket index accelerator.' => 'Ažuriraj akcelerator indeksa tiketa.',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' =>
            'Resetuje i otključava vlasnika ako je tiketa premešten u drugi red.',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' =>
            'Nameće izbor različitog stanja tiketa (od aktuelnog) posle akcije zaključavanja. Definiše aktuelno stanje kao ključ, a sledeće stanje posle zaključavanja kao sadržaj.',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' =>
            'Automatsko podešavanje odgovornog za tiket (ako nije do sada podešeno) posle prvog ažuriranja.',
        'When agent creates a ticket, whether or not the ticket is automatically locked to the agent.' =>
            'Određuje da li će tiket biti automatski zaključan na operatera, kada ga isti kreira.',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' =>
            'Podešava vreme čekanja tiketa na 0 ako je stanje promenjeno na stanje koje nije čekanje.',
        'Sends the notifications which are configured in the admin interface under "Ticket Notifications".' =>
            'Šalje obaveštenja koja su u administrativnom interfejsu konfigurisana pod "Obaveštenja o tiketima".',
        'Updates the ticket escalation index after a ticket attribute got updated.' =>
            'Ažuriraj indeks eskalacije tiketa posle ažuriranja atributa tiketa.',
        'Ticket event module that triggers the escalation stop events.' =>
            'Modul događaja tiketa koji okida događaje zaustavljanja eskalacije.',
        'Forces to unlock tickets after being moved to another queue.' =>
            'Prinudno otključava tikete posle premeštanja u drugi red.',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' =>
            'Ažuriraj oznaku viđenih tiketa ako su svi pregledani ili je kreiran novi članak.',
        'Event module that updates tickets after an update of the Customer.' =>
            'Modul događaja koji ažurira tikete posle ažuriranja korisnika.',
        'Event module that updates tickets after an update of the Customer User.' =>
            'Modul događaja koji ažurira tikete posle ažuriranja klijenta korisnika.',
        'Define a mapping between variables of the customer user data (keys) and dynamic fields of a ticket (values). The purpose is to store customer user data in ticket dynamic fields. The dynamic fields must be present in the system and should be enabled for AgentTicketFreeText, so that they can be set/updated manually by the agent. They mustn\'t be enabled for AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer. If they were, they would have precedence over the automatically set values. To use this mapping, you have to also activate the Ticket::EventModulePost###4100-DynamicFieldFromCustomerUser setting.' =>
            'Definisanje mapiranja između promenljivih podataka klijenta korisnika (ključevi) i dinamičkih polja tiketa (vrednosti). Cilj je da se sačuvaju podaci klijenta korisnika u dinamičkom polju tiketa. Dinamička polja moraju biti prisutna u sistemu i treba da budu omogućena za AgentTicketFreeText, tako da mogu da budu manuelno podešena/ažurirana od strane operatera. Ona ne smeju biti omogućena za AgentTicketPhone, AgentTicketEmail i AgentTicketCustomer. Da su bila, imala bi prednost nad automatski postavljenim vrednostima. Za korišćenje ovog mapiranja treba, takođe, da aktivirate podešavanje Ticket::EventModulePost###4100-DynamicFieldFromCustomerUser.',
        'This event module stores attributes from CustomerUser as DynamicFields tickets. Please see DynamicFieldFromCustomerUser::Mapping setting for how to configure the mapping.' =>
            'Ovaj modul događaja čuva atribute korisnika kao dinamička polja tiketa. Pogledajte opciju DynamicFieldFromCustomerUser::Mapping za podešavanje mapiranja.',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' =>
            'Preopterećuje (redefinisano) postojeće fuckcije u Kernel::System::Ticket. Koristi se za lako dodavanje prilagođavanja.',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). It will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.Console.pl Maint::Ticket::FulltextIndex --rebuild".' =>
            'Omogućuje proširenu tekstualnu pretragu vaših članaka (pretraga po poljima From, To, Cc, Subject i Body). Svi postojeći članci će biti reindeksirani, novi dodati u indeks pretrage po kreiranju, time ubrzavajući tekstualnu pretragu za oko 50%. Za kreiranje početnog indeksa koristite "bin/otrs.Console.pl Maint::Ticket::FulltextIndexRebuild --rebuild".',
        'Defines whether to index archived tickets for fulltext searches.' =>
            'Definiše da li će arhivirani tiketi biti indeksirani za tekstualnu pretragu.',
        'Force the storage of the original article text in the article search index, without executing filters or applying stop word lists. This will increase the size of the search index and thus may slow down fulltext searches.' =>
            'Uključuje spremanje originalnog teksta članka u indeksu pretrage, bez izvršavanja filtera ili uklanjanja zaustavnih reči. Ovo će uvećati veličinu indeksa pretrage i može usporiti tekstualnu pretragu.',
        'Display a warning and prevent search when using stop words within fulltext search.' =>
            'Prikaži upozorenje i onemogući pretragu ako su upotrebljene zaustavne reči u pretrazi kompletnog teksta.',
        'Basic fulltext index settings. Execute "bin/otrs.Console.pl Maint::Ticket::FulltextIndex --rebuild" in order to generate a new index.' =>
            'Osnovno podešavanje indeksa celog teksta. Pokrenite "bin/otrs.Console.pl Maint::Ticket::FulltextIndexRebuild --rebuild" kako bi se generisao novi indeks.',
        'Fulltext index regex filters to remove parts of the text.' => 'Tekst indeks filteri (regularni izrazi) za uklanjanje delova teksta.',
        'English stop words for fulltext index. These words will be removed from the search index.' =>
            'Engleske zaustavne reči za indeks pretrage kompletnog teksta. Ove reči će biti uklonjene iz indeksa pretrage.',
        'German stop words for fulltext index. These words will be removed from the search index.' =>
            'Nemačke zaustavne reči za indeks pretragu kompletnog teksta. Ove reči će biti uklonjene iz indeksa pretrage.',
        'Dutch stop words for fulltext index. These words will be removed from the search index.' =>
            'Holandske zaustavne reči za indeks pretrage kompletnog teksta. Ove reči će biti uklonjene iz indeksa pretrage.',
        'Spanish stop words for fulltext index. These words will be removed from the search index.' =>
            'Španske zaustavne reči za indeks pretragu kompletnog teksta. Ove reči će biti uklonjene iz indeksa pretrage.',
        'French stop words for fulltext index. These words will be removed from the search index.' =>
            'Francuske zaustavne reči za indeks pretrage kompletnog teksta. Ove reči će biti uklonjene iz indeksa pretrage.',
        'Italian stop words for fulltext index. These words will be removed from the search index.' =>
            'Italijanske zaustavne reči za indeks pretrage kompletnog teksta. Ove reči će biti uklonjene iz indeksa pretrage.',
        'Customizable stop words for fulltext index. These words will be removed from the search index.' =>
            'Podesive zaustavne reči za indeks kompletnog teksta. Ove reči će biti uklonjene iz indeksa pretrage.',
        'Allows having a small format ticket overview (CustomerInfo =&gt; 1 - shows also the customer information).' =>
            '',
        'Allows having a medium format ticket overview (CustomerInfo =&gt; 1 - shows also the customer information).' =>
            '',
        'Shows a preview of the ticket overview (CustomerInfo =&gt; 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' =>
            '',
        'Defines which article sender types should be shown in the preview of a ticket.' =>
            'Definiše koji tipovi pošiljaoca artikla treba da budu pokazani u prikazu tiketa.',
        'Sets the count of articles visible in preview mode of ticket overviews.' =>
            'Podešava broja članaka vidljivih u modu prikaza pregleda tiketa.',
        'Defines if the first article should be displayed as expanded, that is visible for the related customer. If nothing defined, latest article will be expanded.' =>
            'Definiše da li će prvi članak vidljiv za klijenta biti prikazan kao proširen. Ako ništa nije definisano, poslednji članak će biti proširen.',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' =>
            'Vreme u sekundama koje se dodaje na trenutno vreme ako se postavlja status na čekanju (podrazumevano: 86400 = 1 dan).',
        'Define the max depth of queues.' => 'Definiši maksimalnu dubinu za redove.',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' =>
            'Prikazuje postojeće liste redova nadređeni-podređeni u sistemu u formi stabla ili liste.',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' =>
            'Aktivira ili isključuje mogućnost nadzora tiketa, radi praćenja tiketa bez vlasnika ili odgovorne osobe.',
        'Enables ticket watcher feature only for the listed groups.' => 'Aktivira funkciju nadzora tiketa samo za izlistane grupe.',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' =>
            'Aktivira funkciju masovne akcije na tiketima za operaterski pristupni sistem na više tiketa istovremeno.',
        'Enables ticket bulk action feature only for the listed groups.' =>
            'Aktivira funkciju masovne akcije na tiketima samo za izlistane grupe.',
        'Defines time in minutes since last modification for drafts of specified type before they are considered expired.' =>
            'Definiše vreme u minutima od poslednje promene određenog tipa nacrta pre nego što se smatraju zastarelim.',
        'Shows a link to see a zoomed email ticket in plain text.' => 'Prikazuje vezu za prikaz detaljnog pregleda tiketa kao običan tekst.',
        'Shows all the articles of the ticket (expanded) in the agent zoom view.' =>
            'Prikazuje sve članke tiketa (detaljno) na detaljnom pregledu.',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' =>
            'Prikazuje članke sortirano normalno ili obrnuto, na detaljnom prikazu tiketa u interfejsu operatera.',
        'Shows the article head information in the agent zoom view.' => 'Uvek prikazuje sve detaljne informacije članka tiketa u detaljnom pregledu operatera.',
        'Shows a count of attachments in the ticket zoom, if the article has attachments.' =>
            'Prikazuje broj priloga u detaljnom prikazu tiketa, ako članak ima priloge.',
        'Displays the accounted time for an article in the ticket zoom view.' =>
            'Prikazuje obračunato vreme za jedan članak u detaljnom pregledu tiketa.',
        'Activates the article filter in the zoom view to specify which articles should be shown.' =>
            'Aktivira filter za članke u proširenom pregledu radi definisanja koji članci treba da budu prikazani.',
        'Displays the number of all tickets with the same CustomerID as current ticket in the ticket zoom view.' =>
            'Prikazuje broj svih tiketa sa istim ID klijenta kao trenutni tiket u detaljnom pregledu tiketa.',
        'Shows the ticket history (reverse ordered) in the agent interface.' =>
            'Prikazuje istorijat tiketa (obrnut redosled) u interfejsu operatera.',
        'Controls how to display the ticket history entries as readable values.' =>
            'Kontroliše način prikaza istorijskih unosa tiketa kao čitljivih vrednosti. ',
        'Permitted width for compose email windows.' => 'Dozvoljena širina prozora za pisanje poruke.',
        'Permitted width for compose note windows.' => 'Dozvoljena širina prozora za pisanje napomene.',
        'Max size (in rows) of the informed agents box in the agent interface.' =>
            'Maksimalna veličina (u redovima) okvira informisanih operatera u operaterskom interfejsu.',
        'Max size (in rows) of the involved agents box in the agent interface.' =>
            'Maksimalna veličina (u redovima) okvira uključenih operatera u operaterskom interfejsu.',
        'Makes the application block external content loading.' => 'Primorava aplikaciju da blokira učitavanje eksternog sadržaja.',
        'Shows the customer user information (phone and email) in the compose screen.' =>
            'Prikazuje podatke o klijentu korisniku (broj telefona i imejl) na ekranu pisanja odgovora.',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' =>
            'Maksimalna dužina (u znacima) klijentske info tabele (telefon i imejl) na ekranu pisanja imejla.',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' =>
            'Maksimalna dužina (u znacima) klijentske info tabele na detaljnom pregledu tiketa.',
        'Maximum length (in characters) of the dynamic field in the sidebar of the ticket zoom view.' =>
            'Maksimalna dužina (u znacima) dinamičkog polja u bočnoj traci na detaljnom pregledu tiketa.',
        'Maximum length (in characters) of the dynamic field in the article of the ticket zoom view.' =>
            'Maksimalna dužina (u znacima) dinamičkog polja u članku na detaljnom pregledu tiketa.',
        'Controls if customers have the ability to sort their tickets.' =>
            'Kontroliše da li klijenti imaju mogućnost da sortiraju svoje tikete.',
        'This option will deny the access to customer company tickets, which are not created by the customer user.' =>
            'Ova opcija će odbiti pristup tiketima klijentove firme, ako ih  nije  kreirao klijent korisnik .',
        'Custom text for the page shown to customers that have no tickets yet (if you need those text translated add them to a custom translation module).' =>
            'Prilagođen tekst za stranicu koja se prikazuje klijentima koji još uvek nemaju tikete (ako vam je taj tekst potreban na drugom jeziku, dodajte ga u prilagođen modul za prevode).',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' =>
            'Prikazuje predmet zadnjeg klijentovog članka ili naslov tiketa u prekledu malog formata.',
        'Show the current owner in the customer interface.' => 'Prikazuje aktuelnog vlasnika u klijentskom interfejsu.',
        'Show the current queue in the customer interface.' => 'Prikazuje aktuelni red u klijentskom interfejsu.',
        'Dynamic fields shown in the ticket overview screen of the customer interface.' =>
            'Dinamička polja prikazana u pregledu tiketa u interfejsu klijenta.',
        'Strips empty lines on the ticket preview in the queue view.' => 'Uklanja prazne linije u prikazu tiketa na pregledu reda.',
        'Shows all both ro and rw queues in the queue view.' => 'Prikazuje sve, i ro i rw redove na pregledu redova.',
        'Show queues even when only locked tickets are in.' => 'Prikaži redove čak i kad sadrže samo zaključane tikete.',
        'Enable highlighting queues based on ticket age.' => 'Omogući obeležavanje redova na osnovu starosti tiketa.',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' =>
            'Postavi vreme u minutama (prvi nivo) za naglašavanje redova koji sadrže netaknute tikete.',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' =>
            'Postavi vreme u minutama (drugi nivo) za naglašavanje redova koji sadrže netaknute tikete.',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' =>
            'Aktivira mehanizam treptanja reda koji sarži najstariji tiket.',
        'Include tickets of subqueues per default when selecting a queue.' =>
            'Kod izbora reda, podrazumevano uključi i tikete podredova.',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' =>
            'Sortiranje tiketa (rastuće ili opadajuće) kada se izabere jedan red iz pregleda redova posle sortiranja tiketa po prioritetu. Vrednosti: 0 = rastuće (najstarije na vrhu, podrazumevano), 1 = opadajuće (najnovije na vrhu). Koristi ID reda za ključ i 0 ili 1 za vrednost.',
        'Defines the default sort criteria for all queues displayed in the queue view.' =>
            'Određuje podrazumevani kriterijum sortiranja za sve redove prikazane u pregledu reda.',
        'Defines if a pre-sorting by priority should be done in the queue view.' =>
            'Određuje ako prethodno sortiranje po prioritetu treba da se uradi u prikazu reda.',
        'Defines the default sort order for all queues in the queue view, after priority sort.' =>
            'Određuje podrazumevani redosled sortiranja za sve redove prikazane u prikazu reda, nakon sortiranja po prioritetu.',
        'Strips empty lines on the ticket preview in the service view.' =>
            'Uklanja prazne linije u prikazu tiketa na pregledu usluga.',
        'Shows all both ro and rw tickets in the service view.' => 'Prikazuje sve, i ro i rw tikete na pregledu usluga.',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the service view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the ServiceID for the key and 0 or 1 for value.' =>
            'Sortiranje tiketa (rastuće ili opadajuće) kada se izabere jedan red iz pregleda usluge posle sortiranja tiketa po prioritetu. Vrednosti: 0 = rastuće (najstarije na vrhu, podrazumevano), 1 = opadajuće (najnovije na vrhu). Koristi ID usluge za ključ i 0 ili 1 za vrednost.',
        'Defines the default sort criteria for all services displayed in the service view.' =>
            'Definiše podrazumevani kriterijum sortiranja za sve servise prikazane u servisnom pregledu.',
        'Defines if a pre-sorting by priority should be done in the service view.' =>
            'Određuje da li prethodno sortiranje po prioritetu treba da se uradi u servisnom prikazu.',
        'Defines the default sort order for all services in the service view, after priority sort.' =>
            'Definiše podrazumevani kriterijum sortiranja za sve servise u servisnom pregledu, posle  sortiranja po prioritu.',
        'Activates time accounting.' => 'Aktivira merenje vremena.',
        'Sets the prefered time units (e.g. work units, hours, minutes).' =>
            'Podesi prioritetne vremenske jedinice (npr jedinice posla, sate, minute)',
        'Defines if time accounting is mandatory in the agent interface. If enabled, a note must be entered for all ticket actions (no matter if the note itself is configured as active or is originally mandatory for the individual ticket action screen).' =>
            'Definiše da li je obračun vremena obavezan u interfejsu operatera. Ako je uključeno, za sve akcije na tiketima se mora uneti napomena (bez obzira da li je sama napomena konfigurisana kao aktivna ili je inače obavezna na ekranu individualne akcije na tiketu).',
        'Defines if time accounting must be set to all tickets in bulk action.' =>
            'Određuje da li obračun vremena mora biti podešen na svim tiketima u masovnim akcijama.',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' =>
            'Definiše podrazumevani atribut tiketa za sortiranje tiketa u pregledu statusa interfejsa operatera.',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' =>
            'Definiše podrazumevani redosled tiketa (posle sortiranja po prioritetu) u pregledu statusa u interfejsu opreratera. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'Defines the required permission to show a ticket in the escalation view of the agent interface.' =>
            'Definiše zahtevanu dozvolu za prikaz tiketa u eskalacionom pregledu interfejsa operatera.',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' =>
            'Definiše podrazumevani atribut tiketa za sortiranje tiketa u eskalacionom pregledu interfejsa operatera.',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' =>
            'Definiše podrazumevani redosled tiketa (posle sortiranja po prioritetu) u eskalacionom pregledu u interfejsu opreratera. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search e. g. ticket title with this kind of conditions like "(*key1*&amp;&amp;*key2*)" or "(*key1*||*key2*)".' =>
            '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' =>
            'Maksimalni broj tiketa koji će biti prikazani u rezultatu pretrage u interfejsu operatera.',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' =>
            'Broj tiketa koji će biti prikazani na svakoj strani rezultata pretrage u interfejsu operatera.',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' =>
            'Broj linija (po tiketu) prikazanih prema uslužnoj pretrazi u interfejsu operatera.',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' =>
            'Definiše podrazumevani atribut tiketa za sortiranje tiketa u rezultatu pretrage tiketa interfejsa operatera.',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' =>
            'Definiše podrazumevani redosled tiketa (posle sortiranja po prioritetu) u pregledu pretrage tiketa u interfejsu opreratera. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'Exports the whole article tree in search result (it can affect the system performance).' =>
            'Izvozi celo stablo članaka u rezultat pretrage (može ozbiljno da utiče na performanse sistema).',
        'Data used to export the search result in CSV format.' => 'Podaci upotrebljeni za ivoz rezultata pretraživanja u CSV formatu.',
        'Includes article create times in the ticket search of the agent interface.' =>
            'Uključuje vremena kreiranja tiketa u pretragu na operaterskom interfejsu.',
        'Defines the default shown ticket search attribute for ticket search screen.' =>
            'Definiše podrazumevani prikaz pretrage atributa tiketa za prikaz ekrana pretrage tiketa.',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' =>
            'Podrazumevani podaci za korišćenje na atributima za prikaz pretrage tiketa. Primer: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' =>
            'Podrazumevani podaci za korišćenje na atributima za prikaz pretrage tiketa. Primer: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".',
        'Default data to use on attribute for ticket search screen. Example: "TicketLastChangeTimePointFormat=year;TicketLastChangeTimePointStart=Last;TicketLastChangeTimePoint=2;".' =>
            '',
        'Default data to use on attribute for ticket search screen. Example: "TicketLastChangeTimeStartYear=2010;TicketLastChangeTimeStartMonth=10;TicketLastChangeTimeStartDay=4;TicketLastChangeTimeStopYear=2010;TicketLastChangeTimeMonth=11;TicketLastChangeTimeStopDay=3;".' =>
            '',
        'Default data to use on attribute for ticket search screen. Example: "TicketPendingTimePointFormat=year;TicketPendingTimePointStart=Last;TicketPendingTimePoint=2;".' =>
            '',
        'Default data to use on attribute for ticket search screen. Example: "TicketPendingTimeStartYear=2010;TicketPendingTimeStartMonth=10;TicketPendingTimeStartDay=4;TicketPendingTimeStopYear=2010;TicketPendingTimeMonth=11;TicketPendingTimeStopDay=3;".' =>
            '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' =>
            'Definiše podrazumevani atribut tiketa za sortiranje tiketa u pregledu zaključanog tiketa interfejsa operatera.',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' =>
            'Definiše podrazumevani redosled tiketa (posle sortiranja po prioritetu) u pregledu zaključanih tiketa u interfejsu opreratera. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' =>
            'Definiše podrazumevani atribut tiketa za sortiranje tiketa u odgovornom pregledu interfejsa operatera.',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' =>
            'Definiše podrazumevani redosled tiketa (posle sortiranja po prioritetu) u odgovornom pregledu u interfejsu opreratera. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' =>
            'Definiše podrazumevani atribut tiketa za sortiranje tiketa u posmatranom pregledu interfejsa operatera.',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' =>
            'Definiše podrazumevani redosled tiketa u posmatranom pregledu interfejsa operatera. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'Required permissions to use the ticket free text screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana slobodnog teksta tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu slobodnog teksta tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be enabled).' =>
            'Određuje tip tiketa na ekranu slobodnog teksta tiketa u interfejsu operatera (Ticket::Type mora biti uključeno).',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be enabled).' =>
            'Podešava servis na ekranu slobodnog teksta tiketa u interfejsu operatera (Ticket::Service treba da bude aktiviran).',
        'Sets if service must be selected by the agent.' => 'Podešava da li usluga mora biti izabrana od strane operatera.',
        'Sets if SLA must be selected by the agent.' => 'Podešava ako SLA mora biti izabran od strane operatera.',
        'Sets the queue in the ticket free text screen of a zoomed ticket in the agent interface.' =>
            'Postavlja red na prozoru slobodnog teksta tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets if queue must be selected by the agent.' => 'Definiše da li operater mora da odabere red.',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' =>
            'Postavlja vlasnika tiketa u prozoru slobodnog teksta tiketa u interfejsu operatera.',
        'Sets if ticket owner must be selected by the agent.' => 'Podešava ako vlasnik tiketa mora biti izabran od strane operatera.',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' =>
            'Postavlja odgovornog operatera za tiket na prozoru slobodnog teksta tiketa u interfejsu operatera.',
        'Sets if ticket responsible must be selected by the agent.' => 'Definiše da li operater mora da odabere odgovornog tiketa.',
        'Sets the state of a ticket in the ticket free text screen of the agent interface.' =>
            'Postavlja status tiketa u ekranu slobodnog teksta u interfejsu operatera.',
        'Sets if state must be selected by the agent.' => 'Definiše da li operater mora da odabere stanje.',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' =>
            'Definiše sledeći status tiketa nakon dodavanja napomene u prikazu ekrana tiketa slobodnog teksta interfejsa operatera.',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u prikazu ekrana tiketa slobodnog teksta u interfejsu operatera.',
        'Allows adding notes in the ticket free text screen of the agent interface. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Dozvoljava dodavanje napomena na ekranu slobodnog teksta tiketa interfejsa operatera. Ticket::Frontend::NeedAccountedTime je može prepisati.',
        'Sets if note must be filled in by the agent. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Određuje da li napomena mora biti popunjena od strane operatera. Ovo ponašanje je moguće preinačiti putem Ticket::Frontend::NeedAccountedTime.',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' =>
            'Definiše podrazumevani predmet napomene za prikaz ekrana tiketa slobodnog teksta u interfejsu operatera.',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' =>
            'Definiše telo napomene na prikazu ekrana slobodnog teksta tiketa u interfejsu operatera.',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' =>
            'Prikazuje listu svih uključenih operatera za ovaj tiket, na ekranu slobodnog teksta tiketa u operaterskom interfejsu.',
        'Shows a list of all the possible agents (all agents with at least ro permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' =>
            '',
        'Defines if the note in the ticket free text screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu slobodnog teksta tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu slobodnog teksta tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa na prikazu ekrana tiketa slobodnog teksta u interfejsu operatera.',
        'Shows the title field in the ticket free text screen of the agent interface.' =>
            'Prikazuje polje naslova naekranu slobodnog teksta tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket free text screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu slobodnog teksta tiketa u interfejsu operatera.',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti tiketa slobodnog teksta, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti tiketa slebodnog teksta, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana odlaznih poziva tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu odlaznih poziva tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' =>
            'Definiše podrazumevani tip pošiljaoca za tikete poziva na prikazu ekrana za odlazne pozive u interfejsu operatera.',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' =>
            'Definiše podrazumevani predmet za tikete poziva na prikazu ekrana za odlazne pozive u interfejsu operatera.',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa poziva u prikazu ekrana za odlazne pozive u interfejsu operatera.',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja poziva na prikazu ekrana za odlazne pozive u interfejsu operatera.',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' =>
            'Sledeći mogući status tiketa nakon dodavanja poziva u ekranu odlaznih poziva tiketa u interfejsu operatera.',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip za akciju odlaznih poziva tiketa, koji se koristi za istorijat tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar za akciju odlaznih poziva tiketa, koji se koristi za istorijat tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket phone outbound screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu odlaznih poziva tiketa u interfejsu operatera.',
        'Required permissions to use the ticket phone inbound screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana dolaznih poziva tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket phone inbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu dolaznih poziva tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Defines the default sender type for phone tickets in the ticket phone inbound screen of the agent interface.' =>
            'Definiše podrazumevani tip pošiljaoca za tikete poziva na prikazu ekrana za dolazne pozive u interfejsu operatera.',
        'Defines the default subject for phone tickets in the ticket phone inbound screen of the agent interface.' =>
            'Definiše podrazumevani predmet za tikete poziva na prikazu ekrana za dolazne pozive u interfejsu operatera.',
        'Defines the default note body text for phone tickets in the ticket phone inbound screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa poziva u prikazu ekrana za dolazne pozive u interfejsu operatera.',
        'Defines the default ticket next state after adding a phone note in the ticket phone inbound screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja poziva na prikazu ekrana za dolazne pozive u interfejsu operatera.',
        'Next possible ticket states after adding a phone note in the ticket phone inbound screen of the agent interface.' =>
            'Sledeći mogući status tiketa nakon dodavanja poziva u ekranu dolaznih poziva tiketa u interfejsu operatera.',
        'Defines the history type for the ticket phone inbound screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip za akciju dolaznih poziva tiketa, koji se koristi za istorijat tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket phone inbound screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar za akciju dolaznih poziva tiketa, koji se koristi za istorijat tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket phone inbound screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu dolaznih poziva tiketa u interfejsu operatera.',
        'Shows an owner selection in phone and email tickets in the agent interface.' =>
            'Prikazuje izbor vlasnika za tikete poziva i imejl tikete u interfejsu operatera.',
        'Show a responsible selection in phone and email tickets in the agent interface.' =>
            'Prikaži izbor odgovornog u tiketima poziva i imejl tiketima u interfejsu operatera.',
        'Defines the recipient target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "System address" displays all system addresses) in the agent interface.' =>
            'Određuje ciljnog primaoca tiketa poziva i pošiljaoca imejl tiketa ("Red" prikazuje sve redove, "Sistemska adresa" prikazuje sve sistemske adrese) u interfejsu operatera.',
        'Determines the strings that will be shown as recipient (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "&lt;Queue&gt;" shows the names of the queues and for SystemAddress "&lt;Realname&gt; &lt;&lt;Email&gt;&gt;" shows the name and email of the recipient.' =>
            '',
        'Determines which options will be valid of the recipient (phone ticket) and the sender (email ticket) in the agent interface.' =>
            'Određuje koje opcije će biti važeće za primaoca (tiket poziva) i pošiljaoca (imejl tiket) u interfejsu operatera.',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' =>
            'Prikazuje istorijat tiketa klijenta u AgentTicketPhone, AgentTicketEmail i AgentTicketCustomer.',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' =>
            'Ako je aktivirano, tiketi poziva i imejl tiketi će biti otvoreni u novom prozoru.',
        'Sets the default priority for new phone tickets in the agent interface.' =>
            'Određuje podrazumevani prioritet novog tiketa poziva u interfejsu operatera.',
        'Sets the default sender type for new phone ticket in the agent interface.' =>
            'Postavlja podrazumevani tip pošiljaoca za nove tikete poziva u interfejsu operatera.',
        'Sets the default article customer visibility for new phone tickets in the agent interface.' =>
            'Definiše podrazumevanu vidljivost članaka klijentu za nove tikete poziva u interfejsu operatera.',
        'Controls if more than one from entry can be set in the new phone ticket in the agent interface.' =>
            'Kontroliše da li više od jednog pošiljaoca može biti podešeno u novom tiketu poziva u interfejsu operatera.',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' =>
            'Određuje podrazumevani predmet za nove tikete poziva (npr. \'Poziv\') u interfejsu operatera.',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' =>
            'Postavlja podrazumevani tekst napomene za nove tikete poziva. Npr. \'Novi tiket putem poziva\' u interfejsu operatera.',
        'Sets the default next state for new phone tickets in the agent interface.' =>
            'Određuje podrazumevani sledeći status za nove tikete poziva u interfejsu operatera.',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' =>
            'Određuje sledeći mogući status tiketa, nakon kreiranja novog tiketa poziva u interfejsu operatera.',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip za akciju tiketa poziva, koji se koristi za istorijat tiketa u interfejsu operatera.',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar za akciju tiketa poziva, koji se koristi za istorijat tiketa u interfejsu operatera.',
        'Sets the default link type of splitted tickets in the agent interface.' =>
            'Postavlja podrazumevani tip veze za podeljene tikete u interfejsu operatera.',
        'Sets the default priority for new email tickets in the agent interface.' =>
            'Određuje podrazumevani prioritet novog imejl tiketa a u interfejsu operatera.',
        'Sets the default article customer visibility for new email tickets in the agent interface.' =>
            'Definiše podrazumevanu vidljivost članka klijentu za nove imejl tikete u interfejsu operatera.',
        'Sets the default sender type for new email tickets in the agent interface.' =>
            'Postavlja podrazumevani tip pošiljaoca za nove imejl tikete u interfejsu operatera.',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' =>
            'Određuje podrazumevani predmet za nove imejl tikete (npr. \'odlazni imejl\') u interfejsu operatera.',
        'Sets the default text for new email tickets in the agent interface.' =>
            'Određuje podrazumevani tekst novog imejl tiketa a u interfejsu operatera.',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' =>
            'Određuje podrazumevani sledeći status tiketa, nakon kreiranja imejl tiketa u interfejsu operatera.',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' =>
            'Određuje sledeći mogući status tiketa, nakon kreiranja novog imejl tiketa u interfejsu operatera.',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti imejl tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti imejl tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Required permissions to use the close ticket screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana zatvaranja tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu zatvaranja tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be enabled).' =>
            'Određuje tip tiketa na ekranu zatvaranja tiketa u interfejsu operatera (Ticket::Type mora biti uključeno).',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be enabled).' =>
            'Podešava servis na ekranu zatvaranja tiketa u interfejsu operatera (Ticket::Service treba da bude aktiviran).',
        'Sets the queue in the ticket close screen of a zoomed ticket in the agent interface.' =>
            'Postavlja red na prozoru zatvaranja tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the ticket owner in the close ticket screen of the agent interface.' =>
            'Postavlja vlasnika tiketa u prozoru zatvaranja tiketa u interfejsu operatera.',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' =>
            'Postavlja odgovornog operatera za tiket na prozoru zatvaranja tiketa u interfejsu operatera.',
        'Sets the state of a ticket in the close ticket screen of the agent interface.' =>
            'Postavlja status tiketa u ekranu zatvaranja tiketa u interfejsu operatera.',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' =>
            'Definiše sledeći status tiketa nakon dodavanja napomene u prikazu ekrana zatvorenog tiketa interfejsa operatera.',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u prikazu ekrana zatvorenog tiketa u interfejsu operatera.',
        'Allows adding notes in the close ticket screen of the agent interface. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Dozvoljava dodavanje napomena na ekranu zatvaranja tiketa interfejsa operatera. Ticket::Frontend::NeedAccountedTime je može prepisati.',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' =>
            'Određuje podrazumevani predmet za napomene dodate na prikazu ekrana zatvorenog tiketa u interfejsu operatera.',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' =>
            'Postavlja podrazumevani sadržaj za napomene dodate na ekranu zatvaranja tiketa u interfejsu operatera.',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' =>
            'Prikazuje listu svih uključenih operatera za ovaj tiket, na ekranu zatvaranja tiketa u operaterskom interfejsu.',
        'Shows a list of all the possible agents (all agents with at least ro permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' =>
            '',
        'Defines if the note in the close ticket screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu zatvaranja tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu zatvorenog tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa na prikazu ekrana zatvorenog tiketa u interfejsu operatera.',
        'Shows the title field in the close ticket screen of the agent interface.' =>
            'Prikazuje polje naslova u ekranu zatvaranja tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the close ticket screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu zatvaranja tiketa u interfejsu operatera.',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti zatvorenog tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti zatvorenog tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Required permissions to use the ticket note screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana napomena tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje ako je potrebno zaključati tiket u ekranu napomene tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be enabled).' =>
            'Određuje tip tiketa na ekranu napomene tiketa u interfejsu operatera (Ticket::Type mora biti uključeno).',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be enabled).' =>
            'Podešava servis na ekranu napomene tiketa u interfejsu operatera (Ticket::Service treba da bude aktiviran).',
        'Sets the queue in the ticket note screen of a zoomed ticket in the agent interface.' =>
            'Postavlja red na prozoru napomene tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the ticket owner in the ticket note screen of the agent interface.' =>
            'Postavlja vlasnika tiketa u prozoru napomene tiketa u interfejsu operatera.',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' =>
            'Postavlja odgovornog operatera za tiket na prozoru napomene tiketa u interfejsu operatera.',
        'Sets the state of a ticket in the ticket note screen of the agent interface.' =>
            'Postavlja status tiketa u ekranu napomene u interfejsu operatera.',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' =>
            'Definiše sledeći status tiketa nakon dodavanja napomene u prikazu ekrana napomene tiketa interfejsa operatera.',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u prikazu ekrana napomene tiketa u interfejsu operatera.',
        'Allows adding notes in the ticket note screen of the agent interface. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Dozvoljava dodavanje napomena na ekranu napomene tiketa interfejsa operatera. Ticket::Frontend::NeedAccountedTime je može prepisati.',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' =>
            'Određuje podrazumevani predmet za napomene dodate na prikazu ekrana napomena tiketa u interfejsu operatera.',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' =>
            'Postavlja podrazumevani sadržaj za napomene dodate na ekranu napomene tiketa u interfejsu operatera.',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' =>
            'Prikazuje listu svih uključenih operatera za ovaj tiket, na ekranu napomene tiketa u operaterskom interfejsu.',
        'Shows a list of all the possible agents (all agents with at least ro permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' =>
            '',
        'Defines if the note in the ticket note screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu napomene tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu napomene tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa na prikazu ekrana napomene tiketa u interfejsu operatera.',
        'Shows the title field in the ticket note screen of the agent interface.' =>
            'Prikazuje polje naslova u ekranu napomene tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket note screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu napomena tiketa u interfejsu operatera.',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti napomene tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti napomene tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana vlasnika tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu vlasnika tiketa u detaljnom pregledu tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be enabled).' =>
            'Određuje tip tiketa na ekranu vlasnika tiketa u interfejsu operatera (Ticket::Type mora biti uključeno).',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be enabled).' =>
            'Podešava servis na ekranu vlasnika tiketa na detaljnom pregledu tiketa u interfejsu operatera (Ticket::Service treba da bude aktiviran).',
        'Sets the queue in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Postavlja red na prozoru vlasnika tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Određuje vlasnika tiketa na ekranu vlasništva tiketa u detaljnom prikazu tiketa interfejsa operatera.',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Postavlja odgovornog operatera za tiket u prozoru vlasnika tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Postavlja status tiketa u ekranu vlasnika u interfejsu operatera.',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Definiše sledeći status tiketa nakon dodavanja napomene u ekranu vlasnika tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u ekranu vlasnika tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Dozvoljava dodavanje napomena na ekranu vlasnika tiketa interfejsa operatera. Ticket::Frontend::NeedAccountedTime je može prepisati.',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Određuje podrazumevani predmet za napomene dodate na detaljnom prikazu ekrana vlasnika tiketa u interfejsu operatera.',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Postavlja podrazumevani sadržaj za napomene dodate na ekranu vlasnika tiketa u interfejsu operatera.',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje listu svih uključenih operatera za ovaj tiket, na ekranu vlasnika tiketa na detaljnom prikazu tiketa u operaterskom interfejsu.',
        'Shows a list of all the possible agents (all agents with at least ro permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            '',
        'Defines if the note in the ticket owner screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu vlasnika tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu vlasnika na detaljnom prikazu tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa u ekranu vlasnika tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Shows the title field in the ticket owner screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje polje naslova u ekranu vlasnika tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket owner screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu vlasnika tiketa u interfejsu operatera.',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti vlasnika tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti vlasnika tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana tiketa na čekanju u detaljnom pregledu tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu tiketa na čekanju u detaljnom pregledu tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be enabled).' =>
            'Određuje tip tiketa na ekranu tiketa na čekanju u interfejsu operatera (Ticket::Type mora biti uključeno).',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be enabled).' =>
            'Podešava servis na ekranu tiketa na čekanju na detaljnom pregledu tiketa u interfejsu operatera (Ticket::Service treba da bude aktiviran).',
        'Sets the queue in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Postavlja red na prozoru tiketa na čekanju na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Određuje vlasnika tiketa na ekranu tiketa na čekanju u detaljnom prikazu tiketa interfejsa operatera.',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Postavlja odgovornog operatera za tiket u prozoru tiketa na čekanju na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Postavlja status tiketa u ekranu čekanja u interfejsu operatera.',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Definiše sledeći status tiketa nakon dodavanja napomene u ekranu tiketa na čekanju u detaljnom pregledu tiketa u interfejsu operatera.',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u ekranu tiketa na čekanju u detaljnom pregledu tiketa u interfejsu operatera.',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Dozvoljava dodavanje napomena na ekranu tiketa na čekanju interfejsa operatera. Ticket::Frontend::NeedAccountedTime je može prepisati.',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Određuje podrazumevani predmet za napomene dodate na detaljnom prikazu ekrana tiketa na čekanju u interfejsu operatera.',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Postavlja podrazumevani sadržaj za napomene dodate na ekranu tiketa na čekanju na detaljnom prikazu tiketa u interfejsu operatera.',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje listu svih uključenih operatera za ovaj tiket, na ekranu tiketa na čekanju na detaljnom prikazu tiketa u operaterskom interfejsu.',
        'Shows a list of all the possible agents (all agents with at least ro permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            '',
        'Defines if the note in the ticket pending screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu tiketa na čekanju u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu prikaza  čekanja na detaljnom prikazu tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa u ekranu tiketa na čekanju u detaljnom pregledu tiketa u interfejsu operatera.',
        'Shows the title field in the ticket pending screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje polje naslova u ekranu tiketa na čekanju u interfejsu operatera.',
        'Allows to save current work as draft in the ticket pending screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu tiketa na čekanju u interfejsu operatera.',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti tiketa na čekanju, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti tiketa na čekanju, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana prioriteta tiketa u detaljnom pregledu tiketa tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu prioriteta tiketa u detaljnom pregledu tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be enabled).' =>
            'Određuje tip tiketa na ekranu prioriteta tiketa u interfejsu operatera (Ticket::Type mora biti uključeno).',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be enabled).' =>
            'Podešava servis na ekranu prioriteta tiketa na detaljnom pregledu tiketa u interfejsu operatera (Ticket::Service treba da bude aktiviran).',
        'Sets the queue in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Postavlja red na prozoru prioriteta tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Određuje vlasnika tiketa na ekranu prioriteta tiketa u detaljnom prikazu tiketa interfejsa operatera.',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Postavlja odgovornog operatera za tiket u prozoru prioriteta tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Postavlja status tiketa u ekranu prioriteta u interfejsu operatera.',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Definiše sledeći status tiketa nakon dodavanja napomene u ekranu prioriteta tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u ekranu prioriteta tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Dozvoljava dodavanje napomena na ekranu prioriteta detaljnog prikaza tiketa interfejsa operatera. Ticket::Frontend::NeedAccountedTime je može prepisati.',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Određuje podrazumevani predmet za napomene dodate na detaljnom prikazu ekrana prioriteta tiketa u interfejsu operatera.',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Postavlja podrazumevani sadržaj za napomene dodate na ekranu prioriteta tiketa na detaljnom prikazu tiketa u interfejsu operatera.',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje listu svih uključenih operatera za ovaj tiket, na ekranu prioriteta tiketa na detaljnom prikazu tiketa u operaterskom interfejsu.',
        'Shows a list of all the possible agents (all agents with at least ro permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            '',
        'Defines if the note in the ticket priority screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu prioriteta tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu prioriteta na detaljnom prikazu tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa u ekranu prioriteta tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Shows the title field in the ticket priority screen of a zoomed ticket in the agent interface.' =>
            'Prikazuje polje naslova u ekranu prioriteta tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket priority screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu prioriteta tiketa u interfejsu operatera.',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti prioritetnog tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti prioritetnih tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Required permissions to use the ticket responsible screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana odgovornog tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu odgovornog tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be enabled).' =>
            'Određuje tip tiketa na ekranu odgovornog tiketa u interfejsu operatera (Ticket::Type mora biti uključeno).',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be enabled).' =>
            'Podešava servis na ekranu odgovornog za tiket u interfejsu operatera (neophodno je uključiti Ticket::Service).',
        'Sets the queue in the ticket responsible screen of a zoomed ticket in the agent interface.' =>
            'Postavlja red na prozoru odgovornog za tiket na detaljnom prikazu tiketa u interfejsu operatera.',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' =>
            'Određuje vlasnika tiketa na ekranu odgovornosti za tiket u interfejsu operatera.',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' =>
            'Postavlja odgovornog operatera za tiket u prozoru odgovornog za tiket u interfejsu operatera.',
        'Sets the state of a ticket in the ticket responsible screen of the agent interface.' =>
            'Postavlja status tiketa u ekranu odgovornog u interfejsu operatera.',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' =>
            'Definiše sledeći status tiketa nakon dodavanja napomene u prikazu ekrana odgovornog tiketa u interfejsu operatera.',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u prikazu ekrana odgovornog tiketa u interfejsu operatera.',
        'Allows adding notes in the ticket responsible screen of the agent interface. Can be overwritten by Ticket::Frontend::NeedAccountedTime.' =>
            'Dozvoljava dodavanje napomena na ekranu odgovornog za tiket interfejsa operatera. Ticket::Frontend::NeedAccountedTime je može prepisati.',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' =>
            'Određuje podrazumevani predmet za napomene dodate na prikazu ekrana odgovornog za tiket u interfejsu operatera.',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' =>
            'Postavlja podrazumevani sadržaj za napomene dodate na ekranu odgovornog za tiket u interfejsu operatera.',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' =>
            'Prikazuje listu svih uključenih operatera za ovaj tiket, na ekranu odgovornog za tiket u operaterskom interfejsu.',
        'Shows a list of all the possible agents (all agents with at least ro permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' =>
            '',
        'Defines if the note in the ticket responsible screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu odgovornog tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu o odgovornosti na detaljnom prikazu tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa na prikazu ekrana odgovornog tiketa interfejsa operatera.',
        'Shows the title field in the ticket responsible screen of the agent interface.' =>
            'Prikazuje polje naslova u ekranu odgovornog tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket responsible screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu odgovornog tiketa u interfejsu operatera.',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše tip istorije za prikaz ekrana aktivnosti odgovornog tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' =>
            'Definiše komentar istorije za prikaz ekrana aktivnosti odgovornih tiketa, koji se koristi za istoriju tiketa u interfejsu operatera.',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' =>
            'Automatsko zaključavanje i podešavanje vlasnika na aktuelnog operatera posle izbora masovne akcije.',
        'Sets the ticket type in the ticket bulk screen of the agent interface.' =>
            'Određuje tip tiketa na ekranu masovne akcije tiketa u interfejsu operatera.',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' =>
            'Postavlja vlasnika tiketa u prozoru masovnih akcija tiketa u interfejsu operatera.',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' =>
            'Postavlja odgovornog operatera za tiket na prozoru masovnih akcija tiketa u interfejsu operatera.',
        'Sets the state of a ticket in the ticket bulk screen of the agent interface.' =>
            'Postavlja status tiketa u ekranu masovnih akcija u interfejsu operatera.',
        'Defines the next state of a ticket, in the ticket bulk screen of the agent interface.' =>
            'Definiše sledeći status tiketa u prikazu ekrana masovnih tiketa u interfejsu operatera.',
        'Defines the default next state of a ticket, in the ticket bulk screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa u prikazu ekrana masovnih tiketa u interfejsu operatera.',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu masovnih tiketa u interfejsu operatera.',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' =>
            'Određuje podrazumevani prioritet tiketa na prikazu ekrana masovnih tiketa u interfejsu operatera.',
        'Defines if the note in the ticket bulk screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu masovne akcije tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' =>
            'Određuje da li lista mogućih redova za premeštanje u tiket treba da bude prikazana u padajućoj listi ili u novom prozoru u interfejsu operatera. Ako je podešen "Novi prozor" možete dodavati napomene o premeštanju u tiket.',
        'Automatically lock and set owner to current Agent after opening the move ticket screen of the agent interface.' =>
            'Automatsko zaključavanje i podešavanje vlasnika na aktuelnog operatera posle otvaranja prozora za premeštanje tiketa u interfejsu operatera.',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' =>
            'Dozvoljava podešavanje statusa novog tiketa na prikazanom ekranu pomerenog tiketa u interfejsu operatera.',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' =>
            'Definiše sledeći status tiketa nakon što je pomeren u drugi red u prikazu ekrana pomerenog tiketa interfejsa operatera.',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' =>
            'Prikazuje opcije prioriteta tiketa na ekranu pomeranja tiketa u interfejsu operatera.',
        'Allows to save current work as draft in the ticket move screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu pomeranja tiketa u interfejsu operatera.',
        'Required permissions to use the ticket bounce screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana preusmerenja tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu za preusmerenje tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u prikazu ekrana za povraćaj tiketa u interfejsu operatera.',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' =>
            'Definiše sledeći status tiketa nakon vraćanja, u prikazu ekrana za povraćaj tiketa interfejsa operatera.',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' =>
            'Određuje podrazumevanu napomenu povratnog tiketa za  klijenta/pošiljaoca na prikazu ekrana za povraćaj tiketa u interfejsu operatera.',
        'Required permissions to use the ticket compose screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana slanja odgovora tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu slanja odgovora tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa ukoliko je sastavljeno / odgovoreno u prikazu ekrana za otvaranje tiketa u interfejsu operatera.',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' =>
            'Definiše sledeće moguće statuse nakon otvaranja / odgovaranja tiketa u prikazu ekrana za otvaranje tiketa interfejsa operatera.',
        'Defines if the message in the ticket compose screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu slanja odgovora tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Allows to save current work as draft in the ticket compose screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu za pisanje odgovora tiketa u interfejsu operatera.',
        'Defines the format of responses in the ticket compose screen of the agent interface ([% Data.OrigFrom | html %] is From 1:1, [% Data.OrigFromName | html %] is only realname of From).' =>
            'Definiše format odgovora u prikazu ekrana za kreiranje tiketa interfejsa operatera ([% Data.OrigFrom | html %]  je Od u originalnom obliku, [% Data.OrigFromName | html %] je samo pravo ime iz Od).',
        'Defines the used character for plaintext email quotes in the ticket compose screen of the agent interface. If this is empty or inactive, original emails will not be quoted but appended to the response.' =>
            'Definiše korišćene karaktere za plaintext imejl navode u prikazu ekrana otvorenog tiketa interfejsa operatera. Ukoliko je ovo prazno ili neaktivno, originalni imejlovi neće biti navedeni, nego dodati odgovoru.',
        'Defines the maximum number of quoted lines to be added to responses.' =>
            'Definiše maksimalni broj citiranih linija za dodavanje u odgovore.',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface. The customers email address won\'t be added if the article type is email-internal.' =>
            'Dodavanje imejl adresa klijenata, primaocima u tiketu na prikazu ekrana za otvaranje tiketa u interfejsu operatera. Imejl adrese klijenata neće biti dodate, ukoliko je tip artikla imejl-interni.',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' =>
            'Zamenjuje originalnog pošiljaoca sa imejl adresom aktuelnog klijenta pri kreiranju odgovora u prozoru za pisanje odgovora interfejsa operatera.',
        'Required permissions to use the ticket forward screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana prosleđivanja tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu prosleđivanja tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle dodavanja napomene u prikazu ekrana za prosleđivanje tiketa u interfejsu operatera.',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' =>
            'Definiše sledeće moguće statuse nakon prosleđivanja tiketa u prikazu ekrana za prosleđivanje tiketa interfejsa operatera.',
        'Defines if the message in the ticket forward screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu prosleđivanja tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Allows to save current work as draft in the ticket forward screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu prosleđivanja tiketa u interfejsu operatera.',
        'Required permissions to use the email outbound screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana odlaznih imejlova u interfejsu operatera.',
        'Defines if a ticket lock is required in the email outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Definiše da li je potrebno zaključati tiket u ekranu odlaznih imejlova tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Defines the default next state of a ticket after the message has been sent, in the email outbound screen of the agent interface.' =>
            'Definiše podrazumevani sledeći status tiketa posle slanja poruke, na ekranu odlaznih imejlova u interfejsu operatera.',
        'Defines the next possible states after sending a message in the email outbound screen of the agent interface.' =>
            'Definiše sledeće moguće statuse nakon slanja poruke u prikazu ekrana odlaznih imejlova interfejsa operatera.',
        'Defines if the message in the email outbound screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu odlaznog imejla tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Required permissions to use the email resend screen in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana za ponovno slanje imejlova u interfejsu operatera.',
        'Defines if a ticket lock is required in the email resend screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Definiše da li je potrebno zaključati tiket u ekranu ponovnog slanja imejlova u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Defines if the message in the email resend screen of the agent interface is visible for the customer by default.' =>
            'Definiše da li je poruka u ekranu ponovnog slanja imejla tiketa u interfejsu operatera podrazumevano vidljiva za klijenta.',
        'Allows to save current work as draft in the email outbound screen of the agent interface.' =>
            'Dozvoljava čuvanje trenutne forme kao nacrta u ekranu odlaznih imejlova tiketa u interfejsu operatera.',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' =>
            'Neophodne dozvole za upotrebu ekrana spajanja tiketa u detaljnom pregledu tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu spajanja tiketa u detaljnom pregledu tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'Required permissions to change the customer of a ticket in the agent interface.' =>
            'Neophodne dozvole za promenu klijenta tiketa u interfejsu operatera.',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' =>
            'Određuje da li je potrebno zaključati tiket u ekranu promene klijenta tiketa u interfejsu operatera (ako tiket još uvek nije zaključan, tiket će biti zaključan i trenutni operater će biti automatski postavljen kao vlasnik).',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' =>
            'Kada su tiketi spojeni, klijent može biti informisan imejlom postavljanjem polja za potvrdu "Obavesti pošiljaoca". U prostoru za tekst, možete definisati unapred formatirani tekst koji kasnije biti modifikovan od strane operatera.',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. Here you can define the subject of this note (this subject cannot be changed by the agent).' =>
            'Kada su tiketi spojeni, napomena će biti automatski dodata tiketu koji nije više aktivan. Ovde možete definisati predmet ove napomene (ovaj predmet se ne može promeniti od strane operatera).',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. Here you can define the body of this note (this text cannot be changed by the agent).' =>
            'Kada su tiketi spojeni, napomena će biti automatski dodata tiketu koji nije više aktivan. Ovde možete definisati telo ove napomene (ovaj tekst se ne može promeniti od strane operatera).',
        'Defines the default viewable sender types of a ticket (default: customer).' =>
            'Određuje podrazumevani tip vidljivog pošiljaoca tiketa (podrazmevano: klijent).',
        'Defines the viewable locks of a ticket. NOTE: When you change this setting, make sure to delete the cache in order to use the new value. Default: unlock, tmp_lock.' =>
            'Definiše',
        'Defines the valid state types for a ticket. If a ticket is in a state which have any state type from this setting, this ticket will be considered as open, otherwise as closed.' =>
            'Definiše ispravne tipove stanja tiketa. Ako je tiket u stanju koji sadrži bilo koji tip stanja iz ovog podešavanja, ovaj tiket će se smatrati otvorenim, u suprotnom kao zatvoren.',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.Console.pl Maint::Ticket::UnlockTimeout" can be used.' =>
            'Određuje važeće statuse za otključane tikete. Za otključavanje tiketa može se koristiti skript "bin/otrs.Console.pl Maint::Ticket::UnlockTimeout".',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' =>
            'Šalje obaveštenje za potsećanje o otključanom tiketu kad se dostigne datum podsetnika (šalje samo vlasniku tiketa).',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be enabled).' =>
            'Onemogućuje slanje obaveštenja podsetnika odgovornom operateru tiketa (Ticket::Responsible mora biti uključeno).',
        'Defines the state type of the reminder for pending tickets.' => 'Definiše dip statusa podsetnika za tikete na čekanju.',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' =>
            'Određuje mogući status za tikete na čekanju koji menjaju status nakon dostizanja vremenskog limita.',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' =>
            'Definiše koji statusi treba da budu automatski podešeni (Sadržaj), nakon dostizanja vremena čekanja statusa (Ključ).',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=[% Data.CustomerID %]\' or \'\').' =>
            'Određuje spoljašnju vezu za bazu podataka klijenta (npr. \'http://yourhost/customer.php?CID=[% Data.CustomerID %]\' ili \'\').',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' =>
            'Određuje ciljni atribut u vezi sa eksternom bazom podataka klijenta. Npr. \'target="cdb"\'.',
        'Defines the target attribute in the link to external customer database. E.g. \'AsPopup PopupType_TicketAction\'.' =>
            'Određuje ciljni atribut u vezi sa eksternom bazom podataka klijenta. Npr. \'AsPopup PopupType_TicketAction\'.',
        'Toolbar Item for a shortcut. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Stavka alatne linije za prečicu. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Agent interface notification module to see the number of tickets an agent is responsible for. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Modul interfejsa operatera za prikaz broja tiketa za koje je operater odgovoran. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Agent interface notification module to see the number of watched tickets. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Modul interfejsa operatera za prikaz broja praćenih tiketa. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Agent interface notification module to see the number of locked tickets. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Modul interfejsa operatera za prikaz broja zaključanih tiketa. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Agent interface notification module to see the number of tickets in My Services. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Modul interfejsa operatera za prikaz broja tiketa u Mojim uslugama. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Agent interface module to access search profiles via nav bar. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Modul interfejsa operatera za pristup profilima pretraživanja preko linije za navigaciju. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Agent interface module to access fulltext search via nav bar. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Modul interfejsa operatera za pristup tekstualnoj pretrazi preko linije za navigaciju. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Agent interface module to access CIC search via nav bar. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Modul interfejsa operatera za pristup CIC pretrazi preko linije za navigaciju. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' =>
            'Modul za generisanje HTML OpenSearch profila za kratku pretragu tiketa u profilu operatera.',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' =>
            'Modul za prikaz obaveštenja i eskalacija (ShownMax: najveći prikazan broj eksalacija, EscalationInMinutes: prikaz tiketa koji će eskalirati, CacheTime: keš izračunatih eskalacija u sekundama).',
        'Customer item (icon) which shows the open tickets of this customer as info block. Setting CustomerUserLogin to 1 searches for tickets based on login name rather than CustomerID.' =>
            'Klijent ikonica koja pokazuje otvorene tikete ovog klijenta kao info blok. Podešavanje CustomerUserLogin na 1 pretražuje tikete na osnovu korisničkog naziva umesto CustomerID.',
        'Customer item (icon) which shows the closed tickets of this customer as info block. Setting CustomerUserLogin to 1 searches for tickets based on login name rather than CustomerID.' =>
            'Klijent ikonica koja pokazuje zatvorene tikete ovog klijenta kao info blok. Podešavanje CustomerUserLogin na 1 pretražuje tikete na osnovu korisničkog naziva umesto CustomerID.',
        'Agent interface article notification module to check PGP.' => 'Modul interfejsa operatera za obaveštavanja o članku za proveru PGP.',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' =>
            'Modul interfejsa operatera za proveru dolaznih poruka u detaljnom pregledu tiketa ako S/MIME-ključ postoji i dostupan je.',
        'Agent interface article notification module to check S/MIME.' =>
            'Modul interfejsa operatera za obaveštavanja o članku, provera S/MIME',
        'Module to define the email security options to use (PGP or S/MIME).' =>
            'Modul za izbor imejl bezbednosti u upotrebi (PGP ili S/MIME).',
        'Module to compose signed messages (PGP or S/MIME).' => 'Modul za izradu potpisane poruke (PGP ili S/MIME).',
        'Module to encrypt composed messages (PGP or S/MIME).' => 'Modul za šifrovanje poruka za slanje (PGP or S/MIME).',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' =>
            'U meniju prikazuje vezu za preuzimanje priloga članka u detaljnom pregledu članka u interfejsu operatera',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' =>
            'U meniju prikazuje vezu za pristup prilozima članka preko html pregleda u detaljnom pregledu članka u interfejsu operatera.',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za povratak u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za zaključavanje/otključavanje tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za pristup istorijatu tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za štampu tiketa ili članka u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za kontrolu prioriteta tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za dodavanje polja slobodnog teksta u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.  Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju koja omogućava povezivanje tiketa sa drugim objektom u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to change the owner of a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za promenu vlasnika tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to change the responsible agent of a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za promenu odgovornog tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to change the customer who requested the ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za promenu klijenta na koga se vodi tiket u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za dodavanje napomene u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to add a phone call outbound in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za dodavanje odlaznog poziva tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to add a phone call inbound in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za dodavanje dolaznog poziva tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to send an outbound email in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za slanje odlazne imejl poruke u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju koja omogućava spajanje tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za postavljanje tiketa u čekanje u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za prijavu / odjavu na tiket u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za zatvaranje tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za brisanje tiketa u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows a link to set a ticket as junk in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2". To cluster menu items use for Key "ClusterName" and for the Content any name you want to see in the UI. Use "ClusterPriority" to configure the order of a certain cluster within the toolbar.' =>
            'Prikazuje vezu u meniju za označavanje tiketa kao besmislenog „junk” u detaljnom pregledu u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2". Za združivanje veza u meniju podesite ključ "ClusterName" sa sadržajem koji će biti naziv koji želite da vidite u interfejsu. Koristite ključ "ClusterPriority" za izmenu redosleda grupa u meniju.',
        'Shows link to external page in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Prikazuje vezu na eksternu stranu u detaljnom pregledu tiketa u interfejsu operatera. DOdatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'This setting shows the sorting attributes in all overview screen, not only in queue view.' =>
            'Ovo podešavanje prikazuje atribute sortiranja u svim ekranima pregleda, ne samo u prikazu redova.',
        'Defines from which ticket attributes the agent can select the result order.' =>
            'Definiše iz kog atributa tiketa operater može da izabere redosled rezultata.',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' =>
            'U meniju prikazuje vezu za zaključavanje / otključavanje tiketa u preglede tiketa u interfejsu operatera.',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' =>
            'U meniju prikazuje vezu za detaljni prikaz tiketa u preglede tiketa u interfejsu operatera.',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' =>
            'U meniju prikazuje vezu za gledanje istorijata tiketa u svaki pregled tiketa u interfejsu operatera.',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' =>
            'U meniju prikazuje vezu za podešavanje prioriteta tiketa u svaki pregled tiketa u interfejsu operatera.',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' =>
            'U meniju prikazuje vezu za dodavanje napomene na tiket u svaki pregled tiketa u interfejsu operatera.',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' =>
            'U meniju prikazuje vezu za zatvaranje tiketa u svaki pregled tiketa u interfejsu operatera.',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' =>
            'U meniju prikazuje vezu za pomeranje tiketa u svaki pregled tiketa u interfejsu operatera.',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Prikazuje vezu u meniju za brisanje tiketa u svim pregledima u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Shows a link in the menu to set a ticket as junk in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            'Prikazuje vezu u meniju za označavanje tiketa kao besmislenog junk u svim pregledima u interfejsu operatera. Dodatna kontrola prikaza ove veze može se postići korišćenjem ključa "Group" sa sadržajem "rw:group1;move_into:group2".',
        'Module to grant access to the owner of a ticket.' => 'Modul za dodelu pristupa tiketu za vlasnika.',
        'Optional queue limitation for the OwnerCheck permission module. If set, permission is only granted for tickets in the specified queues.' =>
            'Opciono ograničenje pristupa redovima za OwnerCheck modul permisija. Ukoliko je podešeno, pristup će biti dozvoljen samo za tikete u definisanim redovima.',
        'Module to grant access to the agent responsible of a ticket.' =>
            'Modul za dodelu pristupa tiketu za odgovornog operatera.',
        'Optional queue limitation for the ResponsibleCheck permission module. If set, permission is only granted for tickets in the specified queues.' =>
            'Opciono ograničenje pristupa redovima za ResponsibleCheck modul permisija. Ukoliko je podešeno, pristup će biti dozvoljen samo za tikete u definisanim redovima.',
        'Module to check the group permissions for the access to tickets.' =>
            'Modul za proveru grupnih dozvola za pristup tiketima.',
        'Module to grant access to the watcher agents of a ticket.' => 'Modul za dodelu pristupa tiketu za nadzornog operatera.',
        'Module to grant access to the creator of a ticket.' => 'Modul za dodelu pristupa tiketu za kreatora tiketa.',
        'Optional queue limitation for the CreatorCheck permission module. If set, permission is only granted for tickets in the specified queues.' =>
            'Opciono ograničenje pristupa redovima za CreatorCheck modul permisija. Ukoliko je podešeno, pristup će biti dozvoljen samo za tikete u definisanim redovima.',
        'Module to grant access to any agent that has been involved in a ticket in the past (based on ticket history entries).' =>
            'Modul za dodelu pristupa bilo kom operateru angažovanom na tiketu u prošlosti (bazirano na stavkama istorijata tiketa).',
        'Optional queue limitation for the InvolvedCheck permission module. If set, permission is only granted for tickets in the specified queues.' =>
            'Opciono ograničenje pristupa redovima za InvolvedCheck modul permisija. Ukoliko je podešeno, pristup će biti dozvoljen samo za tikete u definisanim redovima.',
        'Module to check the group permissions for customer access to tickets.' =>
            'Modul za proveru grupnih dozvola za klijentski pristup tiketima.',
        'Module to grant access if the CustomerUserID of the ticket matches the CustomerUserID of the customer.' =>
            'Modul za dodelu pristupa ako se ID klijenta korisnika tiketa poklapa sa ID klijent korisnika.',
        'Module to grant access if the CustomerID of the ticket matches the CustomerID of the customer.' =>
            'Modul za dodelu pristupa ako se ID klijenta tiketa poklapa sa ID klijenta.',
        'Module to grant access if the CustomerID of the customer has necessary group permissions.' =>
            'Modul za dodelu pristupa ukoliko ID klijenta poseduje odgovarajuće grupne dozvole.',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' =>
            'Definiše kako polje Od u imejl porukama (poslato iz odgovora i imejl tiketa) treba da izgleda.',
        'Defines the separator between the agents real name and the given queue email address.' =>
            'Određuje separator između pravog imena operatera i email adrese dodeljene redu.',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste tiketa na čekanju kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste eskaliranih tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste novih tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the open tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste otvorenih tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Parametri za dodatak statistika tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'MyLastChangedTickets dashboard widget.' => '',
        'Parameters for the dashboard backend of the upcoming events widget of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Parametri za dodatak predstojećih događaja u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Parameters for the dashboard backend of the queue overview widget of the agent interface. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "QueuePermissionGroup" is not mandatory, queues are only listed if they belong to this permission group if you enable it. "States" is a list of states, the key is the sort order of the state in the widget. "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Parametri za dodatak liste redova kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "QueuePermissionGroup" nije neophodan, ako ga definišete redovi će biti izlistani samo ako pripadaju ovoj grupi dozvola. "States" je lista stanja, ključ je redosled sortiranja stanja u dodatku. "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Parameters for the dashboard backend of the ticket events calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. "Mandatory" determines if the plugin is always shown and can not be removed by agents.' =>
            'Parametri za dodatak kalendara događaja tiketa u kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. "Mandatory" određuje da li je dodatak uvek prikazan i ne može biti isključen od strane operatera.',
        'Defines the calendar width in percent. Default is 95%.' => 'Definiše širinu kalendara u procentima. Podrazumevano je 95%.',
        'Defines queues that\'s tickets are used for displaying as calendar events.' =>
            'Definiše redove koje koriste tiketi za prikazivanje u vidu kalendarskih događaja.',
        'Define dynamic field name for start time. This field has to be manually added to the system as Ticket: "Date / Time" and must be activated in ticket creation screens and/or in any other ticket action screens.' =>
            'Definiše naziv dinamičkog polja za početno vreme. Ovo polje mora biti manuelno dodato sistemu kao tiket: "Datum / Vreme" i mora biti aktivirano u ekranima za kreiranje tiketa i/ili u bilo kom drugom ekranu sa tiket akcijama.',
        'Define dynamic field name for end time. This field has to be manually added to the system as Ticket: "Date / Time" and must be activated in ticket creation screens and/or in any other ticket action screens.' =>
            'Definiše naziv dinamičkog polja za krajnje vreme. Ovo polje mora biti manuelno dodato sistemu kao tiket: "Datum / Vreme" i mora biti aktivirano u ekranima za kreiranje tiketa i/ili u bilo kom drugom ekranu sa tiket akcijama.',
        'Defines the dynamic fields that are used for displaying on calendar events.' =>
            'Definiše dinamička polja koja se koriste za prikazivanje na kalendaru događaja.',
        'Defines the ticket fields that are going to be displayed calendar events. The "Key" defines the field or ticket attribute and the "Content" defines the display name.' =>
            'Definiše polja tiketa koja će biti prikazana u kalendaru događaja. "Ključ" definiše polje ili atribut tiketa, a "Sadržaj" definiše prikazan naziv.',
        'Defines if the values for filters should be retrieved from all available tickets. If enabled, only values which are actually used in any ticket will be available for filtering. Please note: The list of customers will always be retrieved like this.' =>
            'Definiše da li će vrednosti filtera biti pribavljene od svih dostupnih tiketa. Ukoliko je uključeno, samo vrednosti koje se inače koriste u bilo kom tiketu će biti dostupne kao filter. Napominjemo da će lista korisnika uvek biti prikazana na ovaj način.',
        'Parameters for the dashboard backend of the customer user list overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' =>
            'Parametri za dodatak liste klijent korisnika kontrolne table u interfejsu operatera. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je podrazumevano aktiviran ili da je potrebno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keš dodatka.',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste tiketa na čekanju kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste eskaliranih tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste novih tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the open tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste otvorenih tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the customer id status widget of the agent interface . "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' =>
            'Parametri za dodatak statusa ID klijenta kontrolne table u interfejsu operatera. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je podrazumevano aktiviran ili da je potrebno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keš dodatka.',
        'Parameters for the dashboard backend of the customer id list overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' =>
            'Parametri za dodatak liste klijenata kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka.',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste tiketa na čekanju kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Parametri za dodatak liste eskaliranih tiketa kontrolne table u interfejsu operatera. "Limit" definiše podrazumevani broj prikazanih stavki. "Group" se koristi da ograniči pristup dodatku (npr. Group: admin;group1;group2;). "Default" određuje da li je dodatak podrazumevano aktiviran ili da je neophodno da ga korisnik manuelno aktivira. "CacheTTLLocal" je vreme u minutima za keširanje dodatka. Napomena: za DefaultColumns su dozvoljeni samo atributi tiketa i dinamička polja (DynamicField_NameX).',
        'Parameters for the CustomQueue object in the preference view of the agent interface. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri za CustomQueue objekat u prikazu podešavanja u interfejsu operatera. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Parameters for the CustomService object in the preference view of the agent interface. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri za CustomService objekat u prikazu podešavanja u interfejsu operatera. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Parameters for the RefreshTime object in the preference view of the agent interface. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri za RefreshTime objekat u prikazu podešavanja u interfejsu operatera. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri stranica (na kojima su tiketi vidljivi) umanjenog pregleda tiketa. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana. ',
        'Parameters for the column filters of the small ticket overview. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri za filter kolona u umanjenom pregledu tiketa. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana. ',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri stranica (na kojima su tiketi vidljivi) srednjeg pregleda tiketa. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana. ',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri stranica (na kojima su tiketi vidljivi) pregleda tiketa. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana. ',
        'Parameters for the CreateNextMask object in the preference view of the agent interface. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri za CreateNextMask objekat u prikazu podešavanja u interfejsu operatera. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Parameters of the example queue attribute Comment2.' => 'Parametri za primer atributa red komentara 2.',
        'Parameters of the example service attribute Comment2.' => 'Parametri za primer atributa servis komentara 2.',
        'Parameters of the example SLA attribute Comment2.' => 'Parametri za primer atributa SLA komentara 2.',
        'Sends customer notifications just to the mapped customer.' => 'Šalje klijentska obaveštenja samo mapiranom klijentu.',
        'Specifies if an agent should receive email notification of his own actions.' =>
            'Definiše da li operater treba da dobije imejl obaveštenje za svoje akcije.',
        'Determines the next screen after new customer ticket in the customer interface.' =>
            'Određuje sledeći prikaz ekrana, nakon tiketa novog klijenta u interfejsu klijenta.',
        'Allows customers to set the ticket priority in the customer interface.' =>
            'Dozvoljava klijentima da podese prioritet tiketa u klijentskom interfejsu.',
        'Defines the default priority of new customer tickets in the customer interface.' =>
            'Određuje podrazumevani prioritet za nove klijentske tikete u interfejsu klijenta.',
        'Allows customers to set the ticket queue in the customer interface. If this is not enabled, QueueDefault should be configured.' =>
            'Dozvoljava klijentima da podese red tiketa u korisničkom interfejsu. Ako je isključeno, onda treba podesiti QueueDefault.',
        'Defines the default queue for new customer tickets in the customer interface.' =>
            'Određuje podrazumevani red za nove klijentske tikete u interfejsu klijenta.',
        'Allows customers to set the ticket type in the customer interface. If this is not enabled, TicketTypeDefault should be configured.' =>
            'Dozvoljava klijentima da podese tip tiketa u interfejsu korisnika. Ukoliko je isključeno, treba konfigurisati TicketTypeDefault.',
        'Defines the default ticket type for new customer tickets in the customer interface.' =>
            'Određuje podrazumevani tip tiketa za tikete novog klijenta u interfejsu klijenta.',
        'Allows customers to set the ticket service in the customer interface.' =>
            'Dozvoljava klijentima da podese uslugu za tiket u korisničkom interfejsu.',
        'Allows customers to set the ticket SLA in the customer interface.' =>
            'Dozvoljava klijentima da podese SLA za tiket u klijentskom interfejsu.',
        'Sets if service must be selected by the customer.' => 'Podešava da li usluga mora biti izabrana od strane klijenta.',
        'Sets if SLA must be selected by the customer.' => 'Podešava ako SLA mora biti izabran od strane klijenta.',
        'Defines the default state of new customer tickets in the customer interface.' =>
            'Određuje podrazumevani status tiketa novog klijenta u interfejsu klijenta.',
        'Sender type for new tickets from the customer inteface.' => 'Tip pošiljaoca za nove tikete iz interfejsa klijenta.',
        'Defines the default history type in the customer interface.' => 'Određuje podrazumevani tip istorije u interfejsu klijenta.',
        'Comment for new history entries in the customer interface.' => 'Komentar za nove stavke istorije u klijentskom interfejsu.',
        'Defines the recipient target of the tickets ("Queue" shows all queues, "SystemAddress" shows only the queues which are assigned to system addresses) in the customer interface.' =>
            'Određuje ciljnog primaoca tiketa ("Red" prikazuje sve redove, "Sistemska adresa" prikazuje samo redove koji su dodeljeni sistemskim adresama) u interfejsu klijenta.',
        'Determines the strings that will be shown as recipient (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "&lt;Queue&gt;" shows the names of the queues, and for SystemAddress, "&lt;Realname&gt; &lt;&lt;Email&gt;&gt;" shows the name and email of the recipient.' =>
            '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' =>
            'Određuje koji će redovi biti važeći za tikete primaoca u interfejsu klijenta.',
        'Module for To-selection in new ticket screen in the customer interface.' =>
            'Modul za izbor primaoca (Za:) u prikazu novog tiketa u interfejsu klijenta.',
        'Determines the next screen after the follow-up screen of a zoomed ticket in the customer interface.' =>
            'Određuje sledeći ekrana, nakon narednog ekrana detaljnog prikaza tiketa u interfejsu klijenta.',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' =>
            'Određuje podrazumevani tip pošiljaoca za tikete na detaljnom prikazu ekrana tiketa u interfejsu klijenta.',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' =>
            'Određuje tip istorije za prikaz ekrana aktivnosti detaljnog prikaza tiketa, koji se koristi za istoriju tiketa u interfejsu klijenta.',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' =>
            'Određuje komentar istorije za prikaz ekrana aktivnosti tiketa detaljnog prikaza, koji se koristi za istoriju tiketa u interfejsu klijenta.',
        'Allows customers to change the ticket priority in the customer interface.' =>
            'Dozvoljava klijentima da promene prioritet tiketa u klijentskom interfejsu.',
        'Defines the default priority of follow-up customer tickets in the ticket zoom screen in the customer interface.' =>
            'Definiše podrazumevani prioritet tiketa klijenta za nastavljanje na ekranu detaljnog prikaza tiketa u interfejsu  klijenta.',
        'Allows choosing the next compose state for customer tickets in the customer interface.' =>
            'Dozvoljava izbor sledećeg stanja za klijentske tikete u klijentskom interfejsu.',
        'Defines the default next state for a ticket after customer follow-up in the customer interface.' =>
            'Definiše podrazumevani sledeći status tiketa nakon klijentovog nastavljanja tiketa u interfejsu klijenta.',
        'Defines the next possible states for customer tickets in the customer interface.' =>
            'Određuje sledeće moguće statuse za tikete klijenata u interfejsu klijenta.',
        'Shows the enabled ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' =>
            'Prikazuje atribute aktiviranih tiketa u interfejsu klijenta (0 = isključeno, 1 = uključeno).',
        'Shows all the articles of the ticket (expanded) in the customer zoom view.' =>
            'Prikazuje sve članke tiketa (detaljno) na detaljnom pregledu u interfejsu korisnika.',
        'Defines the displayed style of the From field in notes that are visible for customers. A default agent name can be defined in Ticket::Frontend::CustomerTicketZoom###DefaultAgentName setting.' =>
            'Definiše podrazumevan format From polja napomena koji su vidljivi klijentima. Podrazumevano ime operatera može biti definisano u putem Ticket::Frontend::CustomerTicketZoom###DefaultAgentName.',
        'Defines the default agent name in the ticket zoom view of the customer interface.' =>
            'Određuje podrazumevano ime operatera u detaljnom prikazu tiketa u interfejsu klijenta.',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' =>
            'Maksimalni broj tiketa koji će biti prikazani u rezultatu pretrage u interfejsu klijenta.',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' =>
            'Broj tiketa koji će biti prikazani na svakoj strani rezultata pretrage u interfejsu klijenta.',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' =>
            'Određuje podrazumevani atribut tiketa za sortiranje tiketa u pretrazi tiketa u interfejsu klijenta.',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' =>
            'Određuje podrazumevani redosled tiketa u pregledu pretrage rezultata u interfejsu klijenta. Gore: Najstariji na vrhu. Dole: Najnovije na vrhu.',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search e. g. ticket title with this kind of conditions like "(*key1*&amp;&amp;*key2*)" or "(*key1*||*key2*)".' =>
            '',
        'If enabled, the customer can search for tickets in all services (regardless what services are assigned to the customer).' =>
            'Ako je aktivirano, klijent može pretraživati tikete u svim servisima (bez obzira na to koji servisi su dodeljeni klijentu).',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' =>
            'Definiše sve parametre za ShownTickets objekat u postavkama interfejsu klijenta.',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' =>
            'Definiše sve parametre za RefreshTime objekat u postavkama u interfejsu klijenta.',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' =>
            'Definiše podrazumevani upotrebljeni modul korisničkog dela, ako akcioni parametar nije dat u url na inerfejsu operatera.',
        'Default queue ID used by the system in the agent interface.' => 'Podrazumevani ID reda koji koristi sistem u interfejsu operatera.',
        'Default ticket ID used by the system in the agent interface.' =>
            'Podrazumevani ID tiketa koji koristi sistem u interfejsu operatera.',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' =>
            'Određuje podrazumevani upotrebljeni modul korisničkog dela, ako akcioni parametar nije dat u url na inerfejsu klijenta.**',
        'Default ticket ID used by the system in the customer interface.' =>
            'Podrazumevani ID tiketa koji koristi sistem u klijentskom interfejsu.',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' =>
            'Modul za generisanje HTML OpenSearch profila za kratku pretragu tiketa u profilu klijenta.',
        'Determines the next screen after the ticket is moved. LastScreenOverview will return the last overview screen (e.g. search results, queueview, dashboard). TicketZoom will return to the TicketZoom.' =>
            'Određuje sledeći prikaz ekrana, nakon premeštanja tiketa. LastScreenOverview će vratiti poslednji pregled ekrana (npr. rezultati pretrage, pregled redova, kontrolna tabla). TicketZoom će vratiti na uvećanje tiketa.',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' =>
            'Određuje podrazumevani predmet za napomene dodate na prikazu ekrana pomeranja tiketa u interfejsu operatera.',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' =>
            'Postavlja podrazumevani sadržaj za napomene dodate na ekranu pomeranja tiketa u interfejsu operatera.',
        'Allows extended search conditions in ticket search of the generic agent interface. With this feature you can search e. g. ticket title with this kind of conditions like "(*key1*&amp;&amp;*key2*)" or "(*key1*||*key2*)".' =>
            '',
        'Set the limit of tickets that will be executed on a single genericagent job execution.' =>
            'Postavlja ograničenje koliko će tiketa biti izvršeno u jednom izvršavanju posla generičkog operatera.',
        'Allows generic agent to execute custom modules.' => 'Omogućava generičkom operateru da izvršava dodatne module.',
        'Unlock tickets whenever a note is added and the owner is out of office.' =>
            'Otključavanje tiketa kad god se doda napomena i vlasnik je van kancelarije.',
        'Include unknown customers in ticket filter.' => 'Uključite nepoznate klijente u filter tiketa.',
        'List of all ticket events to be displayed in the GUI.' => 'Lista svih događaja na tiketima za prikaz u grafičkom interfejsu.',
        'List of all article events to be displayed in the GUI.' => 'Lista svih događaja na člancima za prikaz u grafičkom interfejsu.',
        'List of all queue events to be displayed in the GUI.' => 'Lista svih događaja na redovima za prikaz u grafičkom interfejsu.',
        'Event module that performs an update statement on TicketIndex to rename the queue name there if needed and if StaticDB is actually used.' =>
            'Modul događaja koji izvršava ažuriranje na indeksu tiketa radi promene naziva reda ako je potrebno i ako je stvarno upotrebljena statička baza podataka.',
        'Ignores not ticket related attributes.' => '',
        'Transport selection for ticket notifications. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Izbor transporta za obaveštenja o tiketima. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana. ',
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' =>
            'ACL modul koji dozvoljava da nadređeni tiketi budu zatvoreni samo ako su već zatvoreni svi podređeni tiketi ("State" pokazuje koja stanja nisu dostupna za nadređeni tiket dok se ne zatvore svi podređeni tiketi).',
        'Default ACL values for ticket actions.' => 'Podrazumevane ACL vrednosti za akcije tiketa.',
        'Defines which items are available in first level of the ACL structure.' =>
            'Definiše koje su stavke slobodne u prvom nivou ACL strukture.',
        'Defines which items are available in second level of the ACL structure.' =>
            'Definiše koje su stavke slobodne u drugom nivou ACL strukture',
        'Defines which items are available for \'Action\' in third level of the ACL structure.' =>
            'Definiše koje su stavke slobodne za \'Action\' u trećem nivou ACL strukture.',
        'Cache time in seconds for the DB ACL backend.' => 'Vreme keširanja u sekundama za ACL modul baze podataka.',
        'If enabled debugging information for ACLs is logged.' => 'Ako je aktivirano, ispravljanje grešaka za ACL se beleži.',
        'Filter for debugging ACLs. Note: More ticket attributes can be added in the format &lt;OTRS_TICKET_Attribute&gt; e.g. &lt;OTRS_TICKET_Priority&gt;.' =>
            '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' =>
            'Maksimum automatskih imejl odgovora dnevno na sopstvenu adresu (Zaštita od petlje)',
        'Maximal auto email responses to own email-address a day, configurable by email address (Loop-Protection).' =>
            'Maksimalni broj automatskih imejl odgovora dnevno na sopstvenu adresu, podesiv po imejl adresi (zaštita od petlje).',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' =>
            'Maksimalna veličina u kilobajtima za imejlove koji mogu biti preuzeti preko POP3/POP3S/IMAP/IMAPS (KBytes).',
        'The maximum number of mails fetched at once before reconnecting to the server.' =>
            'Maksimalni broj imejlova preuzetih odjednom pre ponovne konekcije na server.',
        'Default loop protection module.' => 'Podrazumevani modul zaštite od petlje.',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' =>
            'Putanja do log datoteke (važi jedino ako je za LoopProtectionModule izabrano "FS" i postavljeno kao obavezno).',
        'Converts HTML mails into text messages.' => 'Konvertuje HTML poruke u tekstualne poruke.',
        'Specifies user id of the postmaster data base.' => 'Određuje ID korisnika „postmaster” baze podataka.',
        'Defines the postmaster default queue.' => 'Definiše podrazumevani red postmastera.',
        'Defines the default priority of new tickets.' => 'Određuje podrazumevani prioritet za nove tikete.',
        'Defines the default state of new tickets.' => 'Određuje podrazumevani status novih tiketa.',
        'Defines the state of a ticket if it gets a follow-up.' => 'Definiše stanje tiketa ukoliko dobije nastavak',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' =>
            'Definiše stanje tiketa ukoliko dobije nastavak, a tiket je već zatvoen.',
        'Defines the PostMaster header to be used on the filter for keeping the current state of the ticket.' =>
            'Definiše koje „PostMaster” zaglavlje će biti korišćeno u filteru za čuvanje trenutnog stanja tiketa.',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' =>
            'Šalje obaveštenje o nastavku samo operateru vlasniku, ako je tiket otključan (podrazumevano je da šalje svim operaterima).',
        'Defines the number of header fields in frontend modules for add and update postmaster filters. It can be up to 99 fields.' =>
            'Odeređuje broj polja zaglavlja u pristupnim modulima za dodavanje i ažuriranje glavnih imejl filtera. Može ih biti do 99.',
        'Indicates if a bounce e-mail should always be treated as normal follow-up.' =>
            'Određuje da li će preusmereni imejl uvek biti tretiran kao običan nastavak.',
        'Defines all the X-headers that should be scanned.' => 'Definiše sva H-zaglavlja koja treba skenirati.',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' =>
            'Modul za filtriranje i rukovanje dolaznim porukama. Blokiranje/ignorisanje svih nepoželjnih imejlova sa From: noreply@ adrese.',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From =&gt; \'(.+?)@.+?\', and use () as [***] in Set =&gt;.' =>
            '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' =>
            'Blokira sve dolazne email-ove koji nemaju ispravan broj tiketa u predmetu sa Od: @example.com adrese.',
        'Defines the sender for rejected emails.' => 'Definiše pošiljaoca odbijenih imejl poruka.',
        'Defines the subject for rejected emails.' => 'Definiše predmet za odbačene poruke.',
        'Defines the body text for rejected emails.' => 'Definiše sadržaj teksta za odbačene poruke.',
        'Module to use database filter storage.' => 'Modul za smeštaj filtera u bazu podataka.',
        'Module to check if arrived emails should be marked as internal (because of original forwarded internal email). IsVisibleForCustomer and SenderType define the values for the arrived email/article.' =>
            'Modul za proveru da li pristigli imejlovi treba da budu označeni kao interni (na osnovu originalnog prosleđenog internog imejla). „IsVisibleForCustomer” i „SenderType” definiišu vrednosti za pristigli imejl/članak.',
        'Recognize if a ticket is a follow-up to an existing ticket using an external ticket number. Note: the first capturing group from the \'NumberRegExp\' expression will be used as the ticket number value.' =>
            'Prepoznaje da li je tiket nastavak postojećeg tiketa korišćenjem eksternog broja tiketa. Napomena: prva RegEx grupa iz \'NumberRegExp\' izraza će biti iskorišćena kao vrednost broja tiketa.',
        'Module to filter encrypted bodies of incoming messages.' => 'Modul za filtriranje šifriranog sadržaja dolaznih poruka.',
        'Module to fetch customer users SMIME certificates of incoming messages.' =>
            'Modul za izvlačenje korisničkih SMIME sertifikata iz dolaznih poruka.',
        'Module to check if a incoming e-mail message is bounce.' => 'Modul za proveru da li je dolazna imejl poruka odbijena.',
        'Module used to detect if attachments are present.' => 'Modul za detekciju da li su prisutni prilozi.',
        'Executes follow-up checks on OTRS Header \'X-OTRS-Bounce\'.' => 'Izvršava provere nastavka na „OTRS” zaglavlju „X-OTRS-Bounce”.',
        'Checks if an E-Mail is a followup to an existing ticket by searching the subject for a valid ticket number.' =>
            'Proverava da li je imejl nastavljanje na postojeći tiket pretragom predmeta važećih brojeva tiketa.',
        'Executes follow-up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' =>
            'Izvršava provere za nastavak tiketa na „In-Reply-To” ili „References” zaglavljima imejla koji nemaju broj tiketa u predmetu.',
        'Executes follow-up checks on email body for mails that don\'t have a ticket number in the subject.' =>
            'Izvršava proveru nastavljanja u sadržaju imejla za poruke koje nemaju broj tiketa u predmetu.',
        'Executes follow-up checks on attachment contents for mails that don\'t have a ticket number in the subject.' =>
            'Izvršava proveru nastavljanja u sadržaju priloga za imejlove koji nemaju broj tiketa u predmetu.',
        'Executes follow-up checks on the raw source email for mails that don\'t have a ticket number in the subject.' =>
            'Izvršava proveru nastavljanja u sirovom izvoru imejla za imejlove koji nemaju broj tiketa u predmetu.',
        'Checks if an email is a follow-up to an existing ticket with external ticket number which can be found by ExternalTicketNumberRecognition filter module.' =>
            '',
        'Controls if CustomerID is automatically copied from the sender address for unknown customers.' =>
            'Kontroliše da li se ID klijenta automatski kopira iz adrese pošiljaoca za nepoznate korisnike.',
        'If this regex matches, no message will be send by the autoresponder.' =>
            'Ako se ovaj izraz poklapa, automatski odgovarač neće poslati nijednu poruku.',
        'If this option is enabled, tickets created via the web interface, via Customers or Agents, will receive an autoresponse if configured. If this option is not enabled, no autoresponses will be sent.' =>
            'Ukoliko je ova opcija uključena, tiketi kreirani preko veb interfejsa od strane klijenata ili operatera, će dobiti automatski odgovor ukoliko je podešen. Ako je ova opcija isključena, automatski odgovori neće biti slati.',
        'Links 2 tickets with a "Normal" type link.' => 'Povezuje 2 tiketa tipom veze "Normal".',
        'Links 2 tickets with a "ParentChild" type link.' => 'Povezuje 2 tiketa tipom veze "ParentChild".',
        'Defines, which tickets of which ticket state types should not be listed in linked ticket lists.' =>
            'Definiše, koji tiketi od kojih tipova statusa tiketa ne treba da budu prikazani u listi povezanih tiketa.',
        'For these state types the ticket numbers are striked through in the link table.' =>
            'Za ove tipove stanja brojevi tiketa će biti precrtani u tabeli veza.',
        'Module to generate ticket statistics.' => 'Modul za generisanje statistike tiketa.',
        'Determines if the statistics module may generate ticket lists.' =>
            'Određuje da li modul statistike može generisati liste tiketa.',
        'Module to generate accounted time ticket statistics.' => 'Modul za generisanje statistike obračunatog vremena tiketa.',
        'Module to generate ticket solution and response time statistics.' =>
            'Modul za generisanje statistike rešavanja tiketa i vremena odgovora.',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' =>
            'Podešava podrazumevanu visinu (u pikselima) neposrednih HTML članaka u AgentTicketZoom.',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' =>
            'Podešava maksimalnu visinu (u pikselima) neposrednih HTML članaka u AgentTicketZoom.',
        'The maximal number of articles expanded on a single page in AgentTicketZoom.' =>
            'Maksimalni broj članaka raširenih na jednoj strani na detaljnom prikazu tiketa u interfejsu operatera.',
        'The maximal number of articles shown on a single page in AgentTicketZoom.' =>
            'Maksimalni broj članaka za prikaz na jednoj strani na detaljnom prikazu tiketa u interfejsu operatera.',
        'Show article as rich text even if rich text writing is disabled.' =>
            'Prikaži članak kao obogaćeni tekst čak i kad je pisanje obogaćenog teksta deaktivirano.',
        'Parameters for the pages (in which the dynamic fields are shown) of the dynamic fields overview. Please note: setting \'Active\' to 0 will only prevent agents from editing settings of this group in their personal preferences, but will still allow administrators to edit the settings of another user\'s behalf. Use \'PreferenceGroup\' to control in which area these settings should be shown in the user interface.' =>
            'Parametri stranica (na kojima su dinamička polja vidljiva) pregleda dinamičkih polja. Napomena: podešavanje \'Active\' na 0 će samo onemogućiti operaterima da menjaju svoja lična podešavanja iz ove grupe, ali će administratori i dalje moći da ih menjaju u njihovo ime. Podesite \'PreferenceGroup\' da biste odredili u kom delu interfejsa ova podešavanja treba da budu prikazana.',
        'Dynamic fields shown in the ticket close screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu zatvaranja tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket compose screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu pisanja odgovora tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket email screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu imejl tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket free text screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu slobodnog teksta tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket forward screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu prosleđivanja tiketa u interfejsu operatera.',
        'Dynamic fields shown in the email outbound screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu odlaznih imejlova u interfejsu operatera.',
        'Dynamic fields shown in the ticket move screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu pomeranja tiketa u interfejsu operatera. ',
        'Dynamic fields shown in the ticket note screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu napomene tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket owner screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu vlasnika tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket pending screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu tiketa na čekanju u interfejsu operatera.',
        'Dynamic fields shown in the ticket phone screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu tiketa poziva u interfejsu operatera.',
        'Dynamic fields shown in the ticket phone inbound screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu dolaznih poziva tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket phone outbound screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu odlaznih poziva tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket priority screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu prioriteta tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket responsible screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu odgovornog tiketa u interfejsu operatera.',
        'Dynamic fields options shown in the ticket message screen of the customer interface. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###DynamicField.' =>
            'Opcije dinamičkih polja prikazanih u ekranu otvaranja tiketa u interfejsu klijenta. Napomena: ukoliko želite da prikažete ova polja i u detaljnom pregledu tiketa, morate ih uključiti u CustomerTicketZoom###DynamicField.',
        'Dynamic fields shown in the ticket small format overview screen of the agent interface.' =>
            'Dinamička polja prikazana u pregledu tiketa malog formata u interfejsu operatera.',
        'Dynamic fields shown in the ticket medium format overview screen of the agent interface.' =>
            'Dinamička polja prikazana u pregledu tiketa srednjeg formata u interfejsu operatera.',
        'Dynamic fields shown in the ticket preview format overview screen of the agent interface.' =>
            'Dinamička polja prikazana u pregledu tiketa formata prikaza u interfejsu operatera.',
        'Dynamic fields shown in the sidebar of the ticket zoom screen of the agent interface.' =>
            'Dinamička polja prikazana sa desne strane u detaljnom pregledu tiketa u interfejsu operatera.',
        'AgentTicketZoom widget that displays ticket data in the side bar.' =>
            'Dodatak za AgentTicketZoom ekran koji prikazuje informacije o tiketu sa desne strane.',
        'AgentTicketZoom widget that displays customer information for the ticket in the side bar.' =>
            'Dodatak za AgentTicketZoom ekran koji prikazuje informacije o klijentu tiketa sa desne strane.',
        'AgentTicketZoom widget that displays a table of objects linked to the ticket.' =>
            'Dodatak za AgentTicketZoom ekran koji prikazuje tabelu objekata povezanih sa tiketom.',
        'Dynamic fields shown in the ticket zoom screen of the customer interface.' =>
            'Dinamička polja prikazana u detaljnom pregledu tiketa u interfejsu klijenta.',
        'Dynamic fields options shown in the ticket reply section in the ticket zoom screen of the customer interface.' =>
            'Opcije dinamičkih polja prikazanih u odeljku odgovora tiketa u detaljnom pregledu tiketa u interfejsu klijenta.',
        'Dynamic fields shown in the ticket print screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu štampe tiketa u interfejsu operatera.',
        'Dynamic fields shown in the ticket print screen of the customer interface.' =>
            'Dinamička polja prikazana u ekranu štampe tiketa u interfejsu klijenta.',
        'Dynamic fields shown in the ticket search screen of the agent interface.' =>
            'Dinamička polja prikazana u ekranu pretrage tiketa u interfejsu operatera.',
        'Defines the default shown ticket search attribute for ticket search screen. Example: "Key" must have the name of the Dynamic Field in this case \'X\', "Content" must have the value of the Dynamic Field depending on the Dynamic Field type,  Text: \'a text\', Dropdown: \'1\', Date/Time: \'Search_DynamicField_XTimeSlotStartYear=1974; Search_DynamicField_XTimeSlotStartMonth=01; Search_DynamicField_XTimeSlotStartDay=26; Search_DynamicField_XTimeSlotStartHour=00; Search_DynamicField_XTimeSlotStartMinute=00; Search_DynamicField_XTimeSlotStartSecond=00; Search_DynamicField_XTimeSlotStopYear=2013; Search_DynamicField_XTimeSlotStopMonth=01; Search_DynamicField_XTimeSlotStopDay=26; Search_DynamicField_XTimeSlotStopHour=23; Search_DynamicField_XTimeSlotStopMinute=59; Search_DynamicField_XTimeSlotStopSecond=59;\' and or \'Search_DynamicField_XTimePointFormat=week; Search_DynamicField_XTimePointStart=Before; Search_DynamicField_XTimePointValue=7\';.' =>
            'Definiše podrazumevani prikaz pretrage atributa tiketa za prikaz ekrana pretrage tiketa. Primer: "Key" mora imati naziv dinamičkog polja, u ovom slučaju \'X\', "Content" mora imati vrednost dinamičkog polja u zavisnosti od tipa dinamičkog polja, Tekst: \'a text\', Padajući: \'1\', Datum/Vreme: \'Search_DynamicField_XTimeSlotStartYear=1974; Search_DynamicField_XTimeSlotStartMonth=01; Search_DynamicField_XTimeSlotStartDay=26; Search_DynamicField_XTimeSlotStartHour=00; Search_DynamicField_XTimeSlotStartMinute=00; Search_DynamicField_XTimeSlotStartSecond=00; Search_DynamicField_XTimeSlotStopYear=2013; Search_DynamicField_XTimeSlotStopMonth=01; Search_DynamicField_XTimeSlotStopDay=26; Search_DynamicField_XTimeSlotStopHour=23; Search_DynamicField_XTimeSlotStopMinute=59; Search_DynamicField_XTimeSlotStopSecond=59;\' i/ili \'Search_DynamicField_XTimePointFormat=week; Search_DynamicField_XTimePointStart=Before; Search_DynamicField_XTimePointValue=7\';.',
        'Dynamic Fields used to export the search result in CSV format.' =>
            'Dinamička polja korišćena za izvoz rezultata pretrage u CSV format.',
        'Dynamic fields shown in the ticket search screen of the customer interface.' =>
            'Dinamička polja prikazana u ekranu pretrage tiketa u interfejsu klijenta.',
        'Dynamic fields shown in the ticket search overview results screen of the customer interface.' =>
            'Dinamička polja prikazana u ekranu rezultata pretrage tiketa u interfejsu klijenta.',
        'Event module registration. For more performance you can define a trigger event (e. g. Event =&gt; TicketCreate). This is only possible if all Ticket dynamic fields need the same event.' =>
            '',
        'Configures a default TicketDynamicField setting. "Name" defines the dynamic field which should be used, "Value" is the data that will be set, and "Event" defines the trigger event. Please check the developer manual (https://doc.otrs.com/doc/), chapter "Ticket Event Module".' =>
            'Konfiguriše podrazumevanu vrednost TicketDynamicField podešavanja. "Name" definiše dinamičko polje koje bi se trebalo koristiti, "Value je vrednost koju treba podesiti i "Event" definiše modul događaja. Molimo proverite uputstvo za programere (https://doc.otrs.com/doc/), poglavlje "Ticket Event Module".',
        'Defines the list of types for templates.' => 'Definiše listu tipova šablona.',
        'List of default Standard Templates which are assigned automatically to new Queues upon creation.' =>
            'Lista podrazumevanih standardnih šablona koji se automatski dodeljiju novom Redu nakon kreiranja.',
        'General ticket data shown in the ticket overviews (fall-back). Note that TicketNumber can not be disabled, because it is necessary.' =>
            'Opšti podaci tiketa prikazani u pregledima tiketa (rezerva). Napominjemo da TicketNumber ne može biti isključen, jer je neophodan.',
        'Columns that can be filtered in the status view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane na prikazu statusa u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Columns that can be filtered in the queue view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane na prikazu reda u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Columns that can be filtered in the responsible view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane na prikazu odgovornosti u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Columns that can be filtered in the watch view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane na prikazu nadzora u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Columns that can be filtered in the locked view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane na prikazu zaključavanja u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Columns that can be filtered in the escalation view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane u prikazu eskalacija u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Columns that can be filtered in the ticket search result view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane na prikazu rezultata pretrage u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Columns that can be filtered in the service view of the agent interface. Note: Only Ticket attributes, Dynamic Fields (DynamicField_NameX) and Customer attributes (e.g. CustomerUserPhone, CustomerCompanyName, ...) are allowed.' =>
            'Kolone koje mogu biti filtrirane na prikazu servisa u interfejsu operatera. Napomena: dozvoljeni su samo tiket atributi, dinamička polja (DynamicField_NameX) i klijent atributi (npr. CustomerUserPhone, CustomerCompanyName).',
        'Frontend module registration (disable AgentTicketService link if Ticket Service feature is not used).' =>
            'Registracija modula pristupa (onemogućuje vezu AgentTicketService ako se ne koristi tiket servis).',
        'Default display type for recipient (To,Cc) names in AgentTicketZoom and CustomerTicketZoom.' =>
            'Podrazumevani tip prikaza za imena primaoca (To,Cc) na detaljnom prikazu tiketa u interfejsu operatara i klijenta.',
        'Default display type for sender (From) names in AgentTicketZoom and CustomerTicketZoom.' =>
            'Podrazumevani tip prikaza za imena (Od) pošiljaoca na detaljnom prikazu tiketa u interfejsu operatera i klijenta.',
        'Define which columns are shown in the linked tickets widget (LinkObject::ViewMode = "complex"). Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed for DefaultColumns.' =>
            'Definiše koje kolone će biti prikazane u dodatku povezanih tiketa (LinkObject::ViewMode = "složeno"). Napomena: samo atributi tiketa i dinamička polja (DynamicField_NameX) su dozvoljena za DefaultColumns.',
        'Whether or not to collect meta information from articles using filters configured in Ticket::Frontend::ZoomCollectMetaFilters.' =>
            'Definiše da li će biti prikupljane informacije iz članaka korišćenjem filtera definisanim u Ticket::Frontend::ZoomCollectMetaFilters.',
        'Defines a filter to collect CVE numbers from article texts in AgentTicketZoom. The results will be displayed in a meta box next to the article. Fill in URLPreview if you would like to see a preview when moving your mouse cursor above the link element. This could be the same URL as in URL, but also an alternate one. Please note that some websites deny being displayed within an iframe (e.g. Google) and thus won\'t work with the preview mode.' =>
            'Definiše filter za prikupljanje CVE brojeva iz teksta članka u AgentTicketZoom. Rezultati će biti prikazani u prozorčetu pored članka. Podesite URLPreview ukoliko želite da vidite prikaz strane prilikom prelaska kursorom preko elementa veze. Ova adresa može biti ista kao i za URL, ali i drugačija. Napominjemo da neke lokacije odbijaju da budu prikazane u IFRAME (npr. Gugl) i zato prikaz neće raditi.',
        'Sets the default link type of split tickets in the agent interface.' =>
            'Definiše podrazumevani tip veze za podeljene tikete u interfejsu operatera.',
        'Defines available article actions for Internal articles.' => 'Definiše omogućene akcije za interne članke.',
        'Defines available article actions for Phone articles.' => 'Definiše omogućene akcije za članke poziva.',
        'Defines available article actions for Email articles.' => 'Definiše omogućene akcije za članke imejlova.',
        'Defines available article actions for Chat articles.' => 'Definiše omogućene akcije za članke ćaskanja.',
        'Defines available article actions for invalid articles.' => 'Definiše omogućene akcije za nevažeće članke.',
        'Disables the redirection to the last screen overview / dashboard after a ticket is closed.' =>
            'Onemogućuje preusmeravanje na poslednji ekran pregleda / kontrolnu tablu pošto je tiket zatvoren.',
        'Defines the default queue for new tickets in the agent interface.' =>
            'Definiše podrazumevani red za nove tikete u interfejsu oeratera.',

        # XML Definition: Kernel/Config/Files/XML/Znuny.xml
        'Access package repositories via HTTP or HTTPS.' => '',
        'URL to the OTRS cloud service proxy service. The http or https prefix will be added, depending on SysConfig option \'PackageRepositoryURLSchema\'.' =>
            '',
        'Enables/disables the Znuny package verification. If disabled, all packages are shown as verified. It\'s still recommended to use only verified packages.' =>
            '',
        'Screens for which it is possible to enable or disable dynamic fields.' =>
            '',
        'Screens for which it is possible to enable or disable default columns.' =>
            '',
        'Mapping of Ticket::Generic invoker name (key) to list of fields (content) whose values will be base-64 encoded. Fields have to be given in the following form: Field1->Field2;Field3->Field4->Field5;Field6. So a nested data structure can be given by connecting the fields with \'->\'. Content of different fields can be given by separating those fields by \';\'.' =>
            '',
        'Mapping of Ticket::Generic invoker name (key) to list of fields (content) which will be removed from the request. Fields have to be given in the following form: Field1->Field2;Field3->Field4->Field5;Field6. So a nested data structure can be given by connecting the fields with \'->\'. Different fields can be omitted by separating them by \';\'.' =>
            '',
        'Maximum number of parallel instances when using OTRS_AsynchronousInvokerExecution in invoker Ticket::Generic.' =>
            '',
        'Enables support for huge XML data in load_xml calls of CPAN library XML::LibXML. This should only be enabled if absolutely needed. Disabling this option (default) protects against denial of service through entity expansion attacks. Before enabling this option ensure that alternative measures to protect the application against this type of attack have been taken.' =>
            '',
        'Shows a link in the menu to create a unit test for the current ticket.' =>
            '',
        'Shows a link in the menu to create and send a unit test for the current ticket.' =>
            '',
        'Dynamic field backend registration.' => '',
        'Frontend module for the agent interface that provides the AJAX interface for the web service dynamic field backends.' =>
            '',
        'Frontend module for the customer interface that provides the AJAX interface for the web service dynamic field backends.' =>
            '',
        'Ticket event module that stores values of the selected web service record into the configured additional dynamic fields.' =>
            '',
        'It might happen that a dynamic field of type WebserviceDropdown or WebserviceMultiselect will be set to a value fetched from a configured web service table but the web service record will not have a value set in the field that is configured as displayed value. Enable this setting to hide those dynamic fields in the ticket information widget of AgentTicketZoom so that they will not be shown as empty.' =>
            '',
        'Mapping for field values received from form. This setting is necessary for the correct identification of the form fields. Key means value type, value means possible representation in views.' =>
            '',
        'Mapping for field values received from form which have multiple values. This setting is needed when the view shows the values of a particular field in a custom way (e.g. selectable customer user in ticket creation view). This setting is always respected first. There is also the possibility to specify an order for checking fields. (Field of customer user in ticket creation view can be saved as CustomerUser or just simple e-mail. First we need to check if CustomerKey is present (CustomerKey -> ID of CustomerUser). If not, then simply take plain text (CustomerTicketText -> E-mail)).' =>
            '',
        'Options and default field set for attributes. Values of this setting will always be passed as simple form value without possibility to further configure it in AdminDynamicField view. The keys with which the form values will be sent to the invoker can be edited in the "Default" section of this setting.' =>
            '',
        'Options and default field set for selectable attributes. Values which will be passed to invoker (ID or Name or both) can be configured in AdminDynamicField view. The keys with which the form values (ID or Name) will be sent to the invoker can be edited in the "Default" section of this setting. Example usage for field Queue: Field with selected ID and Name will send QueueID = 3 and Queue = Raw.' =>
            '',
        'Template for the out-of-office message shown to the user in the frontend. Placeholders for out-of-office information can be used via ###PlaceholderName###. Possible placeholders are: StartYear, StartMonth, StartDay, EndYear, EndMonth, EndDay, DaysRemaining.' =>
            '',
        'Message that will be shown if the agent is currently logged in.' =>
            '',
        'Message that will be shown if the agent is currently logged out.' =>
            '',
        'Assignment between action and attributes.' => '',
        'Possible types for agent interface.' => '',
        'Possible types for customer interface.' => '',
        'Assignment between type and icon.' => '',
        'List of actions that will be ignored.' => '',
        'List of sub-actions that will be ignored.' => '',
        'Registers a user preferences module for LastViewsLimit.' => '',
        'Registers a user preferences module for LastViewsPosition.' => '',
        'Registers a user preferences module for LastViewsType.' => '',
        'Pre-application module to store the current view.' => '',
        'Domains accessed through WebUserAgent module for which no proxy should be used. Separate domains by semicolon.' =>
            '',
        'User agent string to use for the WebUserAgent module. Leave empty to use the default user agent string.' =>
            '',
        'Agent recipient information which will be passed to the web service.' =>
            '',
        'Customer recipient information which will be passed to the web service.' =>
            '',
        'Parameter name for additional recipients.' => '',
        'Shows only valid dynamic fields in screen configuration (AdminDynamicFieldScreenConfiguration) if enabled.' =>
            '',
        'Shows only valid dynamic fields in dynamic field export selection (AdminDynamicFieldConfigurationImportExport) if enabled.' =>
            '',
        'Config keys and their action to activate dynamic fields in different screens, grouped by object type.' =>
            '',
        'Dynamic field screen config keys and their action for all screens that don\'t allow dynamic fields to be mandatory.' =>
            '',
        'Frontend module registration for the admin interface.' => '',
        'The user\'s Mattermost username.' => '',
        'Loader module registration for the admin interface.' => '',
        'Adds ticket attribute relations based on CSV/Excel data.' => '',
        'Available/allowed actions for ticket attribute relations.' => '',
        'Always adds empty values to the ticket attribute relations so that it is not needed to add them to the CSV/Excel data.' =>
            '',
        'Triggers event \'TicketAllChildrenClosed\' if all child tickets of a parent ticket have been closed/merged/removed.' =>
            '',
        'Ticket event module which sends new ticket notifications even for tickets without articles.' =>
            '',
        'Name of the dynamic field in which the attachment file IDs of the transition will be stored.' =>
            '',
        'Keep dynamic field attachments after each transition.' => '',
        'Format string for output of attachments in the selection list. "%1$d": article number; "%2$s": filename; "%3$s": translated object type (e.g. Article => Artikel); "%4$s": translated attachment label (e.g. "Anhang").' =>
            '',
        'Sets the service in the ticket bulk screen in the agent interface (Ticket::Service needs to be enabled).' =>
            '',
        'Dynamic fields shown in the ticket bulk screen of the agent interface.' =>
            '',
        'This configuration defines if a dynamic field has to be checked in the agent ticket bulk view to get set for each ticket. This prevents unwanted overwrite of dynamic field values with their default or even empty values.' =>
            '',
        'Default format for export files.' => '',
        'Separator for exported CSV files.' => '',
        'Quoting character for exported CSV files.' => '',
        'Handles changes to data of modules which use the DBCRUD base module.' =>
            '',
        'Cache settings for DBCRUD modules (default: 1 day).' => '',
        'Displays notifications for missing and expired OAuth2 tokens.' =>
            '',
        'Authentication type for sendmail module. If \'OAuth2 token\' has been selected, SendmailModule::OAuth2TokenConfigName must also be configured.' =>
            '',
        'Name of the OAuth2 token configuration to use for sending mails if \'OAuth2 token\' was configured in SendmailModule::AuthenticationType.' =>
            '',
        'Hosts that need a separate info about authentication method and token (instead of both in one line). Most commonly needed for Office 365 and Outlook.' =>
            '',
        'This option enables a dropdown which will be displayed instead of the time unit input field.' =>
            '',
        'Defines the default ticket attribute for ticket sorting in the owner view of the agent interface.' =>
            '',
        'Defines the default ticket order in the owner view of the agent interface. Up: oldest on top. Down: latest on top.' =>
            '',
        'Columns that can be filtered in the owner view of the agent interface. Note: Only Ticket attributes and Dynamic Fields (DynamicField_NameX) are allowed.' =>
            '',
        'Agent interface notification module to see the number of tickets an agent is owner for. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' =>
            '',
        'Defines the next possible ticket states for calendar based tickets.' =>
            '',
        'Defines the default next state.' => '',
        'Defines the default ticket priority for calendar based tickets.' =>
            '',
        'Defines if the processes should be displayed in TreeView.' => '',
        'Enables calendar based ticket creation feature only for the listed groups.' =>
            '',
        'Defines the default ticket title for calendar based tickets.' =>
            '',
        'Defines the default ticket body for calendar based tickets.' => '',
        'Defines the default article channel name for calendar based tickets.' =>
            '',
        'Defines the default visibility of articles for calendar based tickets.' =>
            '',
        'Defines the default sender type for calendar based tickets.' => '',
        'Defines the default from for calendar based tickets.' => '',
        'Defines the default history type for calendar based tickets.' =>
            '',
        'Defines the default history comment for calendar based tickets.' =>
            '',
        'Defines the default content type for calendar based tickets.' =>
            '',
        'Threshold (in minutes) for catching up with ticket creation for appointments. Tickets for due appointments will only be created if their planned creation date is not older than the configured amount of minutes. This prevents creation of tickets for e. g. recurring appointments if the ticket creation will be executed some time later.' =>
            '',
        'Creates the calendar-based tickets regularly.' => '',
        'Cleans up the calendar-based tickets regularly.' => '',
        'Maximum number of quoted lines to be added to forwarded messages.' =>
            '',
        'Re-indexes S/MIME certificate folders. Note: S/MIME needs to be enabled in SysConfig.' =>
            '',
        'Maximum length of displayed attachment filenames in the article preview of ticket zoom view.' =>
            '',
        'General settings for autocompletion in rich text editor.' => '',
        'Rich text editor configuration for autocompletion module.' => '',
        'Rich text editor configuration for autocompletion module to support templates.' =>
            '',
        'Defines which notifications about mentions should be sent.' => '',
        'Defines if the toolbar mention icon should count mentions.' => '',
        'These groups won\'t be selectable to be mentioned.' => '',
        'Limits number of users (per article) that will be marked as mentioned and be notified. Users (and users from mentioned groups) that exceed this limit will silently be ignored.' =>
            '',
        'Frontend registration of triggers for mention plugin of CKEditor.' =>
            '',
        'Frontend registration of input/output templates for mention plugin of CKEditor.' =>
            '',
        'Event handler for mentions.' => '',
        'Parameters for the dashboard backend of the last mention widget.' =>
            '',
        'Agent interface notification module to show the number of mentions.' =>
            '',
        'Module to grant access to the mentioned agents of a ticket.' => '',
        'Mapping of non-standard time zones to official ones.' => '',
        'Start date (YYYYMMDD) of the range to use when parsing ICS files. The used CPAN module iCal::Parser needs this to be able to parse ICS files with events in a year before the current one. The end date of the range is automatically set to 10 years in the future from the time of parsing/execution.' =>
            '',
        'Define a mapping between variables of the customer company data (keys) and dynamic fields of a ticket (values). The purpose is to store customer company data in ticket dynamic fields. The dynamic fields must be present in the system and should be enabled for AgentTicketFreeText, so that they can be set/updated manually by the agent. They mustn\'t be enabled for AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer. If they were, they would have precedence over the automatically set values. To use this mapping, you have to also activate the Ticket::EventModulePost###4100-DynamicFieldFromCustomerCompany setting.' =>
            '',
        'This event module stores attributes from customer companies in ticket dynamic fields. Please see DynamicFieldFromCustomerCompany::Mapping setting for how to configure the mapping.' =>
            '',
        'Required permissions to use the NoteToLinkedTicket screen in the agent interface.' =>
            '',
        'Sets the state of the selected linked ticket in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Defines the default next state of a ticket after adding a note in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Activates the selection if a note in NoteToLinkedTicket screen should be created in this origin ticket.' =>
            '',
        'Defines the default value if a note in NoteToLinkedTicket screen should be created in this origin ticket.' =>
            '',
        'Sets the default subject for notes added in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Sets the default body text for notes added in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Allows adding notes in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Sets if a note in NoteToLinkedTicket screen must be filled in by the agent.' =>
            '',
        'Defines the history type for the NoteToLinkedTicket screen, which will be used for ticket history in the agent interface.' =>
            '',
        'Defines the history comment for the NoteToLinkedTicket screen, which will be used for ticket history in the agent interface.' =>
            '',
        'Defines if the note in the NoteToLinkedTicket screen of the agent interface is visible for the customer by default.' =>
            '',
        'Sets the ticket type in the NoteToLinkedTicket screen of the agent interface (Ticket::Type needs to be activated).' =>
            '',
        'Sets the service in the NoteToLinkedTicket screen of the agent interface (Ticket::Service needs to be activated).' =>
            '',
        'Sets the queue in the NoteToLinkedTicket screen of a zoomed ticket in the agent interface.' =>
            '',
        'Sets the ticket owner in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Sets the responsible agent of the ticket in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Sets the state of a ticket in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Defines the next state of a ticket after adding a note in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Shows the ticket priority options in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Defines the default ticket priority in the NoteToLinkedTicket screen of the agent interface.' =>
            '',
        'Shows the title field in the NoteToLinkedTicket screen of the agent interface.' =>
            '',

        # XML Definition: scripts/database/initial_insert.xml
        'invalid-temporarily' => 'nevažeći-privremeno',
        'Group for default access.' => 'Grupa za podrazumevan pristup.',
        'Group of all administrators.' => 'Grupa svih administratora.',
        'Group for statistics access.' => 'Grupa za pristup statistici.',
        'Group for time accounting web service access.' => '',
        'new' => 'novo',
        'All new state types (default: viewable).' => 'Svi novi tipovi stanja (podrazumevano: vidljivo).',
        'open' => 'otvoreni',
        'All open state types (default: viewable).' => 'Svi otvoreni tipovi stanja (podrazumevano: vidljivo).',
        'closed' => 'zatvoreni',
        'All closed state types (default: not viewable).' => 'Svi zatvoreni tipovi stanja (podrazumevano: vidljivo).',
        'pending reminder' => 'podsetnik čekanja',
        'All \'pending reminder\' state types (default: viewable).' => 'Svi tipovi stanja "podsetnik na čekanju" (podrazumevano: vidljivo).',
        'pending auto' => 'automatsko čekanje',
        'All \'pending auto *\' state types (default: viewable).' => 'Svi tipovi stanja "podsetnik automatski *" (podrazumevano: vidljivo).',
        'removed' => 'uklonjeni',
        'All \'removed\' state types (default: not viewable).' => 'Svi tipovi stanja "uklonjeno" (podrazumevano: vidljivo).',
        'merged' => 'spojeno',
        'State type for merged tickets (default: not viewable).' => 'Tip stanja za spojene tikete (podrazumevano: nije vidljivo).',
        'New ticket created by customer.' => 'Novi tiket koji je otvorio klijent.',
        'closed successful' => 'zatvoreno uspešno',
        'Ticket is closed successful.' => 'Tiket je zatvoren uspešno.',
        'closed unsuccessful' => 'zatvoreno neuspešno',
        'Ticket is closed unsuccessful.' => 'Tiket je zatvoren neuspešno.',
        'Open tickets.' => 'Otvoreni tiketi.',
        'Customer removed ticket.' => 'Klijent je uklonio tiket.',
        'Ticket is pending for agent reminder.' => 'Tiket je na čekanju za operaterski podsetnik.',
        'pending auto close+' => 'čekanje na automatsko zatvaranje+',
        'Ticket is pending for automatic close.' => 'Tiket je na čekanju za automatsko zatvaranje.',
        'pending auto close-' => 'čekanje na automatsko zatvaranje-',
        'State for merged tickets.' => 'Status za spojene tikete.',
        'system standard salutation (en)' => 'standardni sistemski pozdrav (en)',
        'Standard Salutation.' => 'Standardni Pozdrav',
        'system standard signature (en)' => 'standardni sistemski potpis (en)',
        'Standard Signature.' => 'Standardni potpis.',
        'Standard Address.' => 'Standardna adresa.',
        'possible' => 'moguće',
        'Follow-ups for closed tickets are possible. Ticket will be reopened.' =>
            'Nastavljanje na zatvorene tikete je moguće. Tiketi će biti ponovo otvoreni.',
        'reject' => 'odbaci',
        'Follow-ups for closed tickets are not possible. No new ticket will be created.' =>
            'Nastavljanje na zatvorene tikete nije moguće. Novi tiket neće biti kreiran.',
        'new ticket' => 'novi tiket',
        'Follow-ups for closed tickets are not possible. A new ticket will be created.' =>
            'Nastavljanje na zatvorene tikete nije moguće. Novi tiket će biti kreiran.',
        'Postmaster queue.' => 'Postmaster red.',
        'All default incoming tickets.' => ' Svi podrazumevani dolazni tiketi.',
        'All junk tickets.' => 'Svi besmisleni tiketi junk.',
        'All misc tickets.' => 'Svi drugi tiketi.',
        'auto reply' => 'automatski odgovor',
        'Automatic reply which will be sent out after a new ticket has been created.' =>
            'Automatski odgovor koji će biti poslat posle kreiranja novog tiketa.',
        'auto reject' => 'automatsko odbacivanje',
        'Automatic reject which will be sent out after a follow-up has been rejected (in case queue follow-up option is "reject").' =>
            'Automatska poruka koja će biti poslata nakon odbacivanja nastavka (u slučaju da je opcija nastavka za red postavljena na "odbaci").',
        'auto follow up' => 'automatsko praćenje',
        'Automatic confirmation which is sent out after a follow-up has been received for a ticket (in case queue follow-up option is "possible").' =>
            'Automatska potvrda koja će biti poslata nakon primanja nastavka u tiketu (u slučaju da je opcija nastavka za red postavljena na "moguće").',
        'auto reply/new ticket' => 'automatski odgovor/novi tiket',
        'Automatic response which will be sent out after a follow-up has been rejected and a new ticket has been created (in case queue follow-up option is "new ticket").' =>
            'Automatski odgovor koji će biti poslat nakon odbacivanja nastavka i kreiranja novog tiketa (u slučaju da je opcija nastavka za red postavljena na "novi tiket").',
        'auto remove' => 'automatsko uklanjanje',
        'Auto remove will be sent out after a customer removed the request.' =>
            'Automatsko uklanjanje će biti poslato kad klijent ukloni zahtev.',
        'default reply (after new ticket has been created)' => 'podrazumevani odgovor (posle kreiranja novog tiketa)',
        'default reject (after follow-up and rejected of a closed ticket)' =>
            'podrazumevano odbacivanje (posle nastavljanja i odbacivanja zatvorenog tiketa)',
        'default follow-up (after a ticket follow-up has been added)' => 'podrazumevano nastvljanje (posle dodavanja nastavljanja na tiket)',
        'default reject/new ticket created (after closed follow-up with new ticket creation)' =>
            'podrazumevano odbacivanje/kreiran novi tiket (posle zatvorenog nastavljanja sa kreiranjem novog tiketa)',
        'Unclassified' => 'Nerazvrstano',
        '1 very low' => '1 vrlo nizak',
        '2 low' => '2 nizak',
        '3 normal' => '3 normalan',
        '4 high' => '4 visok',
        '5 very high' => '5 vrlo visok',
        'unlock' => 'otključan',
        'lock' => 'zaključan',
        'tmp_lock' => 'tmp_lock',
        'agent' => 'operater',
        'system' => 'sistem',
        'customer' => 'klijent',
        'Ticket create notification' => 'Obaveštenje o kreiranju tiketa',
        'You will receive a notification each time a new ticket is created in one of your "My Queues" or "My Services".' =>
            'Dobićete obaveštenje svaki put kad se kreira novi tiket u jednom od vaših "Moji redovi" ili "Moji servisi".',
        'Ticket follow-up notification (unlocked)' => 'Obaveštenje o nastavljanju tiketa (otključano)',
        'You will receive a notification if a customer sends a follow-up to an unlocked ticket which is in your "My Queues" or "My Services".' =>
            'Dobićete obaveštenje kada korisnik pošalje nastavak u otključanom tiketu koji se nalazi u "Moji redovi" ili "Moje usluge".',
        'Ticket follow-up notification (locked)' => 'Obaveštenje o nastavljanju tiketa (zaključano)',
        'You will receive a notification if a customer sends a follow-up to a locked ticket of which you are the ticket owner or responsible.' =>
            'Dobićete obaveštenje kada korisnik pošalje nastavak u zaključanom tiketu čiji ste vlasnik ili odgovorni.',
        'Ticket lock timeout notification' => 'Obaveštenje o isticanju zaključavanja tiketa',
        'You will receive a notification as soon as a ticket owned by you is automatically unlocked.' =>
            'Dobićete obaveštenje odmah nakon automatskog otključavanja tiketa čiji ste vlasnik.',
        'Ticket owner update notification' => 'Obaveštenje o ažuriranju vlasnika tiketa',
        'Ticket responsible update notification' => 'Obaveštenje o ažuriranju odgovornog za tiket',
        'Ticket new note notification' => 'Obaveštenje o novoj napomeni tiketa',
        'Ticket queue update notification' => 'Obaveštenje o ažuriranju reda tiketa',
        'You will receive a notification if a ticket is moved into one of your "My Queues".' =>
            'Dobićete obaveštenje ako se tiket premesti u jedan od vaših "Moji redovi".',
        'Ticket pending reminder notification (locked)' => 'Obaveštenje - podsetnik tiketa na čekanju (zaključano)',
        'Ticket pending reminder notification (unlocked)' => 'Obaveštenje - podsetnik tiketa na čekanju (otključano)',
        'Ticket escalation notification' => 'Obaveštenje o eskalaciji tiketa',
        'Ticket escalation warning notification' => 'Obaveštenje o upozorenju na eskalaciju tiketa',
        'Ticket service update notification' => 'Obaveštenje o ažuriranju usluge tiketa',
        'You will receive a notification if a ticket\'s service is changed to one of your "My Services".' =>
            'Dobićete obaveštenje ako se servis tiketa promeni u jedan od vaših "Moji servisi".',
        'Appointment reminder notification' => 'Obaveštenje podsetnika o terminu',
        'You will receive a notification each time a reminder time is reached for one of your appointments.' =>
            'Dobićete obaveštenje svaki put kada dođe do vremena podsetnika za neki od vaših termina.',
        'Ticket email delivery failure notification' => 'Obaveštenje o neuspelom slanju imejla tiketa',
        'Mention notification' => '',

        # JS File: var/httpd/htdocs/js/Core.AJAX.js
        'Error during AJAX communication. Status: %s, Error: %s' => 'Greška prilikom AJAX komunikacije. Status: %s, greška %s',
        'This window must be called from compose window.' => 'Ovaj prozor mora biti pozvan od strane prozora za pisanje.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.ACL.js
        'Add all' => 'Dodaj sve',
        'An item with this name is already present.' => 'Već je prisutna tavka pod ovim imenom.',
        'This item still contains sub items. Are you sure you want to remove this item including its sub items?' =>
            'Ova stavka i dalje sadrži podstavke. Da li ste sigurni da želite da uklonite ovu stavku uključujući i njene podstavke?',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.AppointmentCalendar.Manage.js
        'More' => 'Više',
        'Less' => 'Manje',
        'Press Ctrl+C (Cmd+C) to copy to clipboard' => 'Pritisnite Ctrl+C (Cmd+C) za kopiranje',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.Attachment.js
        'Delete this Attachment' => 'Obriši ovaj prilog',
        'Deleting attachment...' => 'Brisanje priloga...',
        'There was an error deleting the attachment. Please check the logs for more information.' =>
            'Greška prilikom brisanja priloga. Molimo proverite log datoteku za više informacija.',
        'Attachment was deleted successfully.' => 'Prilog je uspešno obrisan.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.DynamicField.js
        'Do you really want to delete this dynamic field? ALL associated data will be LOST!' =>
            'Da li stvarno želite da obrišete ovo dinamičko polje? Svi povezani podaci će biti IZGUBLJENI!',
        'Delete field' => 'Obriši polje',
        'Deleting the field and its data. This may take a while...' => 'Brisanje polja i konfiguracije. Ovo može malo potrajati...',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericAgent.js
        'Remove this dynamic field' => 'Ukloni ovo dinamičko polje',
        'Remove selection' => 'Ukloni izbor',
        'Do you really want to delete this generic agent job?' => 'Da li stvarno želite da obrišete ovaj posao generičkog operatera?',
        'Delete this Event Trigger' => 'Obriši ovaj okidač događaja',
        'Duplicate event.' => 'Napravi duplikat događaja.',
        'This event is already attached to the job, Please use a different one.' =>
            'Ovaj događaj je priložen poslu. Molimo koristite neki drugi.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericInterfaceDebugger.js
        'An error occurred during communication.' => 'Došlo je do greške prilikom komunikacije.',
        'Request Details' => 'Detalji zahteva',
        'Request Details for Communication ID' => 'Detalji zahteva za ID komunikacije',
        'Show or hide the content.' => 'Pokaži ili sakrij sadržaj.',
        'Clear debug log' => 'Očisti otklanjanje grešaka u logu',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericInterfaceErrorHandling.js
        'Delete error handling module' => 'Obriši modul za obradu greške',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericInterfaceInvoker.js
        'It is not possible to add a new event trigger because the event is not set.' =>
            'Nije moguće dodati novi okidač događaja zato što događaj još uvek nije definisan.',
        'Delete this Invoker' => 'Obriši ovog pozivaoca',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericInterfaceInvokerEvent.js
        'Sorry, the only existing condition can\'t be removed.' => 'Žao nam je, poslednji uslov ne može biti uklonjen.',
        'Sorry, the only existing field can\'t be removed.' => 'Žao nam je, poslednje polje ne može biti uklonjeno.',
        'Delete conditions' => 'Obriši uslove',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericInterfaceMapping.js
        'Mapping for Key %s' => 'Mapiranje za ključ %s',
        'Mapping for Key' => 'Mapiranje za ključ',
        'Delete this Key Mapping' => 'Obriši mapiranje za ovaj ključ',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericInterfaceOperation.js
        'Delete this Operation' => 'Obriši ovu operaciju',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.GenericInterfaceWebservice.js
        'Clone web service' => 'Kloniraj veb servis',
        'Delete operation' => 'Obriši operaciju',
        'Delete invoker' => 'Obriši pozivaoca',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.Group.js
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' =>
            'UPOZORENJE: Ako promenite naziv grupe \'admin\' pre adekvatnog podešavanja u sistemskoj konfiguraciji, izgubićete pristup administrativnom panelu! Ukoliko se to desi, vratite naziv grupi u admin pomoću SQL komande.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.MailAccount.js
        'Delete this Mail Account' => 'Obriši ovaj imejl nalog',
        'Deleting the mail account and its data. This may take a while...' =>
            'Brisanje imejl naloga i konfiguracije. Ovo može malo potrajati...',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.NotificationEvent.js
        'Do you really want to delete this notification language?' => 'Da li stvarno želite da izbrišete ovaj jezik za obaveštenja?',
        'Do you really want to delete this notification?' => 'Da li stvarno želite da obrišete ovo obaveštenje?',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.OAuth2TokenManagement.js
        'Do you really want to delete this token and its configuration?' =>
            '',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.PGP.js
        'Do you really want to delete this key?' => 'Da li zaista želite da obrišete ovaj ključ?',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.PackageManager.js
        'There is a package upgrade process running, click here to see status information about the upgrade progress.' =>
            'Ažuriranje paketa je u toku, kliknite ovde za status napredovanja.',
        'A package upgrade was recently finished. Click here to see the results.' =>
            'Ažuriranje paketa je završeno. Kliknite ovde za rezultate.',
        'No response from get package upgrade result.' => 'Bez odgovora od komande za unapređenje paketa.',
        'Update all packages' => 'Ažuriraj sve pakete',
        'Dismiss' => 'Poništi',
        'Update All Packages' => 'Ažuriraj sve pakete',
        'No response from package upgrade all.' => 'Bez odgovora od komande za unapređenje svih paketa.',
        'Currently not possible' => 'Trenutno nije moguće',
        'This is currently disabled because of an ongoing package upgrade.' =>
            'Ova funkcija je trenutno isključena zbog ažuriranja paketa u toku.',
        'This option is currently disabled because the OTRS Daemon is not running.' =>
            'Ova funkcija je trenutno isključena zato što OTRS servis ne radi.',
        'Are you sure you want to update all installed packages?' => 'Da li ste sigurni da želite da unapredite sve instalirane pakete?',
        'No response from get package upgrade run status.' => 'Bez odgovora od komande za status unapređenja paketa.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.PostMasterFilter.js
        'Delete this PostMasterFilter' => 'Obriši ovaj PostMaster filter',
        'Deleting the postmaster filter and its data. This may take a while...' =>
            'Brisanje PostMaster filtera i konfiguracije. Ovo može malo potrajati...',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.ProcessManagement.Canvas.js
        'Remove Entity from canvas' => 'Ukloni objekat sa površine',
        'No TransitionActions assigned.' => 'Nema dodeljenih tranzicionih aktivnosti.',
        'No dialogs assigned yet. Just pick an activity dialog from the list on the left and drag it here.' =>
            'Još uvek nema dodeljenih dijaloga. Samo izaberite jedan dijalog aktivnosti iz liste sa leve strane i prevucite ga ovde.',
        'This Activity cannot be deleted because it is the Start Activity.' =>
            'Ova aktivnost se ne može brisati, zato što je to početak aktivnosti.',
        'Remove the Transition from this Process' => 'Ukloni tranziciju iz ovog procesa',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.ProcessManagement.js
        'As soon as you use this button or link, you will leave this screen and its current state will be saved automatically. Do you want to continue?' =>
            'Ukoliko koristite ovo dugme ili vezu, napustićete ekran i njegov trenutni sadržaj će biti automatski sačuvan. Želite li da nastavite?',
        'Delete Entity' => 'Izbriši objekat',
        'This Activity is already used in the Process. You cannot add it twice!' =>
            'Ova aktivnost je već korišćena u procesu. Ne možete je dodavati dva puta.',
        'Error during AJAX communication' => 'Greška prilikom AJAX komunikacije',
        'An unconnected transition is already placed on the canvas. Please connect this transition first before placing another transition.' =>
            'Nepovezana tranzicija je već postavljena na površinu. Molimo povežite prvu tranziciju pre nego što postavite drugu tranziciju.',
        'This Transition is already used for this Activity. You cannot use it twice!' =>
            'Ova tranzicija je već korišćena za ovu aktivnost. Ne možete je koristiti dva puta.',
        'This TransitionAction is already used in this Path. You cannot use it twice!' =>
            'Ova tranziciona tktivnost je već korišćena u ovoj putanji. Ne možete je koristiti dva puta.',
        'Hide EntityIDs' => 'Sakrij EntityIDs',
        'Edit Field Details' => 'Uredi detalje polja',
        'Customer interface does not support articles not visible for customers.' =>
            'Klijentski interfejs ne podržava članke koji nisu vidljivi klijentima.',
        'Sorry, the only existing parameter can\'t be removed.' => 'Žao nam je, poslednji parametar ne može biti uklonjen.',
        'Are you sure you want to overwrite the config parameters?' => '',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.SMIME.js
        'Do you really want to delete this certificate?' => 'Da li stvarno želite da obrišete ovaj sertifikat?',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.SupportDataCollector.js
        'Sending Update...' => 'Slanje ažuriranja...',
        'Support Data information was successfully sent.' => 'Informacije podržanih podataka su uspešno poslate.',
        'Was not possible to send Support Data information.' => 'Nije moguće poslati informacije podržanih podataka.',
        'Update Result' => 'Rezultat ažuriranja',
        'Generating...' => 'Generisanje...',
        'It was not possible to generate the Support Bundle.' => 'Nije moguće generisati Paket podrške.',
        'Generate Result' => 'Generiši rezultat',
        'Support Bundle' => 'Paket podrške',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.SysConfig.Entity.js
        'It is not possible to set this entry to invalid. All affected configuration settings have to be changed beforehand.' =>
            'Nije moguće obeležiti ovu stavku kao nevažeću. Sva zavisna podešavanja u konfiguraciji moraju biti prvo izmenjena.',
        'Cannot proceed' => 'Nije moguće nastaviti',
        'Update manually' => 'Ažuriraj ručno',
        'You can either have the affected settings updated automatically to reflect the changes you just made or do it on your own by pressing \'update manually\'.' =>
            'Možete ili ažurirati sva zavisna podešavanja automatski na promene koje ste napravili ili da to odradite ručno klikom na \'Ažuriraj ručno\'.',
        'Save and update automatically' => 'Sačuvaj i ažuriraj automatski',
        'Don\'t save, update manually' => 'Odustani i ažuriraj ručno',
        'The item you\'re currently viewing is part of a not-yet-deployed configuration setting, which makes it impossible to edit it in its current state. Please wait until the setting has been deployed. If you\'re unsure what to do next, please contact your system administrator.' =>
            'Stavka koju trenutno gledate je deo neraspoređene konfiguracije, i nije moguće urediti je u trenutnom stanju. Molimo sačekajte dok podešavanje ne bude raspoređeno. Ukoliko niste sigurni kako da nastavite, molimo kontaktirajte vašeg administratora.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.SystemConfiguration.js
        'Loading...' => 'Učitavanje...',
        'Search the System Configuration' => 'Pretraga sistemske konfiguracije',
        'Please enter at least one search word to find anything.' => 'Molimo unesite barem jednu ključnu reč da bi ste nešto pronašli.',
        'Unfortunately deploying is currently not possible, maybe because another agent is already deploying. Please try again later.' =>
            'Nažalost, raspoređivanje trenutno nije moguće, verovatno zato što drugi korisnik već raspoređuje. Molimo pokušajte kasnije.',
        'Deploy' => 'Rasporedi',
        'The deployment is already running.' => 'Raspoređivanje je već u toku.',
        'Deployment successful. You\'re being redirected...' => 'Raspoređivanje uspešno, bićete preusmereni...',
        'There was an error. Please save all settings you are editing and check the logs for more information.' =>
            'Dogodila se greška. Molimo sačuvajte sva podešavanja koja uređujete i proverite log datoteku za više informacija.',
        'Reset option is required!' => 'Poništavanje je obavezno!',
        'By restoring this deployment all settings will be reverted to the value they had at the time of the deployment. Do you really want to continue?' =>
            'Obnavljanjem ovog rasporeda sva podešavanja će biti vraćena na vrednost koju su imala u vreme rasporeda. Da li stvarno želite da nastavite?',
        'Keys with values can\'t be renamed. Please remove this key/value pair instead and re-add it afterwards.' =>
            'Ključevi sa vrednostima ne mogu biti promenjeni. Molimo uklonite ovaj par ključ/vrednost i dodajte ga ponovo.',
        'Unlock setting.' => 'Otključaj podešavanje.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.SystemMaintenance.js
        'Do you really want to delete this scheduled system maintenance?' =>
            'Da li stvarno želite da obrišete ovo planirano oržavanje sistema?',

        # JS File: var/httpd/htdocs/js/Core.Agent.Admin.Template.js
        'Delete this Template' => 'Obriši ovaj šablon',
        'Deleting the template and its data. This may take a while...' =>
            'Brisanje šablona i konfiguracije. Ovo može malo potrajati...',

        # JS File: var/httpd/htdocs/js/Core.Agent.AppointmentCalendar.js
        'Jump' => 'Skoči',
        'Timeline Month' => 'Mesečna osa',
        'Timeline Week' => 'Sedmična osa',
        'Timeline Day' => 'Dnevna osa',
        'Previous' => 'Nazad',
        'Resources' => 'Resursi',
        'Su' => 'ne',
        'Mo' => 'po',
        'Tu' => 'ut',
        'We' => 'sr',
        'Th' => 'če',
        'Fr' => 'pe',
        'Sa' => 'su',
        'This is a repeating appointment' => 'Ovaj termin se ponavlja',
        'Would you like to edit just this occurrence or all occurrences?' =>
            'Da li želite da izmeni samo ovo ili sva ponavljanja?',
        'All occurrences' => 'Sva ponavljanja',
        'Just this occurrence' => 'Samo ovo ponavljanje',
        'Too many active calendars' => 'Previše aktivnih kalendara',
        'Please either turn some off first or increase the limit in configuration.' =>
            'Ili prvo isključite prikaz nekog kalendara ili povećajte limit u konfiguraciji.',
        'Restore default settings' => 'Vratite podrazumevana podešavanja',
        'Are you sure you want to delete this appointment? This operation cannot be undone.' =>
            'Da li ste sigurni da želite da izbrišete ovaj termin? Ovu operaciju nije moguće opozvati.',

        # JS File: var/httpd/htdocs/js/Core.Agent.CustomerSearch.js
        'First select a customer user, then select a customer ID to assign to this ticket.' =>
            'Prvo odaberite klijent korisnika, onda možete odabrati ID klijenta za dodelu ovom tiketu.',
        'Duplicated entry' => 'Dvostruki unos',
        'It is going to be deleted from the field, please try again.' => 'Biće obrisano iz polja, molimo pokušajte ponovo.',

        # JS File: var/httpd/htdocs/js/Core.Agent.CustomerUserAddressBook.js
        'Please enter at least one search value or * to find anything.' =>
            'Molimo unesite barem jednu vrednost pretrage ili * da bi ste nešto pronašli.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Daemon.js
        'Information about the OTRS Daemon' => 'Informacije o OTRS sistemskom servisu',

        # JS File: var/httpd/htdocs/js/Core.Agent.Dashboard.js
        'Please check the fields marked as red for valid inputs.' => 'Molimo proverite polja označena crvenim za važeće unose.',
        'month' => 'mesec',
        'Remove active filters for this widget.' => 'Ukloni aktivne filtere za ovaj dodatak.',

        # JS File: var/httpd/htdocs/js/Core.Agent.LinkObject.SearchForm.js
        'Please wait...' => 'Molimo sačekajte...',
        'Searching for linkable objects. This may take a while...' => 'Pretraga objekata za povezivanje. Ovo može malo potrajati...',

        # JS File: var/httpd/htdocs/js/Core.Agent.LinkObject.js
        'Do you really want to delete this link?' => 'Da li zaista želite da obrišete ovu vezu?',

        # JS File: var/httpd/htdocs/js/Core.Agent.Login.js
        'Are you using a browser plugin like AdBlock or AdBlockPlus? This can cause several issues and we highly recommend you to add an exception for this domain.' =>
            'Da li koristite dodatak za pretraživač kao što su AdBlock ili AdBlockPlus? Ovo može rezultirati u nekoliko problema i toplo preporučujemo da dodate izuzetak za ovu stranu.',
        'Do not show this warning again.' => 'Ne prikazuj ponovo ovo upozorenje.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Preferences.js
        'Sorry, but you can\'t disable all methods for notifications marked as mandatory.' =>
            'Izvinite ali ne možete isključiti sve metode za obaveštenja označena kao obavezna.',
        'Sorry, but you can\'t disable all methods for this notification.' =>
            'Izvinite ali ne možete isključiti sve metode za ovo obaveštenje.',
        'Please note that at least one of the settings you have changed requires a page reload. Click here to reload the current screen.' =>
            'Napominjemo da najmanje jedno podešavanje koje ste izmenili zahteva ponovno učitavanje stranice. Kliknite ovde za ponovno učitavanje ekrana.',
        'An unknown error occurred. Please contact the administrator.' =>
            'Dogodila se nepoznata greška. Molimo kontaktirajte administratora.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Responsive.js
        'Switch to desktop mode' => 'Pređi na desktop mod',

        # JS File: var/httpd/htdocs/js/Core.Agent.Search.js
        'Please remove the following words from your search as they cannot be searched for:' =>
            'Molimo da uklonite sledeće reči iz vaše pretrage jer se ne mogu tražiti:',

        # JS File: var/httpd/htdocs/js/Core.Agent.SharedSecretGenerator.js
        'Generate' => 'Generiši',

        # JS File: var/httpd/htdocs/js/Core.Agent.SortedTree.js
        'This element has children elements and can currently not be removed.' =>
            'Ovaj element ima decu i trenutno ne može biti uklonjen.',

        # JS File: var/httpd/htdocs/js/Core.Agent.Statistics.js
        'Do you really want to delete this statistic?' => 'Da li stvarno želite da obrišete ovu statistiku?',

        # JS File: var/httpd/htdocs/js/Core.Agent.TicketAction.js
        'Select a customer ID to assign to this ticket' => 'Odaberite ID klijenta za dodelu ovom tiketu',
        'Do you really want to continue?' => 'Da li stvarno želite da nastavite?',

        # JS File: var/httpd/htdocs/js/Core.Agent.TicketBulk.js
        ' ...and %s more' => '...i još %s',
        ' ...show less' => '...prikaži manje',

        # JS File: var/httpd/htdocs/js/Core.Agent.TicketFormDraft.js
        'Add new draft' => 'Dodaj novi nacrt',
        'Delete draft' => 'Obriši nacrt',
        'There are no more drafts available.' => 'Trenutno nema više nacrta.',
        'It was not possible to delete this draft.' => 'Nije bilo moguće obrisati ovaj nacrt.',

        # JS File: var/httpd/htdocs/js/Core.Agent.TicketZoom.js
        'Article filter' => 'Filter za članke',
        'Apply' => 'Primeni',
        'Event Type Filter' => 'Filter tipa događaja',

        # JS File: var/httpd/htdocs/js/Core.Agent.js
        'Slide the navigation bar' => 'Pomerite navigacionu traku',
        'Please turn off Compatibility Mode in Internet Explorer!' => 'Molimo da isključite mod kompatibilnosti u Internet eksploreru!',
        'Find out more' => 'Saznaj više',

        # JS File: var/httpd/htdocs/js/Core.App.Responsive.js
        'Switch to mobile mode' => 'Pređi na mobilni mod',

        # JS File: var/httpd/htdocs/js/Core.App.js
        'Error: Browser Check failed!' => 'Greška: provera pretraživača nije uspela!',
        'Reload page' => 'Osveži stranicu',
        'Reload page (%ss)' => 'Osveži stranicu (%ss)',

        # JS File: var/httpd/htdocs/js/Core.Debug.js
        'Namespace %s could not be initialized, because %s could not be found.' =>
            'Skript %s nije bilo moguće inicijalizovati, jer %s nije pronađen.',

        # JS File: var/httpd/htdocs/js/Core.Exception.js
        'An error occurred! Please check the browser error log for more details!' =>
            'Dogodila se greška! Molimo proverite log pretraživača za više informacija!',

        # JS File: var/httpd/htdocs/js/Core.Form.Validate.js
        'One or more errors occurred!' => 'Došlo je do jedne ili više grešaka!',

        # JS File: var/httpd/htdocs/js/Core.Installer.js
        'Mail check successful.' => 'Uspešna provera imejl podešavanja.',
        'Error in the mail settings. Please correct and try again.' => 'Greška u podešavanju imejla. Molimo ispravite i pokušajte ponovo.',

        # JS File: var/httpd/htdocs/js/Core.SystemConfiguration.js
        'Open this node in a new window' => 'Otvori ovu stavku u novom prozoru',
        'Please add values for all keys before saving the setting.' => 'Molimo unesite vrednosti za sve ključeve pre nego što sačuvate podešavanje.',
        'The key must not be empty.' => 'Ključ ne sme biti prazan.',
        'A key with this name (\'%s\') already exists.' => 'Ključ sa ovim nazivom (\'%s\') već postoji.',
        'Do you really want to revert this setting to its historical value?' =>
            'Da li stvarno želite da poništite ovo podešavanje na njegovu prethodnu vrednost?',

        # JS File: var/httpd/htdocs/js/Core.UI.Datepicker.js
        'Open date selection' => 'Otvori izbor datuma',
        'Invalid date (need a future date)!' => 'Neispravan datum (neophodan datum u budućnosti)!',
        'Invalid date (need a past date)!' => 'Neispravan datum (neophodan datum u prošlosti)!',

        # JS File: var/httpd/htdocs/js/Core.UI.InputFields.js
        'Not available' => 'Nije dostupno',
        'and %s more...' => 'i %s više...',
        'Show current selection' => 'Prikaži trenutni izbor',
        'Current selection' => 'Trenutni izbor',
        'Clear all' => 'Očisti sve',
        'Filters' => 'Filteri',
        'Clear search' => 'Očisti pretragu',

        # JS File: var/httpd/htdocs/js/Core.UI.Popup.js
        'If you now leave this page, all open popup windows will be closed, too!' =>
            'Ako napustite ovu stranicu, svi otvoreni prozori će biti zatvoreni!',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' =>
            'Prikaz ovog ekrana je već otvoren. Želite li da ga zatvorite i učitate ovaj umesto njega?',
        'Could not open popup window. Please disable any popup blockers for this application.' =>
            'Nije moguće otvoriti iskačući prozor. Molimo da isključite blokadu iskačućih prozora za ovu aplikaciju.',

        # JS File: var/httpd/htdocs/js/Core.UI.Table.Sort.js
        'Ascending sort applied, ' => 'Rastuće sortiranje,',
        'Descending sort applied, ' => 'Opadajuće sortiranje,',
        'No sort applied, ' => 'Bez sortiranja,',
        'sorting is disabled' => 'sortiranje je isključeno',
        'activate to apply an ascending sort' => 'sortiraj rastuće',
        'activate to apply a descending sort' => 'sortiraj opadajuće',
        'activate to remove the sort' => 'isključi sortiranje',

        # JS File: var/httpd/htdocs/js/Core.UI.Table.js
        'Remove the filter' => 'Ukloni filter',

        # JS File: var/httpd/htdocs/js/Core.UI.TreeSelection.js
        'There are currently no elements available to select from.' => 'Trenutno nema slobodnih elemenata za odabir.',

        # JS File: var/httpd/htdocs/js/Core.UI.js
        'Please only select one file for upload.' => 'Molimo da izaberete samo jednu datoteku za otpremanje.',
        'Sorry, you can only upload one file here.' => 'Žao nam je, ovde možete otpremiti samo jednu datoteku.',
        'Sorry, you can only upload %s files.' => 'Žao namo je, možete otpremiti samo %s datoteke(a).',
        'Please only select at most %s files for upload.' => 'Molimo da izaberete najviše %s datoteke(a) za otpremanje.',
        'The following files are not allowed to be uploaded: %s' => 'Nije dozvoljeno otpremanje sledećih datoteka: %s',
        'The following files exceed the maximum allowed size per file of %s and were not uploaded: %s' =>
            'Sledeće datoteke premašuju najveću dozvoljenu veličinu od %s i nisu bile otpremljene: %s',
        'The names of the following files exceed the maximum allowed length of %s characters and were not uploaded: %s' =>
            '',
        'The following files were already uploaded and have not been uploaded again: %s' =>
            'Sledeće datoteke su već bile otpremljene i nisu dodate ponovo: %s',
        'No space left for the following files: %s' => 'Za sledeće datoteke nema više mesta: %s',
        'Available space %s of %s.' => 'Raspoloživ prostor %s od %s.',
        'Upload information' => 'Informacije o otpremanju',
        'An unknown error occurred when deleting the attachment. Please try again. If the error persists, please contact your system administrator.' =>
            'Dogodila se nepoznata greška prilikom brisanja priloga. Molimo pokušajte ponovo. Ako se greška ponovo, molimo kontaktirajte vašeg administratora.',

        # JS File: var/httpd/htdocs/js/test/Core.Language.UnitTest.js
        'yes' => 'da',
        'no' => 'ne',
        'This is %s' => 'Ovo je %s',
        'Complex %s with %s arguments' => 'Kompleksan %s sa %s argumenata',

        # JS File: var/httpd/htdocs/js/thirdparty/nvd3-1.7.1/models/OTRSLineChart.js
        'No Data Available.' => 'Nema informacija.',

        # JS File: var/httpd/htdocs/js/thirdparty/nvd3-1.7.1/models/OTRSMultiBarChart.js
        'Grouped' => 'Grupisano',
        'Stacked' => 'Naslagano',

        # JS File: var/httpd/htdocs/js/thirdparty/nvd3-1.7.1/models/OTRSStackedAreaChart.js
        'Stream' => 'Protok',
        'Expanded' => 'Prošireno',

        # SysConfig
        '
Dear Customer,

Unfortunately we could not detect a valid ticket number
in your subject, so this email can\'t be processed.

Please create a new ticket via the customer panel.

Thanks for your help!

 Your Helpdesk Team
' => '
Poštovani,

Na žalost ne možemo pronaći važeći broj tiketa
u vašem predmetu, pa ovaj imejl ne može biti obrađen.

Molimo Vas da preko klijentskog panela kreirate novi tiket.

Hvala na vašoj pomoći!

Vaša tehnička podrška
',
        ' (work units)' => '(radne jedinice)',
        ' 2 minutes' => ' 2 minuta',
        ' 5 minutes' => ' 5 minuta',
        ' 7 minutes' => ' 7 minuta',
        '"Slim" skin which tries to save screen space for power users.' =>
            '"Uprošćeni" izgled koji pokušava da uštedi mesto za napredne korisnike.',
        '%s' => '%s',
        '(UserLogin) Firstname Lastname' => '(Korisničko ime) Ime Prezime',
        '(UserLogin) Lastname Firstname' => '(Korisničko ime) Prezime Ime',
        '(UserLogin) Lastname, Firstname' => '(Korisničko ime) Prezime, Ime',
        '0 - Disabled' => '0 - Isključeno',
        '1 - Available' => '1 - Uključeno',
        '1 - Enabled' => '1 - Uključeno',
        '10 Minutes' => '10 minuta',
        '100 (Expert)' => '100 (Ekspert)',
        '15 Minutes' => '15 minuta',
        '2 - Enabled and required' => '2 - Uključeno i obavezno',
        '2 - Enabled and shown by default' => '2 - Uključeno i podrazumevano prikazano',
        '2 - Enabled by default' => '2 - Podrazumevano uključeno',
        '2 Minutes' => '2 minuta',
        '200 (Advanced)' => '200 (Napredni)',
        '30 Minutes' => '30 minuta',
        '300 (Beginner)' => '300 (Početnik)',
        '5 Minutes' => '5 minuta',
        'A TicketWatcher Module.' => 'Modul nadzora tiketa.',
        'A Website' => 'Vebsajt',
        'A picture' => 'Slika',
        'AJAX functions for notification event transport web service.' =>
            '',
        'AJAX interface for the web service dynamic field backends.' => '',
        'AccountedTime' => 'Obračunato vreme',
        'Activation of dynamic fields for screens.' => '',
        'ActivityID' => 'ID aktivnosti',
        'Add a note to this ticket' => 'Dodaj napomenu ovom tiketu',
        'Add an inbound phone call to this ticket' => 'Dodaj dolazni poziv ovom tiketu.',
        'Add an outbound phone call to this ticket' => 'Dodaj odlazni poziv ovom tiketu.',
        'Added %s time unit(s), for a total of %s time unit(s).' => 'Dodato %s jedinice(a), za ukupno %s vremenske(ih) jedinice(a).',
        'Added email. %s' => 'Dodat imejl. %s',
        'Added follow-up to ticket [%s]. %s' => 'Dodat nastavak u tiket [%s]. %s',
        'Added link to ticket "%s".' => 'Veza na tiket "%s" je postavljena.',
        'Added note (%s).' => 'Dodata napomena (%s).',
        'Added phone call from customer.' => 'Dodat dolazni poziv od klijenta.',
        'Added phone call to customer.' => 'Dodat odlazni poziv klijentu.',
        'Added subscription for user "%s".' => 'Pretplata za korisnika "%s" je uključena.',
        'Added system request (%s).' => 'Dodat sistemski zahtev (%s).',
        'Added web request from customer.' => 'Dodat veb zahtev od klijenta.',
        'Admin' => 'Admin',
        'Admin Area.' => 'Administrativni prostor.',
        'Admin Notification' => 'Administratorska obaveštenja',
        'Admin configuration dialog for dynamic field types WebserviceDropdown and WebserviceMultiselect' =>
            '',
        'Admin modules overview.' => 'Pregled administratorskih modula.',
        'Admin.' => 'Admin.',
        'Administration' => 'Administracija',
        'Agent Customer Search' => 'Pretraga klijenata za operatere',
        'Agent Customer Search.' => 'Pretraga klijenata za operatere.',
        'Agent Name' => 'Ime operatera',
        'Agent Name + FromSeparator + System Address Display Name' => 'Naziv operatera + separator "od" + sistemska adresa za prikaz',
        'Agent Preferences.' => 'Operaterska podešavanja.',
        'Agent Statistics.' => 'Statistike za interfejs operatera.',
        'Agent User Search' => 'Pretraga korisnika za operatere',
        'Agent User Search.' => 'Pretraga korisnika za operatere.',
        'All CustomerIDs of a customer user.' => 'Svi klijent ID klijent korisnika.',
        'All customer users of a CustomerID' => 'Svi klijenti korisnici za CustomerID',
        'All escalated tickets' => 'Svi eskalirani tiketi',
        'All new tickets, these tickets have not been worked on yet' => 'Svi novi tiketi, na njima još nije ništa rađeno',
        'All open tickets, these tickets have already been worked on.' =>
            'Svi otvoreni tiketi na kojima je već rađeno.',
        'All tickets with a reminder set where the reminder date has been reached' =>
            'Svi tiketi sa podešenim podsetnikom, a datum podsetnika je dostignut',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search e. g. ticket title with this kind of conditions like "(*key1*&&*key2*)" or "(*key1*||*key2*)".' =>
            'Omogućava napredne uslove pretrage tiketa u interfejsu operatera. Sa ovom opcijom moćete pretraživati npr. naslov tiketa sa uslovima kao "(*key1*&&*key2*)" ili "(*key1*||*key2*)".',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search e. g. ticket title with this kind of conditions like "(*key1*&&*key2*)" or "(*key1*||*key2*)".' =>
            'Omogućava napredne uslove pretrage tiketa u interfejsu korisnika. Sa ovom opcijom moćete pretraživati npr. naslov tiketa sa uslovima kao "(*key1*&&*key2*)" ili "(*key1*||*key2*)".',
        'Allows extended search conditions in ticket search of the generic agent interface. With this feature you can search e. g. ticket title with this kind of conditions like "(*key1*&&*key2*)" or "(*key1*||*key2*)".' =>
            'Dozvoljava proširene uslove pretrage u pretrazi tiketa na interfejsu generičkog operatera. Pomoću ove funkcije možete vršiti pretrage npr. naslov tiketa sa vrstom uslova kao što su "(*key1*&&*key2*)" ili "(*key1*||*key2*)".',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' =>
            'Dozvoljava posedovanje srednjeg formata pregleda tiketa ( CustomerInfo => 1 - takođe prikazuje informacije o klijentu).',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' =>
            'Dozvoljava posedovanje malog formata pregleda tiketa ( CustomerInfo => 1  - takođe prikazuje informacije o klijentu).',
        'Always show RichText if available' => 'Uvek prikaži RichText ako je dostupan',
        'An additional screen to add notes to a linked ticket.' => '',
        'Answer' => 'Odgovor',
        'Appointment Calendar overview page.' => 'Stranica za pregled kalendara.',
        'Appointment Notifications' => 'Obaveštenja o terminu',
        'Appointment edit screen.' => 'Stranica za izmenu kalendara.',
        'Appointment list' => 'Lista termina',
        'Appointment list.' => 'Lista termina.',
        'Appointment notifications' => 'Obaveštenja o terminu',
        'Arabic (Saudi Arabia)' => 'Arapski (Saudijska arabija)',
        'ArticleTree' => 'Članak u obliku drveta',
        'Attachment Name' => 'Naziv priloga',
        'Avatar' => 'Avatar sličica',
        'Based on global RichText setting' => 'Bazirano na globalnim RichText postavkama',
        'Bounced to "%s".' => 'Odbijeno na "%s".',
        'Bulgarian' => 'Bugarski',
        'Bulk Action' => 'Masovna akcija',
        'CSV Separator' => 'CSV separator',
        'Calendar manage screen.' => 'Stranica za upravljanje kalendarima.',
        'Catalan' => 'Katalonski',
        'Change password' => 'Promena lozinke',
        'Change queue!' => 'Promena reda!',
        'Change the customer for this ticket' => 'Promeni klijenta za ovaj tiket',
        'Change the free fields for this ticket' => 'Promeni slobodna polja ovog tiketa',
        'Change the owner for this ticket' => 'Promeni vlasnika ovog tiketa',
        'Change the priority for this ticket' => 'Promeni prioritete za ovaj tiket.',
        'Change the responsible for this ticket' => 'Promeni odgovornog za ovaj tiket',
        'Change your avatar image.' => 'Promenite vašu avatar sličicu.',
        'Change your password and more.' => 'Promenite lozinku i slično.',
        'Changed SLA to "%s" (%s).' => 'Promenjen SLA na "%s" (%s).',
        'Changed archive state to "%s".' => 'Promenjeno stanje arhiviranja na "%s".',
        'Changed customer to "%s".' => 'Promenjen klijent na "%s".',
        'Changed dynamic field %s from "%s" to "%s".' => 'Promenjeno dinamičko polje %s sa "%s" na "%s".',
        'Changed owner to "%s" (%s).' => 'Promenjen vlasnik na "%s" (%s).',
        'Changed pending time to "%s".' => 'Promenjeno vreme čekanja na "%s".',
        'Changed priority from "%s" (%s) to "%s" (%s).' => 'Ažuriran prioritet sa "%s" (%s) na "%s" (%s).',
        'Changed queue to "%s" (%s) from "%s" (%s).' => 'Promenjen red na "%s" (%s) sa "%s" (%s).',
        'Changed responsible to "%s" (%s).' => 'Promenjen odgovorni na "%s" (%s).',
        'Changed service to "%s" (%s).' => 'Promenjen servis na "%s" (%s).',
        'Changed state from "%s" to "%s".' => 'Promenjeno stanje sa "%s" na "%s".',
        'Changed title from "%s" to "%s".' => 'Promenjen naslov sa "%s" na "%s".',
        'Changed type from "%s" (%s) to "%s" (%s).' => 'Promenjen tip sa "%s" (%s) na "%s" (%s).',
        'Chat communication channel.' => 'Komunikacioni kanal ćaskanja.',
        'Checkbox' => 'Polje za potvrdu',
        'Child' => 'Child',
        'Chinese (Simplified)' => 'Kineski (uprošćeno)',
        'Chinese (Traditional)' => 'Kineski (tradicionalno)',
        'Choose for which kind of appointment changes you want to receive notifications.' =>
            'Izaberi za kakve promene termina želiš da primiš obaveštenja.',
        'Choose for which kind of ticket changes you want to receive notifications. Please note that you can\'t completely disable notifications marked as mandatory.' =>
            'Izaberite za kakve promene tiketa želite da primate obaveštenja. Molimo obratite pažnju da ne možete u potpunosti da isključite obaveštenja koja su označena kao obavezna.',
        'Choose which notifications you\'d like to receive.' => 'Izaberite koja obaveštenja želite da primate.',
        'Christmas Eve' => 'Badnje veče',
        'Close' => 'Zatvori',
        'Close this ticket' => 'Zatvori ovaj tiket',
        'Closed tickets (customer user)' => 'Zatvoreni tiketi (klijent korisnik)',
        'Closed tickets (customer)' => 'Zatvoreni tiketi (klijent)',
        'Cloud Services' => 'Servisi u oblaku',
        'Column ticket filters for Ticket Overviews type "Small".' => 'Filteri kolona tiketa za preglede tiketa tipa "malo".',
        'Comment2' => 'Komentar 2',
        'Communication' => 'Komunikacija',
        'Communication & Notifications' => 'Komunikacija & obaveštenja',
        'Communication Log GUI' => 'Grafički interfej komunikacionog loga',
        'Communication log limit per page for Communication Log Overview.' =>
            'Ograničenje broja logova po strani za pregled komunikacionih logova.',
        'CommunicationLog Overview Limit' => 'Ograničenje pregleda komunikacionih logova',
        'Company Status' => 'Status firme',
        'Company Tickets.' => 'Tiketi firmi.',
        'Compat module for AgentZoom to AgentTicketZoom.' => 'Modul kompatibilnosti za AgentZoom u AgentTicketZoom.',
        'Complex' => 'Složeno',
        'Compose' => 'Napiši',
        'Configure Processes.' => 'Konfiguriši procese.',
        'Configure and manage ACLs.' => 'Konfiguriši i upravljaj ACL listama.',
        'Configure sending of support data to OTRS Group for improved support.' =>
            'Podešavanje slanja podataka za podršku OTRS grupi radi unapređenja podrške.',
        'Configure which screen should be shown after a new ticket has been created.' =>
            'Konfiguriše koji ekran bi trebalo prikazati nakon kreiranja novog tiketa.',
        'Create New process ticket.' => 'Kreiraj novi proces tiket',
        'Create Ticket' => 'Kreiraj tiket',
        'Create a new calendar appointment linked to this ticket' => 'Kreira novi termin u kalendaru povezan sa ovim tiketom',
        'Create a unit test file' => '',
        'Create and manage Service Level Agreements (SLAs).' => 'Kreira i upravlja Sporazume o nivou usluga (SLA)',
        'Create and manage agents.' => 'Kreiranje i upravljanje operaterima.',
        'Create and manage appointment notifications.' => 'Kreiranje i upravljanje obaveštenjima za termine.',
        'Create and manage attachments.' => 'Kreiranje i upravljanje prilozima.',
        'Create and manage calendars.' => 'Kreiranje i upravljanje kalendarima.',
        'Create and manage customer users.' => 'Kreiranje i upravljanje klijentima korisnicima.',
        'Create and manage customers.' => 'Kreiranje i upravljanje klijentima.',
        'Create and manage dynamic fields.' => 'Kreiranje i upravljanje dinamičkim poljima.',
        'Create and manage groups.' => 'Kreiranje i upravljanje grupama.',
        'Create and manage queues.' => 'Kreiranje i upravljanje redovima.',
        'Create and manage responses that are automatically sent.' => 'Kreiranje i upravljanje automatskim odgovorima.',
        'Create and manage roles.' => 'Kreiranje i upravljanje ulogama.',
        'Create and manage salutations.' => 'Kreiranje i upravljanje pozdravima.',
        'Create and manage services.' => 'Kreiranje i upravljanje uslugama.',
        'Create and manage signatures.' => 'Kreiranje i upravljanje potpisima.',
        'Create and manage templates.' => 'Kreiranje i upravljanje šablonima.',
        'Create and manage ticket notifications.' => 'Kreiranje i upravljanje obaveštenjima za tikete.',
        'Create and manage ticket priorities.' => 'Kreiranje i upravljanje prioritetima tiketa.',
        'Create and manage ticket states.' => 'Kreiranje i upravljanje statusima tiketa.',
        'Create and manage ticket types.' => 'Kreiranje i upravljanje tipovima tiketa.',
        'Create and manage web services.' => 'Kreiranje i upravljanje veb servisima.',
        'Create new Ticket.' => 'Kreiranje novog tiketa.',
        'Create new appointment.' => 'Kreira novi termin.',
        'Create new email ticket and send this out (outbound).' => 'Otvori novi imejl tiket i pošalji (odlaznu) poruku.',
        'Create new email ticket.' => 'Kreiranje novog imejl tiketa.',
        'Create new phone ticket (inbound).' => 'Kreiraj novi tiket (dolaznog) poziva.',
        'Create new phone ticket.' => 'Kreiranje novog tiketa poziva.',
        'Create new process ticket.' => 'Kreiraj novi proces tiket.',
        'Create tickets.' => 'Kreiranje tiketa.',
        'Created ticket [%s] in "%s" with priority "%s" and state "%s".' =>
            'Kreiran tiket [%s] u "%s" sa prioritetom "%s" i stanjem "%s".',
        'Creates a unit test file for this ticket and sends it to Znuny.' =>
            '',
        'Creates a unit test file for this ticket.' => '',
        'Croatian' => 'Hrvatski',
        'Custom RSS Feed' => 'Prilagođeni RSS izvor',
        'Custom RSS feed.' => 'Prilagođeni RSS izvor.',
        'Customer Administration' => 'Administracija klijenata',
        'Customer Companies' => 'Firme klijenti',
        'Customer IDs' => 'ID klijenta',
        'Customer Information Center Search.' => 'Pretraga klijentskog informativnog centra.',
        'Customer Information Center search.' => 'Pretraga klijentskog informativnog centra.',
        'Customer Information Center.' => 'Klijentski informativni centar.',
        'Customer Ticket Print Module.' => 'Modul za štampu tiketa u interfejsu klijenta.',
        'Customer User Administration' => 'Administracija klijenta korisnika',
        'Customer User Information' => 'Informacije o klijent korisniku',
        'Customer User Information Center Search.' => 'Pretraga klijent korisničkog informativnog centra.',
        'Customer User Information Center search.' => 'Pretraga klijent korisničkog informativnog centra.',
        'Customer User Information Center.' => 'Klijent-korisnički informativni centar.',
        'Customer User-Customer Relations' => '',
        'Customer preferences.' => 'Klijentske postavke.',
        'Customer ticket overview' => 'Klijentski pregled tiketa',
        'Customer ticket search.' => 'Klijentska pretraga tiketa.',
        'Customer ticket zoom' => 'Klijentski detaljni pregled tiketa',
        'Customer user search' => 'Pretraga klijenata korisnika',
        'CustomerID search' => 'Pretraga ID klijenata',
        'CustomerName' => 'Naziv klijenta',
        'CustomerUser' => 'Klijent korisnik',
        'Czech' => 'Češki',
        'Danish' => 'Danski',
        'Dashboard overview.' => 'Pregled komandne table.',
        'Date / Time' => 'Datum / Vreme',
        'Default (Slim)' => 'Podrazumevano (uprošćeno)',
        'Default agent name' => 'Podrazumevano ime operatera',
        'Default value for NameX' => 'Podrazumevana vrednost za NameX',
        'Define the queue comment 2.' => 'Definiše komentar reda 2.',
        'Define the service comment 2.' => 'Definiše servisni komentar 2.',
        'Define the sla comment 2.' => 'Definiše sla komentar 2.',
        'Delete this ticket' => 'Obrišite ovaj tiket',
        'Deleted link to ticket "%s".' => 'Veza na tiket "%s" je obrisana.',
        'Deploy and manage OTRS Business Solution™.' => 'Primeni i upravljaj OTRS Business Solution™.',
        'Detached' => 'Odvojeno',
        'Determines the strings that will be shown as recipient (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the recipient.' =>
            'Određuje frazu koje će biti prikazana kao primalac (To:) tiketa poziva i kao pošiljalac (From:) imejl tiketa u interfejsu operatera. Za red kao NewQueueSelectionType "<Queue>" prikazuje nazive redova, a za sistemsku adresu "<Realname> <<Email>>" prikazuje ime i imejl primaoca.',
        'Determines the strings that will be shown as recipient (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the recipient.' =>
            'Određuje frazu koja će biti prikazana kao primalac (To:) tiket u interfejsu klijenta. Za red kao CustomerPanelSelectionType "<Queue>" prikazuje imena redova i za sistemsku adresu "<Realname> <<Email>>" prikazuje ime i imejl primaoca.',
        'Development' => 'Razvoj',
        'Disable cloud services' => 'Onemogući servise u oblaku',
        'Display communication log entries.' => 'Prikazuje stavke komunikacionih logova.',
        'Down' => 'Dole',
        'Dropdown' => 'Padajući',
        'Dutch' => 'Holandski',
        'Dynamic Fields Checkbox Backend GUI' => 'Grafički interfejs dinamičkog polja za potvrdu',
        'Dynamic Fields Date Time Backend GUI' => 'Grafički interfejs dinamičkog polja za datum i vreme',
        'Dynamic Fields Drop-down Backend GUI' => 'Grafički interfejs padajućeg dinamičkog polja',
        'Dynamic Fields GUI' => 'Grafički interfejs dinamičkih polja',
        'Dynamic Fields Multiselect Backend GUI' => 'Grafički interfejs dinamičkog polja sa višestrukim izborom',
        'Dynamic Fields Overview Limit' => 'Ograničen pregled dinamičkih polja',
        'Dynamic Fields Text Backend GUI' => 'Grafički interfejs tekstualnog dinamičkog polja',
        'Dynamic fields groups for process widget. The key is the name of the group, the value contains the fields to be shown. Example: \'Key => My Group\', \'Content: Name_X, NameY\'.' =>
            'Grupe dinamičkih polja za procesni dodatak. Ključ je naziv grupe, vrednost sadrži polje koje će biti prikazano. Primer: \'Key => My Group\', \'Content: Name_X, NameY\'.',
        'Dynamic fields limit per page for Dynamic Fields Overview.' => 'Ograničenje dinamičkih polja po strani za prikaz dinamičkih polja.',
        'DynamicField' => 'Dinamičko polje',
        'DynamicField_%s' => 'DynamicField_%s',
        'E-Mail Outbound' => 'Odlazni imejl',
        'Edit Customer Companies.' => 'Izmena firmi klijenta.',
        'Edit Customer Users.' => 'Uredi klijente korisnike.',
        'Edit appointment' => 'Izmena termina',
        'Edit customer company' => 'Izmeni firmu klijenta',
        'Email Outbound' => 'Odlazni imejl',
        'Email Resend' => 'Pošalji ponovo imejl',
        'Email communication channel.' => 'Komunikacioni kanal imejla.',
        'Enabled filters.' => 'Omogućeni filteri.',
        'English (Canada)' => 'Engleski (Kanada)',
        'English (United Kingdom)' => 'Engleski (Ujedinjeno Kraljevstvo)',
        'English (United States)' => 'Engleski (Sjedinjene Države)',
        'Enroll process for this ticket' => 'Upiši proces za ovaj tiket',
        'Enter your shared secret to enable two factor authentication. WARNING: Make sure that you add the shared secret to your generator application and the application works well. Otherwise you will be not able to login anymore without the two factor token.' =>
            'Unesite svoj deljeni tajni ključ za dvofaktorski modul za identifikaciju. UPOZORENJE: obratite pažnju da morate pravilno uneti tajni ključ u vašu aplikaciju za identifikaciju i da aplikacija funkcioniše ispravno. U suprotnom, nećete biti u mogućnosti da se prijavite u sistem bez dvofaktorskog tokena.',
        'Escalated Tickets' => 'Eskalirani tiketi',
        'Escalation view' => 'Pregled eskalacija',
        'EscalationTime' => 'Vreme eskalacije',
        'Estonian' => 'Estonski',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate).' =>
            'Registracija modula događaja. Za bolji učinak možete definisati događaj okidač (npr Događaj => KreiranjeTiketa).',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all Ticket dynamic fields need the same event.' =>
            'Registracija modula događaja. Za bolji učinak možete definisati događaj okidač (npr Događaj => KreiranjeTiketa). Ovo je moguće samo ako svim dinamičkim poljima tiketa treba isti događaj.',
        'Events Ticket Calendar' => 'Kalendar događaja tiketa',
        'Execute SQL statements.' => 'Izvrši SQL naredbe.',
        'External' => 'Eksterno',
        'External Link' => 'Eksterna veza',
        'Filter for debugging ACLs. Note: More ticket attributes can be added in the format <OTRS_TICKET_Attribute> e.g. <OTRS_TICKET_Priority>.' =>
            'Filter za otklanjanje grešaka u ACL listama. Napomena: atributi tiketa mogu biti dodati u formatu <OTRS_TICKET_Attribute> npr. <OTRS_TICKET_Priority>.',
        'Filter for debugging Transitions. Note: More filters can be added in the format <OTRS_TICKET_Attribute> e.g. <OTRS_TICKET_Priority>.' =>
            'Filter za otklanjanje grešaka kod tranzicija. Napomena: filteri mogu biti dodati u formatu <OTRS_TICKET_Attribute> npr. <OTRS_TICKET_Priority>.',
        'Filter incoming emails.' => 'Filtriranje dolaznih poruka.',
        'Finnish' => 'Finski',
        'First Christmas Day' => 'Prvi dan Božića',
        'First Queue' => 'Prvi red',
        'First response time' => 'Vreme prvog odgovora',
        'FirstLock' => 'FirstLock',
        'FirstResponse' => 'FirstResponse',
        'FirstResponseDiffInMin' => 'FirstResponseDiffInMin',
        'FirstResponseInMin' => 'FirstResponseInMin',
        'Firstname Lastname' => 'Ime Prezime',
        'Firstname Lastname (UserLogin)' => 'Ime Prezime (Korisničko ime)',
        'Forwarded to "%s".' => 'Prosleđeno "%s".',
        'Free Fields' => 'Slobodna polja',
        'French' => 'Francuski',
        'French (Canada)' => 'Francuski (Kanada)',
        'Frontend' => 'Interfejs',
        'Full value' => 'Cela vrednost',
        'Fulltext search' => 'Tekst za pretragu',
        'Galician' => 'Galicijski',
        'Generic Info module.' => 'Generički informacioni modul',
        'GenericAgent' => 'Generički operater',
        'GenericInterface Debugger GUI' => 'Generički interfejs - otklanjanje grešaka',
        'GenericInterface ErrorHandling GUI' => 'Generički interfejs - otklanjanje grešaka',
        'GenericInterface Invoker Event GUI' => 'Generički interfejs - događaji pozivaoca',
        'GenericInterface Invoker GUI' => 'Generički interfejs - pozivalac',
        'GenericInterface Operation GUI' => 'Generički interfejs - operacija',
        'GenericInterface TransportHTTPREST GUI' => 'Generički interfejs -  HTTP REST transport',
        'GenericInterface TransportHTTPSOAP GUI' => 'Generički interfejs -  HTTP SOAP transport',
        'GenericInterface Web Service GUI' => 'Generički interfejs - veb servis',
        'GenericInterface Web Service History GUI' => 'Generički interfejs - istorijat veb servisa',
        'GenericInterface Web Service Mapping GUI' => 'Generički interfejs - mapiranje veb servisa',
        'German' => 'Nemački',
        'Gives customer users group based access to tickets from customer users of the same customer (ticket CustomerID is a CustomerID of the customer user).' =>
            'Dozvoljava pristup klijent korisnicima tiketima istog klijenta na osnovu grupa (klijent tiketa je isti kao klijent korisnika).',
        'Global Search Module.' => 'Modul opšte pretrage',
        'Go to dashboard!' => 'Idi na komandnu tablu!',
        'Good PGP signature.' => '',
        'Google Authenticator' => 'Gugl autentifikacija',
        'Graph: Bar Chart' => 'Grafik: Trakasti grafikon',
        'Graph: Line Chart' => 'Grafik: Linijski grafikon',
        'Graph: Stacked Area Chart' => 'Grafik: Naslagani prostorni grafikon',
        'Greek' => 'Grčki',
        'Hebrew' => 'Hebrejski',
        'High Contrast' => 'Visoki kontrast',
        'Hindi' => 'Hindi',
        'Hungarian' => 'Mađarski',
        'If enabled the daemon will use this directory to create its PID files. Note: Please stop the daemon before any change and use this setting only if <$OTRSHome>/var/run/ can not be used.' =>
            'Ukoliko je omogućeno, sistemski servis će koristiti ovaj direktorijum za snimanje procesnih (PID) datoteka. Napomena: molimo stopirajte sistemski servis pre izmene ovog podešavanja i koristite ga samo u slučaju kad je <$OTRSHome>/var/run/ nedostupan.',
        'If enabled, the different overviews (Dashboard, LockedView, QueueView) will automatically refresh after the specified time.' =>
            'Ako je aktivirinao, različiti pregledi (kontrolna tabla, zaključavanje, redovi) će se automatski osvežiti posle zadatog vremena.',
        'If you\'re going to be out of office, you may wish to let other users know by setting the exact dates of your absence.' =>
            'Ukoliko ćete biti van kancelarije, možda ćete želeti da obavestite druge korisnike postavljanjem tačnih datuma vašeg izostanka.',
        'Import appointments screen.' => 'Ekran za uvoz termina.',
        'Incoming Phone Call.' => 'Dolazni poziv.',
        'Indonesian' => 'Indonežanski',
        'Inline' => 'Neposredno',
        'Input' => 'Unos',
        'Interface language' => 'Jezik interfejsa',
        'Internal' => '',
        'Internal communication channel.' => 'Interni komunikacioni kanal.',
        'International Workers\' Day' => 'Međunarodni praznik rada',
        'It was not possible to check the PGP signature, this may be caused by a missing public key or an unsupported algorithm.' =>
            '',
        'Italian' => 'Italijanski',
        'Ivory' => 'Slonovača',
        'Ivory (Slim)' => 'Slonovača (uprošćeno)',
        'Japanese' => 'Japanski',
        'Korean' => 'Korejski',
        'Language' => 'Jezik',
        'Large' => 'Veliko',
        'Last Mentions' => '',
        'Last Screen Overview' => 'Pregled poslednjeg ekrana',
        'Last customer subject' => 'Poslednji predmet poruke klijenta',
        'Last view - limit' => '',
        'Last view - position' => '',
        'Last view - types' => '',
        'Lastname Firstname' => 'Prezime, Ime',
        'Lastname Firstname (UserLogin)' => 'Prezime, Ime (Korisničko ime)',
        'Lastname, Firstname' => 'Prezime, Ime',
        'Lastname, Firstname (UserLogin)' => 'Prezime, Ime (Korisničko ime)',
        'LastnameFirstname' => 'PrezimeIme',
        'Latvian' => 'Letonski',
        'Link Object' => 'Poveži objekat',
        'Link Object.' => 'Poveži objekat.',
        'Link agents to groups.' => 'Poveži operatere sa gupama.',
        'Link agents to roles.' => 'Poveži operatere sa ulogama.',
        'Link customer users to customers.' => 'Poveži klijent korisnike sa klijentima.',
        'Link customer users to groups.' => 'Poveđu klijent korisnike sa grupama.',
        'Link customer users to services.' => 'Poveži klijent korisnike sa servisima.',
        'Link customers to groups.' => 'Poveži klijente sa grupama.',
        'Link queues to auto responses.' => 'Poveži redove sa automatskim odgovorima.',
        'Link roles to groups.' => 'Poveži uloge sa grupama.',
        'Link templates to attachments.' => 'Povezivanje šablona sa prilozima.',
        'Link templates to queues.' => 'Poveži šablone sa redovima',
        'Link this ticket to other objects' => 'Uveži ovaj tiket sa drugim objektom',
        'List view' => 'Pregled liste',
        'Lithuanian' => 'Litvanski',
        'Lock / unlock this ticket' => 'Zaključaj / otključaj ovaj tiket',
        'Locked Tickets' => 'Zaključani tiketi',
        'Locked Tickets.' => 'Zaključani tiketi.',
        'Locked ticket.' => 'Zaključan tiket.',
        'Logged in users.' => 'Prijavljeni korisnici.',
        'Logged-In Users' => 'Prijavljeni korisnici',
        'Logout of customer panel.' => 'Odjava sa klijentskog panela.',
        'Look into a ticket!' => 'Pogledaj sadržaj tiketa!',
        'Loop protection: no auto-response sent to "%s".' => 'Zaštita od petlje: bez automatskog odgovora na "%s".',
        'Macedonian' => 'Makedonski',
        'Mail Accounts' => 'Imejl nalozi',
        'Malay' => 'Malajski',
        'Manage Customer User-Customer Relations.' => '',
        'Manage OAuth2 tokens and their configurations.' => '',
        'Manage OTRS Group cloud services.' => 'Upravlja uslugama u oblaku OTRS grupe.',
        'Manage PGP keys for email encryption.' => 'Upravlja PGP ključevima za imejl šifrovanje.',
        'Manage POP3 or IMAP accounts to fetch email from.' => 'Upravljanje POP3 ili IMAP nalozima za preuzimanje email-a od.',
        'Manage S/MIME certificates for email encryption.' => 'Upravljaj S/MIME sertifikatima za imej enkripciju.',
        'Manage System Configuration Deployments.' => 'Upravljanje rasporedima sistemske konfiguracije.',
        'Manage different calendars.' => 'Upravljanje različitim kalendarima.',
        'Manage existing sessions.' => 'Upravljanje postojećim sesijama.',
        'Manage support data.' => 'Upravljanje podacima podrške.',
        'Manage system files.' => '',
        'Manage tasks triggered by event or time based execution.' => 'Upravlja zadacima pokrenutim od događaja ili na osnovu vremenskog izvršavanja.',
        'Management of ticket attribute relations.' => '',
        'Mark as Spam!' => 'Označi kao Spam!',
        'Mark this ticket as junk!' => 'Označi ovaj tiket kao besmislen junk!',
        'Mattermost Username' => '',
        'Max. number of articles per page in TicketZoom' => '',
        'Medium' => 'Srednje',
        'Mentioned in article' => '',
        'Mentioned in ticket' => '',
        'Mentions.' => '',
        'Merge this ticket and all articles into another ticket' => 'Spoji ovaj tiket i sve članke u drugi tiket',
        'Merged Ticket (%s/%s) to (%s/%s).' => 'Spojen tiket (%s/%s) u (%s/%s)',
        'Merged Ticket <OTRS_TICKET> to <OTRS_MERGE_TO_TICKET>.' => 'Tiket <OTRS_TICKET> spojen u <OTRS_MERGE_TO_TICKET>.',
        'Minute' => 'Minut',
        'Miscellaneous' => 'Razno',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' =>
            'Modul za filtriranje i rukovanje dolaznim porukama. Uzmite broj sa 4 cifre za slobodni tekst tiketa, upotrebite regularni izraz za poklapanje, npr Od: => \'(.+?)@.+?\', i upotrebite () kao [***] u Postavi =>.',
        'Multiselect' => 'Višestruki izbor',
        'My Queues' => 'Moji redovi',
        'My Services' => 'Moje usluge',
        'My Tickets.' => 'Moji tiketi.',
        'My last changed tickets' => '',
        'NameX' => 'NameX',
        'New Ticket' => 'Novi tiket',
        'New Tickets' => 'Novi tiketi',
        'New Window' => 'Novi prozor',
        'New Year\'s Day' => 'Nova godina',
        'New Year\'s Eve' => 'Doček nove godine',
        'New process ticket' => 'Novi tiket procesa',
        'News' => '',
        'News about OTRS releases!' => 'Vesti o OTRS izdanjima!',
        'No public key found.' => '',
        'No valid OpenPGP data found.' => '',
        'None' => 'Ni jedan',
        'Norwegian' => 'Norveški',
        'Notification Settings' => 'Podešavanja obaveštenja',
        'Notified about response time escalation.' => 'Obaveštenje o eskalaciji vremena odgovora.',
        'Notified about solution time escalation.' => 'Obaveštenje o eskalaciji vremena rešavanja.',
        'Notified about update time escalation.' => 'Obaveštenje o eskalaciji vremena ažuriranja.',
        'Number of displayed tickets' => 'Broj prikazanih tiketa',
        'OAuth2' => '',
        'OAuth2 token' => '',
        'OTRS Group Services' => 'Servisi OTRS grupe',
        'Open an external link!' => 'Otvori eksternu vezu!',
        'Open tickets (customer user)' => 'Otvoreni tiketi (klijent korisnik)',
        'Open tickets (customer)' => 'Otvoreni tiketi (klijent)',
        'Option' => 'Opcija',
        'Other Customers' => 'Drugi klijenti',
        'Out Of Office' => 'Van kancelarije',
        'Out Of Office Time' => 'Vreme van kancelarije',
        'Out of Office users.' => 'Korisnici van kancelarije.',
        'Overview Escalated Tickets.' => 'Pregled eskaliranih tiketa.',
        'Overview Refresh Time' => 'Pregled vremena osvežavanja',
        'Overview of all Tickets per assigned Queue.' => 'Pregled svih tiketa po dodeljenim redovima.',
        'Overview of all appointments.' => 'Pregled svih termina.',
        'Overview of all escalated tickets.' => 'Pregled svih eskaliranih tiketa.',
        'Overview of all open Tickets.' => 'Pregled svih otvorenih tiketa.',
        'Overview of all open tickets.' => 'Pregled svih otvorenih tiketa.',
        'Overview of customer tickets.' => 'Pregled klijentskih tiketa.',
        'PGP Key' => 'PGP ključ',
        'PGP Key Management' => 'Upravljanje PGP ključem',
        'PGP Keys' => 'PGP ključevi',
        'Parent' => 'Parent',
        'ParentChild' => 'ParentChild',
        'Pending time' => 'Vreme čekanja',
        'People' => 'Osobe',
        'Persian' => 'Persijski',
        'Phone Call Inbound' => 'Dolazni poziv',
        'Phone Call Outbound' => 'Odlazni poziv',
        'Phone Call.' => 'Poziv.',
        'Phone call' => 'Poziv',
        'Phone communication channel.' => 'Komunikacioni kanal poziva.',
        'Phone-Ticket' => 'Tiket poziva',
        'Picture Upload' => 'Otpremanje slike',
        'Picture upload module.' => 'Modul za otpremanje slike.',
        'Picture-Upload' => 'Otpremanje slike',
        'Plugin search' => 'Modul pretrage',
        'Plugin search module for autocomplete.' => 'Modul pretrage za automatsko dopunjavanje.',
        'Polish' => 'Poljski',
        'Portuguese' => 'Portugalski',
        'Portuguese (Brasil)' => 'Portugalski (Brazil)',
        'PostMaster Filters' => 'PostMaster filteri',
        'Print this ticket' => 'Odštampaj ovaj tiket',
        'Priorities' => 'Prioriteti',
        'Process Management Activity Dialog GUI' => 'Grafički interfejs dijaloga aktivnosti u procesima',
        'Process Management Activity GUI' => 'Grafički interfejs aktivnosti u procesima',
        'Process Management Path GUI' => 'Grafički interfejs putanje u procesima',
        'Process Management Transition Action GUI' => 'Grafički interfejs tranzicione akcije u procesima',
        'Process Management Transition GUI' => 'Grafički interfejs tranzicije u procesima',
        'Process Ticket.' => 'Proces tiket.',
        'ProcessID' => 'ID procesa',
        'Processes & Automation' => 'Procesi & automatizacija',
        'Product News' => 'Novosti o proizvodu',
        'Provides a matrix overview of the tickets per state per queue' =>
            'Prikazuje matricu pregleda tiketa po njihovom stanju po redovima',
        'Provides customer users access to tickets even if the tickets are not assigned to a customer user of the same customer ID(s), based on permission groups.' =>
            'Dozvoljava pristup klijent korisnicima tiketima čak iako tiketi nemaju dodeljenog klijent korisnika istog klijenta, a na osnovu grupnih dozvola.',
        'Public Calendar' => 'Javni kalendar',
        'Public calendar.' => 'Javni kalendar.',
        'Queue view' => 'Pregled reda',
        'Refresh interval' => 'Interval osvežavanja',
        'Reminder Tickets' => 'Tiketi podsetnika',
        'Removed subscription for user "%s".' => 'Pretplata za korisnika "%s" je isključena.',
        'Reports' => 'Izveštaji',
        'Resend Ticket Email.' => 'Pošalji ponovo imejl.',
        'Resent email to "%s".' => 'Ponovo poslat imejl na "%s".',
        'Responsible Tickets' => 'Odgovorni tiketi',
        'Responsible Tickets.' => 'Odgovorni tiketi.',
        'Right' => 'Desno',
        'Romanian' => 'Rumunski',
        'Running Process Tickets' => 'Aktivni proces tiketi',
        'Russian' => 'Ruski',
        'S/MIME Certificates' => 'S/MIME sertifikati',
        'SMS' => 'SMS',
        'Schedule a maintenance period.' => 'Planiranje perioda održavanja.',
        'Screen after new ticket' => 'Prikaz ekrana posle otvaranja novog tiketa',
        'Search Customer' => 'Traži klijenta',
        'Search Ticket.' => 'Traži tiket.',
        'Search Tickets.' => 'Pretraži tikete.',
        'Search User' => 'Traži korisnika',
        'Search.' => 'Pretraga.',
        'Second Christmas Day' => 'Drugi dan Božića',
        'Second Queue' => 'Drugi Red',
        'Seconds' => '',
        'Select after which period ticket overviews should refresh automatically.' =>
            'Izaberite posle kog perioda će pregledi tiketa biti automatski osveženi.',
        'Select how many last views should be shown.' => '',
        'Select how many tickets should be shown in overviews by default.' =>
            'Izaberite koji broj tiketa će biti podrazumevano prikazan u pregledima.',
        'Select the main interface language.' => 'Izaberite glavni jezik interfejsa.',
        'Select the maximum articles per page shown in TicketZoom. System default value will apply when entered empty value.' =>
            '',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' =>
            'Izaberite separator koji će se koristi u CSV datotekama (statistika i pretrage). Ako ovde ne izaberete separator, koristiće se podrazumevani separator za vaš jezik',
        'Select where to display the last views.' => '',
        'Select which types should be displayed.' => '',
        'Select your frontend Theme.' => 'Izaberite temu interfejsa.',
        'Select your personal time zone. All times will be displayed relative to this time zone.' =>
            'Izaberite vašu ličnu vremensku zonu. Sva vremena će biti prikazana u njoj.',
        'Select your preferred layout for the software.' => 'Izaberite izgled aplikacije po vašoj želji.',
        'Select your preferred theme for OTRS.' => 'Izaberite temu za OTRS po vašoj želji.',
        'Send a unit test file' => '',
        'Send new outgoing mail from this ticket' => 'Pošalji novi odlazni imejl iz ovog tiketa',
        'Send notifications to users.' => 'Pošalji obaveštenja korisnicima.',
        'Sent "%s" notification to "%s" via "%s".' => 'Poslato obaveštenje "%s" na "%s" preko "%s".',
        'Sent auto follow-up to "%s".' => 'Poslat automatski nastavak na "%s".',
        'Sent auto reject to "%s".' => 'Poslato automatsko odbijanje na "%s".',
        'Sent auto reply to "%s".' => 'Poslat automatski odgovor na "%s".',
        'Sent email to "%s".' => 'Poslat imejl na "%s".',
        'Sent email to customer.' => 'Poslat imejl klijentu.',
        'Sent notification to "%s".' => 'Poslato obaveštenje na "%s".',
        'Serbian Cyrillic' => 'Srpski ćirilica',
        'Serbian Latin' => 'Srpski latinica',
        'Service view' => 'Pregled usluge',
        'ServiceView' => 'ServiceView',
        'Set a new password by filling in your current password and a new one.' =>
            'Podesite novu lozinku ukucavanjem vaše trenutne i nove.',
        'Set sender email addresses for this system.' => 'Podesi sistemsku adresu pošiljaoca.',
        'Set this ticket to pending' => 'Postavi ovaj tiket u status čekanja',
        'Shared Secret' => 'Deljena tajna',
        'Show the history for this ticket' => 'Prikaži istorijat za ovaj tiket',
        'Show the ticket history' => 'Prikaži istoriju tiketa',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' =>
            'Prikazuje pregleda tiketa (Info klijenta => 1 - pokazuje i podatke o klijentu, Maksimalna veličina prikaza podataka o klijentu u karakterima).',
        'Shows information on how to start OTRS Daemon' => 'Prikazuje informacije kako pokrenuti OTRS sistemski servis',
        'Shows last mention of tickets.' => '',
        'Signature data.' => '',
        'Simple' => 'Jednostavno',
        'Skin' => 'Izgled',
        'Slovak' => 'Slovački',
        'Slovenian' => 'Slovenački',
        'Small' => 'Malo',
        'Snippet' => '',
        'Software Package Manager.' => 'Upravljanje programskim paketima.',
        'Solution time' => 'Vreme rešavanja',
        'SolutionDiffInMin' => 'SolutionDiffInMin',
        'SolutionInMin' => 'SolutionInMin',
        'Some description!' => 'Neki opis!',
        'Some picture description!' => 'Neki opis slike!',
        'Spam' => 'Spam',
        'Spanish' => 'Španski',
        'Spanish (Colombia)' => 'Španski (Kolumbija)',
        'Spanish (Mexico)' => 'Španski (Meksiko)',
        'Stable' => ' Stabilno',
        'Started response time escalation.' => 'Započeta eskalacija vremena odgovora.',
        'Started solution time escalation.' => 'Započeta eskalacija vremena rešavanja.',
        'Started update time escalation.' => 'Započeta eskalacija vremena ažuriranja.',
        'Stat#' => 'Statistika#',
        'States' => 'Stanja',
        'Statistics overview.' => 'Pregled statistika.',
        'Status view' => 'Pregled statusa',
        'Stopped response time escalation.' => 'Obustavljena eskalacija vremena odgovora.',
        'Stopped solution time escalation.' => 'Obustavljena eskalacija vremena rešavanja.',
        'Stopped update time escalation.' => 'Započeta eskalacija vremena ažuriranja.',
        'Support Agent' => 'Operater podrške',
        'Swahili' => 'Svahili',
        'Swedish' => 'Švedski',
        'System Address Display Name' => 'Naziv za prikaz sistemske adrese',
        'System Configuration Deployment' => 'Raspoređivanje sistemske konfiguracije',
        'System Configuration Group' => 'Kategorija sistemske konfiguracije',
        'System Maintenance' => 'Održavanje sistema',
        'Textarea' => 'Oblast teksta',
        'Thai' => 'Tajlandski',
        'The PGP signature is expired.' => '',
        'The PGP signature was made by a revoked key, this could mean that the signature is forged.' =>
            '',
        'The PGP signature was made by an expired key.' => '',
        'The PGP signature with the keyid has not been verified successfully.' =>
            '',
        'The PGP signature with the keyid is good.' => '',
        'The secret you supplied is invalid. The secret must only contain letters (A-Z, uppercase) and numbers (2-7) and must consist of 16 characters.' =>
            'Tajna koju ste uneli je nevažeća. Tajna mora sadržati samo velika slova (A-Z) i cifre (2-7) i mora imati tačno 16 karaktera.',
        'The value of the From field' => 'Vrednost From polja',
        'Theme' => 'Tema',
        'This is a Description for Comment on Framework.' => 'Ovo je opis za komentar u sistemu.',
        'This is a Description for DynamicField on Framework.' => 'Ovo je opis za dinamičko polje u sistemu.',
        'This is the default orange - black skin for the customer interface.' =>
            'Ovo je podrazumevani narandžasto-crni izgled klijentskog interfejsa.',
        'This is the default orange - black skin.' => 'Ovo je podrazumevani narandžasto-crni izgled.',
        'This key is not certified with a trusted signature!' => '',
        'This module is part of the admin area of OTRS.' => 'Ovaj modul je deo OTRS administrativnog prostora.',
        'This will allow the system to send text messages via SMS.' => 'Ovo će dozvoliti sistemu da šalje tekstualne poruke preko SMS.',
        'Ticket Close.' => 'Zatvaranje tiketa.',
        'Ticket Compose Bounce Email.' => 'Preusmeravanje imejl poruke u tiketu.',
        'Ticket Compose email Answer.' => 'Pisanje imejl poruke u tiketu.',
        'Ticket Customer.' => 'Korisnik tiketa.',
        'Ticket Forward Email.' => 'Prosleđivanje imejl poruke u tiketu.',
        'Ticket FreeText.' => 'Slobodni tekst tiketa.',
        'Ticket History.' => 'Istorijat tiketa.',
        'Ticket Lock.' => 'Zaključavanje tiketa',
        'Ticket Merge.' => 'Spajanje tiketa.',
        'Ticket Move.' => 'Pomeranje tiketa.',
        'Ticket Note.' => 'Napomena tiketa.',
        'Ticket Notifications' => 'Obaveštenja o tiketu',
        'Ticket Outbound Email.' => 'Slanje odlazne imejl poruke u tiketu.',
        'Ticket Overview "Medium" Limit' => 'Ograničenje pregleda tiketa "srednje"',
        'Ticket Overview "Preview" Limit' => 'Ograničenje pregleda tiketa "prikaz"',
        'Ticket Overview "Small" Limit' => 'Ograničenje pregleda tiketa "malo"',
        'Ticket Owner.' => 'Vlasnik tiketa.',
        'Ticket Pending.' => 'Postavljanje tiketa u čekanje.',
        'Ticket Print.' => 'Štampa tiketa.',
        'Ticket Priority.' => 'Prioritet tiketa.',
        'Ticket Queue Overview' => 'Pregled reda tiketa',
        'Ticket Responsible.' => 'Odgovoran za tiket.',
        'Ticket Watcher' => 'Praćenje tiketa.',
        'Ticket Zoom' => 'Detalji tiketa',
        'Ticket Zoom.' => 'Detalji tiketa.',
        'Ticket bulk module.' => 'Modul masovne akcije na tiketima.',
        'Ticket creation' => '',
        'Ticket limit per page for Ticket Overview "Medium".' => 'Ograničenje tiketa po strani za pregled tipa "srednje".',
        'Ticket limit per page for Ticket Overview "Preview".' => 'Ograničenje tiketa po strani za pregled tipa "prikaz".',
        'Ticket limit per page for Ticket Overview "Small".' => 'Ograničenje tiketa po strani za pregled tipa "malo".',
        'Ticket notifications' => 'Obaveštenja o tiketu',
        'Ticket overview' => 'Pregled tiketa',
        'Ticket plain view of an email.' => 'Prikaz neformatirane imejl poruke u tiketu.',
        'Ticket split dialog.' => 'Dijalog za podelu tiketa.',
        'Ticket title' => 'Naslov tiketa',
        'Ticket zoom view.' => 'Detaljni pregled tiketa.',
        'TicketNumber' => 'Broj tiketa',
        'Tickets.' => 'Tiketi.',
        'To accept login information, such as an EULA or license.' => 'Prihvatanje informacija prilikom prijavljivanja, npr. EULA izjava ili licenca.',
        'To download attachments.' => 'Za preuzimanje priloga.',
        'To view HTML attachments.' => 'Za pregled HTML priloga.',
        'Tree view' => 'Prikaz u obliku stabla',
        'Turkish' => 'Turski',
        'Tweak the system as you wish.' => 'Prilagodite sistem svojim potrebama.',
        'Ukrainian' => 'Ukrajinski',
        'Unlocked ticket.' => 'Otključano',
        'Up' => 'Gore',
        'Upcoming Events' => 'Predstojeći događaji',
        'Update time' => 'Vreme ažuriranja',
        'Upload your PGP key.' => 'Pošaljite svoj PGP ključ.',
        'Upload your S/MIME certificate.' => 'Pošaljite vaš S/MIME sertifikat.',
        'User Profile' => 'Korisnički profil',
        'UserFirstname' => 'Ime korisnika',
        'UserLastname' => 'Prezime korisnika',
        'Users, Groups & Roles' => 'Operateri, grupe & uloge',
        'Vietnam' => 'Vijetnamski',
        'View performance benchmark results.' => 'Pregled rezultata provere performansi.',
        'Watch this ticket' => 'Nadgledaj ovaj tiket',
        'Watched Tickets' => 'Posmatrani tiket',
        'Watched Tickets.' => 'Nadgledani tiketi.',
        'We are performing scheduled maintenance.' => 'Izvršavamo planirano održavanje.',
        'We are performing scheduled maintenance. Login is temporarily not available.' =>
            'Izvršavamo planirano održavanje. Prijava privremeno nije moguća.',
        'We are performing scheduled maintenance. We should be back online shortly.' =>
            'Izvršavamo planirano održavanje. uskoro ćemo biti ponovo aktivni.',
        'Web Services' => 'Veb servisi',
        'Web service (Dropdown)' => '',
        'Web service (Multiselect)' => '',
        'Web service dynamic field AJAX interface' => '',
        'Webservice' => '',
        'Yes, but hide archived tickets' => 'Da, ali skloni arhivirane tikete',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' =>
            'Vaš imejl sa brojem tiketa "<OTRS_TICKET>" je preusmeren na tiket "<OTRS_BOUNCE_TO>"!',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' =>
            'Vaš imejl sa brojem tiketa "<OTRS_TICKET>" je pripojen tiketu "<OTRS_MERGE_TO_TICKET>"!',
        'Your queue selection of your preferred queues. You also get notified about those queues via email if enabled.' =>
            'Izbor redova po vašoj želji. Ukoliko je uključeno, dobijaćete i obaveštenja o ovim redovima putem imejla.',
        'Your service selection of your preferred services. You also get notified about those services via email if enabled.' =>
            'Izbor usluga po vašoj želji. Ukoliko je uključeno, dobijaćete i obaveštenja o ovim uslugama putem imejla.',
        'Your username in Mattermost without the leading @' => '',
        'Znuny.org - News' => '',
        'Zoom' => 'Uvećaj',
        'all tickets' => '',
        'archived tickets' => '',
        'attachment' => 'prilog',
        'bounce' => 'preusmeri',
        'compose' => 'sastavi',
        'debug' => 'otklanjanje neispravnosti',
        'error' => 'greška',
        'forward' => 'prosledi',
        'info' => 'info',
        'inline' => 'neposredno',
        'normal' => 'normalan',
        'not archived tickets' => '',
        'notice' => 'napomena',
        'pending' => 'na čekanju',
        'phone' => 'poziv',
        'responsible' => 'odgovornost',
        'reverse' => 'obrnuto',
        'stats' => 'statistika',

    };

    $Self->{JavaScriptStrings} = [
        ' ...and %s more',
        ' ...show less',
        '%s B',
        '%s GB',
        '%s KB',
        '%s MB',
        '%s TB',
        '+%s more',
        'A key with this name (\'%s\') already exists.',
        'A package upgrade was recently finished. Click here to see the results.',
        'A popup of this screen is already open. Do you want to close it and load this one instead?',
        'A preview of this website can\'t be provided because it didn\'t allow to be embedded.',
        'Add',
        'Add Event Trigger',
        'Add all',
        'Add entry',
        'Add key',
        'Add new draft',
        'Add new entry',
        'Add to favourites',
        'Agent',
        'All occurrences',
        'All-day',
        'An Error Occurred',
        'An error occurred during communication.',
        'An error occurred! Please check the browser error log for more details!',
        'An item with this name is already present.',
        'An unconnected transition is already placed on the canvas. Please connect this transition first before placing another transition.',
        'An unknown error occurred when deleting the attachment. Please try again. If the error persists, please contact your system administrator.',
        'An unknown error occurred. Please contact the administrator.',
        'Apply',
        'Appointment',
        'Apr',
        'April',
        'Are you sure you want to delete this appointment? This operation cannot be undone.',
        'Are you sure you want to overwrite the config parameters?',
        'Are you sure you want to update all installed packages?',
        'Are you using a browser plugin like AdBlock or AdBlockPlus? This can cause several issues and we highly recommend you to add an exception for this domain.',
        'Article display',
        'Article filter',
        'As soon as you use this button or link, you will leave this screen and its current state will be saved automatically. Do you want to continue?',
        'Ascending sort applied, ',
        'Attachment was deleted successfully.',
        'Attachments',
        'Aug',
        'August',
        'Available space %s of %s.',
        'Basic information',
        'By restoring this deployment all settings will be reverted to the value they had at the time of the deployment. Do you really want to continue?',
        'Calendar',
        'Cancel',
        'Cannot proceed',
        'Clear',
        'Clear all',
        'Clear debug log',
        'Clear search',
        'Click to delete this attachment.',
        'Click to select a file for upload.',
        'Click to select a file or just drop it here.',
        'Click to select files or just drop them here.',
        'Clone web service',
        'Close preview',
        'Close this dialog',
        'Complex %s with %s arguments',
        'Confirm',
        'Could not open popup window. Please disable any popup blockers for this application.',
        'Current selection',
        'Currently not possible',
        'Customer interface does not support articles not visible for customers.',
        'Date/Time',
        'Day',
        'Dec',
        'December',
        'Delete',
        'Delete Entity',
        'Delete conditions',
        'Delete draft',
        'Delete error handling module',
        'Delete field',
        'Delete invoker',
        'Delete operation',
        'Delete this Attachment',
        'Delete this Event Trigger',
        'Delete this Invoker',
        'Delete this Key Mapping',
        'Delete this Mail Account',
        'Delete this Operation',
        'Delete this PostMasterFilter',
        'Delete this Template',
        'Delete web service',
        'Deleting attachment...',
        'Deleting the field and its data. This may take a while...',
        'Deleting the mail account and its data. This may take a while...',
        'Deleting the postmaster filter and its data. This may take a while...',
        'Deleting the template and its data. This may take a while...',
        'Deploy',
        'Deploy now',
        'Deploying, please wait...',
        'Deployment comment...',
        'Deployment successful. You\'re being redirected...',
        'Descending sort applied, ',
        'Description',
        'Dismiss',
        'Do not show this warning again.',
        'Do you really want to continue?',
        'Do you really want to delete "%s"?',
        'Do you really want to delete this certificate?',
        'Do you really want to delete this dynamic field? ALL associated data will be LOST!',
        'Do you really want to delete this generic agent job?',
        'Do you really want to delete this key?',
        'Do you really want to delete this link?',
        'Do you really want to delete this notification language?',
        'Do you really want to delete this notification?',
        'Do you really want to delete this scheduled system maintenance?',
        'Do you really want to delete this statistic?',
        'Do you really want to delete this token and its configuration?',
        'Do you really want to reset this setting to it\'s default value?',
        'Do you really want to revert this setting to its historical value?',
        'Don\'t save, update manually',
        'Draft title',
        'Duplicate event.',
        'Duplicated entry',
        'Edit Field Details',
        'Edit this setting',
        'Edit this transition',
        'End date',
        'Error',
        'Error during AJAX communication',
        'Error during AJAX communication. Status: %s, Error: %s',
        'Error in the mail settings. Please correct and try again.',
        'Error: Browser Check failed!',
        'Event Type Filter',
        'Expanded',
        'Feb',
        'February',
        'Filters',
        'Find out more',
        'Finished',
        'First select a customer user, then select a customer ID to assign to this ticket.',
        'Fr',
        'Fri',
        'Friday',
        'Generate',
        'Generate Result',
        'Generating...',
        'Grouped',
        'Help',
        'Hide EntityIDs',
        'If you now leave this page, all open popup windows will be closed, too!',
        'Import web service',
        'Information about the OTRS Daemon',
        'Invalid date (need a future date)!',
        'Invalid date (need a past date)!',
        'Invalid date!',
        'It is going to be deleted from the field, please try again.',
        'It is not possible to add a new event trigger because the event is not set.',
        'It is not possible to set this entry to invalid. All affected configuration settings have to be changed beforehand.',
        'It was not possible to delete this draft.',
        'It was not possible to generate the Support Bundle.',
        'Jan',
        'January',
        'Jul',
        'July',
        'Jump',
        'Jun',
        'June',
        'Just this occurrence',
        'Keys with values can\'t be renamed. Please remove this key/value pair instead and re-add it afterwards.',
        'Less',
        'Loading, please wait...',
        'Loading...',
        'Location',
        'Mail check successful.',
        'Mapping for Key',
        'Mapping for Key %s',
        'Mar',
        'March',
        'May',
        'May_long',
        'Mo',
        'Mon',
        'Monday',
        'Month',
        'More',
        'Name',
        'Namespace %s could not be initialized, because %s could not be found.',
        'Next',
        'No Data Available.',
        'No TransitionActions assigned.',
        'No data found.',
        'No dialogs assigned yet. Just pick an activity dialog from the list on the left and drag it here.',
        'No matches found.',
        'No package information available.',
        'No response from get package upgrade result.',
        'No response from get package upgrade run status.',
        'No response from package upgrade all.',
        'No sort applied, ',
        'No space left for the following files: %s',
        'Not available',
        'Notice',
        'Notification',
        'Nov',
        'November',
        'OK',
        'Oct',
        'October',
        'One or more errors occurred!',
        'Open URL in new tab',
        'Open date selection',
        'Open this node in a new window',
        'Please add values for all keys before saving the setting.',
        'Please check the fields marked as red for valid inputs.',
        'Please either turn some off first or increase the limit in configuration.',
        'Please enter at least one search value or * to find anything.',
        'Please enter at least one search word to find anything.',
        'Please note that at least one of the settings you have changed requires a page reload. Click here to reload the current screen.',
        'Please only select at most %s files for upload.',
        'Please only select one file for upload.',
        'Please remove the following words from your search as they cannot be searched for:',
        'Please see the documentation or ask your admin for further information.',
        'Please turn off Compatibility Mode in Internet Explorer!',
        'Please wait...',
        'Preparing to deploy, please wait...',
        'Press Ctrl+C (Cmd+C) to copy to clipboard',
        'Previous',
        'Process state',
        'Queues',
        'Reload page',
        'Reload page (%ss)',
        'Remove',
        'Remove Entity from canvas',
        'Remove active filters for this widget.',
        'Remove all user changes.',
        'Remove from favourites',
        'Remove selection',
        'Remove the Transition from this Process',
        'Remove the filter',
        'Remove this dynamic field',
        'Remove this entry',
        'Repeat',
        'Request Details',
        'Request Details for Communication ID',
        'Reset',
        'Reset globally',
        'Reset locally',
        'Reset option is required!',
        'Reset options',
        'Reset setting',
        'Reset setting on global level.',
        'Resource',
        'Resources',
        'Restore default settings',
        'Restore web service configuration',
        'Rule',
        'Running',
        'Sa',
        'Sat',
        'Saturday',
        'Save',
        'Save and update automatically',
        'Scale preview content',
        'Search',
        'Search attributes',
        'Search the System Configuration',
        'Searching for linkable objects. This may take a while...',
        'Select a customer ID to assign to this ticket',
        'Select a customer ID to assign to this ticket.',
        'Select all',
        'Sending Update...',
        'Sep',
        'September',
        'Setting a template will overwrite any text or attachment.',
        'Settings',
        'Show',
        'Show EntityIDs',
        'Show current selection',
        'Show or hide the content.',
        'Slide the navigation bar',
        'Sorry, but you can\'t disable all methods for notifications marked as mandatory.',
        'Sorry, but you can\'t disable all methods for this notification.',
        'Sorry, the only existing condition can\'t be removed.',
        'Sorry, the only existing field can\'t be removed.',
        'Sorry, the only existing parameter can\'t be removed.',
        'Sorry, you can only upload %s files.',
        'Sorry, you can only upload one file here.',
        'Split',
        'Stacked',
        'Start date',
        'Status',
        'Stream',
        'Su',
        'Sun',
        'Sunday',
        'Support Bundle',
        'Support Data information was successfully sent.',
        'Switch to desktop mode',
        'Switch to mobile mode',
        'Team',
        'Th',
        'The browser you are using is too old.',
        'The deployment is already running.',
        'The following files are not allowed to be uploaded: %s',
        'The following files exceed the maximum allowed size per file of %s and were not uploaded: %s',
        'The following files were already uploaded and have not been uploaded again: %s',
        'The item you\'re currently viewing is part of a not-yet-deployed configuration setting, which makes it impossible to edit it in its current state. Please wait until the setting has been deployed. If you\'re unsure what to do next, please contact your system administrator.',
        'The key must not be empty.',
        'The names of the following files exceed the maximum allowed length of %s characters and were not uploaded: %s',
        'There are currently no elements available to select from.',
        'There are no more drafts available.',
        'There is a package upgrade process running, click here to see status information about the upgrade progress.',
        'There was an error deleting the attachment. Please check the logs for more information.',
        'There was an error. Please save all settings you are editing and check the logs for more information.',
        'This Activity cannot be deleted because it is the Start Activity.',
        'This Activity is already used in the Process. You cannot add it twice!',
        'This Transition is already used for this Activity. You cannot use it twice!',
        'This TransitionAction is already used in this Path. You cannot use it twice!',
        'This address already exists on the address list.',
        'This element has children elements and can currently not be removed.',
        'This event is already attached to the job, Please use a different one.',
        'This feature is part of the %s. Please contact us at %s for an upgrade.',
        'This field can have no more than 250 characters.',
        'This field is required.',
        'This is %s',
        'This is a repeating appointment',
        'This is currently disabled because of an ongoing package upgrade.',
        'This item still contains sub items. Are you sure you want to remove this item including its sub items?',
        'This option is currently disabled because the OTRS Daemon is not running.',
        'This software runs with a huge lists of browsers, please upgrade to one of these.',
        'This window must be called from compose window.',
        'Thu',
        'Thursday',
        'Timeline Day',
        'Timeline Month',
        'Timeline Week',
        'Title',
        'Today',
        'Too many active calendars',
        'Try again',
        'Tu',
        'Tue',
        'Tuesday',
        'Unfortunately deploying is currently not possible, maybe because another agent is already deploying. Please try again later.',
        'Unknown',
        'Unlock setting.',
        'Update All Packages',
        'Update Result',
        'Update all packages',
        'Update manually',
        'Upload information',
        'Uploading...',
        'Use options below to narrow down for which tickets appointments will be automatically created.',
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.',
        'Warning',
        'Was not possible to send Support Data information.',
        'We',
        'Wed',
        'Wednesday',
        'Week',
        'Would you like to edit just this occurrence or all occurrences?',
        'Yes',
        'You can either have the affected settings updated automatically to reflect the changes you just made or do it on your own by pressing \'update manually\'.',
        'You can use the category selection to limit the navigation tree below to entries from the selected category. As soon as you select the category, the tree will be re-built.',
        'You have undeployed settings, would you like to deploy them?',
        'activate to apply a descending sort',
        'activate to apply an ascending sort',
        'activate to remove the sort',
        'and %s more...',
        'day',
        'month',
        'more',
        'no',
        'none',
        'or',
        'sorting is disabled',
        'user(s) have modified this setting.',
        'week',
        'yes',
    ];

    # $$STOP$$
    return;
}

1;
