# Contributing / How to contribute

Thank you so much for your interest in contributing!
We welcome all types of participation. Whether it is programming, expanding documentation, updating translations or reporting bugs.
If you want to participate, we prepared a list for you how we handle things.
If there are any open questions, you can reach out via:
- Forum
- Discord
- Issues here in this repo


Before you start with your contribution, please have a look at the sections below.
We tried to cover all relevant parts and it should help to make your contribution as smooth
as possible. For you and for us as maintainers.

Have fun!

## How can I:

  * [Report an Issue or Bug](#report-an-error-or-bug)
  * [Request community support](#request-support)
  * [Open a Feature Request](#request-a-feature)
  * [Join the Project Team](#join-the-project-team)
  * [Translate the Software](#translate-the-software)



## How do we:
  * [Provide Support on Issues](#provide-support-on-issues)
  * [Clean Up Issues and PRs](#clean-up-issues-and-prs)


## Where do I find:
  * The developer documentation https://doc.znuny.org/znuny/developer/
  * The documentation in general https://doc.znuny.org/znuny/



## Report an Error or Bug

If you find an error or a bug, please follow this steps

* Open an Issue at https://github.com/znuny/znuny/issues
* Use the template we provide. Please don't delete it.
* Include everything we need to know. Especially how to reproduce the problem.

After you filed the issue:

* A team member will categorize and label the issue.
* We try to reproduce it and we may ask additional questions.
* If we are able to reproduce the issue, we will label it accordingly and try to fix it.

Special Case:
Security issues. If you want to report a security issue, please see the [Security.md](https://github.com/znuny/Znuny/blob/dev/SECURITY.md#how-to-report-a-security-vulnerability)

Note: if you don't reply on questions, we will close the issue after 30 days. This is just a measure to keep our issue list clean.



## Request Support

If you need support / assisitence with your project or just need a helping hand, get in touch:
- [Project website](https://www.znuny.org)
- [Community forum](https://community.znuny.org)
- [Discord server](https://discord.gg/XTud3WWZTs)
- [Commercial services](https://www.znuny.com)

The community is here to help and you can rely on them. If you need immediate help for an incident,
you can also request commercial support.

In any case, please provide as much context as you can. Please keep in mind:
the community members and the team dont know what you want to achieve or what you already tried.

## Request a Feature

If you need a new feature, feel free to follow these steps:

* Open an issue in the [feature request repository](https://github.com/znuny/znuny-feature-requests/issues)
* Please describe your wish as detailed as possible
* Keep in mind that it should be a general feature, not one which is only for your specific usecase
* If similiar features are available, please explain why they won't work for you

After you filed the request:

* A team member will categorize and label the request
* Once a month we discuss feature requests in the team
* If a feature will be implemented it gets an "accepted" label
* If a date for the implementation is set, a version label will be added
* If a request is declined, we close the request


Please note:
We can't accept every feature request. Especially such requests that are limited to a very small fraction of the users. Our job is not only to build cool software, sometimes it requires us to say no.
Please respect that. There is always the of way of using add-ons or customizing to achieve your goal.


## Contribute Code

Before you make a code/feature contribution on your own, please ask our team in advance if this customization is likely to find a place in the project. We may have suggestions to make upfront or give you some more insights.
There is no special "checklist", just post a question and explain what you would like
to contribute. We will get in touch ASAP.
We value your time and respect your work. Thats why we dont want you to waste it on features
we might be working on in the background.


## Provide Support on Issues

We try provide support for free, as good as we can. Thats why we offer so many channels to get help, directly from
the community. We dont have a special team for Open Source support, but we do our best to support you.

The amount of free-support we can deliver is limited.

If you have a general question, the documentation, the forum and the Discord chat should be a good start.
The forum has well build search, which can help in a lot of cases. Before you open a new post, use the search.
There is a good chance that your issue was already discussed before.



## Clean Up Issues and PRs

We will close issues, which are not labeled as bug/verified/critical and haven't been updated in 30 days.
Accepted feature requests will remain open until they are implemented.
Feature requests that we won't implement, will be closed with an explanation.


## Join the Project Team

If you want to join the project, you are welcome!
Just let us know and we can discuss details via Discord.

We need help for:
- Issue tracking and handling / labeling issues
- Code reviews

## Translate the software

To translate missing or incorrect strings, please feel free to create an account in our [Weblate](https://translations.znuny.org/projects/znuny/znuny/). Choose your language, and search for the string to be modified. Provide a suggestion. You can also do this without registering an account, if you desire not to be named.

We look forward to you!
